
#ifndef h_host68k_h
#define h_host68k_h

// passes back into pnolet
extern UInt32 pnobridge_retval;
extern UInt32 pnobridge_mask;
extern UInt8 g_make_package;

// Define the minimum OS version we support (5.0 for now).
#define kOurMinVersion	sysMakeROMVersion(5,0,0,sysROMStageDevelopment,0)
#define kPalmOS10Version	sysMakeROMVersion(1,0,0,sysROMStageRelease,0)

/* VFS stubs
 */
#ifdef __cplusplus
extern "C"
#endif
UInt16 palm_vfs_count ( void );

#ifdef __cplusplus
extern "C"
#endif
UInt16 palm_vfs_iter ( void );

UInt16 palm_game_count ( UInt16 entry, char *r_filename );

/* hardware stubs
 */
#ifdef __cplusplus
extern "C"
#endif
void *hw_query_vram ( void );

#ifdef __cplusplus
extern "C"
#endif
UInt8 hw_set16bpp ( void );

#ifdef __cplusplus
extern "C"
#endif
int update_field ( FormPtr f, int obid, char *newtext );
char *strdup ( char *text );

#ifdef __cplusplus
extern "C"
#endif
UInt32 host_event_handler ( UInt32 arg, UInt32 arg2 );

void * GetObjectPtr ( UInt16 objectID );
void show_pause ( void );

UInt8 is_clie ( void );

/* debug assist
 */
#define DEBUGU8(x) {                                   \
  char buffer [ 200 ];                                 \
  StrPrintF ( buffer, "%u %x", x, x );                 \
  ErrNonFatalDisplay ( buffer ); \
}

#define DEBUGU32(x) {                                  \
  char buffer [ 200 ];                                 \
  StrPrintF ( buffer, "%lu %lx", x, x );               \
  ErrNonFatalDisplay ( buffer ); \
}

#define DEBUGS(s) {                                    \
  ErrNonFatalDisplay ( s );      \
}

#endif
