// -*- mode: c++; tab: 4 -*-

#include <PalmOS.h>
#include <DataMgr.h>
#include <VFSMgr.h>
#include <StringMgr.h>
#include "memhack.h"

#define MAX_FILES 20

#define appCreatorID 'Mmhk'

#define CROSSOVER
#define CROSSOVER_TOP
//#define CROSSOVER_LEFT
//#define CROSSOVER_HALF

#define PREFERENCE_ENABLED 1
#define PREFERENCE_DBARRAY 2 // dbs I made
#define PREFERENCE_CNARRAY 3

#define REG(x) SysNotifyRegister(cn,db,x,NULL,sysNotifyNormalPriority,NULL)
#define UNREG(x) SysNotifyUnregister(cn,db,x,NULL)

static void EventLoop(void);
static Boolean getEnabled();
static void setEnabled(Boolean);
void EnableMemHack();
static Boolean MainEventHandler(EventType *);

static void startfn() {
  RectangleType rect;
  rect.topLeft.x = 0;
  rect.topLeft.y = 0;
  rect.extent.y  = 160;
  rect.extent.x  = 160;
  WinEraseRectangle(&rect, 0);
}

static Err updatfn(UInt32 totalBytes, UInt32 offset, void *ignore) {
  RectangleType rect;
  rect.topLeft.x = 0;
  rect.topLeft.y = 78;
  rect.extent.y  = 4;
  rect.extent.x  = ((offset+1)*160L)/(totalBytes+1);
  WinPaintRectangle(&rect, 1);
  return errNone;
}

static void *getControl() {
  return FrmGetObjectPtr(FrmGetActiveForm(), 
			 FrmGetObjectIndex(FrmGetActiveForm(), btnEnabled));
}

static void foobar() {
  UInt32 done, total;
  short i = 0;
  UInt16  prefcn[MAX_FILES];
  LocalID prefdb[MAX_FILES];
  Char *message;

  i = sizeof(prefcn);
  if (PrefGetAppPreferences(appCreatorID, PREFERENCE_CNARRAY, prefcn,
			    &i, true) == noPreferenceFound || !i)
    return;

  i = sizeof(prefdb);
  if (PrefGetAppPreferences(appCreatorID, PREFERENCE_DBARRAY, prefdb,
			    &i, true) == noPreferenceFound || !i)
    return;

  total = i/sizeof(LocalID);

  startfn();

  message = MemPtrNew(128);
  StrPrintF(message, "Deleting %d Files...", total);
  WinDrawChars(message, StrLen(message), 5, 58);
  MemPtrFree(message);

  for (done = 0; done < total; done++) {
    Err err;
#if 0
    UInt16 props;

    // Dave's suggestion. Crashes all sorts of stuff.
    DmDatabaseInfo(prefcn[i], prefdb[i], NULL, &props, NULL, NULL,
		   NULL, NULL, NULL, NULL, NULL, NULL, NULL);

    props &= ~dmHdrAttrReadOnly;
    
    DmSetDatabaseInfo(prefcn[i], prefdb[i], NULL, &props, NULL, NULL,
		      NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#endif

    updatfn(total-1, done-1, NULL);

    err = DmDeleteDatabase(prefcn[done], prefdb[done]);
  }

  startfn();

  PrefSetAppPreferences(appCreatorID, PREFERENCE_DBARRAY, 0, NULL, 0, true);
  PrefSetAppPreferences(appCreatorID, PREFERENCE_CNARRAY, 0, NULL, 0, true);
}

static void PageInOut(UInt16 cardNo, LocalID dbID) {
  Char *appName = MemPtrNew(256);
  Char *dirName = MemPtrNew(256);
  Char *fileName = MemPtrNew(256);
  UInt32 dirIterator;
  UInt16 volRefNum;
  UInt32 volIterator = vfsIteratorStart;
  UInt16 props;
  Err err;
  short i = 0;
  LocalID dbType;
  UInt16  prefcn[MAX_FILES+1];
  LocalID prefdb[MAX_FILES];

  if (!appName || !dirName || !fileName)
    goto fail;

  err = DmDatabaseInfo (cardNo, dbID, appName, NULL, NULL, NULL, NULL,
			NULL, NULL, NULL, NULL, &dbType, NULL);

  if (err != errNone)
    goto fail;

  if (dbType != sysFileTApplication) 
    goto fail;

  StrPrintF(dirName, "/palm/programs/memhack/%s/", appName);

  while (volIterator != vfsIteratorStop) {
    FileInfoType info;
    FileRef dirRef;
    err = VFSVolumeEnumerate(&volRefNum, &volIterator);
    if (err == errNone) {
      // open the directory first, to get the directory reference
      // volRefNum must have already been defined
      err = VFSFileOpen(volRefNum, dirName, vfsModeRead, &dirRef);
      if(err == errNone) {
	info.nameP = fileName; // point to local buffer
	info.nameBufLen = 256;
	dirIterator = vfsIteratorStart;

	while (dirIterator != vfsIteratorStop) {
	  // Get the next file
	  err = VFSDirEntryEnumerate (dirRef, &dirIterator, &info);
	  if (err == errNone) {
	    if (i >= MAX_FILES)
	      goto fail;

	    startfn();
	    StrPrintF(appName, "Importing %s", fileName);
	    WinDrawChars(appName, StrLen(appName), 5, 58);

	    StrPrintF(appName, "%s%s", dirName, fileName);
	    VFSImportDatabaseFromFileCustom(volRefNum, appName, 
					    &prefcn[i], &prefdb[i],
					    updatfn, NULL);

	    startfn();

#if 0
	    // Dave's suggestion. Crashes all sorts of stuff.
	    DmDatabaseInfo(prefcn[i], prefdb[i], NULL, &props, NULL, NULL,
			   NULL, NULL, NULL, NULL, NULL, NULL, NULL);

	    props |= dmHdrAttrReadOnly;

	    DmSetDatabaseInfo(prefcn[i], prefdb[i], NULL, &props, NULL, NULL,
			      NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#endif

	    i++;
	  } else {
	    goto fail;
	  }
	}
      } else {
	goto fail;
      }
    } else {
      goto fail;
    }
  }  

 fail:
  PrefSetAppPreferences(appCreatorID, PREFERENCE_DBARRAY, 0, 
			prefdb, i*sizeof(LocalID), true);
  PrefSetAppPreferences(appCreatorID, PREFERENCE_CNARRAY, 0, 
			prefcn, i*sizeof(UInt16),  true);

  if (appName)
    MemPtrFree(appName);
  if (dirName)
    MemPtrFree(dirName);
  if (fileName)
    MemPtrFree(fileName);
}

UInt32 PilotMain(UInt16 cmd, MemPtr cmdPBP,
                 UInt16 launchFlags __attribute__ ((unused)))
{
  if(cmd == sysAppLaunchCmdNormalLaunch) {
    UInt32 dwROMVer;

    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &dwROMVer);
    if (sysGetROMVerMajor(dwROMVer) < 5) {
      if(sysGetROMVerMajor(dwROMVer) == 1)
	AppLaunchWithCommand(sysFileCDefaultApp,
			     sysAppLaunchCmdNormalLaunch, NULL);
      return sysErrRomIncompatible;
    }

    FrmGotoForm(frmMain);
    EventLoop();
  }
  else if(cmd == sysAppLaunchCmdSystemReset ||
	  cmd == sysAppLaunchCmdSyncNotify) {
    if (cmd == sysAppLaunchCmdSystemReset) {
      PrefSetAppPreferences(appCreatorID, PREFERENCE_DBARRAY, 0, NULL, 0, true);
      PrefSetAppPreferences(appCreatorID, PREFERENCE_CNARRAY, 0, NULL, 0, true);
    }
    EnableMemHack();
  }
  else if(cmd == sysAppLaunchCmdNotify) {
    SysNotifyParamType *np = (SysNotifyParamType *)cmdPBP;
    SysNotifyAppLaunchOrQuitType *alp =
      (SysNotifyAppLaunchOrQuitType *)np->notifyDetailsP;
    SysNotifyPenStrokeType *psp =
      (SysNotifyPenStrokeType *)np->notifyDetailsP;
    UInt16 numAreas, i;
    const SilkscreenAreaType *Areas = EvtGetSilkscreenAreaList(&numAreas);
    RectangleType rect;

    switch(np->notifyType) {
    case sysNotifyProcessPenStrokeEvent:
#ifdef CROSSOVER
      for (i=0; i<numAreas; i++)
	if (Areas[i].areaType == silkscreenRectGraffiti &&
	    Areas[i].index    == alphaGraffitiSilkscreenArea)
	  break;

      if (i == numAreas)
	break;

#ifdef CROSSOVER_LEFT
      rect.topLeft.x = Areas[i].bounds.topLeft.x;
#else
      rect.topLeft.x = Areas[i].bounds.topLeft.x + 
	(Areas[i].bounds.extent.x >> 1);
#endif /* CROSSOVER_LEFT */
      rect.extent.x  = Areas[i].bounds.extent.x >> 1;

#ifdef CROSSOVER_HALF
      rect.topLeft.y = Areas[i].bounds.topLeft.y;
      rect.extent.y  = Areas[i].bounds.extent.y;
#else
#ifdef CROSSOVER_TOP
      rect.topLeft.y = Areas[i].bounds.topLeft.y;
#else
      rect.topLeft.y = Areas[i].bounds.topLeft.y +
	(Areas[i].bounds.extent.y >> 1);
#endif /* CROSSOVER_TOP */
      rect.extent.x  = Areas[i].bounds.extent.x >> 1;
      rect.extent.y  = Areas[i].bounds.extent.y >> 1;
#endif /* CROSSOVER_HALF */

      if (RctPtInRectangle(psp->startPt.x, psp->startPt.y, &rect) &&
	  RctPtInRectangle(psp->endPt.x, psp->endPt.y, &rect)) {
	Boolean cl, nl, as; // caps, num, auto
	UInt16  sh;
	GrfGetState(&cl, &nl, &sh, &as);
	if (!cl && !sh && !as)
	  GrfSetState(cl, nl, 1);
      }
#endif

      break;

    case sysNotifyAppLaunchingEvent:
      PageInOut(alp->cardNo, alp->dbID);
      break;

    case sysNotifyAppQuittingEvent:
      foobar();
      break;

    default:
      break;
    }
  }

  return 0;
}

static void EventLoop(void)
{
  EventType event;

  do {
    EvtGetEvent(&event, evtWaitForever);

    if(SysHandleEvent(&event)) continue;

    if(event.eType == frmLoadEvent) {
      Int32 formID = event.data.frmLoad.formID;
      FormPtr pForm = FrmInitForm(formID);
      
      FrmSetActiveForm(pForm);
      switch(formID) {
      case frmMain:
	FrmSetEventHandler(pForm, MainEventHandler);
	break;
      }
    }

    FrmDispatchEvent(&event);

  } while(event.eType != appStopEvent);

  FrmCloseAllForms();
}

static Boolean MainEventHandler(EventType *event) {
  switch (event->eType) {
  case frmOpenEvent:
    CtlSetValue(getControl(), getEnabled());
    EnableMemHack(); // needed in case of bypass soft-reset
    FrmDrawForm(FrmGetActiveForm());
    return true;
    break;

  case ctlSelectEvent:
    if (event->data.ctlEnter.controlID == btnEnabled) {
      setEnabled(CtlGetValue(getControl()));
      EnableMemHack();
      return true;
    }
    break;


  default: break;
  }

  return false;
}

static Boolean getEnabled() {
  short ret, sz;
  sz = sizeof(ret);
  if (PrefGetAppPreferences(appCreatorID, PREFERENCE_ENABLED, &ret, &sz, 
			    true) == noPreferenceFound) {
    ret = false;
    setEnabled(false);
  }

  return ret;
}

static void setEnabled(Boolean enabled) {
  int en = enabled;

  PrefSetAppPreferences(appCreatorID, PREFERENCE_ENABLED, 0, &en, sizeof(en),
			true);
}

void EnableMemHack()
{
  UInt16 cn;
  LocalID db;

  SysCurAppDatabase(&cn, &db);

  if(getEnabled) {
    REG(sysNotifyAppLaunchingEvent);
    REG(sysNotifyAppQuittingEvent);
#ifdef CROSSOVER
    REG(sysNotifyProcessPenStrokeEvent);
#endif
  } else {
    UNREG(sysNotifyAppLaunchingEvent);
    UNREG(sysNotifyAppQuittingEvent);
#ifdef CROSSOVER
    UNREG(sysNotifyProcessPenStrokeEvent);
#endif
  }
}
