/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

class GameCanvas
extends Canvas
implements Runnable {
    private static final int GAME_WIDTH = 120;
    private static final int GAME_HEIGHT = 146;
    private static final int TOPLEFT = 20;
    private static final int BLACK = 0;
    private static final int WHITE = 0xFFFFFF;
    private static final int LIGHTGRAY = 0xAAAAAA;
    private static final int DARKGRAY = 0x555555;
    private Graphics bufferedGraphics;
    private Image bufferedImage;
    private static boolean bMoveWholePosition = true;
    private static int clipx = 0;
    private static int clipy = 0;
    private static int clipw = 120;
    private static int cliph = 146;
    private static Random rand = new Random();
    private static final int SCENE_TITLE = 1;
    private static final int SCENE_MENU = 2;
    private static final int SCENE_LIST_HELP = 21;
    private static final int SCENE_LIST_HELP2 = 29;
    private static final int SCENE_LIST_CREDIT = 25;
    private static final int SCENE_LIST_SETTING = 22;
    private static final int SCENE_LIST_HIGHSCORE = 24;
    private static final int SCENE_SELECT_PLAYER = 4;
    private static final int SCENE_VERSUS = 41;
    private static final int SCENE_GAME_SET_POSITION_P = 51;
    private static final int SCENE_GAME_SET_DIRECTION_P = 52;
    private static final int SCENE_GAME_SET_POWER_P = 53;
    private static final int SCENE_GAME_ROLLING_P = 54;
    private static final int SCENE_GAME_CRASH_P = 55;
    private static final int SCENE_GAME_SCORE_P = 56;
    private static final int SCENE_GAME_TEMPORARYSCORE = 60;
    private static final int SCENE_GAME_TEMPORARYHELP = 61;
    private static final int SCENE_GAME_QUITTOMENU = 71;
    private static final int SCENE_GAME_STAGE_END = 7;
    private static final int SCENE_GAME_RECORD = 8;
    private int nCurrentScene = 0;
    private int nReturnedScene = 0;
    private int nTurnOfPlayer = 0;
    private int nTheNumberOfPlayers = 1;
    private int nPositionOfEnv = 0;
    private boolean bVibrator = true;
    private boolean bSound = true;
    private boolean bBacklight = true;
    private int nStage = 0;
    private int nCrashStep = 0;
    private boolean bNewScene = true;
    private boolean isStrike = false;
    private boolean isClear = false;
    private Image imgTitle;
    private Image imgSelectMsg;
    private Image imgState;
    private Image[] imgSelectPlayerTitle = new Image[2];
    private Image imgSelectTarget;
    private Image[] imgPower = new Image[3];
    private Image[] imgGageHook = new Image[3];
    private Image[] imgHookSelection = new Image[3];
    private Image imgBoy;
    private Image[] imgBoyAnimation = new Image[2];
    private Image imgGirl;
    private Image[] imgGirlAnimation = new Image[2];
    private Image imgGuy;
    private Image[] imgGuyAnimation = new Image[2];
    private Image imgCharacterMask;
    private Image imgVersus;
    private Image[] imgTextPlayer = new Image[2];
    private Image imgFloorWhole;
    private Image imgGageDirection;
    private Image imgGageHookPoint;
    private Image imgPosition;
    private Image imgPinSmall;
    private Image imgBoard;
    private Image imgBoardMask;
    private Image imgSureYes;
    private Image imgSureNo;
    private Image imgStrike;
    private Image imgStrike_s;
    private Image[] imgScore = new Image[10];
    private Image imgTotal;
    private Image imgScoreMiss;
    private Image imgScoreSpare;
    private Image imgScoreStrike;
    private Image imgLane;
    private Image imgLaneBall;
    private Image imgLanePin;
    private Image imgCrashBack;
    private Image[] imgPin = new Image[3];
    private Image[] imgBall = new Image[3];
    private Image imgTextWin;
    private Image imgTextLose;
    private Image imgScoreBox;
    private Image imgCapture;
    private int[] nScoreList = new int[]{0, 0, 0, 0, 0, 0};
    private static int[][] nActorPower = new int[][]{{57, 62, 68, 74, 79, 84, 79, 74, 68, 62}, {62, 68, 74, 79, 84, 79, 74, 68}, {52, 57, 62, 68, 74, 79, 84, 79, 74, 68, 62, 57}};
    private static int[] nPowerEachIndex = new int[]{52, 57, 62, 68, 74, 79, 84};
    private static int nRealPower = 100;
    private static int[][] nActorHook = new int[][]{{-2, 2}, {-3, 1}, {-1, 2}};
    private static int[] nArcX = new int[]{48, 52, 56, 60, 64, 68, 72, 76, 80, 76, 72, 68, 64, 60, 56, 52};
    private static int[] nArcY = new int[]{96, 93, 91, 90, 89, 90, 91, 93, 96, 93, 91, 90, 89, 90, 91, 93};
    private static int[] nArc = new int[]{-4, -3, -2, -1, 0, 1, 2, 3, 4, 3, 2, 1, 0, -1, -2, -3};
    private static int nRealDirection = 0;
    private static int[][] nPinPosition = new int[][]{{62, 59, 65, 56, 62, 68, 53, 59, 65, 71}, {27, 25, 25, 23, 23, 23, 21, 21, 21, 21}, {18, 14, 14, 10, 10, 10, 6, 6, 6, 6}, {59, 51, 67, 44, 59, 74, 38, 52, 66, 80}, {12, 9, 9, 6, 6, 6, 3, 3, 3, 3}};
    private int[] nCurrentPlayer = new int[]{0, 0};
    private int[] nCurrentHookOnGage = new int[]{0, 0};
    private int[] nPinStatus = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private int[] nBallXonCrash = new int[]{0, 0, 0};
    private int[][] nBallXonCrashArray = new int[][]{{25, 43, 60, 77, 95}, {28, 44, 60, 76, 92}, {32, 46, 60, 74, 88}};
    private int[][][] nPinGain_player = new int[][][]{new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1, -1}}, new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1, -1}}};
    private int[][] nPoint_player = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    private int[] nTimeOfRolling_player = new int[]{0, 0};
    private int nTempGain = 0;
    private int nTempScore;
    private int nPointX;
    private int nPointY;
    private boolean isFirstShot = true;
    private int nRollingBallXonLane = 65;
    private int nRollingBallYonLane = 130;
    private int nPlayerPower = 0;
    private int nPlayerDirection = 0;
    private int nPlayerHook = 0;
    private int[] nPlayerPosition = new int[]{60, 60};
    private int SLEEP_TIME = 100;
    private int nSelectedMenu = 1;
    private int nAnimationToggle = 0;
    private boolean bRun = false;
    private boolean bMakeBack = true;
    private int maxProgress = 11;
    private int numProgress = 0;
    private Image[] imgLoad = new Image[2];
    private MobileBowling midletBowling;
    private int nSndStrike = 1;
    private RecordStore db;
    private boolean saving = false;
    boolean areYouSure = false;
    private static final int EMULATOR_SOFT1 = -6;
    private static final int EMULATOR_SOFT2 = -7;
    private static final int KEY_SOFT1 = -20;
    private static final int KEY_SOFT2 = -21;
    private boolean yesno = false;
    private int returnScene = 0;

    GameCanvas(MobileBowling mobileBowling) {
        this.midletBowling = mobileBowling;
        this.bufferedImage = Image.createImage((int)120, (int)146);
        this.bufferedGraphics = this.bufferedImage.getGraphics();
        this.bufferedGraphics.setFont(Font.getFont((int)64, (int)0, (int)8));
    }

    void init() {
        this.soundLoad();
        this.drawTitle();
    }

    void soundLoad() {
    }

    public void resetState() {
        int[] nArray = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[][][] nArrayArray = new int[][][]{new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1, -1}}, new int[][]{{-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1}, {-1, -1, -1}}};
        int[][] nArrayArray2 = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
        this.nPinStatus = nArray;
        this.nPinGain_player = nArrayArray;
        this.nPoint_player = nArrayArray2;
        this.nTurnOfPlayer = 0;
        this.nTimeOfRolling_player[0] = 0;
        this.nTempGain = 0;
        this.nTempScore = 0;
        this.isFirstShot = true;
        this.nSndStrike = 1;
        this.nSelectedMenu = 1;
        this.bRun = false;
        this.bMakeBack = true;
        this.nPlayerPosition[0] = 60;
        this.nCurrentHookOnGage[0] = 0;
        this.nCurrentHookOnGage[1] = 0;
    }

    public void paint(Graphics graphics) {
        graphics.setClip(clipx, clipy, clipw, cliph);
        graphics.drawImage(this.bufferedImage, 0, 0, 20);
        if (this.saving) {
            graphics.setClip(0, this.getHeight() >> 1, this.getWidth(), 22);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(0, this.getHeight() >> 1, this.getWidth(), 22);
            graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
            graphics.setColor(0);
            graphics.drawString("Saving data", this.getWidth() >> 1, (this.getHeight() >> 1) + 1, 0x10 | 1);
            graphics.drawString("Please wait", this.getWidth() >> 1, (this.getHeight() >> 1) + 11, 0x10 | 1);
        }
    }

    private void repaintAll() {
        this.repaint(0, 0, 120, 146);
    }

    private static int rand(int n, int n2) {
        return (rand.nextInt() >>> 1) % (n2 - n + 1) + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        this.loadResource();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(this.SLEEP_TIME);
                    GameCanvas gameCanvas = this;
                    synchronized (gameCanvas) {
                        switch (this.nCurrentScene) {
                            case 2: {
                                this.drawMenu();
                                break;
                            }
                            case 21: {
                                this.drawHelp();
                                break;
                            }
                            case 29: {
                                this.drawHelp2();
                                break;
                            }
                            case 25: {
                                this.drawCredit();
                                break;
                            }
                            case 22: {
                                this.drawEnvirionment();
                                break;
                            }
                            case 24: {
                                this.showHighScore();
                                break;
                            }
                            case 4: {
                                this.drawSelectPlayer();
                                break;
                            }
                            case 41: {
                                this.drawVersus();
                                break;
                            }
                            case 51: {
                                this.changeClip(0, 0, 120, 146);
                                this.drawSetPosition();
                                break;
                            }
                            case 52: {
                                this.changeClip(0, 0, 120, 146);
                                this.drawSetDirection();
                                break;
                            }
                            case 61: {
                                this.drawHelp();
                                this.bufferedGraphics.setColor(15694848);
                                this.bufferedGraphics.fillRect(0, 6, 120, 13);
                                this.bufferedGraphics.setColor(0);
                                this.bufferedGraphics.drawString("MINI HELP", 60, 6, 17);
                                break;
                            }
                            case 60: {
                                this.drawTemporaryBoard();
                                break;
                            }
                            case 53: {
                                this.drawSetPower();
                                break;
                            }
                            case 54: {
                                this.drawLaneRolling();
                                break;
                            }
                            case 55: {
                                this.drawCrash();
                                break;
                            }
                            case 56: {
                                this.changeClip(0, 0, 120, 146);
                                this.drawScore();
                                break;
                            }
                            case 7: {
                                this.SLEEP_TIME = 300;
                                this.drawEnding();
                                break;
                            }
                            case 71: {
                                this.drawSure();
                                break;
                            }
                        }
                        this.repaintAll();
                    }
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void callVibration(int n) {
    }

    private void turnOnLight() {
    }

    private void changeSoundVolume() {
        this.bSound = !this.bSound;
    }

    private void drawHelp() {
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.bufferedGraphics.setColor(15694848);
        this.bufferedGraphics.fillRect(0, 6, 120, 13);
        this.bufferedGraphics.setColor(16751920);
        this.bufferedGraphics.fillRect(4, 23, 112, 117);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 19, 120, 2);
        this.bufferedGraphics.drawRect(3, 22, 113, 118);
        this.bufferedGraphics.drawImage(this.imgPosition, 5, 25, 20);
        this.bufferedGraphics.drawImage(this.imgGageHook[2], 5, 60, 20);
        this.bufferedGraphics.drawImage(this.imgGageDirection, 5, 95, 20);
        this.bufferedGraphics.drawString("HELP (1/2)", 60, 6, 17);
        this.bufferedGraphics.drawString("1.standing", 47, 23, 20);
        this.bufferedGraphics.drawString("position", 47, 34, 20);
        this.bufferedGraphics.drawString(":left,right", 47, 45, 20);
        this.bufferedGraphics.drawString("2.hook", 47, 64, 20);
        this.bufferedGraphics.drawString(":up,down", 47, 75, 20);
        this.bufferedGraphics.drawString("3.set angle", 47, 96, 20);
        this.bufferedGraphics.drawString("& power ", 47, 107, 20);
        this.bufferedGraphics.drawString(":'OK' ", 47, 118, 20);
    }

    private void drawHelp2() {
        String[] stringArray = new String[]{"HELP (2/2)", "4.View Score : ", " '1' Button", "5.Sound On/Off :", " '#' Button", "6.Mini Help : ", " '*' Button"};
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.bufferedGraphics.setColor(15694848);
        this.bufferedGraphics.fillRect(0, 6, 120, 13);
        this.bufferedGraphics.setColor(16751920);
        this.bufferedGraphics.fillRect(4, 23, 112, 87);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 19, 120, 2);
        this.bufferedGraphics.drawRect(3, 22, 113, 88);
        this.bufferedGraphics.drawString(stringArray[0], 60, 6, 17);
        int n = 1;
        while (n < stringArray.length) {
            this.bufferedGraphics.drawString(stringArray[n], 6, n * 14 + 10, 20);
            ++n;
        }
    }

    private void drawCredit() {
        String[] stringArray = new String[]{"CREDITS", "Producer & Designer ", " : Nam Il-hee", "Programmer", " : Jeon Hyun-sang", "T720 version", " : nGame/Mforma"};
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.bufferedGraphics.setColor(15694848);
        this.bufferedGraphics.fillRect(0, 6, 120, 13);
        this.bufferedGraphics.setColor(16751920);
        this.bufferedGraphics.fillRect(4, 23, 112, 98);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 19, 120, 2);
        this.bufferedGraphics.drawRect(3, 22, 113, 99);
        this.bufferedGraphics.drawString(stringArray[0], 60, 6, 17);
        int n = 1;
        while (n < stringArray.length) {
            this.bufferedGraphics.drawString(stringArray[n], 6, n * 14 + 15, 20);
            ++n;
        }
    }

    private void drawEnvirionment() {
        this.clearScreen(0xFFFFFF);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.drawRect(5, 5, 110, 136);
        this.bufferedGraphics.fillRect(30, 0, 60, 15);
        this.bufferedGraphics.fillRect(0, 131, 30, 15);
        this.bufferedGraphics.fillRect(90, 131, 30, 15);
        if (this.bVibrator) {
            if (this.nPositionOfEnv != 0) {
                this.bufferedGraphics.drawString("Vibration : ON", 15, 30, 20);
            } else {
                this.bufferedGraphics.setColor(0);
                this.bufferedGraphics.fillRect(10, (this.nPositionOfEnv + 2) * 15, 100, 14);
                this.bufferedGraphics.setColor(0xFFFFFF);
                this.bufferedGraphics.drawString("Vibration : ON", 15, 30, 20);
            }
        } else if (this.nPositionOfEnv != 0) {
            this.bufferedGraphics.drawString("Vibration : OFF", 15, 30, 20);
        } else {
            this.bufferedGraphics.setColor(0);
            this.bufferedGraphics.fillRect(10, (this.nPositionOfEnv + 2) * 15, 100, 14);
            this.bufferedGraphics.setColor(0xFFFFFF);
            this.bufferedGraphics.drawString("Vibration : OFF", 15, 30, 20);
        }
        this.bufferedGraphics.setColor(0);
        if (this.bSound) {
            if (this.nPositionOfEnv != 1) {
                this.bufferedGraphics.drawString("Sound : ON", 15, 45, 20);
            } else {
                this.bufferedGraphics.setColor(0);
                this.bufferedGraphics.fillRect(10, (this.nPositionOfEnv + 2) * 15, 100, 14);
                this.bufferedGraphics.setColor(0xFFFFFF);
                this.bufferedGraphics.drawString("Sound : ON", 15, 45, 20);
            }
        } else if (this.nPositionOfEnv != 1) {
            this.bufferedGraphics.drawString("Sound : OFF", 15, 45, 20);
        } else {
            this.bufferedGraphics.setColor(0);
            this.bufferedGraphics.fillRect(10, (this.nPositionOfEnv + 2) * 15, 100, 14);
            this.bufferedGraphics.setColor(0xFFFFFF);
            this.bufferedGraphics.drawString("Sound : OFF", 15, 45, 20);
        }
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawString("OPTIONS", 60, 1, 17);
        this.bufferedGraphics.drawString("BACK", 3, 131, 20);
        this.bufferedGraphics.drawString("OK", 93, 131, 20);
    }

    private void showHighScore() {
        this.clearScreen(0xFFFFFF);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.drawRect(5, 5, 110, 136);
        this.bufferedGraphics.drawString("HIGH SCORE", 35, 10, 20);
        this.bufferedGraphics.drawString("1. " + this.nScoreList[0], 10, 35, 20);
        this.bufferedGraphics.drawString("2. " + this.nScoreList[1], 10, 50, 20);
        this.bufferedGraphics.drawString("3. " + this.nScoreList[2], 10, 65, 20);
        this.bufferedGraphics.drawString("4. " + this.nScoreList[3], 70, 35, 20);
        this.bufferedGraphics.drawString("5. " + this.nScoreList[4], 70, 50, 20);
        int n = 0;
        int n2 = 0;
        while (n2 < this.nScoreList.length && this.nScoreList[n2] != 0) {
            n += this.nScoreList[n2];
            ++n2;
        }
        if (n2 != 0) {
            n /= n2;
        }
        this.bufferedGraphics.drawString("AVERAGE : " + n, 35, 90, 20);
    }

    private void readScore() {
        try {
            this.db = RecordStore.openRecordStore((String)"jgebowlscr", (boolean)true);
            if (this.db == null) {
                return;
            }
            if (this.db.getNumRecords() == 0) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                int n = 0;
                while (n < 5) {
                    try {
                        dataOutputStream.writeUTF(Integer.toString(0));
                    }
                    catch (IOException iOException) {
                        System.out.println("Exception at Writing INIT-SCORE");
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    int n2 = this.db.addRecord(byArray, 0, byArray.length);
                    ++n;
                }
                dataOutputStream.close();
                byteArrayOutputStream.close();
            } else {
                int n = 0;
                int n3 = 0;
                while (n3 < 5) {
                    byte[] byArray = this.db.getRecord(n3 + 1);
                    String string = new String(this.db.getRecord(n3 + 1));
                    this.nScoreList[n3] = Integer.parseInt(string.substring(n + 2));
                    n = string.length();
                    ++n3;
                }
            }
            this.db.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("Exception at readScore() method : " + exception.toString());
        }
    }

    private void writeScore(int n) {
        this.saving = true;
        this.repaint();
        this.serviceRepaints();
        int n2 = 0;
        this.nScoreList[5] = n;
        int n3 = 0;
        while (n3 < 5) {
            int n4 = n3 + 1;
            while (n4 < 6) {
                if (this.nScoreList[n3] < this.nScoreList[n4]) {
                    n2 = this.nScoreList[n3];
                    this.nScoreList[n3] = this.nScoreList[n4];
                    this.nScoreList[n4] = n2;
                }
                ++n4;
            }
            ++n3;
        }
        try {
            this.db = RecordStore.openRecordStore((String)"jgebowlscr", (boolean)true);
            if (this.db == null) {
                return;
            }
            if (this.db.getNumRecords() != 0) {
                this.db.closeRecordStore();
                RecordStore.deleteRecordStore((String)"jgebowlscr");
                this.db = RecordStore.openRecordStore((String)"jgebowlscr", (boolean)true);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n5 = 0;
            while (n5 < 5) {
                dataOutputStream.writeUTF(Integer.toString(this.nScoreList[n5]));
                byte[] byArray = byteArrayOutputStream.toByteArray();
                int n6 = this.db.addRecord(byArray, 0, byArray.length);
                System.out.print("nID_ScoreDB[" + n5 + "] : " + n6);
                ++n5;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            this.db.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println("Exeption at writeScore() method : " + exception.toString());
        }
        this.saving = false;
        this.repaint();
        this.serviceRepaints();
    }

    public void keyPressed(int n) {
        if (this.saving) {
            return;
        }
        int n2 = this.getGameAction(n);
        switch (this.nCurrentScene) {
            case 1: {
                if (this.bRun) break;
                new Thread(this).start();
                this.bRun = true;
                break;
            }
            case 2: {
                if (n > 48 && n < 55) {
                    this.nSelectedMenu = n - 48;
                    switch (this.nSelectedMenu) {
                        case 1: {
                            this.nTheNumberOfPlayers = 1;
                            this.nCurrentScene = 4;
                            break;
                        }
                        case 2: {
                            this.nTheNumberOfPlayers = 2;
                            this.nCurrentScene = 4;
                            break;
                        }
                        case 3: {
                            this.nCurrentScene = 24;
                            break;
                        }
                        case 4: {
                            this.nCurrentScene = 21;
                            break;
                        }
                        case 5: {
                            this.nCurrentScene = 25;
                            break;
                        }
                        case 6: {
                            this.midletBowling.midletExit();
                        }
                    }
                    break;
                }
                if (n == -20 || n2 == 8) {
                    switch (this.nSelectedMenu) {
                        case 1: {
                            this.nTheNumberOfPlayers = 1;
                            this.nCurrentScene = 4;
                            break;
                        }
                        case 2: {
                            this.nTheNumberOfPlayers = 2;
                            this.nCurrentScene = 4;
                            break;
                        }
                        case 3: {
                            this.nCurrentScene = 24;
                            break;
                        }
                        case 4: {
                            this.nCurrentScene = 21;
                            break;
                        }
                        case 5: {
                            this.nCurrentScene = 25;
                            break;
                        }
                        case 6: {
                            this.midletBowling.midletExit();
                        }
                    }
                    break;
                }
                switch (n2) {
                    case 1: {
                        this.nSelectedMenu = this.nSelectedMenu - 1 == 0 ? 1 : this.nSelectedMenu - 1;
                        break;
                    }
                    case 6: {
                        this.nSelectedMenu = this.nSelectedMenu + 1 == 7 ? 6 : this.nSelectedMenu + 1;
                    }
                }
                break;
            }
            case 21: {
                this.nCurrentScene = 29;
                break;
            }
            case 29: {
                this.nCurrentScene = 2;
                break;
            }
            case 25: {
                this.nCurrentScene = 2;
                break;
            }
            case 22: {
                if (n == -20 || n == -6) {
                    this.nCurrentScene = 2;
                    break;
                }
                if (n == -21 || n == -7 || n2 == 8 || n2 == 2 || n2 == 5) {
                    switch (this.nPositionOfEnv) {
                        case 0: {
                            this.bVibrator = !this.bVibrator;
                            break;
                        }
                        case 1: {
                            this.bSound = !this.bSound;
                            break;
                        }
                        case 2: {
                            this.bBacklight = !this.bBacklight;
                            this.turnOnLight();
                        }
                    }
                    break;
                }
                switch (n2) {
                    case 1: {
                        this.nPositionOfEnv = (this.nPositionOfEnv + 2) % 3;
                        break;
                    }
                    case 6: {
                        this.nPositionOfEnv = (this.nPositionOfEnv + 1) % 3;
                    }
                }
                break;
            }
            case 24: {
                this.nCurrentScene = 2;
                break;
            }
            case 4: {
                if (this.nTheNumberOfPlayers == 1) {
                    if (n == -20 || n2 == 8) {
                        this.nCurrentScene = 51;
                        break;
                    }
                    switch (n2) {
                        case 2: {
                            this.nCurrentPlayer[0] = (this.nCurrentPlayer[0] + 2) % 3;
                            break;
                        }
                        case 5: {
                            this.nCurrentPlayer[0] = (this.nCurrentPlayer[0] + 1) % 3;
                        }
                    }
                    break;
                }
                if (this.nTurnOfPlayer == 0) {
                    if (n == -20 || n2 == 8) {
                        this.nTurnOfPlayer = 1;
                        this.nCurrentPlayer[1] = (this.nCurrentPlayer[0] + 1) % 3;
                        break;
                    }
                    switch (n2) {
                        case 2: {
                            this.nCurrentPlayer[0] = (this.nCurrentPlayer[0] + 2) % 3;
                            break;
                        }
                        case 5: {
                            this.nCurrentPlayer[0] = (this.nCurrentPlayer[0] + 1) % 3;
                        }
                    }
                    break;
                }
                if (n == -20 || n2 == 8) {
                    this.nTurnOfPlayer = 0;
                    this.nCurrentScene = 41;
                    break;
                }
                switch (n2) {
                    case 2: {
                        this.nCurrentPlayer[1] = (this.nCurrentPlayer[1] + 2) % 3 == this.nCurrentPlayer[0] ? (this.nCurrentPlayer[1] + 1) % 3 : (this.nCurrentPlayer[1] + 2) % 3;
                        break;
                    }
                    case 5: {
                        this.nCurrentPlayer[1] = (this.nCurrentPlayer[1] + 1) % 3 == this.nCurrentPlayer[0] ? (this.nCurrentPlayer[1] + 2) % 3 : (this.nCurrentPlayer[1] + 1) % 3;
                    }
                }
                break;
            }
            case 41: {
                this.nCurrentScene = 51;
                break;
            }
            case 51: {
                if (n2 == 8) {
                    this.nRollingBallXonLane = 25 * this.nPlayerPosition[this.nTurnOfPlayer] / 120 + 50;
                    this.nRollingBallYonLane = 130;
                    this.nCurrentScene = 52;
                    break;
                }
                if (n == 49) {
                    this.nReturnedScene = this.nCurrentScene;
                    this.nCurrentScene = 60;
                    break;
                }
                if (n == 42) {
                    this.nReturnedScene = this.nCurrentScene;
                    this.nCurrentScene = 61;
                    break;
                }
                if (n == 35) {
                    this.changeSoundVolume();
                    break;
                }
                switch (n2) {
                    case 2: {
                        this.nPlayerPosition[this.nTurnOfPlayer] = this.nPlayerPosition[this.nTurnOfPlayer] - 5 < 5 ? 5 : this.nPlayerPosition[this.nTurnOfPlayer] - 5;
                        break;
                    }
                    case 5: {
                        this.nPlayerPosition[this.nTurnOfPlayer] = this.nPlayerPosition[this.nTurnOfPlayer] + 5 > 114 ? 114 : this.nPlayerPosition[this.nTurnOfPlayer] + 5;
                        break;
                    }
                    case 1: {
                        this.chageHook(-1);
                        break;
                    }
                    case 6: {
                        this.chageHook(1);
                    }
                }
                break;
            }
            case 52: {
                if (n2 == 8) {
                    nRealDirection = nArc[this.nPlayerDirection];
                    this.nCurrentScene = 53;
                    break;
                }
                if (n == 49) {
                    this.nReturnedScene = this.nCurrentScene;
                    this.nCurrentScene = 60;
                    break;
                }
                if (n == 42) {
                    this.nReturnedScene = this.nCurrentScene;
                    this.nCurrentScene = 61;
                    break;
                }
                if (n == 35) {
                    this.changeSoundVolume();
                    break;
                }
                switch (n2) {
                    case 1: {
                        this.chageHook(-1);
                        break;
                    }
                    case 6: {
                        this.chageHook(1);
                    }
                }
                break;
            }
            case 61: {
                this.nCurrentScene = this.nReturnedScene;
                break;
            }
            case 60: {
                if (n == -20 || n == -6) {
                    this.returnScene = this.nCurrentScene;
                    this.nCurrentScene = 71;
                    return;
                }
                this.nCurrentScene = this.nReturnedScene;
                break;
            }
            case 53: {
                if (n != -20 && n2 != 8) break;
                nRealPower = this.convertPositionToRealPower(nActorPower[this.nCurrentPlayer[this.nTurnOfPlayer]][this.nPlayerPower]);
                this.changeClip(42, 4, this.imgLane.getWidth() - 1, this.imgLane.getHeight() - 1);
                this.nCurrentScene = 54;
                break;
            }
            case 54: {
                break;
            }
            case 55: {
                break;
            }
            case 56: {
                int n3;
                if (n == -20 || n == -6) {
                    this.returnScene = this.nCurrentScene;
                    this.nCurrentScene = 71;
                    return;
                }
                if (this.isFirstShot) {
                    n3 = 0;
                    while (n3 < 10) {
                        this.nPinStatus[n3] = 1;
                        ++n3;
                    }
                    if (this.nTheNumberOfPlayers == 2 && this.nTimeOfRolling_player[this.nTurnOfPlayer] < 19) {
                        this.changeNextTurn();
                    }
                }
                if (this.nPinGain_player[this.nTurnOfPlayer][9][1] != -1 && this.nPinGain_player[this.nTurnOfPlayer][9][0] + this.nPinGain_player[this.nTurnOfPlayer][9][1] < 10) {
                    if (this.nTheNumberOfPlayers == 2) {
                        if (this.nTurnOfPlayer == 0) {
                            n3 = 0;
                            while (n3 < 10) {
                                this.nPinStatus[n3] = 1;
                                ++n3;
                            }
                            this.changeNextTurn();
                            this.nCurrentScene = 51;
                        } else {
                            this.nCurrentScene = 7;
                        }
                    } else {
                        this.nCurrentScene = 7;
                        this.writeScore(this.nPoint_player[this.nTurnOfPlayer][9]);
                        this.changeClip(0, 0, 120, 146);
                    }
                } else {
                    this.nCurrentScene = 51;
                }
                if (this.nPinGain_player[this.nTurnOfPlayer][9][2] == -1) break;
                if (this.nTheNumberOfPlayers == 2) {
                    if (this.nTurnOfPlayer == 0) {
                        n3 = 0;
                        while (n3 < 10) {
                            this.nPinStatus[n3] = 1;
                            ++n3;
                        }
                        this.changeNextTurn();
                        this.nCurrentScene = 51;
                        break;
                    }
                    this.nCurrentScene = 7;
                    break;
                }
                this.nCurrentScene = 7;
                this.writeScore(this.nPoint_player[this.nTurnOfPlayer][9]);
                this.changeClip(0, 0, 120, 146);
                break;
            }
            case 71: {
                if (n == -20 || n2 == 8) {
                    if (this.yesno) {
                        this.resetState();
                        this.nCurrentScene = 2;
                        this.yesno = false;
                        break;
                    }
                    this.nCurrentScene = this.returnScene;
                    break;
                }
                if (n2 != 2 && n2 != 5) break;
                this.yesno = !this.yesno;
                break;
            }
            case 7: {
                this.resetState();
                this.SLEEP_TIME = 100;
                this.nCurrentScene = 2;
            }
        }
    }

    private Image loadFileToImage(String string) {
        try {
            return Image.createImage((String)string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private Image load(String string) {
        return this.loadFileToImage("/" + string + ".png");
    }

    private void load(Image[] imageArray, String string) {
        int n = 0;
        while (n < imageArray.length) {
            imageArray[n] = this.loadFileToImage("/" + string + n + ".png");
            ++n;
        }
    }

    private void drawProgress() {
        ++this.numProgress;
        int n = 6;
        int n2 = 66;
        int n3 = 12;
        int n4 = 107;
        int n5 = (n4 - 2) * this.numProgress / this.maxProgress;
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.fillRect(0, 0, 120, 146);
        this.bufferedGraphics.drawImage(this.imgLoad[0], n, 22, 20);
        this.bufferedGraphics.fillRect(n + n5, n2, n4 - 1 - n5, 12);
        this.bufferedGraphics.drawImage(this.imgLoad[1], n + 2, n2 + 1, 20);
        this.repaintAll();
        this.serviceRepaints();
    }

    private void clearScreen(int n) {
        this.bufferedGraphics.setColor(n);
        this.bufferedGraphics.fillRect(0, 0, 120, 146);
    }

    private void loadResource() {
        this.imgTitle = null;
        System.gc();
        this.drawProgress();
        this.imgFloorWhole = this.load("floor");
        this.drawProgress();
        this.drawProgress();
        this.imgLane = this.load("lane");
        this.imgCrashBack = this.load("pinback");
        this.imgStrike = this.load("strike");
        this.drawProgress();
        this.load(this.imgGirlAnimation, "cgirl");
        this.imgGirl = this.load("cgirl");
        this.drawProgress();
        this.load(this.imgBoyAnimation, "cboy");
        this.imgBoy = this.load("cboy");
        this.drawProgress();
        this.load(this.imgGuyAnimation, "cguy");
        this.imgGuy = this.load("cguy");
        this.drawProgress();
        this.imgStrike_s = this.load("strike_s");
        this.imgPosition = this.load("finger");
        this.imgSelectTarget = this.load("stg");
        this.imgBoard = this.load("board");
        this.imgGageDirection = this.load("arc");
        this.imgBoardMask = this.load("boardmask");
        this.imgSureYes = this.load("sureYes");
        this.imgSureNo = this.load("sureNo");
        this.load(this.imgGageHook, "hook");
        this.imgTotal = this.load("total");
        this.drawProgress();
        this.load(this.imgPin, "pin");
        this.load(this.imgBall, "crball");
        this.imgState = this.load("state");
        this.imgSelectMsg = this.load("smsg");
        this.imgTextWin = this.load("rwin");
        this.imgTextLose = this.load("rlose");
        this.load(this.imgSelectPlayerTitle, "selectp");
        this.imgCharacterMask = this.load("charactermask");
        this.drawProgress();
        this.imgVersus = this.load("vs");
        this.load(this.imgHookSelection, "hooks");
        this.load(this.imgTextPlayer, "textp");
        this.imgPinSmall = this.load("pinsmall");
        this.load(this.imgPower, "power");
        this.imgGageHookPoint = this.load("hookp");
        this.imgScoreBox = this.load("rscore");
        this.imgLaneBall = this.load("laneball");
        this.imgLanePin = this.load("lanepin");
        this.drawProgress();
        this.load(this.imgScore, "score/");
        this.imgScoreMiss = this.load("score/m");
        this.imgScoreSpare = this.load("score/sp");
        this.imgScoreStrike = this.load("score/st");
        this.readScore();
        this.drawProgress();
        this.nCurrentScene = 2;
    }

    private void drawTitle() {
        this.load(this.imgLoad, "load");
        this.imgTitle = this.load("open");
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 0, 120, 146);
        this.bufferedGraphics.drawImage(this.imgTitle, 0, 6, 20);
        this.repaintAll();
        this.serviceRepaints();
        this.nCurrentScene = 1;
    }

    private void drawMenu() {
        String[] stringArray = new String[]{"1 Single", "2 VS Mode", "3 Score", "4 Help", "5 Credits", "6 Exit"};
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.drawRect(15, 5, 90, 16);
        int n = 0;
        while (n < 6) {
            this.bufferedGraphics.drawRoundRect(10, n * 20 + 27, 100, 16, 10, 10);
            n = (byte)(n + 1);
        }
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawRect(16, 6, 88, 14);
        n = 0;
        while (n < 6) {
            this.bufferedGraphics.drawRoundRect(11, n * 20 + 28, 98, 14, 10, 10);
            n = (byte)(n + 1);
        }
        this.bufferedGraphics.setColor(11164102);
        this.bufferedGraphics.fillRect(17, 7, 87, 13);
        this.bufferedGraphics.setColor(16231936);
        n = 0;
        while (n < 6) {
            this.bufferedGraphics.fillRoundRect(12, n * 20 + 29, 98, 14, 10, 10);
            n = (byte)(n + 1);
        }
        this.bufferedGraphics.setColor(14555648);
        this.bufferedGraphics.fillRoundRect(13, (this.nSelectedMenu - 1) * 20 + 30, 97, 13, 8, 8);
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawString("SELECT MODE", 60, 7, 17);
        n = 0;
        while (n < 6) {
            this.bufferedGraphics.drawString(stringArray[n], 20, n * 20 + 30, 20);
            n = (byte)(n + 1);
        }
    }

    private void changeNextTurn() {
        this.nTurnOfPlayer = this.nTurnOfPlayer * -1 + 1;
    }

    private boolean checkNextTurnEnable() {
        return true;
    }

    private void drawVersus() {
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
        switch (this.nCurrentPlayer[0]) {
            case 0: {
                this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 9, 47, 20);
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 9, 47, 20);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 9, 47, 20);
            }
        }
        switch (this.nCurrentPlayer[1]) {
            case 0: {
                this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 75, 47, 20);
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 75, 47, 20);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 75, 47, 20);
            }
        }
        this.bufferedGraphics.drawImage(this.imgVersus, 46, 59, 20);
    }

    private void drawSelectPlayer() {
        this.clearScreen(0xFFFFFF);
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.bufferedGraphics.setColor(6438530);
        this.bufferedGraphics.fillRect(0, 40, 120, 55);
        this.bufferedGraphics.drawImage(this.imgState, 9, 100, 20);
        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
        switch (this.nCurrentPlayer[0]) {
            case 0: {
                this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 3, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGirl, 42, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGuy, 81, 55, 20);
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgBoy, 3, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 42, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGuy, 81, 55, 20);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgBoy, 3, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGirl, 42, 55, 20);
                this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 81, 55, 20);
            }
        }
        if (this.nTheNumberOfPlayers == 2) {
            this.bufferedGraphics.drawImage(this.imgSelectPlayerTitle[this.nTurnOfPlayer], 2, 23, 20);
            if (this.nTurnOfPlayer == 1) {
                switch (this.nCurrentPlayer[1]) {
                    case 0: {
                        this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 3, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGirl, 42, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGuy, 81, 55, 20);
                        break;
                    }
                    case 1: {
                        this.bufferedGraphics.drawImage(this.imgBoy, 3, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 42, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGuy, 81, 55, 20);
                        break;
                    }
                    case 2: {
                        this.bufferedGraphics.drawImage(this.imgBoy, 3, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGirl, 42, 55, 20);
                        this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 81, 55, 20);
                    }
                }
                this.bufferedGraphics.drawImage(this.imgCharacterMask, this.nCurrentPlayer[0] * 39 + 3, 55, 20);
            }
        } else {
            this.bufferedGraphics.drawImage(this.imgSelectMsg, 0, 23, 20);
        }
        if (this.nTheNumberOfPlayers == 2 && this.nTurnOfPlayer == 1) {
            this.bufferedGraphics.drawImage(this.imgSelectTarget, this.nCurrentPlayer[1] * 39, 41, 20);
            this.bufferedGraphics.drawImage(this.imgPower[this.nCurrentPlayer[1]], 54, 103, 20);
            this.bufferedGraphics.drawImage(this.imgHookSelection[this.nCurrentPlayer[1]], 56, 115, 20);
        } else {
            this.bufferedGraphics.drawImage(this.imgSelectTarget, this.nCurrentPlayer[0] * 39, 41, 20);
            this.bufferedGraphics.drawImage(this.imgPower[this.nCurrentPlayer[0]], 54, 103, 20);
            this.bufferedGraphics.drawImage(this.imgHookSelection[this.nCurrentPlayer[0]], 56, 115, 20);
        }
    }

    private void drawSetPosition() {
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        switch (this.nCurrentPlayer[this.nTurnOfPlayer]) {
            case 0: {
                this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[0], 89, 4, 20);
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[1], 92, 4, 20);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[2], 89, 10, 20);
            }
        }
        this.bufferedGraphics.drawImage(this.imgGageDirection, 46, 87, 20);
        this.bufferedGraphics.drawImage(this.imgGageHookPoint, 100, 30 - 6 * (nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][1] - this.nCurrentHookOnGage[this.nTurnOfPlayer]), 20);
        this.bufferedGraphics.drawImage(this.imgPosition, this.nPlayerPosition[this.nTurnOfPlayer] - 11, 125, 20);
        int n = 9;
        while (n > -1) {
            if (this.nPinStatus[n] == 1) {
                this.bufferedGraphics.drawImage(this.imgPinSmall, nPinPosition[0][n] - 3, nPinPosition[1][n], 20);
            }
            --n;
        }
    }

    private void drawSetDirection() {
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        switch (this.nCurrentPlayer[this.nTurnOfPlayer]) {
            case 0: {
                this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[0], 89, 4, 20);
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[1], 92, 4, 20);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                this.bufferedGraphics.drawImage(this.imgGageHook[2], 89, 10, 20);
            }
        }
        this.bufferedGraphics.drawImage(this.imgGageHookPoint, 100, 30 - 6 * (nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][1] - this.nCurrentHookOnGage[this.nTurnOfPlayer]), 20);
        this.bufferedGraphics.drawImage(this.imgPosition, this.nPlayerPosition[this.nTurnOfPlayer] - 11, 125, 20);
        int n = 9;
        while (n > -1) {
            if (this.nPinStatus[n] == 1) {
                this.bufferedGraphics.drawImage(this.imgPinSmall, nPinPosition[0][n] - 3, nPinPosition[1][n], 20);
            }
            --n;
        }
        this.nPlayerDirection = (this.nPlayerDirection + 1) % 16;
        this.bufferedGraphics.drawImage(this.imgGageDirection, 46, 87, 20);
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawLine(64, 112, nArcX[this.nPlayerDirection], nArcY[this.nPlayerDirection]);
    }

    private void chageHook(int n) {
        int n2 = this.nTurnOfPlayer;
        this.nCurrentHookOnGage[n2] = this.nCurrentHookOnGage[n2] + n;
        if (this.nCurrentHookOnGage[this.nTurnOfPlayer] < nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][0]) {
            this.nCurrentHookOnGage[this.nTurnOfPlayer] = nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][1];
        } else if (this.nCurrentHookOnGage[this.nTurnOfPlayer] > nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][1]) {
            this.nCurrentHookOnGage[this.nTurnOfPlayer] = nActorHook[this.nCurrentPlayer[this.nTurnOfPlayer]][0];
        }
    }

    private void drawSetPower() {
        this.bufferedGraphics.setClip(111, 50, 20, 50);
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.nPlayerPower = (this.nPlayerPower + 1) % nActorPower[this.nCurrentPlayer[this.nTurnOfPlayer]].length;
        this.bufferedGraphics.fillRect(115, nActorPower[this.nCurrentPlayer[this.nTurnOfPlayer]][this.nPlayerPower], 5, 2);
        this.bufferedGraphics.setClip(0, 0, 120, 146);
    }

    private void drawLaneRolling() {
        this.bufferedGraphics.drawImage(this.imgLane, 42, 4, 20);
        int n = 9;
        while (n > -1) {
            if (this.nPinStatus[n] == 1) {
                this.bufferedGraphics.drawImage(this.imgLanePin, nPinPosition[0][n] - 4, nPinPosition[2][n], 20);
            }
            --n;
        }
        if (nRealPower > 80) {
            if (this.nRollingBallYonLane < 40) {
                this.nRollingBallXonLane += this.nCurrentHookOnGage[this.nTurnOfPlayer];
            }
        } else if (nRealPower > 50) {
            if (this.nRollingBallYonLane < 60) {
                this.nRollingBallXonLane += this.nCurrentHookOnGage[this.nTurnOfPlayer];
            }
        } else if (this.nRollingBallYonLane < 80) {
            this.nRollingBallXonLane += this.nCurrentHookOnGage[this.nTurnOfPlayer];
        }
        if (this.nRollingBallXonLane < 50) {
            this.nRollingBallXonLane = 47;
        } else if (this.nRollingBallXonLane > 73) {
            this.nRollingBallXonLane = 76;
        } else {
            this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
            this.nRollingBallXonLane = this.nAnimationToggle == 0 ? (this.nRollingBallXonLane += nRealDirection) : (this.nRollingBallXonLane += nRealDirection / 2);
        }
        if (this.nRollingBallYonLane > 20) {
            this.nRollingBallYonLane -= nRealPower / 10;
        } else {
            this.nCurrentScene = 55;
            this.changeClip(0, 0, 120, 146);
            this.bNewScene = true;
        }
        this.bufferedGraphics.drawImage(this.imgLaneBall, this.nRollingBallXonLane - 4, this.nRollingBallYonLane + 5, 20);
    }

    private void drawCrash() {
        if (this.bNewScene) {
            this.bNewScene = false;
        } else {
            this.changeClip(27, 4, 65, 58);
        }
        this.bufferedGraphics.drawImage(this.imgCrashBack, 25, 1, 20);
        int n = 9;
        while (n > -1) {
            switch (this.nPinStatus[n]) {
                case 1: {
                    this.bufferedGraphics.drawImage(this.imgPin[0], nPinPosition[3][n], nPinPosition[4][n], 20);
                    break;
                }
                case 3: {
                    this.bufferedGraphics.drawImage(this.imgPin[1], nPinPosition[3][n], nPinPosition[4][n], 20);
                    break;
                }
                case 6: {
                    this.bufferedGraphics.drawImage(this.imgPin[2], nPinPosition[3][n], nPinPosition[4][n], 20);
                }
            }
            --n;
        }
        switch (this.nCrashStep) {
            case 0: {
                if (this.nRollingBallXonLane < 50 || this.nRollingBallXonLane > 73) {
                    this.nBallXonCrash[2] = -50;
                    this.nBallXonCrash[1] = -50;
                    this.nBallXonCrash[0] = -50;
                    break;
                }
                int n2 = 0;
                n2 = this.nRollingBallXonLane < 55 ? 0 : (this.nRollingBallXonLane < 59 ? 1 : (this.nRollingBallXonLane < 63 ? 2 : (this.nRollingBallXonLane < 68 ? 3 : 4)));
                this.nBallXonCrash[2] = this.nBallXonCrashArray[2][n2];
                this.nBallXonCrash[1] = this.nBallXonCrashArray[1][n2] - (nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer]) * 10;
                this.nBallXonCrash[0] = this.nBallXonCrashArray[0][n2] - (nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer]) * 20;
                break;
            }
            case 1: {
                this.bufferedGraphics.drawImage(this.imgBall[0], this.nBallXonCrash[0], 46, 17);
                break;
            }
            case 2: {
                this.bufferedGraphics.drawImage(this.imgBall[1], this.nBallXonCrash[1], 36, 17);
                break;
            }
            case 3: {
                this.bufferedGraphics.drawImage(this.imgBall[2], this.nBallXonCrash[2], 28, 17);
                boolean bl = this.isFirstShot = !this.isFirstShot;
                if (this.nRollingBallXonLane < 50 || this.nRollingBallXonLane > 73) break;
                if (this.nCurrentHookOnGage[this.nTurnOfPlayer] == 0) {
                    this.attackPin_0();
                    break;
                }
                if (nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer] == 0) {
                    this.attackPin_0();
                    break;
                }
                if (nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer] == -1) {
                    this.attackPin_L1();
                    break;
                }
                if (nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer] == 1) {
                    this.attackPin_R1();
                    break;
                }
                this.attackPin_2(nRealDirection + this.nCurrentHookOnGage[this.nTurnOfPlayer]);
                break;
            }
            case 4: {
                this.attackPinFinish();
                break;
            }
            case 5: {
                this.nCrashStep = -1;
                this.SLEEP_TIME = 100;
                this.nCurrentScene = 56;
                int n3 = 0;
                int n4 = 0;
                while (n4 < 10) {
                    n3 += this.nPinStatus[n4];
                    ++n4;
                }
                this.isClear = n3 == 0;
            }
        }
        ++this.nCrashStep;
        this.nSndStrike = 1;
    }

    private void drawTemporaryBoard() {
        if (this.nTheNumberOfPlayers == 1) {
            this.drawBoard2(3, 90, this.nTurnOfPlayer);
        } else {
            this.bufferedGraphics.drawImage(this.imgTextPlayer[0], 3, 24, 20);
            this.bufferedGraphics.drawImage(this.imgTextPlayer[1], 3, 79, 20);
            this.drawBoard2(3, 33, 0);
            this.drawBoard2(3, 88, 1);
        }
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 134, 30, 15);
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawString("QUIT", 1, 136, 20);
    }

    private void drawSure() {
        this.bufferedGraphics.drawImage(this.yesno ? this.imgSureYes : this.imgSureNo, 3, this.nTheNumberOfPlayers == 1 ? 90 : 88, 20);
    }

    private void drawScore() {
        this.bufferedGraphics.drawImage(this.imgFloorWhole, 0, 0, 20);
        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
        if (this.isStrike && this.nAnimationToggle == 0) {
            if (this.nTheNumberOfPlayers == 1) {
                this.bufferedGraphics.drawImage(this.imgStrike, 10, 52, 20);
            } else {
                this.bufferedGraphics.drawImage(this.imgStrike_s, 36, 15, 20);
            }
            if (this.nSndStrike > 0) {
                this.nSndStrike = 0;
            }
        }
        switch (this.nCurrentPlayer[this.nTurnOfPlayer]) {
            case 0: {
                if (this.isClear) {
                    this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 1, 1, 20);
                } else if (this.nTempGain == 0) {
                    this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                } else {
                    this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                }
                this.bufferedGraphics.drawImage(this.imgGageHook[0], 89, 4, 20);
                break;
            }
            case 1: {
                if (this.isClear) {
                    this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 1, 1, 20);
                } else if (this.nTempGain == 0) {
                    this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                } else {
                    this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                }
                this.bufferedGraphics.drawImage(this.imgGageHook[1], 92, 4, 20);
                break;
            }
            case 2: {
                if (this.isClear) {
                    this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 1, 1, 20);
                } else if (this.nTempGain == 0) {
                    this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                } else {
                    this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                }
                this.bufferedGraphics.drawImage(this.imgGageHook[2], 89, 10, 20);
            }
        }
        int n = 9;
        while (n > -1) {
            if (this.nPinStatus[n] == 1) {
                this.bufferedGraphics.drawImage(this.imgPinSmall, nPinPosition[0][n] - 3, nPinPosition[1][n], 20);
            }
            --n;
        }
        if (this.nTheNumberOfPlayers == 1) {
            this.drawBoard2(3, 90, this.nTurnOfPlayer);
        } else {
            this.bufferedGraphics.drawImage(this.imgTextPlayer[this.nTurnOfPlayer], 3, 24, 20);
            this.bufferedGraphics.drawImage(this.imgTextPlayer[-this.nTurnOfPlayer + 1], 3, 79, 20);
            this.drawBoard2(3, 33, this.nTurnOfPlayer);
            this.drawBoard2(3, 88, -this.nTurnOfPlayer + 1);
            this.bufferedGraphics.drawImage(this.imgBoardMask, 3, 88, 20);
        }
        this.bufferedGraphics.setColor(0);
        this.bufferedGraphics.fillRect(0, 134, 30, 15);
        this.bufferedGraphics.setColor(0xFFFFFF);
        this.bufferedGraphics.drawString("QUIT", 1, 136, 20);
    }

    private void drawBoard2(int n, int n2, int n3) {
        int n4 = 0;
        this.bufferedGraphics.drawImage(this.imgBoard, n, n2, 20);
        int n5 = 0;
        while (n5 < 8) {
            if (n5 != 0) {
                if (this.nPoint_player[n3][n5 - 1] == -1) break;
                n4 = this.nPoint_player[n3][n5 - 1];
            }
            if (this.nPinGain_player[n3][n5][0] == 10) {
                this.nPinGain_player[n3][n5][1] = 0;
                if (this.nPinGain_player[n3][n5 + 1][0] == 10) {
                    if (this.nPinGain_player[n3][n5 + 2][0] != -1) {
                        this.nPoint_player[n3][n5] = n4 + this.nPinGain_player[n3][n5][0] + this.nPinGain_player[n3][n5][1] + this.nPinGain_player[n3][n5 + 1][0] + this.nPinGain_player[n3][n5 + 2][0];
                    }
                } else if (this.nPinGain_player[n3][n5 + 1][0] != -1 && this.nPinGain_player[n3][n5 + 1][1] != -1) {
                    this.nPoint_player[n3][n5] = n4 + this.nPinGain_player[n3][n5][0] + this.nPinGain_player[n3][n5][1] + this.nPinGain_player[n3][n5 + 1][0] + this.nPinGain_player[n3][n5 + 1][1];
                }
            } else if (this.nPinGain_player[n3][n5][0] + this.nPinGain_player[n3][n5][1] == 10) {
                if (this.nPinGain_player[n3][n5 + 1][0] != -1) {
                    this.nPoint_player[n3][n5] = n4 + this.nPinGain_player[n3][n5][0] + this.nPinGain_player[n3][n5][1] + this.nPinGain_player[n3][n5 + 1][0];
                }
            } else if (this.nPinGain_player[n3][n5][0] != -1 && this.nPinGain_player[n3][n5][1] != -1) {
                this.nPoint_player[n3][n5] = n4 + this.nPinGain_player[n3][n5][0] + this.nPinGain_player[n3][n5][1];
            }
            if (this.nPoint_player[n3][n5] == -1) break;
            ++n5;
        }
        if (this.nPoint_player[n3][7] != -1) {
            if (this.nPinGain_player[n3][8][0] == 10) {
                if (this.nPinGain_player[n3][9][0] != -1 && this.nPinGain_player[n3][9][1] != -1) {
                    this.nPoint_player[n3][8] = this.nPoint_player[n3][7] + 10 + this.nPinGain_player[n3][9][0] + this.nPinGain_player[n3][9][1];
                }
            } else if (this.nPinGain_player[n3][8][0] + this.nPinGain_player[n3][8][1] == 10) {
                if (this.nPinGain_player[n3][9][0] != -1) {
                    this.nPoint_player[n3][8] = this.nPoint_player[n3][7] + 10 + this.nPinGain_player[n3][9][0];
                }
            } else if (this.nPinGain_player[n3][8][0] != -1 && this.nPinGain_player[n3][8][1] != -1) {
                this.nPoint_player[n3][8] = this.nPoint_player[n3][7] + this.nPinGain_player[n3][8][0] + this.nPinGain_player[n3][8][1];
            }
            if (this.nPoint_player[n3][8] != -1 && this.nPinGain_player[n3][9][0] != -1 && this.nPinGain_player[n3][9][1] != -1) {
                if (this.nPinGain_player[n3][9][0] + this.nPinGain_player[n3][9][1] >= 10) {
                    if (this.nPinGain_player[n3][9][2] != -1) {
                        this.nPoint_player[n3][9] = this.nPoint_player[n3][8] + this.nPinGain_player[n3][9][0] + this.nPinGain_player[n3][9][1] + this.nPinGain_player[n3][9][2];
                    }
                } else {
                    this.nPoint_player[n3][9] = this.nPoint_player[n3][8] + this.nPinGain_player[n3][9][0] + this.nPinGain_player[n3][9][1];
                }
            }
        }
        int n6 = 0;
        while (n6 < 9) {
            this.nPointX = 8 + 20 * (n6 % 5) + n - 3;
            if (n6 % 5 == 4) {
                this.nPointX += 10;
            }
            this.nPointY = 104 + 19 * (n6 / 5) + n2 - 99;
            if (this.nPinGain_player[n3][n6][0] == 10) {
                this.bufferedGraphics.drawImage(this.imgScoreStrike, this.nPointX + 8, this.nPointY - 2, 20);
            } else if (this.nPinGain_player[n3][n6][0] + this.nPinGain_player[n3][n6][1] == 10) {
                this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][n6][0]], this.nPointX, this.nPointY, 20);
                this.bufferedGraphics.drawImage(this.imgScoreSpare, this.nPointX + 8, this.nPointY - 2, 20);
            } else if (this.nPinGain_player[n3][n6][1] == 0) {
                this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][n6][0]], this.nPointX, this.nPointY, 20);
                this.bufferedGraphics.drawImage(this.imgScoreMiss, this.nPointX + 8, this.nPointY - 2, 20);
            } else {
                if (this.nPinGain_player[n3][n6][0] == -1) break;
                if (this.nPinGain_player[n3][n6][1] != -1) {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][n6][0]], this.nPointX, this.nPointY, 20);
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][n6][1]], this.nPointX + 10, this.nPointY, 20);
                } else {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][n6][0]], this.nPointX, this.nPointY, 20);
                }
            }
            ++n6;
        }
        if (this.nPinGain_player[n3][9][0] == 10) {
            this.bufferedGraphics.drawImage(this.imgScoreStrike, n + 83, n2 + 22, 20);
            if (this.nPinGain_player[n3][9][1] == 10) {
                this.bufferedGraphics.drawImage(this.imgScoreStrike, n + 93, n2 + 22, 20);
                if (this.nPinGain_player[n3][9][2] == 10) {
                    this.bufferedGraphics.drawImage(this.imgScoreStrike, n + 103, n2 + 22, 20);
                } else if (this.nPinGain_player[n3][9][1] + this.nPinGain_player[n3][9][2] == 10) {
                    this.bufferedGraphics.drawImage(this.imgScoreSpare, n + 103, n2 + 22, 20);
                } else if (this.nPinGain_player[n3][9][2] != -1) {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][2]], n + 105, n2 + 24, 20);
                }
            } else if (this.nPinGain_player[n3][9][1] != -1) {
                this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][1]], n + 95, n2 + 24, 20);
                if (this.nPinGain_player[n3][9][1] + this.nPinGain_player[n3][9][2] == 10) {
                    this.bufferedGraphics.drawImage(this.imgScoreSpare, n + 103, n2 + 22, 20);
                } else if (this.nPinGain_player[n3][9][2] != -1) {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][2]], n + 105, n2 + 24, 20);
                }
            }
        } else if (this.nPinGain_player[n3][9][0] != -1) {
            this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][0]], n + 85, n2 + 24, 20);
            if (this.nPinGain_player[n3][9][0] + this.nPinGain_player[n3][9][1] == 10) {
                this.bufferedGraphics.drawImage(this.imgScoreSpare, n + 93, n2 + 22, 20);
                if (this.nPinGain_player[n3][9][2] == 10) {
                    this.bufferedGraphics.drawImage(this.imgScoreStrike, n + 103, n2 + 22, 20);
                } else if (this.nPinGain_player[n3][9][2] != -1) {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][2]], n + 105, n2 + 24, 20);
                }
            } else if (this.nPinGain_player[n3][9][1] != -1) {
                this.bufferedGraphics.drawImage(this.imgScore[this.nPinGain_player[n3][9][1]], n + 95, n2 + 24, 20);
            }
        }
        int n7 = 0;
        while (n7 < 10) {
            if (this.nPoint_player[n3][n7] == -1) break;
            this.nTempScore = this.nPoint_player[n3][n7];
            this.nPointX = 19 + 20 * (n7 % 5) + n - 3;
            if (n7 % 5 == 4) {
                this.nPointX += 10;
            }
            this.nPointY = 113 + 19 * (n7 / 5) + n2 - 99;
            int n8 = 0;
            while (n8 < 3) {
                if (this.nTempScore / 10 == 0 && this.nTempScore % 10 == 0) break;
                this.bufferedGraphics.drawImage(this.imgScore[this.nTempScore % 10], this.nPointX, this.nPointY, 20);
                this.nTempScore /= 10;
                this.nPointX -= 6;
                ++n8;
            }
            ++n7;
        }
    }

    private void attackPin_0() {
        int n;
        int[] nArray;
        if (this.nRollingBallXonLane < 52) {
            nArray = CPattern.nStraight[0];
        } else if (this.nRollingBallXonLane < 56) {
            nArray = CPattern.nStraight[1];
        } else if (this.nRollingBallXonLane < 59) {
            nArray = CPattern.nStraight[2];
        } else if (this.nRollingBallXonLane < 63) {
            nArray = CPattern.nStraight[3];
            if (this.isFirstShot) {
                if (this.nPinStatus[6] == 1 || this.nPinStatus[9] == 1) {
                    nArray = CPattern.nStraight[14];
                } else if (GameCanvas.rand(0, 2) != 0) {
                    nArray = CPattern.nStraight[14];
                }
            } else {
                n = GameCanvas.rand(-2, 7);
                if (n > 0) {
                    nArray = CPattern.nStraight[6 + n];
                }
            }
        } else {
            nArray = this.nRollingBallXonLane < 66 ? CPattern.nStraight[4] : (this.nRollingBallXonLane < 70 ? CPattern.nStraight[5] : CPattern.nStraight[6]);
        }
        n = 0;
        while (n < 10) {
            if (this.nPinStatus[n] != 0) {
                this.nPinStatus[n] = nArray[n];
            }
            ++n;
        }
    }

    private void attackPin_L1() {
        int n;
        int[] nArray;
        if (this.nRollingBallXonLane < 52) {
            nArray = CPattern.nTurnLeft1[0];
        } else if (this.nRollingBallXonLane < 56) {
            nArray = CPattern.nTurnLeft1[1];
        } else if (this.nRollingBallXonLane < 59) {
            nArray = CPattern.nTurnLeft1[2];
        } else if (this.nRollingBallXonLane < 63) {
            nArray = CPattern.nTurnLeft1[3];
        } else if (this.nRollingBallXonLane < 66) {
            nArray = CPattern.nTurnLeft1[4];
            if (this.isFirstShot) {
                if (this.nPinStatus[9] == 0) {
                    nArray = CPattern.nTurnLeft1[9];
                } else if (GameCanvas.rand(0, 2) != 0) {
                    nArray = CPattern.nTurnLeft1[9];
                }
            } else {
                n = GameCanvas.rand(-1, 2);
                if (n > 0) {
                    nArray = CPattern.nTurnLeft1[6 + n];
                }
            }
        } else {
            nArray = this.nRollingBallXonLane < 70 ? CPattern.nTurnLeft1[5] : CPattern.nTurnLeft1[6];
        }
        n = 0;
        while (n < 10) {
            if (this.nPinStatus[n] != 0) {
                this.nPinStatus[n] = nArray[n];
            }
            ++n;
        }
    }

    private void attackPin_R1() {
        int n;
        int[] nArray;
        if (this.nRollingBallXonLane < 52) {
            nArray = CPattern.nTurnRight1[0];
        } else if (this.nRollingBallXonLane < 56) {
            nArray = CPattern.nTurnRight1[1];
        } else if (this.nRollingBallXonLane < 59) {
            nArray = CPattern.nTurnRight1[2];
            if (this.isFirstShot) {
                if (this.nPinStatus[6] == 0) {
                    nArray = CPattern.nTurnRight1[9];
                } else if (GameCanvas.rand(0, 2) != 0) {
                    nArray = CPattern.nTurnRight1[9];
                }
            } else {
                n = GameCanvas.rand(-1, 2);
                if (n > 0) {
                    nArray = CPattern.nTurnRight1[6 + n];
                }
            }
        } else {
            nArray = this.nRollingBallXonLane < 63 ? CPattern.nTurnRight1[3] : (this.nRollingBallXonLane < 66 ? CPattern.nTurnRight1[4] : (this.nRollingBallXonLane < 70 ? CPattern.nTurnRight1[5] : CPattern.nTurnRight1[6]));
        }
        n = 0;
        while (n < 10) {
            if (this.nPinStatus[n] != 0) {
                this.nPinStatus[n] = nArray[n];
            }
            ++n;
        }
    }

    private void attackPin_2(int n) {
        int n2 = n = n > 0 ? 1 : 0;
        int[] nArray = this.nRollingBallXonLane < 52 ? CPattern.nTurnStrongly[n][0] : (this.nRollingBallXonLane < 56 ? CPattern.nTurnStrongly[n][1] : (this.nRollingBallXonLane < 59 ? CPattern.nTurnStrongly[n][2] : (this.nRollingBallXonLane < 63 ? CPattern.nTurnStrongly[n][3] : (this.nRollingBallXonLane < 66 ? CPattern.nTurnStrongly[n][4] : (this.nRollingBallXonLane < 70 ? CPattern.nTurnStrongly[n][5] : CPattern.nTurnStrongly[n][6])))));
        int n3 = 0;
        while (n3 < 10) {
            if (this.nPinStatus[n3] != 0) {
                this.nPinStatus[n3] = nArray[n3];
            }
            ++n3;
        }
    }

    private void attackPinFinish() {
        this.nTempGain = 0;
        int n = this.nTurnOfPlayer;
        this.nTimeOfRolling_player[n] = this.nTimeOfRolling_player[n] + 1;
        int n2 = 0;
        while (n2 < 10) {
            if (this.nPinStatus[n2] == 3 || this.nPinStatus[n2] == 6) {
                this.nPinStatus[n2] = 0;
                ++this.nTempGain;
            }
            ++n2;
        }
        if (this.nTimeOfRolling_player[this.nTurnOfPlayer] == 21) {
            this.nPinGain_player[this.nTurnOfPlayer][9][2] = this.nTempGain;
        } else {
            this.nPinGain_player[this.nTurnOfPlayer][(this.nTimeOfRolling_player[this.nTurnOfPlayer] - 1) / 2][(this.nTimeOfRolling_player[this.nTurnOfPlayer] - 1) % 2] = this.nTempGain;
        }
        this.isStrike = false;
        if (this.nTempGain == 10) {
            this.isFirstShot = true;
            switch (this.nTimeOfRolling_player[this.nTurnOfPlayer]) {
                case 19: {
                    this.isStrike = true;
                    break;
                }
                case 20: 
                case 21: {
                    if (this.nPinGain_player[this.nTurnOfPlayer][(this.nTimeOfRolling_player[this.nTurnOfPlayer] - 2) / 2][(this.nTimeOfRolling_player[this.nTurnOfPlayer] - 2) % 2] != 10) break;
                    this.isStrike = true;
                    break;
                }
                default: {
                    if ((this.nTimeOfRolling_player[this.nTurnOfPlayer] - 1) % 2 != 0) break;
                    this.nPinGain_player[this.nTurnOfPlayer][this.nTimeOfRolling_player[this.nTurnOfPlayer] / 2][this.nTimeOfRolling_player[this.nTurnOfPlayer] % 2] = 0;
                    int n3 = this.nTurnOfPlayer;
                    this.nTimeOfRolling_player[n3] = this.nTimeOfRolling_player[n3] + 1;
                    this.isStrike = true;
                }
            }
            this.callVibration(this.SLEEP_TIME + 10);
            this.SLEEP_TIME = 1500;
        } else if (this.nTempGain != 0) {
            this.callVibration(this.SLEEP_TIME + 10);
        }
    }

    private void drawEnding() {
        if (this.nTheNumberOfPlayers == 1) {
            switch (this.nCurrentPlayer[0]) {
                case 0: {
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 200) {
                        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
                        this.bufferedGraphics.drawImage(this.imgBoyAnimation[this.nAnimationToggle], 1, 1, 20);
                        break;
                    }
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 100) {
                        this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                        break;
                    }
                    this.bufferedGraphics.drawImage(this.imgBoy, 1, 1, 20);
                    break;
                }
                case 1: {
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 200) {
                        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
                        this.bufferedGraphics.drawImage(this.imgGirlAnimation[this.nAnimationToggle], 1, 1, 20);
                        break;
                    }
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 100) {
                        this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                        break;
                    }
                    this.bufferedGraphics.drawImage(this.imgGirl, 1, 1, 20);
                    break;
                }
                case 2: {
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 200) {
                        this.nAnimationToggle = -1 * (this.nAnimationToggle - 1);
                        this.bufferedGraphics.drawImage(this.imgGuyAnimation[this.nAnimationToggle], 1, 1, 20);
                        break;
                    }
                    if (this.nPoint_player[this.nTurnOfPlayer][9] > 100) {
                        this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                        break;
                    }
                    this.bufferedGraphics.drawImage(this.imgGuy, 1, 1, 20);
                }
            }
            this.bufferedGraphics.drawImage(this.imgTotal, 19, 48, 20);
            this.nTempScore = this.nPoint_player[this.nTurnOfPlayer][9];
            int n = 0;
            while (n < 3) {
                if (this.nTempScore / 10 != 0 || this.nTempScore % 10 != 0) {
                    this.bufferedGraphics.drawImage(this.imgScore[this.nTempScore % 10], 79 - n * 7, 56, 20);
                    this.nTempScore /= 10;
                    ++n;
                    continue;
                }
                break;
            }
        } else {
            this.drawVersus();
            if (this.nPoint_player[0][9] < this.nPoint_player[1][9]) {
                switch (this.nCurrentPlayer[0]) {
                    case 0: {
                        this.bufferedGraphics.drawImage(this.imgBoy, 9, 47, 20);
                        break;
                    }
                    case 1: {
                        this.bufferedGraphics.drawImage(this.imgGirl, 9, 47, 20);
                        break;
                    }
                    case 2: {
                        this.bufferedGraphics.drawImage(this.imgGuy, 9, 47, 20);
                    }
                }
                this.bufferedGraphics.drawImage(this.imgTextLose, 26, 44, 33);
                this.bufferedGraphics.drawImage(this.imgTextWin, 92, 44, 33);
            } else if (this.nPoint_player[0][9] > this.nPoint_player[1][9]) {
                switch (this.nCurrentPlayer[1]) {
                    case 0: {
                        this.bufferedGraphics.drawImage(this.imgBoy, 75, 47, 20);
                        break;
                    }
                    case 1: {
                        this.bufferedGraphics.drawImage(this.imgGirl, 75, 47, 20);
                        break;
                    }
                    case 2: {
                        this.bufferedGraphics.drawImage(this.imgGuy, 75, 47, 20);
                    }
                }
                this.bufferedGraphics.drawImage(this.imgTextWin, 26, 44, 33);
                this.bufferedGraphics.drawImage(this.imgTextLose, 92, 44, 33);
            }
            int n = 0;
            while (n < 2) {
                this.bufferedGraphics.drawImage(this.imgScoreBox, 14 + 66 * n, 86, 20);
                this.nTempScore = this.nPoint_player[n][9];
                int n2 = 0;
                while (n2 < 3) {
                    if (this.nTempScore / 10 == 0 && this.nTempScore % 10 == 0) break;
                    this.bufferedGraphics.drawImage(this.imgScore[this.nTempScore % 10], 31 - n2 * 5 + n * 66, 90, 20);
                    this.nTempScore /= 10;
                    ++n2;
                }
                ++n;
            }
        }
    }

    private void changeClip(int n, int n2, int n3, int n4) {
        clipx = n;
        clipy = n2;
        clipw = n3;
        cliph = n4;
    }

    private int convertPositionToRealPower(int n) {
        int n2 = 0;
        while (n2 < nPowerEachIndex.length) {
            if (n == nPowerEachIndex[n2]) {
                return 100 - n2 * 15;
            }
            ++n2;
        }
        return 10;
    }
}

