/*
 * Decompiled with CFR 0.152.
 */
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextField;

public class GameScreen
extends Canvas {
    public static final int MODE_PLAY = 0;
    public static final int MODE_PAUSE = 1;
    public static final int MODE_LEVELSTART = 2;
    public static final int MODE_LEVELEND = 3;
    public static final int MODE_DEAD = 4;
    public static final int MODE_GAMEOVER = 5;
    public static final int MODE_MENU = 6;
    private MenuScreen menuScreen;
    Player player;
    Playfield playfield;
    Enemies enemies;
    Image buffer;
    Graphics bufG;
    public int mode;
    public int cnt;
    private int drawWidth;
    private int drawHeight;
    public int level;
    private int menuItemFocus;
    private int menuItems;
    private int menuImageY = 32;
    private int lastScore = 0;
    Timer frameUpdateTimer;
    Timer gameUpdateTimer;
    static GameScreen instance;
    private TextField nameField;

    public GameScreen(MenuScreen menuScreen) {
        this.menuScreen = menuScreen;
        try {
            this.drawWidth = Math.min(this.getWidth(), 162);
            this.drawHeight = Math.min(this.getHeight(), 162);
            instance = this;
            this.jbInit();
            this.newGame();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.player = new Player(instance);
        this.playfield = new Playfield(28, 28);
        this.enemies = new Enemies(25);
        this.player.playfield = this.playfield;
        this.playfield.player = this.player;
        this.playfield.setDrawDimensions(this.drawWidth, this.drawHeight);
        this.playfield.enemies = this.enemies;
        this.enemies.playfield = this.playfield;
        this.enemies.player = this.player;
        this.frameUpdateTimer = new Timer();
        this.frameUpdateTimer.schedule((TimerTask)new FrameUpdateTask(), 0L, 50L);
        System.out.println("Starting frame update");
    }

    public void newGame() {
        this.player.reset();
        this.level = 0;
        this.nextLevel();
    }

    public void nextLevel() {
        ++this.level;
        this.playfield.reset();
        this.playfield.loadLevel(this.level);
        this.player.resetPos();
        this.mode = 2;
        this.cnt = 10;
    }

    public void levelClear() {
        this.stopGameUpdate();
        this.mode = 3;
        this.cnt = 20;
    }

    public void showMenu() {
        this.menuScreen.showMenu();
    }

    public void showGameOver(int n) {
        this.lastScore = n;
        if (this.menuScreen.hs.isHighScore(n)) {
            GameMidlet.instance.setDisplayable((Displayable)this.menuScreen.nameForm);
        } else {
            this.showMenu();
        }
    }

    public void keyPressed(int n) {
        switch (this.mode) {
            case 0: {
                this.keyPressedPlayMode(n);
                break;
            }
            case 2: {
                if (this.cnt != 0) break;
                this.mode = 0;
                System.out.println("Starting game update (keypressed - levelstart)");
                this.startGameUpdate();
                break;
            }
            case 5: {
                this.showGameOver(this.player.points);
                break;
            }
            case 1: {
                this.mode = 0;
                System.out.println("Starting game update (keypressed - pause)");
                this.startGameUpdate();
            }
        }
    }

    private void keyPressedPlayMode(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.player.moveLeft = true;
                this.player.moveRight = false;
                this.player.moveLeftOnce = true;
                return;
            }
            case 5: {
                this.player.moveRight = true;
                this.player.moveLeft = false;
                this.player.moveRightOnce = true;
                return;
            }
            case 6: {
                this.player.moveDown = true;
                this.player.moveUp = false;
                this.player.moveDownOnce = true;
                return;
            }
            case 1: {
                this.player.moveUp = true;
                this.player.moveDown = false;
                this.player.moveUpOnce = true;
                return;
            }
            case 8: {
                this.player.fireOnce = true;
                return;
            }
        }
        if (n == 48) {
            this.mode = 1;
            this.stopGameUpdate();
        } else if (n != 51) {
            if (n == 55) {
                this.player.fireExtra = true;
                this.player.fireExtraOnce = true;
            } else {
                this.menuScreen.showMenu();
            }
        }
    }

    private void keyReleasedPlayMode(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                this.player.moveLeft = false;
                break;
            }
            case 5: {
                this.player.moveRight = false;
                break;
            }
            case 6: {
                this.player.moveDown = false;
                break;
            }
            case 1: {
                this.player.moveUp = false;
                break;
            }
            case 8: {
                this.player.fire = false;
                break;
            }
        }
        if (n == 55) {
            this.player.fireExtra = false;
        }
    }

    public void keyReleased(int n) {
        switch (this.mode) {
            case 0: {
                this.keyReleasedPlayMode(n);
            }
        }
    }

    protected void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (this.buffer == null) {
            this.buffer = Image.createImage((int)this.drawWidth, (int)this.drawHeight);
            this.bufG = this.buffer.getGraphics();
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        switch (this.mode) {
            case 0: {
                this.renderPlayMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 2: {
                this.renderLevelStartMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 5: {
                this.renderGameOverMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 3: {
                this.renderLevelEndMode(this.bufG);
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                break;
            }
            case 1: {
                graphics.drawImage(this.buffer, n / 2, n2 / 2, 3);
                graphics.setColor(0, 0, 0);
                graphics.fillRect(n / 2 - 40, n2 / 2 - 10, 80, 20);
                graphics.setColor(100, 200, 250);
                graphics.drawString(this.menuScreen.Texts[14], n / 2, n2 / 2, 65);
            }
        }
        if (this.cnt > 0) {
            --this.cnt;
        }
        if (this.mode == 3 && this.cnt == 0) {
            this.nextLevel();
        }
    }

    private void renderPlayMode(Graphics graphics) {
        this.playfield.updateScreen(graphics);
    }

    public void renderLevelStartMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(200, 180, 160);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.menuScreen.Texts[32]))).append(" ").append(this.level))), this.drawWidth / 2, this.drawHeight / 2, 65);
        graphics.drawString(this.menuScreen.Texts[34], this.drawWidth / 2, this.drawHeight / 2 + 16, 65);
    }

    public void renderGameOverMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.setClip(0, 0, this.drawWidth, this.drawHeight);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(200, 180, 160);
        graphics.drawString(this.menuScreen.Texts[16], this.drawWidth / 2, this.drawHeight / 2 - 10, 65);
        graphics.setColor(100, 180, 200);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.menuScreen.Texts[33]))).append(": ").append(this.player.points))), this.drawWidth / 2, this.drawHeight / 2 + 10, 65);
    }

    public void renderLevelEndMode(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.drawWidth, this.drawHeight);
        graphics.setColor(100, 200, 250);
        graphics.drawString(this.menuScreen.Texts[31], this.drawWidth / 2, this.drawHeight / 2, 65);
        graphics.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.menuScreen.Texts[33]))).append(": ").append(Integer.toString(this.player.points)))), this.drawWidth / 2, this.drawHeight / 2 + 16, 65);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateAll() {
        this.repaint();
    }

    private void startGameUpdate() {
        try {
            this.gameUpdateTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.gameUpdateTimer = new Timer();
            this.gameUpdateTimer.schedule((TimerTask)new GameUpdateTask(), 0L, 100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopGameUpdate() {
        try {
            System.out.println("Stopping game update");
            this.gameUpdateTimer.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void showNotify() {
        if (this.mode == 0) {
            System.out.println("Starting game update (showNotify)");
            this.startGameUpdate();
        }
    }

    protected void hideNotify() {
        this.stopGameUpdate();
    }

    static {
        MODE_PLAY = 0;
        MODE_PAUSE = 1;
        MODE_LEVELSTART = 2;
        MODE_LEVELEND = 3;
        MODE_DEAD = 4;
        MODE_GAMEOVER = 5;
        MODE_MENU = 6;
    }

    class GameUpdateTask
    extends TimerTask {
        public void run() {
            GameScreen.this.player.update();
            GameScreen.this.playfield.update();
        }
    }

    class FrameUpdateTask
    extends TimerTask {
        public void run() {
            GameScreen.this.updateAll();
        }
    }
}

