/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class MenuScreen
extends Canvas
implements CommandListener {
    public String[] Texts = new String[]{"PLAY", "OK", "RESUME", "HIGH SCORES", "Your name", "HELP", "SETTINGS", "QUIT", "Difficulty", "Beginner", "Intermediate", "Game Addict", "Guru", "God", "Paused", "New high score!", "Game Over", "Use the navigational keys to move within the game. ", "Use the '2' key to move up, '8' to move down, '4' key to move left, '6' key to move right and the '5' key to drop a bomb. ", "Your character is equipped with bombs that can be placed on any floor tile. ", "A dropped bomb explodes after a short period of time.  ", "The explosion will spread flames in all four directions destroying the monsters. ", "Some monsters require more than one bomb to destroy. ", "Most of the walls and other stationary objects can be broken or otherwise manipulated by using the bombs.  ", "Use good judgment when dropping bombs, as there is a limit to the amount of bombs that can be dropped at one time.", "", "", "", "", "", "", "Level Clear", "Level ", "Score", "Press any key", "ABOUT", "BACK"};
    public static final byte MODE_MENU = 1;
    private byte mode;
    private Command quitComm;
    private Command backComm;
    private Command okComm;
    private Command continueGameComm;
    private Command newGameComm;
    private Command instructionsComm;
    private Command highScoresComm;
    private Command settingsComm;
    private Command aboutComm;
    private Form highScoresForm;
    private Form instructionsForm;
    private Form settingsForm;
    private Form aboutForm;
    public Form nameForm;
    private TextField nameField;
    public ChoiceGroup balls;
    public ChoiceGroup difficulty;
    public HighScores hs;
    private String[] ballStrings = new String[]{"2", "3"};
    private String[] difficultyStrings = new String[]{this.Texts[9], this.Texts[10], this.Texts[11], this.Texts[12], this.Texts[13]};
    public GameScreen gameScreen;
    private Image splashScreen;

    public MenuScreen() {
        this.setCommandListener(this);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        try {
            this.gameScreen = new GameScreen(this);
            LanguageLoader languageLoader = new LanguageLoader();
            String[] stringArray = languageLoader.ReadLangFile(37);
            if (stringArray != null) {
                this.Texts = stringArray;
            }
            this.difficultyStrings[0] = this.Texts[9];
            this.difficultyStrings[1] = this.Texts[10];
            this.difficultyStrings[2] = this.Texts[11];
            this.difficultyStrings[3] = this.Texts[12];
            this.difficultyStrings[4] = this.Texts[13];
            this.splashScreen = GameMidlet.getImage("splash");
            this.quitComm = new Command(this.Texts[7], 6, 10);
            this.backComm = new Command(this.Texts[36], 2, 1);
            this.okComm = new Command(this.Texts[1], 4, 1);
            this.continueGameComm = new Command(this.Texts[2], 1, 2);
            this.newGameComm = new Command(this.Texts[0], 1, 3);
            this.settingsComm = new Command(this.Texts[7], 1, 4);
            this.instructionsComm = new Command(this.Texts[5], 1, 5);
            this.highScoresComm = new Command(this.Texts[3], 1, 6);
            this.aboutComm = new Command(this.Texts[35], 1, 7);
            this.aboutForm = new Form(this.Texts[35]);
            this.aboutForm.append("B-Man\nVersion:\n 1.12.11\nCopyright:\n Tracebit Ltd");
            this.aboutForm.addCommand(this.backComm);
            this.aboutForm.setCommandListener((CommandListener)this);
            this.highScoresForm = new Form(this.Texts[3]);
            this.highScoresForm.addCommand(this.backComm);
            this.highScoresForm.setCommandListener((CommandListener)this);
            this.hs = HighScores.loadHighScores();
            this.settingsForm = new Form(this.Texts[6]);
            this.settingsForm.addCommand(this.backComm);
            this.settingsForm.setCommandListener((CommandListener)this);
            this.nameForm = new Form(this.Texts[15]);
            this.nameField = new TextField(this.Texts[4], "", 10, 0);
            this.nameForm.append((Item)this.nameField);
            this.nameForm.addCommand(this.okComm);
            this.nameForm.setCommandListener((CommandListener)this);
            this.instructionsForm = new Form(this.Texts[5]);
            this.instructionsForm.append(String.valueOf(String.valueOf(this.Texts[17])).concat(String.valueOf(String.valueOf(this.Texts[18]))));
            this.instructionsForm.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.Texts[19]))).append(this.Texts[20]).append(this.Texts[21]).append(this.Texts[22]))));
            this.instructionsForm.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.Texts[23]))).append(this.Texts[24]).append(this.Texts[25]).append(this.Texts[26]))));
            this.instructionsForm.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.Texts[27]))).append(this.Texts[28]).append(this.Texts[29]).append(this.Texts[30]))));
            this.instructionsForm.addCommand(this.backComm);
            this.instructionsForm.setCommandListener((CommandListener)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void commandAction(Command command, Displayable displayable) {
        try {
            if (command.getCommandType() == 6) {
                GameMidlet.quitApp();
            } else if (command == this.continueGameComm) {
                this.continueGame();
            } else if (command == this.newGameComm) {
                this.newGame();
            } else if (command == this.instructionsComm) {
                this.showInstructions();
            } else if (command == this.settingsComm) {
                this.showSettings();
            } else if (command == this.highScoresComm) {
                this.showHighScores();
            } else if (command == this.aboutComm) {
                this.showAbout();
            } else if (command == this.backComm) {
                if (displayable == this.highScoresForm || displayable == this.instructionsForm || displayable == this.settingsForm || displayable == this.aboutForm) {
                    this.showMenu();
                }
            } else if (command == this.okComm && displayable == this.nameForm) {
                this.hs.setHighScore(this.gameScreen.player.points, this.nameField.getString());
                this.showHighScores();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showMenu() {
        try {
            this.removeCommand(this.okComm);
            this.removeCommand(this.backComm);
            this.addCommand(this.newGameComm);
            this.addCommand(this.instructionsComm);
            this.addCommand(this.highScoresComm);
            this.addCommand(this.aboutComm);
            this.addCommand(this.quitComm);
            this.mode = 1;
            GameMidlet.instance.setDisplayable((Displayable)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void showAbout() {
        GameMidlet.instance.setDisplayable((Displayable)this.aboutForm);
    }

    public void showInstructions() {
        GameMidlet.instance.setDisplayable((Displayable)this.instructionsForm);
    }

    public void showSettings() {
        GameMidlet.instance.setDisplayable((Displayable)this.settingsForm);
    }

    public void showHighScores() {
        try {
            int n;
            for (n = this.highScoresForm.size(); n > 0; --n) {
                this.highScoresForm.delete(0);
            }
            for (n = 0; n < 10; ++n) {
                this.highScoresForm.append(String.valueOf(String.valueOf(new StringBuffer("").append(n + 1).append(". ").append(this.hs.getScore(n)).append(" ").append(this.hs.getName(n)).append('\n'))));
            }
            GameMidlet.instance.setDisplayable((Displayable)this.highScoresForm);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void newGame() {
        block10: {
            block9: {
                try {
                    this.removeCommand(this.newGameComm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.removeCommand(this.instructionsComm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.removeCommand(this.highScoresComm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.gameScreen.mode == 5) break block9;
                if (this.gameScreen.mode != 2 || this.gameScreen.level != 1 || this.gameScreen.player.points != 0) break block10;
            }
            this.gameScreen.newGame();
        }
        GameMidlet.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void continueGame() {
        try {
            this.removeCommand(this.newGameComm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeCommand(this.instructionsComm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeCommand(this.highScoresComm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        GameMidlet.instance.setDisplayable((Displayable)this.gameScreen);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    protected void paint(Graphics graphics) {
        this.renderMenuMode(graphics);
    }

    private void renderMenuMode(Graphics graphics) {
        try {
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics.setColor(0, 0, 0);
            graphics.fillRect(0, 0, n, n2);
            graphics.drawImage(this.splashScreen, n / 2, n2 / 2, 3);
            graphics.setColor(255, 255, 255);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanUp() {
    }

    static {
        MODE_MENU = 1;
    }
}

