/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Playfield {
    int levPtr;
    String lev;
    String[] levels = new String[]{"10;9;AAAAAAAAAAAKCKCKCKCKAAAAAAAAAAKCKCKCKCKAAAAAAAAAAAAKCKCKCKCKAAAAAAAAAAKCKCKCKCKAGAAAAAAAAAM5,6,5;1,6,4;4,4,3;9,3,2;5,2,4;9,0,6;M", "10;9;AAAAAAAAAAAKAKCKCKAKAAKAAKAAKAKAKAKGKAKAAAAAAAAAAAAKAKCKCKAKAAKAAKAAKAKAKAKAKAKAAAAAAAAAAAM2,5,2;8,5,2;8,1,2;2,1,2;5,7,5;5,0,5;5,4,6;1,2,4;7,2,4;7,6,4;1,6,4;M", "11;10;BAAAABAAAABBACAAKAACABAABBAAABBAAAABAABAABAABAAACBCAAABBAAACBCAAABAABAABAABAAUABBAGABBAABACAAKAACABBAAAABAAAABM5,2,6;10,6,1;0,6,1;0,3,2;10,3,2;7,1,2;3,1,2;3,6,2;7,6,2;2,4,4;8,4,4;M", "10;10;BACABBACABAAAAAAAAAABCBBCCBBCBAAAAAAAAAABAKABBAKABBAACBBCAABPAAAAAAAAABABBCCBBCBACAAAAAAQGBAAABBAAABM1,0,6;5,1,2;9,1,2;3,6,2;6,6,2;5,8,2;4,8,2;4,1,2;4,3,2;5,3,2;1,6,3;8,6,3;8,3,4;1,3,4;M", "10;10;AAAAAAAAAAABABABABABACAKAKACAAABABABABABACAKUKACAAABABABABABACAKAKACAAABABABABABAAAAAAAACCABABABABCHM0,0,6;9,2,2;9,4,2;9,6,2;6,9,2;4,9,2;2,9,2;2,6,5;4,6,5;6,6,5;2,2,4;4,2,4;6,2,4;M", "10;10;KAAACAAAAKAKABBBAPKAAAAAIAAKAAACAAAAAAAABCBCBCBCBAACKAAAACAAACAAIAAAABAAABBBAKAAAKAACAAAKAKUAACACAGKM1,0,6;9,1,2;9,8,2;0,8,2;0,1,2;0,3,4;0,5,3;5,0,4;8,2,5;6,5,5;5,9,5;3,9,5;M", "10;10;BABBBBBBABAAABABAAAAABAAACAABAAABBKBBBAABABAAAABABBCBAAGABABBABAAAABABAABBBBBBCAABACAACABAAAABBABAAAM9,9,6;0,9,1;1,0,7;8,0,8;1,3,8;9,3,8;4,1,3;5,9,2;2,8,2;4,5,4;3,5,2;6,5,2;6,4,7;M", "10;10;ABBABAKAABACAAAABBAAABBABAACAAABBCBABBABAIAABABBCACBBAGACAABABBABABBAAACAABABBABABBAAAKAAAAACABABBABM0,0,6;9,1,8;5,0,8;9,8,2;9,6,2;2,7,3;5,6,4;5,2,4;0,4,2;1,9,5;M", "10;10;UAAABBAAAIABAAKCAABAAABAAAABAAAAABAABAAGBCAABBAACBBKAPBBAAKBAAABAABAAAAABAAAABAAABAACKAABSAAAABBAAAAM0,9,6;9,1,1;3,0,1;8,9,2;4,6,2;4,3,2;7,3,3;9,6,4;0,3,4;7,0,7;6,9,8;0,1,8;M", "10;9;ACAAAAAACAABABBABABAAAACAACAAACBABABBABCAAACAGCAAACBABBABABCAAACAACAAAABABABBABAACAAAAAACAM4,4,6;7,6,8;7,2,8;2,2,8;2,6,8;M", "22;22;AAAABBBBBBBBBBBAAAAAAAAAAABAAAABBBBBBAAABAAAAAAACAAAABAAAABBBBBAAAAAAABAAAACAAAABAAAABBABBCBBAAAABAAAACAAAABBABAAAABBBBBAAAABAAAAQAABAAAABAAAABBBBBAAAABBBBAAAABAAAABAAABBBCBBBBBAAAABAAAAAABAABAAAABBBBBCBBAAAABAAAABAAAABBBBAAAABBABBBBAAQAAAABBBBAAAABAAAAAAAABAAAABBBBAAAABABABBBCBBBBCBBBBBAAAABAAAAACAAABAAAABBBBBCBBBAAAABABABAAAABBBBAAAABBBBBBAAUBAAAABBBBAAAABAAAABBBBBAAAABBBBAAAACAAAABAAAABBCBBBBBAAAABAAAACAAAABAAAAAAABBSBBAAAABAAAACAAAAABAAAABBBBBBBAAAABAAAAAAABBBBBBBBBBBBBBBAAAAM6,6,2;6,7,2;7,6,2;9,6,2;6,9,2;1,6,8;4,7,8;3,6,4;5,3,4;6,1,8;8,2,8;11,3,5;13,5,5;4,10,5;2,13,5;5,16,7;3,17,7;17,4,7;15,6,7;9,18,3;10,16,2;10,19,2;17,10,3;19,9,2;19,11,2;4,12,2;12,3,2;3,15,1;4,18,1;18,6,1;15,4,1;9,9,2;M", "17;17;AAAAAAAAAAAAAAAAAABABBBBABABBBBABAAAABAAAAAAAAABAAAABABABABBBBBABABAABABABAAAAABABABAABAAABBBABABAAABAABBBABAAAAABABBBAAAABAAABABAAABAAAABABABAAGAABABABAAAABAAABABAAABAAAABBBABAAAAABABBBAABAAABABABBBAAABAABABABAAAAABABABAABABABBBBBABABABAAAABAAAAAAAAABAAAABABBBBABABBBBABAAAAAAAAAAAAAAAAAAM8,9,6;4,14,8;12,14,8;12,8,8;12,2,8;4,2,8;4,8,8;8,4,8;8,12,8;2,11,4;2,5,4;14,5,4;14,11,4;16,16,4;16,0,4;0,0,4;0,16,4;2,9,2;2,7,2;14,7,2;14,9,2;M", "19;19;AAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBSSBABAAABAAAAAABAAAAABAAABAQAAABABBAAAAABBBABABAABAAABABBAAABBABABABBAOABAAABBNBAAAABAABAAABBAOBAABAAABBAAABBBAQAABAUBAAAAABAABBAABBBBBBBABABAABBBBAGABAAABAAAAAABANABBAABABAAAAAABBBABAAQABBAAABAAAAAABABOABBAAABBBBABABAAABBBABAAABUABAAAAAAAAAAABAAABAABAAABABBABBBBBBBBBCBCBAAABAAABAAAAAAAAAAAABAAAAACABCBABABCBAAAABAAABAAAAAAAAAAAM11,13,6;15,6,2;14,6,2;14,7,2;14,14,2;15,14,2;15,13,2;10,16,8;14,18,8;17,18,8;17,10,4;14,16,4;8,17,4;18,6,1;1,5,1;4,3,1;7,4,1;5,8,1;11,6,1;11,2,1;5,18,1;4,14,4;4,10,4;0,11,8;0,16,8;2,14,8;9,0,1;2,0,1;MTs12,6:2,3;s6,12:13,1;s6,12:14,1;s7,5:10,7;s7,5:8,11;T", "10;15;AAAAAAAACAABABABBABAACAAAACAAAABABBBBABAAAACAAAACAABABBABABAACAAAAAAAABBCBBBBCBBAAAAAABAAAABABBABABAABAAAABAAAAAAABABBBCABBABABAAAAAAAAABAGABBBBBACAAAM3,2,6;5,8,4;0,11,8;0,6,8;1,0,8;6,0,8;9,6,8;5,12,7;2,11,7;9,4,8;M", "18;9;AABAAAAABAABABABAAAAAABBBAAAABAAABAABAABAAABAAABCBACAABABAAAAABABBAAABBABACAABAACAACABAACGBABAAAAABABBAAABBABAABAAABAAABCBACAAAAAABBBAAAABAAABAAAABAAAAABAABABABAAM9,0,1;8,6,1;10,6,1;6,0,1;3,7,1;6,4,4;4,3,4;5,3,8;5,5,8;4,5,8;6,3,8;17,5,5;17,3,5;14,1,5;14,7,5;0,0,6;M", "16;20;AAABAAABBAAABAAAAAACABAAAABACAOAAAABAAAAAAAABAAABBBBBBBAABBBBBBBAAAAAABAABAAAAAABBBBBBBSSBBBBBBBAAAAQAAAAAAQAAAAABABBAAAAAABBABAAAABACBAABCABAAAABBBACAAAACABBBAABAAABAAAABCBABAABAAABAAAABAAABAAQABBBBBBBBABAQAABAAAABAAAAACABAABAABABABABABABAABAAAABAAACAAABAABBBABBBBBBABBBAAAABOBAAAABOBAAAABABBBAAAABBBABAAAAAAAABBAAAAAAAM1,1,6;15,16,7;9,17,7;6,17,7;5,13,5;3,13,5;9,13,5;7,13,5;9,10,4;6,10,4;11,2,5;11,1,5;11,0,5;15,9,3;0,9,3;0,16,7;8,9,5;MTs14,1:8,5,7,5;s11,17:14,12,1,12;s4,17:11,6,4,6;T", "12;12;AABBAABBBAAAAAAAAAAACABABBAABBABCAOAAABBAAAACBBCAAACABABBAAAABACAAAACABAAABBBBAACAAAAAACAABABBNBBAACAAAABAAGBSBBABBABAAGAAABAAAABBNBUAUBBBAACAAAM0,0,6;9,0,1;11,0,1;11,2,1;4,3,8;7,5,8;7,8,8;0,6,8;11,5,8;6,10,7;1,8,7;7,11,1;MTc0,11:2;c2,11:8;s10,2:1,9;T", "11;20;AAAAAAAAAAABCBBOBBBBBAAAABABUAABAAAABABUAANAAUUBABOAABCCBBBSBBBBBAABAAAAABAAAABABAAABABAABAAABABAAAABOBAAABABBABAAABABAAAAKAAAAIBABABBBBKBBBAAAAAAAAAAQAAAABBCBBBBBBBABAAABABAAAABAAAKAKAHAABAAABABAAAABBBBBCBBABAAAAAQAAAAAM0,3,3;4,15,5;4,17,5;2,17,5;2,15,5;8,11,1;10,11,1;10,7,1;8,7,1;3,8,4;5,9,4;1,3,7;2,3,3;7,2,7;7,3,3;7,4,7;MTs4,1:4,5;s6,4:5,19;c1,4:8;c2,4:1;c6,2:6;c6,3:8;s2,9:7,13;T"};
    public static final byte EMPTY = 0;
    public static final byte WALL = 1;
    public static final byte BRICK = 2;
    public static final byte BRICK_BREAK = 3;
    public static final byte FLAME = 4;
    public static final byte POWERUP = 5;
    public static final byte CLOSED_DOOR = 6;
    public static final byte OPEN_DOOR = 7;
    public static final byte SPAWNER = 8;
    public static final byte SPAWNER_BREAK = 9;
    public static final byte ROCK = 10;
    public static final byte ROCK_BREAK = 11;
    public static final byte GATE_OPEN = 12;
    public static final byte GATE_CLOSED = 13;
    public static final byte SWITCH_OFF = 14;
    public static final byte SWITCH_ON = 15;
    public static final byte SGATEV_CLOSED = 16;
    public static final byte SGATEV_OPEN = 17;
    public static final byte SGATEH_CLOSED = 18;
    public static final byte SGATEH_OPEN = 19;
    public static final byte CHEST = 20;
    public static final byte TREASURE = 21;
    boolean[] passableTiles = new boolean[]{true, false, false, false, true, true, true, true, false, false, false, false, true, false, true, true, false, true, false, true, false, true};
    public static final byte BOMB = 101;
    public static final byte RINGBOMB = 104;
    public static final byte POWERBOMB = 105;
    public static final byte BRANCHBOMB = 106;
    public static final byte HUGEBOMB = 107;
    public static final int TILESIZE = 16;
    public static final byte POWER_BOMB = 1;
    public static final byte POWER_FLAME = 2;
    public static final byte POWER_FOOT = 3;
    public static final byte POWER_RINGBOMB = 4;
    public static final byte POWER_POWERBOMB = 5;
    public static final byte POWER_BRANCHBOMB = 6;
    public static final byte POWER_HUGEBOMB = 7;
    public static final byte GOLD = 8;
    public static final byte EFF_NONE = 0;
    public static final byte EFF_BURN = 10;
    public static final byte EFF_EXIT = 11;
    private static final int SPAWNRATE = 120;
    public static final byte FIRE_NONE = 0;
    public static final byte FIRE_STRAIGHT = 1;
    public static final byte FIRE_FLAMECAST = 2;
    public static final byte FIRE_POWER = 3;
    public static final byte FIRE_BRANCH = 4;
    private static final int numFires = 28;
    private Fire[] fires;
    int firstEmpty;
    int width;
    int height;
    int pwidth;
    int pheight;
    int drawWidth;
    int drawHeight;
    int pAnim;
    int bombs;
    byte[][] grid;
    byte[][] cnt;
    byte[][] occ;
    byte[][] trace;
    boolean levelClear;
    byte levelObjective;
    int switchActivationId;
    int nextSwitchActivationId;
    public Player player;
    public Enemies enemies;
    public static final byte OBJECTIVE_NONE = 0;
    public static final byte OBJECTIVE_COLLECT = 1;
    public static final byte OBJECTIVE_CLEAN = 2;
    Image floorIm;
    Image brickIm;
    Image closedDoorIm;
    Image openDoorIm;
    Image chestIm;
    Image treasureIm;
    Image wallIm;
    Image bombIm;
    Image flameIm;
    Image powerIm;
    Image rockIm;
    Image spawnerIm;
    Image[] gateIm;
    Image[] icons;
    Image[] switchIm;
    Image[] powerItemIm;
    Image[] sgateIm;

    public int decodeFire(InputStream inputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            int n5 = this.addFire(by, n, n2, n3, n4, by2);
            return n5;
        }
        catch (IOException iOException) {
            int n = -1;
            return n;
        }
    }

    public boolean encodeAllFires(OutputStream outputStream) {
        try {
            int n;
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeInt(28);
            for (n = 0; n < 28; ++n) {
                if (this.fires[n].type == 0) continue;
                this.fires[n].encode(outputStream);
            }
            n = 1;
            return n != 0;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean decodeAllFires(InputStream inputStream) {
        try {
            int n;
            this.reset();
            DataInputStream dataInputStream = new DataInputStream(inputStream);
            int n2 = dataInputStream.readInt();
            for (n = 0; n < n2; ++n) {
                if (this.decodeFire(inputStream) != -1) continue;
                boolean bl = false;
                return bl;
            }
            n = 1;
            return n != 0;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    public int addFire(byte by, int n, int n2, int n3, int n4, byte by2) {
        int n5;
        for (n5 = this.firstEmpty; n5 < 28 && this.fires[n5].type != 0; ++n5) {
        }
        if (n5 == 28) {
            return -1;
        }
        this.fires[n5].type = by;
        this.fires[n5].x = n;
        this.fires[n5].y = n2;
        this.fires[n5].xsp = n3;
        this.fires[n5].ysp = n4;
        this.fires[n5].cnt = by2;
        this.firstEmpty = n5;
        return n5;
    }

    private void removeFire(int n) {
        this.fires[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    private void resetFires() {
        for (int i = 0; i < 28; ++i) {
            this.fires[i].type = 0;
        }
        this.firstEmpty = 0;
    }

    public byte[] encode() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.pwidth);
            dataOutputStream.writeInt(this.pheight);
            dataOutputStream.writeInt(this.drawWidth);
            dataOutputStream.writeInt(this.drawHeight);
            dataOutputStream.writeInt(this.pAnim);
            dataOutputStream.writeInt(this.bombs);
            dataOutputStream.writeBoolean(this.levelClear);
            dataOutputStream.writeByte(this.levelObjective);
            for (int i = 0; i < this.height; ++i) {
                ((OutputStream)dataOutputStream).write(this.grid[i]);
                ((OutputStream)dataOutputStream).write(this.cnt[i]);
                ((OutputStream)dataOutputStream).write(this.occ[i]);
                ((OutputStream)dataOutputStream).write(this.trace[i]);
            }
            this.encodeAllFires(dataOutputStream);
            this.enemies.encodeAllEnemies(dataOutputStream);
            this.player.encode(dataOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray2 = "Hello".getBytes();
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    public boolean decode(byte[] byArray) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            this.width = dataInputStream.readInt();
            this.height = dataInputStream.readInt();
            this.pwidth = dataInputStream.readInt();
            this.pheight = dataInputStream.readInt();
            this.drawWidth = dataInputStream.readInt();
            this.drawHeight = dataInputStream.readInt();
            this.pAnim = dataInputStream.readInt();
            this.bombs = dataInputStream.readInt();
            this.levelClear = dataInputStream.readBoolean();
            this.levelObjective = dataInputStream.readByte();
            for (int i = 0; i < this.height; ++i) {
                dataInputStream.read(this.grid[i], 0, this.width);
                dataInputStream.read(this.cnt[i], 0, this.width);
                dataInputStream.read(this.occ[i], 0, this.width);
                dataInputStream.read(this.trace[i], 0, this.width);
            }
            byte[] byArray2 = new byte[dataInputStream.available()];
            dataInputStream.read(byArray2);
            this.decodeAllFires(dataInputStream);
            this.enemies.decodeAllEnemies(dataInputStream);
            this.player.decode(dataInputStream);
            dataInputStream.close();
            byteArrayInputStream.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            boolean bl = false;
            return bl;
        }
    }

    private void openStr(String string) {
        this.lev = string;
        this.levPtr = 0;
    }

    private int readNext() {
        if (this.levPtr >= this.lev.length()) {
            return -1;
        }
        return this.lev.charAt(this.levPtr++);
    }

    public void loadLevel(int n) {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            if (--n >= this.levels.length) {
                n = this.levels.length - 1;
            }
            this.openStr(this.levels[n]);
            StringBuffer stringBuffer = new StringBuffer();
            while ((n5 = this.readNext()) != 59) {
                stringBuffer.append((char)n5);
            }
            this.width = Integer.parseInt(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while ((n5 = this.readNext()) != 59) {
                stringBuffer.append((char)n5);
            }
            this.height = Integer.parseInt(stringBuffer.toString());
            this.newGrid(this.width, this.height);
            this.pwidth = this.width * 16;
            this.pheight = this.height * 16;
            for (n4 = 0; n4 < this.height; ++n4) {
                for (n3 = 0; n3 < this.width; ++n3) {
                    this.grid[n4][n3] = (byte)((byte)this.readNext() - 65);
                    this.trace[n4][n3] = -1;
                }
            }
            this.enemies.reset();
            n4 = this.readNext();
            if (n4 == 77) {
                n3 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this.readNext()) != 59) {
                        if (n5 == 77) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) continue;
                    this.enemies.decode(stringBuffer.toString());
                }
                n4 = this.readNext();
            }
            if (n4 == 84) {
                n3 = 1;
                n2 = 1;
                while (n3 != 0) {
                    stringBuffer = new StringBuffer();
                    while ((n5 = this.readNext()) != 59) {
                        if (n5 == 84) {
                            n3 = 0;
                            break;
                        }
                        stringBuffer.append((char)n5);
                    }
                    if (n3 == 0) break;
                    String string = stringBuffer.toString();
                    try {
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        if (string.charAt(0) == 's') {
                            string = string.substring(1);
                            n9 = string.indexOf(44);
                            int n10 = string.indexOf(58);
                            int n11 = 0;
                            int n12 = Integer.parseInt(string.substring(0, n9));
                            n8 = Integer.parseInt(string.substring(n9 + 1, n10));
                            while (n11 != string.length()) {
                                n9 = string.indexOf(44, n10 + 1);
                                n11 = string.indexOf(44, n9 + 1);
                                if (n11 == -1) {
                                    n11 = string.length();
                                }
                                n7 = Integer.parseInt(string.substring(n10 + 1, n9));
                                n6 = Integer.parseInt(string.substring(n9 + 1, n11));
                                n10 = n11;
                                byte[] byArray = this.cnt[n6];
                                int n13 = n7;
                                byArray[n13] = (byte)(byArray[n13] + n2);
                            }
                            this.cnt[n8][n12] = n2;
                            n2 = (byte)(n2 * 2);
                            continue;
                        }
                        if (string.charAt(0) != 'c') continue;
                        n6 = string.indexOf(44);
                        n9 = string.indexOf(58);
                        int n14 = Integer.parseInt(string.substring(1, n6));
                        n8 = Integer.parseInt(string.substring(n6 + 1, n9));
                        n7 = Integer.parseInt(string.substring(n9 + 1));
                        this.cnt[n8][n14] = (byte)n7;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        GameMidlet.quitApp();
                    }
                }
            }
            for (n3 = 0; n3 < this.height; ++n3) {
                for (n2 = 0; n2 < this.width; ++n2) {
                    if (this.grid[n3][n2] != 1) continue;
                    int n15 = 0;
                    if (n3 < this.height - 1 && this.grid[n3 + 1][n2] == 1) {
                        n15 = (byte)(n15 + 1);
                    }
                    if (n2 > 0 && this.grid[n3][n2 - 1] == 1) {
                        n15 = (byte)(n15 + 2);
                    }
                    if (n3 > 0 && this.grid[n3 - 1][n2] == 1) {
                        n15 = (byte)(n15 + 4);
                    }
                    if (n2 < this.width - 1 && this.grid[n3][n2 + 1] == 1) {
                        n15 = (byte)(n15 + 8);
                    }
                    this.cnt[n3][n2] = n15;
                }
            }
            this.player.resetPos();
            this.levelObjective = (byte)2;
            this.levelClear = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GameMidlet.quitApp();
        }
    }

    private void newGrid(int n, int n2) {
        this.grid = new byte[n2][n];
        this.cnt = new byte[n2][n];
        this.occ = new byte[n2][n];
        this.trace = new byte[n2][n];
        this.switchActivationId = 0;
        this.nextSwitchActivationId = 0;
    }

    public Playfield(int n, int n2) {
        int n3;
        this.width = n;
        this.height = n2;
        this.pwidth = n * 16;
        this.pheight = n2 * 16;
        this.newGrid(n, n2);
        this.fires = new Fire[28];
        for (n3 = 0; n3 < 28; ++n3) {
            this.fires[n3] = new Fire(this);
        }
        this.resetFires();
        this.floorIm = GameMidlet.getImage("set1/floor");
        this.brickIm = GameMidlet.getImage("set1/brick");
        this.closedDoorIm = GameMidlet.getImage("set1/doorClosed");
        this.openDoorIm = GameMidlet.getImage("set1/doorOpen");
        this.chestIm = GameMidlet.getImage("set1/chest");
        this.treasureIm = GameMidlet.getImage("set1/treasure");
        this.powerItemIm = new Image[3];
        this.gateIm = new Image[2];
        this.icons = new Image[3];
        this.switchIm = new Image[2];
        this.sgateIm = new Image[4];
        this.bombIm = GameMidlet.getImage("bomb0");
        this.flameIm = GameMidlet.getImage("flame5");
        this.powerIm = GameMidlet.getImage("power0");
        this.wallIm = GameMidlet.getImage("set1/wall0");
        this.spawnerIm = GameMidlet.getImage("set1/spawner0");
        this.rockIm = GameMidlet.getImage("set1/rock0");
        for (n3 = 0; n3 < 12; ++n3) {
            if (n3 < this.powerItemIm.length) {
                this.powerItemIm[n3] = GameMidlet.getImage("powerI".concat(String.valueOf(String.valueOf(n3))));
            }
            if (n3 < this.gateIm.length) {
                this.gateIm[n3] = GameMidlet.getImage("set1/gate".concat(String.valueOf(String.valueOf(n3))));
            }
            if (n3 < this.icons.length) {
                this.icons[n3] = GameMidlet.getImage("icon".concat(String.valueOf(String.valueOf(n3))));
            }
            if (n3 < this.switchIm.length) {
                this.switchIm[n3] = GameMidlet.getImage("set1/switch".concat(String.valueOf(String.valueOf(n3))));
            }
            if (n3 >= this.sgateIm.length) continue;
            this.sgateIm[n3] = GameMidlet.getImage("set1/sgate".concat(String.valueOf(String.valueOf(n3))));
        }
        this.pAnim = 0;
    }

    public void reset() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                this.grid[i][j] = 0;
                this.cnt[i][j] = 0;
                this.trace[i][j] = -1;
            }
        }
        this.bombs = 0;
    }

    int getGridX(int n) {
        return n / 16;
    }

    int getGridY(int n) {
        return n / 16;
    }

    public boolean setBomb(byte by, int n, int n2, int n3) {
        if (this.bombs >= this.player.bombs) {
            return false;
        }
        if (this.grid[n2][n] != 0 && this.grid[n2][n] != 4) {
            return false;
        }
        this.grid[n2][n] = by;
        this.cnt[n2][n] = (byte)n3;
        ++this.bombs;
        return true;
    }

    public boolean setFlame(int n, int n2, int n3, boolean bl) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return true;
        }
        byte by = this.grid[n2][n];
        if (by == 0 || by == 4 || by == 5) {
            this.grid[n2][n] = 4;
            this.cnt[n2][n] = (byte)(0 - n3);
            return false;
        }
        if (by == 2) {
            this.player.givePoints(1);
            this.grid[n2][n] = 3;
            this.cnt[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        } else if (by == 20) {
            this.player.givePoints(1);
            this.grid[n2][n] = this.cnt[n2][n] == 8 ? 21 : 5;
            if (bl) {
                return false;
            }
        } else if (by == 10) {
            if (this.cnt[n2][n] == 2 || bl) {
                this.player.givePoints(2);
                this.grid[n2][n] = 11;
                this.cnt[n2][n] = (byte)(0 - n3);
                if (bl) {
                    return false;
                }
            } else {
                byte[] byArray = this.cnt[n2];
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] + 1);
            }
        }
        if (by >= 100) {
            this.cnt[n2][n] = (byte)Math.min(this.cnt[n2][n], (byte)(1 + n3));
            if (bl) {
                return false;
            }
        }
        if (by == 13) {
            this.cnt[n2][n] = (byte)(100 - n3);
        }
        if (by == 8) {
            this.player.givePoints(10);
            this.grid[n2][n] = 9;
            this.cnt[n2][n] = (byte)(0 - n3);
            if (bl) {
                return false;
            }
        }
        if (by == 12 || by == 19 || by == 17) {
            return false;
        }
        if (by == 14 || by == 15) {
            this.nextSwitchActivationId |= this.cnt[n2][n];
            this.grid[n2][n] = by == 14 ? 15 : 14;
        }
        return true;
    }

    boolean isPassable(int n, int n2, int n3) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        byte by = this.grid[n2][n];
        if (by > 100) {
            return false;
        }
        return this.passableTiles[by];
    }

    boolean isBomb(int n, int n2) {
        if (n < 0 || n >= this.width || n2 < 0 || n2 >= this.height) {
            return false;
        }
        byte by = this.grid[n2][n];
        return by == 101;
    }

    boolean isOccupied(int n, int n2) {
        return this.occ[n2][n] != 0;
    }

    void occupy(int n, int n2) {
        this.occ[n2][n] = 2;
    }

    void setDrawDimensions(int n, int n2) {
        if (n > this.pwidth || n2 > this.pheight) {
            GameMidlet.quitApp();
        }
        this.drawWidth = n;
        this.drawHeight = n2 - 16;
    }

    public byte passThrough(int n, int n2, boolean bl) {
        byte by = this.grid[n2][n];
        switch (by) {
            case 4: {
                if (this.cnt[n2][n] < 0) break;
                return 10;
            }
            case 7: {
                return 11;
            }
            case 21: {
                if (!bl) {
                    return 0;
                }
                this.grid[n2][n] = 0;
                return 8;
            }
            case 5: {
                if (!bl) {
                    return 0;
                }
                byte by2 = this.cnt[n2][n];
                this.grid[n2][n] = 0;
                return by2;
            }
        }
        return 0;
    }

    public void update() {
        int n;
        int n2;
        int n3 = 0;
        this.switchActivationId = this.nextSwitchActivationId;
        this.nextSwitchActivationId = 0;
        for (n2 = 0; n2 < this.width; ++n2) {
            for (int i = 0; i < this.height; ++i) {
                byte by;
                if (this.occ[i][n2] > 0) {
                    byte[] byArray = this.occ[i];
                    int n4 = n2;
                    byArray[n4] = (byte)(byArray[n4] - 1);
                }
                if ((n = this.grid[i][n2]) == 101 || n == 106 || n == 105 || n == 107) {
                    byte[] byArray = this.cnt[i];
                    int n5 = n2;
                    byArray[n5] = (byte)(byArray[n5] - 1);
                    if (this.cnt[i][n2] != 0) continue;
                    --this.bombs;
                    this.grid[i][n2] = 4;
                    this.cnt[i][n2] = 0;
                    if (n == 107) {
                        this.setFlame(n2, i, 1, false);
                        return;
                    }
                    by = n == 101 ? (byte)1 : (n == 106 ? (byte)4 : 3);
                    this.addFire(by, n2 * 16, i * 16, -16, 0, (byte)(this.player.flames + 1));
                    this.addFire(by, n2 * 16, i * 16, 16, 0, (byte)(this.player.flames + 1));
                    this.addFire(by, n2 * 16, i * 16, 0, -16, (byte)(this.player.flames + 1));
                    this.addFire(by, n2 * 16, i * 16, 0, 16, (byte)(this.player.flames + 1));
                    continue;
                }
                if (n == 104) {
                    byte[] byArray = this.cnt[i];
                    int n6 = n2;
                    byArray[n6] = (byte)(byArray[n6] - 1);
                    if (this.cnt[i][n2] != 0) continue;
                    --this.bombs;
                    for (by = -2; by <= 2; ++by) {
                        this.setFlame(n2 - 2, i + by, 1, false);
                        this.setFlame(n2 + 2, i + by, 1, false);
                        this.setFlame(n2 + by, i - 2, 1, false);
                        this.setFlame(n2 + by, i + 2, 1, false);
                    }
                    this.grid[i][n2] = 0;
                    this.cnt[i][n2] = 0;
                    continue;
                }
                if (n == 4) {
                    byte[] byArray = this.cnt[i];
                    int n7 = n2;
                    byArray[n7] = (byte)(byArray[n7] + 1);
                    if (this.cnt[i][n2] != 9) continue;
                    this.grid[i][n2] = 0;
                    continue;
                }
                if (n == 3) {
                    this.grid[i][n2] = 0;
                    continue;
                }
                if (n == 11) {
                    this.grid[i][n2] = 0;
                    continue;
                }
                if (n == 12) {
                    byte[] byArray = this.cnt[i];
                    int n8 = n2;
                    byArray[n8] = (byte)(byArray[n8] - 1);
                    if (this.cnt[i][n2] != 0) continue;
                    this.grid[i][n2] = 13;
                    this.cnt[i][n2] = 9;
                    continue;
                }
                if (n == 13) {
                    if (this.cnt[i][n2] > 50) {
                        this.grid[i][n2] = 12;
                        this.cnt[i][n2] = 24;
                        continue;
                    }
                    if (this.cnt[i][n2] <= 0) continue;
                    byte[] byArray = this.cnt[i];
                    int n9 = n2;
                    byArray[n9] = (byte)(byArray[n9] - 1);
                    continue;
                }
                if (n == 6) {
                    if (!this.levelClear) continue;
                    this.grid[i][n2] = 7;
                    continue;
                }
                if (n >= 16 && n <= 19 && (this.cnt[i][n2] & this.switchActivationId) != 0) {
                    switch (n) {
                        case 18: {
                            this.grid[i][n2] = 19;
                            break;
                        }
                        case 19: {
                            this.grid[i][n2] = 18;
                            break;
                        }
                        case 16: {
                            this.grid[i][n2] = 17;
                            break;
                        }
                        case 17: {
                            this.grid[i][n2] = 16;
                        }
                    }
                    continue;
                }
                if (n == 9) {
                    this.grid[i][n2] = 0;
                    continue;
                }
                if (n != 8) continue;
                ++n3;
                byte[] byArray = this.cnt[i];
                int n10 = n2;
                byArray[n10] = (byte)(byArray[n10] + 1);
                if (this.cnt[i][n2] != 120) continue;
                this.cnt[i][n2] = 0;
                if (this.isOccupied(n2, i)) continue;
                this.enemies.addEnemy((byte)2, n2, i, (byte)0, (byte)2, 0);
            }
        }
        for (n2 = 0; n2 < 28; ++n2) {
            if (this.fires[n2].type == 0) continue;
            Fire fire = this.fires[n2];
            fire.x += fire.xsp;
            fire.y += fire.ysp;
            fire.cnt = (byte)(fire.cnt - 1);
            if (fire.cnt == 0) {
                this.removeFire(n2);
                continue;
            }
            n = this.getGridX(fire.x);
            int n11 = this.getGridY(fire.y);
            if (fire.type == 1 && this.setFlame(n, n11, 1, false)) {
                this.removeFire(n2);
                continue;
            }
            if (fire.type == 4) {
                if (fire.cnt > 1) {
                    if (fire.xsp != 0) {
                        if (this.isPassable(n, n11 + 1, -1)) {
                            this.addFire((byte)1, fire.x, fire.y, 0, 16, (byte)(fire.cnt - 2));
                        }
                        if (this.isPassable(n, n11 - 1, -1)) {
                            this.addFire((byte)1, fire.x, fire.y, 0, -16, (byte)(fire.cnt - 2));
                        }
                    }
                    if (fire.ysp != 0) {
                        if (this.isPassable(n + 1, n11, -1)) {
                            this.addFire((byte)1, fire.x, fire.y, 16, 0, (byte)(fire.cnt - 2));
                        }
                        if (this.isPassable(n - 1, n11, -1)) {
                            this.addFire((byte)1, fire.x, fire.y, -16, 0, (byte)(fire.cnt - 2));
                        }
                    }
                }
                if (this.setFlame(n, n11, 1, false)) {
                    this.removeFire(n2);
                    continue;
                }
            }
            if (fire.type != 3 || !this.setFlame(n, n11, 1, true)) continue;
            this.removeFire(n2);
        }
        if (this.levelObjective == 2 && (n3 += this.enemies.update()) == 0) {
            this.levelClear = true;
        }
    }

    public void updateScreen(Graphics graphics) {
        Image image;
        int n = this.player.x + 8;
        int n2 = this.player.y + 8;
        int n3 = n - this.drawWidth / 2;
        int n4 = n2 - this.drawHeight / 2;
        if (n3 < -1) {
            n3 = -1;
        } else if (n3 > this.pwidth - this.drawWidth + 1) {
            n3 = this.pwidth - this.drawWidth + 1;
        }
        if (n4 < -1) {
            n4 = -1;
        } else if (n4 > this.pheight - this.drawHeight + 1) {
            n4 = this.pheight - this.drawHeight + 1;
        }
        int n5 = -(n3 % 16);
        int n6 = -(n4 % 16);
        int n7 = Math.max(n3 / 16, 0);
        int n8 = Math.max(n4 / 16, 0);
        int n9 = (this.drawWidth - n5 + 16 - 1) / 16;
        int n10 = (this.drawHeight - n6 + 16 - 1) / 16;
        if (n3 == this.pwidth - this.drawWidth + 1) {
            --n9;
        }
        if (n4 == this.pheight - this.drawHeight + 1) {
            --n10;
        }
        int n11 = 0;
        int n12 = 0;
        graphics.setClip(0, 16, this.drawWidth, this.drawHeight + 16);
        for (n11 = 0; n11 < n9; ++n11) {
            for (n12 = 0; n12 < n10; ++n12) {
                image = this.floorIm;
                byte by = this.grid[n8 + n12][n7 + n11];
                byte by2 = this.cnt[n8 + n12][n7 + n11];
                switch (by) {
                    case 1: {
                        image = this.wallIm;
                        break;
                    }
                    case 2: {
                        image = this.brickIm;
                        break;
                    }
                    case 10: {
                        image = this.rockIm;
                        break;
                    }
                    case 101: {
                        int n13 = by2 / 2 % 4;
                        if (n13 == 3) {
                            n13 = 1;
                        }
                        image = this.bombIm;
                        break;
                    }
                    case 104: {
                        int n13 = by2 / 2 % 2;
                        image = this.bombIm;
                        break;
                    }
                    case 105: {
                        int n13 = by2 / 2 % 2;
                        image = this.bombIm;
                        break;
                    }
                    case 106: {
                        int n13 = by2 / 2 % 4;
                        if (n13 == 3) {
                            n13 = 1;
                        }
                        image = this.bombIm;
                        break;
                    }
                    case 107: {
                        int n13 = by2 / 2 % 4;
                        if (n13 == 3) {
                            n13 = 1;
                        }
                        image = this.bombIm;
                        break;
                    }
                    case 4: {
                        if (by2 < 0) break;
                        image = this.flameIm;
                        break;
                    }
                    case 5: {
                        image = this.powerIm;
                        break;
                    }
                    case 12: {
                        image = this.gateIm[1];
                        break;
                    }
                    case 7: {
                        image = this.openDoorIm;
                        break;
                    }
                    case 6: {
                        image = this.closedDoorIm;
                        break;
                    }
                    case 13: {
                        image = this.gateIm[0];
                        break;
                    }
                    case 8: {
                        boolean bl = false;
                        image = this.spawnerIm;
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 11: {
                        break;
                    }
                    case 14: {
                        image = this.switchIm[1];
                        break;
                    }
                    case 15: {
                        image = this.switchIm[0];
                        break;
                    }
                    case 18: {
                        image = this.sgateIm[2];
                        break;
                    }
                    case 19: {
                        image = this.sgateIm[3];
                        break;
                    }
                    case 16: {
                        image = this.sgateIm[0];
                        break;
                    }
                    case 17: {
                        image = this.sgateIm[1];
                        break;
                    }
                    case 20: {
                        image = this.chestIm;
                        break;
                    }
                    case 21: {
                        image = this.treasureIm;
                    }
                }
                graphics.drawImage(image, n11 * 16 + n5, 16 + n12 * 16 + n6, 20);
                if (by != 5) continue;
                graphics.drawImage(this.powerItemIm[by2 - 1], n11 * 16 + n5 + 3, 16 + n12 * 16 + n6 + 3, 20);
            }
        }
        graphics.setColor(120, 120, 120);
        if (n3 == -1) {
            graphics.drawLine(0, 16, 0, 16 + this.drawHeight - 1);
        }
        if (n4 == -1) {
            graphics.drawLine(0, 16, this.drawWidth - 1, 16);
        }
        if (n3 == this.pwidth - this.drawWidth + 1) {
            graphics.drawLine(this.drawWidth - 1, 16, this.drawWidth - 1, 16 + this.drawHeight - 1);
        }
        if (n4 == this.pheight - this.drawHeight + 1) {
            graphics.drawLine(0, 16 + this.drawHeight - 1, this.drawWidth - 1, 16 + this.drawHeight - 1);
        }
        graphics.setClip(0, 16, this.drawWidth, this.drawHeight + 16);
        if (this.player.invinc % 3 < 2) {
            if (this.player.mode != 1 || this.player.step <= 8 || this.player.step % 2 != 0) {
                graphics.drawImage(this.player.getImage(), this.player.x - n3 + 8, 16 + this.player.y - n4 + 8, 3);
            }
        }
        graphics.setClip(0, 0, this.drawWidth, 16 + this.drawHeight);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, this.drawWidth, 16);
        graphics.setColor(200, 180, 160);
        graphics.drawImage(this.icons[0], 2, 2, 20);
        graphics.drawImage(this.icons[1], 26, 2, 20);
        graphics.drawImage(this.icons[2], 50, 2, 20);
        if (this.player.extra != 0) {
            image = this.floorIm;
            switch (this.player.extra) {
                case 104: {
                    image = this.bombIm;
                    break;
                }
                case 105: {
                    image = this.bombIm;
                    break;
                }
                case 106: {
                    image = this.bombIm;
                    break;
                }
                case 107: {
                    image = this.bombIm;
                }
            }
            graphics.drawImage(image, 74, 0, 20);
            if (this.player.exCnt > 0) {
                graphics.drawString(Integer.toString(this.player.exCnt), 90, 0, 20);
            }
        }
        this.enemies.updateGraphics(-n3 + 8, 16 + -n4 + 8, this.drawWidth, this.drawHeight + 16, graphics);
        graphics.drawString(Integer.toString(this.player.lives - 1), 14, 0, 20);
        graphics.drawString(Integer.toString(this.player.bombs), 38, 0, 20);
        graphics.drawString(Integer.toString(this.player.flames), 62, 0, 20);
        graphics.drawString(Integer.toString(this.player.points), this.drawWidth - 2, 0, 24);
        graphics.setColor(255, 80, 0);
        ++this.pAnim;
        if (this.pAnim == 120) {
            this.pAnim = 0;
        }
    }

    static {
        EMPTY = 0;
        WALL = 1;
        BRICK = (byte)2;
        BRICK_BREAK = (byte)3;
        FLAME = (byte)4;
        POWERUP = (byte)5;
        CLOSED_DOOR = (byte)6;
        OPEN_DOOR = (byte)7;
        SPAWNER = (byte)8;
        SPAWNER_BREAK = (byte)9;
        ROCK = (byte)10;
        ROCK_BREAK = (byte)11;
        GATE_OPEN = (byte)12;
        GATE_CLOSED = (byte)13;
        SWITCH_OFF = (byte)14;
        SWITCH_ON = (byte)15;
        SGATEV_CLOSED = (byte)16;
        SGATEV_OPEN = (byte)17;
        SGATEH_CLOSED = (byte)18;
        SGATEH_OPEN = (byte)19;
        CHEST = (byte)20;
        TREASURE = (byte)21;
        BOMB = (byte)101;
        RINGBOMB = (byte)104;
        POWERBOMB = (byte)105;
        BRANCHBOMB = (byte)106;
        HUGEBOMB = (byte)107;
        TILESIZE = 16;
        POWER_BOMB = 1;
        POWER_FLAME = (byte)2;
        POWER_FOOT = (byte)3;
        POWER_RINGBOMB = (byte)4;
        POWER_POWERBOMB = (byte)5;
        POWER_BRANCHBOMB = (byte)6;
        POWER_HUGEBOMB = (byte)7;
        GOLD = (byte)8;
        EFF_NONE = 0;
        EFF_BURN = (byte)10;
        EFF_EXIT = (byte)11;
        SPAWNRATE = 120;
        FIRE_NONE = 0;
        FIRE_STRAIGHT = 1;
        FIRE_FLAMECAST = (byte)2;
        FIRE_POWER = (byte)3;
        FIRE_BRANCH = (byte)4;
        numFires = 28;
        OBJECTIVE_NONE = 0;
        OBJECTIVE_COLLECT = 1;
        OBJECTIVE_CLEAN = (byte)2;
    }

    public class Fire {
        public static final int DATA_LENGTH = 18;
        byte type;
        byte cnt;
        int x;
        int y;
        int xsp;
        int ysp;

        public Fire(Playfield playfield) {
        }

        public boolean encode(OutputStream outputStream) {
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeByte(this.type);
                dataOutputStream.writeByte(this.cnt);
                dataOutputStream.writeInt(this.x);
                dataOutputStream.writeInt(this.y);
                dataOutputStream.writeInt(this.xsp);
                dataOutputStream.writeInt(this.ysp);
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
        }

        static {
            DATA_LENGTH = 18;
        }
    }
}

