/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

	.text

#define INTERRUPT_BASE	0x4a000000
#define INTMSK 0x08

#define DMA_BASE	0x4b000000

#define DMASKTRIG0	0x20
#define DMASKTRIG1 	0x60
#define DMASKTRIG2	0xa0
#define DMASKTRIG3	0xe0

#define DMASKTRIG_ON_OFF 2
#define DMASKTRIG_STOP	4

#define CLOCK_BASE	0x4c000000
#define CLKCON		0x0c

#define USB_BASE	0x52000000
#define EP_INT_EN_REG	0x15c
#define USB_INT_EN_REG	0x16c
#define EP1_DMA_CON	0x200
#define EP2_DMA_CON	0x218
#define EP3_DMA_CON	0x240
#define EP4_DMA_CON	0x258

#define GPIO_BASE	0x56000000

#define EINTMASK	0xa4
#define MISCCR		0x80

	/* disable interrupts */
	.global _disable_interrupts
_disable_interrupts:
	mrs	r2, cpsr
	orr	r2, r2, #0xc0
	msr	cpsr_c, r2
	
	movs	pc, lr

	/* disable the MMU and jump to a physical address */

	.global	_enter_physical
_enter_physical:
	/* r0 the physical address to jump to */

	bl	flush_caches

	mov	r2, #0
	mcr	p15, 0, r2, c8, c7, 0		/* Invalidate I+D TLB */

	mrc	p15, 0, r2, c1, c0, 0
	bic	r2, r2, #0x000f			/* disable the D-cache + MMU */
	bic	r2, r2, #0x1100			/* disable the I-cache + S */
	mcr	p15, 0, r2, c1, c0, 0

	mov	pc, r0				/* jump to the physaddr */

	/* copy the kernel to the start of ram and execute it */

	.global	_boot_linux_start
_boot_linux_start:
	ldr	r6, led_reg
	ldr	r7, led_val

	/* turn on the LED */
	cmp	r6, #0
	beq	1f
	ldr	r5, [r6]
	orr	r5, r5, r7
	str	r5, [r6]
1:

	/* disable USB */
#if 0
	mov	r1, #USB_BASE
	mov	r1, #0
	str	r1, [r0, #EP_INT_EN_REG]
	str	r1, [r0, #USB_INT_EN_REG]
	str	r1, [r0, #EP1_DMA_CON]
	str	r1, [r0, #EP2_DMA_CON]
	str	r1, [r0, #EP3_DMA_CON]
	str	r1, [r0, #EP4_DMA_CON]
#endif

	mov	r0, #GPIO_BASE
	ldr	r1, [r0, #MISCCR]
	bic	r1, r1, #0x3000		/* take USB out of suspend */
	orr	r1, r1, #0x0008		/* select USB host mode */
	str	r1, [r0, #MISCCR]

	/* disable INTMSK */
	mov	r0, #INTERRUPT_BASE
	mvn	r1, #0
	str	r1, [r0, #INTMSK]

	/* disable EINTR */
	mov	r0, #GPIO_BASE
	mvn	r1, #0
	str	r1, [r1, #EINTMASK]

	/* disable DMA */
	mov	r0, #DMA_BASE

	ldr	r1, [r0, #DMASKTRIG0]
	orr	r1, r1, #DMASKTRIG_STOP
	str	r1, [r0, #DMASKTRIG0]
1:	ldr	r1, [r0, #DMASKTRIG0]
	tst	r1, #DMASKTRIG_ON_OFF
	bne	1b

	ldr	r1, [r0, #DMASKTRIG1]
	orr	r1, r1, #DMASKTRIG_STOP
	str	r1, [r0, #DMASKTRIG1]
1:	ldr	r1, [r0, #DMASKTRIG1]
	tst	r1, #DMASKTRIG_ON_OFF
	bne	1b

	ldr	r1, [r0, #DMASKTRIG2]
	orr	r1, r1, #DMASKTRIG_STOP
	str	r1, [r0, #DMASKTRIG2]
1:	ldr	r1, [r0, #DMASKTRIG2]
	tst	r1, #DMASKTRIG_ON_OFF
	bne	1b

	ldr	r1, [r0, #DMASKTRIG3]
	orr	r1, r1, #DMASKTRIG_STOP
	str	r1, [r0, #DMASKTRIG3]
1:	ldr	r1, [r0, #DMASKTRIG3]
	tst	r1, #DMASKTRIG_ON_OFF
	bne	1b

        /// \todo disable anything else that can mess up the boot

#if 0
	/* wait for USB to settle down, don't know if this is neccesary */
	mov	r0, #0x100000
1:	sub	r0, r0, #1
	cmp	r0, #0
	bne	1b
#endif

	/* turn off the LED */
	cmp	r6, #0
	beq	1f
	ldr	r5, [r6]
	eor	r5, r5, r7
	str	r5, [r6]
1:

        /* copy the kernel to it's final place using the directory */
	ldr	r0, dir
	ldr	r3, [r0, #0]
	cmp	r3, #0
L40:
	add	r0, r0, #4
	sub	r2, r3, #1
	ldr	ip, [r0], #4
	cmn	r2, #1
	ldr	r1, [r0], #4
	beq	L44
L39:
	ldr	r3, [ip], #4
	sub	r2, r2, #1
	cmn	r2, #1
	str	r3, [r1], #4
	bne	L39
L44:
	cmp	r6, #0
	beq	1f
	ldr	r5, [r6]
	eor	r5, r5, r7
	str	r5, [r6]
1:

	ldr	r3, [r0, #0]
	cmp	r3, #0
	bne	L40

	/* were done, turn off the LED */
	cmp	r6, #0
	beq	1f
	ldr	r5, [r6]
	bic	r5, r5, r7
	str	r5, [r6]
1:

	bl	flush_caches

	mov	r0, #0
	mrc	p15, 0, r0, c1, c0, 0
	bic	r0, r0, #0x0004			/* disable the D-cache */
	bic	r0, r0, #0x1000			/* disable the I-cache */
	mcr	p15, 0, r0, c1, c0, 0

	mov	r0, #0
	mcr	p15, 0, r0, c13, c0, 0		/* clear PID register */
	mcr	p15, 0, r0, c8, c7, 0		/* invalidate I+D TLB */

	mov	r0, #0
        ldr     r1, mach
        ldr     r2, tags
        ldr     r3, kernel

	mov	pc, r3

	/* Flush D+I cache.  Note that we must save r0 */
flush_caches:
	mov	r1, #(8 - 1) << 5		/* 8 segments */
1:	orr	r2, r1, #(64 - 1) << 26		/* 64 entries */
2:	mcr	p15, 0, r2, c7, c14, 2		/* clean+invalidate D index */
	subs	r2, r2, #1 << 26
	bcs	2b				/* entries 63 to 0 */
	subs	r1, r1, #1 << 5
	bcs	1b				/* segments 7 to 0 */
	mov	r1, #0
	mcrne	p15, 0, r1, c7, c10, 4		/* drain write buffer */
	mcrne	p15, 0, r0, c7, c5, 0		/* invalidate I cache */
	mov	pc, lr

	/* note, if you change the following parametes, you must
	 * update the corresponding structure in boot.c */
	.global	_boot_linux_param
_boot_linux_param:
dir:		.word	0
mach:		.word	0
tags:		.word	0
kernel:		.word	0
led_reg: 	.word	0
led_val:	.word	0

	.global	_boot_linux_end
_boot_linux_end:
