/*
 * Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This is a program that looks for changes of the specified
 * addresses.  I've used it to figure out which GPIO pin is connected
 * to which button.  It also gives an indication of what pins Windows
 * CE is modifying.
 *
 * \todo The output format could be a lot clearer.
 * \todo So far I can only dump the GPIO registers, this needs fixing.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "winhack.h"

int main()
{
    unsigned t0;
    unsigned t;
    int r;
    int b;
    unsigned long base = 0x58000000;
    void *virt;
    int i;
    unsigned d0, d1;

    virt = VirtualAlloc(NULL, 0x10000, MEM_RESERVE, PAGE_NOACCESS);
    if (!virt) {
	fprintf(stderr, "VirtualAlloc failed\n");
	exit(1);
    }
    
    if (!VirtualCopy(virt, (LPVOID)(base >> 8), 0x10000, 
		     PAGE_READWRITE | PAGE_PHYSICAL | PAGE_NOCACHE)) {
	printf("VirtualCopy of 0x%08lx failed\n", base);
	exit(1);
    }

    t0 = GetTickCount();
    while (1) {
	d0 = readl(virt + 0xc);
	d1 = readl(virt + 0x10);

	t = GetTickCount() - t0;
	printf("%08u %4u %4u\n", t, d0 & 0x3ff, d1 & 0x3ff);

	if ((d0 & 0x8000) || (d1 & 0x8000))
	    break;

	if (0)
	    Sleep(1);
    }	

    exit(0);
}
