#! /usr/bin/python

# Copyright (c) 2005 Christer Weinigel <christer@weinigel.se>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation.

"""Take the output from readregs.c and summarise it."""

import string
import sys

def process(f):
    last_addr = -1

    while 1:
        l = f.readline()
        if not l:
            break
        if not l.startswith('0x'):
            continue
        parts = l.strip().split()
        if len(parts) < 3:
            continue

        addr = string.atol(parts[0], 0)
        value = string.atol(parts[2], 0)

        if last_addr != addr:
            if last_addr != -1:
                print "0x%08x 0x%08x 0x%08x" % (last_addr, (last_value & ~mask), mask)
            mask = 0
            last_value = value
            last_addr = addr

        mask = mask | (last_value ^ value)
        last_value = value

    f.close()
    
def main():
    if sys.argv[0]:
        if len(sys.argv) > 1:
            for fn in sys.argv[1:]:
                print fn
                f = open(fn, 'r')
                process(f)
                f.close()
        else:
            print "stdin"
            process(sys.stdin)
    else:
        process(open('dumps/charger-usb-green-on-blue-blink.txt', 'r'))

main()

