#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>

#define HD_COLS 16
#include "hd.h"

typedef unsigned char BYTE;
typedef unsigned int DWORD;

typedef struct _PARTENTRY {
    BYTE Part_BootInd;
    BYTE Part_FirstHead;
    BYTE Part_FirstSector;
    BYTE Part_FirstTrack;
    BYTE Part_FileSystem;
    BYTE Part_LastHead;
    BYTE Part_LastSector;
    BYTE Part_LastTrack;
    DWORD Part_StartSector;
    DWORD Part_TotalSectors;
} PARTENTRY;

void fetch(int fd, char *buf, long offset, int count)
{
    if (lseek(fd, offset, SEEK_SET) != offset) {
	perror("lseek");
	exit(1);
    }

    if (read(fd, buf, count) != count) {
	perror("read failed");
	exit(1);
    }
}

int main() {
    int fd;
    unsigned char buf[64 * 1024];
    int poffs = 0;
    int i;
    PARTENTRY part[4];

    if ((fd = open("ptable.bin", O_RDONLY)) == -1) {
	perror("open");
	exit(1);
    }

    fetch(fd, buf, 0, 512);
    // hd_base("", 0x28000, buf, 0x8000);

    if (buf[poffs] != 0xe9 || buf[poffs + 1] != 0xfd || 
	buf[poffs + 0x1fe] != 0x55 || buf[poffs + 0x1ff] != 0xaa) {
	fprintf(stderr, "no partition table signature\n");
	exit(1);
    }

    memcpy(part, buf + poffs + 0x1fe - sizeof(part), sizeof(part));

    for (i = 0; i < 4; i++) {
	printf("%d: inde %02x type %02x %08x-%08x (%08x)\n", i, 
	       part[i].Part_BootInd, part[i].Part_FileSystem,
	       part[i].Part_StartSector, 
	       part[i].Part_StartSector + part[i].Part_TotalSectors,
	       part[i].Part_TotalSectors);

	if (0 && part[i].Part_TotalSectors) {
	    unsigned base = 0x2c000 + part[i].Part_StartSector * 512;

	    printf("0x%08x\n", base);
 	    fetch(fd, buf, base, 0x2000);
	    hd_base("", base, buf, 0x2000);

	    printf("\n");
	}
    }

    close(fd);
   
    exit(0);
}

 
/*
  Local variables:
  compile-command: "make CROSS_COMPILE=/opt/crosstool/gcc-3.4.1-glibc-2.3.3/arm-9tdmi-linux-gnu/bin/arm-9tdmi-linux-gnu- -k "
  End:
*/

