/* $Id: $
 *
 * sh-boot/serial-ec3104.c
 *
 * Support for the 16550-compatible serial port on the EC3104 companion
 * chip.
 *
 * Copyright (C) 2000 Philipp Rumpf <prumpf@tux.org>
 *
 * This file is subject to the terms and conditions of the GNU
 * General Public License.  See the file "COPYING" in the main
 * directory of this archive for more details.
 */

#include "config.h"
#include "io.h"

#define EC_BASEADDR	0xB0EC0000
#define EC_INDEX	7
#define EC_SERBASE	EC_BASEADDR + EC_INDEX * 0x1000
#define EC_POWER	EC_BASEADDR + EC_INDEX * 4

#define EC_RX	EC_SERBASE + 0
#define EC_TX	EC_SERBASE + 0
#define EC_IER	EC_SERBASE + 4
#define EC_LSR	EC_SERBASE + 20

#define LSR_TEMT	0x40
#define LSR_THRE	0x20
#define LSR_DR		0x01

#define inb(addr) (*(volatile unsigned int *)(addr))
#define outb(data, addr) do { *(volatile unsigned int *)(addr) = (data); } while(0)

void
handleError (void)
{
}

void
init_serial(void)
{
	outb(1, EC_POWER);
	outb(0, EC_IER);
}

static inline void wait_for_data(void)
{
	unsigned int status;

	do {
		status = inb(EC_LSR);
	} while(!(status & LSR_DR));
}

char getDebugChar (void)
{
	char ret;
	int i = 0;

	wait_for_data();

	ret = inb(EC_RX);

	return ret;
}
	
#define BOTH_EMPTY (LSR_TEMT | LSR_THRE)

static inline void wait_for_xmitr(void)
{
	unsigned int status;

	do {
		status = inb(EC_LSR);
	} while((status & BOTH_EMPTY) != BOTH_EMPTY);
}

void
putDebugChar (char c)
{
	wait_for_xmitr();

	outb(c, EC_TX);
}
