/*
 * Decompiled with CFR 0.152.
 */
package waba.applet;

import waba.io.Catalog;
import waba.io.DataStream;

public class UserFont {
    public short fontType;
    public short firstChar;
    public short lastChar;
    public short maxWidth;
    public short kernMax;
    public short nDescent;
    public short fRectWidth;
    public short fRectHeight;
    public short owTLoc;
    public short ascent;
    public short descent;
    public short leading;
    public short rowWords;
    public int rowWidthInBytes;
    public int numberOfChars;
    public int bitmapTableSize;
    public byte[] bitmapTable;
    public short[] bitIndexTable;
    public boolean loaded;

    public UserFont(String string, String string2) {
        Catalog catalog = new Catalog(String.valueOf(string) + ".Font.Font", 1);
        if (!catalog.isOpen()) {
            catalog = new Catalog(String.valueOf(string) + string2 + ".Font.Font", 1);
        }
        if (catalog.isOpen()) {
            int n;
            string = String.valueOf(string) + string2;
            DataStream dataStream = new DataStream(catalog);
            int n2 = catalog.getRecordCount();
            if (n2 > 1) {
                n = 0;
                int n3 = 0;
                while (n3 < n2) {
                    String string3;
                    if (catalog.setRecordPos(n3) && (string3 = dataStream.readCString()).equals(string)) {
                        int n4 = string3.length() + 1;
                        dataStream.skip((n4 + 3 >> 2 << 2) - n4);
                        n = 1;
                        break;
                    }
                    ++n3;
                }
                if (n == 0) {
                    catalog.close();
                    return;
                }
            } else {
                catalog.setRecordPos(0);
            }
            this.fontType = dataStream.readShort();
            this.firstChar = dataStream.readShort();
            this.lastChar = dataStream.readShort();
            this.maxWidth = dataStream.readShort();
            this.kernMax = dataStream.readShort();
            this.nDescent = dataStream.readShort();
            this.fRectWidth = dataStream.readShort();
            this.fRectHeight = dataStream.readShort();
            this.owTLoc = dataStream.readShort();
            this.ascent = dataStream.readShort();
            this.descent = dataStream.readShort();
            this.leading = dataStream.readShort();
            this.rowWords = dataStream.readShort();
            this.rowWidthInBytes = this.rowWords << 1;
            this.numberOfChars = this.lastChar - this.firstChar + 1;
            this.bitmapTableSize = this.rowWidthInBytes * this.fRectHeight;
            this.bitmapTable = new byte[this.bitmapTableSize];
            dataStream.readBytes(this.bitmapTable);
            this.bitIndexTable = new short[this.numberOfChars + 2];
            n = 0;
            while (n < this.bitIndexTable.length) {
                this.bitIndexTable[n] = dataStream.readShort();
                ++n;
            }
            this.loaded = true;
            catalog.close();
        }
    }

    public int charWidth(char c) {
        short s;
        byte by;
        int n = (short)c - this.firstChar;
        if (n < 0 || c > this.lastChar) {
            n = this.numberOfChars;
        }
        if ((by = (byte)(this.bitIndexTable[n + 1] - (s = this.bitIndexTable[n]))) == 0) {
            by = (byte)(this.bitIndexTable[this.numberOfChars + 1] - this.bitIndexTable[this.numberOfChars]);
        }
        return by;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public int stringWidth(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            n += this.charWidth(cArray[n2]);
            ++n2;
        }
        return n;
    }
}

