/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Vm;

public final class Vector {
    public Object[] items;
    private int f1;

    public Vector() {
        this(8);
    }

    public Vector(int n) {
        this.items = new Object[n == 0 ? 1 : n];
    }

    public Vector(Object[] objectArray) {
        if (objectArray != null) {
            this.items = objectArray;
            this.f1 = objectArray.length;
            return;
        }
        this.items = new Object[1];
    }

    public void add(Object object) {
        if (this.f1 < this.items.length) {
            this.items[this.f1++] = object;
            return;
        }
        Vector vector = this;
        vector.insert(vector.f1, object);
    }

    public void addElement(Object object) {
        this.add(object);
    }

    public void clear() {
        int n = 0;
        while (n < this.f1) {
            this.items[n] = null;
            ++n;
        }
        this.f1 = 0;
    }

    public void del(int n) {
        if (n != this.f1 - 1) {
            Vm.copyArray(this.items, n + 1, this.items, n, this.f1 - n - 1);
        }
        this.items[this.f1 - 1] = null;
        --this.f1;
    }

    public boolean del(Object object) {
        int n = this.find(object);
        if (n >= 0) {
            this.del(n);
            return true;
        }
        return false;
    }

    public Object elementAt(int n) {
        return this.get(n);
    }

    public int find(Object object) {
        return this.find(object, 0);
    }

    public int find(Object object, int n) {
        int n2 = n;
        while (n2 < this.f1) {
            if (this.items[n2].equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object get(int n) {
        if (n >= this.f1) {
            n = this.items.length;
        }
        return this.items[n];
    }

    public int getCount() {
        return this.f1;
    }

    public int indexOf(Object object) {
        return this.find(object, 0);
    }

    public int indexOf(Object object, int n) {
        return this.find(object, n);
    }

    public void insert(int n, Object object) {
        if (n < 0 || n > this.f1) {
            n = this.f1;
        }
        if (this.f1 == this.items.length) {
            Object[] objectArray = new Object[this.items.length * 12 / 10 + 1];
            Vm.copyArray(this.items, 0, objectArray, 0, this.f1);
            this.items = objectArray;
        }
        if (n != this.f1) {
            Vm.copyArray(this.items, n, this.items, n + 1, this.f1 - n);
        }
        this.items[n] = object;
        ++this.f1;
    }

    public void insertElementAt(Object object, int n) {
        this.insert(n, object);
    }

    public Object peek() {
        if (this.f1 > 0) {
            return this.items[this.f1 - 1];
        }
        return null;
    }

    public Object pop() {
        Object object = null;
        if (this.f1 > 0) {
            object = this.items[--this.f1];
        }
        this.items[this.f1] = null;
        return object;
    }

    public void push(Object object) {
        this.add(object);
    }

    public boolean qsort() {
        if (this.f1 > 0) {
            Convert.qsort(this.items, 0, this.f1 - 1);
            return true;
        }
        return false;
    }

    public void removeAllElements() {
        this.clear();
    }

    public boolean removeElement(Object object) {
        return this.del(object);
    }

    public void removeElementAt(int n) {
        this.del(n);
    }

    public void set(int n, Object object) {
        if (n >= this.f1) {
            n = this.items.length;
        }
        this.items[n] = object;
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public int size() {
        return this.f1;
    }

    public Object[] toObjectArray() {
        if (this.f1 == 0) {
            return null;
        }
        Object[] objectArray = this.items[0] instanceof String ? new String[this.f1] : new Object[this.f1];
        if (this.f1 > 0) {
            Vm.copyArray(this.items, 0, objectArray, 0, this.f1);
        }
        return objectArray;
    }
}

