/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Image;
import waba.sys.Settings;
import waba.ui.Control;
import waba.ui.ControlEvent;
import waba.ui.Event;
import waba.ui.PenEvent;

public class Button
extends Control {
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_SIMPLE = 1;
    public static final byte BORDER_3D = 2;
    protected String text;
    protected Image img;
    protected boolean armed;
    protected boolean isText;
    protected int gap;
    protected byte border = (byte)2;
    protected int ww;
    protected int hh;
    protected Color fColor;
    protected Color imgColor;
    protected Color aColor;
    protected Graphics myg;
    protected Color[] fourColors = new Color[4];
    protected boolean ignoreEvents;
    public static int commonGap;

    public Button(String string) {
        this.text = string;
        this.isText = true;
        this.img = null;
    }

    public Button(Image image) {
        this.img = image;
        this.imgColor = image.getTransparentColor();
        this.isText = false;
        this.text = null;
    }

    public static Button createArrowButton(byte by, int n, Color color) {
        boolean bl = by == 4 || by == 3;
        int n2 = (n << 1) - 1;
        Image image = bl ? new Image(n, n2) : new Image(n2, n);
        Graphics graphics = image.getGraphics();
        graphics.setBackColor(image.getTransparentColor());
        if (bl) {
            graphics.fillRect(0, 0, n, n2);
        } else {
            graphics.fillRect(0, 0, n2, n);
        }
        graphics.drawArrow(0, 0, n, by, false, true, color);
        return new Button(image);
    }

    public Image getImage() {
        if (this.isText) {
            return null;
        }
        return this.img;
    }

    public int getPreferredHeight() {
        if (this.isText) {
            return this.fmH + (commonGap + this.gap << 1);
        }
        return this.img.getHeight() + (this.border + this.gap + commonGap << 1);
    }

    public int getPreferredWidth() {
        return (this.isText ? this.fm.getTextWidth(this.text) : this.img.getWidth()) + (this.border + this.gap + commonGap << 1);
    }

    public String getText() {
        if (this.isText) {
            return this.text;
        }
        return "image";
    }

    protected void onBoundsChanged() {
        if (this.isText) {
            if (this.text != null) {
                this.ww = this.width - this.fm.getTextWidth(this.text) >> 1;
                this.hh = this.height - this.fmH >> 1;
                return;
            }
        } else if (this.img != null) {
            this.ww = this.width - this.img.getWidth() >> 1;
            this.hh = this.height - this.img.getHeight() >> 1;
        }
    }

    protected void onColorsChanged(boolean bl) {
        this.fColor = this.getForeColor();
        if (Settings.uiStyle == 1) {
            this.aColor = this.backColor.getCursorColor();
        }
        Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.fourColors);
    }

    public void onEvent(Event event) {
        if (!this.ignoreEvents) {
            switch (event.type) {
                case 498: {
                    if (this.myg != null) {
                        this.myg.free();
                    }
                    this.myg = this.createGraphics();
                    return;
                }
                case 200: {
                    this.armed = true;
                    this.repaint();
                    return;
                }
                case 202: {
                    this.armed = false;
                    this.repaint();
                    PenEvent penEvent = (PenEvent)event;
                    if (penEvent.x < 0 || penEvent.x >= this.width || penEvent.y < 0 || penEvent.y >= this.height) break;
                    this.postEvent(new ControlEvent(300, this));
                    return;
                }
                case 203: {
                    PenEvent penEvent = (PenEvent)event;
                    boolean bl = false;
                    if (penEvent.x >= 0 && penEvent.x < this.width && penEvent.y >= 0 && penEvent.y < this.height) {
                        bl = true;
                    }
                    if (this.armed == bl) break;
                    this.armed = bl;
                    this.repaint();
                    return;
                }
                case 302: {
                    this.armed = false;
                }
            }
        }
    }

    protected void onFontChanged() {
        this.onBoundsChanged();
    }

    public void onPaint(Graphics graphics) {
        if (this.myg == null) {
            this.myg = this.createGraphics();
        }
        this.paintButton(graphics, this.armed);
    }

    public void onlyShowImage() {
        this.border = 0;
        this.ignoreEvents = true;
    }

    protected void paintButton(Graphics graphics, boolean bl) {
        int n = this.ww;
        int n2 = this.hh;
        if (!this.ignoreEvents || this.img == null) {
            if (Settings.uiStyle == 0) {
                graphics.setBackColor(this.backColor);
                graphics.fillRect(0, 0, this.width, this.height);
            } else {
                graphics.setBackColor(bl ? this.aColor : this.backColor);
                if (this.border == 0) {
                    graphics.fillRect(0, 0, this.width, this.height);
                } else {
                    graphics.fillHatchedRect(0, 0, this.width, this.height, true, true);
                }
            }
            if (this.border != 0) {
                graphics.draw3dRect(0, 0, this.width, this.height, bl ? (byte)2 : 3, false, this.border == 1, this.fourColors);
            }
            graphics.setClip(this.border, this.border, this.width - (this.border << 1), this.height - (this.border << 1));
            if (bl && Settings.uiStyle == 0) {
                ++n;
                ++n2;
            }
            graphics.setForeColor(this.fColor);
            if (this.isText) {
                graphics.drawText(this.text, n, n2);
            }
        }
        if (!this.isText) {
            if (this.imgColor != null) {
                graphics.setBackColor(this.imgColor);
                graphics.setDrawOp(this.enabled ? 6 : 7);
            } else {
                graphics.setDrawOp(this.enabled ? 0 : 7);
            }
            graphics.drawImage(this.img, n, n2);
            graphics.setDrawOp(0);
        }
    }

    public void press(boolean bl) {
        this.myg.clearClip();
        Button button = this;
        button.paintButton(button.myg, bl);
    }

    public void setBorder(byte by) {
        this.border = by;
    }

    public void setGap(int n) {
        this.gap = n;
    }

    public void setText(String string) {
        this.text = string;
        this.isText = true;
        this.img = null;
        this.repaint();
    }
}

