/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Coord;
import waba.fx.Font;
import waba.fx.FontMetrics;
import waba.fx.Graphics;
import waba.fx.ISurface;
import waba.fx.Rect;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Container;
import waba.ui.Event;
import waba.ui.MainWindow;
import waba.ui.Timer;
import waba.ui.Window;

public class Control
implements ISurface {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected Container parent;
    Control next;
    Control prev;
    protected boolean enabled = true;
    protected Font font = MainWindow.defaultFont;
    public FontMetrics fm;
    protected boolean visible = true;
    protected Color foreColor;
    protected Color backColor;
    public int appId;
    public static final int PREFERRED = 100000;
    public static final int LEFT = 110000;
    public static final int CENTER = 120000;
    public static final int RIGHT = 130000;
    public static final int TOP = 140000;
    public static final int BOTTOM = 150000;
    public static final int FILL = 160000;
    public static final int BEFORE = 170000;
    public static final int SAME = 180000;
    public static final int AFTER = 190000;
    public static final int FIT = 200000;
    protected int fmH;
    protected Color foreDis;
    protected Color backDis;
    protected int x2;
    protected int y2;
    protected boolean focusLess;
    boolean eventsEnabled = true;
    public static final int RANGE = 4000;
    protected Container asContainer;
    protected Window asWindow;

    protected Control() {
        Control control = this;
        control.fm = control.getFontMetrics(control.font);
        this.fmH = this.fm.getHeight();
    }

    public Timer addTimer(int n) {
        return MainWindow._mainWindow.addTimer(this, n);
    }

    public boolean contains(int n, int n2) {
        return this.x <= n && n <= this.x2 && this.y <= n2 && n2 <= this.y2;
    }

    public Graphics createGraphics() {
        int n = 0;
        int n2 = 0;
        Control control = this;
        while (control.asWindow == null) {
            n += control.x;
            n2 += control.y;
            control = control.parent;
            if (control != null) continue;
            return null;
        }
        Graphics graphics = new Graphics(this);
        graphics.translate(n + control.asWindow.x, n2 + control.asWindow.y);
        graphics.setFont(this.font);
        return graphics;
    }

    public Rect getAbsoluteRect() {
        Rect rect = this.getRect();
        Container container = this.parent;
        while (container != null) {
            rect.x += container.x;
            rect.y += container.y;
            container = container.parent;
        }
        return rect;
    }

    public Color getBackColor() {
        if (this.enabled || this.parent == null) {
            return this.backColor;
        }
        if (this.backColor.equ == Color.WHITE.equ && this.backColor.equ == this.parent.getBackColor().equ) {
            return Color.WHITE;
        }
        return this.backDis;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return MainWindow._mainWindow.getFontMetrics(font);
    }

    public Color getForeColor() {
        if (this.enabled) {
            return this.foreColor;
        }
        return this.foreDis;
    }

    public Control getNext() {
        return this.next;
    }

    public Container getParent() {
        return this.parent;
    }

    /*
     * Unable to fully structure code
     */
    public Window getParentWindow() {
        var1_1 = this.parent;
        if (var1_1 == null || var1_1.parentWindow == null) ** GOTO lbl5
        return var1_1.parentWindow;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.parent;
lbl5:
            // 2 sources

            ** while (var1_1 != null && var1_1.asWindow == null)
        }
lbl6:
        // 1 sources

        if (var1_1 != null) {
            return (Window)var1_1;
        }
        return Window.getTopMost();
    }

    public Coord getPos() {
        return new Coord(this.x, this.y);
    }

    public int getPreferredHeight() {
        return this.fmH;
    }

    public int getPreferredWidth() {
        return 30;
    }

    public Rect getRect() {
        return new Rect(this.x, this.y, this.width, this.height);
    }

    public Coord getSize() {
        return new Coord(this.width, this.height);
    }

    public boolean isDisplayed() {
        Control control = this;
        while (control.asWindow == null) {
            control = control.parent;
            if (control != null) continue;
            return false;
        }
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void onBoundsChanged() {
    }

    protected void onColorsChanged(boolean bl) {
    }

    public void onEvent(Event event) {
    }

    protected void onFontChanged() {
    }

    public void onPaint(Graphics graphics) {
    }

    protected void onWindowPaintFinished() {
    }

    public void postEvent(Event event) {
        if (!this.enabled || !this.eventsEnabled) {
            return;
        }
        Control control = this;
        while (control != null) {
            Container container = control.parent;
            control.onEvent(event);
            if (event.consumed) {
                event.consumed = false;
                return;
            }
            if (container != control.parent) break;
            control = container;
        }
    }

    public boolean removeTimer(Timer timer) {
        return MainWindow._mainWindow.removeTimer(timer);
    }

    public void repaint() {
        block2: {
            int n = 0;
            int n2 = 0;
            Control control = this;
            while (control.asWindow == null) {
                n += control.x;
                n2 += control.y;
                control = control.parent;
                if (control != null) {
                    continue;
                }
                break block2;
            }
            control.asWindow.damageRect(n, n2, this.width, this.height);
        }
    }

    public void repaintNow() {
        if (this.asWindow != null) {
            this.repaint();
            this.asWindow._doPaint(0, 0, this.width, this.height);
            return;
        }
        Graphics graphics = this.createGraphics();
        if (graphics != null) {
            this.onPaint(graphics);
            if (this.asContainer != null) {
                this.asContainer.paintChildren(graphics, 0, 0, this.width, this.height);
            }
        }
    }

    public void requestFocus() {
        this.getParentWindow().setFocus(this);
    }

    public void setBackColor(Color color) {
        this.backColor = color;
        this.backDis = this.backColor.darker();
        this.onColorsChanged(true);
    }

    public void setBackForeColors(Color color, Color color2) {
        this.backColor = color;
        this.backDis = this.backColor.darker();
        this.foreColor = color2;
        this.foreDis = this.foreColor.brighter();
        this.onColorsChanged(true);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.onColorsChanged(false);
            this.repaint();
        }
    }

    public void setFocusLess(boolean bl) {
        this.focusLess = bl;
        if (this.asContainer != null) {
            Control control = this.asContainer.children;
            while (control != null) {
                if (control.asContainer != null) {
                    control.setFocusLess(bl);
                } else {
                    control.focusLess = bl;
                }
                control = control.next;
            }
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.fm = this.getFontMetrics(font);
        this.fmH = this.fm.getHeight();
        this.onFontChanged();
    }

    public void setForeColor(Color color) {
        this.foreColor = color;
        this.foreDis = this.foreColor.brighter();
        this.onColorsChanged(true);
    }

    public void setRect(int n, int n2, int n3, int n4) {
        this.setRect(n, n2, n3, n4, null);
    }

    public void setRect(int n, int n2, int n3, int n4, Control control) {
        if (this.parent != null || this.asWindow != null) {
            this.repaint();
        }
        if (n + n2 + n3 + n4 >= 50000) {
            int n5;
            int n6;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            if (this.parent == null) {
                n6 = Settings.screenWidth;
                n5 = Settings.screenHeight;
            } else {
                Rect rect = this.parent.getClientRect();
                n7 = rect.x;
                n8 = rect.y;
                n6 = rect.width;
                n5 = rect.height;
                n9 = this.parent.lastX;
                n10 = this.parent.lastY;
                if (n6 == 0 || n5 == 0) {
                    Vm.debug("Warning! " + this.parent + " must have its bounds set before calling " + this + ".setRect");
                }
                if (control != null) {
                    this.parent.lastX = control.x;
                    this.parent.lastY = control.y;
                    this.parent.lastW = control.width;
                    this.parent.lastH = control.height;
                } else {
                    if (this.parent.lastX == -1) {
                        this.parent.lastX = n7;
                    }
                    if (this.parent.lastY == -1) {
                        this.parent.lastY = n8;
                    }
                }
            }
            boolean bl = false;
            boolean bl2 = false;
            if (n3 >= 96000 && n3 <= 104000) {
                n3 = this.getPreferredWidth() + (n3 - 100000);
                bl = true;
            }
            if (n4 >= 96000 && n4 <= 104000) {
                n4 = this.getPreferredHeight() + (n4 - 100000);
                bl2 = true;
            }
            if (n3 >= 176000 && n3 <= 184000 && this.parent != null) {
                n3 = this.parent.lastW + n3 - 180000;
            }
            if (n4 >= 176000 && n4 <= 184000 && this.parent != null) {
                n4 = this.parent.lastH + n4 - 180000;
            }
            if (n > 50000) {
                if (n >= 106000 && n <= 114000) {
                    n = n7 + n - 110000;
                } else if (n >= 126000 && n <= 134000) {
                    n = n7 + n6 - n3 + n - 130000;
                } else if (n >= 116000 && n <= 124000) {
                    n = n7 + (n6 - n3 >> 1) + n - 120000;
                }
                if (this.parent != null) {
                    if (n >= 186000 && n <= 194000) {
                        n = this.parent.lastX + this.parent.lastW + n - 190000;
                    } else if (n >= 166000 && n <= 174000) {
                        n = this.parent.lastX - n3 + n - 170000;
                    } else if (n >= 176000 && n <= 184000) {
                        n = this.parent.lastX + n - 180000;
                    }
                }
            }
            if (n2 > 50000) {
                if (n2 >= 136000 && n2 <= 144000) {
                    n2 = n8 + n2 - 140000;
                } else if (n2 >= 146000 && n2 <= 154000) {
                    n2 = n8 + n5 - n4 + n2 - 150000;
                } else if (n2 >= 116000 && n2 <= 124000) {
                    n2 = n8 + (n5 - n4 >> 1) + n2 - 120000;
                }
                if (this.parent != null) {
                    if (n2 >= 186000 && n2 <= 194000) {
                        n2 = this.parent.lastY + this.parent.lastH + n2 - 190000;
                    } else if (n2 >= 166000 && n2 <= 174000) {
                        n2 = this.parent.lastY - n4 + n2 - 170000;
                    } else if (n2 >= 176000 && n2 <= 184000) {
                        n2 = this.parent.lastY + n2 - 180000;
                    }
                }
            }
            if (n3 > 50000) {
                if (n3 >= 156000 && n3 <= 164000) {
                    n3 = n6 - n + n7 + n3 - 160000;
                }
                if (this.parent != null && n3 >= 196000 && n3 <= 204000) {
                    n3 = n9 - n + n3 - 200000;
                }
            }
            if (n4 > 50000) {
                if (n4 >= 156000 && n4 <= 164000) {
                    n4 = n5 - n2 + n8 + n4 - 160000;
                }
                if (this.parent != null && n4 >= 196000 && n4 <= 204000) {
                    n4 = n10 - n2 + n4 - 200000;
                }
            }
            if (n + n2 + n3 + n4 > 50000) {
                n2 = 0;
                n = 0;
                n4 = 10;
                n3 = 10;
                Vm.debug("To use AFTER/BEFORE/SAME you must add first the control " + this.toString() + " to the parent container.");
            } else if (n + n2 < -50000) {
                if (n < -50000) {
                    Vm.debug("You can't use FILL with BEFORE or RIGHT for control " + this.toString());
                } else {
                    Vm.debug("You can't use FILL with BEFORE or BOTTOM for control " + this.toString());
                }
            } else if (this.parent != null) {
                int n11;
                if (bl && n + n3 > n7 + n6 && (n11 = n7 + n6 - n) > 0) {
                    n3 = n11;
                }
                if (bl2 && n2 + n4 > n8 + n5 && (n11 = n8 + n5 - n2) > 0) {
                    n4 = n11;
                }
            }
        }
        if (this.asWindow != null && this.fmH > 11 && !this.asWindow.highResPrepared) {
            float f = (float)this.fmH / 11.0f;
            n3 = (int)((float)n3 * f);
            n4 = (int)((float)n4 * f);
            n = Settings.screenWidth - n3 >> 1;
            n2 = Settings.screenHeight - n4 >> 1;
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.x2 = n + n3 - 1;
        this.y2 = n2 + n4 - 1;
        if (this.parent != null) {
            this.parent.lastX = n;
            this.parent.lastY = n2;
            this.parent.lastW = n3;
            this.parent.lastH = n4;
        }
        if (this.visible && this.parent != null || this.asWindow != null) {
            this.repaint();
        }
        this.onBoundsChanged();
        if (this.asContainer != null && !this.asContainer.started) {
            this.asContainer.started = true;
            this.asContainer.onStart();
        }
    }

    public void setRect(Rect rect) {
        this.setRect(rect.x, rect.y, rect.width, rect.height, null);
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.repaint();
            if (this.parent != null && this.parent.parentWindow != null) {
                this.parent.parentWindow.eraseBackgroundNow = true;
            }
        }
    }
}

