/*
 * Decompiled with CFR 0.152.
 */
package waba.fx;

import waba.fx.Palette;
import waba.sys.Convert;
import waba.sys.Settings;

public final class Color {
    protected int red;
    protected int green;
    protected int blue;
    protected int rgb;
    protected int gray;
    public int equ;
    protected Color bright;
    protected Color dark;
    private static boolean f1 = Settings.isColor ^ true;
    private static int f2;
    public static int fadeStep;
    public static int smallerFadeStep;
    public static final Color WHITE;
    public static final Color BRIGHT;
    public static final Color DARK;
    public static final Color BLACK;
    public static Color defaultForeColor;
    public static Color defaultBackColor;

    static {
        int n = f2 = Settings.maxColors == 4 ? 6 : 4;
        int n2 = f1 ? (Settings.maxColors == 4 ? 1 : 7) : (fadeStep = 96);
        smallerFadeStep = f1 ? (Settings.maxColors == 4 ? 1 : 4) : 32;
        WHITE = new Color(255, 255, 255);
        BRIGHT = new Color(191, 191, 191);
        DARK = new Color(127, 127, 127);
        defaultForeColor = BLACK = new Color(0, 0, 0);
        defaultBackColor = BRIGHT;
    }

    public Color(int n) {
        this.red = n >> 16 & 0xFF;
        this.green = n >> 8 & 0xFF;
        this.blue = n & 0xFF;
        this.rgb = n;
        if (f1) {
            this.equ = this.gray = ((this.red << 5) + (this.green << 6) + (this.blue << 2)) / 100 >> f2;
            return;
        }
        this.equ = this.rgb;
    }

    public Color(int n, int n2, int n3) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
        this.rgb = n << 16 | n2 << 8 | n3;
        if (f1) {
            Color color = this;
            color.equ = color.gray = ((n << 5) + (n2 << 6) + (n3 << 2)) / 100 >> f2;
            return;
        }
        this.equ = this.rgb;
    }

    public Color(String string) {
        this((int)Convert.toLong(string, 16));
    }

    public Color brighter() {
        if (f1) {
            if (this.bright == null) {
                this.bright = Palette.SystemPalette.getColor(this.gray + fadeStep);
            }
            return this.bright;
        }
        return new Color(Math.min(this.red + fadeStep, 255), Math.min(this.green + fadeStep, 255), Math.min(this.blue + fadeStep, 255));
    }

    public Color brighter(int n) {
        if (f1) {
            return Palette.SystemPalette.getColor(this.gray + n);
        }
        return new Color(Math.min(this.red + n, 255), Math.min(this.green + n, 255), Math.min(this.blue + n, 255));
    }

    public Color darker() {
        if (f1) {
            if (this.dark == null) {
                this.dark = Palette.SystemPalette.getColor(this.gray - fadeStep);
            }
            return this.dark;
        }
        return new Color(Math.max(this.red - fadeStep, 0), Math.max(this.green - fadeStep, 0), Math.max(this.blue - fadeStep, 0));
    }

    public Color darker(int n) {
        if (f1) {
            return Palette.SystemPalette.getColor(this.gray - n);
        }
        return new Color(Math.max(this.red - n, 0), Math.max(this.green - n, 0), Math.max(this.blue - n, 0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Color) {
            return ((Color)object).equ == this.equ;
        }
        return false;
    }

    public int getAlpha() {
        return ((this.red << 5) + (this.green << 6) + (this.blue << 2)) / 100;
    }

    public int getBlue() {
        return this.blue;
    }

    public Color getCursorColor() {
        int n = Settings.maxColors;
        if (n == 4) {
            return Palette.SystemPalette.getColor(1);
        }
        if (this.getAlpha() > 128) {
            return this.darker(n >= 256 ? fadeStep : smallerFadeStep);
        }
        return this.brighter(n >= 256 ? fadeStep : smallerFadeStep);
    }

    public int getGray() {
        if (f1) {
            return this.gray;
        }
        return this.getAlpha();
    }

    public int getGreen() {
        return this.green;
    }

    public int getRGB() {
        return this.rgb;
    }

    public int getRed() {
        return this.red;
    }

    public int hashCode() {
        return this.equ;
    }

    public String toString() {
        if (f1) {
            return Convert.toString(this.gray);
        }
        return Convert.unsigned2hex(this.rgb, 6);
    }
}

