/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import java.util.Date;
import waba.io.ByteArrayStream;
import waba.io.DataStream;
import waba.io.NativeMethods;
import waba.io.NativeMethods4JDK;
import waba.io.Stream;
import waba.sys.Vm;
import waba.util.Vector;

class NativeMethods4JDK$CatalogBag {
    private final NativeMethods4JDK f1;
    boolean _isOpen;
    String _name;
    int _mode;
    Vector _records;
    Vector _attrs;
    int _recordPos;
    int _cursor;
    String _creator;
    String _type;
    int originalModificationNumber;
    byte[] appInfoBlock;
    byte[] sortInfoBlock;
    int creationDate;
    int modificationDate;
    int lastBackupDate;
    int modificationNumber;
    short attributes;
    short version;
    int appInfoOffset;
    int sortInfoOffset;
    int uniqueIDSeed;
    int nextRecordListID;

    NativeMethods4JDK$CatalogBag(NativeMethods4JDK nativeMethods4JDK) {
        this.f1 = nativeMethods4JDK;
        this._records = new Vector();
        this._attrs = new Vector();
        this.attributes = (short)8;
        this.version = 1;
    }

    static void access$0(NativeMethods4JDK$CatalogBag nativeMethods4JDK$CatalogBag) {
        nativeMethods4JDK$CatalogBag.m1();
    }

    private void m1() {
        long l = this.m2();
        this.modificationDate = this.creationDate = (int)l;
        this.lastBackupDate = (int)(l -= 31536000L);
    }

    protected void finalize() throws Throwable {
        try {
            if (this._isOpen) {
                System.out.println("Catalog " + this._name + " being closed by GC...");
                ((NativeMethods4JDK)NativeMethods.nm).catalogClose(this);
                return;
            }
        }
        catch (Exception exception) {}
    }

    public Vector fromPDB(byte[] byArray, String string, String string2, Vector vector) throws Exception {
        int n;
        DataStream dataStream = new DataStream(new ByteArrayStream(byArray));
        if (byArray.length == 0) {
            throw new Exception("Invalid File with 0 length!");
        }
        byte[] byArray2 = new byte[32];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        dataStream.readBytes(byArray2);
        this.attributes = dataStream.readShort();
        this.version = dataStream.readShort();
        this.creationDate = dataStream.readInt();
        this.modificationDate = dataStream.readInt();
        this.lastBackupDate = dataStream.readInt();
        this.modificationNumber = dataStream.readInt();
        this.appInfoOffset = dataStream.readInt();
        this.sortInfoOffset = dataStream.readInt();
        dataStream.readBytes(byArray3);
        dataStream.readBytes(byArray4);
        this.uniqueIDSeed = dataStream.readInt();
        this.originalModificationNumber = this.modificationNumber;
        if (!string.equals(new String(byArray4)) || !string2.equals(new String(byArray3))) {
            if (byArray.length >= 8 && new String(byArray, 0, 8).trim().equalsIgnoreCase("<HTML>")) {
                return new Vector();
            }
            throw new Exception("Error: invalid pdb file! creatorId '" + string + "' != '" + new String(byArray4) + "' and/or typeId '" + string2 + "' != '" + new String(byArray3) + "' \n" + new String(byArray));
        }
        this.nextRecordListID = dataStream.readInt();
        if (this.nextRecordListID != 0) {
            throw new Exception("Invalid database file! SuperWaba does not support multiple record or resource lists in a Database!!!");
        }
        int n2 = dataStream.readUnsignedShort();
        int[] nArray = new int[n2 + 1];
        byte[] byArray5 = new byte[3];
        if (vector != null) {
            vector.clear();
        }
        int n3 = 0;
        while (n3 < n2) {
            nArray[n3] = dataStream.readInt();
            byte by = dataStream.readByte();
            dataStream.readBytes(byArray5);
            if (vector != null) {
                vector.addElement(new Byte(by));
            }
            ++n3;
        }
        nArray[n2] = byArray.length;
        dataStream.readShort();
        int n4 = 80 + (n2 << 3);
        if (this.appInfoOffset > 0) {
            n = this.sortInfoOffset > 0 ? this.sortInfoOffset - n4 : nArray[0] - n4;
            this.appInfoBlock = new byte[n];
            dataStream.readBytes(this.appInfoBlock);
            n4 += n;
        }
        if (this.sortInfoOffset > 0) {
            n = nArray[0] - n4;
            this.sortInfoBlock = new byte[n];
            dataStream.readBytes(this.sortInfoBlock);
        }
        Vector vector2 = new Vector(n2);
        int n5 = 0;
        while (n5 < n2) {
            int n6 = nArray[n5 + 1] - nArray[n5];
            if (n6 <= 0) {
                throw new Exception("Invalid record " + n5 + "! Size <= 0 (" + n6 + ")");
            }
            byte[] byArray6 = new byte[n6];
            dataStream.readBytes(byArray6);
            vector2.addElement(byArray6);
            ++n5;
        }
        dataStream.close();
        return vector2;
    }

    private long m2() {
        return new Date().getTime() / 1000L + 2082844800L;
    }

    public void toPDB(Stream stream, Vector vector, String string, String string2, String string3, Vector vector2) throws Exception {
        int n;
        byte[] byArray = new byte[32];
        byte[] byArray2 = string3.getBytes();
        byte[] byArray3 = string.getBytes();
        int n2 = string2.lastIndexOf(92);
        if (n2 != -1 || (n2 = string2.lastIndexOf(47)) != -1) {
            string2 = string2.substring(n2 + 1);
        }
        if (string2.length() > 31) {
            string2 = string2.substring(0, 31);
        }
        byte[] byArray4 = string2.getBytes();
        int n3 = 0;
        while (n3 < byArray.length) {
            int n4 = n3;
            byArray[n4] = n4 < byArray4.length ? byArray4[n3] : (byte)0;
            ++n3;
        }
        int n5 = vector.size();
        DataStream dataStream = new DataStream(stream);
        int n6 = 80 + (n5 << 3);
        if (this.appInfoBlock != null) {
            this.appInfoOffset = n6;
            n6 += this.appInfoBlock.length;
        }
        if (this.sortInfoBlock != null) {
            this.sortInfoOffset = n6;
            n6 += this.sortInfoBlock.length;
        }
        this.modificationDate = (int)this.m2();
        dataStream.writeBytes(byArray);
        dataStream.writeShort(this.attributes);
        dataStream.writeShort(this.version);
        dataStream.writeInt(this.creationDate);
        dataStream.writeInt(this.modificationDate);
        dataStream.writeInt(this.lastBackupDate);
        dataStream.writeInt(this.modificationNumber);
        dataStream.writeInt(this.appInfoOffset);
        dataStream.writeInt(this.sortInfoOffset);
        dataStream.writeBytes(byArray2);
        dataStream.writeBytes(byArray3);
        dataStream.writeInt(this.uniqueIDSeed);
        dataStream.writeInt(0);
        dataStream.writeShort(n5);
        byte[] byArray5 = new byte[3];
        int n7 = 0;
        while (n7 < n5) {
            dataStream.writeInt(n6);
            if (vector2 == null || n7 >= vector2.size()) {
                dataStream.writeByte(0);
            } else {
                dataStream.writeByte((int)((Byte)vector2.elementAt(n7) & 0xFFFFFFDF));
            }
            dataStream.writeBytes(byArray5);
            n = ((byte[])vector.elementAt(n7)).length;
            if (n > 65520) {
                Vm.debug("CAUTION! RECORD " + n7 + " HAS A SIZE GREATER THAN 65520 AND WILL BE REJECTED BY PALM OS!");
            }
            n6 += n;
            ++n7;
        }
        dataStream.writeShort(0);
        if (this.appInfoBlock != null) {
            dataStream.writeBytes(this.appInfoBlock);
        }
        n = 0;
        while (n < n5) {
            dataStream.writeBytes((byte[])vector.elementAt(n));
            ++n;
        }
        dataStream.close();
    }
}

