/*
 * Decompiled with CFR 0.152.
 */
package waba.io;

import waba.io.Catalog;
import waba.io.Stream;

public class ResizeStream
extends Stream {
    private Catalog f1;
    private int f2;
    private int f3;
    private int f4;

    public ResizeStream(Catalog catalog, int n) {
        this.f1 = catalog;
        this.f2 = n;
    }

    public boolean close() {
        return this.f1.close();
    }

    public void endRecord() {
        this.f1.resizeRecord(this.f3);
        this.f4 = 0;
    }

    public boolean isOpen() {
        return this.f1.isOpen();
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        return this.f1.readBytes(byArray, n, n2);
    }

    public boolean restartRecord(int n) {
        if (n < 0 || n >= this.f1.getRecordCount()) {
            return this.startRecord();
        }
        this.f3 = 0;
        this.f4 = this.f2;
        if (this.f1.setRecordPos(n)) {
            this.f4 = this.f1.getRecordSize();
            return true;
        }
        return false;
    }

    public boolean startRecord() {
        boolean bl = this.f1.addRecord(this.f2) != -1;
        this.f3 = 0;
        this.f4 = this.f2;
        return bl;
    }

    public boolean startRecord(int n) {
        boolean bl = n >= this.f1.getRecordCount() ? this.f1.addRecord(this.f2) != -1 : this.f1.addRecord(this.f2, n) != -1;
        this.f3 = 0;
        this.f4 = this.f2;
        return bl;
    }

    public int writeBytes(byte[] byArray, int n, int n2) {
        if (this.f4 == 0) {
            return this.f1.writeBytes(byArray, n, n2);
        }
        if (n2 - n <= 0) {
            return 0;
        }
        int n3 = this.f3 + (n2 - n);
        while (n3 > this.f4) {
            this.f4 += this.f2;
            if (this.f1.resizeRecord(this.f4)) continue;
            return -1;
        }
        int n4 = this.f1.writeBytes(byArray, n, n2);
        if (n4 >= 0) {
            this.f3 += n4;
        }
        return n4;
    }
}

