/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Sound;
import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Vm;
import waba.ui.Control;
import waba.ui.Edit;
import waba.ui.Event;
import waba.ui.KeyEvent;
import waba.ui.Label;
import waba.ui.PushButtonGroup;
import waba.ui.Window;

public class Calculator
extends Window {
    private Edit f1;
    private Edit f2;
    private Edit f3;
    private Label f4;
    private PushButtonGroup f5;
    private PushButtonGroup f6;
    private PushButtonGroup f7;
    private PushButtonGroup f8;
    private String[] f9 = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", ".", "-"};
    private String f10;

    public Calculator() {
        super("Calculator", (byte)1);
        this.highResPrepared = true;
        float f = (float)this.fmH / 11.0f;
        int n = f == 1.0f ? 110 : (int)(f * 95.0f);
        int n2 = f == 1.0f ? 113 : (int)(f * 100.0f);
        this.setRect(120000, 120000, n, n2);
    }

    public void clear(boolean bl) {
        if (bl) {
            Calculator calculator = this;
            calculator.setFocus(calculator.f1);
        }
        this.f1.setText("");
        this.f2.setText("");
        this.f4.setText("");
        this.f10 = null;
    }

    public String getAnswer() {
        return this.f10;
    }

    private boolean m1(String string) {
        return string != null && string.length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onEvent(Event event) {
        switch (event.type) {
            case 100: {
                if (((KeyEvent)event).key != 76007) return;
                Sound.beep();
                this.unpop();
                return;
            }
            case 302: {
                if (!(event.target instanceof Edit)) return;
                this.m2((Edit)event.target);
                return;
            }
            case 300: {
                int n;
                if (event.target == this.f5 && this.f5.getSelected() != -1) {
                    String string = this.f10 = this.f5.getSelected() == 0 ? this.f1.getText() : this.f4.getText();
                    if (this.f3 != null) {
                        this.f3.setText(this.f10);
                    }
                    this.unpop();
                    return;
                }
                if (event.target == this.f6 && this.f6.getSelected() != -1) {
                    switch (this.f6.getSelected()) {
                        case 0: {
                            this.f1.setText(this.f4.getText());
                            this.f2.setText("");
                            this.f4.setText("");
                            return;
                        }
                        case 1: {
                            this.clear(true);
                            return;
                        }
                        case 2: {
                            this.unpop();
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                if (event.target == this.f7) {
                    Calculator calculator = this;
                    if (calculator.m2(calculator.f1)) {
                        Calculator calculator2 = this;
                        if (calculator2.m2(calculator2.f2)) {
                            double d = Convert.toDouble(this.f1.getText());
                            double d2 = Convert.toDouble(this.f2.getText());
                            double d3 = 0.0;
                            switch (this.f7.getSelected()) {
                                case 0: {
                                    d3 = d + d2;
                                    break;
                                }
                                case 1: {
                                    d3 = d - d2;
                                    break;
                                }
                                case 2: {
                                    d3 = d * d2;
                                    break;
                                }
                                case 3: {
                                    d3 = d / d2;
                                    break;
                                }
                                case 4: {
                                    d3 = Math.pow(d, d2);
                                }
                            }
                            this.f4.setText(Convert.toString(d3, 4));
                            return;
                        }
                    }
                }
                if (event.target != this.f8 || !(this.getFocus() instanceof Edit) || (n = this.f8.getSelected()) == -1) return;
                KeyEvent keyEvent = new KeyEvent();
                new KeyEvent().key = this.f9[n].charAt(0);
                keyEvent.target = this.getFocus();
                keyEvent.type = 100;
                this.getFocus().onEvent(keyEvent);
            }
        }
    }

    public void onPopup() {
        this.clear(false);
        Control control = Window.topMost.getFocus();
        if (control instanceof Edit) {
            char c;
            this.f3 = (Edit)control;
            String string = this.f3.getText();
            if (string.length() > 0 && ((c = string.charAt(0)) == '-' || c >= '0' && c <= '9')) {
                this.f1.setText(string);
                return;
            }
        } else {
            this.f3 = null;
        }
    }

    public void onStart() {
        if (Settings.isColor) {
            this.setBackColor(new Color(0, 240, 160));
        }
        String[] stringArray = new String[]{" + ", " - ", " * ", " / ", " ^ "};
        String[] stringArray2 = new String[]{"Paste Op 1", "Paste Total"};
        String[] stringArray3 = new String[]{"Reuse", "Clear", "Cancel"};
        this.f1 = new Edit("999999999,99");
        this.add(this.f1, 110002, 140002);
        this.f1.setMode((byte)2);
        this.f1.setKeyboard((byte)0);
        this.f2 = new Edit("999999999,99");
        this.add(this.f2, 180000, 190002);
        this.f2.setMode((byte)2);
        this.f2.setKeyboard((byte)0);
        this.f7 = new PushButtonGroup(stringArray, false, -1, -1, 4, 0, false, 1);
        this.add(this.f7, 110000 + (this.f1.width - this.f7.getPreferredWidth() >> 1), 190004);
        this.f5 = new PushButtonGroup(stringArray2, false, -1, 2, 4, 2, true, 1);
        this.add(this.f5, 110002, 149998);
        this.f6 = new PushButtonGroup(stringArray3, false, -1, 2, 4, 3, true, 1);
        this.add(this.f6, 129998, 149998);
        this.f4 = new Label("");
        this.add(this.f4);
        this.f4.setRect(110002, 180000, 160000 - this.f6.getPreferredWidth() - 4, 100000);
        this.f8 = new PushButtonGroup(this.f9, false, -1, -1, 6, 4, true, 1);
        this.add(this.f8, 129998, 140002);
        this.f8.setFocusLess(true);
        if (Settings.isColor) {
            this.f7.setBackColor(new Color(200, 200, 20));
            this.f5.setBackColor(new Color(0, 160, 230));
            this.f6.setBackColor(new Color(200, 0, 200));
            this.f8.setBackColor(new Color(0, 204, 192));
        }
        this.clear(false);
    }

    public void onUnpop() {
        Calculator calculator = this;
        calculator.setFocus(calculator);
    }

    public void postPopup() {
        String string = this.f1.getText();
        this.setFocus(string.length() > 0 && Convert.toDouble(string) != 0.0 ? this.f2 : this.f1);
    }

    private boolean m2(Edit edit) {
        Object object;
        if (this != Window.topMost) {
            return true;
        }
        String string = edit.getText();
        boolean bl = this.m1(string);
        String string2 = null;
        if (edit == this.f1 || edit == this.f2) {
            object = "";
            if (bl && (((String)(object = Convert.toString(string, 4))).length() <= 0 || ((String)object).equals("0"))) {
                string2 = "err: " + string;
            } else if (this.m1((String)object)) {
                string = object;
            }
        }
        if (string2 != null) {
            Sound.beep();
            edit.setText(string2);
            object = edit.createGraphics();
            edit.onPaint((Graphics)object);
            ((Graphics)object).free();
            Vm.sleep(1500);
        }
        if (this.m1(string)) {
            edit.setText(string);
        }
        return string2 == null;
    }
}

