/*
 * Decompiled with CFR 0.152.
 */
package waba.ui;

import waba.fx.Color;
import waba.fx.Graphics;
import waba.fx.Rect;
import waba.ui.Control;
import waba.ui.Event;
import waba.ui.Window;

public class Container
extends Control {
    protected Control children;
    protected Control tail;
    private byte f1 = 0;
    private Color[] f2 = new Color[4];
    public static final byte BORDER_NONE = 0;
    public static final byte BORDER_LOWERED = 2;
    public static final byte BORDER_RAISED = 3;
    public static final byte BORDER_SIMPLE = 5;
    protected Window parentWindow;
    protected int lastX = -1;
    protected int lastY = -1;
    protected int lastW;
    protected int lastH;
    private int f3;
    boolean started;

    public Container() {
        this.foreColor = Color.defaultForeColor;
        this.backColor = Color.defaultBackColor;
        this.foreDis = this.foreColor.brighter();
        this.backDis = this.backColor.darker();
        this.asContainer = this;
    }

    public void add(Control control) {
        if (control.parent != null) {
            control.parent.remove(control);
        }
        control.next = null;
        if (this.children == null) {
            this.children = control;
        } else {
            this.tail.next = control;
        }
        control.prev = this.tail;
        this.tail = control;
        control.parent = this;
        if (control.backColor == null) {
            control.backColor = this.backColor;
            control.backDis = this.backDis;
        }
        if (control.foreColor == null) {
            control.foreColor = this.foreColor;
            control.foreDis = this.foreDis;
        }
        ++this.f3;
        if (control.asContainer != null) {
            control.asContainer.parentWindow = this.parentWindow;
        }
        control.onColorsChanged(true);
        control.repaint();
    }

    public void add(Control control, int n, int n2) {
        this.add(control);
        control.setRect(n, n2, 100000, 100000, null);
    }

    public void add(Control control, int n, int n2, Control control2) {
        this.add(control);
        control.setRect(n, n2, 100000, 100000, control2);
    }

    public void broadcastEvent(Event event) {
        this.onEvent(event);
        Control control = this.children;
        while (control != null) {
            control.onEvent(event);
            if (control.asContainer != null) {
                control.asContainer.broadcastEvent(event);
            }
            control = control.next;
        }
    }

    public Control findChild(int n, int n2) {
        Container container = this;
        while (true) {
            Control control = container.tail;
            while (!(control == null || control.contains(n, n2) && control.visible)) {
                control = control.prev;
            }
            if (control == null) {
                return container;
            }
            if (control.asContainer == null) {
                return control;
            }
            n -= control.x;
            n2 -= control.y;
            container = control.asContainer;
        }
    }

    public Control[] getChildren() {
        if (this.f3 == 0) {
            return null;
        }
        Control[] controlArray = new Control[this.f3];
        Control control = this.tail;
        int n = 0;
        while (control != null) {
            controlArray[n] = control;
            ++n;
            control = control.prev;
        }
        return controlArray;
    }

    public Rect getClientRect() {
        int n;
        int n2 = n = this.f1 == 0 ? 0 : (this.f1 == 5 ? 1 : 2);
        return new Rect(n2, n2, this.width - n - n, this.height - n - n);
    }

    protected void onColorsChanged(boolean bl) {
        if (this.f1 != 0 && this.f1 != 5) {
            Graphics.compute3dColors(this.enabled, this.backColor, this.foreColor, this.f2);
        }
    }

    public void onPaint(Graphics graphics) {
        if (this.parent != null && this.backColor != this.parent.backColor) {
            graphics.setBackColor(this.backColor);
            graphics.fillRect(0, 0, this.width, this.height);
        }
        switch (this.f1) {
            case 5: {
                graphics.setForeColor(this.getForeColor());
                graphics.drawRect(0, 0, this.width, this.height);
                return;
            }
            default: {
                graphics.draw3dRect(0, 0, this.width, this.height, this.f1, false, false, this.f2);
            }
            case 0: 
        }
    }

    protected void onStart() {
    }

    public void paintChildren(Graphics graphics, int n, int n2, int n3, int n4) {
        Control control = this.children;
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        while (control != null) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            if (control.visible && (n14 = n5) >= (n13 = control.x) && (n12 = n) <= (n11 = control.x2) && (n10 = n6) >= (n9 = control.y) && (n8 = n2) <= (n7 = control.y2)) {
                if (n12 < n13) {
                    n12 = n13;
                }
                if (n8 < n9) {
                    n8 = n9;
                }
                if (n14 > n11) {
                    n14 = n11;
                }
                if (n10 > n7) {
                    n10 = n7;
                }
                graphics.setClip(n12, n8, n14 - n12 + 1, n10 - n8 + 1);
                graphics.translate(n13, n9);
                if (control.font != graphics.lastFont) {
                    graphics.setFont(control.font);
                }
                control.onPaint(graphics);
                if (control.asContainer != null) {
                    control.asContainer.paintChildren(graphics, n12 - n13, n8 - n9, n14 - n12 + 1, n10 - n8 + 1);
                }
                graphics.translate(-n13, -n9);
            }
            control = control.next;
        }
        graphics.clearClip();
    }

    public void remove(Control control) {
        if (control.parent == this) {
            Control control2 = control.prev;
            Control control3 = control.next;
            if (control2 == null) {
                this.children = control3;
            } else {
                control2.next = control3;
            }
            if (control3 != null) {
                control3.prev = control2;
            }
            if (this.tail == control) {
                this.tail = control2;
            }
            control.next = null;
            control.prev = null;
            --this.f3;
            control.repaint();
            this.repaint();
            control.parent = null;
            if (this.getParentWindow().getFocus() == control) {
                this.requestFocus();
            }
        }
    }

    public void setBorderStyle(byte by) {
        this.f1 = by;
        this.onColorsChanged(false);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.enabled) {
            this.enabled = bl;
            this.onColorsChanged(false);
            Control control = this.children;
            while (control != null) {
                control.setEnabled(bl);
                control = control.next;
            }
            this.repaint();
        }
    }
}

