/*
 * Decompiled with CFR 0.152.
 */
package waba.util;

import waba.sys.Convert;
import waba.sys.Settings;
import waba.sys.Time;

public class Date {
    public static String[] monthNames = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private int f1 = 0;
    private int f2 = 0;
    private int f3 = 0;
    private int f4 = 0;
    private int f5 = 1920;
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THRUSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int JANUARY = 1;
    public static final int FEBRUARY = 2;
    public static final int MARCH = 3;
    public static final int APRIL = 4;
    public static final int MAY = 5;
    public static final int JUNE = 6;
    public static final int JULY = 7;
    public static final int AUGUST = 8;
    public static final int SEPTEMBER = 9;
    public static final int OCTOBER = 10;
    public static final int NOVEMBER = 11;
    public static final int DECEMBER = 12;
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    public static boolean allowDay99 = false;
    private static byte[] f6;

    static {
        byte[] byArray = new byte[13];
        byArray[1] = 31;
        byArray[2] = 28;
        byArray[3] = 31;
        byArray[4] = 30;
        byArray[5] = 31;
        byArray[6] = 30;
        byArray[7] = 31;
        byArray[8] = 31;
        byArray[9] = 30;
        byArray[10] = 31;
        byArray[11] = 30;
        byArray[12] = 31;
        f6 = byArray;
    }

    public Date() {
        this.setToday();
    }

    public Date(int n) {
        this.f1 = n % 100;
        this.f2 = n / 100 % 100;
        this.f3 = n / 10000;
        if (this.m1()) {
            this.m4();
            return;
        }
        this.setToday();
    }

    public Date(int n, int n2, int n3) {
        this.f1 = n;
        this.f2 = n2;
        this.f3 = n3;
        if (this.m1()) {
            this.m4();
            return;
        }
        this.setToday();
    }

    public Date(String string) {
        this(string, Settings.dateFormat);
    }

    public Date(String string, byte by) {
        StringBuffer[] stringBufferArray = new StringBuffer[3];
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            int n = 0;
            stringBufferArray[0] = new StringBuffer();
            int n2 = 0;
            while (n2 < cArray.length) {
                if (cArray[n2] >= '0' && cArray[n2] <= '9') {
                    stringBufferArray[n].append(cArray[n2]);
                } else {
                    if (++n == 3) {
                        this.setToday();
                        return;
                    }
                    stringBufferArray[n] = new StringBuffer();
                }
                ++n2;
            }
            if (n != 2) {
                this.setToday();
                return;
            }
            int n3 = Convert.toInt(stringBufferArray[0].toString());
            int n4 = Convert.toInt(stringBufferArray[1].toString());
            int n5 = Convert.toInt(stringBufferArray[2].toString());
            if (by == 1) {
                this.f1 = n4;
                this.f2 = n3;
                this.f3 = n5;
            } else if (by == 3) {
                this.f1 = n5;
                this.f2 = n4;
                this.f3 = n3;
            } else {
                this.f1 = n3;
                this.f2 = n4;
                this.f3 = n5;
            }
        }
        if (this.m1()) {
            this.m4();
            return;
        }
        this.setToday();
    }

    public void advance(int n) {
        int n2 = this.getJulianDay() + n;
        int n3 = 0;
        int n4 = this.f5;
        while (n2 >= 366) {
            if (n2 == 366 && n4 % 4 == 0) break;
            if (n4 % 4 == 0) {
                n2 -= 366;
                ++n3;
            } else {
                n2 -= 365;
                ++n3;
            }
            ++n4;
        }
        this.f3 = this.f5 + n3;
        n4 = 1;
        while (n2 > this.getDaysInMonth(n4)) {
            n2 -= this.getDaysInMonth(n4);
            ++n4;
        }
        this.f2 = n4;
        this.f1 = n2;
        if (this.m1()) {
            this.m4();
            return;
        }
        this.f1 = 1;
        this.f2 = 1;
        this.f3 = 1983;
    }

    public void advanceMonth() {
        this.advanceMonth(true);
    }

    public void advanceMonth(boolean bl) {
        if (bl) {
            ++this.f2;
            if (this.f2 == 13) {
                ++this.f3;
                this.f2 = 1;
            }
        } else {
            --this.f2;
            if (this.f2 == 0) {
                --this.f3;
                this.f2 = 12;
            }
        }
        this.f1 = 1;
        if (!this.m1()) {
            this.f1 = 1;
            this.f2 = 1;
            this.f3 = 1983;
        }
    }

    public void advanceWeek() {
        this.advanceWeek(true);
    }

    public void advanceWeek(boolean bl) {
        this.advance(-1 * this.getDayOfWeek());
        if (bl) {
            this.advance(7);
        } else {
            this.advance(-7);
        }
        if (!this.m1()) {
            this.f1 = 1;
            this.f2 = 1;
            this.f3 = 1983;
        }
    }

    private boolean m1() {
        if (this.f3 >= 0 && this.f3 < 20) {
            this.f3 += 2000;
        } else if (this.f3 >= 20 && this.f3 < 100) {
            this.f3 += 1900;
        }
        return this.f1 > 0 && this.f2 >= 1 && this.f2 <= 12 && (this.f1 <= this.getDaysInMonth() || allowDay99 && this.f1 == 99) && this.f3 >= this.f5 && this.f3 < 3000;
    }

    public boolean equals(Date date) {
        return this.getDate().equals(date.getDate());
    }

    public static String formatDate(int n, int n2, int n3) {
        return Date.formatDate(n, n2, n3, Settings.dateFormat);
    }

    public static String formatDate(int n, int n2, int n3, byte by) {
        int n4 = n;
        int n5 = n2;
        int n6 = n3;
        if (by == 1) {
            n4 = n2;
            n5 = n;
            n6 = n3;
        } else if (by == 3) {
            n4 = n3;
            n5 = n2;
            n6 = n;
        }
        return String.valueOf(Convert.zeroPad(String.valueOf(n4), 2)) + Settings.dateSeparator + Convert.zeroPad(String.valueOf(n5), 2) + Settings.dateSeparator + Convert.zeroPad(String.valueOf(n6), 2);
    }

    public String formatDayMonth() {
        int n = this.f1;
        int n2 = this.f2;
        if (Settings.dateFormat != 2) {
            n = this.f2;
            n2 = this.f1;
        }
        return String.valueOf(Convert.zeroPad(String.valueOf(n), 2)) + Settings.dateSeparator + Convert.zeroPad(String.valueOf(n2), 2);
    }

    public String getDate() {
        return Date.formatDate(this.f1, this.f2, this.f3);
    }

    public int getDateInt() {
        return this.f3 * 10000 + this.f2 * 100 + this.f1;
    }

    public int getDay() {
        return this.f1;
    }

    public int getDayOfWeek() {
        return this.f4;
    }

    private int m2() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.f2) {
            n += this.getDaysInMonth(n2);
            ++n2;
        }
        return n;
    }

    public int getDaysInMonth() {
        Date date = this;
        return date.getDaysInMonth(date.f2);
    }

    public int getDaysInMonth(int n) {
        if (n != 2) {
            return f6[n];
        }
        if (this.f3 % 4 == 0 && (this.f3 % 100 != 0 || this.f3 % 400 == 0)) {
            return 29;
        }
        return 28;
    }

    public int getJulianDay() {
        Date date = this;
        Date date2 = this;
        return (this.f3 - this.f5) * 365 + date.m3(date.f3) - date2.m3(date2.f5) + this.m2() + this.f1;
    }

    public int getMonth() {
        return this.f2;
    }

    public static String getMonthName(int n) {
        if (n >= 1 && n <= 12) {
            return monthNames[n];
        }
        return "";
    }

    private int m3(int n) {
        int n2 = n + 3 >> 2;
        int n3 = (n + 99) / 100;
        int n4 = (n + 399) / 400;
        return n2 - n3 + n4;
    }

    public int getWeek() {
        int n = this.getJulianDay() / 7 % 52;
        if (n == 0) {
            n = 52;
        }
        return n;
    }

    public int getYear() {
        return this.f3;
    }

    public boolean isAfter(Date date) {
        return this.getDateInt() > date.getDateInt();
    }

    public boolean isBefore(Date date) {
        return this.getDateInt() < date.getDateInt();
    }

    private void m4() {
        int n = (this.f3 - 1582) * 365;
        int n2 = this.f3 - 1581 >> 2;
        int n3 = (this.f3 - 1501) / 100;
        int n4 = (this.f3 - 1201) / 400;
        int n5 = (this.f2 - 1) * 31;
        int n6 = this.f1;
        int n7 = (this.f2 + 7) / 10;
        int n8 = (int)(((float)this.f2 * 0.4f + 2.3f) * (float)n7);
        int n9 = 1 / (this.f3 % 4 + 1) * n7;
        int n10 = 1 / (this.f3 % 100 + 1) * n7;
        int n11 = 1 / (this.f3 % 400 + 1) * n7;
        int n12 = (n + n2 - n3 + n4 + n5 + n6 - n8 + n9 - n10 + n11 + 5) % 7;
        this.f4 = n12 > 0 ? n12 - 1 : 6;
    }

    public void setToday() {
        Time time = new Time();
        this.f1 = time.day;
        this.f2 = time.month;
        this.f3 = time.year;
        this.m4();
    }

    public String toString() {
        return Date.formatDate(this.f1, this.f2, this.f3);
    }
}

