#--------------------------------------------------------------------------
# Name         : maketex.mak
# Title        : Makefile to build textures
# Author       : PowerVR
# Created      : 12/01/2005
#
# Copyright    : 2005 by Imagination Technologies.  All rights reserved.
#              : No part of this software, either material or conceptual 
#              : may be copied or distributed, transmitted, transcribed,
#              : stored in a retrieval system or translated into any 
#              : human or computer language in any form by any means,
#              : electronic, mechanical, manual or other-wise, or 
#              : disclosed to third parties without the express written
#              : permission of VideoLogic Limited, Unit 8, HomePark
#              : Industrial Estate, King's Langley, Hertfordshire,
#              : WD4 8LZ, U.K.
#
# Description  : Makefile for demos in the PowerVR SDK
#
# Platform     :
#
# $Revision: 1.4 $
#--------------------------------------------------------------------------

#############################################################################
## Instructions
#############################################################################

TEXTURESPATH = ./../Media

all:	Iris.h Metal.h Fire02.h Fire03.h

Iris.h: $(TEXTURESPATH)/Iris.tga
	$(PVRTEXTURETOOLPATH) -m -h -fOGL5551 -nt -i$(TEXTURESPATH)/Iris.tga -oIris.h

Metal.h: $(TEXTURESPATH)/Metal.tga
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Metal.tga -oMetal.h

Fire02.h: $(TEXTURESPATH)/Fire02.tga
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Fire02.tga -oFire02.h

Fire03.h: $(TEXTURESPATH)/Fire03.tga
	$(PVRTEXTURETOOLPATH) -m -h -fOGLPVRTC4 -i$(TEXTURESPATH)/Fire03.tga -oFire03.h

############################################################################
# End of file (maketex.mak)
############################################################################

