/**********************************************************
 * This file has been created with PowerVR Exporter v3.4
 * Date: 21 December 2004   Time: 12:52
 * Original File: Mouse.max 
 *
 * Options: 
 *
 *   Meshes        = ON
 *   Mesh Anim     = ON
 *   Materials     = OFF
 *   Cameras       = ON
 *   Camera Anim   = ON
 *   Lights        = OFF
 *   Paths         = OFF
 *   Bones         = OFF
 *
 *   UVs           = ON
 *   UVs Layer2    = OFF
 *   Normals       = ON
 *   Colors        = OFF
 *   Materials     = OFF
 *   Weights       = OFF
 *
 *   Strips        = OFF
 *   No Face-list  = OFF
 *   DWORD List    = OFF
 *   Packed Format = OFF
 *   OpenGL Format = ON
 *   Transform UVs = OFF
 *   Vertex Format = FLOAT
 *
 *   Patches       = OFF
 *   PatchTriToQuad= OFF
 *   Patch Mesh    = OFF
 *   Patch UVs     = OFF
 *
 **********************************************************/

#define STRUCT_MESH_DEFINED 

typedef struct { unsigned int      nNumVertex;
                 unsigned int      nNumFaces;
                 unsigned int      nNumStrips;
                 unsigned int      nFlags;
                 int               nMaterial;
                 float             fCenter[3];
                 const float             *pVertex;
                 const float             *pUV;
                 const float             *pNormals;
                 const float             *pPackedVertex;
                 const unsigned int      *pVertexColor;
                 const unsigned int      *pVertexMaterial;
                 const unsigned short    *pFaces;
                 const unsigned short    *pStrips;
                 const unsigned short    *pStripLength;
                 struct
                 {
                     unsigned int  nType;
                     unsigned int  nNumPatches;
                     unsigned int  nNumVertices;
                     unsigned int  nNumSubdivisions;
                     const float         *pControlPoints;
                     const float         *pUVs;
                 } Patch;
               }   Struct_Mesh;


#define STRUCT_CAMERAS_DEFINED 

typedef struct { float    fPosition[3];
                 float    fTarget[3];
                 float    fFOV;
                 float    fNearClip;
                 float    fFarClip;
               }   Struct_Camera;


#define STRUCT_ANIMATION_DEFINED 

typedef struct { unsigned int  nNumFrames;
                 float         Pivot[3];
                 const float         *pData;
               }   Struct_Animation;


#define STRUCT_CAMERAANIMATION_DEFINED 

typedef struct { unsigned int  nNumFrames;
                 const float         *Position;
                 const float         *Target;
                 const float         *FOV;
               }   Struct_CameraAnimation;


/**********************************************************
 * GENERAL DEFINITIONS
 **********************************************************/

#ifndef _NULL_
#define _NULL_ 0
#endif

#define NUM_MESHES     8
#define NUM_BONES	   26
#define NUM_MATERIALS  3
#define NUM_LIGHTS     0
#define NUM_CAMERAS    1
#define NUM_PATHS      0
#define NUM_FRAMES     243

/* MESH FLAGS */

#ifndef MF_MATERIAL
#define MF_MATERIAL        1
#define MF_UV              2
#define MF_NORMALS         4
#define MF_VERTEXCOLOR     8
#define MF_VERTEXMATERIAL  16
#define MF_STRIPS          32
#define MF_NOFACELIST      64
#define MF_UV2             128
#define MF_VERTEXWEIGHTS   256

#define MF_NOPATCH         0
#define MF_RECTPATCH       1
#define MF_TRIPATCH        2
#define MF_MIXPATCH        3

#endif


/* MESHES */
#define M_HEAD  0
#define M_HAND_LEFT  1
#define M_HAND_RIGHT  2
#define M_BODY  3
#define M_OBJECT02  4
#define M_OBJECT01  5
#define M_FLOOR  6
#define M_WALL  7

/* CAMERAS */
#define C_CAMERA01  0


/**********************************************************
 * CAMERAS 
 **********************************************************/

const Struct_Camera 
   Camera[NUM_CAMERAS] = {

/* CAMERA 0 */
	/* Camera position  */ -1351.7603f,722.8143f,862.2454f,
	/* Camera target    */  67.589836f, 198.834610f, -41.417912f,
	/* FOV              */ 0.785398f,
	/* Near clip        */ 1.000000f,
	/* Far clip         */ 1000.000000f

	};  /* END OF CAMERA DEFINITIONS */



/**********************************************************
 * MESHES DATA 
 **********************************************************/

/* MESH 0 */

#define head_NumVertex  605
#define head_NumFaces   1078
#define head_NumStrips  0
#define head_Flags      0x00020006
#define head_Material   0

const float head_Vertices[] = {
	67.7996f,312.0057f,-8.7281f, 69.3990f,319.5967f,-11.6605f, 62.7623f,321.4134f,-9.2319f, 60.1684f,333.8865f,-15.9532f, 49.0775f,325.3758f,-10.2263f, 
	54.3843f,324.8039f,-10.2899f, 56.4574f,335.5349f,-16.4493f, 54.8143f,322.5580f,-9.3157f, 54.3013f,319.6968f,-9.3873f, 61.6442f,336.8952f,-16.9366f, 
	59.0326f,337.0817f,-16.7129f, 62.0584f,335.4002f,-16.9356f, 63.9561f,331.3020f,-16.3165f, 18.7867f,326.9284f,-10.7461f, 21.6493f,331.0734f,-15.2143f, 
	14.8895f,346.9974f,-17.8054f, 21.2958f,343.2421f,-18.4504f, 30.6238f,327.3965f,-15.2823f, 21.4401f,323.6293f,-8.3147f, 25.1405f,324.7830f,-12.5432f, 
	33.4410f,324.4601f,-12.2839f, 65.2436f,304.7702f,31.8238f, 67.7664f,306.5767f,26.0810f, 69.6448f,311.5562f,28.0039f, 67.2730f,309.8415f,33.6834f, 
	68.0851f,310.5439f,19.1768f, 69.6850f,315.2205f,20.9063f, 68.9140f,321.1547f,20.5382f, 68.7829f,318.1980f,27.4624f, 66.4537f,316.7966f,32.9326f, 
	65.4480f,327.0454f,6.9445f, 66.9741f,315.2329f,12.6793f, 63.0462f,331.6591f,10.8020f, 66.5199f,326.7899f,18.8530f, 64.2342f,330.1629f,6.9867f, 
	54.4614f,329.6965f,29.1308f, 63.6446f,323.7247f,30.3586f, 66.4537f,316.7966f,32.9326f, 56.0966f,349.9878f,-10.2683f, 49.1756f,360.3525f,5.5772f, 
	42.8307f,356.9382f,-0.0606f, 26.1619f,354.8692f,-13.1841f, 23.7118f,355.5238f,-10.9163f, 17.2471f,352.2675f,-20.8483f, 14.3489f,353.2300f,-19.7227f, 
	13.7338f,351.0267f,-19.6475f, 16.4512f,349.9275f,-20.5328f, 11.3973f,353.6551f,-17.5105f, 11.0623f,351.4800f,-17.7984f, 31.4635f,343.3407f,-20.3144f, 
	24.0945f,352.4491f,-17.8428f, 17.9087f,356.3586f,-15.7404f, 13.4271f,355.5465f,-15.6743f, 16.0692f,355.3000f,-17.8407f, 18.5939f,354.6623f,-18.9117f, 
	20.8059f,355.4319f,-16.3049f, 58.1407f,341.2779f,-16.1805f, 58.6426f,338.7867f,-16.7595f, 19.1611f,351.0823f,-20.7741f, 148.0160f,315.1020f,45.2766f, 
	131.1766f,298.1256f,43.0009f, 135.4589f,302.7227f,53.2587f, 120.4203f,298.7204f,82.3839f, 115.7405f,302.0490f,87.6336f, 125.2421f,302.0624f,77.2645f, 
	128.9017f,297.8530f,69.8066f, 120.4203f,298.7204f,82.3839f, 125.2421f,302.0624f,77.2645f, 132.3234f,296.4604f,55.2499f, 131.4270f,297.1120f,62.8979f, 
	131.4763f,301.4626f,64.8290f, 129.2338f,330.1279f,90.4601f, 133.0906f,336.4999f,84.1553f, 151.4598f,336.0162f,45.6527f, 121.3286f,312.3589f,92.5939f, 
	129.0113f,368.5545f,28.3370f, 130.3172f,371.4201f,30.0704f, 126.1468f,374.3635f,25.6879f, 132.3786f,374.5114f,30.4268f, 132.7879f,367.7683f,43.2430f, 
	133.2103f,363.0548f,37.1307f, 135.6119f,356.6576f,53.4722f, 149.7219f,341.4037f,37.4550f, 133.0906f,336.4999f,84.1553f, 123.2892f,336.4866f,94.8516f, 
	124.0599f,359.3582f,75.1649f, 124.0599f,359.3582f,75.1649f, 94.1433f,395.9835f,83.7841f, 129.8828f,364.1271f,59.1280f, 131.9574f,379.4623f,38.4330f, 
	104.4906f,404.0210f,67.7871f, 119.5249f,396.0094f,56.0850f, 84.5590f,309.2531f,-19.8848f, 62.6076f,301.4001f,-4.0584f, 69.3837f,290.5469f,7.9861f, 
	85.5951f,295.2975f,-9.8924f, 73.1417f,297.4284f,-3.7800f, 26.9119f,302.0780f,-3.3007f, 32.9131f,295.8045f,2.1983f, 37.9838f,296.8980f,-1.7783f, 
	51.0704f,292.8044f,9.7543f, 62.7125f,294.2537f,2.7720f, 97.2744f,281.0529f,21.6707f, 75.8234f,282.5795f,22.1864f, 96.6157f,281.6292f,60.5711f, 
	94.0278f,294.3209f,-11.5265f, 120.3549f,288.3350f,33.4988f, 125.2482f,292.8702f,34.9901f, 131.8544f,299.9291f,19.1463f, 124.7751f,287.0712f,39.1568f, 
	127.3958f,292.9518f,42.0708f, 130.9055f,292.5587f,48.6441f, 130.2139f,295.9442f,46.4955f, 104.9765f,281.4276f,24.1224f, 106.3408f,284.8735f,20.7448f, 
	116.0761f,283.4488f,31.0615f, 111.6053f,285.6165f,24.8603f, 85.2335f,363.5633f,2.4116f, 65.8857f,387.8536f,15.8147f, 90.3766f,395.7213f,19.4790f, 
	68.0126f,402.0546f,27.7622f, 52.9370f,391.5699f,32.2292f, 90.2099f,400.4305f,24.8146f, 69.4156f,406.8913f,35.6468f, 45.3130f,368.1086f,18.9040f, 
	150.6089f,421.9417f,17.9482f, 157.2109f,419.5946f,19.3526f, 153.9392f,423.6056f,18.8592f, 153.6598f,423.9812f,19.4484f, 144.8187f,429.6083f,19.8218f, 
	145.3495f,429.7585f,18.5266f, 149.7115f,427.2621f,19.0807f, 145.8484f,429.4090f,17.2844f, 150.0592f,426.9274f,18.1789f, 150.3644f,426.1617f,17.5268f, 
	146.2568f,428.6340f,16.2593f, 116.2636f,399.6527f,55.4097f, 121.6403f,396.2828f,45.7333f, 126.2317f,393.1407f,45.8847f, 129.0762f,389.4543f,44.2002f, 
	126.7468f,387.8697f,48.2024f, 99.5993f,407.1985f,53.6283f, 70.6245f,407.7000f,44.3783f, 99.5993f,407.1985f,53.6283f, 138.5412f,428.5007f,11.8208f, 
	138.1668f,429.6083f,13.0499f, 135.2787f,427.9336f,10.6285f, 133.9479f,429.5985f,13.4224f, 132.0117f,427.7805f,10.9617f, 142.0960f,429.6500f,14.6423f, 
	142.3919f,428.5103f,13.6452f, 141.5754f,430.4482f,16.0342f, 136.0103f,430.7345f,18.1853f, 131.6512f,429.4227f,18.2107f, 69.2404f,338.3904f,-18.4121f, 
	75.6612f,336.0512f,-20.8254f, 86.7306f,339.2893f,-19.5057f, 107.8712f,368.1176f,10.2343f, 117.5552f,337.3704f,-13.6020f, 97.9248f,336.0957f,-20.9481f, 
	97.2694f,383.8121f,13.7425f, 90.0846f,300.7838f,-17.4718f, 89.5942f,321.8930f,-24.4062f, 91.8296f,310.1409f,-22.4020f, 109.5516f,318.6676f,-21.1814f, 
	98.3796f,302.5449f,-18.4218f, 116.5147f,312.8712f,-15.5232f, 109.5123f,330.9671f,-20.5303f, 125.4402f,331.8314f,-11.7865f, 117.9954f,318.6377f,-17.1558f, 
	99.0298f,325.6464f,-24.0048f, 65.0495f,334.9156f,-18.1217f, 145.1708f,314.4600f,17.5562f, 151.3729f,337.3644f,30.0107f, 151.0663f,325.7061f,23.1894f, 
	136.2912f,319.6548f,-2.3995f, 146.4280f,339.3292f,15.9267f, 136.6414f,332.6996f,-2.1041f, 131.9684f,325.5694f,-8.0934f, 117.0104f,375.9272f,22.2943f, 
	124.3562f,372.5307f,24.1752f, 111.8631f,375.4273f,18.0930f, 54.5447f,323.0269f,-8.7020f, 54.3013f,319.6968f,-9.3873f, 54.8143f,322.5580f,-9.3157f, 
	50.2520f,316.9052f,-9.4852f, 54.5447f,323.0269f,-8.7020f, 53.2361f,324.4825f,-9.5449f, 49.4618f,325.6219f,-8.7909f, 53.2857f,324.7964f,-8.4992f, 
	53.2361f,324.4825f,-9.5449f, 49.0775f,325.3758f,-10.2263f, 54.5447f,323.0269f,-8.7020f, 54.8143f,322.5580f,-9.3157f, 53.2361f,324.4825f,-9.5449f, 
	53.2857f,324.7964f,-8.4992f, 33.4410f,324.4601f,-12.2839f, 26.4672f,323.8859f,-11.3047f, 26.4672f,323.8859f,-11.3047f, 21.4401f,323.6293f,-8.3147f, 
	33.8549f,331.8010f,27.5458f, 58.2522f,331.8459f,0.9330f, 31.9339f,303.3214f,-7.0035f, 38.1052f,308.2872f,-8.9680f, 38.1052f,308.2872f,-8.9680f, 
	32.0825f,305.2198f,-6.7834f, 31.9339f,303.3214f,-7.0035f, 27.1500f,303.9754f,-3.0826f, 26.9119f,302.0780f,-3.3007f, 45.2889f,311.0881f,-9.7527f, 
	44.6336f,312.5249f,-9.6550f, 38.1052f,308.2872f,-8.9680f, 44.6336f,312.5249f,-9.6550f, 39.8260f,309.2913f,-7.2642f, 50.2520f,316.9052f,-9.4852f, 
	32.0825f,305.2198f,-6.7834f, 63.5282f,313.7315f,8.8869f, 54.5447f,323.0269f,-8.7020f, 65.2436f,304.7702f,31.8238f, 59.5066f,303.4932f,26.5668f, 
	62.2986f,304.9971f,20.9700f, 27.1500f,303.9754f,-3.0826f, 61.0187f,327.7250f,-1.3206f, 60.9617f,323.9999f,-1.0684f, 60.0801f,330.3549f,-0.6234f, 
	62.2732f,330.7323f,2.6923f, 60.9075f,332.2725f,4.3692f, 63.2644f,328.0083f,2.1904f, 40.4612f,332.6476f,28.3194f, 129.6073f,376.0778f,26.3253f, 
	132.6633f,376.8022f,28.0954f, 134.8070f,380.6609f,25.9820f, 124.8770f,379.3401f,25.1948f, 133.8830f,378.5040f,30.6262f, 136.7003f,382.2855f,27.6602f, 
	137.2476f,382.6365f,25.9767f, 139.1620f,384.2794f,27.5179f, 130.8030f,379.6674f,25.1898f, 95.3397f,392.0164f,17.0534f, 96.2524f,397.5116f,20.7898f, 
	100.5929f,400.4990f,25.0711f, 102.6468f,384.6900f,16.8021f, 100.6050f,390.7284f,16.2481f, 103.5596f,388.9638f,16.9319f, 102.7153f,386.8142f,17.2384f, 
	103.4000f,398.5883f,16.5128f, 133.5067f,384.5898f,37.2856f, 137.0178f,390.0762f,37.0326f, 125.3550f,394.9599f,43.3529f, 129.8253f,391.8390f,42.9462f, 
	136.8979f,395.1089f,38.4348f, 120.1674f,376.7754f,24.5597f, 112.7580f,379.9370f,26.1459f, 105.9689f,382.5093f,26.4403f, 106.6582f,380.8707f,25.8208f, 
	109.0507f,380.3858f,26.2327f, 108.6744f,381.9885f,26.8776f, 118.2819f,397.7295f,40.9937f, 101.6170f,400.6366f,30.9806f, 108.7845f,402.0914f,29.3672f, 
	128.9758f,404.8991f,34.1168f, 106.2283f,380.7620f,21.5912f, 106.4492f,379.5196f,17.7469f, 104.7106f,383.2133f,25.0396f, 105.3827f,381.4660f,24.5759f, 
	103.5596f,388.9638f,16.9319f, 102.7153f,386.8142f,17.2384f, 103.8523f,384.0478f,19.9630f, 103.8523f,384.0478f,19.9630f, 122.3951f,383.6723f,26.2373f, 
	146.9346f,388.7472f,28.6802f, 145.6016f,387.1366f,27.4232f, 154.6290f,392.8484f,28.6409f, 150.3404f,389.8083f,28.2275f, 151.1705f,391.3639f,29.2939f, 
	161.4786f,403.4788f,26.2256f, 145.6016f,387.1366f,27.4232f, 150.3404f,389.8083f,28.2275f, 161.4786f,403.4788f,26.2256f, 137.2476f,382.6365f,25.9767f, 
	154.6290f,392.8484f,28.6409f, 142.6534f,391.4783f,32.6908f, 143.8702f,397.4186f,34.4469f, 143.8270f,407.3575f,32.4978f, 148.8232f,397.0207f,32.0662f, 
	110.6480f,384.7105f,26.5934f, 107.4822f,385.3714f,25.9804f, 117.1826f,395.5726f,22.2599f, 106.0652f,386.2189f,24.3590f, 105.5933f,392.0299f,15.9577f, 
	116.4138f,405.2838f,11.1844f, 120.2675f,410.8847f,24.6959f, 112.7143f,407.0827f,22.0879f, 106.9364f,403.2727f,19.0002f, 114.9243f,406.1776f,11.9690f, 
	111.2766f,402.2296f,12.9916f, 110.4170f,404.0575f,14.9918f, 114.1586f,408.6077f,17.5043f, 123.2981f,413.8550f,9.4478f, 131.2807f,420.7229f,9.4596f, 
	133.2715f,427.0085f,21.5876f, 118.9078f,413.0641f,20.3277f, 130.3976f,428.2029f,19.1015f, 117.0822f,410.8901f,13.6602f, 128.6022f,424.8471f,9.8750f, 
	126.7620f,426.2751f,14.5258f, 142.3766f,427.1072f,13.2559f, 131.0093f,424.6497f,8.8383f, 134.9974f,426.6490f,9.7878f, 132.1824f,426.2384f,9.3846f, 
	135.1447f,430.0758f,19.5109f, 127.7736f,427.2270f,17.0905f, 127.1194f,425.4481f,11.9424f, 130.0919f,426.4594f,10.2651f, 128.8258f,427.0388f,12.0247f, 
	128.4840f,427.7037f,14.2589f, 25.7870f,310.3085f,33.5725f, 24.1213f,321.3601f,32.9242f, 18.3036f,300.7263f,60.8694f, 23.3441f,322.5060f,25.0128f, 
	24.6284f,316.3066f,30.7270f, 17.2065f,333.8330f,30.9324f, 22.3374f,324.7525f,24.6706f, 21.9397f,325.3298f,19.3798f, 16.3559f,336.8417f,32.4887f, 
	16.3929f,335.3468f,32.9011f, 16.3518f,337.0284f,29.8682f, 16.3901f,335.4820f,27.2799f, 17.1738f,331.2484f,34.7364f, 15.2997f,327.3702f,1.4415f, 
	14.5710f,331.0587f,-7.4988f, 10.2799f,343.3033f,2.7252f, 18.5304f,324.4341f,3.9851f, 17.5500f,324.7697f,-4.2601f, 67.2730f,309.8415f,33.6834f, 
	61.8214f,311.5428f,36.5408f, 59.7421f,306.5634f,34.8372f, 61.2068f,318.1846f,35.7294f, 54.3195f,321.1289f,36.4627f, 54.7536f,315.1949f,37.1987f, 
	52.8911f,310.5185f,35.7556f, 58.6930f,324.7513f,33.1857f, 46.1184f,328.6835f,34.0381f, 44.1069f,331.6242f,31.4639f, 35.9581f,330.6849f,31.3982f, 
	40.4720f,327.0014f,34.1914f, 41.0029f,322.6898f,34.4998f, 36.2505f,358.5684f,17.8978f, 27.4384f,353.2731f,31.0204f, 25.9029f,355.8909f,4.9664f, 
	36.7692f,358.9908f,15.9366f, 35.1890f,357.9726f,13.0709f, 39.8310f,360.1087f,13.8649f, 17.2270f,354.7872f,-3.1733f, 9.4230f,353.2118f,-14.3939f, 
	9.3860f,351.0068f,-14.9921f, 8.5307f,352.2374f,-11.4177f, 8.6738f,349.8946f,-12.2020f, 13.8887f,356.3138f,-11.1783f, 11.5526f,355.2691f,-12.8394f, 
	13.6794f,355.3533f,-8.2376f, 10.7567f,354.6094f,-10.2346f, 15.2761f,349.2340f,10.3011f, 16.2712f,338.7334f,29.4835f, 17.1554f,340.6025f,36.1335f, 
	16.8035f,341.2245f,28.9324f, 87.9848f,303.9586f,101.9701f, 72.4662f,314.8967f,115.0581f, 97.8009f,314.2288f,107.4873f, 92.7166f,302.6720f,99.9037f, 
	108.6300f,297.8269f,91.9293f, 103.8957f,301.4253f,94.9279f, 94.4270f,296.4126f,96.6067f, 101.9677f,297.0744f,95.0471f, 121.3286f,312.3589f,92.5939f, 
	129.2338f,330.1279f,90.4601f, 79.3762f,331.0286f,118.8228f, 86.5341f,335.9628f,116.5067f, 86.5138f,325.3970f,116.7277f, 77.6811f,367.4279f,98.4549f, 
	69.1683f,371.3667f,96.8026f, 69.7030f,374.4585f,98.8252f, 82.5062f,367.7185f,98.1159f, 92.9426f,356.6081f,100.0376f, 82.8284f,362.3856f,99.3186f, 
	67.3278f,368.5011f,95.6527f, 76.4540f,363.0014f,99.0694f, 104.4906f,404.0210f,67.7871f, 98.0775f,364.0909f,93.8373f, 83.1362f,389.4090f,94.3348f, 
	77.6421f,379.4147f,97.7078f, 29.2685f,301.3548f,32.3255f, 30.4640f,297.3783f,42.7954f, 29.3947f,296.8848f,7.5975f, 36.0842f,294.2178f,31.8367f, 
	27.2780f,299.6661f,14.0539f, 41.8595f,290.5113f,38.0277f, 42.0247f,292.7919f,19.6297f, 56.5653f,282.5536f,43.2037f, 56.5653f,282.5536f,43.2037f, 
	33.3930f,290.0552f,57.5013f, 57.9247f,281.0000f,64.6212f, 96.6157f,281.6292f,60.5711f, 29.1156f,292.6825f,69.8667f, 24.5761f,294.2550f,64.2851f, 
	87.7232f,292.5067f,95.7704f, 85.5240f,295.8892f,95.2700f, 80.8744f,292.8907f,92.8518f, 77.7427f,287.0104f,90.4947f, 71.7380f,288.2509f,86.6001f, 
	53.1352f,309.0037f,107.1846f, 68.9277f,283.3776f,82.5414f, 62.3803f,285.5186f,78.6463f, 57.8173f,284.7822f,73.7566f, 61.0452f,281.3615f,72.0866f, 
	37.6905f,360.3016f,18.0991f, 37.0511f,359.8802f,29.4113f, 40.6527f,367.6089f,23.5102f, 46.6316f,384.2424f,35.9413f, 62.2913f,404.1884f,43.2573f, 
	60.4370f,400.3828f,57.3060f, 55.1362f,395.6699f,57.9371f, 48.7356f,388.5880f,47.1072f, 59.7874f,421.8310f,121.6880f, 59.7458f,422.8663f,121.5172f, 
	60.8353f,419.5412f,124.5281f, 60.0587f,423.5522f,121.3119f, 56.1802f,427.4543f,114.2002f, 56.7990f,428.5806f,113.8853f, 58.4197f,426.1083f,117.8668f, 
	57.7847f,429.3556f,113.3891f, 59.0427f,426.8740f,117.5059f, 60.2227f,429.5549f,112.1421f, 59.9108f,427.2087f,117.0809f, 58.9787f,429.7051f,112.7839f, 
	60.6213f,423.9278f,120.9821f, 84.0155f,396.2378f,86.7937f, 93.1864f,399.6268f,80.5940f, 84.5665f,393.0956f,91.3543f, 77.2403f,403.2473f,67.8819f, 
	50.2801f,427.7272f,100.1561f, 52.9001f,429.5451f,101.8704f, 50.2328f,427.8802f,103.4397f, 52.8968f,429.5549f,106.1058f, 51.7049f,428.4473f,106.5859f, 
	57.4701f,429.3693f,99.1652f, 53.2573f,427.6503f,96.3545f, 57.8247f,430.6811f,103.5099f, 56.1668f,430.3948f,109.2413f, 53.8581f,428.4568f,110.2629f, 
	54.8255f,429.5966f,109.8812f, 35.7117f,360.3249f,40.1118f, 41.5883f,365.5148f,66.7925f, 15.5209f,336.0423f,68.9800f, 15.5472f,338.3369f,40.1838f, 
	24.5516f,337.3147f,87.8971f, 38.3992f,352.0376f,79.9664f, 50.0223f,383.7587f,65.3036f, 49.5737f,376.6590f,71.5739f, 11.3506f,321.8386f,60.9832f, 
	13.5438f,310.0839f,63.0371f, 12.4182f,319.3489f,53.8016f, 21.0259f,297.8826f,67.0291f, 24.7711f,307.0717f,84.8110f, 21.0876f,318.5306f,88.6800f, 
	33.4771f,313.7079f,98.8809f, 12.5728f,325.5919f,70.3480f, 15.4715f,334.8621f,35.9837f, 56.4845f,339.2734f,114.0864f, 64.1295f,325.6424f,118.0794f, 
	44.9373f,339.7983f,107.6760f, 42.8182f,325.7934f,110.5840f, 43.3996f,319.5520f,109.5640f, 64.4391f,374.3101f,93.0300f, 62.7761f,372.4773f,91.3781f, 
	62.7940f,376.7220f,87.1718f, 55.6282f,375.3739f,79.4626f, 22.7783f,316.8603f,20.4833f, 23.4490f,320.3505f,23.7292f, 23.2280f,319.6463f,24.5079f, 
	23.9319f,322.9750f,24.6907f, 23.3441f,322.5060f,25.0128f, 23.2280f,319.6463f,24.5079f, 23.9319f,322.9750f,24.6907f, 23.9319f,322.9750f,24.6907f, 
	23.4490f,320.3505f,23.7292f, 24.4527f,321.2262f,24.1980f, 25.0585f,323.8797f,25.2742f, 22.7783f,316.8603f,20.4833f, 23.8765f,317.7474f,21.0591f, 
	24.0251f,324.7462f,23.4197f, 22.9793f,324.4319f,23.4617f, 23.9319f,322.9750f,24.6907f, 24.0251f,324.7462f,23.4197f, 22.9793f,324.4319f,23.4617f, 
	23.3441f,322.5060f,25.0128f, 23.4026f,325.5765f,19.6370f, 21.9397f,325.3298f,19.3798f, 22.9793f,324.4319f,23.4617f, 18.5304f,324.4341f,3.9851f, 
	18.8990f,323.8727f,-3.0466f, 18.8990f,323.8727f,-3.0466f, 23.6606f,303.3083f,2.0246f, 23.8924f,305.2069f,2.1531f, 23.6606f,303.3083f,2.0246f, 
	22.2397f,308.2620f,8.3421f, 22.2397f,308.2620f,8.3421f, 22.2397f,308.2620f,8.3421f, 23.8924f,305.2069f,2.1531f, 24.0869f,309.2663f,9.9076f, 
	38.0176f,319.1340f,32.3123f, 22.1218f,312.4886f,14.9032f, 22.0822f,311.0513f,15.5652f, 22.1218f,312.4886f,14.9032f, 47.8892f,308.6558f,31.4566f, 
	54.1739f,304.9838f,29.8355f, 31.8495f,327.6740f,30.4969f, 35.5441f,327.9595f,32.4290f, 37.5103f,332.2294f,29.8922f, 32.4629f,330.3053f,29.5016f, 
	65.3756f,376.0244f,96.4218f, 63.8371f,379.2867f,91.8080f, 65.4868f,380.6075f,101.6317f, 67.4053f,376.7491f,99.3119f, 65.6943f,382.5831f,104.0634f, 
	64.3487f,379.6140f,97.7119f, 67.3965f,384.2261f,105.8362f, 67.3237f,382.2321f,103.3715f, 70.0329f,378.4517f,100.3064f, 61.5975f,400.4456f,67.6272f, 
	56.9541f,397.4585f,63.6763f, 53.1525f,391.9632f,63.0927f, 56.8222f,399.5660f,67.8524f, 53.3164f,398.5349f,71.1695f, 53.7478f,388.9103f,71.2919f, 
	53.9795f,386.7608f,70.4241f, 52.8091f,390.6750f,68.4082f, 53.5389f,384.6366f,70.3939f, 76.6341f,384.5392f,99.3511f, 76.6881f,390.0228f,102.8709f, 
	80.5460f,394.8826f,93.7461f, 80.2236f,391.8704f,98.1664f, 75.7422f,400.5443f,106.6068f, 81.9523f,391.7889f,95.1904f, 81.9678f,394.9098f,90.7016f, 
	62.9042f,378.6336f,81.0549f, 60.5022f,378.1192f,78.9471f, 62.4955f,379.1243f,77.8890f, 63.4300f,382.4559f,72.8634f, 64.1014f,381.9351f,75.5205f, 
	63.4918f,380.3324f,75.9516f, 62.8729f,380.8173f,73.6041f, 63.7284f,379.8836f,79.6523f, 79.0011f,397.6794f,83.8611f, 73.1607f,399.5237f,78.6802f, 
	75.9692f,399.9959f,91.1337f, 67.5737f,400.5860f,68.1323f, 66.5912f,402.0380f,75.4131f, 54.8115f,379.4661f,74.0995f, 58.6220f,380.7086f,73.5444f, 
	59.6607f,384.2633f,71.4034f, 56.7928f,383.9943f,71.3193f, 53.7478f,388.9103f,71.2919f, 56.7928f,383.9943f,71.3193f, 53.9795f,386.7608f,70.4241f, 
	61.5216f,381.4126f,72.4419f, 61.9249f,383.1599f,71.7319f, 69.8632f,392.7950f,121.1465f, 69.0777f,389.7549f,116.9102f, 68.0541f,403.4254f,128.1805f, 
	67.8633f,387.0832f,112.2596f, 70.2123f,391.3105f,117.6442f, 69.2317f,388.6938f,113.4780f, 72.8540f,391.4249f,108.8635f, 74.7094f,397.3652f,109.9226f, 
	72.7695f,396.9673f,115.0642f, 63.1037f,385.3180f,74.4110f, 63.9903f,384.6571f,77.5113f, 60.2429f,395.5192f,84.3987f, 60.6991f,400.6937f,97.0265f, 
	52.9546f,391.9765f,73.4028f, 61.3650f,386.1655f,73.1407f, 67.9961f,408.3348f,90.3210f, 69.6533f,411.2136f,98.7450f, 59.6821f,407.0293f,79.9624f, 
	55.2418f,408.5543f,81.8007f, 52.4128f,404.0041f,78.2923f, 49.1425f,405.2304f,84.5981f, 50.4951f,402.1761f,79.3230f, 49.7943f,406.1242f,83.0460f, 
	65.6241f,420.6957f,114.4842f, 56.0865f,426.0507f,114.2613f, 60.9753f,426.9551f,100.4850f, 61.4866f,428.6928f,106.0345f, 58.4683f,413.0107f,86.2857f, 
	58.2483f,428.1495f,97.8387f, 51.6671f,410.8367f,85.0482f, 53.3731f,426.2216f,94.6157f, 48.9003f,424.7937f,96.8543f, 58.8608f,421.8884f,118.0736f, 
	48.0774f,424.5964f,99.3426f, 49.3709f,426.5956f,103.2327f, 56.0162f,427.1736f,95.3999f, 50.8307f,425.3947f,95.1969f, 11.2952f,346.9706f,-13.9682f, 
	
_NULL_ }; /* End of head_Vertices */

const float head_UV[] = {
	0.3534f,0.4649f,0.3510f,0.4958f,0.3789f,0.4999f,0.3890f,0.5477f,0.4286f,0.5084f,0.4108f,0.5089f,0.4011f,0.5523f,0.4096f,0.5003f,0.4102f,0.4885f,0.3847f,0.5604f,0.3933f,0.5598f,0.3827f,0.5546f,0.3751f,0.5393f,0.4957f,0.4986f,0.4836f,0.5162f,
	0.4915f,0.5761f,0.4806f,0.5644f,0.4667f,0.5062f,0.4959f,0.4871f,0.4815f,0.4931f,0.4657f,0.4962f,-0.2298f,0.4395f,0.3217f,0.4473f,0.1802f,0.4685f,-0.1592f,0.4611f,0.3472f,0.4626f,0.3268f,0.4824f,0.3562f,0.5057f,0.3463f,0.4946f,-0.2263f,0.4884f,
	0.3836f,0.5258f,0.3660f,0.4800f,0.4124f,0.5435f,0.4009f,0.5268f,0.3943f,0.5377f,0.5981f,0.5334f,0.6305f,0.5144f,0.7737f,0.4884f,0.4150f,0.6108f,0.4775f,0.6506f,0.4784f,0.6329f,0.4837f,0.6142f,0.4919f,0.6158f,0.4841f,0.5981f,0.4899f,0.6006f,
	0.4906f,0.5914f,0.4854f,0.5884f,0.4973f,0.6010f,0.4970f,0.5921f,0.4601f,0.5699f,0.4786f,0.6028f,0.4920f,0.6155f,0.4979f,0.6099f,0.4909f,0.6100f,0.4856f,0.6087f,0.4867f,0.6132f,0.3982f,0.5762f,0.3952f,0.5664f,0.4813f,0.5944f,0.0694f,0.5262f,
	0.0667f,0.4490f,0.0468f,0.4709f,0.9775f,0.4505f,0.9626f,0.4620f,0.9916f,0.4658f,0.0092f,0.4499f,-0.0225f,0.4505f,-0.0084f,0.4658f,0.0406f,0.4444f,0.0246f,0.4475f,0.0207f,0.4652f,-0.0257f,0.5820f,-0.0129f,0.6088f,0.0701f,0.6119f,-0.0369f,0.5069f,
	0.1080f,0.7284f,0.1031f,0.7407f,0.1174f,0.7498f,0.1023f,0.7543f,0.0669f,0.7290f,0.0832f,0.7096f,0.0443f,0.6872f,0.0858f,0.6316f,0.9871f,0.6088f,0.9596f,0.6049f,0.9855f,0.6946f,-0.0145f,0.6946f,0.8982f,0.8266f,0.0253f,0.7148f,0.0797f,0.7749f,
	-0.0524f,0.8624f,0.0148f,0.8368f,0.2996f,0.4613f,0.3720f,0.4202f,0.3205f,0.3817f,0.2771f,0.4072f,0.3186f,0.4099f,0.4938f,0.4042f,0.4944f,0.3829f,0.4706f,0.3894f,0.4565f,0.3813f,0.3709f,0.3924f,0.1320f,0.3601f,0.1771f,0.3549f,-0.0227f,0.3668f,
	0.2545f,0.4075f,0.0866f,0.4029f,0.0840f,0.4238f,0.1245f,0.4537f,0.0729f,0.4008f,0.0669f,0.4261f,0.0538f,0.4272f,0.0581f,0.4402f,0.1170f,0.3659f,0.1297f,0.3801f,0.0926f,0.3807f,0.1129f,0.3863f,0.2949f,0.6821f,0.4566f,0.7709f,0.2283f,0.8158f,
	0.5515f,0.8304f,0.6081f,0.7809f,0.1887f,0.8352f,0.6593f,0.8515f,0.5422f,0.6813f,0.1339f,0.9525f,0.1279f,0.9467f,0.1306f,0.9610f,0.1295f,0.9624f,0.1332f,0.9804f,0.1362f,0.9811f,0.1324f,0.9735f,0.1388f,0.9798f,0.1342f,0.9722f,0.1355f,0.9692f,
	0.1410f,0.9768f,0.0102f,0.8496f,0.0498f,0.8377f,0.0542f,0.8276f,0.0616f,0.8141f,0.0480f,0.8070f,-0.0328f,0.8708f,0.7501f,0.8564f,0.9672f,0.8708f,0.1577f,0.9716f,0.1551f,0.9760f,0.1640f,0.9675f,0.1582f,0.9738f,0.1667f,0.9652f,0.1478f,0.9785f,
	0.1499f,0.9739f,0.1448f,0.9816f,0.1432f,0.9800f,0.1464f,0.9725f,0.3597f,0.5702f,0.3384f,0.5639f,0.3050f,0.5829f,0.1905f,0.7132f,0.2220f,0.5922f,0.2751f,0.5759f,0.2150f,0.7710f,0.2776f,0.4306f,0.2951f,0.5141f,0.2829f,0.4684f,0.2443f,0.5121f,
	0.2586f,0.4419f,0.2207f,0.4932f,0.2470f,0.5615f,0.2049f,0.5744f,0.2226f,0.5169f,0.2728f,0.5342f,0.3721f,0.5541f,0.1252f,0.5187f,0.1008f,0.6153f,0.1135f,0.5676f,0.1717f,0.5325f,0.1306f,0.6189f,0.1731f,0.5850f,0.1882f,0.5532f,0.1341f,0.7508f,
	0.1226f,0.7413f,0.1558f,0.7456f,0.4116f,0.5021f,0.4102f,0.4885f,0.4096f,0.5003f,0.4229f,0.4752f,0.4116f,0.5021f,0.4156f,0.5071f,0.4299f,0.5098f,0.4171f,0.5085f,0.4156f,0.5071f,0.4286f,0.5084f,0.4116f,0.5021f,0.4096f,0.5003f,0.4156f,0.5071f,
	0.4171f,0.5085f,0.4657f,0.4962f,0.4814f,0.4904f,0.4814f,0.4904f,0.4959f,0.4871f,0.5928f,0.5307f,0.4167f,0.5405f,0.4750f,0.4114f,0.4570f,0.4343f,0.4570f,0.4343f,0.4755f,0.4191f,0.4750f,0.4114f,0.4942f,0.4119f,0.4938f,0.4042f,0.4362f,0.4492f,
	0.4388f,0.4546f,0.4570f,0.4343f,0.4388f,0.4546f,0.4563f,0.4394f,0.4229f,0.4752f,0.4755f,0.4191f,0.3886f,0.4717f,0.4116f,0.5021f,0.7702f,0.4395f,0.5556f,0.4307f,0.4388f,0.4375f,0.4942f,0.4119f,0.3976f,0.5252f,0.3961f,0.5103f,0.4046f,0.5353f,
	0.3991f,0.5384f,0.4106f,0.5441f,0.3912f,0.5280f,0.5949f,0.5377f,0.1147f,0.7586f,0.1090f,0.7633f,0.1149f,0.7796f,0.1201f,0.7690f,0.1020f,0.7711f,0.1102f,0.7874f,0.1146f,0.7889f,0.1104f,0.7966f,0.1181f,0.7735f,0.2121f,0.8033f,0.1891f,0.8262f,
	0.1479f,0.8410f,0.1832f,0.7777f,0.1951f,0.8008f,0.1822f,0.7953f,0.1819f,0.7863f,0.1893f,0.8338f,0.0837f,0.7961f,0.0856f,0.8199f,0.0612f,0.8341f,0.0658f,0.8239f,0.0820f,0.8402f,0.1239f,0.7562f,0.1222f,0.7651f,0.1261f,0.7719f,0.1283f,0.7656f,
	0.1243f,0.7650f,0.1217f,0.7713f,0.0632f,0.8412f,0.1047f,0.8428f,0.1130f,0.8522f,0.0931f,0.8747f,0.1504f,0.7644f,0.1677f,0.7591f,0.1352f,0.7739f,0.1364f,0.7672f,0.1822f,0.7953f,0.1819f,0.7863f,0.1642f,0.7762f,0.1642f,0.7762f,0.1181f,0.7852f,
	0.1071f,0.8188f,0.1100f,0.8115f,0.1069f,0.8393f,0.1079f,0.8248f,0.1056f,0.8316f,0.1118f,0.8852f,0.1100f,0.8115f,0.1079f,0.8248f,0.1118f,0.8852f,0.1146f,0.7889f,0.1069f,0.8393f,0.0977f,0.8280f,0.0938f,0.8526f,0.0993f,0.8922f,0.0998f,0.8534f,
	0.1224f,0.7832f,0.1279f,0.7841f,0.1383f,0.8297f,0.1382f,0.7866f,0.1829f,0.8086f,0.1831f,0.8668f,0.1295f,0.8930f,0.1470f,0.8734f,0.1703f,0.8547f,0.1836f,0.8697f,0.1860f,0.8521f,0.1808f,0.8592f,0.1650f,0.8797f,0.1794f,0.9046f,0.1701f,0.9364f,
	0.1345f,0.9641f,0.1483f,0.9004f,0.1445f,0.9670f,0.1752f,0.8900f,0.1734f,0.9515f,0.1623f,0.9568f,0.1506f,0.9683f,0.1730f,0.9519f,0.1662f,0.9621f,0.1704f,0.9589f,0.1399f,0.9771f,0.1532f,0.9615f,0.1695f,0.9534f,0.1707f,0.9588f,0.1675f,0.9607f,
	0.1614f,0.9634f,0.6191f,0.4411f,0.6145f,0.4844f,0.6960f,0.4020f,0.5867f,0.4876f,0.6074f,0.4641f,0.6055f,0.5305f,0.5858f,0.4960f,0.5686f,0.4975f,0.6097f,0.5423f,0.6111f,0.5364f,0.6020f,0.5427f,0.5946f,0.5362f,0.6171f,0.5206f,0.5262f,0.5000f,
	0.5084f,0.5133f,0.5355f,0.5614f,0.5281f,0.4903f,0.5103f,0.4901f,0.8408f,0.4611f,0.7457f,0.4654f,0.7102f,0.4441f,0.7171f,0.4916f,0.6745f,0.4998f,0.6881f,0.4764f,0.6706f,0.4565f,0.6562f,0.5163f,0.6318f,0.5255f,0.6132f,0.5359f,0.6103f,0.5278f,
	0.6274f,0.5158f,0.6307f,0.4988f,0.5509f,0.6381f,0.6046f,0.6138f,0.5240f,0.6203f,0.5428f,0.6398f,0.5349f,0.6346f,0.5303f,0.6457f,0.5163f,0.6104f,0.5047f,0.5986f,0.5035f,0.5896f,0.5107f,0.5945f,0.5089f,0.5851f,0.5052f,0.6137f,0.5050f,0.6081f,
	0.5107f,0.6101f,0.5104f,0.6054f,0.5488f,0.5887f,0.6008f,0.5495f,0.6201f,0.5582f,0.5990f,0.5597f,0.8973f,0.4567f,0.8606f,0.4940f,0.9100f,0.5037f,0.9083f,0.4538f,0.9463f,0.4418f,0.9340f,0.4541f,0.9156f,0.4292f,0.9313f,0.4357f,0.9631f,0.5069f,
	0.9743f,0.5820f,0.8689f,0.5627f,0.8810f,0.5860f,0.8831f,0.5437f,0.8591f,0.7053f,0.8377f,0.7164f,0.8385f,0.7293f,0.8703f,0.7089f,0.8956f,0.6701f,0.8723f,0.6879f,0.8339f,0.7038f,0.8575f,0.6870f,0.9476f,0.8624f,0.9090f,0.7021f,0.8662f,0.7957f,
	0.8555f,0.7532f,0.6171f,0.4069f,0.6624f,0.3928f,0.5188f,0.3860f,0.6196f,0.3818f,0.5446f,0.3968f,0.6644f,0.3707f,0.5442f,0.3777f,-0.2213f,0.3472f,0.7787f,0.3472f,0.7207f,0.3668f,0.8270f,0.3443f,0.9773f,0.3668f,0.7381f,0.3766f,0.7166f,0.3798f,
	0.9035f,0.4099f,0.8983f,0.4223f,0.8901f,0.4075f,0.8856f,0.3820f,0.8715f,0.3833f,0.8241f,0.4592f,0.8666f,0.3618f,0.8462f,0.3665f,0.8301f,0.3605f,0.8424f,0.3483f,0.5499f,0.6458f,0.5976f,0.6452f,0.5694f,0.6773f,0.6272f,0.7487f,0.6963f,0.8378f,
	0.7526f,0.8233f,0.7375f,0.8016f,0.6823f,0.7686f,0.8143f,0.9167f,0.8140f,0.9208f,0.8177f,0.9084f,0.8142f,0.9237f,0.8032f,0.9364f,0.8038f,0.9412f,0.8093f,0.9327f,0.8051f,0.9448f,0.8100f,0.9360f,0.8088f,0.9467f,0.8113f,0.9378f,0.8068f,0.9468f,
	0.8150f,0.9255f,0.8680f,0.8227f,0.8969f,0.8403f,0.8693f,0.8109f,0.8425f,0.8449f,0.7819f,0.9327f,0.7880f,0.9416f,0.7847f,0.9337f,0.7914f,0.9421f,0.7898f,0.9371f,0.7950f,0.9430f,0.7843f,0.9335f,0.7986f,0.9489f,0.7994f,0.9476f,0.7963f,0.9387f,
	0.7976f,0.9438f,0.6414f,0.6476f,0.7348f,0.6747f,0.7004f,0.5431f,0.6312f,0.5488f,0.7452f,0.5552f,0.7561f,0.6206f,0.7463f,0.7521f,0.7607f,0.7242f,0.6819f,0.4830f,0.6917f,0.4373f,0.6674f,0.4727f,0.7148f,0.3928f,0.7493f,0.4338f,0.7452f,0.4782f,
	0.7796f,0.4667f,0.7014f,0.4998f,0.6198f,0.5343f,0.8251f,0.5831f,0.8431f,0.5330f,0.8007f,0.5784f,0.8022f,0.5215f,0.8041f,0.4966f,0.8240f,0.7252f,0.8197f,0.7168f,0.8158f,0.7333f,0.7898f,0.7232f,0.5717f,0.4641f,0.5824f,0.4789f,0.5852f,0.4760f,
	0.5854f,0.4898f,0.5867f,0.4876f,0.5852f,0.4760f,0.5854f,0.4898f,0.5854f,0.4898f,0.5824f,0.4789f,0.5835f,0.4830f,0.5870f,0.4941f,0.5717f,0.4641f,0.5730f,0.4683f,0.5809f,0.4968f,0.5815f,0.4950f,0.5854f,0.4898f,0.5809f,0.4968f,0.5815f,0.4950f,
	0.5867f,0.4876f,0.5684f,0.4993f,0.5686f,0.4975f,0.5815f,0.4950f,0.5281f,0.4903f,0.5110f,0.4873f,0.5110f,0.4873f,0.5134f,0.4080f,0.5136f,0.4158f,0.5134f,0.4080f,0.5336f,0.4279f,0.5336f,0.4279f,0.5336f,0.4279f,0.5136f,0.4158f,0.5359f,0.4331f,
	0.6177f,0.4827f,0.5540f,0.4456f,0.5561f,0.4399f,0.5540f,0.4456f,0.6224f,0.4458f,0.6146f,0.4342f,0.6060f,0.5135f,0.6154f,0.5168f,0.6032f,0.5347f,0.6015f,0.5242f,0.8272f,0.7330f,0.8203f,0.7447f,0.8279f,0.7520f,0.8326f,0.7373f,0.8287f,0.7604f,
	0.8242f,0.7470f,0.8323f,0.7681f,0.8320f,0.7597f,0.8383f,0.7456f,0.7806f,0.8254f,0.7579f,0.8105f,0.7468f,0.7864f,0.7653f,0.8194f,0.7615f,0.8138f,0.7670f,0.7754f,0.7671f,0.7668f,0.7581f,0.7817f,0.7666f,0.7581f,0.8516f,0.7734f,0.8502f,0.7958f,
	0.8580f,0.8163f,0.8578f,0.8045f,0.8455f,0.8380f,0.8623f,0.8048f,0.8620f,0.8167f,0.8110f,0.7403f,0.8022f,0.7367f,0.8069f,0.7416f,0.8033f,0.7549f,0.8086f,0.7535f,0.8077f,0.7468f,0.8030f,0.7481f,0.8119f,0.7455f,0.8532f,0.8254f,0.8329f,0.8291f,
	0.8443f,0.8340f,0.8038f,0.8292f,0.8076f,0.8353f,0.7787f,0.7385f,0.7890f,0.7454f,0.7878f,0.7600f,0.7785f,0.7573f,0.7670f,0.7754f,0.7785f,0.7573f,0.7671f,0.7668f,0.7968f,0.7496f,0.7964f,0.7568f,0.8381f,0.8056f,0.8367f,0.7925f,0.8340f,0.8481f,
	0.8341f,0.7805f,0.8385f,0.7994f,0.8366f,0.7879f,0.8422f,0.8002f,0.8446f,0.8251f,0.8415f,0.8231f,0.8026f,0.7664f,0.8088f,0.7646f,0.7999f,0.8070f,0.8090f,0.8295f,0.7671f,0.7876f,0.7949f,0.7687f,0.8202f,0.8631f,0.8271f,0.8766f,0.7893f,0.8523f,
	0.7791f,0.8562f,0.7687f,0.8361f,0.7692f,0.8400f,0.7661f,0.8279f,0.7684f,0.8438f,0.8221f,0.9144f,0.8034f,0.9308f,0.8041f,0.9353f,0.8081f,0.9432f,0.7909f,0.8764f,0.7960f,0.9383f,0.7737f,0.8639f,0.7833f,0.9276f,0.7769f,0.9198f,0.8112f,0.9160f,
	0.7778f,0.9189f,0.7833f,0.9281f,0.7894f,0.9329f,0.7789f,0.9230f,0.5025f,0.5746f,
_NULL_ }; /* End of head_UV */

const float head_Normals[] = {
	-0.3398f,-0.3062f,-0.8893f, -0.5430f,-0.3896f,-0.7439f, -0.1947f,-0.3038f,-0.9326f, -0.1894f,-0.3815f,-0.9048f, 0.0673f,-0.5849f,-0.8083f, -0.1441f,-0.5108f,-0.8475f, 0.0288f,-0.3204f,-0.9468f, -0.0768f,-0.2478f,-0.9658f, -0.0108f,0.0041f,-0.9999f, -0.1669f,0.0143f,-0.9859f, -0.0772f,-0.1144f,-0.9904f, -0.2999f,-0.2032f,-0.9321f, -0.4363f,-0.3947f,-0.8086f, -0.6090f,-0.5641f,-0.5576f, -0.3488f,-0.3781f,-0.8575f, 
	-0.5204f,-0.4539f,-0.7233f, -0.2061f,-0.3332f,-0.9201f, -0.0212f,-0.5054f,-0.8626f, -0.4666f,-0.7736f,-0.4287f, -0.2196f,-0.7108f,-0.6682f, 0.0882f,-0.6759f,-0.7317f, -0.4491f,0.7935f,-0.4107f, -0.7478f,0.6592f,0.0787f, -0.9763f,0.1268f,-0.1751f, -0.7215f,0.2066f,-0.6609f, -0.8011f,0.4917f,0.3413f, -0.9907f,0.0473f,0.1275f, -0.9620f,-0.2728f,-0.0090f, -0.8788f,-0.3602f,-0.3129f, -0.7088f,-0.3049f,-0.6361f, 
	-0.9416f,-0.1586f,0.2971f, -0.8668f,0.2593f,0.4259f, -0.4891f,-0.8692f,-0.0722f, -0.7605f,-0.6268f,-0.1696f, -0.7934f,-0.5814f,0.1800f, -0.3116f,-0.8628f,-0.3982f, -0.6239f,-0.6108f,-0.4875f, -0.7088f,-0.3049f,-0.6361f, 0.0562f,0.7233f,-0.6882f, -0.2648f,0.7747f,-0.5743f, -0.0262f,0.9416f,-0.3356f, 0.2423f,0.8901f,-0.3860f, 0.0568f,0.9971f,-0.0501f, -0.0262f,0.3058f,-0.9517f, -0.3471f,0.4560f,-0.8195f, 
	-0.5024f,-0.1749f,-0.8467f, -0.2748f,-0.2750f,-0.9213f, -0.6229f,0.5323f,-0.5733f, -0.7252f,-0.1212f,-0.6778f, 0.0345f,-0.0787f,-0.9963f, 0.3068f,0.6932f,-0.6522f, 0.0562f,0.9666f,-0.2499f, -0.3162f,0.9148f,-0.2514f, -0.1276f,0.8424f,-0.5236f, 0.1586f,0.7396f,-0.6541f, 0.2983f,0.8703f,-0.3918f, 0.0799f,0.4049f,-0.9109f, 0.0676f,0.1003f,-0.9927f, 0.1445f,0.2060f,-0.9678f, 0.8879f,-0.4290f,0.1664f, 
	0.7661f,-0.6375f,-0.0822f, 0.8000f,-0.5937f,0.0869f, 0.6250f,-0.5312f,0.5720f, 0.5838f,-0.4168f,0.6967f, 0.7951f,-0.3191f,0.5158f, 0.7361f,-0.5373f,0.4117f, 0.6250f,-0.5312f,0.5720f, 0.7951f,-0.3191f,0.5158f, 0.7740f,-0.6190f,0.1332f, 0.7964f,-0.5638f,0.2187f, 0.8883f,-0.2915f,0.3549f, 0.7507f,-0.0817f,0.6556f, 0.8298f,0.2245f,0.5109f, 0.9556f,0.1689f,0.2413f, 0.6356f,-0.3703f,0.6774f, 
	0.8464f,0.3163f,-0.4284f, 0.8201f,-0.2370f,-0.5208f, 0.4369f,-0.0386f,-0.8987f, 0.8187f,-0.4343f,-0.3756f, 0.9838f,0.1681f,0.0631f, 0.9045f,0.4242f,-0.0445f, 0.8413f,0.4716f,0.2644f, 0.8626f,0.5052f,0.0278f, 0.8298f,0.2245f,0.5109f, 0.5855f,0.2111f,0.7827f, 0.7599f,0.4265f,0.4906f, 0.7599f,0.4265f,0.4906f, 0.4736f,0.5280f,0.7050f, 0.8702f,0.3347f,0.3616f, 0.9437f,0.0284f,0.3297f, 
	0.4112f,0.8078f,0.4223f, 0.7495f,0.5196f,0.4102f, -0.4153f,-0.3571f,-0.8367f, -0.0542f,-0.5063f,-0.8606f, -0.2094f,-0.8918f,-0.4010f, -0.3031f,-0.7621f,-0.5721f, -0.3446f,-0.6361f,-0.6904f, -0.4594f,-0.7815f,-0.4221f, -0.3177f,-0.9013f,-0.2945f, -0.0682f,-0.8115f,-0.5803f, -0.1027f,-0.9738f,-0.2027f, -0.0917f,-0.8291f,-0.5515f, 0.0720f,-0.9704f,-0.2306f, -0.1705f,-0.9581f,-0.2302f, 0.1848f,-0.9683f,0.1681f, 
	0.1328f,-0.8202f,-0.5565f, 0.7131f,-0.5461f,-0.4397f, 0.7054f,-0.7004f,-0.1090f, 0.6236f,-0.7319f,-0.2747f, 0.7187f,-0.6456f,-0.2583f, 0.8553f,-0.3607f,-0.3719f, 0.8419f,-0.5392f,-0.0202f, 0.9032f,-0.3521f,-0.2454f, 0.2455f,-0.9139f,-0.3233f, 0.3990f,-0.7848f,-0.4742f, 0.5285f,-0.7853f,-0.3223f, 0.5325f,-0.6847f,-0.4977f, 0.0381f,0.5810f,-0.8130f, -0.3121f,0.5554f,-0.7708f, -0.0361f,0.6296f,-0.7761f, 
	-0.3302f,0.7555f,-0.5658f, -0.7003f,0.6186f,-0.3563f, 0.0427f,0.8714f,-0.4887f, -0.2414f,0.9245f,-0.2949f, -0.6013f,0.5992f,-0.5285f, 0.2753f,-0.2021f,-0.9399f, 0.8954f,0.2079f,-0.3938f, 0.6396f,0.4620f,-0.6144f, 0.6194f,0.6801f,0.3923f, 0.2104f,0.7923f,0.5727f, 0.3237f,0.9427f,0.0808f, 0.5298f,0.7685f,0.3587f, 0.4301f,0.8666f,-0.2532f, 0.5923f,0.7509f,-0.2922f, 0.4851f,0.3305f,-0.8096f, 
	0.5330f,0.5488f,-0.6440f, 0.5663f,0.8094f,0.1555f, 0.4706f,0.8815f,0.0390f, 0.6824f,0.5761f,0.4499f, 0.7749f,0.1041f,0.6234f, 0.8598f,0.2100f,0.4655f, 0.1810f,0.9835f,-0.0048f, -0.2019f,0.9761f,0.0806f, 0.1810f,0.9835f,-0.0048f, 0.2942f,0.5247f,-0.7988f, 0.0744f,0.8826f,-0.4642f, 0.0460f,0.6895f,-0.7229f, -0.1849f,0.9274f,-0.3253f, -0.2171f,0.7678f,-0.6027f, 0.3041f,0.7893f,-0.5334f, 
	0.4368f,0.4552f,-0.7759f, 0.1528f,0.9722f,-0.1775f, -0.0900f,0.9882f,0.1242f, -0.3805f,0.8882f,0.2577f, -0.1587f,0.3797f,-0.9114f, -0.1522f,0.2676f,-0.9514f, 0.0418f,0.5132f,-0.8573f, 0.3388f,0.5599f,-0.7561f, 0.3829f,0.5364f,-0.7521f, 0.1073f,0.5523f,-0.8267f, 0.2519f,0.3620f,-0.8975f, -0.2040f,-0.5807f,-0.7881f, -0.1366f,-0.0277f,-0.9902f, -0.0525f,-0.3015f,-0.9520f, 0.3299f,-0.1635f,-0.9298f, 
	0.2788f,-0.5723f,-0.7712f, 0.4967f,-0.5300f,-0.6873f, 0.3303f,0.2816f,-0.9009f, 0.5371f,0.3006f,-0.7881f, 0.5104f,-0.1662f,-0.8437f, 0.1074f,0.0901f,-0.9901f, -0.3212f,-0.0571f,-0.9453f, 0.8119f,-0.5065f,-0.2904f, 0.9500f,0.2843f,-0.1295f, 0.9621f,-0.1387f,-0.2348f, 0.7446f,-0.3413f,-0.5737f, 0.8315f,0.3562f,-0.4262f, 0.7365f,0.2857f,-0.6131f, 0.6607f,-0.0229f,-0.7503f, 0.3584f,0.7088f,-0.6075f, 
	0.5480f,0.4192f,-0.7239f, 0.4531f,0.6229f,-0.6377f, -0.8504f,0.1650f,-0.4996f, -0.8504f,0.1650f,-0.4996f, -0.8504f,0.1650f,-0.4996f, -0.0290f,0.0771f,-0.9966f, -0.1203f,0.2085f,-0.9706f, -0.2167f,-0.7296f,-0.6487f, -0.1247f,-0.8932f,0.4321f, -0.3201f,-0.7308f,0.6029f, -0.2266f,-0.9339f,0.2767f, -0.0686f,-0.9801f,0.1864f, -0.7769f,-0.6115f,0.1499f, -0.7741f,-0.6190f,0.1328f, -0.7831f,-0.5898f,0.1972f, 
	-0.7847f,-0.5825f,0.2121f, 0.1256f,-0.9677f,0.2184f, -0.0883f,-0.8493f,-0.5205f, 0.0914f,-0.9935f,0.0684f, 0.1515f,-0.9771f,0.1495f, 0.3523f,-0.9285f,-0.1172f, -0.0838f,-0.9319f,0.3528f, -0.1104f,-0.6516f,-0.7505f, 0.0492f,-0.4003f,-0.9151f, -0.3984f,0.1363f,-0.9070f, -0.4901f,0.1381f,-0.8606f, -0.5469f,0.1417f,-0.8251f, -0.7275f,0.1629f,-0.6665f, -0.7270f,0.1677f,-0.6658f, 0.0363f,-0.1741f,-0.9841f, 
	-0.0600f,0.0404f,-0.9974f, -0.4879f,0.8726f,-0.0215f, -0.5991f,0.7888f,-0.1378f, -0.4854f,0.8387f,0.2470f, -0.5805f,0.6527f,0.4868f, -0.2511f,0.9403f,0.2298f, -0.6396f,0.5610f,0.5255f, -0.7054f,0.0570f,0.7066f, -0.4491f,0.7935f,-0.4107f, -0.0666f,0.9960f,-0.0596f, -0.3834f,0.8731f,0.3012f, 0.0036f,1.0000f,0.0047f, -0.7387f,-0.2036f,0.6425f, -0.8022f,0.1941f,0.5647f, -0.4568f,-0.6581f,0.5985f, 
	-0.6820f,-0.6250f,0.3799f, -0.3168f,-0.9352f,0.1585f, -0.8780f,-0.1475f,0.4554f, -0.0009f,-0.9959f,-0.0907f, 0.3511f,-0.4243f,-0.8347f, 0.7030f,-0.5709f,-0.4241f, 0.5472f,-0.5597f,-0.6224f, 0.0435f,0.0907f,-0.9949f, 0.9228f,-0.3838f,0.0328f, 0.7241f,-0.6680f,0.1715f, 0.4519f,-0.5598f,-0.6945f, 0.4638f,-0.7503f,0.4710f, 0.0982f,-0.0676f,-0.9929f, -0.1089f,0.4308f,-0.8959f, -0.2931f,0.7735f,-0.5619f, 
	-0.2616f,0.9620f,-0.0784f, 0.7152f,0.2904f,-0.6357f, 0.0206f,0.0508f,-0.9985f, 0.4178f,-0.4042f,-0.8137f, 0.6390f,0.0560f,-0.7671f, -0.4797f,0.4507f,-0.7528f, 0.8198f,-0.2878f,0.4952f, 0.6444f,-0.3777f,0.6649f, 0.3542f,0.7162f,0.6013f, 0.5682f,0.2854f,0.7718f, 0.4887f,0.0187f,0.8723f, 0.1835f,0.4703f,-0.8632f, 0.0138f,0.4407f,-0.8975f, 0.5322f,0.0884f,-0.8420f, 0.4592f,0.7300f,-0.5062f, 
	0.1702f,0.6429f,-0.7468f, 0.0764f,0.1282f,-0.9888f, 0.1573f,0.9450f,0.2868f, 0.0373f,0.9964f,-0.0757f, -0.2785f,0.8753f,0.3955f, -0.1088f,0.6602f,0.7432f, 0.6496f,0.7492f,-0.1295f, 0.6952f,0.5964f,-0.4013f, 0.8775f,-0.0139f,-0.4793f, 0.7324f,0.6523f,-0.1952f, 0.6757f,-0.3573f,-0.6448f, 0.6757f,-0.3573f,-0.6448f, 0.6757f,-0.3573f,-0.6448f, 0.9451f,0.2689f,-0.1855f, -0.0034f,-0.0318f,-0.9995f, 
	0.3382f,-0.6336f,0.6958f, 0.3375f,-0.7384f,0.5839f, 0.4069f,-0.2361f,0.8824f, 0.2658f,-0.6376f,0.7231f, 0.2886f,-0.5068f,0.8123f, 0.9839f,0.0071f,0.1786f, 0.3711f,-0.4211f,-0.8276f, 0.3821f,-0.4311f,-0.8174f, 0.3796f,-0.4285f,-0.8199f, 0.3697f,-0.4199f,-0.8288f, 0.3859f,-0.4336f,-0.8143f, 0.5244f,-0.4746f,0.7069f, 0.4709f,-0.0718f,0.8793f, 0.2470f,0.3891f,0.8875f, 0.3875f,-0.1998f,0.9000f, 
	0.0079f,-0.2101f,-0.9776f, 0.3255f,-0.4282f,-0.8430f, 0.3004f,-0.5082f,-0.8071f, 0.6026f,-0.5497f,-0.5785f, 0.2981f,-0.5074f,-0.8085f, 0.1135f,-0.3107f,-0.9437f, -0.4694f,0.6635f,0.5826f, -0.5480f,0.8143f,0.1914f, -0.5482f,0.7821f,-0.2962f, -0.5426f,0.3197f,-0.7768f, -0.4403f,0.1596f,-0.8836f, -0.6287f,0.5945f,-0.5014f, -0.7097f,0.7012f,-0.0680f, 0.0223f,-0.2121f,-0.9770f, 0.3028f,-0.3339f,-0.8926f, 
	-0.2158f,0.5629f,0.7978f, -0.6851f,0.6178f,0.3860f, -0.4735f,0.6755f,0.5653f, -0.7610f,0.5294f,-0.3749f, -0.4961f,0.4316f,-0.7534f, -0.7573f,0.6436f,-0.1111f, 0.4697f,0.0719f,-0.8799f, -0.0513f,0.1702f,-0.9841f, 0.2596f,0.1942f,-0.9460f, -0.0834f,0.5319f,-0.8427f, -0.1576f,0.7896f,0.5930f, -0.6677f,0.6982f,0.2584f, -0.6898f,0.5630f,-0.4552f, -0.3574f,0.6478f,-0.6728f, -0.4838f,0.7646f,-0.4259f, 
	-0.5116f,0.8392f,-0.1844f, -0.9538f,-0.2761f,-0.1184f, -0.9222f,-0.3338f,-0.1951f, -0.8088f,-0.5670f,-0.1561f, -0.9601f,-0.2779f,0.0322f, -0.9811f,-0.1551f,0.1156f, -0.9187f,-0.3803f,-0.1071f, -0.8551f,-0.5140f,-0.0687f, -0.7992f,-0.5859f,0.1342f, -0.9968f,0.0661f,-0.0443f, -0.9547f,-0.2030f,-0.2177f, -0.9934f,-0.1144f,0.0092f, -0.9416f,-0.3178f,0.1113f, -0.8444f,-0.3853f,-0.3722f, -0.8578f,-0.5110f,0.0561f, 
	-0.8768f,-0.3786f,-0.2964f, -0.9902f,-0.0731f,0.1188f, -0.7210f,-0.6764f,0.1506f, -0.6837f,-0.7116f,-0.1617f, -0.7215f,0.2066f,-0.6609f, -0.2597f,0.1269f,-0.9573f, 0.0124f,0.6598f,-0.7513f, -0.3687f,-0.2961f,-0.8811f, -0.0956f,-0.2908f,-0.9520f, 0.0543f,0.0521f,-0.9972f, 0.2647f,0.4598f,-0.8476f, -0.3726f,-0.6133f,-0.6964f, -0.0826f,-0.5427f,-0.8359f, -0.1033f,-0.8678f,-0.4861f, 0.3051f,-0.6232f,-0.7200f, 
	0.1988f,-0.2518f,-0.9471f, 0.3133f,0.0865f,-0.9457f, -0.5876f,0.8091f,0.0043f, -0.6484f,0.7565f,0.0853f, -0.2598f,0.9635f,0.0650f, -0.5490f,0.8299f,-0.0997f, -0.2382f,0.9616f,-0.1362f, -0.4713f,0.8120f,-0.3444f, -0.2367f,0.9488f,0.2093f, -0.8371f,0.4751f,-0.2714f, -0.8837f,-0.1631f,-0.4387f, -0.9427f,0.3319f,0.0336f, -0.9396f,-0.2908f,-0.1806f, -0.2471f,0.9658f,0.0787f, -0.5013f,0.8624f,-0.0708f, 
	-0.3922f,0.8587f,0.3300f, -0.5993f,0.7795f,0.1820f, -0.6325f,0.7244f,0.2741f, -0.9902f,0.0774f,0.1165f, -0.8601f,0.5101f,0.0040f, -0.8762f,0.4383f,0.2004f, 0.1216f,-0.6461f,0.7535f, 0.0104f,-0.5315f,0.8470f, 0.3909f,-0.4050f,0.8265f, 0.1815f,-0.5640f,0.8056f, 0.4750f,-0.5374f,0.6968f, 0.3994f,-0.3622f,0.8422f, 0.2009f,-0.6193f,0.7590f, 0.2880f,-0.5641f,0.7739f, 0.6356f,-0.3703f,0.6774f, 
	0.7507f,-0.0817f,0.6556f, 0.0606f,0.1324f,0.9893f, 0.2603f,0.3245f,0.9094f, 0.3289f,-0.1994f,0.9231f, -0.0233f,0.0847f,0.9961f, -0.5036f,-0.2442f,0.8287f, -0.3194f,-0.4090f,0.8548f, 0.1841f,0.1858f,0.9652f, 0.3439f,0.4664f,0.8150f, 0.0688f,0.3625f,0.9295f, -0.3685f,0.3065f,0.8777f, -0.0411f,0.3651f,0.9301f, 0.4112f,0.8078f,0.4223f, 0.3576f,0.3421f,0.8690f, 0.6433f,0.1625f,0.7481f, 
	0.3674f,0.0346f,0.9294f, -0.8541f,-0.5193f,0.0279f, -0.6879f,-0.6827f,-0.2464f, -0.5662f,-0.8232f,-0.0422f, -0.5542f,-0.8314f,-0.0407f, -0.8008f,-0.5855f,0.1259f, -0.4217f,-0.8872f,-0.1873f, -0.2055f,-0.9749f,-0.0853f, -0.2342f,-0.9594f,-0.1572f, -0.2342f,-0.9594f,-0.1572f, -0.4687f,-0.8759f,-0.1146f, -0.2035f,-0.9752f,0.0875f, 0.1848f,-0.9683f,0.1681f, -0.4427f,-0.8303f,0.3385f, -0.5808f,-0.8137f,-0.0222f, 
	0.0541f,-0.5395f,0.8403f, -0.1278f,-0.4053f,0.9052f, -0.2434f,-0.4305f,0.8692f, -0.1933f,-0.6460f,0.7384f, -0.3960f,-0.5391f,0.7433f, -0.2517f,-0.6370f,0.7286f, -0.2733f,-0.7865f,0.5538f, -0.4281f,-0.6861f,0.5882f, -0.3957f,-0.8214f,0.4108f, -0.2991f,-0.9150f,0.2707f, -0.7305f,0.6543f,-0.1957f, -0.7784f,0.6224f,-0.0825f, -0.8053f,0.5069f,-0.3074f, -0.8589f,0.4975f,-0.1217f, -0.5725f,0.8195f,-0.0241f, 
	-0.4849f,0.8645f,0.1324f, -0.7471f,0.6613f,0.0676f, -0.8588f,0.5114f,0.0303f, -0.9491f,-0.1426f,0.2808f, -0.7862f,0.2633f,0.5591f, -0.3550f,0.1478f,0.9231f, -0.3017f,0.6078f,0.7345f, -0.7687f,0.3072f,0.5610f, -0.5154f,0.6744f,0.5288f, -0.7112f,0.3647f,0.6010f, -0.2147f,0.8666f,0.4505f, -0.2394f,0.7509f,0.6155f, 0.5367f,0.8214f,0.1931f, 0.3904f,0.7732f,0.4997f, 0.1087f,0.9427f,0.3154f, 
	0.4041f,0.6824f,0.6091f, 0.0745f,0.8931f,0.4436f, 0.1809f,0.8357f,0.5185f, 0.5067f,0.5766f,0.6410f, -0.1330f,0.9588f,0.2510f, -0.6296f,0.7506f,-0.2008f, -0.3401f,0.9274f,-0.1559f, -0.7276f,0.6795f,0.0941f, -0.4560f,0.8826f,0.1146f, -0.7813f,0.4908f,0.3855f, 0.2449f,0.8942f,-0.3747f, -0.2651f,0.8322f,-0.4871f, 0.2093f,0.9651f,-0.1572f, -0.1635f,0.9722f,0.1677f, -0.7716f,0.3944f,0.4991f, 
	-0.5061f,0.7840f,0.3595f, -0.8029f,0.5961f,0.0104f, -0.8247f,0.5194f,0.2237f, -0.8543f,0.4791f,0.2017f, -0.9153f,0.4012f,-0.0354f, -0.7309f,0.4757f,0.4894f, -0.6899f,0.6007f,0.4039f, -0.8778f,0.3765f,0.2963f, -0.7279f,0.4847f,0.4850f, -0.9997f,0.0111f,0.0195f, -0.9368f,-0.3430f,0.0685f, -0.9315f,-0.2325f,-0.2798f, -0.7429f,-0.6158f,0.2623f, -0.6400f,-0.5638f,0.5221f, -0.8180f,-0.1345f,0.5593f, 
	-0.5658f,-0.4676f,0.6792f, -0.9613f,0.0853f,0.2619f, -0.9707f,-0.0451f,-0.2362f, -0.2515f,0.3885f,0.8865f, -0.1728f,-0.1130f,0.9785f, -0.5589f,0.4442f,0.7002f, -0.5466f,0.0205f,0.8371f, -0.4634f,-0.3374f,0.8194f, -0.8589f,-0.0681f,0.5076f, -0.6138f,0.4464f,0.6511f, -0.8421f,0.4455f,0.3040f, -0.5273f,0.6852f,0.5025f, -0.9955f,0.0727f,0.0609f, -0.9719f,0.2236f,-0.0736f, -0.9925f,0.0663f,0.1028f, 
	-0.5720f,0.1651f,-0.8035f, -0.5720f,0.1651f,-0.8035f, -0.5720f,0.1651f,-0.8035f, -0.9738f,0.2106f,-0.0859f, 0.4106f,0.0637f,-0.9096f, -0.1952f,0.6273f,-0.7539f, 0.3083f,0.4195f,-0.8538f, 0.6250f,-0.1303f,-0.7697f, -0.2757f,0.7419f,-0.6112f, 0.0967f,0.7280f,-0.6787f, 0.5715f,-0.7295f,-0.3758f, -0.6656f,-0.7290f,-0.1600f, 0.0813f,-0.6111f,-0.7874f, 0.1428f,-0.5820f,-0.8005f, 0.1280f,-0.5893f,-0.7977f, 
	0.0644f,-0.6185f,-0.7831f, 0.4201f,-0.8927f,-0.1630f, 0.1804f,-0.9798f,-0.0860f, 0.2562f,-0.9335f,-0.2510f, 0.2894f,-0.9527f,0.0933f, -0.5253f,-0.8498f,-0.0441f, 0.0778f,-0.9935f,0.0834f, -0.7606f,-0.6468f,-0.0569f, -0.9001f,0.1379f,-0.4132f, -0.8698f,0.1415f,-0.4727f, -0.9384f,0.1361f,-0.3177f, -0.9062f,-0.4020f,0.1309f, -0.0652f,0.8731f,-0.4832f, 0.2069f,0.9412f,-0.2670f, 0.2022f,0.8303f,-0.5194f, 
	0.4825f,0.3778f,-0.7902f, -0.1906f,0.7891f,-0.5840f, -0.9684f,-0.2051f,0.1417f, -0.9988f,0.0400f,0.0271f, 0.4215f,0.6815f,-0.5982f, 0.2340f,0.8869f,-0.3983f, 0.5818f,-0.1435f,-0.8006f, 0.3979f,-0.1628f,-0.9029f, 0.1611f,-0.9147f,-0.3706f, 0.5567f,-0.6575f,-0.5076f, -0.8009f,-0.4243f,0.4225f, -0.9834f,0.1197f,0.1363f, -0.5723f,-0.5597f,0.5994f, -0.3611f,-0.5709f,0.7373f, -0.5956f,-0.6267f,0.5026f, 
	-0.9805f,-0.0676f,0.1844f, 0.5108f,-0.7480f,0.4237f, 0.2443f,-0.6712f,0.6998f, 0.1402f,-0.3445f,0.9283f, -0.1146f,0.9616f,-0.2495f, -0.6104f,0.7668f,-0.1988f, -0.8977f,0.4404f,0.0091f, -0.4272f,0.7679f,-0.4773f, -0.7868f,0.4383f,-0.4345f, -0.7964f,-0.4042f,0.4499f, -0.7085f,0.0560f,0.7035f, -0.9929f,0.0508f,0.1076f, -0.5708f,0.2835f,0.7706f, 0.5635f,-0.3103f,0.7656f, 0.7271f,-0.3485f,0.5915f, 
	0.7743f,0.5937f,0.2192f, 0.8936f,-0.0361f,0.4475f, 0.9410f,0.2731f,0.1999f, 0.7676f,0.3611f,0.5295f, 0.4472f,0.8143f,0.3701f, -0.6573f,0.7392f,0.1466f, -0.3611f,0.8648f,0.3489f, -0.4003f,0.8717f,0.2827f, -0.7924f,0.0884f,0.6036f, -0.9784f,0.1282f,0.1623f, -0.7359f,0.6346f,0.2362f, -0.4379f,0.7529f,0.4914f, -0.9158f,0.3955f,0.0703f, 0.2653f,0.9485f,0.1732f, 0.2797f,0.9601f,-0.0016f, 
	0.7292f,0.6802f,-0.0751f, -0.0962f,0.9948f,0.0322f, 0.3622f,0.8828f,-0.2993f, -0.3640f,0.6153f,0.6992f, -0.0635f,0.7386f,0.6712f, -0.1912f,-0.0985f,0.9766f, -0.0825f,0.2912f,0.9531f, -0.5834f,-0.3573f,0.7293f, -0.5834f,-0.3573f,0.7293f, -0.5834f,-0.3573f,0.7293f, -0.1319f,0.6477f,0.7504f, -0.3860f,-0.0082f,0.9224f, 0.1903f,-0.6360f,0.7479f, -0.0120f,-0.8549f,0.5186f, 0.0531f,-0.0960f,0.9940f, 
	-0.0764f,-0.8574f,0.5090f, 0.8344f,-0.5068f,0.2167f, 0.7170f,-0.6492f,0.2538f, 0.7521f,-0.4959f,0.4342f, 0.9292f,-0.1174f,0.3505f, 0.9281f,-0.1873f,0.3218f, -0.8109f,-0.4268f,0.4003f, -0.9750f,-0.1949f,0.1068f, -0.7110f,-0.5997f,0.3672f, -0.8696f,-0.3985f,0.2917f, -0.7830f,-0.5008f,0.3691f, -0.5081f,-0.5507f,0.6623f, 0.6411f,0.6495f,-0.4090f, 0.8462f,0.5036f,-0.1743f, 0.2215f,0.8253f,-0.5194f, 
	-0.1337f,0.7082f,-0.6932f, -0.5542f,0.5945f,-0.5826f, -0.9568f,-0.2707f,0.1057f, -0.9186f,0.1596f,-0.3616f, -0.8246f,0.3239f,-0.4639f, 0.8648f,0.4612f,0.1982f, -0.8441f,-0.1091f,0.5250f, 0.7295f,0.5980f,-0.3320f, 0.7297f,0.6779f,-0.0890f, 0.3787f,0.6101f,-0.6960f, 0.5163f,0.6796f,-0.5212f, -0.4398f,0.5294f,-0.7255f, -0.1767f,0.6436f,-0.7447f, -0.7863f,0.4662f,-0.4054f, -0.9276f,-0.2385f,0.2874f, 
	-0.9874f,0.1097f,0.1139f, -0.9426f,0.1348f,0.3056f, 0.1992f,0.6982f,-0.6877f, -0.5196f,0.5971f,-0.6112f, -0.7743f,-0.4657f,-0.4283f, 
_NULL_ }; /* End of head_Normals */

const unsigned short head_Faces[] = {
	0, 2, 1, 2, 3, 1, 4, 6, 5, 2, 5, 3, 2, 7, 5, 3, 5, 6, 0, 8, 2, 9, 11, 10, 6, 10, 3, 11, 3, 10, 
	1, 3, 12, 11, 12, 3, 13, 15, 14, 16, 17, 14, 18, 13, 19, 20, 19, 17, 17, 19, 14, 13, 14, 19, 17, 6, 4, 20, 17, 4, 
	21, 23, 22, 21, 24, 23, 25, 23, 26, 25, 22, 23, 27, 23, 28, 27, 26, 23, 29, 23, 24, 29, 28, 23, 30, 26, 27, 30, 31, 26, 
	25, 26, 31, 32, 34, 33, 30, 33, 34, 30, 27, 33, 35, 33, 36, 37, 33, 28, 37, 36, 33, 27, 28, 33, 32, 33, 35, 38, 40, 39, 
	41, 42, 40, 43, 45, 44, 43, 46, 45, 47, 45, 48, 47, 44, 45, 16, 49, 17, 38, 50, 40, 41, 40, 50, 51, 53, 52, 47, 53, 44, 
	47, 52, 53, 43, 53, 54, 43, 44, 53, 55, 53, 51, 55, 54, 53, 9, 57, 56, 9, 10, 57, 6, 57, 10, 56, 50, 38, 56, 58, 50, 
	6, 49, 57, 6, 17, 49, 56, 49, 58, 56, 57, 49, 59, 61, 60, 62, 64, 63, 65, 67, 66, 68, 70, 69, 68, 61, 70, 65, 70, 67, 
	65, 69, 70, 67, 70, 59, 59, 70, 61, 71, 73, 72, 71, 59, 73, 71, 74, 59, 59, 74, 67, 75, 77, 76, 78, 79, 76, 79, 80, 76, 
	79, 81, 80, 75, 76, 80, 82, 81, 73, 81, 82, 80, 83, 85, 84, 72, 81, 86, 84, 85, 87, 72, 73, 81, 79, 89, 88, 79, 88, 81, 
	90, 86, 91, 91, 86, 88, 81, 88, 86, 1, 92, 0, 93, 8, 0, 94, 96, 95, 93, 0, 96, 0, 92, 96, 97, 99, 98, 99, 100, 98, 
	94, 101, 96, 93, 96, 101, 99, 101, 100, 99, 93, 101, 94, 100, 101, 102, 104, 103, 103, 94, 105, 94, 95, 105, 105, 102, 103, 106, 108, 107, 
	60, 107, 108, 109, 106, 110, 111, 109, 110, 60, 110, 107, 106, 107, 110, 68, 112, 61, 68, 111, 112, 60, 61, 112, 60, 112, 110, 111, 110, 112, 
	102, 114, 113, 115, 114, 116, 115, 113, 114, 108, 114, 105, 108, 116, 114, 105, 114, 102, 109, 116, 106, 109, 115, 116, 108, 106, 116, 117, 39, 118, 
	117, 118, 119, 118, 121, 120, 122, 119, 120, 123, 122, 120, 119, 118, 120, 124, 118, 39, 125, 127, 126, 127, 128, 126, 129, 131, 130, 132, 131, 133, 
	132, 130, 131, 127, 131, 128, 127, 133, 131, 125, 134, 127, 127, 134, 133, 132, 134, 135, 132, 133, 134, 90, 91, 136, 137, 136, 138, 139, 138, 136, 
	91, 139, 136, 89, 140, 88, 91, 88, 140, 91, 140, 139, 123, 141, 122, 136, 137, 141, 90, 136, 141, 142, 143, 123, 144, 146, 145, 145, 146, 147, 
	148, 147, 146, 135, 150, 149, 132, 149, 151, 132, 135, 149, 145, 151, 149, 144, 149, 150, 144, 145, 149, 129, 130, 151, 152, 129, 151, 145, 152, 151, 
	132, 151, 130, 145, 147, 152, 152, 147, 153, 39, 117, 38, 9, 56, 154, 154, 156, 155, 38, 117, 156, 56, 38, 154, 154, 38, 156, 117, 157, 156, 
	158, 156, 157, 158, 159, 156, 157, 117, 160, 95, 96, 161, 161, 96, 92, 162, 163, 92, 161, 92, 163, 1, 12, 92, 164, 166, 165, 161, 163, 165, 
	164, 165, 163, 95, 161, 105, 161, 165, 105, 158, 168, 167, 169, 167, 168, 156, 159, 162, 162, 159, 170, 167, 170, 159, 158, 167, 159, 162, 170, 163, 
	164, 163, 170, 167, 164, 170, 167, 169, 164, 164, 169, 166, 9, 171, 11, 9, 154, 171, 171, 92, 12, 11, 171, 12, 171, 155, 92, 92, 155, 162, 
	156, 162, 155, 154, 155, 171, 60, 172, 59, 60, 108, 172, 73, 174, 173, 175, 176, 174, 174, 176, 173, 175, 174, 172, 59, 172, 174, 73, 59, 174, 
	158, 177, 168, 169, 168, 178, 178, 168, 177, 175, 166, 169, 178, 175, 169, 178, 177, 175, 175, 177, 176, 172, 108, 175, 165, 108, 105, 165, 166, 108, 
	175, 108, 166, 179, 77, 180, 75, 180, 77, 181, 180, 157, 181, 179, 180, 158, 180, 177, 158, 157, 180, 73, 173, 82, 75, 82, 173, 176, 75, 173, 
	75, 80, 82, 177, 180, 176, 75, 176, 180, 7, 2, 8, 182, 184, 183, 185, 186, 8, 4, 5, 187, 188, 190, 189, 188, 191, 190, 192, 194, 193, 
	192, 195, 194, 7, 187, 5, 188, 196, 191, 18, 19, 197, 196, 199, 198, 20, 197, 19, 199, 196, 200, 188, 201, 196, 97, 202, 99, 93, 202, 203, 
	93, 99, 202, 204, 206, 205, 207, 206, 208, 207, 205, 206, 8, 93, 209, 185, 209, 210, 185, 8, 209, 203, 210, 209, 93, 203, 209, 211, 213, 212, 
	214, 212, 213, 211, 215, 213, 25, 31, 216, 213, 216, 214, 217, 214, 216, 218, 220, 219, 218, 22, 220, 221, 220, 215, 221, 219, 220, 213, 220, 216, 
	213, 215, 220, 25, 220, 22, 25, 216, 220, 222, 217, 223, 201, 189, 224, 201, 188, 189, 222, 189, 217, 222, 224, 189, 32, 225, 34, 32, 226, 225, 
	30, 225, 227, 30, 34, 225, 222, 225, 224, 222, 227, 225, 201, 225, 226, 201, 224, 225, 31, 223, 216, 217, 216, 223, 222, 223, 227, 30, 223, 31, 
	30, 227, 223, 32, 35, 228, 201, 226, 228, 32, 228, 226, 77, 229, 76, 78, 229, 230, 78, 76, 229, 231, 230, 229, 232, 229, 77, 89, 79, 233, 
	234, 89, 233, 231, 233, 230, 78, 233, 79, 78, 230, 233, 235, 234, 231, 235, 236, 234, 231, 234, 233, 232, 237, 229, 231, 229, 237, 235, 231, 237, 
	117, 119, 238, 238, 119, 239, 240, 119, 122, 240, 239, 119, 241, 160, 242, 241, 157, 160, 238, 242, 160, 117, 238, 160, 243, 244, 242, 238, 245, 242, 
	241, 242, 244, 238, 239, 245, 89, 246, 140, 139, 246, 247, 139, 140, 246, 234, 246, 89, 234, 247, 246, 137, 249, 248, 137, 138, 249, 139, 249, 138, 
	139, 247, 249, 247, 250, 249, 248, 249, 250, 236, 247, 234, 232, 77, 251, 252, 251, 179, 252, 232, 251, 179, 251, 77, 253, 255, 254, 253, 256, 255, 
	179, 254, 255, 252, 179, 255, 252, 255, 256, 137, 257, 141, 137, 248, 257, 240, 122, 258, 141, 258, 122, 141, 257, 258, 257, 259, 258, 240, 258, 259, 
	248, 260, 257, 181, 262, 261, 181, 157, 262, 241, 262, 157, 241, 261, 262, 181, 261, 179, 253, 264, 263, 253, 254, 264, 179, 264, 254, 179, 261, 264, 
	265, 267, 266, 243, 263, 268, 241, 268, 261, 241, 244, 268, 261, 268, 264, 263, 264, 268, 232, 235, 237, 232, 269, 235, 270, 236, 271, 235, 271, 236, 
	272, 274, 273, 271, 274, 270, 271, 273, 274, 269, 275, 235, 276, 278, 277, 276, 279, 278, 280, 277, 278, 236, 281, 247, 282, 247, 281, 270, 281, 236, 
	270, 282, 281, 248, 250, 283, 282, 250, 247, 282, 283, 250, 282, 275, 283, 272, 284, 274, 272, 275, 284, 270, 284, 282, 270, 274, 284, 282, 284, 275, 
	253, 285, 256, 253, 286, 285, 252, 256, 285, 252, 269, 232, 252, 285, 269, 286, 287, 285, 285, 287, 269, 253, 288, 286, 253, 263, 288, 289, 288, 243, 
	263, 243, 288, 289, 287, 288, 286, 288, 287, 289, 290, 287, 248, 283, 260, 257, 260, 291, 240, 259, 292, 257, 291, 259, 292, 259, 291, 240, 292, 239, 
	245, 239, 293, 292, 293, 239, 243, 242, 289, 290, 295, 294, 296, 294, 295, 245, 295, 242, 245, 296, 295, 289, 295, 290, 289, 242, 295, 292, 297, 293, 
	245, 297, 296, 245, 293, 297, 125, 269, 287, 298, 287, 290, 298, 299, 287, 125, 287, 299, 291, 260, 300, 283, 300, 260, 292, 291, 301, 300, 302, 291, 
	301, 291, 302, 283, 129, 300, 292, 301, 297, 296, 297, 303, 298, 290, 294, 296, 303, 294, 303, 304, 294, 298, 294, 304, 301, 305, 297, 303, 297, 305, 
	283, 275, 128, 283, 128, 129, 128, 131, 129, 275, 126, 128, 269, 125, 275, 275, 125, 126, 135, 125, 306, 135, 134, 125, 307, 299, 298, 307, 308, 299, 
	308, 125, 299, 135, 306, 150, 144, 306, 308, 144, 150, 306, 308, 306, 125, 146, 308, 309, 307, 309, 308, 144, 308, 146, 300, 129, 310, 311, 301, 302, 
	152, 153, 310, 300, 153, 302, 300, 310, 153, 311, 302, 153, 152, 310, 129, 312, 303, 305, 311, 305, 301, 307, 298, 304, 312, 304, 303, 146, 313, 148, 
	146, 309, 313, 148, 313, 314, 312, 313, 304, 312, 314, 313, 307, 313, 309, 307, 304, 313, 147, 315, 153, 311, 315, 305, 311, 153, 315, 312, 315, 314, 
	312, 305, 315, 148, 315, 147, 148, 314, 315, 65, 66, 104, 68, 69, 104, 65, 104, 69, 68, 104, 111, 111, 104, 109, 109, 104, 115, 102, 113, 104, 
	115, 104, 113, 316, 318, 317, 319, 320, 317, 316, 317, 320, 321, 323, 322, 317, 322, 319, 317, 321, 322, 324, 326, 325, 325, 326, 321, 327, 321, 326, 
	317, 328, 321, 325, 321, 328, 327, 323, 321, 327, 329, 323, 329, 331, 330, 13, 330, 15, 332, 323, 329, 18, 333, 13, 13, 333, 330, 329, 330, 333, 
	332, 329, 333, 218, 335, 334, 218, 336, 335, 37, 335, 337, 37, 334, 335, 338, 335, 339, 338, 337, 335, 340, 335, 336, 340, 339, 335, 35, 36, 341, 
	35, 341, 342, 338, 341, 337, 338, 342, 341, 37, 341, 36, 37, 337, 341, 343, 342, 344, 345, 342, 338, 345, 344, 342, 35, 342, 343, 340, 346, 339, 
	345, 339, 346, 345, 338, 339, 347, 349, 348, 350, 351, 347, 39, 40, 352, 352, 40, 351, 349, 351, 40, 349, 347, 351, 352, 351, 350, 40, 42, 349, 
	353, 349, 42, 47, 355, 354, 47, 48, 355, 356, 355, 357, 356, 354, 355, 51, 359, 358, 51, 52, 359, 360, 359, 361, 360, 358, 359, 356, 359, 354, 
	356, 361, 359, 47, 359, 52, 47, 354, 359, 348, 349, 362, 356, 362, 361, 353, 362, 349, 353, 361, 362, 324, 363, 326, 324, 364, 363, 327, 326, 363, 
	364, 365, 363, 365, 331, 363, 365, 356, 331, 327, 331, 329, 327, 363, 331, 365, 362, 356, 348, 362, 365, 366, 368, 367, 366, 369, 368, 370, 63, 371, 
	370, 62, 63, 372, 371, 369, 372, 373, 371, 368, 369, 371, 370, 371, 373, 371, 374, 368, 63, 64, 374, 371, 63, 374, 83, 84, 375, 375, 368, 374, 
	376, 378, 377, 375, 84, 377, 378, 375, 377, 378, 368, 375, 368, 378, 367, 379, 381, 380, 379, 382, 381, 379, 383, 382, 379, 384, 383, 385, 386, 380, 
	379, 386, 384, 379, 380, 386, 377, 84, 383, 377, 383, 384, 387, 87, 85, 382, 383, 388, 84, 388, 383, 84, 87, 388, 87, 389, 388, 382, 389, 390, 
	382, 388, 389, 391, 392, 316, 316, 392, 318, 97, 98, 393, 394, 395, 393, 98, 394, 393, 320, 395, 316, 391, 316, 395, 394, 391, 395, 396, 392, 394, 
	396, 394, 397, 391, 394, 392, 94, 397, 100, 98, 397, 394, 98, 100, 397, 396, 397, 94, 398, 103, 104, 398, 94, 103, 399, 396, 94, 399, 400, 396, 
	401, 399, 402, 401, 400, 399, 403, 400, 401, 396, 400, 392, 318, 392, 400, 403, 404, 400, 318, 400, 404, 372, 406, 405, 372, 369, 406, 405, 406, 407, 
	366, 407, 406, 366, 406, 369, 408, 407, 409, 405, 407, 408, 366, 410, 407, 409, 407, 410, 408, 412, 411, 408, 409, 412, 409, 410, 412, 401, 414, 413, 
	403, 413, 412, 403, 401, 413, 411, 413, 414, 411, 412, 413, 350, 347, 415, 347, 416, 415, 416, 417, 415, 416, 418, 417, 142, 123, 419, 121, 419, 123, 
	120, 121, 123, 420, 419, 421, 422, 419, 121, 422, 421, 419, 417, 418, 121, 422, 121, 418, 39, 352, 124, 417, 121, 118, 124, 417, 118, 124, 415, 417, 
	352, 415, 124, 352, 350, 415, 423, 425, 424, 426, 424, 425, 427, 429, 428, 430, 429, 431, 430, 428, 429, 426, 429, 424, 426, 431, 429, 423, 424, 429, 
	432, 434, 433, 426, 433, 431, 426, 435, 433, 430, 433, 434, 430, 431, 433, 426, 425, 435, 436, 438, 437, 87, 437, 389, 389, 437, 438, 387, 437, 87, 
	387, 439, 437, 387, 143, 439, 142, 439, 143, 439, 436, 437, 420, 439, 419, 142, 419, 439, 440, 442, 441, 443, 441, 442, 444, 443, 442, 445, 446, 441, 
	447, 445, 441, 443, 447, 441, 440, 441, 446, 432, 448, 434, 430, 434, 448, 443, 448, 447, 447, 448, 432, 427, 450, 449, 427, 428, 450, 444, 450, 443, 
	444, 449, 450, 443, 450, 448, 430, 450, 428, 430, 448, 450, 348, 451, 416, 347, 348, 416, 418, 451, 452, 418, 416, 451, 453, 452, 451, 348, 453, 451, 
	454, 364, 324, 348, 364, 453, 348, 365, 364, 454, 453, 364, 455, 456, 453, 452, 458, 457, 422, 452, 457, 452, 456, 458, 452, 453, 456, 422, 418, 452, 
	328, 317, 318, 459, 461, 460, 328, 318, 461, 460, 461, 318, 318, 404, 462, 460, 318, 462, 463, 462, 403, 403, 462, 404, 464, 460, 463, 463, 460, 462, 
	403, 465, 463, 464, 455, 466, 465, 464, 463, 459, 460, 466, 464, 466, 460, 455, 453, 466, 459, 453, 454, 459, 466, 453, 324, 325, 467, 454, 324, 467, 
	459, 454, 467, 459, 467, 461, 328, 461, 467, 325, 328, 467, 367, 410, 366, 468, 469, 376, 469, 367, 376, 376, 367, 378, 367, 469, 410, 470, 471, 468, 
	468, 471, 469, 464, 471, 455, 455, 471, 470, 410, 469, 472, 471, 465, 472, 471, 472, 469, 471, 464, 465, 403, 410, 465, 465, 410, 472, 403, 412, 410, 
	473, 474, 380, 385, 380, 474, 475, 474, 473, 474, 470, 385, 475, 470, 474, 458, 470, 476, 476, 470, 475, 458, 456, 470, 455, 470, 456, 384, 376, 377, 
	468, 385, 470, 386, 376, 384, 468, 376, 385, 385, 376, 386, 477, 479, 478, 480, 482, 481, 483, 478, 479, 319, 479, 320, 484, 486, 485, 484, 487, 486, 
	488, 486, 489, 488, 485, 486, 484, 490, 487, 323, 491, 322, 319, 322, 491, 492, 494, 493, 492, 495, 494, 496, 498, 497, 496, 490, 498, 496, 497, 499, 
	496, 499, 200, 499, 199, 200, 18, 500, 333, 332, 333, 500, 499, 501, 199, 97, 393, 502, 207, 504, 503, 207, 208, 504, 505, 503, 504, 395, 502, 393, 
	395, 506, 502, 507, 509, 508, 489, 510, 509, 488, 509, 511, 488, 489, 509, 507, 511, 509, 320, 512, 395, 320, 479, 512, 395, 512, 506, 506, 512, 513, 
	477, 512, 479, 477, 513, 512, 509, 514, 508, 218, 515, 336, 218, 219, 515, 340, 515, 514, 340, 336, 515, 514, 515, 508, 221, 515, 219, 221, 508, 515, 
	340, 514, 510, 509, 510, 514, 489, 486, 510, 516, 510, 486, 487, 516, 486, 340, 510, 346, 345, 346, 517, 516, 346, 510, 516, 517, 346, 343, 344, 518, 
	200, 344, 519, 200, 518, 344, 516, 344, 517, 516, 519, 344, 345, 517, 344, 487, 490, 516, 516, 490, 519, 200, 490, 496, 200, 519, 490, 343, 518, 228, 
	35, 343, 228, 200, 228, 518, 201, 228, 200, 201, 200, 196, 473, 380, 520, 521, 473, 520, 522, 520, 523, 381, 520, 380, 381, 523, 520, 524, 521, 525, 
	524, 525, 522, 522, 525, 520, 521, 520, 525, 524, 527, 526, 524, 522, 527, 390, 528, 382, 381, 528, 523, 381, 382, 528, 522, 528, 527, 522, 523, 528, 
	529, 421, 530, 529, 420, 421, 531, 530, 421, 422, 531, 421, 531, 532, 530, 531, 533, 532, 529, 530, 532, 534, 536, 535, 537, 535, 536, 531, 536, 533, 
	422, 457, 531, 531, 457, 536, 537, 457, 458, 537, 536, 457, 390, 538, 528, 527, 528, 538, 389, 538, 390, 389, 539, 538, 526, 527, 539, 527, 538, 539, 
	540, 542, 541, 539, 541, 542, 436, 543, 438, 436, 544, 543, 389, 543, 539, 389, 438, 543, 539, 543, 541, 540, 543, 544, 540, 541, 543, 545, 547, 546, 
	548, 550, 549, 548, 551, 550, 552, 549, 550, 545, 550, 547, 545, 552, 550, 547, 550, 551, 545, 524, 552, 545, 521, 524, 545, 475, 521, 545, 546, 475, 
	521, 475, 473, 436, 553, 544, 540, 544, 553, 439, 553, 436, 439, 554, 553, 554, 555, 553, 540, 553, 555, 529, 557, 556, 554, 556, 557, 420, 556, 439, 
	439, 556, 554, 529, 556, 420, 537, 458, 558, 559, 537, 558, 476, 558, 458, 476, 559, 558, 534, 561, 560, 562, 564, 563, 559, 561, 537, 537, 561, 535, 
	548, 565, 551, 548, 566, 565, 547, 551, 565, 559, 565, 561, 560, 565, 566, 560, 561, 565, 476, 546, 559, 476, 475, 546, 559, 546, 565, 547, 565, 546, 
	567, 569, 568, 570, 569, 524, 570, 568, 569, 570, 571, 568, 570, 572, 571, 567, 568, 571, 524, 526, 570, 526, 573, 570, 526, 539, 573, 572, 570, 573, 
	539, 574, 573, 567, 575, 569, 567, 571, 575, 574, 575, 573, 574, 569, 575, 572, 575, 571, 572, 573, 575, 574, 542, 569, 539, 542, 574, 548, 577, 576, 
	548, 549, 577, 552, 577, 549, 576, 579, 578, 576, 577, 579, 524, 569, 579, 577, 524, 579, 552, 524, 577, 534, 560, 580, 548, 581, 566, 548, 576, 581, 
	560, 581, 580, 560, 566, 581, 580, 581, 578, 576, 578, 581, 540, 555, 542, 554, 582, 555, 582, 583, 555, 542, 555, 583, 554, 557, 582, 584, 557, 529, 
	584, 582, 557, 584, 529, 532, 533, 585, 532, 533, 586, 585, 584, 532, 585, 587, 589, 588, 580, 587, 588, 533, 588, 586, 586, 588, 589, 534, 580, 536, 
	533, 536, 588, 580, 588, 536, 569, 542, 590, 587, 579, 591, 579, 587, 578, 580, 578, 587, 590, 542, 583, 582, 592, 583, 592, 593, 583, 590, 583, 593, 
	584, 594, 582, 592, 582, 595, 594, 595, 582, 584, 585, 594, 586, 596, 585, 596, 597, 585, 594, 585, 597, 586, 589, 596, 596, 589, 598, 587, 598, 589, 
	569, 435, 425, 569, 590, 435, 435, 590, 433, 432, 433, 590, 591, 579, 599, 569, 599, 579, 427, 599, 429, 427, 591, 599, 423, 429, 599, 569, 423, 599, 
	423, 569, 425, 591, 601, 600, 587, 591, 600, 440, 601, 442, 440, 600, 601, 444, 442, 601, 591, 444, 601, 427, 449, 591, 591, 449, 444, 432, 590, 593, 
	447, 432, 593, 592, 447, 593, 602, 445, 595, 592, 445, 447, 592, 595, 445, 602, 595, 594, 602, 594, 597, 596, 603, 597, 440, 446, 603, 603, 446, 597, 
	602, 446, 445, 602, 597, 446, 440, 598, 600, 440, 603, 598, 596, 598, 603, 600, 598, 587, 370, 402, 62, 372, 402, 373, 370, 373, 402, 372, 405, 402, 
	405, 408, 402, 408, 411, 402, 401, 402, 414, 411, 414, 402, 16, 14, 15, 46, 15, 45, 46, 16, 15, 48, 45, 15, 41, 55, 42, 55, 51, 42, 
	16, 46, 49, 58, 49, 46, 43, 58, 46, 41, 50, 55, 55, 50, 54, 43, 50, 58, 43, 54, 50, 331, 604, 330, 15, 330, 604, 48, 604, 355, 
	48, 15, 604, 353, 358, 360, 353, 42, 358, 51, 358, 42, 356, 357, 331, 331, 357, 604, 355, 604, 357, 353, 360, 361, 
_NULL_ }; /* End of head_Faces */


/* MESH 1 */

#define hand_left_NumVertex  210
#define hand_left_NumFaces   362
#define hand_left_NumStrips  0
#define hand_left_Flags      0x00020006
#define hand_left_Material   0

const float hand_left_Vertices[] = {
	-51.9847f,276.4645f,50.1261f, -54.9331f,276.7632f,51.6481f, -57.1146f,273.5288f,48.3762f, -53.7516f,275.8818f,46.0300f, -58.0841f,275.0086f,62.2592f, 
	-5.7798f,287.0007f,64.9624f, -23.6681f,286.4153f,80.7592f, -44.2940f,277.6931f,79.4534f, -40.1348f,279.6655f,39.4651f, -43.4671f,279.1504f,42.1036f, 
	-42.8801f,277.9608f,39.4077f, -81.4047f,245.8054f,29.4086f, -80.9668f,246.2015f,26.1346f, -78.3081f,250.6560f,27.0594f, -80.7779f,243.6667f,28.9491f, 
	-80.1967f,243.9988f,25.5198f, -79.6450f,244.8842f,33.8142f, -78.9926f,247.6582f,24.6295f, -75.9623f,250.1617f,25.1862f, -78.1802f,245.6613f,23.9298f, 
	-75.0286f,248.4157f,24.5552f, -76.2378f,244.7435f,25.2944f, -73.1974f,245.2347f,28.3138f, -77.9913f,243.1265f,26.7443f, -78.5795f,242.9533f,29.8871f, 
	-77.5621f,244.2005f,34.3703f, 2.8017f,285.8560f,79.9763f, 7.4918f,287.1624f,82.8777f, -4.1553f,288.9584f,94.4181f, -10.5055f,286.4729f,92.1608f, 
	6.8645f,280.6231f,76.8771f, 3.5256f,280.5739f,74.7955f, 10.2015f,280.2662f,81.3095f, 7.4918f,287.1624f,82.8777f, -13.8215f,280.1715f,105.8431f, 
	-4.1553f,288.9584f,94.4181f, -13.8215f,280.1715f,105.8431f, -17.4420f,277.2614f,99.4095f, 7.9781f,269.3577f,84.8340f, 10.2015f,280.2662f,81.3095f, 
	0.9013f,271.1240f,76.8483f, 7.9781f,269.3577f,84.8340f, 0.5562f,264.6402f,90.9042f, -15.9177f,267.4450f,104.7191f, -18.5580f,268.9507f,97.1049f, 
	-17.1914f,265.5424f,87.9009f, -37.7207f,261.0396f,77.7464f, -15.9177f,267.4450f,104.7191f, 0.5562f,264.6402f,90.9042f, 2.0463f,281.3773f,54.2855f, 
	2.7207f,274.9876f,63.1761f, -4.9742f,267.3043f,66.1955f, -9.6815f,276.5667f,40.4199f, -23.0609f,276.4798f,37.7306f, 12.2564f,279.4981f,23.0056f, 
	13.9208f,277.5340f,20.6426f, 14.6728f,278.3607f,24.5232f, 14.8297f,275.2277f,19.9968f, 15.5769f,276.2548f,24.1764f, 11.9452f,276.5627f,18.1829f, 
	12.7363f,274.0378f,17.3306f, 14.5106f,272.7961f,20.8368f, 12.9315f,271.7258f,29.4640f, 12.6003f,271.5624f,18.3397f, 11.4207f,269.5493f,21.1805f, 
	8.7884f,268.9836f,20.3671f, 9.7340f,270.7210f,17.5820f, 6.3720f,270.1210f,18.8494f, 9.7157f,272.8975f,16.5258f, 6.2006f,272.0179f,17.9031f, 
	9.1802f,275.2922f,17.4877f, -46.6032f,264.2817f,54.0147f, -45.6032f,263.5546f,49.7282f, -46.0476f,267.5817f,51.2161f, -52.6256f,264.4971f,54.6950f, 
	-38.1679f,265.3191f,46.9258f, -48.9290f,264.0218f,59.8112f, -22.4154f,267.4061f,38.5460f, -57.0238f,267.7708f,71.1858f, -56.4478f,265.1495f,69.8632f, 
	-73.3719f,257.1443f,9.6158f, -73.5065f,256.7151f,5.5187f, -71.0960f,261.0781f,14.2596f, -72.0992f,257.2081f,3.0128f, -71.3568f,260.0993f,5.6381f, 
	-73.1746f,254.3912f,5.1034f, -71.4731f,254.8228f,2.4647f, -73.1792f,254.9389f,9.4427f, -69.3862f,258.2059f,2.4724f, -65.9685f,259.8093f,4.0859f, 
	-68.5220f,256.0650f,1.8526f, -64.7869f,257.9375f,3.5638f, -63.3043f,256.4378f,5.0010f, -66.8431f,254.5515f,3.3887f, -64.1605f,254.0554f,6.7599f, 
	-69.5974f,253.2481f,3.9432f, -71.3052f,252.9660f,6.3473f, -71.4130f,253.5776f,10.3503f, -59.1083f,274.3933f,1.5017f, -58.9968f,274.3797f,-2.2605f, 
	-57.6315f,276.2486f,0.4467f, -57.3656f,274.4638f,-4.3290f, -59.1164f,272.2726f,-3.1116f, -57.3652f,272.3038f,-5.3462f, -54.4793f,274.2968f,-4.5101f, 
	-54.3691f,272.3493f,-5.5499f, -50.5406f,272.3417f,-3.5596f, -50.8107f,274.1116f,-2.6598f, -49.9428f,270.5307f,-2.6451f, -53.4216f,270.3763f,-4.5225f, 
	-51.4195f,268.6754f,-1.5901f, -56.1200f,270.1580f,-4.3325f, -57.7300f,270.2175f,-2.2069f, -53.9702f,268.3329f,6.9678f, -60.7371f,270.5970f,65.4870f, 
	-57.5352f,274.3243f,52.0935f, -56.0272f,273.8191f,48.8608f, -57.1146f,273.5288f,48.3762f, -57.5352f,274.3243f,52.0935f, -56.0272f,273.8191f,48.8608f, 
	-57.7309f,271.9602f,48.7664f, -59.6478f,269.8711f,47.1879f, -62.8240f,269.7115f,53.2321f, -76.5188f,247.8703f,39.7120f, -58.4819f,269.9114f,49.2852f, 
	-57.4754f,270.4706f,47.7068f, -58.4819f,269.9114f,49.2852f, -53.8104f,268.5697f,47.5988f, -56.4720f,267.5819f,47.7986f, -56.4720f,267.5819f,47.7986f, 
	-55.7667f,270.5654f,47.4985f, -58.4819f,269.9114f,49.2852f, -56.0272f,273.8191f,48.8608f, -57.7309f,271.9602f,48.7664f, -57.7309f,271.9602f,48.7664f, 
	-53.8104f,268.5697f,47.5988f, -48.8886f,266.0089f,51.7140f, -54.6049f,264.9360f,48.5037f, -46.0476f,267.5817f,51.2161f, -53.0106f,262.4959f,49.2879f, 
	-68.6442f,249.1353f,30.8951f, -55.7667f,270.5654f,47.4985f, -48.9290f,264.0218f,59.8112f, -52.6256f,264.4971f,54.6950f, -46.0476f,267.5817f,51.2161f, 
	-51.2591f,261.9960f,57.7190f, -55.6000f,262.8358f,63.5600f, -56.4478f,265.1495f,69.8632f, -55.6000f,262.8358f,63.5600f, -54.4611f,261.8453f,63.6972f, 
	-51.2591f,261.9960f,57.7190f, -60.5510f,263.0214f,62.3223f, -54.4611f,261.8453f,63.6972f, -60.7753f,266.8117f,64.8624f, -73.8195f,254.8138f,29.3452f, 
	-68.3406f,257.8156f,32.6145f, -72.3873f,246.3279f,39.1993f, -57.2754f,269.8144f,42.3117f, -56.1752f,273.9995f,33.7998f, -46.4400f,276.8645f,35.6584f, 
	-51.4208f,273.6519f,31.0588f, -43.9697f,275.1218f,35.0109f, -39.8445f,273.0140f,38.3885f, -41.1697f,272.1838f,38.7929f, -45.9450f,269.9587f,31.1459f, 
	-39.2816f,267.5153f,38.6676f, -36.3749f,268.1254f,39.8474f, -58.8146f,256.7146f,10.6736f, -53.3550f,261.9656f,39.2465f, -54.1847f,265.0264f,46.2824f, 
	-54.6049f,264.9360f,48.5037f, -55.7723f,263.6365f,39.6192f, -67.0974f,253.8766f,15.7185f, -71.0398f,256.6346f,15.1563f, -27.9877f,276.6048f,30.0445f, 
	-25.4523f,272.3454f,28.6027f, -21.8755f,269.2601f,36.0802f, -28.0146f,272.0014f,26.4609f, -25.1583f,270.3677f,29.1734f, -27.9008f,270.0183f,26.9583f, 
	-42.4230f,279.0313f,33.1838f, -50.0637f,278.2505f,18.9069f, -34.6000f,266.9794f,36.4466f, -40.4097f,268.1456f,30.5631f, -46.4394f,268.6260f,2.4719f, 
	-41.8826f,273.9795f,36.6128f, -42.7470f,276.9612f,36.5278f, -43.0066f,276.9044f,33.9882f, -43.8878f,273.8076f,31.1373f, -48.0947f,275.8239f,2.3322f, 
	-56.6446f,276.7092f,6.5063f, -42.6589f,274.2049f,6.8797f, -57.4355f,274.8538f,6.7644f, 2.7691f,270.6506f,49.2531f, 11.7716f,279.8270f,35.1399f, 
	8.0376f,281.7597f,32.7935f, -14.4545f,267.0231f,43.8939f, -6.4470f,268.1333f,38.3815f, -15.0757f,269.6674f,39.4238f, -15.6328f,271.6271f,38.8854f, 
	-11.5278f,274.0971f,39.2624f, -7.9994f,274.2343f,37.3096f, -12.1348f,271.7391f,38.9079f, -7.9861f,269.6316f,37.3615f, -11.5531f,269.7157f,39.3459f, 
	7.8321f,281.8226f,40.1427f, 12.2088f,280.6819f,28.9740f, 4.1219f,268.2828f,23.6201f, 2.6238f,271.6107f,21.7834f, 2.9749f,269.6114f,22.4277f, 
	
_NULL_ }; /* End of hand_left_Vertices */

const float hand_left_UV[] = {
	0.4521f,0.1702f,0.4409f,0.1684f,0.4590f,0.1566f,0.4519f,0.1591f,0.4457f,0.1824f,0.8308f,0.2811f,0.4567f,0.2814f,0.4571f,0.2396f,0.6213f,0.1713f,0.4780f,0.1705f,0.5481f,0.1656f,0.5345f,0.0635f,0.5400f,0.0582f,0.5327f,0.0670f,0.5430f,0.0623f,
	0.5498f,0.0570f,0.5353f,0.0742f,0.5449f,0.0595f,0.5465f,0.0670f,0.5549f,0.0583f,0.5570f,0.0663f,0.5612f,0.0635f,0.5638f,0.0746f,0.5566f,0.0624f,0.5496f,0.0673f,0.5419f,0.0783f,0.7392f,0.3233f,0.7585f,0.3374f,0.5193f,0.3413f,0.5047f,0.3250f,
	0.7547f,0.3209f,0.7504f,0.3114f,0.7443f,0.3347f,0.7585f,0.3374f,0.5033f,0.3418f,0.5193f,0.3413f,0.5033f,0.3418f,0.5131f,0.3218f,0.6909f,0.3311f,0.7443f,0.3347f,0.6964f,0.3053f,0.6909f,0.3311f,0.6383f,0.3276f,0.5419f,0.3285f,0.5428f,0.3105f,
	0.5766f,0.2931f,0.5404f,0.2371f,0.5419f,0.3285f,0.6383f,0.3276f,0.8407f,0.2703f,0.7767f,0.2845f,0.7101f,0.2729f,0.8385f,0.2215f,0.8268f,0.1942f,0.8820f,0.2262f,0.8780f,0.2233f,0.8770f,0.2324f,0.8721f,0.2221f,0.8712f,0.2320f,0.8774f,0.2147f,
	0.8711f,0.2129f,0.8646f,0.2217f,0.8518f,0.2350f,0.8634f,0.2131f,0.8547f,0.2153f,0.8533f,0.2091f,0.8615f,0.2064f,0.8577f,0.2029f,0.8686f,0.2056f,0.8643f,0.2019f,0.8745f,0.2081f,0.5466f,0.1791f,0.5675f,0.1721f,0.5424f,0.1767f,0.5191f,0.1706f,
	0.6204f,0.1801f,0.5253f,0.1862f,0.7651f,0.1914f,0.4763f,0.1968f,0.4878f,0.1937f,0.5872f,0.0458f,0.6134f,0.0375f,0.5591f,0.0608f,0.6448f,0.0353f,0.6249f,0.0433f,0.6243f,0.0358f,0.6553f,0.0339f,0.5979f,0.0445f,0.6768f,0.0394f,0.6994f,0.0491f,
	0.6853f,0.0383f,0.7071f,0.0489f,0.7024f,0.0532f,0.6841f,0.0431f,0.6800f,0.0537f,0.6595f,0.0388f,0.6330f,0.0404f,0.6094f,0.0483f,0.9449f,0.0643f,0.9446f,0.0573f,0.9607f,0.0658f,0.9399f,0.0561f,0.9210f,0.0542f,0.9197f,0.0528f,0.9304f,0.0604f,
	0.9144f,0.0574f,0.9061f,0.0675f,0.9195f,0.0699f,0.8899f,0.0691f,0.8949f,0.0597f,0.8731f,0.0676f,0.8953f,0.0555f,0.8927f,0.0569f,0.8327f,0.0795f,0.4605f,0.1815f,0.4513f,0.1635f,0.4601f,0.1595f,0.4590f,0.1566f,0.4513f,0.1635f,0.4601f,0.1595f,
	0.4676f,0.1554f,0.4761f,0.1479f,0.4643f,0.1541f,0.5271f,0.0925f,0.4777f,0.1539f,0.4792f,0.1529f,0.4777f,0.1539f,0.5065f,0.1576f,0.5007f,0.1529f,0.5007f,0.1529f,0.4853f,0.1553f,0.4777f,0.1539f,0.4601f,0.1595f,0.4676f,0.1554f,0.4676f,0.1554f,
	0.5065f,0.1576f,0.5342f,0.1720f,0.5212f,0.1558f,0.5424f,0.1767f,0.5374f,0.1584f,0.5641f,0.0894f,0.4853f,0.1553f,0.5253f,0.1862f,0.5191f,0.1706f,0.5424f,0.1767f,0.5287f,0.1771f,0.5040f,0.1816f,0.4878f,0.1937f,0.5040f,0.1816f,0.5104f,0.1832f,
	0.5287f,0.1771f,0.4923f,0.1712f,0.5104f,0.1832f,0.4758f,0.1780f,0.5287f,0.0813f,0.5309f,0.0984f,0.5432f,0.0974f,0.4918f,0.1425f,0.4709f,0.1306f,0.5370f,0.1519f,0.5505f,0.1330f,0.6421f,0.1537f,0.6648f,0.1657f,0.6412f,0.1638f,0.6660f,0.1399f,
	0.6635f,0.1638f,0.6798f,0.1713f,0.6956f,0.0716f,0.5681f,0.1384f,0.5277f,0.1523f,0.5212f,0.1558f,0.5454f,0.1361f,0.6105f,0.0658f,0.5784f,0.0599f,0.8529f,0.1715f,0.8279f,0.1704f,0.7873f,0.1887f,0.8290f,0.1618f,0.8135f,0.1707f,0.8139f,0.1618f,
	0.8295f,0.1551f,0.9575f,0.1148f,0.7147f,0.1670f,0.7226f,0.1469f,0.8628f,0.0836f,0.6581f,0.1595f,0.6346f,0.1597f,0.7044f,0.1544f,0.7153f,0.1457f,0.9238f,0.0849f,0.9673f,0.0793f,0.8958f,0.1016f,0.9416f,0.0774f,0.8035f,0.2553f,0.8711f,0.2488f,
	0.8810f,0.2393f,0.7672f,0.2145f,0.8074f,0.2178f,0.7944f,0.2065f,0.8053f,0.2058f,0.8254f,0.2148f,0.8358f,0.2169f,0.8128f,0.2116f,0.8141f,0.2143f,0.8026f,0.2122f,0.8726f,0.2531f,0.8804f,0.2383f,0.8455f,0.2072f,0.8579f,0.2032f,0.8508f,0.2038f,
	
_NULL_ }; /* End of hand_left_UV */

const float hand_left_Normals[] = {
	-0.2256f,0.9715f,-0.0732f, -0.2484f,0.9573f,-0.1477f, -0.7673f,0.6374f,0.0702f, -0.5124f,0.8573f,-0.0494f, -0.5735f,0.8101f,0.1217f, 0.1178f,0.9772f,-0.1764f, -0.2542f,0.9589f,0.1258f, -0.5700f,0.5600f,0.6012f, -0.1627f,0.9762f,-0.1432f, -0.2686f,0.9575f,-0.1054f, -0.3020f,0.8745f,-0.3796f, -0.9902f,0.0955f,0.1017f, -0.9032f,0.1481f,-0.4029f, -0.6633f,0.6710f,-0.3313f, -0.7229f,-0.6905f,0.0233f, 
	-0.5538f,-0.6008f,-0.5765f, -0.7560f,-0.4380f,0.4865f, -0.4909f,0.3689f,-0.7893f, -0.0590f,0.5600f,-0.8264f, -0.0990f,-0.2525f,-0.9625f, 0.4106f,0.0567f,-0.9101f, 0.4458f,-0.6166f,-0.6490f, 0.6256f,-0.7179f,-0.3052f, 0.1072f,-0.9469f,-0.3032f, -0.0383f,-0.9922f,0.1183f, -0.1574f,-0.8754f,0.4570f, 0.2905f,0.8977f,-0.3314f, 0.1976f,0.7340f,-0.6498f, -0.3139f,0.9444f,-0.0975f, -0.3242f,0.9311f,0.1671f, 
	0.6880f,0.1806f,-0.7029f, 0.9181f,0.0742f,-0.3894f, 0.7120f,0.0561f,-0.7000f, 0.6740f,0.0518f,0.7369f, 0.7465f,-0.1359f,0.6514f, 0.7080f,0.1249f,0.6951f, -0.8096f,0.5007f,0.3063f, -0.7738f,0.3701f,0.5140f, 0.6003f,0.1035f,0.7930f, 0.6747f,0.0988f,0.7314f, 0.5872f,-0.7570f,-0.2865f, 0.4578f,-0.6916f,-0.5587f, 0.6327f,0.0797f,0.7703f, 0.7140f,-0.0769f,0.6959f, -0.5606f,-0.6649f,0.4935f, 
	0.0709f,-0.9843f,0.1616f, -0.1567f,-0.9380f,0.3091f, -0.8220f,-0.5254f,0.2195f, 0.0226f,-0.9637f,-0.2661f, 0.5015f,0.8645f,-0.0327f, 0.9412f,-0.3310f,0.0683f, 0.3963f,-0.9179f,-0.0177f, -0.1738f,0.8171f,-0.5497f, 0.3622f,0.7128f,-0.6006f, 0.0723f,0.9296f,-0.3615f, 0.6065f,0.6449f,-0.4651f, 0.7875f,0.6121f,-0.0721f, 0.8825f,0.1132f,-0.4565f, 0.9977f,0.0592f,0.0329f, 0.1718f,0.6569f,-0.7341f, 
	0.5276f,0.0381f,-0.8486f, 0.8736f,-0.4516f,-0.1815f, 0.7251f,-0.6295f,0.2793f, 0.5967f,-0.5610f,-0.5738f, 0.4624f,-0.8821f,-0.0906f, 0.1066f,-0.9535f,-0.2820f, 0.1134f,-0.6562f,-0.7460f, -0.3510f,-0.6608f,-0.6634f, -0.0176f,-0.0629f,-0.9979f, -0.5752f,0.0065f,-0.8180f, -0.3179f,0.5842f,-0.7468f, -0.1868f,-0.9330f,-0.3077f, -0.2881f,-0.9149f,0.2828f, -0.3489f,-0.8934f,-0.2831f, -0.0711f,-0.9407f,-0.3318f, 
	0.1460f,-0.9832f,-0.1092f, 0.1771f,-0.9829f,-0.0512f, 0.1979f,-0.9289f,-0.3130f, -0.7028f,-0.1007f,0.7042f, -0.5197f,-0.6728f,0.5265f, -0.9651f,0.1632f,0.2049f, -0.9569f,0.1899f,-0.2197f, -0.8625f,0.4748f,0.1752f, -0.6415f,0.2988f,-0.7065f, -0.5263f,0.7766f,-0.3464f, -0.8152f,-0.5045f,-0.2845f, -0.4309f,-0.4046f,-0.8066f, -0.8708f,-0.4262f,0.2451f, -0.1128f,0.5214f,-0.8458f, 0.2255f,0.7064f,-0.6710f, 
	0.1311f,-0.1368f,-0.9819f, 0.5417f,0.1836f,-0.8203f, 0.7099f,-0.2481f,-0.6591f, 0.3975f,-0.6152f,-0.6808f, 0.4434f,-0.8638f,-0.2391f, 0.0105f,-0.8959f,-0.4442f, -0.2878f,-0.9560f,-0.0572f, -0.4823f,-0.8127f,0.3269f, -0.9737f,0.1236f,0.1914f, -0.8329f,0.4756f,-0.2829f, -0.3891f,0.9133f,-0.1204f, -0.3508f,0.6673f,-0.6570f, -0.9201f,-0.2385f,-0.3108f, -0.4604f,-0.0953f,-0.8826f, 0.1594f,0.7180f,-0.6775f, 
	0.1628f,0.0330f,-0.9861f, 0.6111f,0.1222f,-0.7820f, 0.5016f,0.6297f,-0.5932f, 0.6314f,-0.3671f,-0.6830f, 0.2177f,-0.5806f,-0.7845f, 0.1318f,-0.9183f,-0.3733f, -0.2705f,-0.7633f,-0.5867f, -0.6351f,-0.7665f,-0.0952f, -0.5010f,-0.8440f,0.1913f, -0.8356f,0.3552f,0.4190f, 0.1571f,-0.9619f,0.2236f, 0.1571f,-0.9619f,0.2236f, 0.1571f,-0.9619f,0.2236f, -0.6712f,0.7114f,-0.2086f, -0.7381f,0.6709f,0.0720f, 
	-0.3694f,0.7197f,-0.5878f, -0.3506f,0.7973f,-0.4914f, -0.7654f,0.6411f,-0.0555f, -0.7237f,-0.3193f,0.6118f, -0.8910f,-0.0180f,-0.4536f, -0.9567f,-0.0478f,-0.2873f, 0.4487f,0.0152f,0.8936f, -0.0544f,0.2072f,0.9768f, 0.1247f,-0.1372f,0.9827f, -0.8515f,-0.4938f,-0.1762f, 0.4600f,0.3358f,0.8220f, 0.4493f,-0.3706f,-0.8129f, 0.4493f,-0.3706f,-0.8129f, 0.4493f,-0.3706f,-0.8129f, 0.5478f,0.0110f,0.8365f, 
	0.6226f,0.0505f,-0.7809f, 0.5245f,-0.7055f,-0.4766f, -0.2310f,0.2824f,0.9311f, -0.3713f,0.3000f,0.8787f, 0.7837f,-0.4214f,-0.4564f, 0.7920f,-0.4136f,-0.4491f, 0.1974f,0.6082f,-0.7689f, -0.2785f,0.9168f,0.2864f, -0.2785f,0.9168f,0.2864f, -0.2785f,0.9168f,0.2864f, 0.5902f,-0.8036f,0.0763f, -0.0359f,-0.9938f,0.1053f, 0.6578f,0.7314f,-0.1800f, 0.6550f,0.7555f,0.0168f, 0.6394f,0.7552f,0.1443f, 
	0.5945f,0.7302f,0.3368f, -0.4469f,-0.6275f,0.6375f, -0.0282f,-0.8977f,0.4397f, -0.7921f,-0.2315f,0.5648f, -0.2847f,0.7879f,-0.5460f, 0.3487f,0.5198f,-0.7798f, 0.2042f,-0.9139f,0.3507f, -0.9843f,0.0778f,0.1585f, -0.5113f,0.8529f,-0.1053f, 0.0316f,0.8823f,-0.4696f, 0.1008f,0.8154f,-0.5700f, 0.5771f,0.4493f,-0.6820f, -0.6190f,-0.7323f,-0.2839f, 0.4714f,-0.1800f,-0.8633f, 0.6418f,0.3706f,-0.6714f, 
	0.7072f,-0.3206f,-0.6302f, -0.5281f,-0.7592f,-0.3806f, 0.7695f,-0.4997f,-0.3977f, -0.1838f,-0.9128f,0.3648f, -0.4143f,-0.8947f,0.1667f, -0.2493f,-0.9646f,-0.0864f, -0.6446f,-0.6155f,0.4535f, -0.1401f,-0.9396f,0.3123f, -0.8128f,-0.3493f,0.4662f, 0.4589f,0.8183f,-0.3462f, 0.7460f,0.2444f,-0.6194f, 0.6659f,-0.3772f,-0.6437f, 0.7358f,0.1592f,-0.6582f, 0.7184f,-0.4319f,-0.5453f, 0.5378f,-0.6661f,-0.5169f, 
	-0.4428f,0.8938f,0.0709f, -0.5321f,0.8107f,0.2442f, -0.1133f,-0.9896f,-0.0891f, -0.5284f,-0.8204f,0.2183f, 0.5425f,-0.7228f,-0.4280f, -0.8214f,-0.3181f,0.4734f, -0.9795f,-0.1721f,0.1049f, -0.9562f,0.1010f,0.2746f, -0.8641f,-0.3082f,0.3980f, 0.3775f,0.8407f,-0.3882f, -0.5478f,0.8298f,0.1069f, 0.7456f,0.3475f,-0.5686f, -0.9381f,0.0127f,0.3462f, 0.5685f,-0.8132f,0.1247f, 0.8800f,0.3561f,0.3144f, 
	-0.1339f,0.9734f,-0.1860f, 0.0448f,-0.9574f,-0.2854f, -0.0892f,-0.9718f,-0.2181f, 0.1937f,-0.5914f,-0.7828f, 0.2113f,0.0062f,-0.9774f, -0.3109f,0.4095f,-0.8577f, -0.5856f,0.3138f,-0.7474f, -0.1416f,-0.0048f,-0.9899f, -0.5746f,-0.4649f,-0.6736f, -0.2665f,-0.5687f,-0.7781f, 0.3522f,0.9227f,0.1571f, 0.4862f,0.8735f,-0.0260f, -0.1315f,-0.9770f,-0.1682f, -0.7629f,0.0967f,-0.6393f, -0.6103f,-0.5778f,-0.5419f, 
	
_NULL_ }; /* End of hand_left_Normals */

const unsigned short hand_left_Faces[] = {
	0, 2, 1, 3, 2, 0, 1, 4, 0, 4, 5, 0, 5, 3, 0, 4, 7, 6, 6, 5, 4, 8, 10, 9, 9, 3, 5, 9, 5, 8, 
	11, 13, 12, 11, 15, 14, 12, 15, 11, 14, 16, 11, 13, 18, 17, 17, 20, 19, 18, 20, 17, 17, 15, 12, 19, 15, 17, 12, 13, 17, 
	20, 22, 21, 21, 22, 23, 21, 15, 19, 23, 15, 21, 19, 20, 21, 24, 16, 14, 25, 16, 24, 24, 15, 23, 14, 15, 24, 23, 22, 24, 
	26, 28, 27, 29, 28, 26, 30, 31, 26, 26, 27, 32, 26, 32, 30, 33, 35, 34, 36, 28, 29, 37, 36, 29, 38, 39, 33, 40, 32, 41, 
	30, 32, 40, 30, 40, 31, 42, 38, 33, 43, 42, 33, 44, 46, 45, 44, 48, 47, 40, 41, 48, 48, 45, 40, 44, 45, 48, 34, 43, 33, 
	37, 47, 36, 44, 47, 37, 26, 5, 29, 5, 6, 29, 26, 31, 49, 5, 26, 49, 37, 29, 7, 6, 7, 29, 40, 51, 50, 50, 49, 31, 
	31, 40, 50, 40, 45, 51, 51, 45, 46, 52, 53, 8, 8, 5, 52, 54, 56, 55, 55, 58, 57, 56, 58, 55, 55, 60, 59, 57, 60, 55, 
	59, 54, 55, 58, 62, 61, 61, 64, 63, 62, 64, 61, 61, 60, 57, 63, 60, 61, 57, 58, 61, 65, 67, 66, 66, 69, 68, 67, 69, 66, 
	66, 60, 63, 68, 60, 66, 66, 64, 65, 63, 64, 66, 70, 54, 59, 70, 60, 68, 59, 60, 70, 68, 69, 70, 71, 73, 72, 74, 73, 71, 
	72, 75, 71, 71, 46, 76, 71, 76, 74, 75, 46, 71, 77, 46, 75, 37, 7, 44, 44, 7, 78, 79, 44, 78, 46, 44, 79, 80, 82, 81, 
	81, 84, 83, 82, 84, 81, 81, 86, 85, 83, 86, 81, 81, 87, 80, 85, 87, 81, 84, 89, 88, 88, 91, 90, 89, 91, 88, 88, 86, 83, 
	90, 86, 88, 83, 84, 88, 92, 94, 93, 93, 94, 95, 93, 86, 90, 95, 86, 93, 93, 91, 92, 90, 91, 93, 96, 87, 85, 97, 87, 96, 
	96, 86, 95, 85, 86, 96, 95, 94, 96, 98, 100, 99, 99, 100, 101, 99, 103, 102, 101, 103, 99, 102, 98, 99, 104, 106, 105, 107, 106, 104, 
	104, 103, 101, 105, 103, 104, 101, 100, 104, 108, 110, 109, 109, 110, 111, 109, 103, 105, 111, 103, 109, 109, 106, 108, 105, 106, 109, 112, 98, 102, 
	113, 98, 112, 112, 103, 111, 102, 103, 112, 111, 110, 112, 114, 7, 4, 115, 117, 116, 1, 2, 118, 119, 120, 118, 118, 4, 1, 121, 122, 118, 
	122, 4, 118, 118, 120, 121, 122, 114, 4, 123, 114, 122, 124, 2, 125, 119, 2, 124, 126, 128, 127, 125, 129, 124, 126, 127, 130, 131, 133, 132, 
	130, 134, 126, 135, 73, 136, 137, 138, 127, 127, 128, 137, 139, 140, 135, 135, 136, 139, 121, 120, 141, 142, 144, 143, 136, 73, 76, 145, 136, 76, 
	146, 46, 79, 147, 149, 148, 146, 145, 76, 149, 150, 148, 146, 76, 46, 139, 136, 145, 78, 151, 79, 151, 152, 79, 78, 7, 114, 78, 114, 153, 
	153, 151, 78, 123, 151, 153, 153, 114, 123, 154, 122, 121, 154, 18, 13, 13, 122, 154, 11, 123, 122, 11, 122, 13, 154, 121, 141, 135, 155, 141, 
	155, 154, 141, 140, 155, 135, 140, 22, 20, 140, 20, 155, 155, 18, 154, 155, 20, 18, 139, 145, 140, 156, 145, 152, 140, 145, 156, 156, 25, 24, 
	24, 22, 156, 156, 22, 140, 151, 123, 152, 123, 156, 152, 123, 11, 16, 156, 16, 25, 123, 16, 156, 157, 2, 3, 158, 157, 3, 9, 10, 159, 
	159, 158, 3, 159, 3, 9, 158, 159, 160, 82, 157, 158, 161, 10, 162, 159, 10, 161, 161, 162, 163, 163, 164, 161, 163, 166, 165, 165, 164, 163, 
	163, 162, 166, 167, 164, 165, 160, 159, 161, 161, 164, 160, 165, 166, 75, 168, 73, 169, 72, 73, 168, 168, 75, 72, 167, 165, 75, 169, 73, 170, 
	169, 129, 157, 170, 129, 169, 125, 2, 157, 157, 129, 125, 168, 169, 171, 169, 157, 171, 158, 89, 84, 160, 89, 158, 158, 84, 82, 167, 94, 92, 
	92, 91, 167, 91, 164, 167, 160, 164, 91, 160, 91, 89, 172, 167, 75, 172, 75, 168, 172, 97, 96, 172, 94, 167, 96, 94, 172, 157, 173, 171, 
	171, 172, 168, 173, 172, 171, 82, 173, 157, 82, 87, 173, 80, 87, 82, 172, 87, 97, 173, 87, 172, 174, 53, 175, 53, 176, 175, 177, 174, 175, 
	176, 77, 178, 77, 179, 178, 178, 177, 175, 179, 177, 178, 175, 176, 178, 180, 10, 8, 8, 53, 174, 174, 180, 8, 181, 180, 174, 77, 75, 182, 
	182, 179, 77, 75, 166, 182, 183, 184, 182, 182, 166, 183, 184, 179, 182, 166, 162, 185, 186, 10, 180, 162, 10, 186, 186, 180, 187, 187, 185, 186, 
	185, 162, 186, 188, 185, 187, 183, 185, 188, 166, 185, 183, 189, 181, 174, 189, 107, 104, 104, 100, 189, 190, 181, 189, 189, 100, 190, 174, 177, 191, 
	191, 189, 174, 184, 191, 177, 184, 177, 179, 184, 110, 108, 108, 106, 184, 106, 191, 184, 189, 191, 106, 189, 106, 107, 113, 184, 183, 113, 110, 184, 
	112, 110, 113, 188, 113, 183, 187, 180, 181, 181, 188, 187, 192, 100, 98, 190, 100, 192, 192, 188, 181, 192, 181, 190, 113, 188, 192, 192, 98, 113, 
	50, 51, 193, 193, 194, 50, 194, 49, 50, 52, 5, 49, 52, 49, 195, 193, 51, 46, 196, 46, 77, 197, 46, 196, 193, 46, 197, 198, 77, 176, 
	176, 199, 198, 198, 196, 77, 53, 52, 199, 53, 199, 176, 200, 195, 201, 52, 195, 200, 200, 203, 202, 201, 203, 200, 202, 199, 200, 199, 52, 200, 
	204, 197, 196, 203, 197, 204, 204, 196, 198, 204, 199, 202, 198, 199, 204, 202, 203, 204, 205, 49, 194, 62, 194, 193, 58, 194, 62, 194, 56, 206, 
	206, 205, 194, 194, 58, 56, 193, 197, 62, 207, 62, 197, 207, 67, 65, 65, 64, 207, 64, 62, 207, 207, 197, 203, 208, 70, 69, 208, 203, 201, 
	209, 67, 207, 209, 207, 203, 209, 203, 208, 209, 69, 67, 208, 69, 209, 195, 49, 205, 206, 56, 54, 54, 195, 206, 195, 205, 206, 70, 201, 195, 
	208, 201, 70, 70, 195, 54, 
_NULL_ }; /* End of hand_left_Faces */


/* MESH 2 */

#define hand_right_NumVertex  212
#define hand_right_NumFaces   362
#define hand_right_NumStrips  0
#define hand_right_Flags      0x00020006
#define hand_right_Material   0

const float hand_right_Vertices[] = {
	118.7702f,233.5575f,-83.5522f, 117.8564f,237.9803f,-81.2005f, 114.6196f,237.2558f,-80.8892f, 114.4012f,234.9257f,-84.7314f, 125.6987f,240.5883f,-73.6310f, 
	79.1796f,255.7348f,-51.4181f, 120.9798f,250.9680f,-54.5781f, 102.1505f,260.6676f,-47.1899f, 101.5354f,234.7255f,-85.6237f, 103.0971f,236.8864f,-84.2385f, 
	98.8955f,236.4623f,-84.9447f, 131.1256f,202.6893f,-101.4750f, 133.7046f,198.1007f,-101.7231f, 135.6332f,199.0695f,-99.1912f, 133.0764f,195.8915f,-100.9829f, 
	135.1918f,196.9740f,-98.4214f, 136.2218f,200.1610f,-94.5204f, 128.2881f,201.6057f,-101.6497f, 131.0706f,198.9195f,-102.5456f, 127.4409f,199.8144f,-101.0234f, 
	130.3362f,196.8647f,-101.9329f, 128.0092f,198.5898f,-95.9464f, 129.3846f,196.7121f,-99.5774f, 131.8234f,195.7380f,-98.6312f, 133.7914f,196.8459f,-96.3612f, 
	134.7453f,199.8949f,-92.8280f, 90.8203f,269.7990f,-28.1630f, 75.6183f,264.0902f,-31.0558f, 78.6180f,261.4218f,-35.0561f, 95.7463f,266.2266f,-31.9801f, 
	76.4172f,254.5232f,-36.7386f, 74.4199f,255.6294f,-33.5339f, 73.5508f,257.3391f,-28.3156f, 90.8203f,269.7990f,-28.1630f, 105.8021f,265.9652f,-20.2874f, 
	75.6183f,264.0902f,-31.0558f, 105.8021f,265.9652f,-20.2874f, 106.4983f,260.4426f,-25.9428f, 73.5508f,257.3391f,-28.3156f, 78.7243f,248.7551f,-22.3233f, 
	78.7243f,248.7551f,-22.3233f, 81.0588f,246.6311f,-32.6678f, 88.7005f,246.5367f,-19.2023f, 88.7005f,246.5367f,-19.2023f, 109.0258f,253.8138f,-17.1937f, 
	116.9043f,235.5276f,-46.3050f, 102.8002f,245.0500f,-30.3289f, 107.6689f,251.8727f,-25.0427f, 88.7005f,246.5367f,-19.2023f, 109.0258f,253.8138f,-17.1937f, 
	88.7005f,246.5367f,-19.2023f, 68.2957f,246.6776f,-53.9427f, 81.9582f,238.4012f,-42.3660f, 72.6849f,244.5924f,-44.1085f, 83.5785f,233.8739f,-76.9846f, 
	73.0281f,235.8674f,-68.5607f, 44.1502f,232.3787f,-70.2785f, 43.1739f,229.9769f,-73.3746f, 45.4162f,232.6391f,-73.0650f, 43.5114f,230.3763f,-69.3011f, 
	42.4250f,227.6691f,-72.5527f, 43.2322f,225.3595f,-75.1835f, 43.9387f,227.9584f,-75.8720f, 48.9073f,228.2916f,-64.6100f, 43.4478f,225.7887f,-71.0905f, 
	46.8015f,222.7964f,-71.0134f, 44.1773f,223.5202f,-73.4840f, 50.0958f,222.0485f,-75.4673f, 46.4775f,222.2706f,-75.1104f, 48.8298f,221.7881f,-72.6808f, 
	49.5354f,223.3699f,-77.0368f, 45.6911f,223.8096f,-76.8034f, 46.2420f,226.3509f,-77.2335f, 111.2169f,229.9935f,-73.7463f, 110.7500f,225.7462f,-73.1366f, 
	113.4649f,228.1205f,-70.5106f, 119.0336f,228.2367f,-72.9094f, 102.6830f,226.6351f,-72.5176f, 118.1762f,230.1435f,-66.9348f, 84.7297f,226.0075f,-72.4893f, 
	129.8912f,237.7708f,-63.2541f, 129.1747f,234.8768f,-63.0009f, 117.4339f,207.2924f,-112.2367f, 116.2362f,199.5677f,-118.5727f, 117.9124f,201.6611f,-115.4426f, 
	113.8984f,202.8202f,-118.7831f, 113.7897f,199.0630f,-120.0771f, 113.3455f,196.7068f,-119.2811f, 116.1015f,197.3047f,-117.8352f, 117.9922f,199.5976f,-114.6262f, 
	108.5024f,202.2373f,-117.3437f, 111.0123f,199.9084f,-119.6090f, 107.5055f,200.3918f,-116.4649f, 110.2900f,197.7589f,-118.8524f, 108.9815f,198.2253f,-112.1283f, 
	109.7362f,197.1202f,-116.2534f, 107.0774f,199.7130f,-114.0424f, 112.6018f,196.0007f,-116.6105f, 115.2349f,196.6368f,-115.4112f, 117.0541f,198.8423f,-112.5415f, 
	97.0825f,216.1646f,-122.6933f, 97.3322f,213.2648f,-124.7464f, 99.1345f,214.8273f,-121.8347f, 94.9481f,212.5831f,-125.6396f, 94.8075f,210.2000f,-125.5983f, 
	97.3644f,210.9913f,-124.6513f, 89.6150f,211.3827f,-120.9714f, 92.0755f,210.3366f,-124.3582f, 92.3545f,212.5293f,-124.3507f, 89.9973f,213.3466f,-121.0808f, 
	91.8254f,208.8145f,-118.4002f, 92.0021f,209.0263f,-122.3276f, 89.7735f,210.1518f,-119.2588f, 94.4919f,208.7448f,-123.3699f, 96.8619f,209.5820f,-122.4776f, 
	97.9991f,211.8917f,-112.7188f, 130.1497f,237.7575f,-70.6152f, 118.7702f,233.5575f,-83.5522f, 117.9913f,234.0869f,-82.7683f, 120.7075f,235.7931f,-81.1280f, 
	120.7075f,235.7931f,-81.1280f, 119.7219f,232.2572f,-82.9230f, 117.9913f,234.0869f,-82.7683f, 126.5571f,231.7571f,-80.9307f, 121.0010f,229.5913f,-84.2602f, 
	135.7057f,205.5014f,-89.5517f, 119.2383f,230.4808f,-83.0563f, 120.9217f,230.5657f,-82.0684f, 118.8274f,227.9549f,-81.3798f, 116.2511f,228.9290f,-80.6634f, 
	120.9217f,230.5657f,-82.0684f, 118.8274f,227.9549f,-81.3798f, 117.6281f,230.5832f,-82.4487f, 119.7219f,232.2572f,-82.9230f, 117.9913f,234.0869f,-82.7683f, 
	120.9217f,230.5657f,-82.0684f, 119.7219f,232.2572f,-82.9230f, 114.1730f,228.6005f,-74.0838f, 116.2511f,228.9290f,-80.6634f, 111.2169f,229.9935f,-73.7463f, 
	117.8997f,225.9550f,-78.9052f, 124.5991f,203.4741f,-93.2772f, 117.2170f,224.1584f,-76.5777f, 117.6281f,230.5832f,-82.4487f, 111.2169f,229.9935f,-73.7463f, 
	119.0336f,228.2367f,-72.9094f, 118.1762f,230.1435f,-66.9348f, 119.5760f,227.2979f,-68.8979f, 125.9149f,230.2177f,-66.6708f, 125.1235f,229.4429f,-65.6362f, 
	125.9149f,230.2177f,-66.6708f, 129.1747f,234.8768f,-63.0009f, 119.5760f,227.2979f,-68.8979f, 129.6767f,229.5774f,-70.0646f, 125.1235f,229.4429f,-65.6362f, 
	130.4625f,234.0581f,-69.6470f, 127.6000f,207.6809f,-99.1702f, 123.8220f,212.0889f,-95.1685f, 132.0719f,204.1357f,-87.3974f, 116.7131f,227.6643f,-86.9639f, 
	111.2639f,228.0098f,-94.7973f, 103.1261f,231.9649f,-89.8404f, 105.8944f,226.8448f,-94.5740f, 99.1408f,229.9920f,-83.0577f, 100.9207f,230.2619f,-88.5008f, 
	100.6121f,229.3258f,-83.0415f, 101.6709f,223.8541f,-90.4692f, 97.4800f,226.3628f,-78.3528f, 99.5899f,225.1462f,-80.4219f, 105.6636f,202.5808f,-107.5470f, 
	116.5096f,225.1432f,-80.4949f, 113.0443f,219.5011f,-84.4598f, 117.8997f,225.9550f,-78.9052f, 115.0893f,221.0282f,-85.9631f, 115.6520f,201.5939f,-106.3775f, 
	118.4515f,203.6304f,-109.7657f, 82.1547f,226.1979f,-83.7063f, 84.4035f,230.5117f,-85.4332f, 82.8614f,226.7037f,-74.9046f, 83.4860f,224.8456f,-86.4758f, 
	82.4490f,224.6552f,-82.3437f, 83.9063f,223.2568f,-85.2543f, 98.1518f,233.1499f,-90.7385f, 98.5070f,226.0751f,-105.3207f, 94.5482f,224.0209f,-79.7490f, 
	89.2987f,210.7489f,-112.8164f, 96.8118f,222.2976f,-87.5998f, 99.9829f,230.0122f,-85.8017f, 100.2608f,232.6338f,-87.4433f, 99.3455f,231.5157f,-89.5487f, 
	99.2872f,227.4701f,-91.0061f, 89.6203f,217.1304f,-116.5234f, 98.8950f,219.1494f,-117.6229f, 87.1465f,217.8672f,-109.7273f, 99.9829f,217.5235f,-117.0685f, 
	66.9724f,234.8944f,-53.3809f, 51.2967f,237.9298f,-63.8447f, 53.2266f,238.4908f,-68.2202f, 80.2164f,228.3495f,-64.3488f, 70.5146f,227.5569f,-65.3425f, 
	78.3419f,228.8646f,-69.2049f, 78.2959f,230.3887f,-70.6594f, 70.4859f,232.5624f,-69.3079f, 74.4926f,233.0344f,-69.3835f, 71.1818f,228.4037f,-67.4619f, 
	75.2157f,230.7094f,-69.0292f, 75.2039f,229.0874f,-67.6173f, 56.7310f,241.5767f,-62.5410f, 47.9890f,236.1812f,-68.8390f, 54.5100f,222.2180f,-72.0486f, 
	54.4990f,224.3912f,-75.5083f, 54.7797f,222.8627f,-74.0521f, 
_NULL_ }; /* End of hand_right_Vertices */

const float hand_right_UV[] = {
	0.7237f,0.1859f,0.7116f,0.1968f,0.7067f,0.1967f,0.7069f,0.1850f,0.7309f,0.2170f,0.5025f,0.2879f,0.7231f,0.2735f,0.6476f,0.3029f,0.6584f,0.1832f,0.6612f,0.1889f,0.6398f,0.1869f,0.8060f,0.1065f,0.8188f,0.1002f,0.8191f,0.1071f,0.8267f,0.0991f,
	0.8264f,0.1063f,0.8229f,0.1191f,0.8097f,0.1048f,0.8159f,0.0994f,0.8171f,0.1041f,0.8237f,0.0983f,0.8299f,0.1141f,0.8288f,0.1035f,0.8317f,0.1044f,0.8307f,0.1109f,0.8269f,0.1227f,0.5879f,0.3580f,0.4735f,0.3448f,0.4931f,0.3323f,0.6223f,0.3447f,
	0.4532f,0.3200f,0.4349f,0.3288f,0.4229f,0.3428f,0.5879f,0.3580f,0.6977f,0.3708f,0.4735f,0.3448f,0.6977f,0.3708f,0.7111f,0.3511f,0.4229f,0.3428f,0.3277f,0.3457f,0.3277f,0.3457f,0.4204f,0.3194f,-0.1045f,0.3498f,0.8955f,0.3498f,0.7787f,0.3628f,
	0.7951f,0.2735f,0.7841f,0.3221f,0.7633f,0.3425f,0.8955f,0.3498f,0.7787f,0.3628f,-0.1045f,0.3498f,0.4097f,0.2713f,0.3647f,0.2871f,0.3868f,0.2910f,0.5221f,0.2024f,0.4179f,0.2244f,0.3358f,0.2171f,0.3327f,0.2071f,0.3426f,0.2110f,0.3273f,0.2168f,
	0.3236f,0.2061f,0.3212f,0.1972f,0.3311f,0.1988f,0.3141f,0.2248f,0.3155f,0.2071f,0.3061f,0.2035f,0.3126f,0.1988f,0.3131f,0.1923f,0.3120f,0.1935f,0.3060f,0.1983f,0.3211f,0.1903f,0.3202f,0.1915f,0.3299f,0.1937f,0.7445f,0.2041f,0.7674f,0.2003f,
	0.7659f,0.2091f,0.7658f,0.2036f,0.7482f,0.2031f,0.7705f,0.2197f,0.5087f,0.2029f,0.7610f,0.2371f,0.7697f,0.2342f,0.7621f,0.0880f,0.7801f,0.0640f,0.7794f,0.0737f,0.7617f,0.0676f,0.7767f,0.0601f,0.7908f,0.0590f,0.7926f,0.0629f,0.7905f,0.0730f,
	0.7609f,0.0704f,0.7708f,0.0623f,0.7740f,0.0701f,0.7848f,0.0613f,0.8038f,0.0773f,0.7968f,0.0665f,0.7869f,0.0748f,0.8022f,0.0642f,0.8020f,0.0677f,0.7989f,0.0769f,0.6257f,0.0757f,0.6324f,0.0674f,0.6438f,0.0760f,0.6167f,0.0646f,0.6230f,0.0618f,
	0.6407f,0.0649f,0.5805f,0.0740f,0.6018f,0.0649f,0.5989f,0.0676f,0.5809f,0.0761f,0.6160f,0.0766f,0.6085f,0.0679f,0.5866f,0.0764f,0.6305f,0.0651f,0.6480f,0.0681f,0.6727f,0.0932f,0.7495f,0.2203f,0.7237f,0.1859f,0.7218f,0.1884f,0.7245f,0.1942f,
	0.7245f,0.1942f,0.7311f,0.1857f,0.7218f,0.1884f,0.7465f,0.1894f,0.7400f,0.1793f,0.8157f,0.1370f,0.7363f,0.1832f,0.7406f,0.1855f,0.7484f,0.1840f,0.7419f,0.1869f,0.7406f,0.1855f,0.7484f,0.1840f,0.7342f,0.1848f,0.7311f,0.1857f,0.7218f,0.1884f,
	0.7406f,0.1855f,0.7311f,0.1857f,0.7554f,0.2016f,0.7419f,0.1869f,0.7445f,0.2041f,0.7605f,0.1872f,0.8202f,0.1264f,0.7728f,0.1903f,0.7342f,0.1848f,0.7445f,0.2041f,0.7658f,0.2036f,0.7705f,0.2197f,0.7789f,0.2116f,0.7763f,0.2201f,0.7806f,0.2215f,
	0.7763f,0.2201f,0.7697f,0.2342f,0.7789f,0.2116f,0.7746f,0.2115f,0.7806f,0.2215f,0.7622f,0.2179f,0.7937f,0.1180f,0.7848f,0.1327f,0.8245f,0.1404f,0.7342f,0.1709f,0.7031f,0.1536f,0.6677f,0.1701f,0.6896f,0.1529f,0.6715f,0.1832f,0.6663f,0.1711f,
	0.6835f,0.1824f,0.6966f,0.1587f,0.7010f,0.1896f,0.7140f,0.1833f,0.7907f,0.0933f,0.7585f,0.1826f,0.7706f,0.1667f,0.7605f,0.1872f,0.7617f,0.1650f,0.8017f,0.0944f,0.7846f,0.0891f,0.4919f,0.1776f,0.5314f,0.1789f,0.4795f,0.1983f,0.5101f,0.1696f,
	0.4844f,0.1788f,0.5087f,0.1704f,0.6356f,0.1696f,0.6341f,0.1276f,0.6922f,0.1836f,0.5893f,0.0918f,0.6880f,0.1634f,0.6689f,0.1770f,0.6557f,0.1765f,0.6503f,0.1703f,0.6631f,0.1620f,0.5764f,0.0912f,0.6362f,0.0909f,0.5566f,0.1077f,0.6486f,0.0902f,
	0.3313f,0.2581f,0.3507f,0.2384f,0.3643f,0.2290f,0.3813f,0.2245f,0.3305f,0.2216f,0.4054f,0.2141f,0.4279f,0.2127f,0.3859f,0.2187f,0.4118f,0.2190f,0.3494f,0.2178f,0.3969f,0.2169f,0.3741f,0.2181f,0.3712f,0.2457f,0.3496f,0.2249f,0.3075f,0.2001f,
	0.3252f,0.1949f,0.3153f,0.1964f,
_NULL_ }; /* End of hand_right_UV */

const float hand_right_Normals[] = {
	0.6114f,0.5621f,-0.5570f, 0.0090f,0.7936f,-0.6083f, 0.0207f,0.8387f,-0.5442f, 0.3005f,0.7276f,-0.6167f, 0.4388f,0.7519f,-0.4921f, -0.3288f,0.8218f,-0.4653f, 0.6903f,0.7234f,-0.0142f, 0.1379f,0.9079f,-0.3958f, -0.0367f,0.6192f,-0.7844f, 0.0459f,0.8101f,-0.5845f, -0.0671f,0.8178f,-0.5716f, 0.3329f,0.4327f,-0.8378f, 0.5889f,-0.0864f,-0.8036f, 0.9021f,0.0695f,-0.4259f, 0.3145f,-0.8175f,-0.4825f, 
	0.7485f,-0.6609f,-0.0541f, 0.9501f,-0.2419f,0.1972f, -0.4062f,0.1633f,-0.8991f, 0.0186f,-0.0209f,-0.9996f, -0.7820f,-0.3005f,-0.5461f, -0.3120f,-0.6336f,-0.7080f, -0.5815f,-0.7410f,0.3359f, -0.5944f,-0.8019f,-0.0602f, -0.0909f,-0.9792f,0.1815f, 0.2348f,-0.8547f,0.4630f, 0.4757f,-0.6156f,0.6283f, 0.0913f,0.7988f,-0.5946f, -0.5774f,0.4097f,-0.7062f, -0.5390f,0.6957f,-0.4749f, 0.2223f,0.8955f,-0.3855f, 
	-0.9944f,-0.0387f,0.0984f, -0.9502f,-0.0856f,-0.2996f, -0.9514f,-0.1960f,-0.2373f, -0.3255f,0.4435f,0.8351f, -0.3403f,0.1908f,0.9207f, -0.2657f,0.3923f,0.8806f, 0.7759f,0.5331f,-0.3373f, 0.8581f,0.5025f,-0.1053f, -0.2759f,0.4328f,0.8582f, -0.1832f,0.4582f,0.8698f, -0.5529f,-0.8320f,0.0460f, -0.5335f,-0.7710f,0.3477f, -0.2185f,0.4290f,0.8765f, -0.2185f,0.4290f,0.8765f, -0.3004f,0.2609f,0.9174f, 
	0.4173f,-0.7336f,0.5364f, 0.1573f,-0.8231f,0.5458f, 0.8153f,-0.4334f,0.3840f, 0.0027f,-0.9842f,0.1772f, 0.9000f,-0.4357f,-0.0106f, 0.0027f,-0.9842f,0.1772f, -0.5841f,0.8018f,-0.1262f, -0.2199f,-0.8174f,0.5324f, -0.7469f,-0.2160f,0.6289f, -0.6966f,0.4207f,-0.5812f, -0.2180f,0.5043f,-0.8355f, -0.8157f,0.5734f,0.0768f, -0.8397f,0.4297f,-0.3320f, -0.3657f,0.6992f,-0.6144f, -0.8706f,0.1271f,0.4753f, 
	-0.9994f,-0.0332f,0.0133f, -0.8542f,-0.2850f,-0.4350f, -0.5815f,0.3033f,-0.7549f, -0.4169f,-0.4128f,0.8098f, -0.7828f,-0.4330f,0.4469f, -0.3163f,-0.8110f,0.4921f, -0.7012f,-0.7113f,0.0489f, 0.1058f,-0.8958f,-0.4316f, -0.3405f,-0.8980f,-0.2787f, -0.0799f,-0.9764f,0.2005f, 0.1335f,-0.3671f,-0.9206f, -0.4278f,-0.4711f,-0.7714f, -0.1461f,0.2026f,-0.9683f, 0.3110f,-0.9496f,-0.0395f, 0.5174f,-0.7313f,0.4444f, 
	0.1632f,-0.9860f,0.0333f, 0.0518f,-0.9961f,0.0721f, -0.0316f,-0.9296f,0.3672f, -0.0328f,-0.9034f,0.4275f, -0.1778f,-0.9615f,0.2097f, 0.9520f,0.1578f,0.2624f, 0.7955f,-0.4245f,0.4325f, 0.7668f,0.4521f,-0.4556f, 0.7130f,0.0242f,-0.7007f, 0.9168f,0.1752f,-0.3590f, 0.1900f,0.5306f,-0.8261f, 0.1989f,-0.0594f,-0.9782f, 0.0730f,-0.7271f,-0.6826f, 0.6623f,-0.6249f,-0.4134f, 0.9397f,-0.3379f,-0.0523f, 
	-0.6074f,0.3776f,-0.6989f, -0.3620f,0.1169f,-0.9248f, -0.8753f,-0.1402f,-0.4628f, -0.5402f,-0.5227f,-0.6595f, -0.3697f,-0.8571f,0.3588f, -0.5667f,-0.8167f,-0.1088f, -0.8859f,-0.4556f,-0.0872f, -0.0775f,-0.9970f,0.0044f, 0.3691f,-0.9093f,0.1922f, 0.6929f,-0.6319f,0.3473f, 0.1516f,0.7565f,-0.6362f, 0.5330f,0.2651f,-0.8035f, 0.9241f,0.1331f,-0.3583f, -0.0889f,0.3133f,-0.9455f, 0.0185f,-0.4793f,-0.8774f, 
	0.7030f,-0.4003f,-0.5878f, -0.9099f,-0.1759f,-0.3757f, -0.5952f,-0.3683f,-0.7142f, -0.5541f,0.3814f,-0.7399f, -0.8034f,0.3566f,-0.4768f, -0.1486f,-0.9808f,0.1266f, -0.4608f,-0.8390f,-0.2893f, -0.8101f,-0.5783f,-0.0967f, 0.0851f,-0.9524f,-0.2929f, 0.6289f,-0.7738f,-0.0763f, 0.6525f,-0.7176f,0.2437f, 0.8716f,0.4459f,-0.2037f, 0.1063f,-0.7719f,0.6268f, 0.1063f,-0.7719f,0.6268f, 0.1063f,-0.7719f,0.6268f, 
	0.3895f,0.5197f,-0.7604f, -0.0490f,0.3884f,-0.9202f, 0.5816f,0.5950f,-0.5548f, 0.5522f,0.5136f,-0.6568f, -0.0333f,0.4999f,-0.8655f, 0.9609f,-0.0803f,0.2650f, 0.7175f,-0.2196f,-0.6611f, 0.5800f,-0.2574f,-0.7729f, 0.3565f,0.2895f,0.8883f, 0.4600f,0.5891f,0.6643f, 0.0087f,0.4105f,0.9118f, 0.7418f,-0.5725f,-0.3493f, -0.0813f,0.6728f,0.7354f, -0.7085f,-0.6461f,-0.2841f, -0.7085f,-0.6461f,-0.2841f, 
	-0.7085f,-0.6461f,-0.2841f, -0.1036f,0.3890f,0.9154f, -0.5722f,-0.8067f,0.1479f, -0.9088f,-0.2399f,-0.3413f, 0.6802f,0.6139f,0.4006f, 0.5833f,0.6279f,0.5152f, -0.8382f,-0.5140f,0.1821f, -0.8330f,-0.5246f,0.1755f, -0.6125f,0.2462f,-0.7511f, 0.2383f,0.9346f,-0.2641f, 0.2383f,0.9346f,-0.2641f, 0.2383f,0.9346f,-0.2641f, -0.3646f,-0.6631f,0.6537f, 0.2270f,-0.8614f,0.4545f, -0.6086f,0.7841f,0.1215f, 
	-0.6802f,0.7325f,0.0282f, -0.7684f,0.6293f,-0.1165f, -0.4782f,0.8383f,0.2620f, 0.7752f,-0.3330f,0.5369f, 0.3576f,-0.6352f,0.6846f, 0.9866f,-0.0241f,0.1612f, -0.1145f,0.4727f,-0.8737f, -0.7374f,0.1704f,-0.6536f, 0.1154f,-0.6729f,0.7307f, 0.9253f,0.0773f,-0.3714f, 0.2748f,0.7006f,-0.6586f, -0.3719f,0.6091f,-0.7006f, -0.4683f,0.5109f,-0.7209f, 0.5240f,-0.8198f,-0.2310f, -0.8832f,0.1605f,-0.4407f, 
	-0.7791f,-0.4925f,-0.3879f, -0.9236f,0.0973f,-0.3709f, 0.4042f,-0.8787f,-0.2538f, -0.8596f,-0.5096f,-0.0373f, -0.7823f,-0.5724f,0.2457f, 0.5727f,-0.7686f,0.2851f, 0.4626f,-0.6892f,0.5576f, 0.3232f,-0.9269f,0.1907f, 0.8636f,-0.4101f,0.2933f, 0.4044f,-0.7327f,0.5474f, 0.9776f,-0.1731f,0.1197f, -0.9728f,0.0104f,-0.2313f, -0.6818f,0.6276f,-0.3758f, -0.8210f,-0.5691f,-0.0454f, -0.9688f,-0.0836f,-0.2334f, 
	-0.8144f,-0.5750f,0.0785f, -0.6080f,-0.7867f,0.1069f, 0.2884f,0.8147f,-0.5030f, 0.4579f,0.8056f,-0.3760f, 0.2062f,-0.9426f,0.2627f, -0.5634f,-0.8012f,0.2015f, 0.6853f,-0.6866f,0.2428f, 0.9838f,-0.1423f,0.1090f, 0.9339f,-0.1716f,-0.3137f, 0.9498f,0.1481f,-0.2755f, 0.9856f,-0.1670f,0.0254f, -0.6327f,0.6257f,-0.4562f, 0.4065f,0.7652f,-0.4993f, -0.9647f,0.1251f,-0.2317f, 0.9795f,0.0986f,-0.1759f, 
	-0.3222f,-0.6530f,0.6854f, -0.6836f,0.5063f,0.5256f, -0.1113f,0.7992f,-0.5907f, -0.0265f,-0.9851f,0.1700f, 0.1239f,-0.9784f,0.1654f, -0.4373f,-0.8495f,-0.2950f, -0.6299f,-0.3861f,-0.6739f, 0.1290f,-0.0593f,-0.9899f, -0.1766f,-0.0016f,-0.9843f, 0.2686f,-0.7354f,-0.6221f, -0.3238f,-0.4224f,-0.8466f, -0.0342f,-0.8546f,-0.5182f, -0.3754f,0.9242f,-0.0698f, -0.5688f,0.8119f,-0.1317f, 0.1844f,-0.9649f,0.1868f, 
	0.3661f,-0.2224f,-0.9036f, 0.3764f,-0.7857f,-0.4909f, 
_NULL_ }; /* End of hand_right_Normals */

const unsigned short hand_right_Faces[] = {
	0, 2, 1, 0, 3, 2, 4, 1, 2, 5, 4, 2, 3, 5, 2, 6, 4, 7, 5, 7, 4, 8, 10, 9, 3, 9, 5, 5, 9, 10, 
	11, 13, 12, 14, 13, 15, 14, 12, 13, 16, 15, 13, 17, 11, 18, 19, 18, 20, 19, 17, 18, 14, 18, 12, 14, 20, 18, 11, 12, 18, 
	21, 19, 22, 21, 22, 23, 14, 22, 20, 14, 23, 22, 19, 20, 22, 16, 24, 15, 16, 25, 24, 14, 24, 23, 14, 15, 24, 21, 23, 24, 
	26, 28, 27, 26, 29, 28, 30, 31, 28, 27, 28, 32, 32, 28, 31, 33, 35, 34, 26, 36, 29, 36, 37, 29, 38, 39, 35, 32, 41, 40, 
	32, 31, 41, 41, 31, 30, 39, 42, 35, 43, 44, 35, 45, 47, 46, 48, 47, 49, 40, 41, 50, 46, 48, 41, 46, 47, 48, 44, 34, 35, 
	49, 37, 36, 49, 47, 37, 5, 28, 29, 7, 5, 29, 30, 28, 51, 28, 5, 51, 29, 37, 6, 6, 7, 29, 52, 41, 53, 51, 53, 30, 
	41, 30, 53, 46, 41, 52, 46, 52, 45, 54, 55, 10, 5, 10, 55, 56, 58, 57, 59, 57, 60, 59, 56, 57, 61, 57, 62, 61, 60, 57, 
	58, 62, 57, 63, 59, 64, 65, 64, 66, 65, 63, 64, 61, 64, 60, 61, 66, 64, 59, 60, 64, 67, 69, 68, 70, 68, 71, 70, 67, 68, 
	61, 68, 66, 61, 71, 68, 65, 68, 69, 65, 66, 68, 58, 72, 62, 61, 72, 71, 61, 62, 72, 70, 71, 72, 73, 75, 74, 73, 76, 75, 
	77, 74, 75, 45, 75, 78, 78, 75, 76, 45, 77, 75, 45, 79, 77, 6, 37, 47, 6, 47, 80, 47, 81, 80, 47, 45, 81, 82, 84, 83, 
	85, 83, 86, 85, 82, 83, 87, 83, 88, 87, 86, 83, 89, 83, 84, 89, 88, 83, 90, 85, 91, 92, 91, 93, 92, 90, 91, 87, 91, 86, 
	87, 93, 91, 85, 86, 91, 94, 96, 95, 94, 95, 97, 87, 95, 93, 87, 97, 95, 92, 95, 96, 92, 93, 95, 89, 98, 88, 89, 99, 98, 
	87, 98, 97, 87, 88, 98, 94, 97, 98, 100, 102, 101, 100, 101, 103, 104, 101, 105, 104, 103, 101, 102, 105, 101, 106, 108, 107, 106, 109, 108, 
	104, 108, 103, 104, 107, 108, 100, 103, 108, 110, 112, 111, 110, 111, 113, 104, 111, 107, 104, 113, 111, 106, 111, 112, 106, 107, 111, 102, 114, 105, 
	102, 115, 114, 104, 114, 113, 104, 105, 114, 110, 113, 114, 6, 116, 4, 117, 119, 118, 0, 1, 120, 121, 122, 120, 4, 120, 1, 123, 124, 120, 
	4, 123, 120, 121, 120, 124, 116, 123, 4, 116, 125, 123, 0, 127, 126, 0, 122, 127, 128, 130, 129, 131, 126, 127, 129, 130, 132, 133, 135, 134, 
	136, 132, 130, 73, 138, 137, 139, 140, 129, 128, 129, 140, 141, 142, 138, 137, 138, 142, 121, 124, 143, 144, 146, 145, 73, 137, 78, 137, 147, 78, 
	45, 148, 81, 149, 151, 150, 147, 148, 78, 152, 149, 150, 78, 148, 45, 137, 142, 147, 153, 80, 81, 154, 153, 81, 6, 80, 116, 116, 80, 155, 
	153, 155, 80, 153, 125, 155, 116, 155, 125, 123, 156, 124, 17, 156, 11, 123, 11, 156, 125, 13, 123, 123, 13, 11, 124, 156, 143, 157, 138, 143, 
	156, 157, 143, 157, 141, 138, 21, 141, 19, 19, 141, 157, 17, 157, 156, 19, 157, 17, 147, 142, 141, 147, 158, 154, 147, 141, 158, 25, 158, 24, 
	21, 24, 158, 21, 158, 141, 125, 153, 154, 158, 125, 154, 13, 125, 16, 16, 158, 25, 16, 125, 158, 0, 159, 3, 159, 160, 3, 8, 9, 161, 
	160, 161, 3, 3, 161, 9, 161, 160, 162, 159, 82, 160, 8, 164, 163, 8, 161, 164, 163, 164, 165, 166, 165, 164, 167, 165, 168, 166, 168, 165, 
	163, 165, 167, 166, 169, 168, 161, 162, 164, 166, 164, 162, 167, 168, 77, 73, 171, 170, 73, 74, 171, 77, 171, 74, 168, 169, 77, 73, 170, 172, 
	131, 170, 159, 131, 172, 170, 0, 126, 159, 131, 159, 126, 170, 171, 173, 159, 170, 173, 90, 160, 85, 90, 162, 160, 85, 160, 82, 94, 169, 96, 
	92, 96, 169, 166, 92, 169, 166, 162, 92, 92, 162, 90, 169, 174, 77, 77, 174, 171, 99, 174, 98, 94, 174, 169, 94, 98, 174, 175, 159, 173, 
	174, 173, 171, 174, 175, 173, 175, 82, 159, 89, 82, 175, 89, 84, 82, 89, 174, 99, 89, 175, 174, 54, 177, 176, 178, 54, 176, 177, 179, 176, 
	79, 178, 180, 181, 79, 180, 179, 180, 176, 179, 181, 180, 178, 176, 180, 8, 182, 10, 54, 10, 177, 182, 177, 10, 182, 183, 177, 77, 79, 184, 
	181, 184, 79, 167, 77, 184, 185, 186, 184, 167, 184, 186, 181, 185, 184, 163, 167, 187, 8, 188, 182, 8, 163, 188, 182, 188, 189, 187, 189, 188, 
	163, 187, 188, 187, 190, 189, 187, 186, 190, 187, 167, 186, 183, 191, 177, 109, 191, 108, 100, 108, 191, 183, 192, 191, 100, 191, 192, 179, 177, 193, 
	191, 193, 177, 193, 185, 179, 179, 185, 181, 110, 185, 112, 106, 112, 185, 193, 106, 185, 193, 191, 106, 106, 191, 109, 185, 115, 186, 110, 115, 185, 
	110, 114, 115, 115, 190, 186, 182, 189, 183, 190, 183, 189, 100, 194, 102, 100, 192, 194, 190, 194, 183, 183, 194, 192, 190, 115, 194, 102, 194, 115, 
	52, 53, 195, 196, 195, 53, 51, 196, 53, 5, 55, 51, 51, 55, 197, 52, 195, 45, 45, 198, 79, 45, 199, 198, 45, 195, 199, 79, 200, 178, 
	201, 178, 200, 198, 200, 79, 55, 54, 201, 201, 54, 178, 197, 203, 202, 197, 55, 203, 204, 203, 205, 204, 202, 203, 201, 205, 203, 55, 201, 203, 
	199, 206, 198, 199, 204, 206, 198, 206, 200, 201, 206, 205, 201, 200, 206, 204, 205, 206, 51, 207, 196, 196, 63, 195, 196, 59, 63, 56, 196, 208, 
	207, 208, 196, 59, 196, 56, 199, 195, 63, 63, 209, 199, 67, 209, 69, 65, 69, 209, 63, 65, 209, 199, 209, 204, 72, 210, 70, 204, 210, 202, 
	67, 211, 209, 209, 211, 204, 204, 211, 210, 70, 211, 67, 70, 210, 211, 51, 197, 207, 56, 208, 58, 197, 58, 208, 207, 197, 208, 202, 72, 197, 
	202, 210, 72, 197, 72, 58, 
_NULL_ }; /* End of hand_right_Faces */


/* MESH 3 */

#define body_NumVertex  189
#define body_NumFaces   332
#define body_NumStrips  0
#define body_Flags      0x00020006
#define body_Material   0

const float body_Vertices[] = {
	141.2572f,200.4930f,12.9589f, 136.9475f,176.0694f,-2.4809f, 148.1041f,174.0248f,12.8092f, 129.3692f,203.0156f,-0.2324f, 122.0882f,178.9550f,-14.0714f, 
	131.9648f,225.6155f,15.8087f, 113.4336f,206.3407f,-9.6319f, 104.6575f,182.4619f,-21.0799f, 118.9834f,228.6844f,4.9173f, 121.5915f,247.3293f,20.4177f, 
	94.5845f,209.7327f,-13.9246f, 85.9821f,186.3230f,-22.9731f, 101.7491f,231.5973f,-1.5955f, 107.2088f,250.1767f,12.1333f, 110.9516f,263.9673f,25.9442f, 
	151.3335f,189.1228f,28.9181f, 142.8235f,216.3990f,28.9338f, 149.7670f,204.0359f,44.6218f, 131.8207f,242.2603f,31.7025f, 139.5753f,232.0063f,44.5562f, 
	144.2607f,217.4783f,58.8940f, 119.6263f,263.5050f,36.2011f, 126.7306f,257.0551f,47.0526f, 132.2192f,245.0243f,58.7182f, 135.6894f,228.3413f,71.1661f, 
	154.6918f,157.4211f,26.0275f, 156.3247f,172.8760f,43.4238f, 156.2243f,143.1101f,42.4898f, 152.2783f,188.3996f,60.7797f, 155.4838f,159.0286f,61.5630f, 
	151.8481f,132.3316f,60.7739f, 143.0255f,202.5874f,76.4701f, 147.3887f,175.4196f,80.1506f, 147.2545f,149.1422f,81.2406f, 141.4405f,125.9916f,78.9702f, 
	144.9105f,149.5088f,4.9619f, 149.7410f,132.8505f,20.4655f, 135.8229f,128.1830f,0.0717f, 147.9636f,118.9435f,40.0802f, 137.2919f,111.8981f,18.5779f, 
	120.8758f,111.8214f,-0.7649f, 138.2031f,110.1632f,61.9678f, 129.8432f,100.4368f,42.0176f, 117.0121f,97.5654f,21.4945f, 101.1823f,101.6836f,3.0065f, 
	130.6973f,151.8930f,-10.9611f, 117.4073f,131.1721f,-15.6471f, 111.5690f,155.4988f,-22.3310f, 97.2992f,116.4888f,-14.3450f, 93.0098f,136.6587f,-24.5886f, 
	89.0440f,160.5686f,-27.2172f, 73.8972f,204.4527f,-15.6853f, 68.1698f,174.5498f,-23.8093f, 55.8092f,192.7749f,-14.4731f, 50.4369f,164.0527f,-18.4439f, 
	64.3627f,220.9433f,-4.5712f, 37.8547f,182.3155f,-6.1914f, 34.6537f,155.5324f,-6.7302f, 46.1545f,209.4088f,-0.3476f, 57.5841f,234.6376f,8.9682f, 
	22.8730f,173.7659f,9.5967f, 22.6938f,149.4998f,10.5720f, 29.2257f,198.8122f,12.0887f, 40.0760f,222.9682f,17.1711f, 53.4052f,244.6310f,23.7703f, 
	105.8924f,275.9594f,37.5976f, 98.0565f,267.7752f,23.7769f, 92.8482f,277.6024f,35.9787f, 84.1394f,265.4868f,22.5200f, 100.1765f,281.0237f,48.6848f, 
	77.8541f,272.1978f,35.7033f, 69.1191f,257.5161f,22.3725f, 86.0623f,279.5874f,48.0313f, 93.5571f,278.9394f,59.5767f, 60.8646f,259.5103f,37.0804f, 
	69.0888f,269.1227f,49.3372f, 77.4667f,272.7493f,60.4639f, 93.5571f,278.9394f,59.5767f, 85.8561f,270.0299f,70.6592f, 129.3303f,221.0853f,85.4970f, 
	123.9647f,247.0184f,73.4260f, 135.6894f,228.3413f,71.1661f, 116.2437f,238.6637f,86.7073f, 111.6800f,260.6910f,73.8697f, 119.5874f,211.3268f,98.3958f, 
	101.7676f,250.7608f,86.1195f, 99.0365f,268.4792f,72.8881f, 104.3167f,227.2287f,98.6642f, 106.5302f,199.9464f,108.7486f, 86.0712f,255.9104f,83.7077f, 
	86.7346f,236.5423f,96.3999f, 88.1994f,213.3108f,107.4972f, 90.6323f,187.9089f,115.2123f, 124.7537f,113.4124f,85.9319f, 131.6608f,137.2085f,96.7435f, 
	141.4405f,125.9916f,78.9702f, 112.9536f,126.4117f,103.5732f, 118.8419f,152.1410f,109.0978f, 103.1381f,106.8883f,89.6006f, 97.7157f,143.9436f,114.8521f, 
	104.6317f,169.5147f,115.2245f, 88.8767f,122.3946f,106.1636f, 78.9732f,106.7550f,89.2724f, 81.4010f,164.8515f,118.1232f, 71.7354f,143.6654f,114.2628f, 
	62.6496f,125.8878f,102.9826f, 55.2388f,112.7828f,84.8687f, 77.1627f,105.4544f,-1.4588f, 89.1844f,93.8122f,21.7453f, 63.6813f,100.1268f,18.8122f, 
	76.4379f,93.2082f,43.5545f, 54.2714f,115.3976f,-1.5118f, 50.0659f,103.0612f,42.6061f, 64.5949f,99.7526f,65.5590f, 39.8478f,113.6594f,20.5781f, 
	35.3913f,130.5167f,2.7481f, 39.1237f,114.6439f,66.3191f, 27.5663f,121.8491f,46.0712f, 21.9419f,133.7659f,26.7123f, 74.3239f,245.9634f,8.5475f, 
	91.0394f,251.5839f,9.6192f, 82.7656f,229.8228f,-4.1627f, 106.3430f,275.2526f,61.1397f, 106.3430f,275.2526f,61.1397f, 119.2357f,264.0319f,60.9610f, 
	113.2142f,273.9427f,49.1056f, 119.2357f,264.0319f,60.9610f, 123.9647f,247.0184f,73.4260f, 120.8052f,181.4569f,106.7124f, 135.2217f,163.9236f,97.6661f, 
	133.9980f,192.8158f,93.3515f, 147.2545f,149.1422f,81.2406f, 147.3887f,175.4196f,80.1506f, 143.0255f,202.5874f,76.4701f, 90.3563f,95.4818f,68.5480f, 
	103.8864f,91.8724f,44.7356f, 76.4379f,93.2082f,43.5545f, 90.3563f,95.4818f,68.5480f, 116.2912f,98.5746f,67.2361f, 116.2912f,98.5746f,67.2361f, 
	138.2031f,110.1632f,61.9678f, 49.7077f,137.4250f,-14.3494f, 68.4309f,147.4686f,-24.8750f, 71.5451f,123.7243f,-17.4237f, 29.0939f,215.2764f,64.1452f, 
	41.5267f,222.5505f,80.6137f, 28.5104f,200.2071f,79.4300f, 43.8876f,237.7155f,65.4875f, 56.5189f,242.5241f,78.9957f, 34.1831f,228.2341f,49.2028f, 
	60.6847f,257.6978f,63.9710f, 71.6886f,258.7577f,75.4233f, 50.7435f,250.6513f,50.6448f, 42.6536f,238.2445f,35.5712f, 39.6669f,198.1624f,94.7202f, 
	53.4853f,220.5865f,93.8202f, 54.5262f,195.2768f,106.3107f, 69.4639f,217.6015f,103.2290f, 71.9569f,191.7700f,113.3192f, 69.6388f,240.5511f,89.9170f, 
	25.5344f,175.9113f,85.9440f, 39.6771f,172.9686f,101.8518f, 28.9223f,152.1411f,89.6024f, 47.1993f,148.0561f,105.2914f, 39.0730f,130.5552f,89.4025f, 
	58.7623f,169.0227f,113.2125f, 18.1097f,186.6434f,65.3878f, 16.7768f,161.4986f,69.5918f, 13.0545f,173.0836f,48.1642f, 14.9465f,146.8625f,49.1974f, 
	14.4664f,160.4093f,29.2394f, 23.4315f,136.6074f,70.2271f, 20.2898f,201.3558f,48.8154f, 27.8743f,213.8250f,32.2242f, 17.5925f,187.2105f,29.9116f, 
	114.3777f,117.1862f,70.9696f, 120.4915f,125.3919f,67.4762f, 162.9528f,65.9721f,73.7831f, 123.7926f,125.6746f,57.1836f, 120.9799f,117.7516f,50.3844f, 
	114.8661f,109.5459f,53.8778f, 111.5650f,109.2632f,64.1704f, 120.4915f,125.3919f,67.4762f, 114.3777f,117.1862f,70.9696f, 117.6788f,117.4689f,60.6770f, 
	123.7926f,125.6746f,57.1836f, 120.9799f,117.7516f,50.3844f, 114.8661f,109.5459f,53.8778f, 111.5650f,109.2632f,64.1704f, 
_NULL_ }; /* End of body_Vertices */

const float body_UV[] = {
	0.1381f,0.3406f,0.1686f,0.2798f,0.1242f,0.2806f,0.1847f,0.3411f,0.2132f,0.2805f,0.1531f,0.3971f,0.2338f,0.3428f,0.2579f,0.2826f,0.2065f,0.3989f,0.1718f,0.4456f,0.2853f,0.3446f,0.3026f,0.2859f,0.2654f,0.3997f,0.2391f,0.4469f,0.1997f,0.4823f,
	0.0887f,0.3193f,0.1009f,0.3807f,0.0524f,0.3562f,0.1123f,0.4384f,0.0593f,0.4186f,0.0137f,0.3882f,0.1257f,0.4853f,0.0595f,0.4739f,0.0088f,0.4491f,-0.0293f,0.4130f,0.0875f,0.2457f,0.0503f,0.2850f,0.0482f,0.2151f,0.0104f,0.3227f,0.0077f,0.2551f,
	0.0049f,0.1914f,-0.0337f,0.3556f,-0.0370f,0.2939f,-0.0400f,0.2325f,-0.0432f,0.1763f,0.1382f,0.2211f,0.0982f,0.1859f,0.1549f,0.1678f,0.0505f,0.1558f,0.1087f,0.1330f,0.1784f,0.1251f,-0.0101f,0.1357f,0.0410f,0.1075f,0.1226f,0.0940f,0.2196f,0.0962f,
	0.1869f,0.2202f,0.2135f,0.1671f,0.2380f,0.2213f,0.2564f,0.1271f,0.2768f,0.1715f,0.2910f,0.2259f,0.3369f,0.3260f,0.3409f,0.2531f,0.3774f,0.2936f,0.3812f,0.2242f,0.3728f,0.3635f,0.4212f,0.2651f,0.4248f,0.2014f,0.4175f,0.3318f,0.4124f,0.3956f,
	0.4694f,0.2432f,0.4725f,0.1865f,0.4665f,0.3040f,0.4630f,0.3644f,0.4582f,0.4200f,0.1860f,0.5107f,0.2751f,0.4872f,0.3213f,0.5105f,0.3534f,0.4776f,0.1137f,0.5226f,0.4342f,0.4934f,0.4148f,0.4545f,0.5027f,0.5150f,-0.2294f,0.5174f,0.4907f,0.4590f,
	0.5439f,0.4858f,0.6337f,0.4984f,0.7706f,0.5174f,0.7353f,0.4960f,0.9238f,0.3963f,0.9419f,0.4536f,0.9707f,0.4130f,0.8875f,0.4338f,0.8994f,0.4821f,0.8808f,0.3726f,0.8351f,0.4579f,0.8305f,0.4965f,0.8382f,0.4054f,0.8413f,0.3437f,0.7651f,0.4650f,
	0.7814f,0.4218f,0.7933f,0.3695f,0.8039f,0.3119f,0.9178f,0.1431f,0.9119f,0.2024f,0.9568f,0.1763f,0.8688f,0.1727f,0.8727f,0.2355f,0.8629f,0.1221f,0.8264f,0.2110f,0.8374f,0.2730f,0.8124f,0.1567f,0.7891f,0.1147f,0.7877f,0.2557f,0.7699f,0.2028f,
	0.7469f,0.1568f,0.7114f,0.1212f,0.3151f,0.0974f,0.2270f,0.0771f,0.4093f,0.0841f,0.6737f,0.0753f,0.3917f,0.1140f,0.5624f,0.0906f,0.7075f,0.0905f,0.4784f,0.1091f,0.4403f,0.1445f,0.6340f,0.1181f,0.5630f,0.1285f,0.5105f,0.1519f,0.3659f,0.4269f,
	0.3059f,0.4451f,0.3240f,0.3897f,0.9291f,0.5127f,-0.0709f,0.5127f,0.9820f,0.4902f,0.0595f,0.5098f,-0.0180f,0.4902f,-0.0581f,0.4536f,0.8763f,0.3043f,0.9154f,0.2661f,0.9190f,0.3327f,0.9600f,0.2325f,0.9630f,0.2939f,0.9663f,0.3556f,0.8480f,0.0885f,
	0.0113f,0.0803f,-0.3263f,0.0753f,-0.1520f,0.0885f,-0.0578f,0.1030f,0.9422f,0.1030f,0.9899f,0.1357f,0.3853f,0.1623f,0.3361f,0.1896f,0.3289f,0.1361f,0.5927f,0.3504f,0.6435f,0.3735f,0.6293f,0.3173f,0.6038f,0.4074f,0.6610f,0.4244f,0.5531f,0.3799f,
	0.6153f,0.4588f,0.6871f,0.4662f,0.5550f,0.4374f,0.5086f,0.4037f,0.6732f,0.3180f,0.6916f,0.3744f,0.7169f,0.3173f,0.7417f,0.3735f,0.7605f,0.3153f,0.7194f,0.4252f,0.6431f,0.2605f,0.6892f,0.2601f,0.6587f,0.2064f,0.7120f,0.2045f,0.6792f,0.1588f,
	0.7374f,0.2582f,0.5938f,0.2804f,0.6061f,0.2218f,0.5572f,0.2445f,0.5636f,0.1839f,0.5173f,0.2124f,0.6181f,0.1655f,0.5553f,0.3129f,0.5121f,0.3418f,0.5148f,0.2762f,0.3131f,0.0024f,0.2637f,0.0088f,0.2143f,0.1871f,0.1650f,0.0088f,0.1156f,0.0024f,
	0.1650f,-0.0039f,0.2637f,-0.0039f,0.2637f,0.0088f,0.3131f,0.0024f,0.2143f,0.0024f,0.1650f,0.0088f,0.1156f,0.0024f,0.1650f,-0.0039f,0.2637f,-0.0039f,
_NULL_ }; /* End of body_UV */

const float body_Normals[] = {
	0.7957f,0.3740f,-0.4765f, 0.7218f,0.2014f,-0.6621f, 0.8742f,0.1773f,-0.4521f, 0.6225f,0.4062f,-0.6690f, 0.5162f,0.2349f,-0.8236f, 0.7017f,0.5114f,-0.4961f, 0.3928f,0.4465f,-0.8040f, 0.2734f,0.2744f,-0.9219f, 0.4904f,0.5502f,-0.6758f, 0.5839f,0.6299f,-0.5122f, 0.1253f,0.4874f,-0.8641f, 0.0177f,0.3191f,-0.9475f, 0.2179f,0.5920f,-0.7759f, 0.3130f,0.6732f,-0.6699f, 0.4175f,0.7552f,-0.5054f, 
	0.9261f,0.2901f,-0.2411f, 0.8500f,0.4520f,-0.2706f, 0.9257f,0.3774f,-0.0263f, 0.7609f,0.5836f,-0.2835f, 0.8520f,0.5219f,-0.0421f, 0.8747f,0.4463f,0.1890f, 0.6239f,0.7326f,-0.2721f, 0.7443f,0.6677f,-0.0133f, 0.7800f,0.5887f,0.2121f, 0.7688f,0.5051f,0.3923f, 0.9637f,-0.0044f,-0.2669f, 0.9878f,0.1531f,-0.0283f, 0.9772f,-0.2092f,-0.0365f, 0.9381f,0.2752f,0.2105f, 0.9740f,0.0026f,0.2266f, 
	0.8909f,-0.3993f,0.2163f, 0.8216f,0.3704f,0.4333f, 0.8639f,0.1713f,0.4737f, 0.8574f,-0.1386f,0.4957f, 0.7211f,-0.5261f,0.4509f, 0.8266f,-0.1062f,-0.5527f, 0.8657f,-0.3766f,-0.3298f, 0.6570f,-0.4619f,-0.5958f, 0.7778f,-0.6258f,-0.0585f, 0.5924f,-0.7424f,-0.3130f, 0.3758f,-0.7549f,-0.5374f, 0.5907f,-0.7805f,0.2049f, 0.4190f,-0.9076f,-0.0277f, 0.2534f,-0.9396f,-0.2302f, 0.0946f,-0.9018f,-0.4217f, 
	0.6281f,-0.0833f,-0.7737f, 0.4046f,-0.4328f,-0.8056f, 0.3618f,-0.0446f,-0.9312f, 0.0972f,-0.7056f,-0.7020f, 0.0854f,-0.3684f,-0.9257f, 0.0561f,0.0169f,-0.9983f, -0.1573f,0.4705f,-0.8683f, -0.2246f,0.1893f,-0.9559f, -0.4013f,0.3832f,-0.8319f, -0.4782f,0.0301f,-0.8777f, -0.3203f,0.5835f,-0.7463f, -0.6480f,0.2713f,-0.7117f, -0.6992f,-0.1331f,-0.7024f, -0.5512f,0.5219f,-0.6510f, -0.4631f,0.6667f,-0.5840f, 
	-0.8563f,0.1453f,-0.4957f, -0.8486f,-0.2661f,-0.4572f, -0.7652f,0.4412f,-0.4688f, -0.6628f,0.6163f,-0.4254f, -0.5704f,0.7269f,-0.3824f, 0.3273f,0.8950f,-0.3031f, 0.1207f,0.8142f,-0.5679f, -0.0427f,0.9404f,-0.3373f, -0.1744f,0.8191f,-0.5465f, 0.1589f,0.9873f,0.0079f, -0.3568f,0.8894f,-0.2859f, -0.4052f,0.7846f,-0.4692f, -0.2342f,0.9721f,-0.0083f, -0.0307f,0.9476f,0.3179f, -0.5553f,0.8070f,-0.2009f, 
	-0.4972f,0.8673f,0.0257f, -0.3632f,0.8870f,0.2852f, -0.0307f,0.9476f,0.3179f, -0.1607f,0.8400f,0.5182f, 0.6475f,0.4784f,0.5932f, 0.6298f,0.6104f,0.4804f, 0.7688f,0.5051f,0.3923f, 0.4578f,0.5827f,0.6715f, 0.4213f,0.7143f,0.5589f, 0.4854f,0.4417f,0.7545f, 0.2064f,0.6685f,0.7145f, 0.1394f,0.8020f,0.5809f, 0.2547f,0.5461f,0.7981f, 0.2949f,0.3837f,0.8751f, -0.0876f,0.7268f,0.6812f, 
	-0.0231f,0.6182f,0.7857f, 0.0318f,0.4885f,0.8720f, 0.0809f,0.2937f,0.9525f, 0.4299f,-0.7558f,0.4939f, 0.6204f,-0.3568f,0.6985f, 0.7211f,-0.5261f,0.4509f, 0.3232f,-0.5703f,0.7551f, 0.4613f,-0.1352f,0.8769f, 0.1295f,-0.8660f,0.4830f, 0.1517f,-0.2952f,0.9433f, 0.2702f,0.0942f,0.9582f, -0.0039f,-0.6684f,0.7438f, -0.1350f,-0.8822f,0.4511f, -0.0505f,0.0180f,0.9986f, -0.1991f,-0.3375f,0.9201f, 
	-0.3155f,-0.6503f,0.6911f, -0.3739f,-0.8330f,0.4078f, -0.1475f,-0.8728f,-0.4652f, -0.0443f,-0.9788f,-0.1999f, -0.2753f,-0.9335f,-0.2296f, -0.1589f,-0.9873f,-0.0079f, -0.3935f,-0.7739f,-0.4962f, -0.3987f,-0.9169f,-0.0172f, -0.2657f,-0.9463f,0.1844f, -0.5297f,-0.8136f,-0.2399f, -0.6441f,-0.5749f,-0.5046f, -0.5360f,-0.8161f,0.2161f, -0.6827f,-0.7306f,0.0146f, -0.8052f,-0.5524f,-0.2156f, -0.2502f,0.7074f,-0.6611f, 
	0.0156f,0.7106f,-0.7034f, -0.0684f,0.6109f,-0.7888f, 0.3349f,0.8741f,0.3519f, 0.3349f,0.8741f,0.3519f, 0.6171f,0.7279f,0.2989f, 0.5275f,0.8493f,0.0229f, 0.6171f,0.7279f,0.2989f, 0.6298f,0.6104f,0.4804f, 0.4992f,0.2248f,0.8368f, 0.6986f,0.0430f,0.7142f, 0.6855f,0.3123f,0.6577f, 0.8574f,-0.1386f,0.4957f, 0.8639f,0.1713f,0.4737f, 0.8216f,0.3704f,0.4333f, -0.0321f,-0.9762f,0.2143f, 
	0.0907f,-0.9959f,0.0018f, -0.1589f,-0.9873f,-0.0079f, -0.0321f,-0.9762f,0.2143f, 0.2470f,-0.9423f,0.2258f, 0.2470f,-0.9423f,0.2258f, 0.5907f,-0.7805f,0.2049f, -0.4840f,-0.4282f,-0.7632f, -0.2343f,-0.2179f,-0.9474f, -0.2041f,-0.6241f,-0.7542f, -0.7889f,0.5623f,0.2480f, -0.6393f,0.5973f,0.4843f, -0.7755f,0.4355f,0.4570f, -0.6659f,0.6916f,0.2798f, -0.5070f,0.6979f,0.5058f, -0.7605f,0.6484f,0.0345f, 
	-0.5400f,0.7884f,0.2945f, -0.3580f,0.7732f,0.5235f, -0.6452f,0.7622f,0.0524f, -0.6899f,0.7012f,-0.1797f, -0.6238f,0.4074f,0.6670f, -0.4652f,0.5705f,0.6768f, -0.4185f,0.3721f,0.8285f, -0.2349f,0.5345f,0.8118f, -0.1758f,0.3319f,0.9268f, -0.2947f,0.6657f,0.6856f, -0.8196f,0.1499f,0.5530f, -0.6244f,0.1059f,0.7739f, -0.7703f,-0.2416f,0.5901f, -0.5220f,-0.2965f,0.7997f, -0.5951f,-0.6072f,0.5265f, 
	-0.3598f,0.0566f,0.9313f, -0.9171f,0.2941f,0.2692f, -0.9409f,-0.0910f,0.3261f, -0.9936f,0.1075f,0.0357f, -0.9351f,-0.3509f,0.0507f, -0.9707f,-0.0961f,-0.2203f, -0.7962f,-0.5238f,0.3028f, -0.8899f,0.4549f,0.0332f, -0.8038f,0.5589f,-0.2038f, -0.9234f,0.3117f,-0.2241f, -0.1750f,-0.1265f,0.9764f, 0.4854f,0.5885f,0.6465f, 0.7469f,-0.6234f,0.2311f, 0.7679f,0.6028f,-0.2167f, 0.4340f,-0.0910f,-0.8963f, 
	-0.2628f,-0.7656f,-0.5871f, -0.5473f,-0.7907f,0.2742f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, -0.7508f,0.6239f,-0.2169f, 
_NULL_ }; /* End of body_Normals */

const unsigned short body_Faces[] = {
	0, 2, 1, 3, 1, 4, 0, 1, 3, 5, 0, 3, 6, 4, 7, 3, 4, 6, 8, 3, 6, 5, 3, 8, 9, 5, 8, 10, 7, 11, 
	6, 7, 10, 12, 6, 10, 8, 6, 12, 13, 8, 12, 9, 8, 13, 14, 9, 13, 15, 2, 0, 16, 0, 5, 15, 0, 16, 17, 15, 16, 
	18, 5, 9, 16, 5, 18, 19, 16, 18, 17, 16, 19, 20, 17, 19, 21, 9, 14, 18, 9, 21, 22, 18, 21, 19, 18, 22, 23, 19, 22, 
	20, 19, 23, 24, 20, 23, 25, 2, 15, 26, 15, 17, 25, 15, 26, 27, 25, 26, 28, 17, 20, 26, 17, 28, 29, 26, 28, 27, 26, 29, 
	30, 27, 29, 31, 20, 24, 28, 20, 31, 32, 28, 31, 29, 28, 32, 33, 29, 32, 30, 29, 33, 34, 30, 33, 35, 2, 25, 36, 25, 27, 
	35, 25, 36, 37, 35, 36, 38, 27, 30, 36, 27, 38, 39, 36, 38, 37, 36, 39, 40, 37, 39, 41, 30, 34, 38, 30, 41, 42, 38, 41, 
	39, 38, 42, 43, 39, 42, 40, 39, 43, 44, 40, 43, 1, 2, 35, 45, 35, 37, 1, 35, 45, 4, 1, 45, 46, 37, 40, 45, 37, 46, 
	47, 45, 46, 4, 45, 47, 7, 4, 47, 48, 40, 44, 46, 40, 48, 49, 46, 48, 47, 46, 49, 50, 47, 49, 7, 47, 50, 11, 7, 50, 
	51, 11, 52, 53, 52, 54, 51, 52, 53, 55, 51, 53, 56, 54, 57, 53, 54, 56, 58, 53, 56, 55, 53, 58, 59, 55, 58, 60, 57, 61, 
	56, 57, 60, 62, 56, 60, 58, 56, 62, 63, 58, 62, 59, 58, 63, 64, 59, 63, 65, 14, 66, 67, 66, 68, 65, 66, 67, 69, 65, 67, 
	70, 68, 71, 67, 68, 70, 72, 67, 70, 69, 67, 72, 73, 69, 72, 74, 71, 64, 70, 71, 74, 75, 70, 74, 72, 70, 75, 76, 72, 75, 
	77, 72, 76, 78, 77, 76, 79, 81, 80, 82, 80, 83, 79, 80, 82, 84, 79, 82, 85, 83, 86, 82, 83, 85, 87, 82, 85, 84, 82, 87, 
	88, 84, 87, 89, 86, 78, 85, 86, 89, 90, 85, 89, 87, 85, 90, 91, 87, 90, 88, 87, 91, 92, 88, 91, 93, 95, 94, 96, 94, 97, 
	93, 94, 96, 98, 93, 96, 99, 97, 100, 96, 97, 99, 101, 96, 99, 98, 96, 101, 102, 98, 101, 103, 100, 92, 99, 100, 103, 104, 99, 103, 
	101, 99, 104, 105, 101, 104, 102, 101, 105, 106, 102, 105, 107, 44, 108, 109, 108, 110, 107, 108, 109, 111, 107, 109, 112, 110, 113, 109, 110, 112, 
	114, 109, 112, 111, 109, 114, 115, 111, 114, 116, 113, 106, 112, 113, 116, 117, 112, 116, 114, 112, 117, 118, 114, 117, 115, 114, 118, 61, 115, 118, 
	59, 64, 71, 119, 71, 68, 59, 71, 119, 55, 59, 119, 120, 68, 66, 119, 68, 120, 121, 119, 120, 55, 119, 121, 51, 55, 121, 13, 66, 14, 
	120, 66, 13, 12, 120, 13, 121, 120, 12, 10, 121, 12, 51, 121, 10, 11, 51, 10, 77, 78, 86, 122, 86, 83, 77, 86, 122, 69, 73, 123, 
	124, 83, 80, 122, 83, 124, 125, 123, 126, 69, 123, 125, 65, 69, 125, 23, 127, 24, 126, 127, 23, 22, 126, 23, 125, 126, 22, 21, 125, 22, 
	65, 125, 21, 14, 65, 21, 88, 92, 100, 128, 100, 97, 88, 100, 128, 84, 88, 128, 129, 97, 94, 128, 97, 129, 130, 128, 129, 84, 128, 130, 
	79, 84, 130, 131, 94, 95, 129, 94, 131, 132, 129, 131, 130, 129, 132, 133, 130, 132, 79, 130, 133, 81, 79, 133, 102, 106, 113, 134, 113, 110, 
	102, 113, 134, 98, 102, 134, 135, 136, 108, 137, 136, 135, 138, 137, 135, 98, 134, 139, 93, 98, 139, 43, 108, 44, 135, 108, 43, 42, 135, 43, 
	138, 135, 42, 41, 138, 42, 93, 139, 140, 95, 93, 140, 115, 61, 57, 141, 57, 54, 115, 57, 141, 111, 115, 141, 142, 54, 52, 141, 54, 142, 
	143, 141, 142, 111, 141, 143, 107, 111, 143, 50, 52, 11, 142, 52, 50, 49, 142, 50, 143, 142, 49, 48, 143, 49, 107, 143, 48, 44, 107, 48, 
	144, 146, 145, 147, 145, 148, 144, 145, 147, 149, 144, 147, 150, 148, 151, 147, 148, 150, 152, 147, 150, 149, 147, 152, 153, 149, 152, 76, 151, 78, 
	150, 151, 76, 75, 150, 76, 152, 150, 75, 74, 152, 75, 153, 152, 74, 64, 153, 74, 145, 146, 154, 155, 154, 156, 145, 154, 155, 148, 145, 155, 
	157, 156, 158, 155, 156, 157, 159, 155, 157, 148, 155, 159, 151, 148, 159, 91, 158, 92, 157, 158, 91, 90, 157, 91, 159, 157, 90, 89, 159, 90, 
	151, 159, 89, 78, 151, 89, 154, 146, 160, 161, 160, 162, 154, 160, 161, 156, 154, 161, 163, 162, 164, 161, 162, 163, 165, 161, 163, 156, 161, 165, 
	158, 156, 165, 105, 164, 106, 163, 164, 105, 104, 163, 105, 165, 163, 104, 103, 165, 104, 158, 165, 103, 92, 158, 103, 160, 146, 166, 167, 166, 168, 
	160, 166, 167, 162, 160, 167, 169, 168, 170, 167, 168, 169, 171, 167, 169, 162, 167, 171, 164, 162, 171, 118, 170, 61, 169, 170, 118, 117, 169, 118, 
	171, 169, 117, 116, 171, 117, 164, 171, 116, 106, 164, 116, 166, 146, 144, 172, 144, 149, 166, 144, 172, 168, 166, 172, 173, 149, 153, 172, 149, 173, 
	174, 172, 173, 168, 172, 174, 170, 168, 174, 63, 153, 64, 173, 153, 63, 62, 173, 63, 174, 173, 62, 60, 174, 62, 170, 174, 60, 61, 170, 60, 
	175, 177, 176, 176, 177, 178, 178, 177, 179, 179, 177, 180, 180, 177, 181, 181, 177, 175, 182, 184, 183, 185, 184, 182, 186, 184, 185, 187, 184, 186, 
	188, 184, 187, 183, 184, 188, 
_NULL_ }; /* End of body_Faces */


/* MESH 4 */

#define object02_NumVertex  410
#define object02_NumFaces   760
#define object02_NumStrips  0
#define object02_Flags      0x00020006
#define object02_Material   0

const float object02_Vertices[] = {
	58.2815f,-4.9517f,83.1020f, 58.8940f,-3.5793f,87.0378f, 61.2280f,-4.2062f,84.5270f, 60.5862f,-5.4213f,80.8275f, 56.5091f,-4.5058f,85.5051f, 
	57.1445f,-2.9829f,89.6649f, 57.5142f,-5.7920f,78.1980f, 55.7230f,-5.4303f,80.1394f, 59.7926f,-6.1782f,76.3382f, 55.0188f,-4.1061f,87.8140f, 
	53.5562f,-3.7722f,89.8254f, 54.3654f,-2.0882f,94.3961f, 55.7234f,-2.4714f,92.1767f, 54.1774f,-5.1016f,81.9979f, 52.6334f,-4.8133f,83.6166f, 
	53.3464f,-5.4335f,75.7759f, 52.6754f,-4.9428f,70.1132f, 51.0987f,-4.6655f,70.8307f, 51.7576f,-5.1682f,76.9286f, 54.9194f,-5.7584f,74.4702f, 
	54.2277f,-5.3503f,69.3278f, 56.7149f,-6.1268f,73.0858f, 58.9654f,-6.5200f,71.7067f, 58.2120f,-6.3556f,67.5349f, 55.9974f,-5.8402f,68.4665f, 
	69.3454f,-6.3853f,75.8224f, 69.8399f,-5.4584f,78.7122f, 71.1302f,-5.4597f,77.0340f, 71.3064f,-6.1586f,74.6761f, 66.7830f,-6.2436f,77.3112f, 
	67.4913f,-5.2413f,80.5731f, 68.6859f,-6.9816f,72.3898f, 65.9138f,-6.8824f,73.4212f, 70.8624f,-6.7496f,71.5498f, 63.6626f,-5.8884f,78.9248f, 
	64.3731f,-4.7943f,82.4243f, 62.7945f,-6.5791f,74.7323f, 61.8931f,-6.9163f,70.4285f, 61.0706f,-6.8265f,66.5562f, 64.9208f,-7.1960f,69.4584f, 
	64.0059f,-7.1314f,65.8909f, 67.6040f,-7.2425f,68.9764f, 69.6660f,-6.9907f,68.5465f, 68.3090f,-6.9344f,66.4282f, 66.5592f,-7.1530f,65.8970f, 
	54.8954f,30.3318f,67.8313f, 51.9654f,31.7083f,78.9380f, 47.5990f,31.4519f,77.8121f, 57.5715f,31.8745f,79.1334f, 54.8954f,30.3318f,67.8313f, 
	44.6367f,31.1533f,76.0943f, 42.8724f,30.8067f,73.7788f, 44.6367f,31.1533f,76.0943f, 53.5462f,18.7941f,80.7820f, 55.0212f,12.9551f,84.1882f, 
	54.3661f,13.0743f,82.5625f, 53.1861f,17.8117f,78.8672f, 54.0198f,20.6054f,81.3299f, 55.8473f,13.2889f,84.4354f, 53.5462f,18.7941f,80.7820f, 
	53.1861f,17.8117f,78.8672f, 54.8458f,23.2337f,80.7978f, 56.3279f,26.3472f,79.2162f, 59.1866f,14.4452f,82.2875f, 57.1360f,13.8605f,83.7712f, 
	42.1316f,30.3712f,70.5852f, 41.8996f,29.8989f,67.0124f, 41.8713f,29.4459f,63.5479f, 42.2500f,29.0849f,60.7102f, 52.0963f,16.4882f,65.8793f, 
	52.5029f,13.7276f,65.9665f, 52.2400f,10.5494f,62.5626f, 52.0355f,15.5321f,62.7016f, 52.3526f,17.4626f,70.1783f, 52.9730f,15.1121f,70.6799f, 
	52.7607f,17.6561f,74.9737f, 53.5452f,15.0110f,76.2982f, 52.7607f,17.6561f,74.9737f, 52.9730f,15.1121f,70.6799f, 52.3526f,17.4626f,70.1783f, 
	43.3892f,28.9047f,59.1109f, 45.3908f,28.8534f,58.3339f, 48.3855f,28.8948f,58.0752f, 52.2814f,28.9861f,58.0264f, 53.6561f,16.6845f,59.5103f, 
	54.4861f,8.3116f,60.7115f, 56.2906f,7.7198f,60.4521f, 55.1902f,17.9147f,59.0674f, 52.7402f,15.7716f,60.0866f, 53.3552f,8.8887f,60.9954f, 
	52.2344f,15.3513f,60.9846f, 52.6619f,9.5352f,61.4894f, 68.6345f,31.1919f,71.7799f, 66.6849f,31.5956f,75.2466f, 68.9324f,30.7193f,68.1026f, 
	62.8320f,31.8426f,77.8785f, 58.6473f,28.5928f,77.1432f, 62.0806f,14.5462f,80.4997f, 61.3163f,29.4347f,74.7549f, 65.2102f,14.0826f,78.4488f, 
	63.6869f,28.8851f,72.2344f, 65.3007f,27.4155f,69.5963f, 69.5924f,11.8756f,73.4274f, 67.8761f,13.1382f,76.1315f, 56.0131f,29.0198f,57.5676f, 
	59.0562f,29.0217f,56.9970f, 61.2781f,29.0468f,56.7627f, 63.0298f,29.1587f,57.2835f, 61.9283f,19.8315f,58.0966f, 64.2943f,6.4363f,59.6868f, 
	66.5854f,6.7773f,60.8028f, 63.7028f,20.5211f,58.9995f, 61.9283f,19.8315f,58.0966f, 59.7238f,19.3868f,58.0095f, 61.6067f,6.5750f,59.5273f, 
	61.6067f,6.5750f,59.5273f, 63.0298f,29.1587f,57.2835f, 57.3337f,18.8203f,58.4570f, 58.7921f,7.0691f,59.9324f, 64.9705f,29.4211f,58.9202f, 
	66.8009f,29.7947f,61.4305f, 68.2214f,30.2405f,64.5720f, 65.9816f,25.5867f,66.6022f, 70.1358f,10.4192f,70.0440f, 65.8571f,23.6563f,63.6038f, 
	69.6919f,8.9578f,66.4798f, 65.0549f,21.8819f,60.9524f, 68.4465f,7.6809f,63.2333f, 58.4620f,6.6086f,86.9462f, 60.7767f,5.9100f,85.2260f, 
	56.9020f,7.1621f,88.1912f, 59.0506f,1.7288f,88.7065f, 57.3778f,2.5719f,90.6773f, 61.4229f,0.7654f,86.5744f, 55.8192f,7.6165f,88.8674f, 
	54.9321f,7.7985f,89.6911f, 56.1391f,3.2209f,92.3942f, 55.0530f,3.5865f,94.0590f, 56.0915f,-0.0837f,93.5620f, 54.8550f,0.3207f,95.6795f, 
	57.4324f,-0.7013f,91.2398f, 59.1532f,-1.4728f,88.7746f, 61.5136f,-2.3080f,86.3325f, 8.7199f,2.3252f,97.5229f, 10.2153f,4.5120f,96.4873f, 
	11.7902f,4.2569f,99.0973f, 11.2096f,2.7991f,100.3530f, 7.2359f,1.8546f,93.8070f, 8.7462f,4.1930f,92.2478f, 8.5797f,1.0037f,97.9362f, 
	7.0781f,0.5377f,94.4700f, 11.2883f,1.4360f,100.8262f, 6.8388f,1.2427f,89.7917f, 7.4885f,0.7867f,85.8924f, 8.2641f,2.1776f,85.4552f, 
	8.1232f,3.1765f,88.0590f, 6.7286f,0.0732f,90.5948f, 7.4594f,-0.3546f,86.4839f, 7.5429f,-0.6095f,90.9925f, 9.0565f,-1.0979f,90.6271f, 
	9.2266f,-1.3020f,87.7436f, 8.2165f,-1.0081f,87.1195f, 7.9010f,-0.2386f,94.5362f, 9.5988f,-0.7680f,94.1593f, 9.3612f,0.1609f,97.6635f, 
	11.9773f,0.4964f,100.3665f, 12.7322f,-0.0505f,99.4717f, 11.0507f,-0.3893f,97.3320f, 52.5310f,4.0560f,62.2059f, 51.5476f,4.5143f,62.5492f, 
	53.5280f,3.0812f,61.9502f, 52.3469f,-0.3176f,63.6842f, 53.6256f,-1.1249f,63.4640f, 51.0627f,0.0921f,63.9549f, 54.9010f,1.9425f,61.7682f, 
	56.8887f,0.7074f,61.5046f, 55.1937f,-2.1585f,63.2165f, 57.2918f,-3.2714f,62.8343f, 55.5258f,-4.5933f,65.3481f, 55.9974f,-5.8402f,68.4665f, 
	58.2120f,-6.3556f,67.5349f, 57.6940f,-5.3819f,64.7460f, 53.8293f,-3.8474f,65.8273f, 54.2277f,-5.3503f,69.3278f, 52.3714f,-3.2653f,66.2415f, 
	50.8933f,-2.9354f,66.6569f, 51.0987f,-4.6655f,70.8307f, 52.6754f,-4.9428f,70.1132f, 70.1650f,3.2749f,79.1166f, 72.0322f,2.3004f,76.2796f, 
	67.2871f,4.2039f,81.4165f, 70.8064f,-1.6441f,80.3035f, 67.9880f,-0.9542f,82.5594f, 72.6565f,-2.3450f,77.4857f, 63.9307f,5.0928f,83.4050f, 
	64.6313f,-0.1462f,84.5712f, 64.7041f,-3.0687f,84.2081f, 67.9235f,-3.6772f,82.2331f, 70.4271f,-4.0817f,80.1274f, 72.0632f,-4.5305f,77.5072f, 
	59.5655f,-0.3677f,60.9678f, 62.5722f,-1.1048f,60.5825f, 60.0491f,-4.1873f,62.2142f, 63.0788f,-4.7922f,61.7959f, 65.5267f,-1.4065f,60.8245f, 
	68.1604f,-1.2575f,62.1299f, 66.0126f,-5.0205f,62.0433f, 68.6861f,-4.9226f,63.3912f, 62.5722f,-1.1048f,60.5825f, 63.0788f,-4.7922f,61.7959f, 
	66.1492f,-6.5575f,63.6910f, 68.6093f,-6.4426f,64.9686f, 63.4605f,-6.4647f,63.4840f, 60.5025f,-6.0424f,63.9819f, 57.6940f,-5.3819f,64.7460f, 
	60.5025f,-6.0424f,63.9819f, 60.0491f,-4.1873f,62.2142f, 70.3617f,-0.6812f,64.9145f, 71.8967f,0.1913f,68.5920f, 70.9507f,-4.5696f,66.2292f, 
	72.5144f,-3.9893f,69.8847f, 72.5315f,1.2289f,72.5759f, 73.1540f,-3.1922f,73.8020f, 72.5834f,-5.2497f,74.1743f, 72.0970f,-5.9101f,70.7767f, 
	70.7157f,-6.2622f,67.5750f, 49.9069f,-4.9779f,77.8608f, 49.2343f,-4.5641f,71.4981f, 49.9069f,-4.9779f,77.8608f, 50.8432f,-4.5719f,84.8431f, 
	47.6720f,-4.8238f,78.6298f, 48.7045f,-4.3545f,85.7682f, 46.9284f,-4.5600f,72.1419f, 47.6720f,-4.8238f,78.6298f, 51.8602f,-3.5219f,91.3477f, 
	52.7910f,-1.8731f,96.1803f, 49.8336f,-3.3225f,92.4906f, 50.8897f,-1.7640f,97.6312f, 47.3854f,-3.1429f,93.3495f, 44.4350f,-2.9533f,94.0131f, 
	45.7431f,-1.6376f,99.7489f, 48.5641f,-1.7045f,98.8094f, 46.1180f,-4.1391f,86.4770f, 42.9899f,-3.9039f,87.0518f, 44.9367f,-4.6690f,79.2850f, 
	44.0404f,-4.5770f,72.7764f, 40.4594f,-4.5357f,73.4044f, 41.5964f,-4.4765f,79.8708f, 44.9367f,-4.6690f,79.2850f, 41.5964f,-4.4765f,79.8708f, 
	53.3717f,14.0053f,77.5228f, 53.7723f,11.5930f,84.4925f, 52.7575f,14.2760f,71.2691f, 52.4115f,13.8866f,79.0650f, 51.7646f,14.3107f,72.0882f, 
	52.6270f,11.1409f,86.6879f, 52.0342f,12.5578f,66.3657f, 51.1601f,8.9598f,63.6019f, 50.7168f,12.1700f,66.9697f, 49.4180f,8.1085f,64.3037f, 
	52.7575f,14.2760f,71.2691f, 51.7646f,14.3107f,72.0882f, 48.2261f,12.3059f,67.6277f, 43.8981f,12.8260f,68.5135f, 42.0496f,6.9074f,65.6722f, 
	46.5390f,7.4564f,64.9509f, 49.6666f,15.0943f,73.2963f, 45.7770f,16.5573f,75.1539f, 50.4802f,14.4845f,81.2938f, 50.6520f,11.1213f,89.5989f, 
	47.4831f,11.3674f,93.2648f, 47.0255f,15.6602f,84.4857f, 49.6666f,15.0943f,73.2963f, 45.7770f,16.5573f,75.1539f, 53.4253f,0.4552f,97.6002f, 
	53.8096f,3.5806f,95.9683f, 51.6542f,0.4166f,99.4022f, 52.2031f,3.3542f,98.1344f, 53.9294f,7.5430f,91.3782f, 52.5413f,7.0973f,93.7782f, 
	50.4731f,6.7400f,96.6782f, 47.5248f,6.4467f,99.8669f, 50.0425f,3.0432f,100.4599f, 47.2152f,2.7354f,102.7279f, 49.4140f,0.2880f,101.0795f, 
	46.6275f,0.1630f,102.5457f, 50.1542f,4.1395f,63.0546f, 49.4157f,-0.0686f,64.3721f, 48.0763f,3.3163f,63.6752f, 47.1609f,-0.5771f,64.9217f, 
	49.0941f,-2.9475f,67.1515f, 46.7765f,-3.1692f,67.7306f, 43.7612f,-3.4761f,68.3864f, 39.9313f,-3.7209f,69.0868f, 44.0562f,-1.2258f,65.5757f, 
	39.9511f,-1.8330f,66.3109f, 44.9824f,2.4319f,64.3173f, 40.6114f,1.5765f,65.0312f, 42.2415f,16.6225f,87.9341f, 43.3486f,11.5080f,96.7102f, 
	40.2827f,17.8363f,77.4063f, 36.8320f,16.9575f,90.8550f, 34.1182f,18.3748f,79.6434f, 38.6915f,11.4198f,99.2739f, 38.0390f,13.2083f,69.6459f, 
	36.3528f,6.4469f,66.4954f, 31.6685f,13.2207f,71.0046f, 30.3177f,6.0979f,67.5424f, 26.0097f,12.7419f,72.5892f, 21.4787f,11.7996f,74.5250f, 
	20.1760f,5.4338f,71.0657f, 24.8138f,5.8013f,68.9901f, 28.5676f,17.8899f,81.5045f, 24.0712f,16.5480f,83.0565f, 31.6973f,16.4738f,92.7241f, 
	33.9724f,11.0246f,100.6725f, 29.3069f,10.2942f,101.1134f, 27.1279f,15.2815f,93.6888f, 35.2948f,1.0271f,65.7730f, 35.0184f,-2.1148f,67.0330f, 
	29.6729f,0.7934f,66.7337f, 29.7319f,-2.1086f,67.9593f, 35.3224f,-3.7260f,69.7651f, 36.1357f,-4.3525f,74.0172f, 30.3027f,-3.5326f,70.6359f, 
	31.3587f,-4.0508f,74.8022f, 25.2241f,-3.1966f,71.9287f, 20.3791f,-2.7783f,73.8783f, 21.5532f,-3.1955f,77.6632f, 26.4112f,-3.6565f,75.9526f, 
	24.5305f,-1.9007f,69.3373f, 19.7201f,-1.5990f,71.4271f, 24.3345f,0.7841f,68.1516f, 19.5899f,0.8490f,70.2888f, 37.5668f,-4.2100f,80.4289f, 
	39.2359f,-3.6279f,87.5741f, 33.0581f,-3.8765f,81.1010f, 34.9895f,-3.3105f,88.1334f, 40.9207f,-2.7241f,94.5669f, 42.4044f,-1.5045f,100.4684f, 
	36.9094f,-2.4577f,95.0535f, 38.5701f,-1.3189f,100.9746f, 32.4654f,-2.1563f,95.5178f, 27.6465f,-1.8216f,96.0062f, 29.4559f,-0.8492f,101.4220f, 
	34.2546f,-1.0957f,101.2847f, 30.3830f,-2.9513f,88.8205f, 25.5453f,-2.5494f,89.7267f, 28.2776f,-3.4829f,82.0308f, 23.4253f,-3.0357f,83.3629f, 
	43.3290f,0.1523f,103.6388f, 43.8294f,2.5687f,104.4630f, 39.5431f,0.2264f,104.3331f, 39.9651f,2.5069f,105.5593f, 43.8848f,6.2310f,102.4998f, 
	39.7649f,6.0570f,104.2589f, 35.3389f,5.8566f,105.0863f, 30.6134f,5.5461f,105.1501f, 35.6700f,2.4902f,106.0248f, 30.9112f,2.4492f,105.9485f, 
	35.2758f,0.3480f,104.6403f, 30.4954f,0.4781f,104.5976f, 22.5571f,13.5439f,94.3598f, 24.3311f,9.1913f,101.0681f, 19.9110f,14.6164f,84.7865f, 
	17.6950f,10.8536f,94.9699f, 15.5477f,11.4882f,87.1650f, 19.1568f,7.6286f,100.5923f, 17.4820f,10.4230f,77.1524f, 16.1179f,4.8358f,74.1045f, 
	13.6610f,8.2934f,80.8023f, 12.5429f,3.9809f,78.0681f, 10.4012f,5.6872f,84.8754f, 9.7246f,2.9743f,82.3553f, 11.5537f,7.6300f,89.9009f, 
	13.2637f,7.5560f,95.6065f, 14.5067f,5.7642f,99.8400f, 15.4273f,0.8246f,73.4621f, 15.4471f,-1.3113f,74.5167f, 11.8934f,0.7541f,77.4410f, 
	11.8829f,-1.0207f,78.2599f, 15.9859f,-2.3354f,76.7329f, 17.0147f,-2.6915f,80.1342f, 12.3820f,-1.8886f,80.0373f, 13.2519f,-2.1882f,82.8869f, 
	9.8336f,-1.4466f,83.4315f, 10.6068f,-1.7086f,85.5583f, 9.1989f,-0.7105f,82.3106f, 9.1689f,0.6837f,81.7811f, 18.6907f,-2.5407f,85.2434f, 
	20.6004f,-2.1035f,90.9437f, 14.5656f,-2.0432f,87.2885f, 16.0978f,-1.6535f,92.2104f, 22.5015f,-1.4548f,96.5662f, 24.1481f,-0.5925f,101.4134f, 
	17.7458f,-1.0948f,97.0222f, 19.1865f,-0.3596f,101.1411f, 13.9045f,-0.7641f,97.2078f, 15.2569f,-0.1765f,100.4583f, 12.3967f,-1.2170f,93.3229f, 
	11.3840f,-1.5644f,89.2099f, 25.1139f,0.5786f,104.2522f, 25.5390f,2.3127f,105.4527f, 19.9170f,0.6350f,103.5248f, 20.1294f,2.0922f,104.4799f, 
	25.3585f,5.0314f,104.7196f, 19.9475f,4.3324f,103.7644f, 14.9973f,3.5098f,102.3252f, 15.2587f,1.7994f,102.9726f, 15.5682f,0.6326f,102.3018f, 
	
_NULL_ }; /* End of object02_Vertices */

const float object02_UV[] = {
	0.9132f,0.0836f,0.8949f,0.0898f,0.9082f,0.0886f,0.9239f,0.0832f,0.8997f,0.0839f,0.8793f,0.0910f,0.9371f,0.0814f,0.9282f,0.0815f,0.9435f,0.0812f,0.8846f,0.0842f,0.8689f,0.0843f,0.8465f,0.0922f,0.8629f,0.0919f,0.9176f,0.0817f,0.9061f,0.0817f,
	0.9560f,0.0837f,0.9902f,0.0908f,0.9936f,0.0914f,0.9523f,0.0839f,0.9598f,0.0833f,0.9880f,0.0894f,0.9628f,0.0826f,0.9643f,0.0821f,0.9829f,0.0859f,0.9857f,0.0876f,0.9383f,0.0843f,0.9294f,0.0884f,0.9338f,0.0902f,0.9404f,0.0874f,0.9350f,0.0830f,
	0.9241f,0.0874f,0.9489f,0.0827f,0.9483f,0.0814f,0.9493f,0.0857f,0.9307f,0.0828f,0.9177f,0.0877f,0.9469f,0.0811f,0.9638f,0.0817f,0.9792f,0.0848f,0.9623f,0.0818f,0.9752f,0.0845f,0.9601f,0.0830f,0.9588f,0.0859f,0.9663f,0.0872f,0.9706f,0.0854f,
	0.9811f,0.3228f,0.9061f,0.3224f,0.9118f,0.3197f,0.9104f,0.3257f,-0.0189f,0.3228f,-0.0478f,0.3177f,0.0707f,0.3165f,0.9522f,0.3177f,0.9064f,0.2377f,0.8918f,0.1978f,0.9005f,0.1995f,0.9205f,0.2326f,0.9017f,0.2493f,0.8917f,0.2002f,-0.0936f,0.2377f,
	-0.0795f,0.2326f,0.9042f,0.2671f,0.9129f,0.2891f,0.9065f,0.2107f,0.8971f,0.2049f,0.1399f,0.3157f,0.1548f,0.3151f,0.1579f,0.3147f,0.1528f,0.3146f,0.0102f,0.2331f,0.0080f,0.2152f,0.0265f,0.1970f,0.0267f,0.2292f,-0.0169f,0.2363f,-0.0218f,0.2210f,
	0.9490f,0.2342f,0.9402f,0.2164f,-0.0510f,0.2342f,0.9782f,0.2210f,0.9831f,0.2363f,0.1368f,0.3151f,0.1109f,0.3162f,0.0776f,0.3179f,0.0446f,0.3202f,0.0303f,0.2397f,0.0218f,0.1847f,0.0142f,0.1818f,0.0235f,0.2487f,0.0335f,0.2330f,0.0267f,0.1878f,
	0.0331f,0.2294f,0.0287f,0.1913f,0.9395f,0.3313f,0.9285f,0.3306f,0.9511f,0.3311f,0.9185f,0.3286f,0.9235f,0.3063f,0.9158f,0.2139f,0.9335f,0.3146f,0.9242f,0.2137f,0.9425f,0.3139f,0.9511f,0.3070f,0.9398f,0.2049f,0.9318f,0.2104f,0.0239f,0.3224f,
	0.0122f,0.3241f,0.0048f,0.3254f,-0.0025f,0.3264f,0.9998f,0.2647f,0.9907f,0.1774f,0.9823f,0.1798f,0.9918f,0.2693f,-0.0002f,0.2647f,0.0075f,0.2610f,-0.0016f,0.1773f,0.9984f,0.1773f,0.9975f,0.3264f,0.0155f,0.2559f,0.0062f,0.1791f,0.9871f,0.3278f,
	0.9752f,0.3291f,0.9630f,0.3303f,0.9611f,0.2976f,0.9497f,0.1982f,0.9716f,0.2872f,0.9607f,0.1911f,0.9821f,0.2773f,0.9719f,0.1847f,0.8884f,0.1560f,0.8996f,0.1537f,0.8787f,0.1580f,0.8845f,0.1232f,0.8712f,0.1265f,0.8975f,0.1195f,0.8720f,0.1600f,
	0.8646f,0.1602f,0.8589f,0.1289f,0.8464f,0.1296f,0.8557f,0.1066f,0.8406f,0.1071f,0.8711f,0.1048f,0.8864f,0.1024f,0.9002f,0.0997f,0.4694f,0.0992f,0.4693f,0.1149f,0.4790f,0.1119f,0.4810f,0.1013f,0.4578f,0.0983f,0.4558f,0.1153f,0.4700f,0.0903f,
	0.4590f,0.0892f,0.4822f,0.0921f,0.4468f,0.0971f,0.4365f,0.0973f,0.4360f,0.1070f,0.4435f,0.1115f,0.4485f,0.0889f,0.4378f,0.0894f,0.4501f,0.0845f,0.4503f,0.0822f,0.4421f,0.0831f,0.4398f,0.0850f,0.4599f,0.0844f,0.4608f,0.0820f,0.4702f,0.0853f,
	0.4821f,0.0866f,0.4810f,0.0841f,0.4718f,0.0827f,0.0269f,0.1551f,0.0315f,0.1574f,0.0224f,0.1494f,0.0221f,0.1255f,0.0163f,0.1210f,0.0288f,0.1274f,0.0164f,0.1427f,0.0089f,0.1357f,0.0100f,0.1151f,0.0031f,0.1090f,0.0004f,0.0978f,-0.0143f,0.0876f,
	-0.0171f,0.0859f,-0.0050f,0.0941f,0.0056f,0.1016f,-0.0120f,0.0894f,0.0108f,0.1045f,0.0173f,0.1057f,-0.0064f,0.0914f,-0.0098f,0.0908f,0.9254f,0.1450f,0.9333f,0.1416f,0.9180f,0.1482f,0.9235f,0.1124f,0.9164f,0.1141f,0.9312f,0.1107f,0.9097f,0.1510f,
	0.9081f,0.1164f,0.9107f,0.0977f,0.9184f,0.0966f,0.9248f,0.0966f,0.9319f,0.0963f,0.0012f,0.1303f,-0.0063f,0.1270f,-0.0038f,0.1047f,-0.0106f,0.1024f,0.9859f,0.1261f,0.9772f,0.1272f,0.9822f,0.1019f,0.9736f,0.1027f,0.9937f,0.1270f,0.9894f,0.1024f,
	0.9775f,0.0908f,0.9698f,0.0916f,0.9836f,0.0904f,0.9893f,0.0915f,0.9950f,0.0941f,-0.0107f,0.0915f,0.9962f,0.1047f,0.9662f,0.1299f,0.9546f,0.1335f,0.9628f,0.1039f,0.9516f,0.1056f,0.9433f,0.1376f,0.9409f,0.1082f,0.9408f,0.0943f,0.9501f,0.0923f,
	0.9600f,0.0918f,0.9498f,0.0837f,0.0002f,0.0908f,-0.0502f,0.0837f,0.8941f,0.0816f,0.9491f,0.0832f,0.8794f,0.0814f,0.0134f,0.0894f,-0.0509f,0.0832f,0.8527f,0.0840f,0.8299f,0.0916f,0.8336f,0.0836f,0.8108f,0.0904f,0.8073f,0.0831f,0.7661f,0.0826f,
	0.7542f,0.0875f,0.7868f,0.0890f,0.8560f,0.0812f,0.8042f,0.0810f,-0.0483f,0.0826f,0.0431f,0.0876f,0.1234f,0.0859f,-0.0299f,0.0820f,0.9517f,0.0826f,0.9701f,0.0820f,0.9328f,0.2089f,0.8883f,0.1882f,0.9758f,0.2150f,0.9223f,0.2066f,0.9745f,0.2142f,
	0.8708f,0.1832f,0.0089f,0.2071f,0.0290f,0.1854f,0.0140f,0.2036f,0.0387f,0.1786f,-0.0242f,0.2150f,-0.0255f,0.2142f,0.0301f,0.2030f,0.0836f,0.2038f,0.1267f,0.1667f,0.0634f,0.1727f,-0.0253f,0.2175f,-0.0186f,0.2240f,0.9019f,0.2080f,0.8410f,0.1801f,
	0.7885f,0.1776f,0.8496f,0.2118f,0.9747f,0.2175f,0.9814f,0.2240f,0.8246f,0.1060f,0.8315f,0.1276f,0.8059f,0.1036f,0.8124f,0.1239f,0.8517f,0.1569f,0.8321f,0.1516f,0.8037f,0.1463f,0.7636f,0.1407f,0.7872f,0.1192f,0.7544f,0.1144f,0.7823f,0.1006f,
	0.7518f,0.0975f,0.0390f,0.1540f,0.0386f,0.1254f,0.0533f,0.1473f,0.0558f,0.1207f,0.0272f,0.1045f,0.0447f,0.1016f,0.0793f,0.0979f,0.1515f,0.0941f,0.0895f,0.1147f,0.1562f,0.1085f,0.0839f,0.1398f,0.1489f,0.1319f,0.7173f,0.2135f,0.7166f,0.1742f,
	0.2462f,0.2283f,0.5876f,0.2112f,0.4357f,0.2276f,0.6453f,0.1698f,0.2328f,0.2030f,0.2380f,0.1607f,0.3432f,0.1994f,0.3197f,0.1551f,0.3808f,0.1927f,0.3989f,0.1832f,0.3814f,0.1438f,0.3589f,0.1497f,0.4426f,0.2207f,0.4445f,0.2089f,0.5347f,0.2045f,
	0.5915f,0.1642f,0.5531f,0.1571f,0.5088f,0.1941f,0.2436f,0.1255f,0.2490f,0.1040f,0.3136f,0.1209f,0.3169f,0.1011f,0.2563f,0.0917f,0.2727f,0.0848f,0.3280f,0.0901f,0.3532f,0.0841f,0.3656f,0.0892f,0.3884f,0.0885f,0.4047f,0.0834f,0.3863f,0.0838f,
	0.3553f,0.0993f,0.3795f,0.0977f,0.3523f,0.1175f,0.3765f,0.1144f,0.3819f,0.0816f,0.6658f,0.0808f,0.4213f,0.0813f,0.5384f,0.0807f,0.7002f,0.0822f,0.7098f,0.0864f,0.6201f,0.0819f,0.6553f,0.0856f,0.5578f,0.0816f,0.5199f,0.0814f,0.5560f,0.0845f,
	0.6007f,0.0850f,0.4935f,0.0805f,0.4758f,0.0804f,0.4294f,0.0812f,0.4348f,0.0811f,0.7133f,0.0953f,0.7150f,0.1106f,0.6675f,0.0936f,0.6705f,0.1077f,0.7160f,0.1359f,0.6656f,0.1317f,0.6180f,0.1279f,0.5762f,0.1238f,0.6245f,0.1055f,0.5813f,0.1032f,
	0.6190f,0.0924f,0.5746f,0.0912f,0.4921f,0.1804f,0.5239f,0.1479f,0.4466f,0.1933f,0.4800f,0.1604f,0.4496f,0.1694f,0.5020f,0.1359f,0.4125f,0.1707f,0.3991f,0.1360f,0.4254f,0.1525f,0.4147f,0.1260f,0.4364f,0.1312f,0.4278f,0.1151f,0.4529f,0.1406f,
	0.4723f,0.1366f,0.4869f,0.1224f,0.3955f,0.1101f,0.3983f,0.0954f,0.4116f,0.1052f,0.4135f,0.0931f,0.4056f,0.0874f,0.4183f,0.0830f,0.4189f,0.0863f,0.4285f,0.0826f,0.4296f,0.0856f,0.4363f,0.0826f,0.4264f,0.0909f,0.4253f,0.1004f,0.4401f,0.0809f,
	0.4678f,0.0803f,0.4445f,0.0809f,0.4640f,0.0804f,0.4974f,0.0812f,0.5234f,0.0839f,0.4844f,0.0812f,0.5026f,0.0835f,0.4765f,0.0816f,0.4894f,0.0836f,0.4620f,0.0809f,0.4481f,0.0812f,0.5381f,0.0899f,0.5443f,0.1004f,0.5128f,0.0886f,0.5167f,0.0974f,
	0.5410f,0.1186f,0.5141f,0.1124f,0.4948f,0.1061f,0.4970f,0.0946f,0.4957f,0.0876f,
_NULL_ }; /* End of object02_UV */

const float object02_Normals[] = {
	0.0010f,-0.9706f,0.2408f, 0.2034f,-0.8297f,0.5199f, 0.1059f,-0.8564f,0.5053f, -0.0186f,-0.9717f,0.2355f, 0.0298f,-0.9690f,0.2454f, 0.2863f,-0.7980f,0.5303f, -0.0650f,-0.9900f,0.1254f, -0.0675f,-0.9902f,0.1225f, -0.0666f,-0.9894f,0.1290f, 0.0396f,-0.9684f,0.2461f, 0.0313f,-0.9681f,0.2487f, 0.3194f,-0.7773f,0.5420f, 0.3499f,-0.7692f,0.5348f, -0.0627f,-0.9907f,0.1205f, -0.0561f,-0.9912f,0.1199f, 
	-0.1291f,-0.9916f,0.0085f, -0.2051f,-0.9555f,-0.2121f, -0.1382f,-0.9675f,-0.2117f, -0.1034f,-0.9946f,0.0024f, -0.1373f,-0.9904f,0.0139f, -0.2300f,-0.9545f,-0.1899f, -0.1290f,-0.9913f,0.0263f, -0.1041f,-0.9938f,0.0386f, -0.1747f,-0.9740f,-0.1444f, -0.2108f,-0.9626f,-0.1705f, 0.0660f,-0.9733f,0.2197f, 0.1983f,-0.8792f,0.4332f, 0.2807f,-0.8834f,0.3753f, 0.2679f,-0.9379f,0.2202f, -0.0041f,-0.9748f,0.2228f, 
	0.0998f,-0.8738f,0.4759f, 0.0169f,-0.9941f,0.1068f, -0.0360f,-0.9915f,0.1249f, 0.2124f,-0.9767f,0.0316f, -0.0265f,-0.9722f,0.2325f, 0.0726f,-0.8680f,0.4912f, -0.0571f,-0.9898f,0.1303f, -0.0851f,-0.9953f,0.0453f, -0.1242f,-0.9842f,-0.1258f, -0.0536f,-0.9977f,0.0405f, -0.0710f,-0.9883f,-0.1347f, 0.0041f,-1.0000f,0.0019f, 0.1439f,-0.9825f,-0.1180f, 0.0985f,-0.9762f,-0.1931f, 0.0170f,-0.9856f,-0.1684f, 
	0.0137f,0.9913f,-0.1308f, -0.0568f,0.7860f,0.6157f, -0.1937f,0.7312f,0.6541f, 0.2243f,0.6878f,0.6904f, 0.0137f,0.9913f,-0.1308f, -0.4576f,0.5893f,0.6659f, -0.8147f,0.3837f,0.4348f, -0.4576f,0.5893f,0.6659f, -0.6801f,-0.2005f,0.7052f, -0.5471f,0.3540f,0.7585f, -0.7551f,0.4026f,0.5174f, -0.8215f,-0.4853f,0.2993f, -0.2991f,0.1211f,0.9465f, -0.0021f,0.4680f,0.8837f, -0.6801f,-0.2005f,0.7052f, 
	-0.8215f,-0.4853f,0.2993f, 0.0679f,0.2516f,0.9655f, 0.5216f,0.0316f,0.8526f, 0.3155f,0.3957f,0.8625f, 0.2445f,0.4215f,0.8732f, -0.9350f,0.3207f,0.1516f, -0.9513f,0.3084f,-0.0015f, -0.9464f,0.2807f,-0.1599f, -0.8463f,0.2458f,-0.4726f, -0.8048f,-0.5575f,0.2036f, -0.9935f,0.0705f,0.0891f, -0.8653f,0.0771f,-0.4952f, -0.8756f,-0.4831f,0.0014f, -0.7488f,-0.6440f,0.1567f, -0.9910f,-0.0127f,0.1336f, 
	-0.7680f,-0.6266f,0.1322f, -0.9886f,-0.0298f,0.1475f, -0.7680f,-0.6266f,0.1322f, -0.9910f,-0.0127f,0.1336f, -0.7488f,-0.6440f,0.1567f, -0.4621f,0.3458f,-0.8166f, -0.1471f,0.5063f,-0.8497f, -0.0271f,0.5982f,-0.8009f, -0.0279f,0.6208f,-0.7835f, -0.1473f,-0.1829f,-0.9720f, -0.1648f,-0.1775f,-0.9702f, -0.1415f,-0.1670f,-0.9758f, -0.1253f,-0.1527f,-0.9803f, -0.3750f,-0.3103f,-0.8735f, -0.3119f,-0.1632f,-0.9360f, 
	-0.7238f,-0.4458f,-0.5267f, -0.6518f,-0.1323f,-0.7467f, 0.9158f,0.1548f,0.3706f, 0.6114f,0.2626f,0.7465f, 0.9423f,0.2922f,0.1631f, 0.3131f,0.4476f,0.8376f, 0.3478f,-0.0862f,0.9336f, 0.3419f,0.3736f,0.8622f, 0.4708f,-0.4956f,0.7298f, 0.4233f,0.4071f,0.8094f, 0.5353f,-0.3193f,0.7820f, 0.7414f,-0.0575f,0.6686f, 0.8087f,0.4893f,0.3264f, 0.5895f,0.4597f,0.6642f, -0.0587f,0.6225f,-0.7804f, 
	-0.0522f,0.6055f,-0.7941f, 0.0294f,0.5789f,-0.8149f, 0.2467f,0.5729f,-0.7816f, 0.1321f,-0.0915f,-0.9870f, 0.1388f,-0.0766f,-0.9874f, 0.4261f,0.0451f,-0.9036f, 0.4532f,-0.0021f,-0.8914f, 0.1321f,-0.0915f,-0.9870f, -0.0444f,-0.1171f,-0.9921f, -0.0461f,-0.1347f,-0.9898f, -0.0461f,-0.1347f,-0.9898f, 0.2467f,0.5729f,-0.7816f, -0.1188f,-0.1392f,-0.9831f, -0.1322f,-0.1575f,-0.9786f, 0.4001f,0.5612f,-0.7245f, 
	0.6956f,0.4884f,-0.5268f, 0.8205f,0.3246f,-0.4705f, 0.9943f,-0.0706f,0.0804f, 0.8956f,0.4288f,-0.1179f, 0.9614f,0.0564f,-0.2693f, 0.8338f,0.3146f,-0.4537f, 0.7239f,0.0429f,-0.6886f, 0.6811f,0.1870f,-0.7079f, 0.4397f,0.4513f,0.7765f, 0.3880f,0.3716f,0.8434f, 0.4274f,0.5327f,0.7305f, 0.5386f,0.2400f,0.8076f, 0.6107f,0.3404f,0.7149f, 0.4246f,0.1605f,0.8910f, 0.3963f,0.6375f,0.6607f, 
	0.4169f,0.7207f,0.5539f, 0.6378f,0.4174f,0.6473f, 0.5985f,0.4670f,0.6509f, 0.6554f,-0.1395f,0.7423f, 0.6302f,-0.1018f,0.7698f, 0.6154f,-0.2041f,0.7613f, 0.4855f,-0.2983f,0.8217f, 0.3291f,-0.4006f,0.8551f, -0.6100f,0.5586f,0.5619f, -0.4445f,0.8162f,0.3691f, -0.3274f,0.7589f,0.5629f, -0.4042f,0.4994f,0.7663f, -0.8039f,0.5512f,0.2233f, -0.5678f,0.8167f,0.1031f, -0.6430f,-0.2677f,0.7175f, 
	-0.8675f,-0.3049f,0.3931f, -0.3974f,-0.2409f,0.8855f, -0.9178f,0.3658f,-0.1545f, -0.8688f,0.1665f,-0.4663f, -0.7060f,0.5693f,-0.4212f, -0.6716f,0.7157f,-0.1919f, -0.8946f,-0.4468f,0.0055f, -0.7456f,-0.5973f,-0.2955f, -0.3468f,-0.9346f,0.0792f, -0.1557f,-0.9838f,0.0888f, -0.1678f,-0.9852f,0.0345f, -0.3176f,-0.9467f,-0.0545f, -0.3463f,-0.8996f,0.2661f, -0.1413f,-0.9761f,0.1653f, -0.2805f,-0.8603f,0.4258f, 
	-0.2111f,-0.8045f,0.5552f, -0.1210f,-0.9392f,0.3213f, -0.1319f,-0.9593f,0.2495f, -0.2769f,-0.1913f,-0.9417f, -0.2159f,-0.0997f,-0.9713f, -0.2488f,-0.2618f,-0.9325f, -0.2385f,-0.4742f,-0.8475f, -0.2788f,-0.5005f,-0.8196f, -0.1798f,-0.4682f,-0.8652f, -0.1947f,-0.2655f,-0.9443f, -0.1841f,-0.2640f,-0.9468f, -0.2763f,-0.5246f,-0.8053f, -0.2405f,-0.5362f,-0.8091f, -0.2870f,-0.8141f,-0.5049f, -0.2108f,-0.9626f,-0.1705f, 
	-0.1747f,-0.9740f,-0.1444f, -0.2456f,-0.8410f,-0.4820f, -0.2994f,-0.7931f,-0.5304f, -0.2300f,-0.9545f,-0.1899f, -0.2582f,-0.7915f,-0.5540f, -0.1682f,-0.8012f,-0.5742f, -0.1382f,-0.9675f,-0.2117f, -0.2051f,-0.9555f,-0.2121f, 0.5637f,0.3973f,0.7241f, 0.8207f,0.4146f,0.3932f, 0.4047f,0.3537f,0.8433f, 0.5550f,0.0841f,0.8276f, 0.3926f,0.0989f,0.9144f, 0.8563f,0.0223f,0.5160f, 0.3568f,0.3489f,0.8666f, 
	0.3469f,0.1038f,0.9321f, 0.2526f,-0.4388f,0.8623f, 0.2931f,-0.4576f,0.8394f, 0.4229f,-0.4947f,0.7592f, 0.6156f,-0.5878f,0.5249f, -0.1534f,-0.2558f,-0.9545f, -0.0547f,-0.2346f,-0.9705f, -0.1909f,-0.5443f,-0.8169f, -0.0764f,-0.5353f,-0.8412f, 0.1386f,-0.1841f,-0.9731f, 0.4298f,-0.0760f,-0.8997f, 0.1153f,-0.5090f,-0.8530f, 0.4048f,-0.4318f,-0.8060f, -0.0547f,-0.2346f,-0.9705f, -0.0764f,-0.5353f,-0.8412f, 
	0.0553f,-0.8587f,-0.5094f, 0.2506f,-0.8382f,-0.4843f, -0.0842f,-0.8670f,-0.4911f, -0.1781f,-0.8601f,-0.4780f, -0.2456f,-0.8410f,-0.4820f, -0.1781f,-0.8601f,-0.4780f, -0.1909f,-0.5443f,-0.8169f, 0.6960f,0.0730f,-0.7143f, 0.8656f,0.2144f,-0.4524f, 0.6910f,-0.3004f,-0.6575f, 0.9043f,-0.1664f,-0.3931f, 0.9381f,0.3366f,-0.0810f, 0.9975f,-0.0656f,0.0250f, 0.7266f,-0.6704f,0.1506f, 0.6598f,-0.7292f,-0.1816f, 
	0.4756f,-0.7861f,-0.3947f, -0.0718f,-0.9974f,0.0088f, -0.0824f,-0.9759f,-0.2019f, -0.0718f,-0.9974f,0.0088f, -0.0568f,-0.9914f,0.1180f, -0.0614f,-0.9979f,0.0207f, -0.0521f,-0.9918f,0.1165f, -0.0471f,-0.9848f,-0.1673f, -0.0614f,-0.9979f,0.0207f, 0.0118f,-0.9718f,0.2355f, 0.2272f,-0.8038f,0.5498f, -0.0168f,-0.9749f,0.2219f, 0.1619f,-0.8566f,0.4899f, -0.0249f,-0.9793f,0.2011f, -0.0429f,-0.9815f,0.1864f, 
	0.0332f,-0.9267f,0.3744f, 0.0683f,-0.8946f,0.4415f, -0.0573f,-0.9914f,0.1179f, -0.0560f,-0.9916f,0.1168f, -0.0528f,-0.9980f,0.0355f, -0.0468f,-0.9909f,-0.1261f, -0.0480f,-0.9951f,-0.0864f, -0.0590f,-0.9968f,0.0545f, -0.0528f,-0.9980f,0.0355f, -0.0590f,-0.9968f,0.0545f, -0.3786f,0.8881f,0.2606f, -0.0409f,0.9013f,0.4313f, -0.5694f,0.8219f,-0.0170f, 0.2307f,0.9546f,0.1884f, 0.0509f,0.9849f,-0.1657f, 
	0.3269f,0.8533f,0.4063f, -0.6160f,0.6879f,-0.3838f, -0.5283f,0.4469f,-0.7219f, -0.1618f,0.7978f,-0.5808f, -0.2176f,0.4007f,-0.8900f, -0.5694f,0.8219f,-0.0170f, 0.0509f,0.9849f,-0.1657f, -0.0389f,0.7441f,-0.6669f, -0.0319f,0.6985f,-0.7149f, -0.0957f,0.3194f,-0.9428f, -0.1365f,0.3658f,-0.9206f, 0.1647f,0.9629f,-0.2138f, 0.1242f,0.9670f,-0.2223f, 0.3002f,0.9339f,0.1942f, 0.3591f,0.8311f,0.4246f, 
	0.3161f,0.8180f,0.4807f, 0.2768f,0.9330f,0.2299f, 0.1647f,0.9629f,-0.2138f, 0.1242f,0.9670f,-0.2223f, 0.5297f,-0.1706f,0.8309f, 0.5458f,0.4888f,0.6806f, 0.4279f,-0.2477f,0.8692f, 0.4754f,0.4506f,0.7556f, 0.4130f,0.7341f,0.5390f, 0.4077f,0.7334f,0.5440f, 0.3804f,0.7069f,0.5963f, 0.3399f,0.6585f,0.6714f, 0.4338f,0.3527f,0.8291f, 0.3287f,0.2109f,0.9206f, 0.3274f,-0.4122f,0.8502f, 
	0.1918f,-0.5565f,0.8084f, -0.2131f,-0.0498f,-0.9758f, -0.1028f,-0.4895f,-0.8659f, -0.1449f,-0.0412f,-0.9886f, -0.0823f,-0.5223f,-0.8487f, -0.0865f,-0.8340f,-0.5449f, -0.0495f,-0.8625f,-0.5036f, -0.0395f,-0.8954f,-0.4435f, -0.0511f,-0.9239f,-0.3793f, -0.0589f,-0.5665f,-0.8220f, -0.0720f,-0.6119f,-0.7877f, -0.1107f,-0.0647f,-0.9917f, -0.0899f,-0.0957f,-0.9913f, 0.1885f,0.9428f,0.2749f, 0.2455f,0.8002f,0.5471f, 
	0.0661f,0.9736f,-0.2183f, 0.1045f,0.9403f,0.3239f, -0.0101f,0.9822f,-0.1875f, 0.1467f,0.7789f,0.6098f, -0.0574f,0.6913f,-0.7203f, -0.0992f,0.3074f,-0.9464f, -0.1036f,0.6977f,-0.7089f, -0.1297f,0.3204f,-0.9384f, -0.1794f,0.7198f,-0.6706f, -0.2857f,0.7382f,-0.6111f, -0.3172f,0.3711f,-0.8727f, -0.1980f,0.3392f,-0.9196f, -0.1075f,0.9841f,-0.1412f, -0.1960f,0.9757f,-0.0983f, -0.0027f,0.9292f,0.3695f, 
	0.0518f,0.7462f,0.6637f, -0.0329f,0.7286f,0.6842f, -0.0932f,0.9116f,0.4005f, -0.1029f,-0.1071f,-0.9889f, -0.0879f,-0.6492f,-0.7556f, -0.1362f,-0.1175f,-0.9837f, -0.1286f,-0.6793f,-0.7225f, -0.0687f,-0.9426f,-0.3266f, -0.0642f,-0.9967f,-0.0499f, -0.0933f,-0.9553f,-0.2804f, -0.0707f,-0.9970f,-0.0319f, -0.1158f,-0.9610f,-0.2512f, -0.1472f,-0.9629f,-0.2262f, -0.0888f,-0.9960f,-0.0104f, -0.0812f,-0.9966f,-0.0170f, 
	-0.1845f,-0.7016f,-0.6883f, -0.2669f,-0.7077f,-0.6541f, -0.2175f,-0.1226f,-0.9683f, -0.3334f,-0.1139f,-0.9359f, -0.0608f,-0.9962f,0.0630f, -0.0605f,-0.9912f,0.1181f, -0.0656f,-0.9953f,0.0714f, -0.0606f,-0.9913f,0.1167f, -0.0473f,-0.9834f,0.1753f, -0.0152f,-0.9419f,0.3354f, -0.0538f,-0.9842f,0.1686f, -0.0297f,-0.9494f,0.3128f, -0.0554f,-0.9847f,0.1651f, -0.0568f,-0.9850f,0.1629f, -0.0492f,-0.9536f,0.2970f, 
	-0.0442f,-0.9528f,0.3005f, -0.0620f,-0.9913f,0.1162f, -0.0622f,-0.9914f,0.1155f, -0.0672f,-0.9950f,0.0734f, -0.0694f,-0.9947f,0.0752f, 0.1101f,-0.6650f,0.7387f, 0.2319f,0.0462f,0.9716f, 0.0255f,-0.7324f,0.6804f, 0.1245f,-0.0613f,0.9903f, 0.2420f,0.6086f,0.7557f, 0.1566f,0.5336f,0.8311f, 0.0577f,0.4823f,0.8741f, -0.0128f,0.4490f,0.8934f, 0.0380f,-0.1490f,0.9881f, -0.0198f,-0.1684f,0.9855f, 
	-0.0113f,-0.7578f,0.6524f, -0.0385f,-0.7680f,0.6393f, -0.1696f,0.8969f,0.4083f, -0.0973f,0.7202f,0.6869f, -0.2994f,0.9532f,-0.0422f, -0.2620f,0.8767f,0.4034f, -0.3926f,0.9197f,0.0061f, -0.1679f,0.7296f,0.6629f, -0.4037f,0.7466f,-0.5288f, -0.4503f,0.4047f,-0.7959f, -0.5193f,0.7498f,-0.4101f, -0.5700f,0.4606f,-0.6804f, -0.5919f,0.7510f,-0.2927f, -0.6513f,0.5344f,-0.5387f, -0.4935f,0.8676f,0.0608f, 
	-0.3476f,0.8592f,0.3754f, -0.2495f,0.7548f,0.6066f, -0.4765f,-0.0830f,-0.8753f, -0.3611f,-0.7031f,-0.6125f, -0.6036f,-0.0214f,-0.7970f, -0.4728f,-0.6715f,-0.5706f, -0.1807f,-0.9621f,-0.2042f, -0.0983f,-0.9952f,-0.0018f, -0.2248f,-0.9566f,-0.1855f, -0.1140f,-0.9935f,0.0055f, -0.2781f,-0.9491f,-0.1477f, -0.1447f,-0.9893f,0.0171f, -0.5968f,-0.6378f,-0.4869f, -0.7430f,0.0508f,-0.6674f, -0.0720f,-0.9944f,0.0776f, 
	-0.0639f,-0.9911f,0.1164f, -0.0789f,-0.9935f,0.0820f, -0.0695f,-0.9903f,0.1207f, -0.0588f,-0.9848f,0.1636f, -0.0556f,-0.9532f,0.2972f, -0.0654f,-0.9836f,0.1683f, -0.0703f,-0.9492f,0.3068f, -0.0840f,-0.9786f,0.1877f, -0.1014f,-0.9407f,0.3238f, -0.0840f,-0.9879f,0.1301f, -0.0981f,-0.9914f,0.0872f, -0.0600f,-0.7640f,0.6425f, -0.0623f,-0.1667f,0.9840f, -0.0946f,-0.7495f,0.6552f, -0.1244f,-0.1396f,0.9824f, 
	-0.0710f,0.4493f,0.8906f, -0.1296f,0.4734f,0.8713f, -0.2312f,0.4812f,0.8455f, -0.2164f,-0.1482f,0.9650f, -0.1434f,-0.7508f,0.6448f, 
_NULL_ }; /* End of object02_Normals */

const unsigned short object02_Faces[] = {
	0, 2, 1, 3, 2, 0, 0, 5, 4, 1, 5, 0, 0, 7, 6, 4, 7, 0, 0, 8, 3, 6, 8, 0, 9, 11, 10, 12, 11, 9, 
	9, 14, 13, 10, 14, 9, 9, 7, 4, 13, 7, 9, 9, 5, 12, 4, 5, 9, 15, 17, 16, 18, 17, 15, 15, 20, 19, 16, 20, 15, 
	15, 7, 13, 19, 7, 15, 15, 14, 18, 13, 14, 15, 21, 23, 22, 24, 23, 21, 21, 8, 6, 22, 8, 21, 21, 7, 19, 6, 7, 21, 
	21, 20, 24, 19, 20, 21, 25, 27, 26, 28, 27, 25, 25, 30, 29, 26, 30, 25, 25, 32, 31, 29, 32, 25, 25, 33, 28, 31, 33, 25, 
	34, 2, 3, 35, 2, 34, 34, 8, 36, 3, 8, 34, 34, 32, 29, 36, 32, 34, 34, 30, 35, 29, 30, 34, 37, 23, 38, 22, 23, 37, 
	37, 40, 39, 38, 40, 37, 37, 32, 36, 39, 32, 37, 37, 8, 22, 36, 8, 37, 41, 43, 42, 44, 43, 41, 41, 33, 31, 42, 33, 41, 
	41, 32, 39, 31, 32, 41, 41, 40, 44, 39, 40, 41, 45, 47, 46, 46, 48, 45, 49, 51, 50, 52, 47, 45, 53, 55, 54, 56, 55, 53, 
	53, 58, 57, 54, 58, 53, 53, 47, 52, 57, 47, 53, 59, 51, 60, 50, 51, 59, 61, 63, 62, 64, 63, 61, 61, 48, 46, 62, 48, 61, 
	61, 47, 57, 46, 47, 61, 61, 58, 64, 57, 58, 61, 49, 66, 65, 65, 51, 49, 49, 68, 67, 67, 66, 49, 69, 71, 70, 72, 71, 69, 
	69, 74, 73, 70, 74, 69, 69, 66, 67, 73, 66, 69, 69, 68, 72, 67, 68, 69, 75, 55, 56, 76, 55, 75, 77, 51, 65, 60, 51, 77, 
	77, 66, 73, 65, 66, 77, 75, 78, 76, 79, 78, 75, 49, 81, 80, 80, 68, 49, 49, 83, 82, 82, 81, 49, 84, 86, 85, 87, 86, 84, 
	84, 89, 88, 85, 89, 84, 84, 81, 82, 88, 81, 84, 84, 83, 87, 82, 83, 84, 90, 71, 72, 91, 71, 90, 90, 68, 80, 72, 68, 90, 
	90, 81, 88, 80, 81, 90, 90, 89, 91, 88, 89, 90, 45, 93, 92, 92, 94, 45, 45, 48, 95, 95, 93, 45, 96, 63, 97, 62, 63, 96, 
	96, 99, 98, 97, 99, 96, 96, 93, 95, 98, 93, 96, 96, 48, 62, 95, 48, 96, 100, 102, 101, 103, 102, 100, 100, 94, 92, 101, 94, 100, 
	100, 93, 98, 92, 93, 100, 100, 99, 103, 98, 99, 100, 49, 105, 104, 104, 83, 49, 49, 107, 106, 106, 105, 49, 108, 110, 109, 111, 110, 108, 
	112, 114, 113, 109, 115, 108, 112, 105, 106, 113, 105, 112, 108, 116, 111, 106, 107, 112, 117, 86, 87, 118, 86, 117, 117, 83, 104, 87, 83, 117, 
	117, 105, 113, 104, 105, 117, 117, 114, 118, 113, 114, 117, 45, 120, 119, 119, 116, 45, 45, 94, 121, 121, 120, 45, 122, 102, 123, 101, 102, 122, 
	122, 125, 124, 123, 125, 122, 122, 120, 121, 124, 120, 122, 122, 94, 101, 121, 94, 122, 126, 110, 111, 127, 110, 126, 126, 116, 119, 111, 116, 126, 
	126, 120, 124, 119, 120, 126, 126, 125, 127, 124, 125, 126, 128, 63, 64, 129, 63, 128, 128, 58, 130, 64, 58, 128, 128, 132, 131, 130, 132, 128, 
	128, 133, 129, 131, 133, 128, 134, 55, 135, 54, 55, 134, 134, 137, 136, 135, 137, 134, 134, 132, 130, 136, 132, 134, 134, 58, 54, 130, 58, 134, 
	138, 11, 12, 139, 11, 138, 138, 5, 140, 12, 5, 138, 138, 132, 136, 140, 132, 138, 138, 137, 139, 136, 137, 138, 141, 2, 142, 1, 2, 141, 
	141, 133, 131, 142, 133, 141, 141, 132, 140, 131, 132, 141, 141, 5, 1, 140, 5, 141, 143, 145, 144, 146, 145, 143, 143, 148, 147, 144, 148, 143, 
	143, 150, 149, 147, 150, 143, 143, 151, 146, 149, 151, 143, 152, 154, 153, 155, 154, 152, 152, 157, 156, 153, 157, 152, 152, 150, 147, 156, 150, 152, 
	152, 148, 155, 147, 148, 152, 158, 160, 159, 161, 160, 158, 158, 163, 162, 159, 163, 158, 158, 150, 156, 162, 150, 158, 158, 157, 161, 156, 157, 158, 
	164, 166, 165, 167, 166, 164, 164, 151, 149, 165, 151, 164, 164, 150, 162, 149, 150, 164, 164, 163, 167, 162, 163, 164, 168, 71, 91, 169, 71, 168, 
	168, 89, 170, 91, 89, 168, 168, 172, 171, 170, 172, 168, 168, 173, 169, 171, 173, 168, 174, 86, 175, 85, 86, 174, 174, 177, 176, 175, 177, 174, 
	174, 172, 170, 176, 172, 174, 174, 89, 85, 170, 89, 174, 178, 180, 179, 181, 180, 178, 178, 183, 182, 179, 183, 178, 178, 172, 176, 182, 172, 178, 
	178, 177, 181, 176, 177, 178, 184, 186, 185, 187, 186, 184, 184, 173, 171, 185, 173, 184, 184, 172, 182, 171, 172, 184, 184, 183, 187, 182, 183, 184, 
	188, 102, 103, 189, 102, 188, 188, 99, 190, 103, 99, 188, 188, 192, 191, 190, 192, 188, 188, 193, 189, 191, 193, 188, 194, 63, 129, 97, 63, 194, 
	194, 133, 195, 129, 133, 194, 194, 192, 190, 195, 192, 194, 194, 99, 97, 190, 99, 194, 196, 2, 35, 142, 2, 196, 196, 30, 197, 35, 30, 196, 
	196, 192, 195, 197, 192, 196, 196, 133, 142, 195, 133, 196, 198, 27, 199, 26, 27, 198, 198, 193, 191, 199, 193, 198, 198, 192, 197, 191, 192, 198, 
	198, 30, 26, 197, 30, 198, 200, 86, 118, 175, 86, 200, 200, 114, 201, 118, 114, 200, 200, 203, 202, 201, 203, 200, 200, 177, 175, 202, 177, 200, 
	204, 110, 205, 109, 110, 204, 204, 207, 206, 205, 207, 204, 204, 209, 208, 206, 209, 204, 204, 115, 109, 208, 115, 204, 210, 43, 44, 211, 43, 210, 
	210, 40, 212, 44, 40, 210, 210, 209, 206, 212, 209, 210, 210, 207, 211, 206, 207, 210, 213, 23, 214, 38, 23, 213, 215, 177, 202, 181, 177, 215, 
	213, 209, 212, 216, 209, 213, 213, 40, 38, 212, 40, 213, 217, 110, 127, 205, 110, 217, 217, 125, 218, 127, 125, 217, 217, 220, 219, 218, 220, 217, 
	217, 207, 205, 219, 207, 217, 221, 102, 189, 123, 102, 221, 221, 193, 222, 189, 193, 221, 221, 220, 218, 222, 220, 221, 221, 125, 123, 218, 125, 221, 
	223, 27, 28, 199, 27, 223, 223, 33, 224, 28, 33, 223, 223, 220, 222, 224, 220, 223, 223, 193, 199, 222, 193, 223, 225, 43, 211, 42, 43, 225, 
	225, 207, 219, 211, 207, 225, 225, 220, 224, 219, 220, 225, 225, 33, 42, 224, 33, 225, 226, 17, 18, 227, 186, 228, 226, 14, 229, 18, 14, 226, 
	226, 231, 230, 229, 231, 226, 228, 232, 227, 233, 232, 228, 234, 11, 235, 10, 11, 234, 234, 237, 236, 235, 237, 234, 234, 231, 229, 236, 231, 234, 
	234, 14, 10, 229, 14, 234, 238, 240, 239, 241, 240, 238, 238, 243, 242, 239, 243, 238, 238, 231, 236, 242, 231, 238, 238, 237, 241, 236, 237, 238, 
	244, 246, 245, 247, 246, 244, 244, 232, 233, 245, 232, 244, 248, 231, 242, 230, 231, 248, 248, 243, 249, 242, 243, 248, 250, 55, 76, 251, 55, 250, 
	250, 78, 252, 76, 78, 250, 250, 254, 253, 252, 254, 250, 250, 255, 251, 253, 255, 250, 256, 71, 257, 70, 71, 256, 256, 259, 258, 257, 259, 256, 
	256, 261, 260, 258, 261, 256, 256, 74, 70, 260, 74, 256, 262, 264, 263, 265, 264, 262, 262, 267, 266, 263, 267, 262, 262, 261, 258, 266, 261, 262, 
	262, 259, 265, 258, 259, 262, 268, 270, 269, 271, 270, 268, 268, 255, 253, 269, 255, 268, 268, 254, 272, 253, 254, 268, 268, 273, 271, 272, 273, 268, 
	274, 11, 139, 235, 11, 274, 274, 137, 275, 139, 137, 274, 274, 277, 276, 275, 277, 274, 274, 237, 235, 276, 237, 274, 278, 55, 251, 135, 55, 278, 
	278, 255, 279, 251, 255, 278, 278, 277, 275, 279, 277, 278, 278, 137, 135, 275, 137, 278, 280, 270, 281, 269, 270, 280, 280, 283, 282, 281, 283, 280, 
	280, 277, 279, 282, 277, 280, 280, 255, 269, 279, 255, 280, 284, 240, 241, 285, 240, 284, 284, 237, 276, 241, 237, 284, 284, 277, 282, 276, 277, 284, 
	284, 283, 285, 282, 283, 284, 286, 71, 169, 257, 71, 286, 286, 173, 287, 169, 173, 286, 286, 289, 288, 287, 289, 286, 286, 259, 257, 288, 259, 286, 
	290, 186, 227, 185, 186, 290, 290, 232, 291, 227, 232, 290, 290, 289, 287, 291, 289, 290, 290, 173, 185, 287, 173, 290, 292, 246, 293, 245, 246, 292, 
	292, 295, 294, 293, 295, 292, 292, 289, 291, 294, 289, 292, 292, 232, 245, 291, 232, 292, 296, 264, 265, 297, 264, 296, 296, 259, 288, 265, 259, 296, 
	296, 289, 294, 288, 289, 296, 296, 295, 297, 294, 295, 296, 298, 270, 271, 299, 270, 298, 298, 267, 300, 271, 273, 298, 298, 302, 301, 300, 302, 298, 
	298, 303, 299, 301, 303, 298, 304, 264, 305, 263, 264, 304, 304, 307, 306, 305, 307, 304, 304, 302, 300, 306, 302, 304, 304, 267, 263, 300, 267, 304, 
	308, 310, 309, 311, 310, 308, 308, 313, 312, 309, 313, 308, 308, 302, 306, 312, 302, 308, 308, 307, 311, 306, 307, 308, 314, 316, 315, 317, 316, 314, 
	314, 303, 301, 315, 303, 314, 314, 302, 312, 301, 302, 314, 314, 313, 317, 312, 313, 314, 318, 264, 297, 305, 264, 318, 318, 295, 319, 297, 295, 318, 
	318, 321, 320, 319, 321, 318, 318, 307, 305, 320, 307, 318, 322, 246, 323, 293, 246, 322, 322, 325, 324, 323, 325, 322, 322, 321, 319, 324, 321, 322, 
	322, 295, 293, 319, 295, 322, 326, 328, 327, 329, 328, 326, 326, 331, 330, 327, 331, 326, 326, 321, 324, 330, 321, 326, 326, 325, 329, 324, 325, 326, 
	332, 310, 311, 333, 310, 332, 332, 307, 320, 311, 307, 332, 332, 321, 330, 320, 321, 332, 332, 331, 333, 330, 331, 332, 334, 246, 247, 323, 246, 334, 
	334, 243, 335, 247, 243, 334, 334, 337, 336, 335, 337, 334, 334, 325, 323, 336, 325, 334, 338, 240, 339, 239, 240, 338, 338, 341, 340, 339, 341, 338, 
	338, 337, 335, 340, 337, 338, 338, 243, 239, 335, 243, 338, 342, 344, 343, 345, 344, 342, 342, 347, 346, 343, 347, 342, 342, 337, 340, 346, 337, 342, 
	342, 341, 345, 340, 341, 342, 348, 328, 329, 349, 328, 348, 348, 325, 336, 329, 325, 348, 348, 337, 346, 336, 337, 348, 348, 347, 349, 346, 347, 348, 
	350, 240, 285, 339, 240, 350, 350, 283, 351, 285, 283, 350, 350, 353, 352, 351, 353, 350, 350, 341, 339, 352, 341, 350, 354, 270, 299, 281, 270, 354, 
	354, 303, 355, 299, 303, 354, 354, 353, 351, 355, 353, 354, 354, 283, 281, 351, 283, 354, 356, 316, 357, 315, 316, 356, 356, 359, 358, 357, 359, 356, 
	356, 353, 355, 358, 353, 356, 356, 303, 315, 355, 303, 356, 360, 344, 345, 361, 344, 360, 360, 341, 352, 345, 341, 360, 360, 353, 358, 352, 353, 360, 
	360, 359, 361, 358, 359, 360, 362, 316, 317, 363, 316, 362, 362, 313, 364, 317, 313, 362, 362, 366, 365, 364, 366, 362, 362, 367, 363, 365, 367, 362, 
	368, 310, 369, 309, 310, 368, 368, 371, 370, 369, 371, 368, 368, 366, 364, 370, 366, 368, 368, 313, 309, 364, 313, 368, 372, 154, 155, 373, 154, 372, 
	372, 148, 374, 155, 148, 372, 372, 366, 370, 374, 366, 372, 372, 371, 373, 370, 371, 372, 375, 145, 376, 144, 145, 375, 375, 367, 365, 376, 367, 375, 
	375, 366, 374, 365, 366, 375, 375, 148, 144, 374, 148, 375, 377, 310, 333, 369, 310, 377, 377, 331, 378, 333, 331, 377, 377, 380, 379, 378, 380, 377, 
	377, 371, 369, 379, 371, 377, 381, 328, 382, 327, 328, 381, 381, 384, 383, 382, 384, 381, 381, 380, 378, 383, 380, 381, 381, 331, 327, 378, 331, 381, 
	385, 160, 161, 386, 160, 385, 385, 157, 387, 161, 157, 385, 385, 380, 383, 387, 380, 385, 385, 384, 386, 383, 384, 385, 388, 154, 373, 153, 154, 388, 
	388, 371, 379, 373, 371, 388, 388, 380, 387, 379, 380, 388, 388, 157, 153, 387, 157, 388, 389, 328, 349, 382, 328, 389, 389, 347, 390, 349, 347, 389, 
	389, 392, 391, 390, 392, 389, 389, 384, 382, 391, 384, 389, 393, 344, 394, 343, 344, 393, 393, 396, 395, 394, 396, 393, 393, 392, 390, 395, 392, 393, 
	393, 347, 343, 390, 347, 393, 397, 166, 167, 398, 166, 397, 397, 163, 399, 167, 163, 397, 397, 392, 395, 399, 392, 397, 397, 396, 398, 395, 396, 397, 
	400, 160, 386, 159, 160, 400, 400, 384, 391, 386, 384, 400, 400, 392, 399, 391, 392, 400, 400, 163, 159, 399, 163, 400, 401, 344, 361, 394, 344, 401, 
	401, 359, 402, 361, 359, 401, 401, 404, 403, 402, 404, 401, 401, 396, 394, 403, 396, 401, 405, 316, 363, 357, 316, 405, 405, 367, 406, 363, 367, 405, 
	405, 404, 402, 406, 404, 405, 405, 359, 357, 402, 359, 405, 407, 145, 146, 376, 145, 407, 407, 151, 408, 146, 151, 407, 407, 404, 406, 408, 404, 407, 
	407, 367, 376, 406, 367, 407, 409, 166, 398, 165, 166, 409, 409, 396, 403, 398, 396, 409, 409, 404, 408, 403, 404, 409, 409, 151, 165, 408, 151, 409, 
	
_NULL_ }; /* End of object02_Faces */


/* MESH 5 */

#define object01_NumVertex  402
#define object01_NumFaces   760
#define object01_NumStrips  0
#define object01_Flags      0x00020006
#define object01_Material   0

const float object01_Vertices[] = {
	140.7919f,0.9803f,18.3770f, 140.7361f,1.7256f,14.9732f, 137.8813f,-0.3081f,17.3107f, 138.0477f,-0.8653f,20.5305f, 141.1782f,2.5254f,11.8937f, 
	138.1832f,0.3063f,14.3702f, 134.1456f,-1.5321f,17.6231f, 134.1558f,-1.9893f,20.2497f, 134.5704f,-2.4025f,23.1577f, 142.2709f,3.8318f,6.6015f, 
	138.9037f,1.3705f,9.2447f, 138.6289f,0.8924f,11.6926f, 141.7897f,3.2610f,9.1233f, 134.2169f,-0.7302f,13.0004f, 134.2585f,-1.0926f,15.2262f, 
	124.3868f,-2.7662f,21.0677f, 125.0640f,-2.9727f,22.6728f, 129.4924f,-2.4891f,19.0795f, 129.1058f,-2.2275f,17.1546f, 125.7025f,-3.3203f,24.3051f, 
	129.7751f,-2.8350f,21.1007f, 127.4855f,-4.1375f,28.3366f, 130.8934f,-3.5586f,25.8770f, 130.1693f,-3.2108f,23.3322f, 126.4584f,-3.7360f,26.1407f, 
	142.9151f,-0.3063f,30.6084f, 143.1479f,-0.1874f,28.5077f, 141.0049f,-1.6065f,30.1954f, 141.5651f,-1.3423f,32.3925f, 142.7167f,0.0522f,25.5441f, 
	140.1833f,-1.5234f,27.3457f, 137.0387f,-2.8593f,29.4959f, 138.3122f,-2.8050f,32.1668f, 139.2324f,-2.4632f,34.2959f, 139.0120f,-1.2745f,24.0241f, 
	141.6915f,0.4288f,22.0575f, 135.6720f,-2.7085f,26.3894f, 128.9268f,-4.4299f,31.0177f, 132.1650f,-3.8170f,28.8229f, 130.6043f,-4.5016f,33.5341f, 
	133.6952f,-3.9014f,31.6225f, 133.9722f,-3.7373f,36.1642f, 136.3856f,-3.3066f,35.5972f, 135.2704f,-3.7193f,33.8405f, 132.4158f,-4.2331f,35.3135f, 
	119.7944f,33.3690f,14.8544f, 123.5970f,34.2911f,17.1102f, 118.3556f,31.5281f,27.0465f, 127.6579f,35.1188f,20.8941f, 113.8290f,31.5683f,14.4109f, 
	116.5879f,32.4714f,14.0013f, 131.3140f,16.8498f,15.5689f, 132.9079f,17.0622f,14.8611f, 128.4312f,22.0893f,16.4611f, 127.0584f,20.7841f,17.5443f, 
	133.5963f,17.5219f,15.2731f, 128.7942f,24.0059f,16.4619f, 134.2698f,18.6967f,19.1806f, 127.8892f,29.5683f,19.7791f, 128.5140f,26.5944f,17.5082f, 
	133.9446f,18.1242f,16.6676f, 108.7013f,29.5052f,18.5346f, 111.2113f,30.5558f,16.1601f, 104.8068f,27.7568f,23.2546f, 106.4054f,28.5136f,20.9747f, 
	116.6566f,10.9920f,28.2865f, 118.5577f,14.6744f,26.1458f, 117.6852f,17.3231f,26.0171f, 115.6577f,15.8792f,28.2127f, 121.8398f,16.8259f,23.1536f, 
	120.6118f,18.9830f,23.1578f, 124.1329f,19.9720f,20.0235f, 126.0939f,17.6736f,19.5361f, 105.4488f,27.5117f,27.1395f, 104.5552f,27.4576f,25.1872f, 
	110.0804f,28.3728f,32.1793f, 107.3796f,27.8503f,29.4186f, 118.6174f,8.3425f,32.5297f, 117.4072f,8.7598f,31.1032f, 114.4067f,16.6921f,31.6642f, 
	114.9538f,18.0030f,33.0944f, 116.6921f,9.2427f,30.1295f, 114.3267f,15.7834f,30.5815f, 114.6619f,15.4548f,29.5723f, 116.4161f,9.8762f,29.3139f, 
	131.4972f,35.2654f,30.0307f, 130.5872f,34.5455f,33.8564f, 128.3804f,33.5381f,36.6759f, 130.5236f,35.4853f,25.4661f, 135.0755f,18.8423f,22.4838f, 
	127.6859f,31.7083f,22.9570f, 135.9757f,18.4194f,26.1205f, 127.7820f,32.4611f,26.5571f, 136.0673f,15.9613f,32.6962f, 127.4634f,30.1207f,32.9590f, 
	127.8424f,31.7942f,29.9959f, 136.4583f,17.4305f,29.6074f, 114.1564f,29.0121f,37.6507f, 112.3967f,28.7558f,35.1163f, 117.1320f,29.6409f,40.2276f, 
	115.5611f,29.2512f,39.3718f, 126.3069f,8.6370f,39.4420f, 123.9928f,7.8682f,38.6266f, 118.6855f,20.4930f,38.5618f, 120.4230f,21.5120f,39.1801f, 
	121.9595f,7.6753f,36.8669f, 117.1539f,19.7937f,37.0683f, 115.8789f,19.0379f,35.0591f, 120.1537f,7.9054f,34.6272f, 122.5018f,31.3424f,39.9219f, 
	119.5687f,30.3747f,40.4235f, 125.5621f,32.4337f,38.6852f, 134.4216f,14.0625f,35.4439f, 126.2512f,27.9333f,35.5121f, 131.9563f,12.0190f,37.6308f, 
	124.4866f,25.5545f,37.5021f, 122.4503f,23.3066f,38.7759f, 129.1064f,10.1156f,39.0368f, 138.4275f,11.6577f,15.0809f, 139.0225f,10.9640f,17.9040f, 
	138.0693f,12.2199f,13.1199f, 140.9749f,8.1605f,11.5212f, 140.9732f,7.2131f,14.0698f, 141.3785f,6.2014f,17.2184f, 137.5794f,12.8570f,10.6932f, 
	137.6790f,12.6494f,11.8955f, 141.4455f,9.4241f,7.5147f, 141.1471f,8.9268f,9.4508f, 142.5393f,5.8627f,8.4715f, 143.0328f,6.4520f,6.1081f, 
	142.0206f,5.0437f,11.0469f, 141.8631f,3.1584f,17.3508f, 141.7020f,4.0944f,13.9847f, 114.1987f,5.9808f,-26.2975f, 111.2582f,5.6432f,-25.5248f, 
	111.3248f,3.4913f,-27.3837f, 114.9225f,4.6821f,-27.6496f, 107.3908f,4.4985f,-23.5334f, 107.8327f,2.2783f,-25.7818f, 108.4242f,1.0725f,-26.4103f, 
	111.7594f,2.2437f,-27.8216f, 115.5605f,3.4279f,-27.9787f, 102.8027f,1.4001f,-19.0854f, 102.8180f,0.0164f,-19.9868f, 104.9310f,1.0025f,-23.2113f, 
	104.2883f,2.7731f,-21.0104f, 103.4183f,-1.0137f,-20.4682f, 105.6236f,-0.0311f,-23.9016f, 104.9310f,1.0025f,-23.2113f, 105.6236f,-0.0311f,-23.9016f, 
	104.2883f,2.7731f,-21.0104f, 105.7058f,-1.5455f,-20.1653f, 107.5129f,-0.9118f,-22.3373f, 106.6000f,-0.5464f,-23.6397f, 104.5109f,-1.4694f,-20.4154f, 
	110.2414f,0.0277f,-24.4708f, 109.1985f,0.4143f,-25.9087f, 106.6000f,-0.5464f,-23.6397f, 107.5129f,-0.9118f,-22.3373f, 115.9399f,1.9202f,-26.0521f, 
	115.9127f,2.5118f,-27.2006f, 112.2860f,1.4625f,-27.1090f, 113.3580f,1.0616f,-25.7100f, 117.8561f,4.5982f,28.5254f, 117.3083f,4.9906f,27.6083f, 
	118.5715f,3.7145f,29.3719f, 120.4741f,-0.1634f,28.2165f, 119.5672f,0.5186f,27.1928f, 118.7668f,0.8178f,26.1158f, 121.0935f,1.6956f,31.9587f, 
	119.6341f,2.7240f,30.4231f, 123.0429f,-1.9537f,31.1561f, 121.6097f,-1.0391f,29.4543f, 123.7615f,-3.0556f,28.0812f, 125.0325f,-3.6787f,30.0000f, 
	122.7480f,-2.4404f,26.5783f, 121.0664f,-1.7474f,23.9646f, 121.8899f,-1.9691f,25.2832f, 141.9894f,8.4810f,28.7410f, 141.5594f,7.2907f,32.0400f, 
	141.3481f,9.4282f,25.1180f, 143.6051f,4.6263f,24.6171f, 144.1888f,3.9139f,28.1751f, 143.7077f,2.9930f,31.4577f, 140.1641f,10.2330f,21.3817f, 
	142.4522f,5.3553f,20.8611f, 142.8128f,2.4393f,21.0726f, 143.8558f,1.8962f,24.7131f, 143.7197f,0.7851f,30.9537f, 144.2653f,1.4518f,27.9535f, 
	122.8228f,0.8592f,34.1767f, 124.8241f,0.4155f,36.5284f, 126.7116f,-2.9544f,35.8909f, 124.7419f,-2.6379f,33.4951f, 129.8549f,1.1406f,39.3231f, 
	127.1331f,0.4916f,38.4100f, 131.7844f,-2.1978f,38.6655f, 128.9959f,-2.8078f,37.7567f, 130.5086f,-4.0416f,36.6231f, 133.0953f,-3.4501f,37.4336f, 
	128.4510f,-4.2871f,34.8951f, 126.6208f,-4.1291f,32.4863f, 133.1984f,2.3921f,38.8915f, 136.6238f,3.9991f,37.3664f, 138.7379f,0.1703f,36.7333f, 
	135.2516f,-1.1498f,38.2325f, 139.5908f,5.7143f,34.9988f, 141.7088f,1.6397f,34.4085f, 141.9516f,-0.3849f,33.6742f, 139.4173f,-1.6213f,35.7394f, 
	136.3257f,-2.6257f,37.0495f, 128.3981f,-2.1037f,15.2016f, 123.5059f,-2.7728f,19.2914f, 133.7429f,-0.5032f,10.8812f, 132.8218f,-0.3865f,8.7329f, 
	127.3147f,-2.0845f,13.0955f, 122.3156f,-2.9284f,17.2200f, 142.3345f,4.1449f,4.2338f, 138.6962f,1.6632f,6.9802f, 141.9603f,4.2647f,1.8721f, 
	138.0062f,1.8092f,4.7541f, 139.7453f,4.1393f,-3.2335f, 135.1612f,1.8000f,-0.0941f, 136.8286f,1.8434f,2.4355f, 141.1098f,4.2451f,-0.5929f, 
	129.5752f,-0.3890f,3.8373f, 131.4373f,-0.3563f,6.4262f, 118.6030f,-3.4378f,11.7979f, 120.7117f,-3.1721f,14.7477f, 125.8001f,-2.1390f,10.7211f, 
	123.8037f,-2.2359f,7.9745f, 126.9980f,16.8595f,18.5060f, 132.4928f,15.6323f,13.7249f, 122.2486f,16.0737f,22.5538f, 122.0993f,16.1241f,21.2759f, 
	127.3940f,16.8766f,16.7291f, 133.2670f,15.4040f,11.3407f, 116.9055f,9.4735f,26.7356f, 118.7218f,13.5363f,25.4935f, 116.3158f,8.5515f,24.9879f, 
	118.2771f,13.1017f,24.1281f, 112.2738f,6.7547f,18.8201f, 114.3890f,13.2167f,18.2820f, 116.9408f,13.0567f,21.9219f, 114.8480f,7.6878f,22.4915f, 
	119.5328f,18.1326f,14.9769f, 121.2920f,16.8454f,18.9730f, 134.0753f,16.0772f,3.0546f, 133.8607f,15.6185f,7.8800f, 127.4358f,17.5948f,13.8071f, 
	126.9483f,18.8588f,9.1521f, 143.3071f,6.7239f,3.7413f, 141.8704f,9.5774f,5.2814f, 142.2558f,9.5138f,2.6035f, 143.2922f,6.7687f,1.2148f, 
	138.0703f,12.7578f,8.7784f, 138.8113f,12.5404f,6.0786f, 139.5439f,12.2909f,-1.7994f, 139.3961f,12.4113f,2.5492f, 141.9830f,9.0639f,-4.1852f, 
	142.3747f,9.3295f,-0.5785f, 142.8782f,6.6526f,-1.5535f, 141.9338f,6.4450f,-4.5527f, 116.7402f,4.5447f,26.2608f, 117.9187f,0.5394f,24.6612f, 
	116.7979f,-0.1282f,22.6756f, 115.8527f,3.5995f,24.3374f, 120.1352f,-1.8850f,22.3534f, 118.9355f,-2.2737f,20.3125f, 115.1308f,-3.3760f,14.5410f, 
	117.3115f,-2.8128f,17.7263f, 112.8924f,-1.9574f,16.6018f, 115.1747f,-1.0130f,20.0166f, 114.2739f,2.4828f,21.6866f, 111.8366f,1.2613f,18.0928f, 
	125.7375f,19.8033f,3.3774f, 133.4777f,16.2886f,-2.2917f, 116.9446f,19.1197f,9.5711f, 114.0137f,19.3023f,3.6828f, 123.8448f,19.9789f,-2.4786f, 
	131.9535f,16.0780f,-7.3811f, 108.8994f,5.7881f,14.2350f, 110.9503f,13.1070f,13.3911f, 105.4175f,4.9276f,9.2575f, 107.3752f,12.6121f,7.9686f, 
	114.0137f,19.3023f,3.6828f, 116.9446f,19.1197f,9.5711f, 100.7838f,3.6824f,-0.3699f, 102.8497f,10.6184f,-1.7159f, 104.5503f,11.7514f,2.8655f, 
	102.5740f,4.2415f,4.3666f, 109.5931f,16.9097f,-5.8390f, 111.4549f,18.4911f,-1.5424f, 126.7943f,14.2014f,-15.2919f, 129.6495f,15.3763f,-11.6917f, 
	121.5850f,19.2172f,-7.4188f, 119.2428f,17.6822f,-11.3418f, 111.4549f,18.4911f,-1.5424f, 109.5931f,16.9097f,-5.8390f, 108.6922f,0.2376f,13.8287f, 
	109.9547f,-2.6783f,12.6291f, 106.8515f,-3.1246f,8.2730f, 105.4213f,-0.4765f,9.2054f, 115.9323f,-3.6508f,8.3445f, 112.3392f,-3.7958f,10.8352f, 
	113.0363f,-3.7717f,4.4553f, 109.3510f,-4.0368f,6.7115f, 107.8989f,-3.5922f,-4.4126f, 104.4096f,-3.9099f,-2.5150f, 106.5817f,-4.0785f,2.2499f, 
	110.2514f,-3.7638f,0.1891f, 102.0482f,-3.2123f,-1.1844f, 104.0780f,-3.2925f,3.6603f, 102.6196f,-0.8667f,4.4612f, 100.7136f,-1.0040f,-0.3793f, 
	121.2876f,-2.3425f,4.7687f, 127.2274f,-0.4607f,0.8500f, 121.2876f,-2.3425f,4.7687f, 124.5493f,-0.5417f,-2.5066f, 118.4981f,-2.4196f,1.1487f, 
	118.4981f,-2.4196f,1.1487f, 137.8525f,4.0053f,-6.0763f, 133.0131f,1.7145f,-2.9381f, 135.4544f,3.8333f,-9.1114f, 130.4612f,1.5986f,-6.0801f, 
	129.2331f,3.3338f,-15.7848f, 124.4477f,1.3248f,-13.2128f, 127.5818f,1.4647f,-9.5074f, 132.5754f,3.6130f,-12.3413f, 118.8207f,-0.6128f,-10.2196f, 
	121.6961f,-0.6023f,-6.2048f, 115.6809f,-2.4279f,-2.8432f, 113.0770f,-2.3288f,-7.1709f, 115.6809f,-2.4279f,-2.8432f, 113.0770f,-2.3288f,-7.1709f, 
	140.3517f,6.2332f,-7.6392f, 140.8066f,8.7899f,-7.7967f, 138.8368f,8.4644f,-11.2827f, 138.1371f,5.9868f,-10.7786f, 138.8095f,12.0810f,-6.2316f, 
	137.1323f,11.7206f,-10.3736f, 131.3741f,10.3245f,-17.4233f, 134.6088f,11.1534f,-14.0647f, 132.7187f,7.4451f,-17.8902f, 136.1239f,8.0354f,-14.6176f, 
	135.3096f,5.6718f,-13.9763f, 131.8795f,5.2522f,-17.2822f, 116.8033f,15.5659f,-15.0743f, 123.4594f,12.5495f,-18.7743f, 108.2026f,14.8159f,-10.0477f, 
	107.3388f,11.6268f,-14.9021f, 114.2980f,12.4725f,-18.9990f, 119.7783f,10.3565f,-22.1033f, 100.1036f,3.1140f,-5.3973f, 102.0808f,9.2284f,-6.4328f, 
	100.4442f,2.4934f,-10.7564f, 102.2766f,7.2800f,-11.7828f, 107.3388f,11.6268f,-14.9021f, 108.2026f,14.8159f,-10.0477f, 103.2481f,4.9940f,-17.0590f, 
	101.5688f,1.8602f,-15.8231f, 107.1186f,7.8195f,-19.7784f, 103.2481f,4.9940f,-17.0590f, 107.1186f,7.8195f,-19.7784f, 116.3365f,7.8834f,-24.8787f, 
	112.2306f,8.8361f,-22.6622f, 99.9421f,-1.0003f,-5.5565f, 101.0821f,-2.9280f,-6.3683f, 101.0618f,-2.4582f,-11.5237f, 100.1727f,-0.8444f,-10.8714f, 
	106.2824f,-3.2229f,-9.3328f, 103.1688f,-3.5239f,-7.6097f, 105.4060f,-2.7224f,-13.9122f, 102.7916f,-2.9743f,-12.4741f, 103.2219f,-2.2959f,-16.6652f, 
	105.2680f,-2.1316f,-17.6531f, 101.8691f,-1.8214f,-16.2830f, 101.2212f,-0.5401f,-15.8785f, 110.9210f,-2.0833f,-11.8067f, 116.0732f,-0.5433f,-14.5298f, 
	110.9210f,-2.0833f,-11.8067f, 113.6712f,-0.4121f,-18.5664f, 109.3073f,-1.7405f,-16.1339f, 109.3073f,-1.7405f,-16.1339f, 125.4296f,2.9841f,-19.4794f, 
	121.1259f,1.1908f,-17.1963f, 121.6955f,2.6088f,-22.7446f, 118.0096f,1.0779f,-20.8335f, 115.3602f,0.9971f,-23.6395f, 118.4197f,2.2369f,-24.9968f, 
	111.7327f,-0.2277f,-21.9331f, 108.2792f,-1.3288f,-19.7140f, 108.2792f,-1.3288f,-19.7140f, 127.8242f,4.6880f,-20.7930f, 128.6126f,6.6259f,-21.2951f, 
	124.1708f,5.6451f,-24.3882f, 123.6471f,4.0414f,-23.9035f, 127.4673f,9.1577f,-20.8056f, 123.1276f,7.7101f,-23.9283f, 118.8070f,6.1173f,-26.3876f, 
	119.7589f,4.5704f,-26.7251f, 119.7424f,3.3553f,-26.0690f, 
_NULL_ }; /* End of object01_Vertices */

const float object01_UV[] = {
	0.4864f,0.1024f,0.4736f,0.1035f,0.4951f,0.0979f,0.5043f,0.0975f,0.4572f,0.1045f,0.4820f,0.0982f,0.5155f,0.0961f,0.5223f,0.0959f,0.5261f,0.0958f,0.4201f,0.1055f,0.4493f,0.0985f,0.4663f,0.0984f,0.4389f,0.1053f,0.4971f,0.0962f,0.5067f,0.0962f,
	0.5930f,0.1049f,0.5852f,0.1043f,0.5503f,0.0980f,0.5511f,0.0982f,0.5794f,0.1031f,0.5505f,0.0976f,0.5678f,0.0999f,0.5484f,0.0965f,0.5502f,0.0971f,0.5739f,0.1015f,0.5079f,0.1038f,0.5039f,0.1022f,0.5134f,0.0985f,0.5147f,0.1013f,0.4994f,0.1013f,
	0.5114f,0.0974f,0.5258f,0.0959f,0.5248f,0.0971f,0.5241f,0.0998f,0.5089f,0.0972f,0.4944f,0.1015f,0.5266f,0.0957f,0.5609f,0.0989f,0.5448f,0.0962f,0.5544f,0.0987f,0.5408f,0.0964f,0.5427f,0.1011f,0.5343f,0.0999f,0.5368f,0.0974f,0.5480f,0.0996f,
	0.5579f,0.3076f,0.5081f,0.3100f,0.5769f,0.3105f,0.4965f,0.3130f,0.7615f,0.3048f,0.6844f,0.3059f,0.4890f,0.2009f,0.4770f,0.1994f,0.4992f,0.2348f,0.5167f,0.2302f,0.4754f,0.2015f,0.4925f,0.2451f,0.4878f,0.2108f,0.5011f,0.2805f,0.4938f,0.2609f,
	0.4798f,0.2057f,0.7633f,0.3036f,0.7697f,0.3041f,0.7472f,0.3032f,0.7565f,0.3033f,0.6203f,0.1986f,0.6048f,0.2149f,0.6085f,0.2307f,0.6219f,0.2272f,0.5770f,0.2199f,0.5842f,0.2336f,0.5494f,0.2317f,0.5369f,0.2159f,0.7071f,0.3046f,0.7314f,0.3036f,
	0.6376f,0.3081f,0.6739f,0.3061f,0.6010f,0.1852f,0.6108f,0.1878f,0.6208f,0.2366f,0.6121f,0.2446f,0.6174f,0.1905f,0.6255f,0.2306f,0.6264f,0.2274f,0.6208f,0.1936f,0.5061f,0.3173f,0.5164f,0.3180f,0.5283f,0.3178f,0.4985f,0.3156f,0.4952f,0.2137f,
	0.5091f,0.2957f,0.5017f,0.2135f,0.5164f,0.3031f,0.5155f,0.2057f,0.5308f,0.2964f,0.5233f,0.3025f,0.5081f,0.2106f,0.5971f,0.3116f,0.6123f,0.3100f,0.5789f,0.3137f,0.5876f,0.3127f,0.5602f,0.1834f,0.5700f,0.1813f,0.5816f,0.2588f,0.5723f,0.2629f,
	0.5797f,0.1812f,0.5912f,0.2555f,0.6016f,0.2510f,0.5901f,0.1827f,0.5542f,0.3160f,0.5672f,0.3148f,0.5409f,0.3171f,0.5254f,0.1997f,0.5404f,0.2880f,0.5368f,0.1934f,0.5510f,0.2788f,0.5619f,0.2700f,0.5487f,0.1877f,0.4672f,0.1622f,0.4778f,0.1602f,
	0.4576f,0.1640f,0.4477f,0.1360f,0.4617f,0.1331f,0.4745f,0.1298f,0.4429f,0.1660f,0.4509f,0.1658f,0.4196f,0.1388f,0.4340f,0.1382f,0.4300f,0.1183f,0.4124f,0.1188f,0.4472f,0.1168f,0.4773f,0.1122f,0.4636f,0.1146f,0.0249f,0.1231f,0.0161f,0.1257f,
	0.0168f,0.1118f,0.0272f,0.1136f,0.0036f,0.1261f,0.0061f,0.1110f,0.0073f,0.1029f,0.0174f,0.1039f,0.0282f,0.1055f,0.9850f,0.1187f,0.9856f,0.1101f,0.9956f,0.1099f,0.9921f,0.1227f,0.9868f,0.1031f,0.9973f,0.1026f,-0.0044f,0.1099f,-0.0027f,0.1026f,
	-0.0079f,0.1227f,0.9902f,0.0975f,0.9981f,0.0967f,0.9985f,0.0987f,0.9884f,0.0992f,0.0080f,0.0965f,0.0079f,0.0987f,-0.0015f,0.0987f,-0.0019f,0.0967f,0.0262f,0.0983f,0.0278f,0.1006f,0.0173f,0.0995f,0.0181f,0.0971f,0.6188f,0.1615f,0.6251f,0.1635f,
	0.6127f,0.1564f,0.6066f,0.1311f,0.6146f,0.1352f,0.6235f,0.1369f,0.5946f,0.1442f,0.6046f,0.1504f,0.5884f,0.1205f,0.5980f,0.1259f,0.5885f,0.1106f,0.5801f,0.1072f,0.5964f,0.1139f,0.6142f,0.1175f,0.6045f,0.1165f,0.4997f,0.1525f,0.5072f,0.1494f,
	0.4932f,0.1553f,0.4910f,0.1250f,0.4973f,0.1235f,0.5046f,0.1220f,0.4864f,0.1578f,0.4840f,0.1271f,0.4866f,0.1104f,0.4931f,0.1094f,0.5055f,0.1092f,0.4987f,0.1094f,0.5840f,0.1394f,0.5739f,0.1365f,0.5691f,0.1146f,0.5785f,0.1167f,0.5539f,0.1367f,
	0.5641f,0.1357f,0.5499f,0.1149f,0.5600f,0.1142f,0.5552f,0.1043f,0.5461f,0.1050f,0.5632f,0.1039f,0.5714f,0.1050f,0.5418f,0.1390f,0.5292f,0.1422f,0.5258f,0.1175f,0.5380f,0.1159f,0.5174f,0.1458f,0.5145f,0.1197f,0.5145f,0.1074f,0.5244f,0.1056f,
	0.5351f,0.1052f,0.5560f,0.0980f,0.6059f,0.1043f,0.4879f,0.0961f,0.4777f,0.0960f,0.5691f,0.0976f,0.6292f,0.1031f,0.4003f,0.1050f,0.4313f,0.0983f,0.3770f,0.1040f,0.4090f,0.0980f,0.3019f,0.1014f,0.3124f,0.0971f,0.3750f,0.0975f,0.3461f,0.1027f,
	0.3879f,0.0956f,0.4607f,0.0958f,0.7520f,0.0999f,0.6734f,0.1015f,0.6048f,0.0970f,0.7222f,0.0965f,0.5291f,0.2092f,0.4753f,0.1908f,0.5752f,0.2146f,0.5776f,0.2139f,0.5206f,0.2071f,0.4556f,0.1864f,0.6251f,0.1884f,0.6067f,0.2077f,0.6384f,0.1823f,
	0.6155f,0.2045f,0.7307f,0.1717f,0.7039f,0.2047f,0.6395f,0.2039f,0.6683f,0.1770f,0.6362f,0.2226f,0.5885f,0.2169f,0.3479f,0.1814f,0.4197f,0.1836f,0.5048f,0.2084f,0.4534f,0.2118f,0.3933f,0.1178f,0.4018f,0.1370f,0.3785f,0.1337f,0.3703f,0.1157f,
	0.4279f,0.1630f,0.4041f,0.1583f,0.3156f,0.1487f,0.3681f,0.1536f,0.3047f,0.1252f,0.3468f,0.1296f,0.3406f,0.1130f,0.3010f,0.1103f,0.6350f,0.1605f,0.6363f,0.1350f,0.6575f,0.1309f,0.6528f,0.1545f,0.6283f,0.1165f,0.6516f,0.1139f,0.7558f,0.1073f,
	0.6918f,0.1106f,0.7536f,0.1200f,0.6944f,0.1255f,0.6868f,0.1479f,0.7462f,0.1408f,0.1938f,0.2133f,0.2458f,0.1784f,-0.1563f,0.2265f,-0.0488f,0.2258f,0.0821f,0.2113f,0.1638f,0.1745f,0.8139f,0.1664f,0.8147f,0.2040f,0.8746f,0.1614f,0.8914f,0.2008f,
	0.9512f,0.2258f,0.8437f,0.2265f,0.9304f,0.1514f,0.9449f,0.1864f,0.9262f,0.1949f,0.9088f,0.1567f,0.9831f,0.2092f,0.9744f,0.2197f,0.0830f,0.1632f,0.1146f,0.1695f,0.0544f,0.2053f,0.0399f,0.1961f,-0.0256f,0.2197f,-0.0169f,0.2092f,0.8168f,0.1351f,
	0.8213f,0.1161f,0.8725f,0.1135f,0.8701f,0.1310f,0.8411f,0.0990f,0.8280f,0.1051f,0.8975f,0.0984f,0.8805f,0.1037f,0.9492f,0.0978f,0.9360f,0.1022f,0.9136f,0.1029f,0.9291f,0.0981f,0.9288f,0.1104f,0.9058f,0.1118f,0.9035f,0.1280f,0.9263f,0.1252f,
	0.8836f,0.0961f,0.0629f,0.0954f,-0.1164f,0.0961f,0.0211f,0.0953f,-0.0610f,0.0959f,0.9390f,0.0959f,0.2414f,0.1004f,0.2079f,0.0967f,0.1754f,0.0997f,0.1184f,0.0964f,0.0840f,0.0987f,0.0478f,0.0960f,0.0718f,0.0962f,0.1213f,0.0992f,0.0079f,0.0951f,
	0.0112f,0.0952f,0.9610f,0.0958f,0.9736f,0.0957f,-0.0390f,0.0958f,-0.0264f,0.0957f,0.2513f,0.1083f,0.2548f,0.1219f,0.2019f,0.1193f,0.1961f,0.1068f,0.2543f,0.1443f,0.1949f,0.1406f,0.1070f,0.1337f,0.1456f,0.1373f,0.1121f,0.1154f,0.1528f,0.1173f,
	0.1450f,0.1057f,0.1042f,0.1047f,0.0300f,0.1839f,0.0602f,0.1550f,-0.0111f,0.1954f,-0.0054f,0.1741f,0.0225f,0.1661f,0.0431f,0.1444f,0.9479f,0.1445f,0.9594f,0.1753f,0.9635f,0.1356f,0.9730f,0.1591f,0.9946f,0.1741f,0.9889f,0.1954f,0.9846f,0.1402f,
	0.9767f,0.1259f,-0.0002f,0.1485f,-0.0154f,0.1402f,0.9998f,0.1485f,0.0313f,0.1323f,0.0177f,0.1450f,0.9448f,0.1215f,0.9473f,0.1084f,0.9626f,0.1063f,0.9608f,0.1171f,0.9644f,0.0974f,0.9536f,0.1013f,0.9757f,0.0970f,0.9673f,0.1003f,0.9782f,0.0997f,
	0.9842f,0.0971f,0.9755f,0.1044f,0.9745f,0.1128f,0.9831f,0.0955f,0.0073f,0.0950f,-0.0169f,0.0955f,0.0075f,0.0951f,-0.0100f,0.0955f,0.9900f,0.0955f,0.0589f,0.0982f,0.0342f,0.0958f,0.0433f,0.0979f,0.0262f,0.0958f,0.0211f,0.0961f,0.0331f,0.0979f,
	0.0078f,0.0955f,0.9950f,0.0958f,-0.0050f,0.0958f,0.0736f,0.1035f,0.0800f,0.1129f,0.0571f,0.1102f,0.0532f,0.1023f,0.0769f,0.1290f,0.0547f,0.1235f,0.0388f,0.1179f,0.0408f,0.1077f,0.0393f,0.1015f,
_NULL_ }; /* End of object01_UV */

const float object01_Normals[] = {
	0.5825f,-0.7489f,-0.3159f, 0.6562f,-0.7094f,-0.2573f, 0.3498f,-0.9143f,-0.2041f, 0.3326f,-0.9185f,-0.2140f, 0.7158f,-0.6673f,-0.2058f, 0.3730f,-0.9087f,-0.1872f, 0.2245f,-0.9599f,-0.1681f, 0.2282f,-0.9589f,-0.1685f, 0.2294f,-0.9580f,-0.1722f, 0.7432f,-0.6414f,-0.1903f, 0.3761f,-0.9072f,-0.1885f, 0.3803f,-0.9070f,-0.1809f, 0.7583f,-0.6311f,-0.1635f, 0.2309f,-0.9600f,-0.1584f, 0.2266f,-0.9602f,-0.1633f, 
	-0.0576f,-0.9981f,0.0220f, -0.1074f,-0.9939f,-0.0241f, 0.1035f,-0.9861f,-0.1298f, 0.1181f,-0.9872f,-0.1076f, -0.1101f,-0.9923f,-0.0573f, 0.1012f,-0.9851f,-0.1393f, -0.0363f,-0.9980f,-0.0519f, 0.1421f,-0.9808f,-0.1339f, 0.1156f,-0.9830f,-0.1424f, -0.0817f,-0.9950f,-0.0580f, 0.6225f,-0.7760f,-0.1018f, 0.6029f,-0.7722f,-0.2006f, 0.3818f,-0.9130f,-0.1437f, 0.5181f,-0.8553f,-0.0018f, 0.5614f,-0.7713f,-0.2998f, 
	0.3348f,-0.9219f,-0.1950f, 0.2486f,-0.9572f,-0.1479f, 0.2741f,-0.9567f,-0.0981f, 0.3576f,-0.9292f,0.0928f, 0.3250f,-0.9204f,-0.2175f, 0.5515f,-0.7663f,-0.3295f, 0.2371f,-0.9571f,-0.1665f, 0.0140f,-0.9994f,-0.0302f, 0.1604f,-0.9790f,-0.1254f, 0.0463f,-0.9988f,0.0133f, 0.1798f,-0.9786f,-0.1001f, 0.1239f,-0.9770f,0.1738f, 0.2084f,-0.9662f,0.1517f, 0.1948f,-0.9803f,-0.0323f, 0.0849f,-0.9915f,0.0989f, 
	0.1699f,0.7982f,-0.5780f, 0.2299f,0.8614f,-0.4530f, -0.2684f,0.9536f,0.1366f, 0.4981f,0.8085f,-0.3133f, -0.3521f,0.3526f,-0.8670f, 0.0186f,0.6310f,-0.7756f, -0.2572f,0.3908f,-0.8838f, 0.0634f,0.4046f,-0.9123f, 0.0387f,-0.1628f,-0.9859f, -0.2837f,-0.5220f,-0.8044f, 0.5120f,0.5977f,-0.6170f, 0.4110f,0.2336f,-0.8812f, 0.7355f,0.5593f,-0.3824f, 0.9437f,0.2239f,-0.2435f, 0.6583f,0.4061f,-0.6338f, 
	0.6878f,0.5783f,-0.4387f, -0.7316f,0.1948f,-0.6533f, -0.6180f,0.2327f,-0.7509f, -0.9668f,0.0713f,-0.2455f, -0.8309f,0.1433f,-0.5376f, -0.9635f,-0.0999f,-0.2483f, -0.6544f,-0.0292f,-0.7556f, -0.3234f,-0.6060f,-0.7268f, -0.5254f,-0.5728f,-0.6292f, -0.6064f,-0.1035f,-0.7884f, -0.2993f,-0.6919f,-0.6570f, -0.3329f,-0.6808f,-0.6524f, -0.5920f,-0.1179f,-0.7973f, -0.7797f,0.3467f,0.5213f, -0.9491f,0.1588f,0.2722f, 
	-0.6722f,0.4829f,0.5612f, -0.6792f,0.4581f,0.5734f, -0.7334f,-0.3330f,0.5926f, -0.7441f,-0.3451f,0.5720f, -0.7319f,-0.3488f,0.5853f, -0.7278f,-0.3179f,0.6077f, -0.8274f,-0.3424f,0.4453f, -0.8013f,-0.4840f,0.3515f, -0.7854f,-0.6019f,-0.1446f, -0.9443f,-0.3207f,0.0735f, 0.8908f,0.4439f,-0.0972f, 0.8700f,0.3136f,0.3805f, 0.7211f,0.4188f,0.5519f, 0.7070f,0.6061f,-0.3645f, 0.7582f,0.5406f,-0.3644f, 
	0.8986f,0.1013f,-0.4269f, 0.7733f,0.5744f,-0.2687f, 0.9246f,-0.3184f,-0.2091f, 0.7005f,0.6227f,0.3485f, 0.9904f,0.1324f,0.0385f, 0.9721f,-0.1300f,-0.1954f, 0.7816f,0.6219f,-0.0470f, -0.6937f,0.4635f,0.5514f, -0.6921f,0.4816f,0.5376f, -0.4678f,0.4673f,0.7502f, -0.6451f,0.4433f,0.6223f, -0.3238f,-0.0494f,0.9448f, -0.5606f,-0.2145f,0.7998f, -0.5623f,-0.2298f,0.7944f, -0.2873f,-0.0908f,0.9535f, 
	-0.6818f,-0.2928f,0.6704f, -0.6855f,-0.2757f,0.6738f, -0.7277f,-0.3044f,0.6147f, -0.7306f,-0.3231f,0.6015f, 0.0390f,0.4752f,0.8790f, -0.3183f,0.4821f,0.8162f, 0.1969f,0.3374f,0.9205f, 0.4704f,0.5035f,0.7247f, 0.7705f,0.0557f,0.6350f, 0.2195f,0.3317f,0.9175f, 0.4846f,0.1218f,0.8662f, 0.0335f,0.0159f,0.9993f, -0.0373f,0.1494f,0.9881f, 0.7540f,0.6144f,-0.2323f, 0.7783f,0.5409f,-0.3188f, 
	0.6984f,0.6856f,-0.2052f, 0.8539f,0.5153f,-0.0724f, 0.8854f,0.4232f,-0.1925f, 0.8769f,0.3454f,-0.3344f, 0.5348f,0.8412f,-0.0800f, 0.6089f,0.7740f,-0.1736f, 0.7775f,0.6281f,-0.0310f, 0.8123f,0.5833f,-0.0026f, 0.9956f,0.0538f,-0.0770f, 0.9893f,0.0922f,-0.1130f, 0.9926f,-0.0111f,-0.1207f, 0.8918f,-0.2216f,-0.3944f, 0.9600f,-0.1088f,-0.2578f, 0.0080f,0.7959f,-0.6054f, -0.2178f,0.8085f,-0.5468f, 
	-0.1541f,0.5673f,-0.8089f, 0.1419f,0.5646f,-0.8131f, -0.4863f,0.7532f,-0.4429f, -0.5205f,0.4849f,-0.7028f, -0.2866f,-0.3355f,-0.8974f, 0.0861f,-0.2227f,-0.9711f, 0.3690f,-0.1423f,-0.9185f, -0.8943f,0.4126f,-0.1732f, -0.9633f,-0.0081f,-0.2685f, -0.8232f,0.2309f,-0.5186f, -0.7414f,0.5961f,-0.3081f, -0.6142f,-0.7167f,-0.3302f, -0.5430f,-0.5386f,-0.6443f, -0.8232f,0.2309f,-0.5186f, -0.5430f,-0.5386f,-0.6443f, 
	-0.7414f,0.5961f,-0.3081f, 0.0927f,-0.9801f,-0.1753f, 0.1380f,-0.9689f,-0.2055f, -0.0128f,-0.9437f,-0.3305f, -0.0811f,-0.9732f,-0.2150f, 0.1989f,-0.9477f,-0.2498f, 0.1083f,-0.8800f,-0.4625f, -0.0128f,-0.9437f,-0.3305f, 0.1380f,-0.9689f,-0.2055f, 0.3125f,-0.8847f,-0.3459f, 0.3827f,-0.7260f,-0.5714f, 0.2561f,-0.8089f,-0.5293f, 0.2598f,-0.9169f,-0.3029f, -0.8012f,-0.3668f,0.4728f, -0.7957f,-0.2748f,0.5397f, 
	-0.7616f,-0.4314f,0.4835f, -0.6604f,-0.6512f,0.3738f, -0.6559f,-0.6253f,0.4228f, -0.6277f,-0.6155f,0.4767f, -0.7253f,-0.4285f,0.5388f, -0.7307f,-0.4308f,0.5296f, -0.6194f,-0.6803f,0.3918f, -0.6443f,-0.6723f,0.3645f, -0.3919f,-0.9104f,0.1327f, -0.3419f,-0.9286f,0.1443f, -0.4220f,-0.8953f,0.1429f, -0.3577f,-0.8953f,0.2656f, -0.4093f,-0.8927f,0.1886f, 0.8162f,0.5672f,-0.1100f, 0.7687f,0.5613f,0.3067f, 
	0.7934f,0.5252f,-0.3077f, 0.8819f,0.2850f,-0.3756f, 0.9402f,0.2752f,-0.2006f, 0.9523f,0.1997f,0.2306f, 0.7764f,0.5187f,-0.3580f, 0.8608f,0.2874f,-0.4200f, 0.8500f,-0.2666f,-0.4544f, 0.8666f,-0.2840f,-0.4103f, 0.9047f,-0.4246f,0.0353f, 0.9106f,-0.3183f,-0.2636f, -0.7104f,-0.4182f,0.5661f, -0.6557f,-0.3888f,0.6472f, -0.5255f,-0.6659f,0.5296f, -0.5881f,-0.6839f,0.4318f, -0.2955f,-0.1672f,0.9406f, 
	-0.5305f,-0.3178f,0.7858f, -0.1814f,-0.5044f,0.8442f, -0.4032f,-0.6202f,0.6728f, -0.1447f,-0.9162f,0.3736f, 0.0064f,-0.8701f,0.4928f, -0.2292f,-0.9373f,0.2627f, -0.2878f,-0.9391f,0.1879f, -0.0094f,0.0382f,0.9992f, 0.2620f,0.2372f,0.9355f, 0.4024f,-0.1227f,0.9072f, 0.0969f,-0.3198f,0.9425f, 0.5432f,0.4236f,0.7249f, 0.7340f,0.0524f,0.6771f, 0.7435f,-0.5519f,0.3776f, 0.4810f,-0.6693f,0.5662f, 
	0.2166f,-0.7795f,0.5878f, 0.1453f,-0.9853f,-0.0902f, -0.0099f,-0.9985f,0.0536f, 0.2292f,-0.9605f,-0.1575f, 0.2316f,-0.9607f,-0.1531f, 0.1609f,-0.9827f,-0.0914f, 0.0403f,-0.9978f,0.0533f, 0.6885f,-0.6765f,-0.2612f, 0.3540f,-0.9151f,-0.1929f, 0.6116f,-0.7452f,-0.2658f, 0.3252f,-0.9235f,-0.2032f, 0.4553f,-0.8466f,-0.2756f, 0.2838f,-0.9386f,-0.1963f, 0.3061f,-0.9320f,-0.1942f, 0.5198f,-0.8007f,-0.2979f, 
	0.2290f,-0.9608f,-0.1560f, 0.2289f,-0.9606f,-0.1578f, 0.0968f,-0.9953f,-0.0055f, 0.0698f,-0.9973f,0.0239f, 0.1770f,-0.9795f,-0.0960f, 0.1853f,-0.9761f,-0.1139f, -0.2589f,0.8694f,-0.4208f, 0.0935f,0.9474f,-0.3062f, -0.5703f,0.7393f,-0.3580f, -0.2647f,0.9460f,0.1873f, 0.1095f,0.9922f,0.0589f, 0.3454f,0.9379f,-0.0330f, -0.9505f,0.2654f,0.1617f, -0.8278f,0.5450f,-0.1331f, -0.8368f,0.2288f,0.4973f, 
	-0.6623f,0.6732f,0.3288f, -0.7713f,0.1545f,0.6175f, -0.6431f,0.5694f,0.5121f, -0.6240f,0.6209f,0.4744f, -0.7938f,0.1989f,0.5747f, -0.2481f,0.9279f,0.2783f, -0.2129f,0.9298f,0.3004f, 0.3951f,0.9137f,-0.0949f, 0.3848f,0.9227f,-0.0243f, 0.1665f,0.9807f,0.1026f, 0.1745f,0.9828f,0.0607f, 0.9731f,0.0230f,-0.2292f, 0.7564f,0.6481f,-0.0883f, 0.7652f,0.6144f,-0.1923f, 0.9421f,-0.0582f,-0.3303f, 
	0.5193f,0.8516f,-0.0717f, 0.5192f,0.8510f,-0.0789f, 0.5724f,0.7899f,-0.2199f, 0.5405f,0.8302f,-0.1363f, 0.8196f,0.3887f,-0.4209f, 0.8045f,0.5253f,-0.2773f, 0.8895f,-0.2339f,-0.3926f, 0.7927f,-0.3973f,-0.4623f, -0.8063f,-0.2262f,0.5465f, -0.5698f,-0.6278f,0.5303f, -0.5373f,-0.6551f,0.5312f, -0.7686f,-0.2121f,0.6036f, -0.2738f,-0.9136f,0.3007f, -0.2140f,-0.9309f,0.2961f, -0.1187f,-0.9717f,0.2040f, 
	-0.1597f,-0.9526f,0.2590f, -0.4713f,-0.7321f,0.4917f, -0.4941f,-0.6915f,0.5270f, -0.7420f,-0.2317f,0.6290f, -0.7212f,-0.2597f,0.6422f, 0.1410f,0.9895f,-0.0328f, 0.3940f,0.8988f,-0.1923f, -0.2877f,0.9284f,0.2351f, -0.3221f,0.9331f,0.1601f, 0.1155f,0.9852f,-0.1266f, 0.3710f,0.8765f,-0.3068f, -0.7739f,0.1418f,0.6172f, -0.6634f,0.5586f,0.4979f, -0.7925f,0.1523f,0.5906f, -0.6895f,0.5615f,0.4576f, 
	-0.3221f,0.9331f,0.1601f, -0.2877f,0.9284f,0.2351f, -0.8898f,0.1912f,0.4144f, -0.7591f,0.5960f,0.2619f, -0.7211f,0.5806f,0.3780f, -0.8315f,0.1660f,0.5301f, -0.3914f,0.9196f,-0.0338f, -0.3597f,0.9312f,0.0590f, 0.3045f,0.8185f,-0.4872f, 0.3469f,0.8422f,-0.4128f, 0.0731f,0.9694f,-0.2345f, 0.0336f,0.9467f,-0.3204f, -0.3597f,0.9312f,0.0590f, -0.3914f,0.9196f,-0.0338f, -0.7266f,-0.2720f,0.6310f, 
	-0.4536f,-0.7655f,0.4565f, -0.4540f,-0.7945f,0.4033f, -0.7445f,-0.2851f,0.6036f, 0.1105f,-0.9929f,-0.0429f, -0.0917f,-0.9839f,0.1535f, 0.1182f,-0.9912f,-0.0603f, -0.0751f,-0.9919f,0.1028f, 0.1200f,-0.9888f,-0.0883f, -0.0748f,-0.9969f,0.0262f, -0.0700f,-0.9954f,0.0661f, 0.1209f,-0.9896f,-0.0783f, -0.4997f,-0.8272f,0.2569f, -0.4660f,-0.8172f,0.3391f, -0.7905f,-0.2969f,0.5357f, -0.8519f,-0.2964f,0.4317f, 
	0.1898f,-0.9743f,-0.1212f, 0.2267f,-0.9607f,-0.1602f, 0.1898f,-0.9743f,-0.1212f, 0.2256f,-0.9611f,-0.1592f, 0.1919f,-0.9727f,-0.1305f, 0.1919f,-0.9727f,-0.1305f, 0.3974f,-0.8732f,-0.2821f, 0.2735f,-0.9426f,-0.1916f, 0.3731f,-0.8857f,-0.2763f, 0.2645f,-0.9452f,-0.1913f, 0.3495f,-0.8945f,-0.2788f, 0.2587f,-0.9472f,-0.1894f, 0.2610f,-0.9465f,-0.1899f, 0.3552f,-0.8926f,-0.2778f, 0.2237f,-0.9615f,-0.1595f, 
	0.2243f,-0.9613f,-0.1599f, 0.1921f,-0.9723f,-0.1331f, 0.1918f,-0.9720f,-0.1359f, 0.1921f,-0.9723f,-0.1331f, 0.1918f,-0.9720f,-0.1359f, 0.7081f,-0.5240f,-0.4733f, 0.8175f,0.2241f,-0.5305f, 0.7748f,0.1095f,-0.6226f, 0.6215f,-0.6089f,-0.4930f, 0.5702f,0.7431f,-0.3502f, 0.5756f,0.6717f,-0.4664f, 0.5146f,0.5794f,-0.6321f, 0.5448f,0.6170f,-0.5679f, 0.6901f,-0.0127f,-0.7236f, 0.7290f,0.0133f,-0.6844f, 
	0.5813f,-0.6423f,-0.4996f, 0.5550f,-0.6575f,-0.5096f, -0.0122f,0.9249f,-0.3800f, 0.2624f,0.8034f,-0.5345f, -0.4218f,0.8947f,-0.1469f, -0.4483f,0.8589f,-0.2477f, -0.0770f,0.8939f,-0.4417f, 0.1944f,0.8009f,-0.5663f, -0.9378f,0.2211f,0.2676f, -0.7879f,0.6038f,0.1209f, -0.9542f,0.2807f,0.1034f, -0.7892f,0.6125f,-0.0446f, -0.4483f,0.8589f,-0.2477f, -0.4218f,0.8947f,-0.1469f, -0.7607f,0.6239f,-0.1791f, 
	-0.9291f,0.3661f,-0.0523f, -0.4724f,0.8049f,-0.3590f, -0.7607f,0.6239f,-0.1791f, -0.4724f,0.8049f,-0.3590f, 0.0936f,0.8076f,-0.5822f, -0.1533f,0.8626f,-0.4821f, -0.9175f,-0.2728f,0.2895f, -0.5387f,-0.8269f,0.1615f, -0.5950f,-0.8019f,0.0546f, -0.9656f,-0.2143f,0.1469f, 0.1189f,-0.9878f,-0.1010f, -0.0836f,-0.9964f,-0.0129f, 0.1125f,-0.9867f,-0.1172f, -0.1031f,-0.9930f,-0.0569f, -0.1163f,-0.9858f,-0.1208f, 
	0.0979f,-0.9843f,-0.1468f, -0.6320f,-0.7697f,-0.0908f, -0.9895f,-0.1390f,-0.0407f, 0.1915f,-0.9715f,-0.1393f, 0.2231f,-0.9614f,-0.1613f, 0.1915f,-0.9715f,-0.1393f, 0.2219f,-0.9605f,-0.1682f, 0.1895f,-0.9708f,-0.1473f, 0.1895f,-0.9708f,-0.1473f, 0.3450f,-0.8948f,-0.2834f, 0.2577f,-0.9471f,-0.1912f, 0.3404f,-0.8910f,-0.3004f, 0.2559f,-0.9459f,-0.1992f, 0.2552f,-0.9401f,-0.2259f, 0.3284f,-0.8835f,-0.3339f, 
	0.2176f,-0.9583f,-0.1850f, 0.1791f,-0.9700f,-0.1643f, 0.1791f,-0.9700f,-0.1643f, 0.5413f,-0.6554f,-0.5267f, 0.6587f,-0.0160f,-0.7522f, 0.6086f,0.0032f,-0.7935f, 0.5227f,-0.6432f,-0.5595f, 0.4715f,0.5726f,-0.6707f, 0.4124f,0.5866f,-0.6971f, 0.3215f,0.5788f,-0.7494f, 0.5334f,-0.0183f,-0.8457f, 0.4814f,-0.6516f,-0.5863f, 
_NULL_ }; /* End of object01_Normals */

const unsigned short object01_Faces[] = {
	0, 2, 1, 0, 3, 2, 4, 2, 5, 4, 1, 2, 6, 2, 7, 6, 5, 2, 8, 2, 3, 8, 7, 2, 9, 11, 10, 9, 12, 11, 
	13, 11, 14, 13, 10, 11, 6, 11, 5, 6, 14, 11, 4, 11, 12, 4, 5, 11, 15, 17, 16, 15, 18, 17, 19, 17, 20, 19, 16, 17, 
	6, 17, 14, 6, 20, 17, 13, 17, 18, 13, 14, 17, 21, 23, 22, 21, 24, 23, 8, 23, 7, 8, 22, 23, 6, 23, 20, 6, 7, 23, 
	19, 23, 24, 19, 20, 23, 25, 27, 26, 25, 28, 27, 29, 27, 30, 29, 26, 27, 31, 27, 32, 31, 30, 27, 33, 27, 28, 33, 32, 27, 
	0, 34, 3, 0, 35, 34, 8, 34, 36, 8, 3, 34, 31, 34, 30, 31, 36, 34, 29, 34, 35, 29, 30, 34, 21, 38, 37, 21, 22, 38, 
	39, 38, 40, 39, 37, 38, 31, 38, 36, 31, 40, 38, 8, 38, 22, 8, 36, 38, 41, 43, 42, 41, 44, 43, 33, 43, 32, 33, 42, 43, 
	31, 43, 40, 31, 32, 43, 39, 43, 44, 39, 40, 43, 45, 47, 46, 48, 46, 47, 49, 47, 50, 45, 50, 47, 51, 53, 52, 51, 54, 53, 
	55, 53, 56, 55, 52, 53, 45, 53, 50, 45, 56, 53, 49, 53, 54, 49, 50, 53, 57, 59, 58, 57, 60, 59, 48, 59, 46, 48, 58, 59, 
	45, 59, 56, 45, 46, 59, 55, 59, 60, 55, 56, 59, 61, 47, 62, 49, 62, 47, 63, 47, 64, 61, 64, 47, 65, 67, 66, 65, 68, 67, 
	69, 67, 70, 69, 66, 67, 61, 67, 64, 61, 70, 67, 63, 67, 68, 63, 64, 67, 51, 71, 54, 51, 72, 71, 49, 71, 62, 49, 54, 71, 
	61, 71, 70, 61, 62, 71, 69, 71, 72, 69, 70, 71, 73, 47, 74, 63, 74, 47, 75, 47, 76, 73, 76, 47, 77, 79, 78, 77, 80, 79, 
	81, 79, 82, 81, 78, 79, 73, 79, 76, 73, 82, 79, 75, 79, 80, 75, 76, 79, 65, 83, 68, 65, 84, 83, 63, 83, 74, 63, 68, 83, 
	73, 83, 82, 73, 74, 83, 81, 83, 84, 81, 82, 83, 85, 47, 86, 87, 86, 47, 48, 47, 88, 85, 88, 47, 57, 90, 89, 57, 58, 90, 
	91, 90, 92, 91, 89, 90, 85, 90, 88, 85, 92, 90, 48, 90, 58, 48, 88, 90, 93, 95, 94, 93, 96, 95, 87, 95, 86, 87, 94, 95, 
	85, 95, 92, 85, 86, 95, 91, 95, 96, 91, 92, 95, 97, 47, 98, 75, 98, 47, 99, 47, 100, 97, 100, 47, 101, 103, 102, 101, 104, 103, 
	105, 103, 106, 105, 102, 103, 97, 103, 100, 97, 106, 103, 99, 103, 104, 99, 100, 103, 77, 107, 80, 77, 108, 107, 75, 107, 98, 75, 80, 107, 
	97, 107, 106, 97, 98, 107, 105, 107, 108, 105, 106, 107, 109, 47, 110, 99, 110, 47, 87, 47, 111, 109, 111, 47, 93, 113, 112, 93, 94, 113, 
	114, 113, 115, 114, 112, 113, 109, 113, 111, 109, 115, 113, 87, 113, 94, 87, 111, 113, 101, 116, 104, 101, 117, 116, 99, 116, 110, 99, 104, 116, 
	109, 116, 115, 109, 110, 116, 114, 116, 117, 114, 115, 116, 57, 118, 60, 57, 119, 118, 55, 118, 120, 55, 60, 118, 121, 118, 122, 121, 120, 118, 
	123, 118, 119, 123, 122, 118, 51, 125, 124, 51, 52, 125, 126, 125, 127, 126, 124, 125, 121, 125, 120, 121, 127, 125, 55, 125, 52, 55, 120, 125, 
	9, 128, 12, 9, 129, 128, 4, 128, 130, 4, 12, 128, 121, 128, 127, 121, 130, 128, 126, 128, 129, 126, 127, 128, 0, 132, 131, 0, 1, 132, 
	123, 132, 122, 123, 131, 132, 121, 132, 130, 121, 122, 132, 4, 132, 1, 4, 130, 132, 133, 135, 134, 133, 136, 135, 137, 135, 138, 137, 134, 135, 
	139, 135, 140, 139, 138, 135, 141, 135, 136, 141, 140, 135, 142, 144, 143, 142, 145, 144, 146, 144, 147, 146, 143, 144, 139, 148, 138, 139, 149, 148, 
	137, 148, 150, 137, 138, 148, 151, 153, 152, 151, 154, 153, 155, 157, 156, 155, 158, 157, 139, 157, 149, 139, 156, 157, 146, 153, 154, 146, 147, 153, 
	159, 161, 160, 159, 162, 161, 141, 161, 140, 141, 160, 161, 139, 161, 156, 139, 140, 161, 155, 161, 162, 155, 156, 161, 65, 163, 84, 65, 164, 163, 
	81, 163, 165, 81, 84, 163, 166, 163, 167, 166, 165, 163, 168, 163, 164, 168, 167, 163, 77, 170, 169, 77, 78, 170, 171, 170, 172, 171, 169, 170, 
	166, 170, 165, 166, 172, 170, 81, 170, 78, 81, 165, 170, 21, 173, 24, 21, 174, 173, 19, 173, 175, 19, 24, 173, 166, 173, 172, 166, 175, 173, 
	171, 173, 174, 171, 172, 173, 15, 177, 176, 15, 16, 177, 168, 177, 167, 168, 176, 177, 166, 177, 175, 166, 167, 177, 19, 177, 16, 19, 175, 177, 
	93, 178, 96, 93, 179, 178, 91, 178, 180, 91, 96, 178, 181, 178, 182, 181, 180, 178, 183, 178, 179, 183, 182, 178, 57, 184, 119, 57, 89, 184, 
	123, 184, 185, 123, 119, 184, 181, 184, 180, 181, 185, 184, 91, 184, 89, 91, 180, 184, 0, 186, 35, 0, 131, 186, 29, 186, 187, 29, 35, 186, 
	181, 186, 185, 181, 187, 186, 123, 186, 131, 123, 185, 186, 25, 189, 188, 25, 26, 189, 183, 189, 182, 183, 188, 189, 181, 189, 187, 181, 182, 189, 
	29, 189, 26, 29, 187, 189, 77, 190, 108, 77, 169, 190, 105, 190, 191, 105, 108, 190, 192, 190, 193, 192, 191, 190, 171, 190, 169, 171, 193, 190, 
	101, 195, 194, 101, 102, 195, 196, 195, 197, 196, 194, 195, 192, 195, 191, 192, 197, 195, 105, 195, 102, 105, 191, 195, 41, 198, 44, 41, 199, 198, 
	39, 198, 200, 39, 44, 198, 192, 198, 197, 192, 200, 198, 196, 198, 199, 196, 197, 198, 21, 201, 174, 21, 37, 201, 171, 201, 193, 171, 174, 201, 
	192, 201, 200, 192, 193, 201, 39, 201, 37, 39, 200, 201, 101, 202, 117, 101, 194, 202, 114, 202, 203, 114, 117, 202, 204, 202, 205, 204, 203, 202, 
	196, 202, 194, 196, 205, 202, 93, 206, 179, 93, 112, 206, 183, 206, 207, 183, 179, 206, 204, 206, 203, 204, 207, 206, 114, 206, 112, 114, 203, 206, 
	25, 208, 28, 25, 188, 208, 33, 208, 209, 33, 28, 208, 204, 208, 207, 204, 209, 208, 183, 208, 188, 183, 207, 208, 41, 210, 199, 41, 42, 210, 
	196, 210, 205, 196, 199, 210, 204, 210, 209, 204, 205, 210, 33, 210, 42, 33, 209, 210, 15, 211, 18, 15, 212, 211, 13, 211, 213, 13, 18, 211, 
	214, 211, 215, 214, 213, 211, 216, 211, 212, 216, 215, 211, 9, 218, 217, 9, 10, 218, 219, 218, 220, 219, 217, 218, 214, 218, 213, 214, 220, 218, 
	13, 218, 10, 13, 213, 218, 221, 223, 222, 221, 224, 223, 225, 223, 226, 225, 222, 223, 214, 223, 220, 214, 226, 223, 219, 223, 224, 219, 220, 223, 
	227, 229, 228, 227, 230, 229, 216, 229, 215, 216, 228, 229, 214, 229, 226, 214, 215, 229, 225, 229, 230, 225, 226, 229, 51, 231, 72, 51, 232, 231, 
	69, 231, 233, 69, 72, 231, 234, 231, 235, 234, 233, 231, 236, 231, 232, 236, 235, 231, 65, 238, 237, 65, 66, 238, 239, 238, 240, 239, 237, 238, 
	234, 238, 233, 234, 240, 238, 69, 238, 66, 69, 233, 238, 241, 243, 242, 241, 244, 243, 245, 243, 246, 245, 242, 243, 234, 243, 240, 234, 246, 243, 
	239, 243, 244, 239, 240, 243, 247, 249, 248, 247, 250, 249, 236, 249, 235, 236, 248, 249, 234, 249, 246, 234, 235, 249, 245, 249, 250, 245, 246, 249, 
	9, 251, 129, 9, 217, 251, 126, 251, 252, 126, 129, 251, 253, 251, 254, 253, 252, 251, 219, 251, 217, 219, 254, 251, 51, 255, 232, 51, 124, 255, 
	236, 255, 256, 236, 232, 255, 253, 255, 252, 253, 256, 255, 126, 255, 124, 126, 252, 255, 247, 258, 257, 247, 248, 258, 259, 258, 260, 259, 257, 258, 
	253, 258, 256, 253, 260, 258, 236, 258, 248, 236, 256, 258, 221, 261, 224, 221, 262, 261, 219, 261, 254, 219, 224, 261, 253, 261, 260, 253, 254, 261, 
	259, 261, 262, 259, 260, 261, 65, 263, 164, 65, 237, 263, 168, 263, 264, 168, 164, 263, 265, 263, 266, 265, 264, 263, 239, 263, 237, 239, 266, 263, 
	15, 267, 212, 15, 176, 267, 216, 267, 268, 216, 212, 267, 265, 267, 264, 265, 268, 267, 168, 267, 176, 168, 264, 267, 227, 270, 269, 227, 228, 270, 
	271, 270, 272, 271, 269, 270, 265, 270, 268, 265, 272, 270, 216, 270, 228, 216, 268, 270, 241, 273, 244, 241, 274, 273, 239, 273, 266, 239, 244, 273, 
	265, 273, 272, 265, 266, 273, 271, 273, 274, 271, 272, 273, 247, 275, 250, 247, 276, 275, 245, 275, 277, 245, 250, 275, 278, 275, 279, 278, 277, 275, 
	280, 275, 276, 280, 279, 275, 241, 282, 281, 241, 242, 282, 283, 282, 284, 283, 281, 282, 285, 282, 286, 285, 284, 282, 245, 282, 242, 245, 286, 282, 
	287, 289, 288, 287, 290, 289, 291, 289, 292, 291, 288, 289, 285, 289, 284, 285, 292, 289, 283, 289, 290, 283, 284, 289, 293, 295, 294, 293, 296, 295, 
	280, 295, 279, 280, 294, 295, 278, 295, 297, 278, 279, 295, 298, 295, 296, 298, 297, 295, 241, 299, 274, 241, 281, 299, 271, 299, 300, 271, 274, 299, 
	301, 299, 302, 301, 300, 299, 283, 299, 281, 283, 302, 299, 227, 304, 303, 227, 269, 304, 305, 304, 306, 305, 303, 304, 301, 304, 300, 301, 306, 304, 
	271, 304, 269, 271, 300, 304, 307, 309, 308, 307, 310, 309, 311, 309, 312, 311, 308, 309, 301, 309, 306, 301, 312, 309, 305, 309, 310, 305, 306, 309, 
	287, 313, 290, 287, 314, 313, 283, 313, 302, 283, 290, 313, 301, 313, 312, 301, 302, 313, 311, 313, 314, 311, 312, 313, 227, 315, 230, 227, 303, 315, 
	225, 317, 316, 225, 230, 315, 318, 317, 319, 318, 316, 317, 305, 315, 303, 305, 320, 315, 221, 322, 321, 221, 222, 322, 323, 322, 324, 323, 321, 322, 
	318, 322, 316, 318, 324, 322, 225, 322, 222, 225, 316, 322, 325, 327, 326, 325, 328, 327, 329, 327, 330, 329, 326, 327, 318, 327, 324, 318, 330, 327, 
	323, 327, 328, 323, 324, 327, 307, 331, 310, 307, 332, 331, 305, 331, 320, 305, 310, 331, 318, 333, 330, 318, 319, 333, 329, 333, 334, 329, 330, 333, 
	221, 335, 262, 221, 321, 335, 259, 335, 336, 259, 262, 335, 337, 335, 338, 337, 336, 335, 323, 335, 321, 323, 338, 335, 247, 339, 276, 247, 257, 339, 
	280, 339, 340, 280, 276, 339, 337, 339, 336, 337, 340, 339, 259, 339, 257, 259, 336, 339, 293, 342, 341, 293, 294, 342, 343, 342, 344, 343, 341, 342, 
	337, 342, 340, 337, 344, 342, 280, 342, 294, 280, 340, 342, 325, 345, 328, 325, 346, 345, 323, 345, 338, 323, 328, 345, 337, 345, 344, 337, 338, 345, 
	343, 345, 346, 343, 344, 345, 293, 347, 296, 293, 348, 347, 298, 347, 349, 298, 296, 347, 350, 347, 351, 350, 349, 347, 352, 347, 348, 352, 351, 347, 
	287, 354, 353, 287, 288, 354, 355, 354, 356, 355, 353, 354, 357, 354, 358, 357, 356, 354, 291, 354, 288, 291, 358, 354, 142, 359, 145, 142, 360, 359, 
	137, 362, 361, 137, 150, 362, 357, 359, 356, 357, 363, 359, 355, 359, 360, 355, 356, 359, 133, 365, 364, 133, 134, 365, 352, 365, 351, 352, 364, 365, 
	350, 365, 361, 350, 351, 365, 137, 365, 134, 137, 361, 365, 287, 366, 314, 287, 353, 366, 311, 366, 367, 311, 314, 366, 368, 366, 369, 368, 367, 366, 
	355, 366, 353, 355, 369, 366, 307, 371, 370, 307, 308, 371, 372, 371, 373, 372, 370, 371, 368, 371, 367, 368, 373, 371, 311, 371, 308, 311, 367, 371, 
	151, 374, 154, 151, 375, 374, 146, 374, 376, 146, 154, 374, 368, 374, 373, 368, 376, 374, 372, 374, 375, 372, 373, 374, 142, 377, 360, 142, 143, 377, 
	355, 377, 369, 355, 360, 377, 368, 377, 376, 368, 369, 377, 146, 377, 143, 146, 376, 377, 307, 378, 332, 307, 370, 378, 329, 380, 379, 329, 334, 380, 
	381, 380, 382, 381, 379, 380, 372, 378, 370, 372, 383, 378, 325, 385, 384, 325, 326, 385, 386, 385, 387, 386, 384, 385, 381, 385, 379, 381, 387, 385, 
	329, 385, 326, 329, 379, 385, 159, 388, 162, 159, 389, 388, 155, 388, 390, 155, 162, 388, 381, 388, 387, 381, 390, 388, 386, 388, 389, 386, 387, 388, 
	151, 391, 375, 151, 152, 391, 372, 391, 383, 372, 375, 391, 381, 392, 390, 381, 382, 392, 155, 392, 158, 155, 390, 392, 325, 393, 346, 325, 384, 393, 
	343, 393, 394, 343, 346, 393, 395, 393, 396, 395, 394, 393, 386, 393, 384, 386, 396, 393, 293, 397, 348, 293, 341, 397, 352, 397, 398, 352, 348, 397, 
	395, 397, 394, 395, 398, 397, 343, 397, 341, 343, 394, 397, 133, 399, 136, 133, 364, 399, 141, 399, 400, 141, 136, 399, 395, 399, 398, 395, 400, 399, 
	352, 399, 364, 352, 398, 399, 159, 401, 389, 159, 160, 401, 386, 401, 396, 386, 389, 401, 395, 401, 400, 395, 396, 401, 141, 401, 160, 141, 400, 401, 
	
_NULL_ }; /* End of object01_Faces */


/* MESH 6 */

#define floor_NumVertex  4
#define floor_NumFaces   2
#define floor_NumStrips  0
#define floor_Flags      0x00020006
#define floor_Material   1

const float floor_Vertices[] = {
	2209.3489f,0.0000f,910.9861f, -2448.5784f,0.0000f,-1598.0394f, -1270.0690f,0.0000f,-2775.9292f, 1030.8391f,0.0000f,2088.8757f, 
_NULL_ }; /* End of floor_Vertices */

const float floor_UV[] = {
	9.9950f,4.9975f,0.0050f,0.0025f,0.0050f,4.9975f,9.9950f,0.0025f,
_NULL_ }; /* End of floor_UV */

const float floor_Normals[] = {
	0.0000f,1.0000f,0.0000f, 0.0000f,1.0000f,0.0000f, 0.0000f,1.0000f,0.0000f, 0.0000f,1.0000f,0.0000f, 
_NULL_ }; /* End of floor_Normals */

const unsigned short floor_Faces[] = {
	0, 2, 1, 1, 3, 0, 
_NULL_ }; /* End of floor_Faces */


/* MESH 7 */

#define wall_NumVertex  4
#define wall_NumFaces   2
#define wall_NumStrips  0
#define wall_Flags      0x00020006
#define wall_Material   2

const float wall_Vertices[] = {
	-1792.4279f,1783.4315f,-3222.4351f, 2594.1733f,-64.3017f,1481.6198f, -1792.4279f,-64.3017f,-3222.4351f, 2594.1733f,1783.4316f,1481.6198f, 
_NULL_ }; /* End of wall_Vertices */

const float wall_UV[] = {
	0.0050f,1.9990f,9.9950f,0.0010f,0.0050f,0.0010f,9.9950f,1.9990f,
_NULL_ }; /* End of wall_UV */

const float wall_Normals[] = {
	-0.7314f,0.0000f,0.6820f, -0.7314f,0.0000f,0.6820f, -0.7314f,0.0000f,0.6820f, -0.7314f,0.0000f,0.6820f, 
_NULL_ }; /* End of wall_Normals */

const unsigned short wall_Faces[] = {
	0, 2, 1, 1, 3, 0, 
_NULL_ }; /* End of wall_Faces */



/**********************************************************
 * MESHES 
 **********************************************************/

const Struct_Mesh 
   Mesh[NUM_MESHES] = {

/* MESH 0 */
	/* NumVertex      */ head_NumVertex,
	/* NumFaces       */ head_NumFaces,
	/* NumStrips      */ head_NumStrips,
	/* Flags          */ head_Flags,
	/* Material       */ head_Material,
	/* Center         */  76.314865f, 338.157867f, -40.547432f,
	/* Vertices       */ head_Vertices,
	/* UV             */ head_UV,
	/* Normals        */ head_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)head_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 1 */
	/* NumVertex      */ hand_left_NumVertex,
	/* NumFaces       */ hand_left_NumFaces,
	/* NumStrips      */ hand_left_NumStrips,
	/* Flags          */ hand_left_Flags,
	/* Material       */ hand_left_Material,
	/* Center         */  -31.718134f, 279.384583f, -56.905327f,
	/* Vertices       */ hand_left_Vertices,
	/* UV             */ hand_left_UV,
	/* Normals        */ hand_left_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)hand_left_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 2 */
	/* NumVertex      */ hand_right_NumVertex,
	/* NumFaces       */ hand_right_NumFaces,
	/* NumStrips      */ hand_right_NumStrips,
	/* Flags          */ hand_right_Flags,
	/* Material       */ hand_right_Material,
	/* Center         */  99.450859f, 243.928055f, 67.083153f,
	/* Vertices       */ hand_right_Vertices,
	/* UV             */ hand_right_UV,
	/* Normals        */ hand_right_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)hand_right_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 3 */
	/* NumVertex      */ body_NumVertex,
	/* NumFaces       */ body_NumFaces,
	/* NumStrips      */ body_NumStrips,
	/* Flags          */ body_Flags,
	/* Material       */ body_Material,
	/* Center         */  88.307213f, 187.115921f, -46.119644f,
	/* Vertices       */ body_Vertices,
	/* UV             */ body_UV,
	/* Normals        */ body_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)body_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 4 */
	/* NumVertex      */ object02_NumVertex,
	/* NumFaces       */ object02_NumFaces,
	/* NumStrips      */ object02_NumStrips,
	/* Flags          */ object02_Flags,
	/* Material       */ object02_Material,
	/* Center         */  53.369507f, 14.389765f, -73.442818f,
	/* Vertices       */ object02_Vertices,
	/* UV             */ object02_UV,
	/* Normals        */ object02_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)object02_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 5 */
	/* NumVertex      */ object01_NumVertex,
	/* NumFaces       */ object01_NumFaces,
	/* NumStrips      */ object01_NumStrips,
	/* Flags          */ object01_Flags,
	/* Material       */ object01_Material,
	/* Center         */  124.141319f, 16.595846f, -21.432344f,
	/* Vertices       */ object01_Vertices,
	/* UV             */ object01_UV,
	/* Normals        */ object01_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)object01_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 6 */
	/* NumVertex      */ floor_NumVertex,
	/* NumFaces       */ floor_NumFaces,
	/* NumStrips      */ floor_NumStrips,
	/* Flags          */ floor_Flags,
	/* Material       */ floor_Material,
	/* Center         */  618.626709f, 0.000000f, -456.973206f,
	/* Vertices       */ floor_Vertices,
	/* UV             */ floor_UV,
	/* Normals        */ floor_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)floor_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_,

/* MESH 7 */
	/* NumVertex      */ wall_NumVertex,
	/* NumFaces       */ wall_NumFaces,
	/* NumStrips      */ wall_NumStrips,
	/* Flags          */ wall_Flags,
	/* Material       */ wall_Material,
	/* Center         */  400.872742f, 859.564941f, 870.407654f,
	/* Vertices       */ wall_Vertices,
	/* UV             */ wall_UV,
	/* Normals        */ wall_Normals,
	/* Packed Vertices*/ (const float *) _NULL_,
	/* VertexColor    */ (const unsigned int *)_NULL_,
	/* VertexMaterial */ (const unsigned int *)_NULL_,
	/* Faces          */ (const unsigned short *)wall_Faces,
	/* Strips         */ (const unsigned short *)_NULL_,
	/* StripLength    */ (const unsigned short *)_NULL_,
	/* Patch type     */ 0,
	/* NumPatches     */ 0,
	/* NumPVertices   */ 0,
	/* NumSubdivisions*/ 0,
	/* ControlPoints  */ _NULL_,
	/* PatchUVs       */ _NULL_

	}; /* End of Meshes */

/**********************************************************
 * ANIMATION DATA 
 **********************************************************/

/* MESH ANIMATION 0 */

#define head_NumFrames  243

const float head_pData[] = {
/* M000 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,-0.0000f,-0.0000f,  
/* M001 */   1.0000f,0.0050f,0.0038f,  -0.0050f,1.0000f,0.0016f,  -0.0038f,-0.0016f,1.0000f,  1.6303f,-0.3078f,-0.8055f,  
/* M002 */   0.9999f,0.0104f,0.0080f,  -0.0104f,0.9999f,0.0032f,  -0.0080f,-0.0033f,1.0000f,  3.4593f,-0.6545f,-1.6009f,  
/* M003 */   0.9998f,0.0156f,0.0124f,  -0.0157f,0.9999f,0.0047f,  -0.0123f,-0.0049f,0.9999f,  5.3456f,-0.9838f,-2.3790f,  
/* M004 */   0.9997f,0.0202f,0.0166f,  -0.0204f,0.9998f,0.0063f,  -0.0165f,-0.0067f,0.9998f,  7.1502f,-1.2192f,-3.1431f,  
/* M005 */   0.9995f,0.0239f,0.0205f,  -0.0241f,0.9997f,0.0080f,  -0.0203f,-0.0085f,0.9998f,  8.6365f,-1.3106f,-3.9312f,  
/* M006 */   0.9994f,0.0261f,0.0238f,  -0.0263f,0.9996f,0.0098f,  -0.0235f,-0.0104f,0.9997f,  9.5444f,-1.2511f,-4.7719f,  
/* M007 */   0.9993f,0.0265f,0.0261f,  -0.0268f,0.9996f,0.0118f,  -0.0258f,-0.0125f,0.9996f,  9.7038f,-1.0478f,-5.6611f,  
/* M008 */   0.9994f,0.0219f,0.0255f,  -0.0223f,0.9996f,0.0149f,  -0.0252f,-0.0154f,0.9996f,  8.0615f,-0.4930f,-6.7031f,  
/* M009 */   0.9997f,0.0141f,0.0222f,  -0.0146f,0.9997f,0.0184f,  -0.0219f,-0.0187f,0.9996f,  5.2734f,0.2574f,-7.7654f,  
/* M010 */   0.9998f,0.0077f,0.0189f,  -0.0081f,0.9997f,0.0209f,  -0.0188f,-0.0211f,0.9996f,  3.1503f,0.7868f,-8.5643f,  
/* M011 */   0.9998f,0.0050f,0.0180f,  -0.0054f,0.9997f,0.0219f,  -0.0179f,-0.0220f,0.9996f,  2.4922f,0.8300f,-9.0357f,  
/* M012 */   0.9997f,0.0088f,0.0217f,  -0.0092f,0.9997f,0.0209f,  -0.0215f,-0.0211f,0.9995f,  3.7934f,0.1360f,-9.2404f,  
/* M013 */   0.9993f,0.0182f,0.0312f,  -0.0188f,0.9997f,0.0179f,  -0.0309f,-0.0185f,0.9994f,  6.8712f,-1.2432f,-9.1909f,  
/* M014 */   0.9986f,0.0288f,0.0442f,  -0.0295f,0.9995f,0.0143f,  -0.0437f,-0.0156f,0.9989f,  10.2637f,-2.8704f,-9.0400f,  
/* M015 */   0.9973f,0.0431f,0.0591f,  -0.0437f,0.9990f,0.0097f,  -0.0586f,-0.0122f,0.9982f,  13.6419f,-4.8395f,-8.7747f,  
/* M016 */   0.9954f,0.0610f,0.0736f,  -0.0614f,0.9981f,0.0043f,  -0.0732f,-0.0088f,0.9973f,  16.1870f,-7.0275f,-8.4794f,  
/* M017 */   0.9936f,0.0754f,0.0838f,  -0.0757f,0.9971f,0.0008f,  -0.0835f,-0.0071f,0.9965f,  16.2079f,-8.9338f,-8.4630f,  
/* M018 */   0.9932f,0.0791f,0.0859f,  -0.0796f,0.9968f,0.0018f,  -0.0855f,-0.0087f,0.9963f,  12.4581f,-10.2119f,-9.0073f,  
/* M019 */   0.9962f,0.0519f,0.0700f,  -0.0532f,0.9985f,0.0158f,  -0.0691f,-0.0195f,0.9974f,  -0.8366f,-9.4065f,-11.7039f,  
/* M020 */   0.9990f,0.0050f,0.0436f,  -0.0067f,0.9993f,0.0379f,  -0.0434f,-0.0381f,0.9983f,  -19.8102f,-6.5207f,-15.5799f,  
/* M021 */   0.9994f,-0.0195f,0.0275f,  0.0180f,0.9985f,0.0526f,  -0.0284f,-0.0521f,0.9982f,  -31.1863f,-5.0338f,-17.7357f,  
/* M022 */   0.9995f,-0.0140f,0.0276f,  0.0123f,0.9981f,0.0601f,  -0.0284f,-0.0597f,0.9978f,  -32.4654f,-6.2183f,-18.8224f,  
/* M023 */   0.9994f,0.0015f,0.0343f,  -0.0038f,0.9977f,0.0672f,  -0.0341f,-0.0673f,0.9972f,  -30.3975f,-8.0936f,-20.4116f,  
/* M024 */   0.9989f,0.0235f,0.0397f,  -0.0264f,0.9970f,0.0721f,  -0.0378f,-0.0731f,0.9966f,  -27.5263f,-10.6809f,-21.7657f,  
/* M025 */   0.9982f,0.0491f,0.0354f,  -0.0516f,0.9959f,0.0740f,  -0.0317f,-0.0757f,0.9966f,  -25.5212f,-13.8986f,-22.3612f,  
/* M026 */   0.9971f,0.0751f,0.0133f,  -0.0759f,0.9944f,0.0734f,  -0.0077f,-0.0742f,0.9972f,  -24.5863f,-17.0241f,-21.4903f,  
/* M027 */   0.9945f,0.0988f,-0.0353f,  -0.0961f,0.9928f,0.0709f,  0.0421f,-0.0672f,0.9969f,  -25.9758f,-19.8120f,-18.8252f,  
/* M028 */   0.9839f,0.1231f,-0.1296f,  -0.1158f,0.9913f,0.0628f,  0.1362f,-0.0468f,0.9896f,  -29.5204f,-22.8959f,-12.1705f,  
/* M029 */   0.9429f,0.1632f,-0.2903f,  -0.1548f,0.9866f,0.0520f,  0.2948f,-0.0041f,0.9555f,  -29.0462f,-25.4716f,-0.3617f,  
/* M030 */   0.8445f,0.2116f,-0.4920f,  -0.2133f,0.9755f,0.0535f,  0.4913f,0.0598f,0.8689f,  -21.8228f,-23.9187f,11.7721f,  
/* M031 */   0.6951f,0.2452f,-0.6758f,  -0.2653f,0.9612f,0.0759f,  0.6682f,0.1265f,0.7331f,  -13.1255f,-18.7675f,17.9799f,  
/* M032 */   0.5286f,0.2402f,-0.8142f,  -0.2807f,0.9546f,0.0994f,  0.8011f,0.1760f,0.5721f,  -11.7901f,-11.7818f,21.9396f,  
/* M033 */   0.3474f,0.2056f,-0.9149f,  -0.2660f,0.9572f,0.1141f,  0.8992f,0.2037f,0.3872f,  -16.7816f,-3.2280f,26.3027f,  
/* M034 */   0.1461f,0.1767f,-0.9734f,  -0.2397f,0.9609f,0.1385f,  0.9598f,0.2131f,0.1828f,  -23.4868f,3.0413f,24.0994f,  
/* M035 */   -0.0349f,0.1687f,-0.9850f,  -0.1958f,0.9654f,0.1723f,  0.9800f,0.1989f,-0.0007f,  -36.5160f,6.1277f,13.8250f,  
/* M036 */   -0.1867f,0.1674f,-0.9680f,  -0.1356f,0.9715f,0.1942f,  0.9730f,0.1675f,-0.1587f,  -56.2483f,6.5045f,4.2067f,  
/* M037 */   -0.3368f,0.1597f,-0.9279f,  -0.0730f,0.9781f,0.1948f,  0.9387f,0.1334f,-0.3178f,  -75.8296f,4.6888f,1.3250f,  
/* M038 */   -0.5015f,0.1433f,-0.8532f,  -0.0154f,0.9845f,0.1745f,  0.8650f,0.1007f,-0.4915f,  -89.6458f,0.9560f,5.4715f,  
/* M039 */   -0.6300f,0.1265f,-0.7662f,  0.0288f,0.9898f,0.1398f,  0.7760f,0.0660f,-0.6272f,  -99.3196f,-1.6479f,12.5732f,  
/* M040 */   -0.6849f,0.1093f,-0.7203f,  0.0511f,0.9935f,0.1022f,  0.7268f,0.0331f,-0.6860f,  -108.3804f,-3.3073f,20.3480f,  
/* M041 */   -0.6776f,0.0834f,-0.7307f,  0.0572f,0.9965f,0.0607f,  0.7332f,-0.0006f,-0.6800f,  -118.8323f,-2.0314f,30.9939f,  
/* M042 */   -0.6467f,0.0485f,-0.7612f,  0.0594f,0.9981f,0.0132f,  0.7604f,-0.0367f,-0.6484f,  -130.1341f,1.8739f,43.9831f,  
/* M043 */   -0.6125f,0.0125f,-0.7903f,  0.0625f,0.9975f,-0.0326f,  0.7880f,-0.0694f,-0.6118f,  -141.2964f,6.7562f,55.9674f,  
/* M044 */   -0.5981f,-0.0161f,-0.8013f,  0.0652f,0.9955f,-0.0687f,  0.7988f,-0.0933f,-0.5944f,  -149.4406f,12.6888f,64.0472f,  
/* M045 */   -0.6050f,-0.0376f,-0.7953f,  0.0671f,0.9929f,-0.0979f,  0.7934f,-0.1126f,-0.5982f,  -153.5810f,20.8635f,69.0769f,  
/* M046 */   -0.6244f,-0.0573f,-0.7790f,  0.0652f,0.9900f,-0.1252f,  0.7784f,-0.1290f,-0.6144f,  -153.7533f,32.0514f,72.1853f,  
/* M047 */   -0.6637f,-0.0721f,-0.7446f,  0.0548f,0.9880f,-0.1445f,  0.7460f,-0.1367f,-0.6517f,  -148.8785f,40.3372f,71.7689f,  
/* M048 */   -0.7275f,-0.0778f,-0.6817f,  0.0349f,0.9881f,-0.1501f,  0.6852f,-0.1330f,-0.7161f,  -139.0081f,44.5612f,66.6475f,  
/* M049 */   -0.8189f,-0.0798f,-0.5684f,  0.0049f,0.9893f,-0.1459f,  0.5740f,-0.1223f,-0.8097f,  -125.8068f,45.2840f,55.5134f,  
/* M050 */   -0.9200f,-0.0718f,-0.3853f,  -0.0200f,0.9904f,-0.1369f,  0.3914f,-0.1183f,-0.9126f,  -113.1232f,42.1815f,38.5195f,  
/* M051 */   -0.9913f,-0.0284f,-0.1289f,  -0.0133f,0.9931f,-0.1168f,  0.1313f,-0.1141f,-0.9848f,  -104.8568f,33.6279f,13.2637f,  
/* M052 */   -0.9733f,0.0426f,0.2256f,  0.0243f,0.9962f,-0.0835f,  -0.2283f,-0.0757f,-0.9706f,  -103.8700f,22.6910f,-26.7195f,  
/* M053 */   -0.7787f,0.0981f,0.6197f,  0.0725f,0.9951f,-0.0665f,  -0.6232f,-0.0069f,-0.7820f,  -117.7208f,12.7840f,-72.8563f,  
/* M054 */   -0.4179f,0.1208f,0.9004f,  0.1142f,0.9902f,-0.0799f,  -0.9013f,0.0695f,-0.4277f,  -147.6239f,6.2555f,-109.0081f,  
/* M055 */   -0.0227f,0.1173f,0.9928f,  0.1270f,0.9854f,-0.1135f,  -0.9916f,0.1235f,-0.0373f,  -180.0314f,2.8448f,-126.6298f,  
/* M056 */   0.3160f,0.0984f,0.9436f,  0.0926f,0.9867f,-0.1339f,  -0.9442f,0.1297f,0.3027f,  -200.2925f,1.0682f,-135.8173f,  
/* M057 */   0.5746f,0.0724f,0.8152f,  0.0373f,0.9927f,-0.1144f,  -0.8176f,0.0962f,0.5677f,  -212.1613f,0.3186f,-148.8491f,  
/* M058 */   0.7268f,0.0464f,0.6853f,  0.0034f,0.9975f,-0.0711f,  -0.6869f,0.0540f,0.7248f,  -222.8691f,0.4631f,-165.0827f,  
/* M059 */   0.8055f,0.0141f,0.5924f,  -0.0024f,0.9998f,-0.0205f,  -0.5926f,0.0151f,0.8054f,  -234.7811f,1.7457f,-183.4773f,  
/* M060 */   0.8520f,-0.0267f,0.5229f,  0.0084f,0.9993f,0.0373f,  -0.5235f,-0.0274f,0.8516f,  -248.1501f,4.8262f,-205.1145f,  
/* M061 */   0.8765f,-0.0717f,0.4760f,  0.0308f,0.9952f,0.0930f,  -0.4804f,-0.0669f,0.8745f,  -262.3349f,9.3615f,-227.6352f,  
/* M062 */   0.8863f,-0.1150f,0.4486f,  0.0576f,0.9885f,0.1396f,  -0.4595f,-0.0978f,0.8828f,  -276.0907f,14.4589f,-249.0075f,  
/* M063 */   0.8871f,-0.1495f,0.4366f,  0.0810f,0.9818f,0.1716f,  -0.4543f,-0.1168f,0.8831f,  -288.7679f,18.7999f,-267.8873f,  
/* M064 */   0.8683f,-0.1676f,0.4669f,  0.0892f,0.9786f,0.1855f,  -0.4880f,-0.1194f,0.8647f,  -294.7645f,20.3210f,-284.2061f,  
/* M065 */   0.8243f,-0.1699f,0.5400f,  0.0805f,0.9794f,0.1854f,  -0.5604f,-0.1093f,0.8210f,  -291.7950f,19.1832f,-298.0284f,  
/* M066 */   0.7727f,-0.1640f,0.6132f,  0.0664f,0.9816f,0.1790f,  -0.6313f,-0.0976f,0.7694f,  -285.7971f,20.7201f,-308.8760f,  
/* M067 */   0.7414f,-0.1620f,0.6512f,  0.0597f,0.9825f,0.1765f,  -0.6684f,-0.0919f,0.7381f,  -284.7455f,26.6330f,-318.8723f,  
/* M068 */   0.7434f,-0.1721f,0.6463f,  0.0658f,0.9805f,0.1854f,  -0.6656f,-0.0953f,0.7402f,  -291.7372f,33.0182f,-330.5624f,  
/* M069 */   0.7566f,-0.1897f,0.6257f,  0.0783f,0.9764f,0.2012f,  -0.6491f,-0.1032f,0.7537f,  -301.9290f,40.7666f,-344.9575f,  
/* M070 */   0.7686f,-0.2073f,0.6053f,  0.0918f,0.9720f,0.2163f,  -0.6332f,-0.1107f,0.7661f,  -312.1722f,46.4977f,-360.4810f,  
/* M071 */   0.7756f,-0.2150f,0.5934f,  0.0992f,0.9700f,0.2218f,  -0.6234f,-0.1132f,0.7737f,  -320.4849f,48.0322f,-373.2209f,  
/* M072 */   0.7877f,-0.2015f,0.5821f,  0.0959f,0.9736f,0.2071f,  -0.6085f,-0.1073f,0.7863f,  -327.2624f,44.0903f,-379.8846f,  
/* M073 */   0.8083f,-0.1728f,0.5629f,  0.0851f,0.9802f,0.1788f,  -0.5826f,-0.0966f,0.8070f,  -333.5938f,37.2866f,-382.2700f,  
/* M074 */   0.8252f,-0.1460f,0.5457f,  0.0729f,0.9855f,0.1533f,  -0.5602f,-0.0867f,0.8238f,  -338.6536f,31.6119f,-384.4616f,  
/* M075 */   0.8281f,-0.1376f,0.5434f,  0.0682f,0.9870f,0.1458f,  -0.5564f,-0.0837f,0.8267f,  -342.5035f,32.2342f,-391.2873f,  
/* M076 */   0.8178f,-0.1467f,0.5565f,  0.0716f,0.9854f,0.1545f,  -0.5711f,-0.0865f,0.8163f,  -346.2401f,37.5278f,-403.1878f,  
/* M077 */   0.8053f,-0.1598f,0.5709f,  0.0773f,0.9831f,0.1662f,  -0.5878f,-0.0898f,0.8040f,  -351.2062f,41.0441f,-416.6566f,  
/* M078 */   0.7991f,-0.1853f,0.5720f,  0.0958f,0.9784f,0.1831f,  -0.5936f,-0.0916f,0.7996f,  -362.3253f,43.7167f,-431.2978f,  
/* M079 */   0.7974f,-0.2166f,0.5632f,  0.1226f,0.9721f,0.2002f,  -0.5908f,-0.0906f,0.8017f,  -377.5020f,44.8505f,-445.6110f,  
/* M080 */   0.7938f,-0.2297f,0.5632f,  0.1332f,0.9691f,0.2075f,  -0.5935f,-0.0897f,0.7998f,  -388.3822f,42.3870f,-458.2625f,  
/* M081 */   0.7887f,-0.2209f,0.5737f,  0.1227f,0.9710f,0.2053f,  -0.6024f,-0.0915f,0.7929f,  -392.9535f,37.4791f,-468.9549f,  
/* M082 */   0.7904f,-0.2037f,0.5778f,  0.1053f,0.9742f,0.1994f,  -0.6035f,-0.0967f,0.7915f,  -396.3112f,29.4948f,-477.9444f,  
/* M083 */   0.8020f,-0.1850f,0.5680f,  0.0877f,0.9770f,0.1943f,  -0.5909f,-0.1060f,0.7998f,  -401.0097f,25.1111f,-486.4826f,  
/* M084 */   0.8238f,-0.1702f,0.5408f,  0.0753f,0.9783f,0.1932f,  -0.5619f,-0.1185f,0.8187f,  -408.7109f,27.6094f,-495.4312f,  
/* M085 */   0.8560f,-0.1597f,0.4916f,  0.0707f,0.9783f,0.1947f,  -0.5121f,-0.1319f,0.8488f,  -420.2627f,33.0534f,-504.1785f,  
/* M086 */   0.8966f,-0.1538f,0.4152f,  0.0765f,0.9774f,0.1969f,  -0.4361f,-0.1448f,0.8882f,  -436.0992f,37.5538f,-511.4914f,  
/* M087 */   0.9413f,-0.1506f,0.3020f,  0.0933f,0.9761f,0.1960f,  -0.3243f,-0.1564f,0.9329f,  -456.2800f,41.7594f,-516.0919f,  
/* M088 */   0.9778f,-0.1468f,0.1496f,  0.1174f,0.9749f,0.1889f,  -0.1736f,-0.1671f,0.9705f,  -479.4834f,43.5558f,-516.8980f,  
/* M089 */   0.9894f,-0.1421f,-0.0286f,  0.1449f,0.9737f,0.1759f,  0.0029f,-0.1782f,0.9840f,  -503.6110f,43.0472f,-513.7342f,  
/* M090 */   0.9683f,-0.1353f,-0.2099f,  0.1701f,0.9727f,0.1580f,  0.1827f,-0.1887f,0.9649f,  -526.1537f,40.0751f,-507.3627f,  
/* M091 */   0.9202f,-0.1256f,-0.3707f,  0.1885f,0.9723f,0.1384f,  0.3431f,-0.1972f,0.9184f,  -545.3783f,34.4032f,-499.1676f,  
/* M092 */   0.8563f,-0.1137f,-0.5038f,  0.1994f,0.9726f,0.1193f,  0.4764f,-0.2027f,0.8555f,  -561.4406f,29.0819f,-490.8930f,  
/* M093 */   0.7836f,-0.1020f,-0.6128f,  0.2059f,0.9733f,0.1013f,  0.5861f,-0.2056f,0.7837f,  -575.1338f,23.7456f,-483.4965f,  
/* M094 */   0.7116f,-0.0929f,-0.6964f,  0.2104f,0.9739f,0.0851f,  0.6703f,-0.2070f,0.7126f,  -586.8079f,19.8505f,-477.6500f,  
/* M095 */   0.6568f,-0.0945f,-0.7481f,  0.2211f,0.9726f,0.0713f,  0.7209f,-0.2122f,0.6597f,  -598.8090f,20.0233f,-474.7756f,  
/* M096 */   0.6269f,-0.1047f,-0.7721f,  0.2357f,0.9700f,0.0599f,  0.7426f,-0.2195f,0.6327f,  -611.2112f,21.3914f,-475.2010f,  
/* M097 */   0.6148f,-0.1105f,-0.7809f,  0.2400f,0.9694f,0.0519f,  0.7513f,-0.2193f,0.6225f,  -620.6091f,22.5001f,-478.1398f,  
/* M098 */   0.6165f,-0.1092f,-0.7797f,  0.2330f,0.9713f,0.0482f,  0.7521f,-0.2114f,0.6243f,  -627.3093f,21.7866f,-483.4656f,  
/* M099 */   0.6273f,-0.1073f,-0.7713f,  0.2236f,0.9736f,0.0464f,  0.7460f,-0.2016f,0.6348f,  -633.9892f,19.5067f,-489.9785f,  
/* M100 */   0.6379f,-0.1134f,-0.7618f,  0.2215f,0.9743f,0.0404f,  0.7376f,-0.1945f,0.6466f,  -641.7063f,15.6437f,-495.0252f,  
/* M101 */   0.6405f,-0.1286f,-0.7571f,  0.2272f,0.9735f,0.0269f,  0.7335f,-0.1893f,0.6528f,  -649.9606f,11.2687f,-496.7778f,  
/* M102 */   0.6309f,-0.1244f,-0.7659f,  0.2041f,0.9789f,0.0091f,  0.7486f,-0.1621f,0.6430f,  -648.4365f,3.2293f,-494.8883f,  
/* M103 */   0.6165f,-0.1018f,-0.7808f,  0.1576f,0.9875f,-0.0043f,  0.7714f,-0.1204f,0.6248f,  -639.2482f,-4.5947f,-492.6604f,  
/* M104 */   0.6119f,-0.0957f,-0.7851f,  0.1396f,0.9901f,-0.0119f,  0.7785f,-0.1023f,0.6192f,  -639.3591f,-5.4068f,-492.4903f,  
/* M105 */   0.6190f,-0.1110f,-0.7775f,  0.1564f,0.9875f,-0.0165f,  0.7696f,-0.1114f,0.6287f,  -651.1933f,-0.9347f,-493.9149f,  
/* M106 */   0.6272f,-0.1286f,-0.7682f,  0.1788f,0.9837f,-0.0188f,  0.7581f,-0.1255f,0.6399f,  -664.2502f,4.8674f,-496.0044f,  
/* M107 */   0.6350f,-0.1485f,-0.7581f,  0.2047f,0.9786f,-0.0203f,  0.7449f,-0.1423f,0.6518f,  -677.6639f,11.7369f,-498.3021f,  
/* M108 */   0.6413f,-0.1704f,-0.7481f,  0.2322f,0.9724f,-0.0224f,  0.7313f,-0.1593f,0.6632f,  -691.0911f,19.3493f,-500.1956f,  
/* M109 */   0.6455f,-0.1933f,-0.7389f,  0.2590f,0.9655f,-0.0263f,  0.7185f,-0.1745f,0.6733f,  -704.2849f,27.2901f,-501.0785f,  
/* M110 */   0.6471f,-0.2158f,-0.7312f,  0.2829f,0.9586f,-0.0325f,  0.7080f,-0.1858f,0.6814f,  -716.4454f,35.0484f,-500.6838f,  
/* M111 */   0.6463f,-0.2363f,-0.7256f,  0.3015f,0.9526f,-0.0416f,  0.7010f,-0.1919f,0.6868f,  -726.7913f,42.0320f,-498.9073f,  
/* M112 */   0.6432f,-0.2528f,-0.7228f,  0.3125f,0.9484f,-0.0536f,  0.6990f,-0.1914f,0.6890f,  -734.5824f,47.6031f,-495.7761f,  
/* M113 */   0.6382f,-0.2636f,-0.7234f,  0.3139f,0.9470f,-0.0682f,  0.7030f,-0.1835f,0.6871f,  -739.3185f,51.1862f,-491.5331f,  
/* M114 */   0.6274f,-0.2710f,-0.7300f,  0.3048f,0.9481f,-0.0901f,  0.7166f,-0.1660f,0.6775f,  -740.5698f,52.6733f,-484.5995f,  
/* M115 */   0.6126f,-0.2804f,-0.7390f,  0.2892f,0.9497f,-0.1206f,  0.7356f,-0.1398f,0.6628f,  -738.9777f,52.7272f,-474.9403f,  
/* M116 */   0.5984f,-0.2915f,-0.7463f,  0.2694f,0.9504f,-0.1552f,  0.7545f,-0.1081f,0.6473f,  -735.2955f,51.7241f,-464.3115f,  
/* M117 */   0.5869f,-0.3032f,-0.7507f,  0.2475f,0.9500f,-0.1902f,  0.7709f,-0.0742f,0.6326f,  -730.1885f,49.9979f,-453.8424f,  
/* M118 */   0.5802f,-0.3141f,-0.7515f,  0.2257f,0.9485f,-0.2222f,  0.7826f,-0.0407f,0.6213f,  -724.7020f,47.6039f,-444.7151f,  
/* M119 */   0.5811f,-0.3218f,-0.7475f,  0.2054f,0.9467f,-0.2480f,  0.7875f,-0.0094f,0.6163f,  -719.9236f,44.1973f,-438.0509f,  
/* M120 */   0.5923f,-0.3239f,-0.7378f,  0.1876f,0.9459f,-0.2647f,  0.7836f,0.0183f,0.6210f,  -716.5010f,39.2624f,-434.8430f,  
/* M121 */   0.6096f,-0.2903f,-0.7377f,  0.1460f,0.9557f,-0.2554f,  0.7792f,0.0480f,0.6250f,  -706.6389f,27.2822f,-438.4750f,  
/* M122 */   0.6234f,-0.2135f,-0.7522f,  0.0677f,0.9731f,-0.2201f,  0.7790f,0.0863f,0.6211f,  -686.0817f,8.3192f,-448.1823f,  
/* M123 */   0.6302f,-0.1255f,-0.7662f,  -0.0228f,0.9834f,-0.1799f,  0.7761f,0.1309f,0.6169f,  -661.8693f,-10.6217f,-458.9482f,  
/* M124 */   0.6290f,-0.0401f,-0.7764f,  -0.1172f,0.9823f,-0.1458f,  0.7685f,0.1827f,0.6132f,  -636.4866f,-27.2833f,-467.5883f,  
/* M125 */   0.6172f,0.0507f,-0.7852f,  -0.2218f,0.9687f,-0.1118f,  0.7549f,0.2431f,0.6091f,  -607.0295f,-41.7798f,-475.6968f,  
/* M126 */   0.5950f,0.1471f,-0.7902f,  -0.3304f,0.9410f,-0.0736f,  0.7327f,0.3049f,0.6085f,  -574.4458f,-52.8670f,-485.1524f,  
/* M127 */   0.5627f,0.2500f,-0.7879f,  -0.4375f,0.8988f,-0.0272f,  0.7014f,0.3600f,0.6152f,  -540.5457f,-59.8561f,-497.8599f,  
/* M128 */   0.5205f,0.3605f,-0.7740f,  -0.5376f,0.8427f,0.0310f,  0.6634f,0.4000f,0.6324f,  -507.2052f,-62.3943f,-515.5634f,  
/* M129 */   0.4642f,0.4776f,-0.7459f,  -0.6317f,0.7688f,0.0992f,  0.6209f,0.4251f,0.6586f,  -474.2325f,-59.1834f,-537.9092f,  
/* M130 */   0.3890f,0.5943f,-0.7039f,  -0.7198f,0.6729f,0.1703f,  0.5749f,0.4405f,0.6896f,  -441.5266f,-48.6455f,-562.5048f,  
/* M131 */   0.2964f,0.7019f,-0.6477f,  -0.7957f,0.5566f,0.2389f,  0.5282f,0.4446f,0.7235f,  -410.9759f,-30.3719f,-587.8034f,  
/* M132 */   0.1901f,0.7931f,-0.5787f,  -0.8544f,0.4240f,0.3004f,  0.4836f,0.4373f,0.7582f,  -384.4736f,-4.9086f,-612.1602f,  
/* M133 */   0.0756f,0.8627f,-0.5001f,  -0.8929f,0.2817f,0.3511f,  0.4438f,0.4200f,0.7916f,  -363.4220f,26.3898f,-634.0995f,  
/* M134 */   -0.0406f,0.9082f,-0.4165f,  -0.9110f,0.1376f,0.3887f,  0.4103f,0.3952f,0.8219f,  -348.5046f,61.3499f,-652.4999f,  
/* M135 */   -0.1516f,0.9305f,-0.3334f,  -0.9108f,-0.0005f,0.4128f,  0.3839f,0.3663f,0.8476f,  -339.5886f,97.2999f,-666.7255f,  
/* M136 */   -0.2532f,0.9328f,-0.2564f,  -0.8963f,-0.1265f,0.4249f,  0.3640f,0.3375f,0.8681f,  -335.8323f,131.8172f,-676.8036f,  
/* M137 */   -0.3422f,0.9201f,-0.1903f,  -0.8721f,-0.2356f,0.4289f,  0.3498f,0.3128f,0.8831f,  -336.0965f,162.7108f,-683.4075f,  
/* M138 */   -0.4164f,0.8990f,-0.1357f,  -0.8421f,-0.3251f,0.4303f,  0.3427f,0.2935f,0.8924f,  -339.3331f,188.5851f,-688.1168f,  
/* M139 */   -0.4759f,0.8749f,-0.0897f,  -0.8099f,-0.3961f,0.4327f,  0.3430f,0.2785f,0.8971f,  -344.5921f,210.1192f,-692.3447f,  
/* M140 */   -0.5206f,0.8522f,-0.0513f,  -0.7789f,-0.4495f,0.4373f,  0.3497f,0.2676f,0.8978f,  -350.7780f,227.7066f,-696.5245f,  
/* M141 */   -0.5512f,0.8342f,-0.0196f,  -0.7520f,-0.4865f,0.4448f,  0.3615f,0.2599f,0.8954f,  -356.9355f,240.9639f,-700.8401f,  
/* M142 */   -0.5697f,0.8218f,0.0052f,  -0.7315f,-0.5099f,0.4527f,  0.3747f,0.2542f,0.8916f,  -362.0447f,250.1915f,-704.6315f,  
/* M143 */   -0.5789f,0.8151f,0.0224f,  -0.7187f,-0.5230f,0.4582f,  0.3852f,0.2492f,0.8886f,  -365.3398f,255.8806f,-707.1181f,  
/* M144 */   -0.5797f,0.8142f,0.0325f,  -0.7142f,-0.5269f,0.4607f,  0.3922f,0.2439f,0.8870f,  -366.5055f,257.9508f,-708.1331f,  
/* M145 */   -0.5748f,0.8174f,0.0382f,  -0.7151f,-0.5245f,0.4621f,  0.3977f,0.2383f,0.8860f,  -366.3014f,257.6313f,-708.2278f,  
/* M146 */   -0.5668f,0.8227f,0.0422f,  -0.7179f,-0.5184f,0.4646f,  0.4041f,0.2331f,0.8845f,  -365.7249f,256.4102f,-708.3460f,  
/* M147 */   -0.5558f,0.8301f,0.0444f,  -0.7225f,-0.5088f,0.4682f,  0.4112f,0.2282f,0.8825f,  -364.9314f,254.5370f,-708.8340f,  
/* M148 */   -0.5419f,0.8393f,0.0447f,  -0.7286f,-0.4956f,0.4728f,  0.4190f,0.2236f,0.8800f,  -363.9334f,251.8501f,-709.5958f,  
/* M149 */   -0.5251f,0.8500f,0.0433f,  -0.7361f,-0.4791f,0.4782f,  0.4272f,0.2192f,0.8772f,  -362.6804f,248.0942f,-710.2739f,  
/* M150 */   -0.5055f,0.8619f,0.0400f,  -0.7447f,-0.4592f,0.4844f,  0.4358f,0.2150f,0.8740f,  -361.2331f,243.3742f,-710.8053f,  
/* M151 */   -0.4833f,0.8748f,0.0348f,  -0.7541f,-0.4361f,0.4911f,  0.4447f,0.2111f,0.8704f,  -359.6572f,237.7430f,-711.1224f,  
/* M152 */   -0.4585f,0.8883f,0.0274f,  -0.7641f,-0.4098f,0.4982f,  0.4538f,0.2075f,0.8666f,  -358.0206f,231.2135f,-711.1539f,  
/* M153 */   -0.4314f,0.9020f,0.0179f,  -0.7744f,-0.3804f,0.5056f,  0.4629f,0.2042f,0.8626f,  -356.3917f,223.8298f,-710.8239f,  
/* M154 */   -0.4021f,0.9156f,0.0061f,  -0.7846f,-0.3479f,0.5131f,  0.4719f,0.2015f,0.8583f,  -354.8358f,215.6398f,-710.0508f,  
/* M155 */   -0.3708f,0.9287f,-0.0083f,  -0.7946f,-0.3126f,0.5206f,  0.4808f,0.1996f,0.8538f,  -353.3729f,206.6969f,-708.4816f,  
/* M156 */   -0.3379f,0.9409f,-0.0254f,  -0.8039f,-0.2744f,0.5277f,  0.4895f,0.1987f,0.8491f,  -352.0221f,197.0630f,-705.8104f,  
/* M157 */   -0.3036f,0.9517f,-0.0455f,  -0.8124f,-0.2336f,0.5343f,  0.4978f,0.1992f,0.8441f,  -350.8336f,186.8115f,-702.0168f,  
/* M158 */   -0.2634f,0.9615f,-0.0788f,  -0.8260f,-0.1825f,0.5334f,  0.4984f,0.2056f,0.8422f,  -347.9984f,173.3508f,-694.4106f,  
/* M159 */   -0.2139f,0.9683f,-0.1290f,  -0.8410f,-0.1154f,0.5285f,  0.4969f,0.2216f,0.8391f,  -344.9707f,154.9416f,-683.3362f,  
/* M160 */   -0.1595f,0.9687f,-0.1902f,  -0.8486f,-0.0361f,0.5278f,  0.5044f,0.2456f,0.8278f,  -344.5541f,133.1076f,-671.2656f,  
/* M161 */   -0.1041f,0.9600f,-0.2598f,  -0.8474f,0.0512f,0.5285f,  0.5207f,0.2752f,0.8082f,  -346.8588f,109.4875f,-657.9754f,  
/* M162 */   -0.0511f,0.9411f,-0.3342f,  -0.8369f,0.1423f,0.5286f,  0.5450f,0.3067f,0.7803f,  -351.7856f,85.5889f,-643.4529f,  
/* M163 */   -0.0022f,0.9126f,-0.4088f,  -0.8173f,0.2339f,0.5266f,  0.5762f,0.3353f,0.7454f,  -359.2281f,63.3163f,-628.3271f,  
/* M164 */   0.0749f,0.8662f,-0.4941f,  -0.7976f,0.3494f,0.4917f,  0.5985f,0.3573f,0.7170f,  -368.3486f,35.7214f,-603.4922f,  
/* M165 */   0.1738f,0.7920f,-0.5852f,  -0.7696f,0.4800f,0.4211f,  0.6144f,0.3772f,0.6930f,  -381.4161f,5.6552f,-568.4221f,  
/* M166 */   0.2380f,0.7111f,-0.6616f,  -0.7229f,0.5846f,0.3683f,  0.6487f,0.3906f,0.6531f,  -398.5971f,-14.5288f,-540.0950f,  
/* M167 */   0.2626f,0.6351f,-0.7264f,  -0.6649f,0.6647f,0.3407f,  0.6992f,0.3935f,0.5968f,  -416.6441f,-26.3753f,-518.1429f,  
/* M168 */   0.2781f,0.5510f,-0.7868f,  -0.6031f,0.7377f,0.3034f,  0.7476f,0.3901f,0.5374f,  -434.5085f,-35.9849f,-490.9708f,  
/* M169 */   0.2852f,0.4621f,-0.8397f,  -0.5393f,0.8016f,0.2580f,  0.7923f,0.3793f,0.4779f,  -451.9818f,-43.2363f,-461.2386f,  
/* M170 */   0.2853f,0.3725f,-0.8831f,  -0.4755f,0.8550f,0.2070f,  0.8321f,0.3609f,0.4211f,  -468.8674f,-47.8392f,-432.0656f,  
/* M171 */   0.2803f,0.2862f,-0.9162f,  -0.4136f,0.8974f,0.1537f,  0.8662f,0.3359f,0.3699f,  -484.8705f,-49.5712f,-405.0032f,  
/* M172 */   0.2724f,0.2073f,-0.9396f,  -0.3555f,0.9291f,0.1019f,  0.8941f,0.3063f,0.3268f,  -499.4144f,-48.7875f,-379.8507f,  
/* M173 */   0.2617f,0.1372f,-0.9554f,  -0.3028f,0.9515f,0.0537f,  0.9164f,0.2752f,0.2905f,  -511.8295f,-45.9539f,-357.0652f,  
/* M174 */   0.2460f,0.0873f,-0.9653f,  -0.2570f,0.9662f,0.0218f,  0.9346f,0.2427f,0.2601f,  -521.4260f,-42.2276f,-340.2788f,  
/* M175 */   0.2271f,0.0621f,-0.9719f,  -0.2165f,0.9762f,0.0118f,  0.9495f,0.2078f,0.2351f,  -528.7271f,-38.8642f,-330.7685f,  
/* M176 */   0.2095f,0.0517f,-0.9764f,  -0.1794f,0.9837f,0.0136f,  0.9612f,0.1723f,0.2153f,  -534.5823f,-35.7878f,-325.1336f,  
/* M177 */   0.1968f,0.0458f,-0.9794f,  -0.1441f,0.9894f,0.0173f,  0.9698f,0.1377f,0.2013f,  -539.3696f,-32.6699f,-319.6236f,  
/* M178 */   0.1915f,0.0339f,-0.9809f,  -0.1095f,0.9939f,0.0130f,  0.9754f,0.1049f,0.1940f,  -543.3503f,-28.6168f,-310.6142f,  
/* M179 */   0.1949f,0.0127f,-0.9807f,  -0.0739f,0.9973f,-0.0017f,  0.9780f,0.0729f,0.1953f,  -547.5113f,-23.0426f,-297.8434f,  
/* M180 */   0.2294f,-0.0014f,-0.9733f,  -0.0442f,0.9990f,-0.0118f,  0.9723f,0.0458f,0.2291f,  -551.9636f,-17.5439f,-287.5127f,  
/* M181 */   0.2871f,-0.0007f,-0.9579f,  -0.0287f,0.9995f,-0.0093f,  0.9575f,0.0302f,0.2869f,  -554.1118f,-13.4377f,-282.4837f,  
/* M182 */   0.3111f,0.0039f,-0.9504f,  -0.0302f,0.9995f,-0.0058f,  0.9499f,0.0305f,0.3111f,  -549.5134f,-10.5320f,-276.6865f,  
/* M183 */   0.2816f,-0.0013f,-0.9595f,  -0.0391f,0.9992f,-0.0129f,  0.9587f,0.0412f,0.2813f,  -539.8337f,-7.9292f,-266.0831f,  
/* M184 */   0.2459f,-0.0106f,-0.9692f,  -0.0477f,0.9986f,-0.0230f,  0.9681f,0.0518f,0.2451f,  -529.7726f,-5.6000f,-255.3237f,  
/* M185 */   0.2577f,-0.0091f,-0.9662f,  -0.0608f,0.9978f,-0.0256f,  0.9643f,0.0653f,0.2566f,  -520.7180f,-4.2970f,-249.1839f,  
/* M186 */   0.2924f,-0.0026f,-0.9563f,  -0.0761f,0.9968f,-0.0260f,  0.9533f,0.0804f,0.2912f,  -512.0701f,-3.3744f,-244.6495f,  
/* M187 */   0.3222f,-0.0028f,-0.9467f,  -0.0779f,0.9965f,-0.0295f,  0.9435f,0.0833f,0.3208f,  -507.2513f,-1.8145f,-238.9230f,  
/* M188 */   0.3379f,-0.0111f,-0.9411f,  -0.0654f,0.9972f,-0.0352f,  0.9389f,0.0735f,0.3363f,  -506.0998f,0.4372f,-231.6842f,  
/* M189 */   0.3489f,-0.0205f,-0.9369f,  -0.0495f,0.9980f,-0.0402f,  0.9359f,0.0604f,0.3472f,  -505.9877f,2.6961f,-224.5845f,  
/* M190 */   0.3556f,-0.0305f,-0.9341f,  -0.0308f,0.9985f,-0.0444f,  0.9341f,0.0446f,0.3541f,  -506.8524f,4.9158f,-217.8547f,  
/* M191 */   0.3586f,-0.0407f,-0.9326f,  -0.0102f,0.9988f,-0.0475f,  0.9334f,0.0265f,0.3578f,  -508.6171f,7.1366f,-211.6910f,  
/* M192 */   0.3585f,-0.0505f,-0.9322f,  0.0117f,0.9987f,-0.0496f,  0.9335f,0.0069f,0.3586f,  -511.1982f,9.4071f,-206.2602f,  
/* M193 */   0.3559f,-0.0597f,-0.9326f,  0.0341f,0.9981f,-0.0509f,  0.9339f,-0.0137f,0.3573f,  -514.5112f,11.6850f,-201.7064f,  
/* M194 */   0.3514f,-0.0679f,-0.9338f,  0.0562f,0.9971f,-0.0514f,  0.9345f,-0.0344f,0.3542f,  -518.1202f,13.9180f,-197.7883f,  
/* M195 */   0.3456f,-0.0750f,-0.9354f,  0.0773f,0.9957f,-0.0513f,  0.9352f,-0.0546f,0.3500f,  -521.5182f,16.0457f,-194.1773f,  
/* M196 */   0.3393f,-0.0811f,-0.9372f,  0.0968f,0.9940f,-0.0509f,  0.9357f,-0.0734f,0.3451f,  -524.5234f,17.9999f,-190.8711f,  
/* M197 */   0.3120f,-0.0885f,-0.9460f,  0.1168f,0.9917f,-0.0543f,  0.9429f,-0.0935f,0.3197f,  -526.4691f,20.1875f,-185.4769f,  
/* M198 */   0.2834f,-0.0955f,-0.9542f,  0.1272f,0.9900f,-0.0613f,  0.9505f,-0.1040f,0.2927f,  -525.3742f,21.6029f,-179.5251f,  
/* M199 */   0.2695f,-0.1018f,-0.9576f,  0.1256f,0.9896f,-0.0698f,  0.9548f,-0.1014f,0.2795f,  -521.6071f,21.9325f,-174.5068f,  
/* M200 */   0.2418f,-0.1116f,-0.9639f,  0.1252f,0.9887f,-0.0831f,  0.9622f,-0.1006f,0.2531f,  -517.3909f,22.8197f,-167.3604f,  
/* M201 */   0.2071f,-0.1248f,-0.9703f,  0.1272f,0.9868f,-0.0998f,  0.9700f,-0.1028f,0.2203f,  -513.7889f,24.3742f,-158.6907f,  
/* M202 */   0.1875f,-0.1380f,-0.9725f,  0.1250f,0.9854f,-0.1158f,  0.9743f,-0.0999f,0.2020f,  -510.5365f,25.5850f,-151.0266f,  
/* M203 */   0.1717f,-0.1514f,-0.9734f,  0.1206f,0.9839f,-0.1318f,  0.9778f,-0.0947f,0.1871f,  -507.2282f,26.7136f,-143.5464f,  
/* M204 */   0.1589f,-0.1645f,-0.9735f,  0.1150f,0.9824f,-0.1472f,  0.9806f,-0.0885f,0.1750f,  -504.0566f,27.8074f,-136.4657f,  
/* M205 */   0.1483f,-0.1765f,-0.9731f,  0.1095f,0.9808f,-0.1612f,  0.9829f,-0.0826f,0.1648f,  -501.1850f,28.8845f,-130.0004f,  
/* M206 */   0.1389f,-0.1867f,-0.9725f,  0.1051f,0.9793f,-0.1730f,  0.9847f,-0.0782f,0.1557f,  -498.7408f,29.8783f,-124.3690f,  
/* M207 */   0.1298f,-0.1945f,-0.9723f,  0.1030f,0.9779f,-0.1819f,  0.9862f,-0.0766f,0.1470f,  -496.8204f,30.7219f,-119.7921f,  
/* M208 */   0.1226f,-0.1985f,-0.9724f,  0.1033f,0.9770f,-0.1864f,  0.9871f,-0.0776f,0.1403f,  -495.6281f,31.2598f,-116.7476f,  
/* M209 */   0.1183f,-0.1996f,-0.9727f,  0.1052f,0.9766f,-0.1876f,  0.9874f,-0.0802f,0.1365f,  -495.0685f,31.5392f,-114.9435f,  
/* M210 */   0.1145f,-0.1997f,-0.9731f,  0.1080f,0.9763f,-0.1876f,  0.9875f,-0.0836f,0.1333f,  -494.8072f,31.7877f,-113.5784f,  
/* M211 */   0.1111f,-0.1989f,-0.9737f,  0.1114f,0.9761f,-0.1867f,  0.9875f,-0.0877f,0.1306f,  -494.7820f,31.9631f,-112.5995f,  
/* M212 */   0.1081f,-0.1972f,-0.9744f,  0.1151f,0.9760f,-0.1848f,  0.9875f,-0.0922f,0.1282f,  -494.9300f,32.0546f,-111.9539f,  
/* M213 */   0.1052f,-0.1947f,-0.9752f,  0.1190f,0.9761f,-0.1821f,  0.9873f,-0.0969f,0.1258f,  -495.1883f,32.0524f,-111.5885f,  
/* M214 */   0.1022f,-0.1915f,-0.9762f,  0.1227f,0.9762f,-0.1786f,  0.9872f,-0.1015f,0.1233f,  -495.5661f,31.9466f,-111.5236f,  
/* M215 */   0.0991f,-0.1875f,-0.9772f,  0.1262f,0.9765f,-0.1746f,  0.9870f,-0.1060f,0.1205f,  -496.1040f,31.7530f,-111.7735f,  
/* M216 */   0.0958f,-0.1832f,-0.9784f,  0.1297f,0.9768f,-0.1702f,  0.9869f,-0.1106f,0.1174f,  -496.8577f,31.5145f,-112.3400f,  
/* M217 */   0.0924f,-0.1785f,-0.9796f,  0.1333f,0.9772f,-0.1654f,  0.9868f,-0.1152f,0.1141f,  -497.8485f,31.2579f,-113.2051f,  
/* M218 */   0.0890f,-0.1736f,-0.9808f,  0.1369f,0.9775f,-0.1606f,  0.9866f,-0.1200f,0.1108f,  -499.0442f,31.0001f,-114.2828f,  
/* M219 */   0.0857f,-0.1687f,-0.9819f,  0.1407f,0.9777f,-0.1557f,  0.9863f,-0.1248f,0.1075f,  -500.4107f,30.7559f,-115.4890f,  
/* M220 */   0.0824f,-0.1640f,-0.9830f,  0.1447f,0.9779f,-0.1510f,  0.9860f,-0.1298f,0.1043f,  -501.9135f,30.5457f,-116.7404f,  
/* M221 */   0.0794f,-0.1596f,-0.9840f,  0.1489f,0.9779f,-0.1466f,  0.9857f,-0.1348f,0.1014f,  -503.5182f,30.3913f,-117.9540f,  
/* M222 */   0.0764f,-0.1555f,-0.9849f,  0.1532f,0.9779f,-0.1425f,  0.9852f,-0.1400f,0.0985f,  -505.1658f,30.3051f,-119.0519f,  
/* M223 */   0.0731f,-0.1520f,-0.9857f,  0.1577f,0.9776f,-0.1391f,  0.9848f,-0.1453f,0.0954f,  -506.8193f,30.2943f,-119.9975f,  
/* M224 */   0.0697f,-0.1491f,-0.9864f,  0.1622f,0.9773f,-0.1363f,  0.9843f,-0.1505f,0.0923f,  -508.4743f,30.3668f,-120.7710f,  
/* M225 */   0.0709f,-0.1464f,-0.9867f,  0.1672f,0.9769f,-0.1330f,  0.9834f,-0.1555f,0.0937f,  -510.6302f,30.4620f,-121.9871f,  
/* M226 */   0.0758f,-0.1448f,-0.9866f,  0.1726f,0.9764f,-0.1301f,  0.9821f,-0.1605f,0.0990f,  -513.1805f,30.6818f,-123.3261f,  
/* M227 */   0.0757f,-0.1462f,-0.9863f,  0.1775f,0.9754f,-0.1310f,  0.9812f,-0.1652f,0.0998f,  -515.2260f,31.2644f,-123.3412f,  
/* M228 */   0.0702f,-0.1502f,-0.9862f,  0.1823f,0.9739f,-0.1353f,  0.9807f,-0.1703f,0.0957f,  -516.8028f,32.1984f,-122.1457f,  
/* M229 */   0.0645f,-0.1545f,-0.9859f,  0.1876f,0.9722f,-0.1401f,  0.9801f,-0.1760f,0.0917f,  -518.4651f,33.2654f,-120.8499f,  
/* M230 */   0.0587f,-0.1591f,-0.9855f,  0.1931f,0.9704f,-0.1451f,  0.9794f,-0.1818f,0.0877f,  -520.0938f,34.3865f,-119.4818f,  
/* M231 */   0.0531f,-0.1636f,-0.9851f,  0.1981f,0.9686f,-0.1502f,  0.9787f,-0.1872f,0.0838f,  -521.5732f,35.4793f,-118.0694f,  
/* M232 */   0.0478f,-0.1678f,-0.9847f,  0.2022f,0.9670f,-0.1550f,  0.9782f,-0.1917f,0.0801f,  -522.7908f,36.4578f,-116.6393f,  
/* M233 */   0.0430f,-0.1715f,-0.9842f,  0.2049f,0.9657f,-0.1593f,  0.9778f,-0.1948f,0.0767f,  -523.6519f,37.2340f,-115.2724f,  
/* M234 */   0.0391f,-0.1744f,-0.9839f,  0.2055f,0.9650f,-0.1629f,  0.9779f,-0.1958f,0.0736f,  -524.0731f,37.6846f,-114.0852f,  
/* M235 */   0.0363f,-0.1765f,-0.9836f,  0.2043f,0.9648f,-0.1656f,  0.9782f,-0.1950f,0.0711f,  -524.1263f,37.8409f,-113.0764f,  
/* M236 */   0.0341f,-0.1784f,-0.9834f,  0.2022f,0.9648f,-0.1680f,  0.9788f,-0.1931f,0.0690f,  -523.9784f,37.8484f,-112.1795f,  
/* M237 */   0.0322f,-0.1802f,-0.9831f,  0.2001f,0.9649f,-0.1703f,  0.9793f,-0.1912f,0.0671f,  -523.7706f,37.8530f,-111.3205f,  
/* M238 */   0.0301f,-0.1824f,-0.9828f,  0.1988f,0.9647f,-0.1730f,  0.9796f,-0.1901f,0.0653f,  -523.6421f,38.0003f,-110.4254f,  
/* M239 */   0.0281f,-0.1851f,-0.9823f,  0.1985f,0.9642f,-0.1760f,  0.9797f,-0.1900f,0.0638f,  -523.6456f,38.3040f,-109.5020f,  
/* M240 */   0.0263f,-0.1879f,-0.9818f,  0.1986f,0.9636f,-0.1791f,  0.9797f,-0.1903f,0.0627f,  -523.7341f,38.6635f,-108.6069f,  
/* M241 */   0.0248f,-0.1907f,-0.9813f,  0.1989f,0.9629f,-0.1821f,  0.9797f,-0.1907f,0.0618f,  -523.8959f,39.0523f,-107.7390f,  
/* M242 */   0.0235f,-0.1935f,-0.9808f,  0.1994f,0.9623f,-0.1850f,  0.9796f,-0.1912f,0.0611f,  -524.1188f,39.4440f,-106.8970f,  
/* M243 */   0.0222f,-0.1961f,-0.9803f,  0.1997f,0.9617f,-0.1879f,  0.9796f,-0.1916f,0.0605f,  -524.3901f,39.8122f,-106.0783f,  
/* M244 */   0.0222f,-0.1961f,-0.9803f,  0.1997f,0.9617f,-0.1879f,  0.9796f,-0.1916f,0.0605f,  -524.3901f,39.8122f,-106.0783f,  

_NULL_ }; /* End of head_pData */


/* MESH ANIMATION 1 */

#define hand_left_NumFrames  243

const float hand_left_pData[] = {
/* M001 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,-0.0000f,-0.0000f,  
/* M002 */   0.9999f,0.0099f,-0.0019f,  -0.0099f,0.9999f,-0.0036f,  0.0018f,0.0037f,1.0000f,  2.5688f,-0.8043f,0.7426f,  
/* M003 */   0.9998f,0.0192f,-0.0038f,  -0.0192f,0.9998f,-0.0076f,  0.0037f,0.0077f,1.0000f,  5.0317f,-1.5952f,1.5842f,  
/* M004 */   0.9996f,0.0265f,-0.0052f,  -0.0265f,0.9996f,-0.0103f,  0.0050f,0.0105f,0.9999f,  7.0453f,-2.1716f,2.0873f,  
/* M005 */   0.9995f,0.0304f,-0.0054f,  -0.0304f,0.9995f,-0.0099f,  0.0051f,0.0101f,0.9999f,  8.2731f,-2.3135f,1.7885f,  
/* M006 */   0.9995f,0.0323f,-0.0040f,  -0.0324f,0.9995f,-0.0062f,  0.0038f,0.0063f,1.0000f,  9.1359f,-2.0639f,0.6215f,  
/* M007 */   0.9994f,0.0338f,-0.0014f,  -0.0338f,0.9994f,-0.0003f,  0.0014f,0.0004f,1.0000f,  9.9330f,-1.6097f,-1.0903f,  
/* M008 */   0.9994f,0.0335f,0.0016f,  -0.0335f,0.9994f,0.0070f,  -0.0014f,-0.0071f,1.0000f,  10.1527f,-0.9638f,-3.2303f,  
/* M009 */   0.9995f,0.0300f,0.0042f,  -0.0301f,0.9994f,0.0153f,  -0.0037f,-0.0154f,0.9999f,  9.2839f,-0.1448f,-5.6730f,  
/* M010 */   0.9998f,0.0191f,0.0096f,  -0.0193f,0.9995f,0.0251f,  -0.0091f,-0.0253f,0.9996f,  6.5763f,1.0531f,-8.7664f,  
/* M011 */   0.9998f,0.0038f,0.0170f,  -0.0044f,0.9993f,0.0361f,  -0.0168f,-0.0361f,0.9992f,  3.1453f,2.4736f,-12.3023f,  
/* M012 */   0.9998f,-0.0060f,0.0199f,  0.0051f,0.9989f,0.0461f,  -0.0202f,-0.0460f,0.9987f,  0.9980f,3.4478f,-15.3915f,  
/* M013 */   0.9999f,-0.0004f,0.0119f,  -0.0002f,0.9986f,0.0529f,  -0.0119f,-0.0529f,0.9985f,  1.9071f,3.1833f,-17.1913f,  
/* M014 */   0.9999f,0.0153f,-0.0058f,  -0.0149f,0.9981f,0.0591f,  0.0067f,-0.0590f,0.9982f,  4.4415f,2.1778f,-18.2765f,  
/* M015 */   0.9992f,0.0291f,-0.0277f,  -0.0271f,0.9973f,0.0684f,  0.0296f,-0.0676f,0.9973f,  5.7665f,1.3951f,-19.6609f,  
/* M016 */   0.9975f,0.0466f,-0.0523f,  -0.0425f,0.9961f,0.0779f,  0.0557f,-0.0755f,0.9956f,  6.6886f,0.3069f,-20.9258f,  
/* M017 */   0.9943f,0.0710f,-0.0790f,  -0.0642f,0.9943f,0.0857f,  0.0846f,-0.0801f,0.9932f,  7.5759f,-1.3658f,-21.7556f,  
/* M018 */   0.9892f,0.0985f,-0.1086f,  -0.0887f,0.9918f,0.0922f,  0.1167f,-0.0816f,0.9898f,  8.0097f,-3.3493f,-22.0359f,  
/* M019 */   0.9819f,0.1257f,-0.1416f,  -0.1124f,0.9888f,0.0982f,  0.1524f,-0.0805f,0.9850f,  7.9931f,-5.4065f,-21.6788f,  
/* M020 */   0.9726f,0.1492f,-0.1785f,  -0.1320f,0.9857f,0.1044f,  0.1915f,-0.0780f,0.9784f,  7.2376f,-7.2945f,-20.7707f,  
/* M021 */   0.9618f,0.1712f,-0.2135f,  -0.1506f,0.9825f,0.1093f,  0.2284f,-0.0729f,0.9708f,  6.7511f,-9.1801f,-19.4572f,  
/* M022 */   0.9418f,0.2213f,-0.2529f,  -0.2050f,0.9747f,0.0894f,  0.2663f,-0.0324f,0.9633f,  15.3977f,-13.9569f,-12.4837f,  
/* M023 */   0.9072f,0.2961f,-0.2989f,  -0.2977f,0.9538f,0.0414f,  0.2973f,0.0515f,0.9534f,  34.8295f,-20.1871f,1.2960f,  
/* M024 */   0.8695f,0.3623f,-0.3357f,  -0.3870f,0.9220f,-0.0072f,  0.3069f,0.1362f,0.9419f,  55.4633f,-23.6123f,14.7540f,  
/* M025 */   0.8473f,0.4053f,-0.3431f,  -0.4386f,0.8984f,-0.0218f,  0.2995f,0.1689f,0.9390f,  66.6244f,-24.2431f,17.6246f,  
/* M026 */   0.8438f,0.4392f,-0.3085f,  -0.4546f,0.8904f,0.0243f,  0.2853f,0.1197f,0.9509f,  68.3806f,-22.2569f,1.8489f,  
/* M027 */   0.8493f,0.4665f,-0.2470f,  -0.4531f,0.8844f,0.1125f,  0.2709f,0.0163f,0.9625f,  66.4470f,-15.7851f,-25.8515f,  
/* M028 */   0.8653f,0.4670f,-0.1823f,  -0.4292f,0.8779f,0.2122f,  0.2591f,-0.1054f,0.9601f,  58.7610f,-5.7189f,-55.0858f,  
/* M029 */   0.8906f,0.4330f,-0.1394f,  -0.3818f,0.8781f,0.2882f,  0.2472f,-0.2035f,0.9474f,  43.7613f,3.0086f,-76.7478f,  
/* M030 */   0.9299f,0.3434f,-0.1316f,  -0.2909f,0.9058f,0.3080f,  0.2250f,-0.2481f,0.9422f,  16.3386f,5.2113f,-81.7154f,  
/* M031 */   0.9583f,0.2352f,-0.1621f,  -0.1827f,0.9409f,0.2852f,  0.2196f,-0.2436f,0.9447f,  -16.4433f,6.8984f,-74.2358f,  
/* M032 */   0.9475f,0.1811f,-0.2637f,  -0.1066f,0.9559f,0.2737f,  0.3016f,-0.2312f,0.9250f,  -45.6588f,11.8182f,-69.0069f,  
/* M033 */   0.8907f,0.1659f,-0.4233f,  -0.0414f,0.9567f,0.2880f,  0.4528f,-0.2390f,0.8590f,  -76.3113f,19.3255f,-68.6989f,  
/* M034 */   0.7875f,0.1492f,-0.5979f,  0.0404f,0.9557f,0.2917f,  0.6149f,-0.2539f,0.7466f,  -111.7621f,28.7499f,-63.4950f,  
/* M035 */   0.6119f,0.1468f,-0.7772f,  0.1318f,0.9499f,0.2833f,  0.7798f,-0.2758f,0.5619f,  -148.7812f,36.9684f,-51.5294f,  
/* M036 */   0.3620f,0.1667f,-0.9171f,  0.2320f,0.9368f,0.2619f,  0.9028f,-0.3076f,0.3005f,  -183.2320f,44.5261f,-32.9827f,  
/* M037 */   0.0596f,0.2168f,-0.9744f,  0.3424f,0.9124f,0.2240f,  0.9377f,-0.3470f,-0.0199f,  -212.0514f,51.7689f,-9.2569f,  
/* M038 */   -0.2760f,0.3445f,-0.8973f,  0.5070f,0.8453f,0.1685f,  0.8165f,-0.4084f,-0.4080f,  -242.4987f,65.3493f,17.5650f,  
/* M039 */   -0.5464f,0.5400f,-0.6402f,  0.6762f,0.7355f,0.0433f,  0.4942f,-0.4092f,-0.7670f,  -263.1270f,80.4228f,53.9018f,  
/* M040 */   -0.6549f,0.7015f,-0.2813f,  0.7467f,0.6581f,-0.0971f,  0.1170f,-0.2736f,-0.9547f,  -259.2027f,79.1663f,81.1255f,  
/* M041 */   -0.6202f,0.7741f,0.1271f,  0.7588f,0.6331f,-0.1529f,  -0.1988f,0.0016f,-0.9800f,  -246.6512f,56.2555f,73.3186f,  
/* M042 */   -0.4571f,0.7191f,0.5233f,  0.7634f,0.6191f,-0.1839f,  -0.4563f,0.3154f,-0.8321f,  -239.2721f,33.8507f,44.5295f,  
/* M043 */   -0.2360f,0.5847f,0.7762f,  0.7223f,0.6399f,-0.2624f,  -0.6501f,0.4987f,-0.5733f,  -225.8213f,18.4759f,24.5791f,  
/* M044 */   -0.0069f,0.4716f,0.8818f,  0.5700f,0.7264f,-0.3840f,  -0.8216f,0.5000f,-0.2738f,  -183.2372f,2.1409f,18.6904f,  
/* M045 */   0.2163f,0.4225f,0.8802f,  0.3120f,0.8243f,-0.4723f,  -0.9251f,0.3768f,0.0464f,  -117.5228f,-5.6830f,4.7977f,  
/* M046 */   0.3803f,0.4304f,0.8186f,  0.0563f,0.8727f,-0.4850f,  -0.9232f,0.2305f,0.3077f,  -60.6791f,2.8542f,-23.2619f,  
/* M047 */   0.4495f,0.4619f,0.7646f,  -0.1322f,0.8809f,-0.4545f,  -0.8834f,0.1032f,0.4570f,  -21.5006f,21.5247f,-52.7141f,  
/* M048 */   0.4480f,0.4857f,0.7506f,  -0.2756f,0.8737f,-0.4009f,  -0.8505f,-0.0273f,0.5253f,  9.3501f,42.8171f,-81.6344f,  
/* M049 */   0.4303f,0.4678f,0.7720f,  -0.3650f,0.8724f,-0.3251f,  -0.8256f,-0.1419f,0.5461f,  25.1672f,61.3278f,-112.5928f,  
/* M050 */   0.4247f,0.4311f,0.7961f,  -0.4316f,0.8694f,-0.2406f,  -0.7958f,-0.2414f,0.5553f,  28.1497f,77.5287f,-145.0637f,  
/* M051 */   0.4248f,0.3757f,0.8237f,  -0.4724f,0.8681f,-0.1524f,  -0.7723f,-0.3244f,0.5462f,  20.6597f,88.7273f,-175.4281f,  
/* M052 */   0.4134f,0.2637f,0.8715f,  -0.4375f,0.8970f,-0.0639f,  -0.7986f,-0.3549f,0.4862f,  1.8834f,86.8439f,-198.8399f,  
/* M053 */   0.3907f,0.1142f,0.9134f,  -0.3517f,0.9355f,0.0334f,  -0.8507f,-0.3343f,0.4056f,  -24.8575f,80.1678f,-220.7865f,  
/* M054 */   0.3828f,-0.0582f,0.9220f,  -0.2482f,0.9549f,0.1633f,  -0.8899f,-0.2913f,0.3511f,  -61.7974f,76.9141f,-251.1870f,  
/* M055 */   0.3707f,-0.2239f,0.9014f,  -0.1183f,0.9512f,0.2849f,  -0.9212f,-0.2123f,0.3262f,  -108.6049f,76.0807f,-278.9622f,  
/* M056 */   0.3814f,-0.3237f,0.8659f,  -0.0004f,0.9366f,0.3504f,  -0.9244f,-0.1340f,0.3571f,  -155.4038f,75.0566f,-294.2577f,  
/* M057 */   0.4439f,-0.3642f,0.8188f,  0.0879f,0.9270f,0.3646f,  -0.8918f,-0.0899f,0.4435f,  -199.0483f,72.0961f,-297.9072f,  
/* M058 */   0.5349f,-0.3828f,0.7532f,  0.1628f,0.9215f,0.3527f,  -0.8291f,-0.0660f,0.5552f,  -241.5632f,68.4207f,-293.2475f,  
/* M059 */   0.6306f,-0.3922f,0.6697f,  0.2273f,0.9184f,0.3238f,  -0.7421f,-0.0520f,0.6683f,  -279.5750f,64.8621f,-283.0587f,  
/* M060 */   0.7100f,-0.3998f,0.5797f,  0.2837f,0.9158f,0.2842f,  -0.6445f,-0.0374f,0.7637f,  -311.4614f,62.0859f,-271.2784f,  
/* M061 */   0.7739f,-0.4097f,0.4829f,  0.3361f,0.9120f,0.2351f,  -0.5367f,-0.0197f,0.8435f,  -340.3961f,60.5359f,-260.5398f,  
/* M062 */   0.8277f,-0.4196f,0.3725f,  0.3789f,0.9077f,0.1804f,  -0.4138f,-0.0082f,0.9103f,  -367.2467f,60.1592f,-250.7939f,  
/* M063 */   0.8670f,-0.4244f,0.2610f,  0.4038f,0.9054f,0.1311f,  -0.2920f,-0.0083f,0.9564f,  -389.0013f,60.3819f,-243.7341f,  
/* M064 */   0.8937f,-0.4177f,0.1636f,  0.4063f,0.9083f,0.0996f,  -0.1902f,-0.0226f,0.9815f,  -403.9945f,59.8867f,-243.2443f,  
/* M065 */   0.9138f,-0.3928f,0.1031f,  0.3828f,0.9180f,0.1038f,  -0.1354f,-0.0554f,0.9892f,  -409.3254f,58.5751f,-256.0098f,  
/* M066 */   0.9328f,-0.3528f,0.0738f,  0.3414f,0.9304f,0.1334f,  -0.1158f,-0.0992f,0.9883f,  -406.5480f,58.2348f,-278.2834f,  
/* M067 */   0.9508f,-0.3067f,0.0445f,  0.2961f,0.9414f,0.1615f,  -0.0915f,-0.1404f,0.9859f,  -402.1483f,62.4122f,-299.7313f,  
/* M068 */   0.9648f,-0.2617f,-0.0239f,  0.2619f,0.9501f,0.1696f,  -0.0216f,-0.1699f,0.9852f,  -404.7487f,69.0661f,-312.1229f,  
/* M069 */   0.9605f,-0.2049f,-0.1883f,  0.2338f,0.9611f,0.1468f,  0.1509f,-0.1850f,0.9711f,  -418.3503f,69.6332f,-306.2331f,  
/* M070 */   0.9074f,-0.1403f,-0.3961f,  0.2028f,0.9718f,0.1204f,  0.3680f,-0.1896f,0.9103f,  -433.1672f,67.5652f,-291.3828f,  
/* M071 */   0.8346f,-0.1033f,-0.5411f,  0.1936f,0.9746f,0.1124f,  0.5157f,-0.1986f,0.8334f,  -445.6896f,67.1445f,-283.4276f,  
/* M072 */   0.7829f,-0.1131f,-0.6118f,  0.2266f,0.9676f,0.1112f,  0.5794f,-0.2257f,0.7832f,  -461.7738f,71.3132f,-281.7041f,  
/* M073 */   0.7419f,-0.1486f,-0.6538f,  0.2822f,0.9538f,0.1035f,  0.6082f,-0.2613f,0.7495f,  -479.6362f,77.3581f,-278.3015f,  
/* M074 */   0.7113f,-0.1864f,-0.6777f,  0.3353f,0.9374f,0.0941f,  0.6178f,-0.2942f,0.7293f,  -493.6978f,82.7350f,-276.0388f,  
/* M075 */   0.6919f,-0.2019f,-0.6931f,  0.3644f,0.9265f,0.0938f,  0.6233f,-0.3175f,0.7147f,  -500.7786f,84.1393f,-278.3474f,  
/* M076 */   0.6850f,-0.1759f,-0.7070f,  0.3589f,0.9260f,0.1174f,  0.6340f,-0.3342f,0.6974f,  -498.4085f,81.3562f,-287.6673f,  
/* M077 */   0.6914f,-0.1227f,-0.7119f,  0.3302f,0.9302f,0.1604f,  0.6425f,-0.3460f,0.6837f,  -489.1475f,76.4566f,-304.1914f,  
/* M078 */   0.7134f,-0.0682f,-0.6974f,  0.2890f,0.9353f,0.2042f,  0.6384f,-0.3472f,0.6869f,  -478.2748f,69.1995f,-325.6301f,  
/* M079 */   0.7548f,-0.0131f,-0.6558f,  0.2304f,0.9414f,0.2464f,  0.6141f,-0.3371f,0.7136f,  -465.2709f,59.9523f,-351.1775f,  
/* M080 */   0.8056f,0.0429f,-0.5909f,  0.1602f,0.9445f,0.2869f,  0.5704f,-0.3258f,0.7540f,  -450.3166f,50.1301f,-378.8892f,  
/* M081 */   0.8519f,0.0756f,-0.5182f,  0.1005f,0.9475f,0.3034f,  0.5140f,-0.3106f,0.7996f,  -439.4481f,41.5023f,-401.2608f,  
/* M082 */   0.9004f,0.0588f,-0.4312f,  0.0735f,0.9560f,0.2839f,  0.4289f,-0.2873f,0.8564f,  -437.8199f,35.6893f,-415.2079f,  
/* M083 */   0.9406f,0.0170f,-0.3392f,  0.0704f,0.9673f,0.2438f,  0.3322f,-0.2532f,0.9086f,  -442.6564f,28.3449f,-423.4225f,  
/* M084 */   0.9542f,0.0002f,-0.2992f,  0.0635f,0.9771f,0.2032f,  0.2924f,-0.2129f,0.9323f,  -449.0937f,22.3536f,-427.2992f,  
/* M085 */   0.9468f,0.0152f,-0.3214f,  0.0412f,0.9849f,0.1680f,  0.3191f,-0.1723f,0.9319f,  -454.3796f,20.1233f,-428.0493f,  
/* M086 */   0.9269f,0.0344f,-0.3737f,  0.0177f,0.9907f,0.1350f,  0.3749f,-0.1318f,0.9177f,  -460.4897f,20.1514f,-427.0429f,  
/* M087 */   0.8888f,0.0514f,-0.4554f,  -0.0015f,0.9940f,0.1091f,  0.4582f,-0.0963f,0.8836f,  -468.5712f,19.5038f,-424.8611f,  
/* M088 */   0.8222f,0.0631f,-0.5657f,  -0.0122f,0.9956f,0.0933f,  0.5691f,-0.0698f,0.8193f,  -478.7391f,19.6359f,-421.7448f,  
/* M089 */   0.7200f,0.0696f,-0.6905f,  -0.0132f,0.9962f,0.0866f,  0.6938f,-0.0532f,0.7182f,  -489.5858f,18.9640f,-417.5010f,  
/* M090 */   0.5762f,0.0720f,-0.8141f,  -0.0034f,0.9963f,0.0857f,  0.8173f,-0.0466f,0.5743f,  -499.9680f,17.4436f,-410.8484f,  
/* M091 */   0.3942f,0.0743f,-0.9160f,  0.0133f,0.9962f,0.0865f,  0.9189f,-0.0463f,0.3917f,  -507.8039f,14.5749f,-401.7216f,  
/* M092 */   0.2001f,0.0787f,-0.9766f,  0.0310f,0.9958f,0.0866f,  0.9793f,-0.0476f,0.1968f,  -512.4666f,9.7697f,-392.1359f,  
/* M093 */   0.0143f,0.0863f,-0.9962f,  0.0458f,0.9952f,0.0869f,  0.9988f,-0.0469f,0.0103f,  -514.5568f,5.6507f,-384.4657f,  
/* M094 */   -0.1531f,0.0978f,-0.9834f,  0.0571f,0.9943f,0.0900f,  0.9866f,-0.0424f,-0.1578f,  -514.9114f,1.2730f,-380.6775f,  
/* M095 */   -0.2981f,0.1235f,-0.9465f,  0.0696f,0.9918f,0.1074f,  0.9520f,-0.0339f,-0.3042f,  -515.2458f,-2.9121f,-383.7152f,  
/* M096 */   -0.4250f,0.1556f,-0.8917f,  0.0866f,0.9876f,0.1310f,  0.9011f,-0.0215f,-0.4332f,  -515.9166f,-5.3962f,-390.4245f,  
/* M097 */   -0.5333f,0.1699f,-0.8287f,  0.1005f,0.9854f,0.1373f,  0.8399f,-0.0101f,-0.5426f,  -515.6200f,-7.2548f,-393.4978f,  
/* M098 */   -0.6273f,0.1604f,-0.7621f,  0.1051f,0.9870f,0.1212f,  0.7717f,-0.0041f,-0.6360f,  -512.9458f,-6.6709f,-390.8090f,  
/* M099 */   -0.7109f,0.1427f,-0.6886f,  0.1064f,0.9898f,0.0952f,  0.6952f,-0.0056f,-0.7188f,  -509.2836f,-4.7016f,-385.8401f,  
/* M100 */   -0.7844f,0.1278f,-0.6069f,  0.1124f,0.9916f,0.0635f,  0.6099f,-0.0184f,-0.7922f,  -506.8430f,-2.2486f,-379.7501f,  
/* M101 */   -0.8447f,0.1336f,-0.5183f,  0.1402f,0.9898f,0.0266f,  0.5165f,-0.0502f,-0.8548f,  -509.5716f,-0.7918f,-372.8204f,  
/* M102 */   -0.8893f,0.1677f,-0.4254f,  0.1967f,0.9802f,-0.0248f,  0.4128f,-0.1057f,-0.9046f,  -519.3194f,1.6739f,-362.2377f,  
/* M103 */   -0.9154f,0.2197f,-0.3372f,  0.2617f,0.9615f,-0.0839f,  0.3058f,-0.1651f,-0.9377f,  -531.2710f,6.8846f,-349.9833f,  
/* M104 */   -0.9256f,0.2700f,-0.2654f,  0.3111f,0.9419f,-0.1266f,  0.2158f,-0.1997f,-0.9558f,  -540.2784f,12.7610f,-342.9329f,  
/* M105 */   -0.9292f,0.2990f,-0.2174f,  0.3309f,0.9348f,-0.1287f,  0.1648f,-0.1916f,-0.9676f,  -545.3080f,13.8513f,-346.6005f,  
/* M106 */   -0.9343f,0.3087f,-0.1785f,  0.3306f,0.9375f,-0.1091f,  0.1337f,-0.1609f,-0.9779f,  -547.1994f,11.3311f,-355.8289f,  
/* M107 */   -0.9425f,0.3083f,-0.1290f,  0.3224f,0.9404f,-0.1082f,  0.0879f,-0.1436f,-0.9857f,  -544.6556f,11.5506f,-360.7746f,  
/* M108 */   -0.9522f,0.2982f,-0.0660f,  0.3048f,0.9416f,-0.1428f,  0.0195f,-0.1561f,-0.9875f,  -536.2268f,17.1514f,-357.3132f,  
/* M109 */   -0.9602f,0.2792f,-0.0016f,  0.2742f,0.9418f,-0.1943f,  -0.0527f,-0.1870f,-0.9809f,  -523.5284f,26.2780f,-350.2240f,  
/* M110 */   -0.9663f,0.2507f,0.0579f,  0.2297f,0.9418f,-0.2454f,  -0.1161f,-0.2239f,-0.9677f,  -508.3526f,37.0541f,-343.2801f,  
/* M111 */   -0.9741f,0.2051f,0.0949f,  0.1702f,0.9421f,-0.2889f,  -0.1487f,-0.2652f,-0.9527f,  -492.5950f,49.6484f,-336.8672f,  
/* M112 */   -0.9825f,0.1486f,0.1125f,  0.1043f,0.9386f,-0.3288f,  -0.1544f,-0.3113f,-0.9377f,  -478.0738f,64.7607f,-329.9074f,  
/* M113 */   -0.9853f,0.1041f,0.1354f,  0.0474f,0.9282f,-0.3690f,  -0.1640f,-0.3571f,-0.9195f,  -465.7496f,80.7201f,-323.3185f,  
/* M114 */   -0.9776f,0.0967f,0.1871f,  0.0107f,0.9101f,-0.4143f,  -0.2103f,-0.4030f,-0.8907f,  -455.0723f,95.9818f,-318.4644f,  
/* M115 */   -0.9494f,0.1481f,0.2769f,  -0.0025f,0.8783f,-0.4781f,  -0.3140f,-0.4546f,-0.8335f,  -445.0085f,110.9995f,-314.2979f,  
/* M116 */   -0.8936f,0.2480f,0.3742f,  -0.0019f,0.8314f,-0.5557f,  -0.4489f,-0.4973f,-0.7424f,  -436.3257f,124.7872f,-310.3162f,  
/* M117 */   -0.8135f,0.3672f,0.4509f,  0.0060f,0.7807f,-0.6249f,  -0.5815f,-0.5057f,-0.6373f,  -430.7790f,133.1703f,-308.4144f,  
/* M118 */   -0.7287f,0.4715f,0.4967f,  0.0244f,0.7427f,-0.6692f,  -0.6844f,-0.4755f,-0.5527f,  -430.9920f,133.4383f,-308.6148f,  
/* M119 */   -0.6441f,0.5550f,0.5264f,  0.0681f,0.7270f,-0.6832f,  -0.7619f,-0.4042f,-0.5061f,  -439.9622f,123.1683f,-311.7640f,  
/* M120 */   -0.5594f,0.6099f,0.5614f,  0.1286f,0.7329f,-0.6681f,  -0.8188f,-0.3016f,-0.4884f,  -455.0883f,103.9710f,-320.2569f,  
/* M121 */   -0.5057f,0.6110f,0.6091f,  0.1767f,0.7644f,-0.6201f,  -0.8444f,-0.2060f,-0.4945f,  -468.7288f,80.6138f,-336.0212f,  
/* M122 */   -0.5109f,0.5368f,0.6714f,  0.1907f,0.8324f,-0.5204f,  -0.8382f,-0.1378f,-0.5277f,  -473.9283f,53.9063f,-364.1171f,  
/* M123 */   -0.5518f,0.4046f,0.7292f,  0.1687f,0.9105f,-0.3776f,  -0.8167f,-0.0854f,-0.5707f,  -469.4856f,29.0012f,-402.7975f,  
/* M124 */   -0.5809f,0.2636f,0.7701f,  0.1216f,0.9636f,-0.2380f,  -0.8049f,-0.0446f,-0.5918f,  -458.4918f,12.1851f,-441.6194f,  
/* M125 */   -0.5837f,0.1273f,0.8019f,  0.0586f,0.9917f,-0.1148f,  -0.8099f,-0.0201f,-0.5863f,  -443.7576f,2.8828f,-477.3784f,  
/* M126 */   -0.5704f,-0.0115f,0.8213f,  -0.0188f,0.9998f,0.0010f,  -0.8212f,-0.0149f,-0.5705f,  -425.6654f,0.5769f,-510.5544f,  
/* M127 */   -0.5406f,-0.1268f,0.8316f,  -0.0925f,0.9915f,0.0911f,  -0.8362f,-0.0277f,-0.5478f,  -408.4141f,3.1280f,-536.4275f,  
/* M128 */   -0.4965f,-0.1955f,0.8458f,  -0.1562f,0.9785f,0.1345f,  -0.8539f,-0.0653f,-0.5163f,  -393.5552f,7.2060f,-550.7197f,  
/* M129 */   -0.4453f,-0.2282f,0.8658f,  -0.2069f,0.9670f,0.1485f,  -0.8711f,-0.1130f,-0.4779f,  -382.0442f,10.0916f,-558.2966f,  
/* M130 */   -0.3981f,-0.2597f,0.8798f,  -0.2368f,0.9557f,0.1749f,  -0.8862f,-0.1387f,-0.4420f,  -376.1601f,10.2525f,-568.8206f,  
/* M131 */   -0.3563f,-0.3031f,0.8838f,  -0.2361f,0.9444f,0.2287f,  -0.9041f,-0.1272f,-0.4081f,  -378.0410f,6.4746f,-586.1454f,  
/* M132 */   -0.3210f,-0.3528f,0.8789f,  -0.2154f,0.9309f,0.2950f,  -0.9223f,-0.0946f,-0.3748f,  -384.7463f,1.3001f,-606.5704f,  
/* M133 */   -0.2989f,-0.4193f,0.8573f,  -0.2005f,0.9058f,0.3731f,  -0.9330f,-0.0604f,-0.3548f,  -390.1066f,0.4683f,-627.9966f,  
/* M134 */   -0.2943f,-0.5099f,0.8083f,  -0.1949f,0.8600f,0.4716f,  -0.9356f,-0.0188f,-0.3525f,  -393.1652f,6.5499f,-651.6630f,  
/* M135 */   -0.3020f,-0.6074f,0.7347f,  -0.1884f,0.7935f,0.5786f,  -0.9345f,0.0363f,-0.3542f,  -396.2018f,18.0458f,-676.0907f,  
/* M136 */   -0.3117f,-0.6889f,0.6545f,  -0.1881f,0.7199f,0.6681f,  -0.9314f,0.0851f,-0.3539f,  -397.4604f,32.3901f,-695.6724f,  
/* M137 */   -0.3091f,-0.7426f,0.5941f,  -0.2014f,0.6616f,0.7223f,  -0.9295f,0.1036f,-0.3541f,  -395.1722f,45.3198f,-706.5559f,  
/* M138 */   -0.2869f,-0.7688f,0.5716f,  -0.2385f,0.6352f,0.7346f,  -0.9278f,0.0744f,-0.3656f,  -387.0959f,54.1490f,-706.7071f,  
/* M139 */   -0.2542f,-0.7767f,0.5763f,  -0.2931f,0.6297f,0.7195f,  -0.9217f,0.0140f,-0.3877f,  -375.1022f,60.4499f,-699.6009f,  
/* M140 */   -0.2200f,-0.7744f,0.5932f,  -0.3471f,0.6305f,0.6943f,  -0.9117f,-0.0532f,-0.4075f,  -363.5522f,66.2880f,-690.7195f,  
/* M141 */   -0.1902f,-0.7727f,0.6055f,  -0.3827f,0.6264f,0.6791f,  -0.9041f,-0.1026f,-0.4149f,  -356.2626f,72.6183f,-685.7836f,  
/* M142 */   -0.1621f,-0.7777f,0.6074f,  -0.3878f,0.6162f,0.6855f,  -0.9074f,-0.1245f,-0.4015f,  -355.6284f,78.5266f,-688.4792f,  
/* M143 */   -0.1363f,-0.7832f,0.6067f,  -0.3756f,0.6075f,0.6999f,  -0.9167f,-0.1325f,-0.3769f,  -358.6752f,82.8217f,-694.4116f,  
/* M144 */   -0.1206f,-0.7846f,0.6081f,  -0.3655f,0.6047f,0.7077f,  -0.9230f,-0.1369f,-0.3597f,  -360.9237f,84.7701f,-697.7921f,  
/* M145 */   -0.1196f,-0.7771f,0.6179f,  -0.3670f,0.6129f,0.6998f,  -0.9225f,-0.1431f,-0.3585f,  -360.0377f,82.9911f,-695.4951f,  
/* M146 */   -0.1281f,-0.7655f,0.6306f,  -0.3704f,0.6268f,0.6856f,  -0.9200f,-0.1457f,-0.3638f,  -358.3172f,78.9667f,-690.9569f,  
/* M147 */   -0.1397f,-0.7586f,0.6364f,  -0.3635f,0.6372f,0.6796f,  -0.9211f,-0.1364f,-0.3647f,  -358.6251f,75.2355f,-688.9610f,  
/* M148 */   -0.1521f,-0.7626f,0.6287f,  -0.3361f,0.6381f,0.6927f,  -0.9295f,-0.1060f,-0.3534f,  -363.4377f,72.4426f,-692.7789f,  
/* M149 */   -0.1678f,-0.7707f,0.6147f,  -0.2980f,0.6340f,0.7136f,  -0.9397f,-0.0634f,-0.3361f,  -370.7275f,69.8767f,-698.9741f,  
/* M150 */   -0.1859f,-0.7734f,0.6060f,  -0.2677f,0.6333f,0.7261f,  -0.9454f,-0.0272f,-0.3248f,  -376.3528f,66.9614f,-702.4393f,  
/* M151 */   -0.2073f,-0.7665f,0.6079f,  -0.2562f,0.6423f,0.7224f,  -0.9441f,-0.0061f,-0.3295f,  -377.6981f,62.7905f,-700.2405f,  
/* M152 */   -0.2292f,-0.7545f,0.6150f,  -0.2522f,0.6563f,0.7111f,  -0.9402f,0.0079f,-0.3407f,  -377.3606f,57.9878f,-695.4657f,  
/* M153 */   -0.2446f,-0.7428f,0.6232f,  -0.2408f,0.6692f,0.7030f,  -0.9393f,0.0219f,-0.3425f,  -378.8203f,53.7253f,-692.2303f,  
/* M154 */   -0.2484f,-0.7343f,0.6318f,  -0.2143f,0.6777f,0.7034f,  -0.9446f,0.0393f,-0.3257f,  -383.9732f,50.6921f,-692.8964f,  
/* M155 */   -0.2447f,-0.7269f,0.6416f,  -0.1799f,0.6843f,0.7066f,  -0.9528f,0.0575f,-0.2982f,  -391.1802f,48.3742f,-695.2990f,  
/* M156 */   -0.2405f,-0.7187f,0.6524f,  -0.1451f,0.6912f,0.7079f,  -0.9597f,0.0756f,-0.2705f,  -398.4704f,46.0517f,-696.7066f,  
/* M157 */   -0.2427f,-0.7069f,0.6643f,  -0.1177f,0.7012f,0.7032f,  -0.9629f,0.0924f,-0.2534f,  -403.7158f,42.8950f,-694.6422f,  
/* M158 */   -0.2492f,-0.6900f,0.6795f,  -0.0981f,0.7160f,0.6911f,  -0.9635f,0.1055f,-0.2461f,  -406.8440f,38.6012f,-689.1365f,  
/* M159 */   -0.2566f,-0.6693f,0.6973f,  -0.0825f,0.7340f,0.6741f,  -0.9630f,0.1154f,-0.2435f,  -408.8153f,33.6779f,-681.3735f,  
/* M160 */   -0.2628f,-0.6458f,0.7169f,  -0.0655f,0.7532f,0.6545f,  -0.9626f,0.1251f,-0.2403f,  -410.8578f,28.4166f,-672.6182f,  
/* M161 */   -0.2688f,-0.6204f,0.7368f,  -0.0449f,0.7722f,0.6338f,  -0.9622f,0.1373f,-0.2354f,  -413.3802f,23.0567f,-663.3920f,  
/* M162 */   -0.2824f,-0.5935f,0.7537f,  -0.0307f,0.7909f,0.6112f,  -0.9588f,0.1495f,-0.2416f,  -413.6941f,17.9613f,-651.7919f,  
/* M163 */   -0.3041f,-0.5637f,0.7680f,  -0.0249f,0.8106f,0.5851f,  -0.9523f,0.1588f,-0.2606f,  -411.4244f,13.0282f,-637.4303f,  
/* M164 */   -0.3320f,-0.5294f,0.7807f,  -0.0213f,0.8316f,0.5549f,  -0.9430f,0.1677f,-0.2874f,  -408.4720f,8.2379f,-621.0724f,  
/* M165 */   -0.3641f,-0.4883f,0.7931f,  -0.0134f,0.8542f,0.5197f,  -0.9312f,0.1786f,-0.3176f,  -406.7844f,2.3635f,-603.3208f,  
/* M166 */   -0.4193f,-0.4337f,0.7976f,  -0.0070f,0.8801f,0.4748f,  -0.9078f,0.1935f,-0.3720f,  -404.9813f,-5.6906f,-580.0670f,  
/* M167 */   -0.4928f,-0.3660f,0.7894f,  -0.0004f,0.9073f,0.4204f,  -0.8701f,0.2069f,-0.4473f,  -404.1184f,-13.4904f,-551.4634f,  
/* M168 */   -0.5451f,-0.2943f,0.7850f,  0.0245f,0.9304f,0.3658f,  -0.8380f,0.2186f,-0.4999f,  -408.4082f,-19.5417f,-524.0195f,  
/* M169 */   -0.5594f,-0.2190f,0.7994f,  0.0722f,0.9479f,0.3103f,  -0.8257f,0.2313f,-0.5144f,  -418.1142f,-25.2100f,-499.5735f,  
/* M170 */   -0.5556f,-0.1387f,0.8198f,  0.1304f,0.9592f,0.2507f,  -0.8211f,0.2462f,-0.5149f,  -430.5542f,-30.7223f,-475.6769f,  
/* M171 */   -0.5479f,-0.0608f,0.8344f,  0.1922f,0.9615f,0.1962f,  -0.8142f,0.2678f,-0.5151f,  -444.5188f,-35.4348f,-454.5102f,  
/* M172 */   -0.5520f,0.0075f,0.8338f,  0.2522f,0.9546f,0.1584f,  -0.7948f,0.2977f,-0.5289f,  -459.0605f,-38.8528f,-437.1213f,  
/* M173 */   -0.5668f,0.0664f,0.8212f,  0.3104f,0.9405f,0.1382f,  -0.7631f,0.3332f,-0.5537f,  -474.0101f,-41.1595f,-422.6001f,  
/* M174 */   -0.5811f,0.1215f,0.8047f,  0.3696f,0.9204f,0.1279f,  -0.7251f,0.3717f,-0.5797f,  -490.0152f,-42.4138f,-410.4875f,  
/* M175 */   -0.5988f,0.1741f,0.7818f,  0.4284f,0.8943f,0.1289f,  -0.6767f,0.4121f,-0.6101f,  -506.9602f,-42.3414f,-400.7813f,  
/* M176 */   -0.6254f,0.2246f,0.7472f,  0.4844f,0.8625f,0.1461f,  -0.6117f,0.4534f,-0.6483f,  -524.5536f,-40.6835f,-393.9263f,  
/* M177 */   -0.6645f,0.2748f,0.6949f,  0.5340f,0.8252f,0.1842f,  -0.5228f,0.4935f,-0.6951f,  -542.3355f,-37.1525f,-390.5750f,  
/* M178 */   -0.7269f,0.3247f,0.6051f,  0.5708f,0.7756f,0.2695f,  -0.3818f,0.5413f,-0.7491f,  -560.9315f,-31.0925f,-397.0827f,  
/* M179 */   -0.7933f,0.3834f,0.4729f,  0.5801f,0.7117f,0.3961f,  -0.1847f,0.5886f,-0.7870f,  -576.8796f,-21.1006f,-413.5049f,  
/* M180 */   -0.8314f,0.4523f,0.3227f,  0.5550f,0.6477f,0.5220f,  0.0271f,0.6131f,-0.7896f,  -585.3472f,-8.2550f,-430.8097f,  
/* M181 */   -0.8385f,0.5227f,0.1540f,  0.4837f,0.5839f,0.6520f,  0.2509f,0.6212f,-0.7424f,  -584.2323f,6.8306f,-450.7060f,  
/* M182 */   -0.8037f,0.5942f,-0.0312f,  0.3484f,0.5124f,0.7849f,  0.4824f,0.6200f,-0.6188f,  -569.6115f,25.5994f,-477.1385f,  
/* M183 */   -0.7211f,0.6634f,-0.1999f,  0.1683f,0.4476f,0.8783f,  0.6721f,0.5997f,-0.4344f,  -541.6508f,45.0334f,-501.1669f,  
/* M184 */   -0.6049f,0.7231f,-0.3336f,  -0.0129f,0.4100f,0.9120f,  0.7962f,0.5560f,-0.2386f,  -507.9725f,59.8947f,-514.9023f,  
/* M185 */   -0.4468f,0.7596f,-0.4726f,  -0.2103f,0.4243f,0.8808f,  0.8695f,0.4930f,-0.0298f,  -465.7978f,63.4466f,-512.9908f,  
/* M186 */   -0.2435f,0.7702f,-0.5895f,  -0.4026f,0.4726f,0.7839f,  0.8824f,0.4282f,0.1950f,  -420.6011f,58.6433f,-494.5450f,  
/* M187 */   -0.0735f,0.7718f,-0.6315f,  -0.5159f,0.5125f,0.6864f,  0.8535f,0.3763f,0.3605f,  -390.6011f,54.7420f,-473.6552f,  
/* M188 */   0.0163f,0.7809f,-0.6244f,  -0.5456f,0.5303f,0.6489f,  0.8379f,0.3301f,0.4347f,  -379.8039f,55.4800f,-463.4456f,  
/* M189 */   0.0463f,0.7891f,-0.6125f,  -0.5329f,0.5381f,0.6530f,  0.8449f,0.2962f,0.4454f,  -379.3927f,57.4479f,-459.1222f,  
/* M190 */   0.0189f,0.7879f,-0.6155f,  -0.5071f,0.5381f,0.6733f,  0.8617f,0.2994f,0.4097f,  -381.2488f,58.1585f,-454.2473f,  
/* M191 */   -0.0664f,0.7762f,-0.6270f,  -0.4768f,0.5273f,0.7033f,  0.8765f,0.3457f,0.3351f,  -382.1316f,57.8664f,-448.1264f,  
/* M192 */   -0.1927f,0.7532f,-0.6289f,  -0.4301f,0.5113f,0.7441f,  0.8820f,0.4139f,0.2254f,  -385.1635f,57.1114f,-442.3916f,  
/* M193 */   -0.3312f,0.7141f,-0.6167f,  -0.3647f,0.5058f,0.7817f,  0.8702f,0.4839f,0.0929f,  -391.6393f,53.9078f,-434.5087f,  
/* M194 */   -0.4544f,0.6627f,-0.5952f,  -0.2854f,0.5247f,0.8020f,  0.8438f,0.5343f,-0.0492f,  -402.0519f,46.5952f,-421.6075f,  
/* M195 */   -0.5678f,0.6028f,-0.5605f,  -0.1867f,0.5689f,0.8009f,  0.8017f,0.5594f,-0.2105f,  -417.2159f,35.3893f,-401.4889f,  
/* M196 */   -0.6752f,0.5428f,-0.4995f,  -0.0689f,0.6278f,0.7753f,  0.7344f,0.5579f,-0.3865f,  -435.2592f,23.1492f,-374.0784f,  
/* M197 */   -0.7561f,0.4956f,-0.4274f,  0.0467f,0.6922f,0.7202f,  0.6528f,0.5246f,-0.5465f,  -452.2309f,12.5539f,-340.7448f,  
/* M198 */   -0.8090f,0.4678f,-0.3559f,  0.1549f,0.7538f,0.6386f,  0.5670f,0.4615f,-0.6823f,  -467.4025f,5.4106f,-303.5012f,  
/* M199 */   -0.8350f,0.4431f,-0.3262f,  0.2304f,0.8200f,0.5240f,  0.4996f,0.3624f,-0.7868f,  -476.1347f,1.5569f,-259.6212f,  
/* M200 */   -0.8483f,0.4079f,-0.3377f,  0.2702f,0.8818f,0.3865f,  0.4554f,0.2367f,-0.8582f,  -477.9747f,2.8149f,-211.9162f,  
/* M201 */   -0.8594f,0.3812f,-0.3407f,  0.3048f,0.9170f,0.2571f,  0.4105f,0.1171f,-0.9043f,  -478.3364f,9.6375f,-170.3870f,  
/* M202 */   -0.8662f,0.3709f,-0.3347f,  0.3413f,0.9286f,0.1455f,  0.3648f,0.0118f,-0.9310f,  -480.1264f,19.8483f,-136.2460f,  
/* M203 */   -0.8671f,0.3601f,-0.3441f,  0.3690f,0.9285f,0.0418f,  0.3345f,-0.0907f,-0.9380f,  -482.8114f,32.9036f,-105.0792f,  
/* M204 */   -0.8658f,0.3495f,-0.3582f,  0.3931f,0.9179f,-0.0546f,  0.3097f,-0.1881f,-0.9321f,  -485.8622f,48.1881f,-76.9716f,  
/* M205 */   -0.8630f,0.3385f,-0.3751f,  0.4141f,0.8992f,-0.1413f,  0.2895f,-0.2773f,-0.9161f,  -489.0688f,64.7315f,-52.4363f,  
/* M206 */   -0.8597f,0.3266f,-0.3928f,  0.4316f,0.8757f,-0.2166f,  0.2732f,-0.3558f,-0.8938f,  -491.9869f,81.4111f,-31.7346f,  
/* M207 */   -0.8571f,0.3135f,-0.4088f,  0.4446f,0.8509f,-0.2797f,  0.2602f,-0.4215f,-0.8687f,  -493.9691f,96.9791f,-14.8737f,  
/* M208 */   -0.8545f,0.3026f,-0.4222f,  0.4505f,0.8364f,-0.3122f,  0.2587f,-0.4570f,-0.8510f,  -495.0802f,105.6899f,-5.8869f,  
/* M209 */   -0.8512f,0.2961f,-0.4333f,  0.4502f,0.8362f,-0.3130f,  0.2696f,-0.4615f,-0.8452f,  -495.7787f,106.2557f,-4.4772f,  
/* M210 */   -0.8491f,0.2909f,-0.4408f,  0.4472f,0.8401f,-0.3071f,  0.2810f,-0.4579f,-0.8434f,  -495.6815f,104.8011f,-4.7161f,  
/* M211 */   -0.8500f,0.2852f,-0.4428f,  0.4403f,0.8462f,-0.3001f,  0.2891f,-0.4501f,-0.8449f,  -494.0359f,102.5225f,-5.2150f,  
/* M212 */   -0.8524f,0.2805f,-0.4412f,  0.4300f,0.8563f,-0.2863f,  0.2975f,-0.4337f,-0.8505f,  -491.4164f,98.2044f,-7.3386f,  
/* M213 */   -0.8543f,0.2786f,-0.4388f,  0.4225f,0.8640f,-0.2740f,  0.3028f,-0.4194f,-0.8558f,  -489.2006f,94.5842f,-9.2342f,  
/* M214 */   -0.8545f,0.2816f,-0.4365f,  0.4217f,0.8667f,-0.2665f,  0.3033f,-0.4118f,-0.8593f,  -488.3283f,92.7616f,-10.1542f,  
/* M215 */   -0.8544f,0.2870f,-0.4332f,  0.4236f,0.8676f,-0.2606f,  0.3011f,-0.4062f,-0.8628f,  -487.9274f,91.5217f,-10.8428f,  
/* M216 */   -0.8556f,0.2902f,-0.4286f,  0.4229f,0.8694f,-0.2555f,  0.2985f,-0.3999f,-0.8666f,  -486.7362f,90.0393f,-11.5782f,  
/* M217 */   -0.8599f,0.2878f,-0.4216f,  0.4154f,0.8744f,-0.2505f,  0.2966f,-0.3906f,-0.8715f,  -483.6264f,87.6621f,-12.5696f,  
/* M218 */   -0.8654f,0.2831f,-0.4135f,  0.4056f,0.8803f,-0.2462f,  0.2943f,-0.3807f,-0.8766f,  -479.9844f,85.1793f,-13.5857f,  
/* M219 */   -0.8685f,0.2820f,-0.4077f,  0.4011f,0.8831f,-0.2436f,  0.2913f,-0.3751f,-0.8800f,  -478.3108f,83.8990f,-14.1184f,  
/* M220 */   -0.8670f,0.2885f,-0.4064f,  0.4071f,0.8803f,-0.2435f,  0.2875f,-0.3765f,-0.8807f,  -480.2255f,84.5889f,-13.9217f,  
/* M221 */   -0.8629f,0.2985f,-0.4078f,  0.4184f,0.8745f,-0.2452f,  0.2835f,-0.3822f,-0.8795f,  -483.9142f,86.4310f,-13.2683f,  
/* M222 */   -0.8599f,0.3050f,-0.4093f,  0.4268f,0.8695f,-0.2486f,  0.2801f,-0.3884f,-0.8779f,  -486.7560f,88.2566f,-12.3535f,  
/* M223 */   -0.8596f,0.3054f,-0.4096f,  0.4292f,0.8665f,-0.2548f,  0.2771f,-0.3948f,-0.8760f,  -487.7857f,89.8362f,-10.9032f,  
/* M224 */   -0.8607f,0.3024f,-0.4095f,  0.4287f,0.8644f,-0.2628f,  0.2745f,-0.4018f,-0.8736f,  -487.9252f,91.3854f,-9.1214f,  
/* M225 */   -0.8624f,0.2975f,-0.4097f,  0.4259f,0.8638f,-0.2693f,  0.2738f,-0.4067f,-0.8716f,  -487.4252f,92.3191f,-7.8780f,  
/* M226 */   -0.8643f,0.2896f,-0.4113f,  0.4197f,0.8658f,-0.2724f,  0.2772f,-0.4081f,-0.8699f,  -486.1403f,92.1672f,-7.6756f,  
/* M227 */   -0.8665f,0.2798f,-0.4134f,  0.4114f,0.8694f,-0.2738f,  0.2828f,-0.4073f,-0.8684f,  -484.3718f,91.4266f,-7.9935f,  
/* M228 */   -0.8686f,0.2730f,-0.4135f,  0.4051f,0.8718f,-0.2754f,  0.2854f,-0.4067f,-0.8679f,  -483.0389f,90.9464f,-8.1303f,  
/* M229 */   -0.8708f,0.2707f,-0.4104f,  0.4021f,0.8725f,-0.2776f,  0.2829f,-0.4068f,-0.8686f,  -482.3759f,90.9259f,-7.8815f,  
/* M230 */   -0.8730f,0.2708f,-0.4057f,  0.4007f,0.8724f,-0.2800f,  0.2781f,-0.4070f,-0.8700f,  -481.9925f,91.0837f,-7.4909f,  
/* M231 */   -0.8748f,0.2720f,-0.4010f,  0.4007f,0.8714f,-0.2831f,  0.2724f,-0.4083f,-0.8713f,  -481.8611f,91.5377f,-6.9041f,  
/* M232 */   -0.8759f,0.2732f,-0.3977f,  0.4017f,0.8695f,-0.2874f,  0.2672f,-0.4115f,-0.8713f,  -481.9487f,92.4081f,-6.0631f,  
/* M233 */   -0.8757f,0.2751f,-0.3967f,  0.4055f,0.8651f,-0.2953f,  0.2620f,-0.4195f,-0.8691f,  -482.5118f,94.3214f,-4.5587f,  
/* M234 */   -0.8750f,0.2767f,-0.3973f,  0.4102f,0.8595f,-0.3048f,  0.2571f,-0.4297f,-0.8656f,  -483.2171f,96.7196f,-2.7681f,  
/* M235 */   -0.8752f,0.2750f,-0.3980f,  0.4105f,0.8574f,-0.3104f,  0.2559f,-0.4350f,-0.8633f,  -483.2368f,97.8647f,-1.7849f,  
/* M236 */   -0.8770f,0.2681f,-0.3986f,  0.4038f,0.8610f,-0.3091f,  0.2603f,-0.4321f,-0.8634f,  -482.1661f,96.8796f,-2.1839f,  
/* M237 */   -0.8794f,0.2588f,-0.3995f,  0.3936f,0.8674f,-0.3044f,  0.2678f,-0.4250f,-0.8647f,  -480.5766f,94.8542f,-3.2985f,  
/* M238 */   -0.8815f,0.2507f,-0.4001f,  0.3845f,0.8730f,-0.3001f,  0.2741f,-0.4184f,-0.8659f,  -479.2069f,93.0397f,-4.2513f,  
/* M239 */   -0.8829f,0.2463f,-0.3997f,  0.3794f,0.8759f,-0.2982f,  0.2767f,-0.4149f,-0.8668f,  -478.6310f,92.0919f,-4.5376f,  
/* M240 */   -0.8840f,0.2439f,-0.3989f,  0.3763f,0.8776f,-0.2971f,  0.2776f,-0.4127f,-0.8675f,  -478.4258f,91.4960f,-4.5844f,  
/* M241 */   -0.8851f,0.2401f,-0.3988f,  0.3719f,0.8800f,-0.2956f,  0.2799f,-0.4099f,-0.8681f,  -477.8036f,90.6718f,-4.8928f,  
/* M242 */   -0.8865f,0.2331f,-0.3996f,  0.3645f,0.8839f,-0.2930f,  0.2849f,-0.4054f,-0.8686f,  -476.3026f,89.3515f,-5.6835f,  
/* M243 */   -0.8882f,0.2245f,-0.4009f,  0.3554f,0.8886f,-0.2898f,  0.2912f,-0.3999f,-0.8691f,  -474.3376f,87.7827f,-6.7047f,  
/* M244 */   -0.8898f,0.2157f,-0.4022f,  0.3462f,0.8933f,-0.2866f,  0.2974f,-0.3943f,-0.8695f,  -472.3996f,86.2310f,-7.7015f,  
/* M245 */   -0.8898f,0.2157f,-0.4022f,  0.3462f,0.8933f,-0.2866f,  0.2974f,-0.3943f,-0.8695f,  -472.3996f,86.2310f,-7.7015f,  

_NULL_ }; /* End of hand_left_pData */


/* MESH ANIMATION 2 */

#define hand_right_NumFrames  243

const float hand_right_pData[] = {
/* M002 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,-0.0000f,-0.0000f,  
/* M003 */   0.9999f,0.0025f,0.0103f,  -0.0026f,1.0000f,0.0015f,  -0.0103f,-0.0015f,0.9999f,  1.1067f,-0.2631f,-1.1949f,  
/* M004 */   0.9998f,0.0038f,0.0207f,  -0.0039f,1.0000f,0.0033f,  -0.0206f,-0.0034f,0.9998f,  1.9128f,-0.4227f,-2.4618f,  
/* M005 */   0.9996f,0.0055f,0.0273f,  -0.0056f,1.0000f,0.0034f,  -0.0272f,-0.0036f,0.9996f,  2.7533f,-0.5069f,-3.0165f,  
/* M006 */   0.9995f,0.0106f,0.0287f,  -0.0106f,0.9999f,-0.0006f,  -0.0287f,0.0003f,0.9996f,  4.3945f,-0.6605f,-2.1377f,  
/* M007 */   0.9995f,0.0186f,0.0274f,  -0.0184f,0.9998f,-0.0072f,  -0.0275f,0.0066f,0.9996f,  6.7944f,-0.9019f,-0.3623f,  
/* M008 */   0.9993f,0.0262f,0.0251f,  -0.0259f,0.9996f,-0.0127f,  -0.0254f,0.0120f,0.9996f,  9.0360f,-1.0890f,1.1939f,  
/* M009 */   0.9993f,0.0300f,0.0238f,  -0.0297f,0.9995f,-0.0136f,  -0.0241f,0.0129f,0.9996f,  10.2357f,-1.1298f,1.4622f,  
/* M010 */   0.9994f,0.0255f,0.0244f,  -0.0254f,0.9997f,-0.0046f,  -0.0246f,0.0040f,0.9997f,  9.1105f,-0.8772f,-0.9553f,  
/* M011 */   0.9995f,0.0174f,0.0261f,  -0.0177f,0.9998f,0.0100f,  -0.0259f,-0.0104f,0.9996f,  7.0644f,-0.5321f,-4.9906f,  
/* M012 */   0.9995f,0.0142f,0.0271f,  -0.0148f,0.9997f,0.0207f,  -0.0268f,-0.0211f,0.9994f,  6.5708f,-0.4899f,-8.0780f,  
/* M013 */   0.9995f,0.0138f,0.0279f,  -0.0145f,0.9995f,0.0263f,  -0.0275f,-0.0267f,0.9993f,  6.8215f,-0.4054f,-10.0195f,  
/* M014 */   0.9995f,0.0148f,0.0274f,  -0.0156f,0.9994f,0.0293f,  -0.0269f,-0.0297f,0.9992f,  7.2413f,-0.4427f,-11.2435f,  
/* M015 */   0.9994f,0.0255f,0.0217f,  -0.0261f,0.9993f,0.0263f,  -0.0211f,-0.0269f,0.9994f,  10.0475f,-1.7062f,-10.1646f,  
/* M016 */   0.9987f,0.0486f,0.0151f,  -0.0488f,0.9987f,0.0160f,  -0.0143f,-0.0167f,0.9998f,  16.0850f,-4.2560f,-6.7068f,  
/* M017 */   0.9965f,0.0833f,0.0033f,  -0.0833f,0.9965f,-0.0007f,  -0.0034f,0.0005f,1.0000f,  24.4578f,-7.6945f,-0.9462f,  
/* M018 */   0.9914f,0.1267f,-0.0312f,  -0.1274f,0.9916f,-0.0216f,  0.0282f,0.0254f,0.9993f,  34.0309f,-11.7892f,8.1113f,  
/* M019 */   0.9795f,0.1734f,-0.1028f,  -0.1782f,0.9832f,-0.0395f,  0.0942f,0.0570f,0.9939f,  45.1964f,-16.2511f,20.2902f,  
/* M020 */   0.9567f,0.2115f,-0.2000f,  -0.2264f,0.9725f,-0.0545f,  0.1830f,0.0974f,0.9783f,  56.6891f,-19.8474f,34.4727f,  
/* M021 */   0.9265f,0.2245f,-0.3022f,  -0.2574f,0.9635f,-0.0733f,  0.2747f,0.1457f,0.9504f,  63.9365f,-21.4378f,50.0458f,  
/* M022 */   0.8952f,0.2052f,-0.3956f,  -0.2691f,0.9565f,-0.1128f,  0.3552f,0.2074f,0.9115f,  65.0586f,-20.3361f,70.4417f,  
/* M023 */   0.8590f,0.1698f,-0.4830f,  -0.2765f,0.9478f,-0.1586f,  0.4309f,0.2698f,0.8611f,  64.9212f,-17.1442f,92.2469f,  
/* M024 */   0.8102f,0.1440f,-0.5681f,  -0.2884f,0.9418f,-0.1726f,  0.5102f,0.3037f,0.8046f,  67.6216f,-15.1619f,104.9645f,  
/* M025 */   0.7375f,0.1383f,-0.6610f,  -0.3143f,0.9366f,-0.1547f,  0.5978f,0.3218f,0.7342f,  76.7782f,-14.7720f,109.2198f,  
/* M026 */   0.6386f,0.1440f,-0.7560f,  -0.3517f,0.9283f,-0.1203f,  0.6845f,0.3427f,0.6435f,  91.1182f,-14.3663f,108.6072f,  
/* M027 */   0.5258f,0.1593f,-0.8356f,  -0.3805f,0.9226f,-0.0635f,  0.7608f,0.3513f,0.5457f,  103.8321f,-15.5824f,99.6267f,  
/* M028 */   0.4179f,0.1805f,-0.8904f,  -0.3790f,0.9253f,0.0096f,  0.8256f,0.3334f,0.4551f,  107.3613f,-19.5681f,82.7844f,  
/* M029 */   0.3366f,0.2023f,-0.9197f,  -0.3288f,0.9404f,0.0865f,  0.8824f,0.2733f,0.3831f,  94.3325f,-27.1299f,61.1892f,  
/* M030 */   0.2881f,0.2236f,-0.9311f,  -0.1974f,0.9653f,0.1707f,  0.9370f,0.1346f,0.3222f,  55.0623f,-37.2555f,33.6450f,  
/* M031 */   0.2309f,0.2534f,-0.9394f,  -0.0054f,0.9658f,0.2591f,  0.9730f,-0.0548f,0.2244f,  -2.5424f,-39.2556f,2.0154f,  
/* M032 */   0.1452f,0.2957f,-0.9442f,  0.1961f,0.9268f,0.3204f,  0.9698f,-0.2317f,0.0766f,  -63.2379f,-27.1201f,-23.7368f,  
/* M033 */   0.0482f,0.3464f,-0.9368f,  0.3651f,0.8669f,0.3393f,  0.9297f,-0.3583f,-0.0847f,  -115.8779f,-8.1328f,-38.6014f,  
/* M034 */   -0.0421f,0.3979f,-0.9165f,  0.4638f,0.8202f,0.3348f,  0.8849f,-0.4110f,-0.2191f,  -149.9394f,8.0849f,-46.7902f,  
/* M035 */   -0.0958f,0.4543f,-0.8857f,  0.4655f,0.8069f,0.3635f,  0.8798f,-0.3775f,-0.2888f,  -160.5567f,16.8013f,-64.2580f,  
/* M036 */   -0.1218f,0.5188f,-0.8462f,  0.3970f,0.8068f,0.4375f,  0.9097f,-0.2827f,-0.3042f,  -156.1194f,19.6379f,-94.3725f,  
/* M037 */   -0.1585f,0.5797f,-0.7993f,  0.3031f,0.7990f,0.5194f,  0.9397f,-0.1599f,-0.3023f,  -146.0440f,22.4054f,-125.8088f,  
/* M038 */   -0.2464f,0.6202f,-0.7447f,  0.2262f,0.7840f,0.5781f,  0.9424f,-0.0261f,-0.3335f,  -137.9667f,25.5184f,-149.2068f,  
/* M039 */   -0.4235f,0.6240f,-0.6567f,  0.1251f,0.7583f,0.6398f,  0.8972f,0.1888f,-0.3992f,  -116.2495f,30.4416f,-172.2747f,  
/* M040 */   -0.6333f,0.5883f,-0.5028f,  0.0213f,0.6627f,0.7486f,  0.7736f,0.4634f,-0.4322f,  -86.5285f,53.7596f,-209.5247f,  
/* M041 */   -0.7941f,0.5110f,-0.3289f,  0.0024f,0.5439f,0.8391f,  0.6077f,0.6656f,-0.4332f,  -77.6382f,86.6895f,-242.4982f,  
/* M042 */   -0.9165f,0.3638f,-0.1665f,  0.0403f,0.4981f,0.8662f,  0.3980f,0.7871f,-0.4712f,  -82.5100f,104.0600f,-257.1295f,  
/* M043 */   -0.9862f,0.1652f,-0.0073f,  0.0820f,0.5273f,0.8457f,  0.1436f,0.8334f,-0.5336f,  -88.4745f,107.1606f,-258.8016f,  
/* M044 */   -0.9928f,0.0273f,0.1167f,  0.1088f,0.6132f,0.7824f,  -0.0502f,0.7895f,-0.6118f,  -95.3611f,93.7879f,-247.4211f,  
/* M045 */   -0.9756f,-0.0338f,0.2169f,  0.1244f,0.7291f,0.6730f,  -0.1809f,0.6836f,-0.7071f,  -102.3830f,68.3927f,-222.3052f,  
/* M046 */   -0.9390f,-0.0701f,0.3366f,  0.1200f,0.8506f,0.5119f,  -0.3222f,0.5211f,-0.7904f,  -104.4353f,42.5641f,-185.1306f,  
/* M047 */   -0.8750f,-0.0678f,0.4794f,  0.0965f,0.9459f,0.3099f,  -0.4745f,0.3174f,-0.8211f,  -101.6160f,24.8873f,-140.1345f,  
/* M048 */   -0.7822f,-0.0230f,0.6226f,  0.0441f,0.9948f,0.0921f,  -0.6215f,0.0995f,-0.7771f,  -92.0417f,20.6020f,-93.4482f,  
/* M049 */   -0.6686f,0.0560f,0.7415f,  -0.0411f,0.9929f,-0.1121f,  -0.7425f,-0.1054f,-0.6615f,  -75.6862f,25.8306f,-50.7778f,  
/* M050 */   -0.5786f,0.2217f,0.7849f,  -0.0895f,0.9393f,-0.3313f,  -0.8107f,-0.2619f,-0.5236f,  -70.0111f,35.2671f,2.5272f,  
/* M051 */   -0.5373f,0.4131f,0.7353f,  -0.1697f,0.8010f,-0.5741f,  -0.8261f,-0.4333f,-0.3602f,  -56.4553f,63.9794f,69.8065f,  
/* M052 */   -0.5438f,0.4992f,0.6746f,  -0.3581f,0.5889f,-0.7245f,  -0.7590f,-0.6356f,-0.1415f,  -12.3873f,117.8290f,113.2521f,  
/* M053 */   -0.5874f,0.5044f,0.6329f,  -0.5284f,0.3532f,-0.7720f,  -0.6129f,-0.7879f,0.0590f,  32.1557f,179.3275f,130.3230f,  
/* M054 */   -0.6506f,0.4976f,0.5737f,  -0.6023f,0.1221f,-0.7889f,  -0.4626f,-0.8588f,0.2202f,  54.9352f,238.7527f,142.2162f,  
/* M055 */   -0.6877f,0.4919f,0.5339f,  -0.6493f,-0.0880f,-0.7554f,  -0.3246f,-0.8662f,0.3800f,  69.7302f,289.6498f,138.0375f,  
/* M056 */   -0.6726f,0.5130f,0.5333f,  -0.7092f,-0.2412f,-0.6625f,  -0.2112f,-0.8238f,0.5261f,  85.6647f,320.6396f,113.2082f,  
/* M057 */   -0.5520f,0.5755f,0.6034f,  -0.8300f,-0.3097f,-0.4638f,  -0.0801f,-0.7568f,0.6487f,  112.7552f,321.7619f,52.3412f,  
/* M058 */   -0.3255f,0.6368f,0.6989f,  -0.9386f,-0.3069f,-0.1575f,  0.1142f,-0.7073f,0.6977f,  129.9191f,300.8684f,-44.0325f,  
/* M059 */   -0.0796f,0.6634f,0.7440f,  -0.9503f,-0.2759f,0.1444f,  0.3011f,-0.6955f,0.6524f,  117.3991f,277.3173f,-140.4132f,  
/* M060 */   0.1639f,0.6665f,0.7272f,  -0.8967f,-0.2067f,0.3915f,  0.4113f,-0.7162f,0.5638f,  84.1719f,249.7469f,-219.8273f,  
/* M061 */   0.4018f,0.6477f,0.6474f,  -0.7939f,-0.1060f,0.5988f,  0.4564f,-0.7545f,0.4716f,  36.0328f,218.0751f,-284.5506f,  
/* M062 */   0.5645f,0.6250f,0.5392f,  -0.6776f,-0.0222f,0.7351f,  0.4714f,-0.7803f,0.4109f,  -10.7035f,193.2586f,-327.2608f,  
/* M063 */   0.6454f,0.6185f,0.4482f,  -0.5829f,0.0197f,0.8123f,  0.4936f,-0.7855f,0.3732f,  -44.7127f,179.9320f,-355.0436f,  
/* M064 */   0.6861f,0.6234f,0.3751f,  -0.5103f,0.0449f,0.8588f,  0.5185f,-0.7806f,0.3489f,  -69.6841f,171.6212f,-376.3727f,  
/* M065 */   0.7091f,0.6305f,0.3157f,  -0.4630f,0.0787f,0.8828f,  0.5318f,-0.7722f,0.3478f,  -87.8729f,162.6783f,-391.9806f,  
/* M066 */   0.7314f,0.6310f,0.2587f,  -0.4398f,0.1464f,0.8861f,  0.5213f,-0.7618f,0.3846f,  -101.4916f,146.6511f,-400.4215f,  
/* M067 */   0.7480f,0.6280f,0.2147f,  -0.4729f,0.2774f,0.8363f,  0.4656f,-0.7271f,0.5045f,  -101.2827f,115.6047f,-392.6697f,  
/* M068 */   0.7552f,0.6269f,0.1914f,  -0.5418f,0.4326f,0.7206f,  0.3690f,-0.6479f,0.6664f,  -91.1372f,82.7993f,-367.8377f,  
/* M069 */   0.7706f,0.6164f,0.1620f,  -0.5725f,0.5579f,0.6009f,  0.2800f,-0.5558f,0.7828f,  -91.1133f,61.4077f,-344.5078f,  
/* M070 */   0.8075f,0.5815f,0.0991f,  -0.5426f,0.6661f,0.5117f,  0.2315f,-0.4670f,0.8534f,  -109.2738f,43.0177f,-331.9334f,  
/* M071 */   0.8456f,0.5334f,0.0234f,  -0.4914f,0.7605f,0.4244f,  0.2086f,-0.3703f,0.9052f,  -134.7555f,28.4405f,-322.4509f,  
/* M072 */   0.8728f,0.4871f,-0.0301f,  -0.4449f,0.8195f,0.3612f,  0.2006f,-0.3019f,0.9320f,  -158.8308f,20.3361f,-321.6951f,  
/* M073 */   0.8935f,0.4461f,-0.0525f,  -0.4002f,0.8437f,0.3579f,  0.2039f,-0.2987f,0.9323f,  -182.1661f,18.4854f,-338.0836f,  
/* M074 */   0.9158f,0.3968f,-0.0628f,  -0.3420f,0.8520f,0.3963f,  0.2108f,-0.3415f,0.9160f,  -211.2965f,19.8658f,-367.0707f,  
/* M075 */   0.9416f,0.3285f,-0.0734f,  -0.2668f,0.8613f,0.4323f,  0.2053f,-0.3875f,0.8987f,  -247.7363f,21.8546f,-395.4150f,  
/* M076 */   0.9701f,0.2217f,-0.0991f,  -0.1540f,0.8772f,0.4547f,  0.1878f,-0.4258f,0.8851f,  -294.9724f,25.4167f,-416.1162f,  
/* M077 */   0.9843f,0.1002f,-0.1452f,  -0.0207f,0.8830f,0.4689f,  0.1752f,-0.4586f,0.8712f,  -344.7592f,36.6945f,-429.2248f,  
/* M078 */   0.9813f,0.0202f,-0.1914f,  0.0729f,0.8812f,0.4671f,  0.1781f,-0.4724f,0.8632f,  -380.4621f,49.4519f,-435.7707f,  
/* M079 */   0.9750f,-0.0064f,-0.2219f,  0.1090f,0.8846f,0.4535f,  0.1934f,-0.4664f,0.8632f,  -398.9870f,54.2722f,-440.0406f,  
/* M080 */   0.9660f,-0.0154f,-0.2582f,  0.1310f,0.8897f,0.4373f,  0.2230f,-0.4563f,0.8615f,  -413.7542f,54.6129f,-442.8803f,  
/* M081 */   0.9535f,-0.0130f,-0.3012f,  0.1458f,0.8943f,0.4230f,  0.2639f,-0.4472f,0.8546f,  -426.2343f,51.2932f,-445.2970f,  
/* M082 */   0.9415f,0.0065f,-0.3369f,  0.1401f,0.9018f,0.4088f,  0.3065f,-0.4321f,0.8481f,  -432.1610f,43.4299f,-448.7108f,  
/* M083 */   0.9309f,0.0436f,-0.3627f,  0.1124f,0.9106f,0.3978f,  0.3476f,-0.4110f,0.8428f,  -430.9811f,33.2992f,-453.9606f,  
/* M084 */   0.9180f,0.0916f,-0.3860f,  0.0733f,0.9170f,0.3920f,  0.3898f,-0.3881f,0.8351f,  -425.9305f,20.4968f,-460.6433f,  
/* M085 */   0.9014f,0.1446f,-0.4082f,  0.0281f,0.9210f,0.3884f,  0.4322f,-0.3616f,0.8261f,  -418.4300f,11.3076f,-467.9218f,  
/* M086 */   0.8808f,0.1972f,-0.4305f,  -0.0188f,0.9230f,0.3843f,  0.4731f,-0.3304f,0.8167f,  -409.9621f,8.8746f,-475.1173f,  
/* M087 */   0.8573f,0.2442f,-0.4533f,  -0.0637f,0.9239f,0.3773f,  0.5109f,-0.2946f,0.8076f,  -401.9612f,9.6920f,-481.7505f,  
/* M088 */   0.8329f,0.2816f,-0.4765f,  -0.1036f,0.9250f,0.3656f,  0.5437f,-0.2551f,0.7996f,  -395.3303f,10.1595f,-487.1922f,  
/* M089 */   0.8229f,0.3058f,-0.4788f,  -0.1593f,0.9332f,0.3222f,  0.5453f,-0.1889f,0.8167f,  -386.4665f,9.5373f,-486.5400f,  
/* M090 */   0.8199f,0.3221f,-0.4733f,  -0.2195f,0.9404f,0.2597f,  0.5287f,-0.1091f,0.8418f,  -378.6671f,7.5469f,-482.8638f,  
/* M091 */   0.7937f,0.3300f,-0.5110f,  -0.2360f,0.9413f,0.2414f,  0.5607f,-0.0710f,0.8250f,  -382.6854f,5.6506f,-488.6406f,  
/* M092 */   0.7293f,0.3291f,-0.5999f,  -0.1896f,0.9396f,0.2849f,  0.6574f,-0.0940f,0.7476f,  -402.3399f,2.9676f,-506.8985f,  
/* M093 */   0.6438f,0.3256f,-0.6925f,  -0.1068f,0.9343f,0.3400f,  0.7577f,-0.1449f,0.6363f,  -431.5071f,-0.8042f,-526.1649f,  
/* M094 */   0.5531f,0.3200f,-0.7692f,  -0.0111f,0.9260f,0.3773f,  0.8331f,-0.2001f,0.5157f,  -465.0689f,-2.9011f,-539.9779f,  
/* M095 */   0.4747f,0.3071f,-0.8248f,  0.0696f,0.9211f,0.3830f,  0.8774f,-0.2392f,0.4159f,  -496.5262f,-5.5105f,-545.5540f,  
/* M096 */   0.4164f,0.2766f,-0.8661f,  0.1334f,0.9237f,0.3592f,  0.8994f,-0.2650f,0.3477f,  -524.8434f,-7.7733f,-542.5463f,  
/* M097 */   0.3661f,0.2307f,-0.9015f,  0.1953f,0.9282f,0.3168f,  0.9098f,-0.2920f,0.2948f,  -552.0596f,-6.4929f,-533.4321f,  
/* M098 */   0.3208f,0.1803f,-0.9298f,  0.2486f,0.9313f,0.2663f,  0.9139f,-0.3166f,0.2539f,  -575.9728f,-3.9569f,-521.5507f,  
/* M099 */   0.2761f,0.1373f,-0.9513f,  0.2878f,0.9325f,0.2182f,  0.9170f,-0.3341f,0.2180f,  -594.7877f,-0.1663f,-510.4856f,  
/* M100 */   0.2275f,0.1143f,-0.9670f,  0.3078f,0.9337f,0.1828f,  0.9238f,-0.3393f,0.1772f,  -607.0053f,1.7353f,-503.7037f,  
/* M101 */   0.1693f,0.1428f,-0.9752f,  0.2847f,0.9402f,0.1871f,  0.9436f,-0.3093f,0.1185f,  -605.6686f,-3.8176f,-509.6180f,  
/* M102 */   0.1140f,0.2044f,-0.9722f,  0.2363f,0.9450f,0.2263f,  0.9650f,-0.2555f,0.0594f,  -595.9681f,-14.1106f,-526.6672f,  
/* M103 */   0.0802f,0.2434f,-0.9666f,  0.2024f,0.9456f,0.2549f,  0.9760f,-0.2160f,0.0265f,  -590.7136f,-22.4187f,-540.0227f,  
/* M104 */   0.0536f,0.2479f,-0.9673f,  0.1635f,0.9534f,0.2534f,  0.9851f,-0.1717f,0.0105f,  -584.2240f,-28.9662f,-542.8940f,  
/* M105 */   0.0232f,0.2471f,-0.9687f,  0.1011f,0.9634f,0.2482f,  0.9946f,-0.1037f,-0.0026f,  -570.8846f,-32.2396f,-543.4117f,  
/* M106 */   0.0024f,0.2510f,-0.9680f,  0.0380f,0.9673f,0.2509f,  0.9993f,-0.0374f,-0.0072f,  -559.0878f,-31.0091f,-545.2897f,  
/* M107 */   0.0055f,0.2628f,-0.9648f,  0.0138f,0.9647f,0.2629f,  0.9999f,-0.0148f,0.0017f,  -561.1523f,-27.2366f,-549.4457f,  
/* M108 */   0.0508f,0.2609f,-0.9640f,  0.0563f,0.9630f,0.2636f,  0.9971f,-0.0677f,0.0343f,  -585.3419f,-20.6539f,-550.1777f,  
/* M109 */   0.1256f,0.2319f,-0.9646f,  0.1447f,0.9576f,0.2491f,  0.9815f,-0.1709f,0.0867f,  -624.0583f,-9.2647f,-546.5840f,  
/* M110 */   0.2030f,0.1876f,-0.9610f,  0.2586f,0.9363f,0.2375f,  0.9444f,-0.2967f,0.1416f,  -668.9927f,8.6262f,-544.1727f,  
/* M111 */   0.2631f,0.1520f,-0.9527f,  0.3763f,0.8932f,0.2464f,  0.8884f,-0.4233f,0.1778f,  -712.4904f,31.7767f,-547.6553f,  
/* M112 */   0.3247f,0.1453f,-0.9346f,  0.5025f,0.8106f,0.3006f,  0.8013f,-0.5673f,0.1902f,  -756.8821f,63.4706f,-564.7051f,  
/* M113 */   0.3875f,0.1400f,-0.9112f,  0.6371f,0.6737f,0.3744f,  0.6663f,-0.7256f,0.1718f,  -801.9141f,109.6693f,-587.5355f,  
/* M114 */   0.4099f,0.1164f,-0.9047f,  0.7585f,0.5074f,0.4090f,  0.5066f,-0.8538f,0.1196f,  -839.3728f,163.3059f,-597.6105f,  
/* M115 */   0.3764f,0.0759f,-0.9233f,  0.8696f,0.3147f,0.3804f,  0.3195f,-0.9461f,0.0524f,  -869.7943f,223.0483f,-587.8750f,  
/* M116 */   0.3085f,0.0465f,-0.9501f,  0.9447f,0.1023f,0.3117f,  0.1117f,-0.9937f,-0.0123f,  -888.0867f,285.2977f,-566.5945f,  
/* M117 */   0.2447f,0.0592f,-0.9678f,  0.9682f,-0.0690f,0.2405f,  -0.0525f,-0.9959f,-0.0742f,  -893.8970f,330.7521f,-546.1646f,  
/* M118 */   0.2053f,0.1089f,-0.9726f,  0.9625f,-0.2026f,0.1805f,  -0.1774f,-0.9732f,-0.1464f,  -894.7173f,360.5500f,-531.0966f,  
/* M119 */   0.1802f,0.1700f,-0.9688f,  0.9374f,-0.3282f,0.1167f,  -0.2982f,-0.9292f,-0.2185f,  -890.8243f,385.1323f,-516.7644f,  
/* M120 */   0.1634f,0.2282f,-0.9598f,  0.9031f,-0.4263f,0.0524f,  -0.3972f,-0.8753f,-0.2758f,  -884.0559f,400.0697f,-503.1714f,  
/* M121 */   0.1476f,0.2732f,-0.9505f,  0.8758f,-0.4827f,-0.0027f,  -0.4595f,-0.8321f,-0.3106f,  -878.2062f,402.6820f,-491.8281f,  
/* M122 */   0.1267f,0.2993f,-0.9457f,  0.8730f,-0.4862f,-0.0369f,  -0.4709f,-0.8210f,-0.3229f,  -877.2676f,391.8835f,-484.8808f,  
/* M123 */   0.0854f,0.3083f,-0.9474f,  0.9160f,-0.3983f,-0.0470f,  -0.3919f,-0.8639f,-0.3165f,  -885.5203f,357.4830f,-482.1310f,  
/* M124 */   0.0222f,0.2991f,-0.9540f,  0.9766f,-0.2108f,-0.0434f,  -0.2140f,-0.9307f,-0.2968f,  -895.6926f,297.2460f,-480.8798f,  
/* M125 */   -0.0445f,0.2706f,-0.9617f,  0.9988f,0.0315f,-0.0373f,  0.0202f,-0.9622f,-0.2717f,  -895.4955f,224.0095f,-479.1286f,  
/* M126 */   -0.0956f,0.2324f,-0.9679f,  0.9637f,0.2651f,-0.0315f,  0.2493f,-0.9358f,-0.2493f,  -882.2398f,153.7703f,-477.4106f,  
/* M127 */   -0.1105f,0.1851f,-0.9765f,  0.8777f,0.4792f,-0.0085f,  0.4664f,-0.8580f,-0.2154f,  -858.6995f,89.9604f,-480.8046f,  
/* M128 */   -0.0972f,0.1411f,-0.9852f,  0.7373f,0.6751f,0.0240f,  0.6685f,-0.7241f,-0.1696f,  -821.3970f,30.9385f,-486.9960f,  
/* M129 */   -0.0916f,0.1140f,-0.9892f,  0.5769f,0.8158f,0.0406f,  0.8117f,-0.5670f,-0.1405f,  -776.8125f,-15.2149f,-489.0148f,  
/* M130 */   -0.1043f,0.0875f,-0.9907f,  0.4262f,0.9040f,0.0350f,  0.8986f,-0.4186f,-0.1316f,  -733.6811f,-47.8385f,-484.6322f,  
/* M131 */   -0.1218f,0.0533f,-0.9911f,  0.2818f,0.9593f,0.0170f,  0.9517f,-0.2772f,-0.1319f,  -692.2493f,-70.9592f,-476.7758f,  
/* M132 */   -0.1501f,0.0214f,-0.9884f,  0.1447f,0.9895f,-0.0006f,  0.9780f,-0.1432f,-0.1516f,  -651.7856f,-87.5526f,-469.5680f,  
/* M133 */   -0.1994f,-0.0000f,-0.9799f,  0.0160f,0.9999f,-0.0033f,  0.9798f,-0.0163f,-0.1994f,  -610.9642f,-99.4427f,-467.6489f,  
/* M134 */   -0.2888f,-0.0120f,-0.9573f,  -0.1102f,0.9937f,0.0207f,  0.9510f,0.1115f,-0.2883f,  -566.1984f,-107.2395f,-475.3698f,  
/* M135 */   -0.4117f,-0.0195f,-0.9111f,  -0.2071f,0.9756f,0.0727f,  0.8875f,0.2186f,-0.4057f,  -525.6602f,-111.4707f,-494.1354f,  
/* M136 */   -0.5438f,-0.0187f,-0.8390f,  -0.2357f,0.9629f,0.1313f,  0.8055f,0.2691f,-0.5280f,  -503.1125f,-117.1189f,-518.2911f,  
/* M137 */   -0.6820f,-0.0109f,-0.7313f,  -0.1978f,0.9654f,0.1701f,  0.7041f,0.2607f,-0.6605f,  -498.5117f,-126.4720f,-541.3854f,  
/* M138 */   -0.8149f,-0.0162f,-0.5794f,  -0.1435f,0.9741f,0.1746f,  0.5616f,0.2254f,-0.7961f,  -498.9114f,-134.3112f,-560.2761f,  
/* M139 */   -0.9136f,-0.0471f,-0.4040f,  -0.1133f,0.9834f,0.1416f,  0.3906f,0.1751f,-0.9038f,  -495.9510f,-137.6925f,-571.9411f,  
/* M140 */   -0.9655f,-0.0972f,-0.2417f,  -0.1218f,0.9886f,0.0889f,  0.2303f,0.1153f,-0.9663f,  -487.2025f,-136.9784f,-577.0782f,  
/* M141 */   -0.9828f,-0.1400f,-0.1206f,  -0.1432f,0.9895f,0.0184f,  0.1167f,0.0354f,-0.9925f,  -478.4571f,-135.7653f,-572.8957f,  
/* M142 */   -0.9863f,-0.1621f,-0.0312f,  -0.1599f,0.9851f,-0.0633f,  0.0410f,-0.0574f,-0.9975f,  -472.7709f,-134.6580f,-561.7891f,  
/* M143 */   -0.9837f,-0.1748f,0.0422f,  -0.1788f,0.9758f,-0.1259f,  -0.0192f,-0.1314f,-0.9911f,  -468.0539f,-131.9591f,-553.4479f,  
/* M144 */   -0.9771f,-0.1867f,0.1017f,  -0.2010f,0.9671f,-0.1559f,  -0.0692f,-0.1728f,-0.9825f,  -463.9250f,-128.2544f,-552.0417f,  
/* M145 */   -0.9711f,-0.1933f,0.1402f,  -0.2157f,0.9621f,-0.1671f,  -0.1026f,-0.1925f,-0.9759f,  -462.0630f,-125.6170f,-553.3034f,  
/* M146 */   -0.9682f,-0.1920f,0.1604f,  -0.2187f,0.9609f,-0.1699f,  -0.1215f,-0.1996f,-0.9723f,  -462.5294f,-124.7430f,-554.8329f,  
/* M147 */   -0.9698f,-0.1812f,0.1635f,  -0.2085f,0.9632f,-0.1696f,  -0.1268f,-0.1985f,-0.9719f,  -465.4424f,-125.8659f,-555.1057f,  
/* M148 */   -0.9743f,-0.1639f,0.1543f,  -0.1890f,0.9681f,-0.1648f,  -0.1224f,-0.1897f,-0.9742f,  -470.3310f,-127.9190f,-555.0139f,  
/* M149 */   -0.9794f,-0.1445f,0.1410f,  -0.1661f,0.9738f,-0.1556f,  -0.1148f,-0.1758f,-0.9777f,  -475.9573f,-129.4728f,-555.9097f,  
/* M150 */   -0.9831f,-0.1277f,0.1315f,  -0.1462f,0.9789f,-0.1424f,  -0.1105f,-0.1592f,-0.9810f,  -480.9829f,-129.9073f,-558.4545f,  
/* M151 */   -0.9850f,-0.1133f,0.1303f,  -0.1299f,0.9833f,-0.1273f,  -0.1137f,-0.1423f,-0.9833f,  -485.3963f,-129.7084f,-561.9996f,  
/* M152 */   -0.9860f,-0.0985f,0.1344f,  -0.1138f,0.9872f,-0.1113f,  -0.1217f,-0.1251f,-0.9847f,  -489.9802f,-129.2107f,-565.9093f,  
/* M153 */   -0.9865f,-0.0842f,0.1404f,  -0.0980f,0.9908f,-0.0937f,  -0.1313f,-0.1062f,-0.9856f,  -494.5549f,-128.3146f,-570.1778f,  
/* M154 */   -0.9868f,-0.0711f,0.1453f,  -0.0824f,0.9939f,-0.0735f,  -0.1392f,-0.0845f,-0.9867f,  -498.9022f,-126.9561f,-574.8224f,  
/* M155 */   -0.9875f,-0.0597f,0.1458f,  -0.0676f,0.9965f,-0.0496f,  -0.1423f,-0.0589f,-0.9881f,  -502.7534f,-125.0325f,-579.8837f,  
/* M156 */   -0.9891f,-0.0505f,0.1386f,  -0.0540f,0.9983f,-0.0212f,  -0.1373f,-0.0284f,-0.9901f,  -505.7772f,-122.4264f,-585.4158f,  
/* M157 */   -0.9920f,-0.0477f,0.1171f,  -0.0462f,0.9988f,0.0150f,  -0.1177f,0.0095f,-0.9930f,  -506.2301f,-118.5166f,-591.4929f,  
/* M158 */   -0.9962f,-0.0503f,0.0711f,  -0.0456f,0.9968f,0.0663f,  -0.0742f,0.0628f,-0.9953f,  -503.4204f,-112.8474f,-599.0685f,  
/* M159 */   -0.9988f,-0.0491f,-0.0079f,  -0.0498f,0.9890f,0.1396f,  0.0009f,0.1398f,-0.9902f,  -498.1572f,-105.1822f,-609.3159f,  
/* M160 */   -0.9908f,-0.0385f,-0.1294f,  -0.0684f,0.9696f,0.2350f,  0.1164f,0.2417f,-0.9633f,  -488.1863f,-94.3665f,-621.2913f,  
/* M161 */   -0.9634f,-0.0104f,-0.2677f,  -0.1058f,0.9329f,0.3444f,  0.2462f,0.3601f,-0.8999f,  -474.2581f,-79.7145f,-634.0405f,  
/* M162 */   -0.9216f,0.0462f,-0.3853f,  -0.1493f,0.8742f,0.4621f,  0.3582f,0.4834f,-0.7988f,  -461.0802f,-61.2973f,-648.8340f,  
/* M163 */   -0.8701f,0.1303f,-0.4754f,  -0.2045f,0.7821f,0.5886f,  0.4485f,0.6093f,-0.6539f,  -446.7252f,-35.9642f,-666.6072f,  
/* M164 */   -0.8039f,0.2449f,-0.5421f,  -0.2708f,0.6607f,0.7001f,  0.5296f,0.7095f,-0.4648f,  -431.1935f,-5.7440f,-681.0145f,  
/* M165 */   -0.7142f,0.3871f,-0.5831f,  -0.3302f,0.5482f,0.7684f,  0.6171f,0.7413f,-0.2637f,  -419.9992f,18.6942f,-685.9202f,  
/* M166 */   -0.5786f,0.5399f,-0.6113f,  -0.3959f,0.4694f,0.7893f,  0.7131f,0.6987f,-0.0578f,  -410.7771f,31.6416f,-679.8201f,  
/* M167 */   -0.3932f,0.6742f,-0.6252f,  -0.4806f,0.4290f,0.7649f,  0.7838f,0.6012f,0.1554f,  -400.4876f,34.4528f,-663.3738f,  
/* M168 */   -0.1845f,0.7622f,-0.6205f,  -0.5622f,0.4360f,0.7027f,  0.8061f,0.4785f,0.3481f,  -393.6829f,28.3415f,-639.3483f,  
/* M169 */   0.0068f,0.7960f,-0.6053f,  -0.6166f,0.4799f,0.6241f,  0.7873f,0.3690f,0.4940f,  -393.7428f,16.9350f,-610.8608f,  
/* M170 */   0.1469f,0.7881f,-0.5978f,  -0.6214f,0.5437f,0.5641f,  0.7696f,0.2886f,0.5695f,  -404.9249f,2.6063f,-585.1865f,  
/* M171 */   0.2416f,0.7490f,-0.6169f,  -0.5859f,0.6194f,0.5226f,  0.7735f,0.2352f,0.5885f,  -424.9796f,-12.7612f,-561.2190f,  
/* M172 */   0.3045f,0.6848f,-0.6620f,  -0.5355f,0.6979f,0.4756f,  0.7877f,0.2097f,0.5793f,  -446.3984f,-26.6243f,-533.8353f,  
/* M173 */   0.3417f,0.5985f,-0.7246f,  -0.4737f,0.7756f,0.4172f,  0.8117f,0.2007f,0.5485f,  -468.5820f,-38.1895f,-502.9652f,  
/* M174 */   0.3457f,0.4994f,-0.7944f,  -0.3986f,0.8446f,0.3575f,  0.8495f,0.1930f,0.4910f,  -491.4239f,-46.0420f,-471.0726f,  
/* M175 */   0.3136f,0.4007f,-0.8609f,  -0.3253f,0.8971f,0.2991f,  0.8921f,0.1863f,0.4117f,  -509.1976f,-49.5101f,-440.0090f,  
/* M176 */   0.2505f,0.3113f,-0.9167f,  -0.2563f,0.9344f,0.2472f,  0.9335f,0.1730f,0.3139f,  -521.3284f,-50.0261f,-412.1965f,  
/* M177 */   0.1675f,0.2271f,-0.9594f,  -0.1883f,0.9626f,0.1950f,  0.9677f,0.1480f,0.2040f,  -530.1357f,-48.7177f,-385.7678f,  
/* M178 */   0.0710f,0.1410f,-0.9875f,  -0.1317f,0.9826f,0.1308f,  0.9888f,0.1207f,0.0883f,  -533.4513f,-45.2683f,-357.2924f,  
/* M179 */   -0.0314f,0.0433f,-0.9986f,  -0.0984f,0.9941f,0.0462f,  0.9946f,0.0997f,-0.0270f,  -528.5388f,-38.3977f,-323.9231f,  
/* M180 */   -0.1209f,-0.0823f,-0.9892f,  -0.1019f,0.9923f,-0.0701f,  0.9874f,0.0924f,-0.1284f,  -512.7870f,-25.0770f,-282.0466f,  
/* M181 */   -0.1969f,-0.2232f,-0.9547f,  -0.1334f,0.9708f,-0.1995f,  0.9713f,0.0881f,-0.2209f,  -488.7303f,-4.4122f,-237.4835f,  
/* M182 */   -0.2507f,-0.3441f,-0.9049f,  -0.1654f,0.9362f,-0.3102f,  0.9538f,0.0719f,-0.2916f,  -465.2899f,18.1346f,-199.5660f,  
/* M183 */   -0.3036f,-0.4233f,-0.8536f,  -0.1733f,0.9055f,-0.3874f,  0.9369f,0.0303f,-0.3483f,  -448.3929f,35.3072f,-172.0670f,  
/* M184 */   -0.4340f,-0.4732f,-0.7666f,  -0.1878f,0.8798f,-0.4367f,  0.8811f,-0.0456f,-0.4707f,  -422.7658f,47.9850f,-156.4963f,  
/* M185 */   -0.6140f,-0.5179f,-0.5957f,  -0.2441f,0.8423f,-0.4806f,  0.7506f,-0.1497f,-0.6436f,  -380.7860f,63.6715f,-152.4404f,  
/* M186 */   -0.7468f,-0.5322f,-0.3988f,  -0.3016f,0.8054f,-0.5102f,  0.5927f,-0.2608f,-0.7620f,  -343.9331f,75.7496f,-157.7327f,  
/* M187 */   -0.8330f,-0.4952f,-0.2465f,  -0.3150f,0.7909f,-0.5246f,  0.4548f,-0.3594f,-0.8149f,  -325.4651f,75.7108f,-163.5921f,  
/* M188 */   -0.8982f,-0.4260f,-0.1088f,  -0.3110f,0.7905f,-0.5277f,  0.3108f,-0.4401f,-0.8424f,  -315.3231f,68.3751f,-171.3600f,  
/* M189 */   -0.9383f,-0.3455f,0.0105f,  -0.3006f,0.8006f,-0.5184f,  0.1707f,-0.4896f,-0.8551f,  -310.5487f,57.0064f,-181.0820f,  
/* M190 */   -0.9537f,-0.2802f,0.1088f,  -0.2964f,0.8160f,-0.4962f,  0.0502f,-0.5056f,-0.8613f,  -306.8012f,46.1691f,-193.0380f,  
/* M191 */   -0.9577f,-0.2301f,0.1728f,  -0.2851f,0.8397f,-0.4622f,  -0.0387f,-0.4919f,-0.8698f,  -306.2235f,34.9943f,-206.5074f,  
/* M192 */   -0.9628f,-0.1895f,0.1926f,  -0.2542f,0.8771f,-0.4075f,  -0.0917f,-0.4413f,-0.8927f,  -311.1199f,21.9016f,-223.0661f,  
/* M193 */   -0.9707f,-0.1719f,0.1679f,  -0.2182f,0.9234f,-0.3158f,  -0.1008f,-0.3432f,-0.9339f,  -316.5168f,10.4610f,-246.1248f,  
/* M194 */   -0.9783f,-0.1843f,0.0946f,  -0.1981f,0.9656f,-0.1684f,  -0.0603f,-0.1835f,-0.9812f,  -316.0905f,5.4528f,-280.3349f,  
/* M195 */   -0.9810f,-0.1917f,-0.0301f,  -0.1924f,0.9811f,0.0220f,  0.0253f,0.0274f,-0.9993f,  -311.3854f,8.6488f,-320.7898f,  
/* M196 */   -0.9695f,-0.1457f,-0.1970f,  -0.1891f,0.9562f,0.2235f,  0.1558f,0.2539f,-0.9546f,  -307.8735f,16.3446f,-357.4940f,  
/* M197 */   -0.9123f,-0.0354f,-0.4079f,  -0.2268f,0.8731f,0.4316f,  0.3409f,0.4863f,-0.8046f,  -299.1188f,30.6384f,-389.1425f,  
/* M198 */   -0.7663f,0.1099f,-0.6331f,  -0.3665f,0.7346f,0.5711f,  0.5278f,0.6696f,-0.5226f,  -272.1380f,57.0349f,-400.9561f,  
/* M199 */   -0.5508f,0.2610f,-0.7928f,  -0.5235f,0.6317f,0.5717f,  0.6500f,0.7299f,-0.2112f,  -247.6478f,74.9950f,-382.5263f,  
/* M200 */   -0.2656f,0.3953f,-0.8793f,  -0.6019f,0.6445f,0.4715f,  0.7531f,0.6545f,0.0668f,  -252.0569f,63.2896f,-345.6506f,  
/* M201 */   0.0595f,0.4692f,-0.8811f,  -0.5779f,0.7359f,0.3529f,  0.8140f,0.4882f,0.3149f,  -288.3825f,36.6828f,-313.7353f,  
/* M202 */   0.2917f,0.4854f,-0.8242f,  -0.4818f,0.8189f,0.3118f,  0.8263f,0.3061f,0.4728f,  -335.0314f,18.1711f,-308.5711f,  
/* M203 */   0.4085f,0.4987f,-0.7645f,  -0.3718f,0.8558f,0.3597f,  0.8336f,0.1373f,0.5350f,  -374.0546f,11.8013f,-326.9164f,  
/* M204 */   0.4799f,0.5212f,-0.7058f,  -0.2546f,0.8525f,0.4565f,  0.8396f,-0.0394f,0.5418f,  -410.1318f,15.0391f,-357.8013f,  
/* M205 */   0.5307f,0.5381f,-0.6549f,  -0.1370f,0.8169f,0.5602f,  0.8364f,-0.2076f,0.5072f,  -444.5291f,26.9294f,-389.2596f,  
/* M206 */   0.5865f,0.5272f,-0.6149f,  -0.0304f,0.7730f,0.6336f,  0.8094f,-0.3529f,0.4694f,  -476.6454f,42.9106f,-411.1228f,  
/* M207 */   0.6456f,0.4830f,-0.5915f,  0.0679f,0.7352f,0.6745f,  0.7606f,-0.4756f,0.4418f,  -507.2670f,59.5059f,-422.4710f,  
/* M208 */   0.6913f,0.4233f,-0.5856f,  0.1664f,0.6954f,0.6991f,  0.7031f,-0.5807f,0.4103f,  -537.2114f,77.3438f,-427.7539f,  
/* M209 */   0.7220f,0.3550f,-0.5939f,  0.2611f,0.6550f,0.7091f,  0.6407f,-0.6670f,0.3802f,  -565.1421f,95.7101f,-427.7853f,  
/* M210 */   0.7390f,0.2860f,-0.6101f,  0.3457f,0.6163f,0.7076f,  0.5783f,-0.7338f,0.3565f,  -589.2005f,113.6027f,-424.0122f,  
/* M211 */   0.7425f,0.2130f,-0.6351f,  0.4233f,0.5856f,0.6913f,  0.5192f,-0.7821f,0.3446f,  -610.3099f,129.6112f,-415.2961f,  
/* M212 */   0.7317f,0.1371f,-0.6677f,  0.4968f,0.5635f,0.6601f,  0.4667f,-0.8147f,0.3442f,  -629.2065f,143.4884f,-401.7552f,  
/* M213 */   0.7125f,0.0725f,-0.6979f,  0.5573f,0.5459f,0.6256f,  0.4263f,-0.8347f,0.3486f,  -643.8723f,155.0291f,-387.6569f,  
/* M214 */   0.6948f,0.0329f,-0.7185f,  0.5968f,0.5310f,0.6015f,  0.4013f,-0.8467f,0.3493f,  -652.9771f,163.4042f,-377.4970f,  
/* M215 */   0.6835f,0.0231f,-0.7296f,  0.6143f,0.5218f,0.5919f,  0.3944f,-0.8528f,0.3425f,  -656.7843f,167.3175f,-372.4510f,  
/* M216 */   0.6756f,0.0325f,-0.7365f,  0.6179f,0.5201f,0.5897f,  0.4022f,-0.8535f,0.3313f,  -657.4130f,167.2249f,-370.0153f,  
/* M217 */   0.6697f,0.0519f,-0.7408f,  0.6139f,0.5226f,0.5916f,  0.4179f,-0.8510f,0.3181f,  -656.4081f,164.9261f,-369.1610f,  
/* M218 */   0.6641f,0.0721f,-0.7441f,  0.6086f,0.5259f,0.5941f,  0.4342f,-0.8475f,0.3054f,  -655.0577f,162.2408f,-368.8643f,  
/* M219 */   0.6581f,0.0839f,-0.7483f,  0.6080f,0.5270f,0.5938f,  0.4441f,-0.8457f,0.2958f,  -654.7767f,160.8862f,-368.0058f,  
/* M220 */   0.6531f,0.0837f,-0.7526f,  0.6131f,0.5249f,0.5904f,  0.4445f,-0.8471f,0.2915f,  -655.8998f,161.4084f,-366.5547f,  
/* M221 */   0.6503f,0.0769f,-0.7557f,  0.6194f,0.5223f,0.5862f,  0.4398f,-0.8493f,0.2920f,  -657.4091f,162.5772f,-365.1856f,  
/* M222 */   0.6486f,0.0680f,-0.7581f,  0.6245f,0.5218f,0.5811f,  0.4351f,-0.8504f,0.2960f,  -658.8618f,163.4350f,-363.6837f,  
/* M223 */   0.6477f,0.0575f,-0.7597f,  0.6279f,0.5244f,0.5750f,  0.4315f,-0.8495f,0.3035f,  -660.1796f,163.7030f,-361.8821f,  
/* M224 */   0.6476f,0.0450f,-0.7607f,  0.6306f,0.5287f,0.5682f,  0.4277f,-0.8476f,0.3140f,  -661.5890f,163.8336f,-359.8461f,  
/* M225 */   0.6474f,0.0327f,-0.7615f,  0.6332f,0.5330f,0.5612f,  0.4242f,-0.8455f,0.3243f,  -663.0580f,163.9285f,-357.7964f,  
/* M226 */   0.6464f,0.0228f,-0.7627f,  0.6361f,0.5360f,0.5551f,  0.4215f,-0.8439f,0.3319f,  -664.5425f,164.0920f,-356.0194f,  
/* M227 */   0.6446f,0.0174f,-0.7643f,  0.6390f,0.5366f,0.5511f,  0.4197f,-0.8437f,0.3348f,  -665.9009f,164.3741f,-354.9379f,  
/* M228 */   0.6422f,0.0151f,-0.7664f,  0.6419f,0.5358f,0.5485f,  0.4189f,-0.8442f,0.3344f,  -667.0887f,164.6131f,-354.3315f,  
/* M229 */   0.6391f,0.0135f,-0.7690f,  0.6448f,0.5357f,0.5452f,  0.4193f,-0.8443f,0.3337f,  -668.2047f,164.5954f,-353.5232f,  
/* M230 */   0.6338f,0.0104f,-0.7734f,  0.6495f,0.5358f,0.5395f,  0.4200f,-0.8443f,0.3328f,  -669.6229f,164.5273f,-351.9345f,  
/* M231 */   0.6275f,0.0074f,-0.7786f,  0.6547f,0.5362f,0.5328f,  0.4214f,-0.8441f,0.3316f,  -670.9766f,164.3329f,-350.0401f,  
/* M232 */   0.6235f,0.0073f,-0.7818f,  0.6559f,0.5393f,0.5281f,  0.4255f,-0.8421f,0.3315f,  -671.2651f,163.3643f,-348.7622f,  
/* M233 */   0.6230f,0.0120f,-0.7821f,  0.6504f,0.5475f,0.5265f,  0.4345f,-0.8367f,0.3333f,  -669.8455f,160.9631f,-348.3427f,  
/* M234 */   0.6244f,0.0202f,-0.7809f,  0.6406f,0.5589f,0.5266f,  0.4470f,-0.8290f,0.3360f,  -667.3682f,157.5992f,-348.3253f,  
/* M235 */   0.6264f,0.0295f,-0.7789f,  0.6298f,0.5697f,0.5280f,  0.4593f,-0.8214f,0.3383f,  -664.8269f,154.2841f,-348.6518f,  
/* M236 */   0.6282f,0.0378f,-0.7771f,  0.6216f,0.5763f,0.5305f,  0.4679f,-0.8163f,0.3386f,  -663.2547f,151.9242f,-349.3149f,  
/* M237 */   0.6297f,0.0435f,-0.7756f,  0.6175f,0.5777f,0.5337f,  0.4713f,-0.8151f,0.3370f,  -663.0759f,150.9184f,-350.2392f,  
/* M238 */   0.6312f,0.0475f,-0.7741f,  0.6159f,0.5761f,0.5375f,  0.4715f,-0.8160f,0.3344f,  -663.6796f,150.7340f,-351.3858f,  
/* M239 */   0.6329f,0.0508f,-0.7726f,  0.6153f,0.5727f,0.5417f,  0.4700f,-0.8182f,0.3312f,  -664.5888f,150.9803f,-352.7281f,  
/* M240 */   0.6347f,0.0546f,-0.7708f,  0.6146f,0.5691f,0.5463f,  0.4685f,-0.8205f,0.3277f,  -665.3236f,151.2714f,-354.2391f,  
/* M241 */   0.6369f,0.0607f,-0.7686f,  0.6117f,0.5670f,0.5517f,  0.4692f,-0.8215f,0.3240f,  -665.3358f,151.0492f,-355.9835f,  
/* M242 */   0.6395f,0.0713f,-0.7655f,  0.6052f,0.5672f,0.5585f,  0.4740f,-0.8205f,0.3196f,  -664.2697f,149.9008f,-358.1693f,  
/* M243 */   0.6424f,0.0855f,-0.7616f,  0.5962f,0.5687f,0.5667f,  0.4815f,-0.8181f,0.3143f,  -662.4598f,148.1759f,-360.7517f,  
/* M244 */   0.6451f,0.1011f,-0.7574f,  0.5861f,0.5705f,0.5754f,  0.4902f,-0.8151f,0.3087f,  -660.3388f,146.2528f,-363.4841f,  
/* M245 */   0.6475f,0.1161f,-0.7532f,  0.5765f,0.5718f,0.5837f,  0.4985f,-0.8121f,0.3033f,  -658.3584f,144.4852f,-366.1170f,  
/* M246 */   0.6475f,0.1161f,-0.7532f,  0.5765f,0.5718f,0.5837f,  0.4985f,-0.8121f,0.3033f,  -658.3584f,144.4852f,-366.1170f,  

_NULL_ }; /* End of hand_right_pData */


/* MESH ANIMATION 3 */

#define body_NumFrames  243

const float body_pData[] = {
/* M003 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  -0.0000f,-0.0000f,-0.0000f,  
/* M004 */   0.9999f,0.0113f,-0.0065f,  -0.0113f,0.9999f,-0.0010f,  0.0065f,0.0011f,1.0000f,  3.0937f,-0.8896f,0.7598f,  
/* M005 */   0.9997f,0.0221f,-0.0136f,  -0.0221f,0.9998f,-0.0014f,  0.0135f,0.0017f,0.9999f,  6.0715f,-1.7058f,1.4246f,  
/* M006 */   0.9993f,0.0311f,-0.0192f,  -0.0312f,0.9995f,-0.0015f,  0.0191f,0.0021f,0.9998f,  8.6902f,-2.3661f,1.8934f,  
/* M007 */   0.9991f,0.0374f,-0.0214f,  -0.0375f,0.9993f,-0.0014f,  0.0213f,0.0022f,0.9998f,  10.6958f,-2.7741f,2.0940f,  
/* M008 */   0.9989f,0.0423f,-0.0194f,  -0.0423f,0.9991f,-0.0023f,  0.0193f,0.0031f,0.9998f,  12.4482f,-3.0471f,2.2139f,  
/* M009 */   0.9987f,0.0477f,-0.0150f,  -0.0478f,0.9988f,-0.0044f,  0.0148f,0.0051f,0.9999f,  14.4042f,-3.3566f,2.4638f,  
/* M010 */   0.9985f,0.0538f,-0.0094f,  -0.0539f,0.9985f,-0.0072f,  0.0090f,0.0077f,0.9999f,  16.4557f,-3.7094f,2.8106f,  
/* M011 */   0.9982f,0.0604f,-0.0040f,  -0.0604f,0.9981f,-0.0103f,  0.0033f,0.0106f,0.9999f,  18.5021f,-4.1125f,3.2042f,  
/* M012 */   0.9977f,0.0685f,0.0003f,  -0.0684f,0.9976f,-0.0135f,  -0.0012f,0.0135f,0.9999f,  20.9470f,-4.6426f,3.6267f,  
/* M013 */   0.9973f,0.0730f,0.0027f,  -0.0730f,0.9972f,-0.0147f,  -0.0037f,0.0144f,0.9999f,  22.4932f,-4.9869f,3.5219f,  
/* M014 */   0.9973f,0.0730f,0.0038f,  -0.0730f,0.9972f,-0.0133f,  -0.0048f,0.0130f,0.9999f,  22.7366f,-5.1286f,2.7824f,  
/* M015 */   0.9972f,0.0748f,0.0047f,  -0.0747f,0.9971f,-0.0118f,  -0.0055f,0.0114f,0.9999f,  23.2821f,-5.5250f,2.0067f,  
/* M016 */   0.9971f,0.0756f,0.0051f,  -0.0755f,0.9971f,-0.0089f,  -0.0058f,0.0085f,0.9999f,  23.2487f,-6.0148f,0.9368f,  
/* M017 */   0.9975f,0.0711f,0.0044f,  -0.0711f,0.9975f,-0.0033f,  -0.0046f,0.0030f,1.0000f,  21.2758f,-6.2932f,-0.7034f,  
/* M018 */   0.9975f,0.0707f,0.0033f,  -0.0707f,0.9975f,0.0011f,  -0.0032f,-0.0013f,1.0000f,  19.3479f,-6.9610f,-2.0318f,  
/* M019 */   0.9967f,0.0815f,0.0021f,  -0.0815f,0.9967f,0.0012f,  -0.0020f,-0.0014f,1.0000f,  18.9603f,-8.4749f,-2.2793f,  
/* M020 */   0.9946f,0.1034f,-0.0007f,  -0.1034f,0.9946f,-0.0037f,  0.0003f,0.0038f,1.0000f,  20.7805f,-10.7803f,-0.8895f,  
/* M021 */   0.9914f,0.1306f,-0.0082f,  -0.1307f,0.9913f,-0.0117f,  0.0066f,0.0127f,0.9999f,  24.0168f,-13.3948f,2.0706f,  
/* M022 */   0.9880f,0.1527f,-0.0221f,  -0.1531f,0.9880f,-0.0184f,  0.0190f,0.0215f,0.9996f,  26.3162f,-15.6870f,5.5903f,  
/* M023 */   0.9850f,0.1690f,-0.0356f,  -0.1698f,0.9852f,-0.0230f,  0.0312f,0.0287f,0.9991f,  27.7093f,-17.6236f,8.9497f,  
/* M024 */   0.9821f,0.1835f,-0.0431f,  -0.1848f,0.9824f,-0.0271f,  0.0374f,0.0345f,0.9987f,  29.0967f,-19.3800f,11.9217f,  
/* M025 */   0.9793f,0.1974f,-0.0453f,  -0.1988f,0.9796f,-0.0306f,  0.0384f,0.0390f,0.9985f,  30.5414f,-20.9732f,14.3671f,  
/* M026 */   0.9764f,0.2115f,-0.0428f,  -0.2130f,0.9765f,-0.0335f,  0.0347f,0.0419f,0.9985f,  32.1214f,-22.4020f,16.1217f,  
/* M027 */   0.9694f,0.2443f,-0.0236f,  -0.2451f,0.9686f,-0.0408f,  0.0129f,0.0454f,0.9989f,  39.2537f,-24.0354f,17.4126f,  
/* M028 */   0.9557f,0.2944f,0.0042f,  -0.2938f,0.9544f,-0.0540f,  -0.0199f,0.0503f,0.9985f,  51.1707f,-25.4349f,19.0360f,  
/* M029 */   0.9426f,0.3338f,0.0104f,  -0.3325f,0.9410f,-0.0633f,  -0.0309f,0.0562f,0.9979f,  59.0311f,-26.1310f,20.4674f,  
/* M030 */   0.9317f,0.3626f,-0.0221f,  -0.3633f,0.9293f,-0.0671f,  -0.0037f,0.0705f,0.9975f,  62.5263f,-26.5419f,22.3359f,  
/* M031 */   0.9190f,0.3860f,-0.0799f,  -0.3910f,0.9184f,-0.0610f,  0.0499f,0.0873f,0.9949f,  63.4493f,-26.5333f,21.6876f,  
/* M032 */   0.9018f,0.3981f,-0.1684f,  -0.4078f,0.9127f,-0.0264f,  0.1432f,0.0925f,0.9854f,  58.3434f,-24.9796f,13.0445f,  
/* M033 */   0.8679f,0.4034f,-0.2899f,  -0.4111f,0.9109f,0.0367f,  0.2789f,0.0873f,0.9564f,  46.5862f,-19.8515f,-2.3138f,  
/* M034 */   0.8088f,0.4028f,-0.4285f,  -0.3958f,0.9117f,0.1101f,  0.4351f,0.0805f,0.8968f,  28.8624f,-13.4166f,-18.5832f,  
/* M035 */   0.7305f,0.3843f,-0.5646f,  -0.3465f,0.9209f,0.1784f,  0.5885f,0.0653f,0.8059f,  2.8662f,-7.2579f,-31.7080f,  
/* M036 */   0.6229f,0.3506f,-0.6994f,  -0.2662f,0.9356f,0.2319f,  0.7356f,0.0417f,0.6761f,  -29.9708f,-0.1353f,-39.1266f,  
/* M037 */   0.4661f,0.3142f,-0.8270f,  -0.1730f,0.9491f,0.2631f,  0.8676f,0.0204f,0.4968f,  -63.7834f,5.1008f,-39.3740f,  
/* M038 */   0.2686f,0.2807f,-0.9214f,  -0.0833f,0.9598f,0.2681f,  0.9596f,0.0047f,0.2812f,  -92.8460f,8.2886f,-33.1407f,  
/* M039 */   0.0516f,0.2557f,-0.9654f,  -0.0117f,0.9667f,0.2555f,  0.9986f,-0.0018f,0.0529f,  -113.2191f,9.0691f,-24.3991f,  
/* M040 */   -0.1726f,0.2549f,-0.9514f,  0.0264f,0.9668f,0.2542f,  0.9846f,0.0187f,-0.1737f,  -120.6870f,6.2264f,-21.6377f,  
/* M041 */   -0.3753f,0.2704f,-0.8866f,  0.0428f,0.9605f,0.2748f,  0.9259f,0.0652f,-0.3721f,  -119.7528f,0.3489f,-28.1388f,  
/* M042 */   -0.5196f,0.2771f,-0.8083f,  0.0532f,0.9546f,0.2930f,  0.8528f,0.1093f,-0.5107f,  -118.6051f,-4.2191f,-36.4417f,  
/* M043 */   -0.6174f,0.2701f,-0.7388f,  0.0577f,0.9522f,0.2999f,  0.7845f,0.1425f,-0.6035f,  -118.1174f,-7.8135f,-42.4864f,  
/* M044 */   -0.6941f,0.2579f,-0.6721f,  0.0557f,0.9500f,0.3071f,  0.7177f,0.1757f,-0.6738f,  -116.4445f,-9.0350f,-49.0125f,  
/* M045 */   -0.7604f,0.2401f,-0.6034f,  0.0516f,0.9486f,0.3124f,  0.6473f,0.2064f,-0.7337f,  -114.0253f,-8.5070f,-55.4478f,  
/* M046 */   -0.8241f,0.2165f,-0.5234f,  0.0498f,0.9482f,0.3137f,  0.5642f,0.2324f,-0.7922f,  -111.2658f,-7.3356f,-61.7407f,  
/* M047 */   -0.8883f,0.1873f,-0.4194f,  0.0543f,0.9495f,0.3091f,  0.4561f,0.2518f,-0.8535f,  -108.5787f,-4.3464f,-68.3491f,  
/* M048 */   -0.9457f,0.1601f,-0.2828f,  0.0725f,0.9522f,0.2967f,  0.3168f,0.2601f,-0.9121f,  -107.7773f,1.3777f,-75.8050f,  
/* M049 */   -0.9794f,0.1372f,-0.1484f,  0.0947f,0.9602f,0.2629f,  0.1786f,0.2434f,-0.9533f,  -108.6014f,9.4864f,-78.4113f,  
/* M050 */   -0.9926f,0.1174f,-0.0301f,  0.1084f,0.9709f,0.2133f,  0.0543f,0.2085f,-0.9765f,  -108.8555f,15.4908f,-76.5629f,  
/* M051 */   -0.9900f,0.1059f,0.0937f,  0.1209f,0.9776f,0.1725f,  -0.0733f,0.1821f,-0.9806f,  -110.8518f,19.5205f,-78.2454f,  
/* M052 */   -0.9654f,0.0999f,0.2408f,  0.1340f,0.9825f,0.1296f,  -0.2237f,0.1574f,-0.9619f,  -117.7424f,21.0492f,-82.6987f,  
/* M053 */   -0.9130f,0.1013f,0.3951f,  0.1405f,0.9875f,0.0717f,  -0.3829f,0.1210f,-0.9158f,  -127.3058f,19.0967f,-83.8674f,  
/* M054 */   -0.8379f,0.1204f,0.5323f,  0.1566f,0.9874f,0.0233f,  -0.5228f,0.1029f,-0.8462f,  -138.4365f,14.2348f,-85.6887f,  
/* M055 */   -0.7269f,0.1442f,0.6714f,  0.1793f,0.9837f,-0.0172f,  -0.6629f,0.1079f,-0.7409f,  -149.9186f,10.4866f,-91.0609f,  
/* M056 */   -0.5639f,0.1600f,0.8102f,  0.1837f,0.9808f,-0.0658f,  -0.8051f,0.1118f,-0.5825f,  -159.5839f,7.0945f,-96.5581f,  
/* M057 */   -0.3723f,0.1675f,0.9129f,  0.1717f,0.9790f,-0.1096f,  -0.9121f,0.1160f,-0.3932f,  -168.1440f,4.0426f,-102.4447f,  
/* M058 */   -0.1921f,0.1658f,0.9673f,  0.1525f,0.9787f,-0.1374f,  -0.9695f,0.1211f,-0.2133f,  -176.0951f,1.3483f,-109.3419f,  
/* M059 */   -0.0325f,0.1538f,0.9876f,  0.1345f,0.9798f,-0.1482f,  -0.9904f,0.1280f,-0.0526f,  -184.7411f,-0.9218f,-118.5136f,  
/* M060 */   0.1234f,0.1333f,0.9834f,  0.1203f,0.9816f,-0.1482f,  -0.9850f,0.1366f,0.1051f,  -195.8776f,-2.7226f,-130.0346f,  
/* M061 */   0.2702f,0.1075f,0.9568f,  0.1124f,0.9834f,-0.1422f,  -0.9562f,0.1460f,0.2536f,  -209.4978f,-4.0561f,-142.2383f,  
/* M062 */   0.4032f,0.0798f,0.9116f,  0.1109f,0.9846f,-0.1352f,  -0.9084f,0.1556f,0.3881f,  -224.6858f,-4.9800f,-153.3723f,  
/* M063 */   0.5191f,0.0541f,0.8530f,  0.1134f,0.9848f,-0.1315f,  -0.8472f,0.1650f,0.5051f,  -240.3542f,-5.6402f,-162.5232f,  
/* M064 */   0.6163f,0.0345f,0.7868f,  0.1158f,0.9842f,-0.1339f,  -0.7790f,0.1736f,0.6026f,  -255.0578f,-6.2759f,-169.2366f,  
/* M065 */   0.6948f,0.0250f,0.7188f,  0.1131f,0.9831f,-0.1436f,  -0.7103f,0.1811f,0.6802f,  -267.1825f,-7.1922f,-173.5365f,  
/* M066 */   0.7343f,0.0530f,0.6767f,  0.0854f,0.9818f,-0.1696f,  -0.6734f,0.1823f,0.7165f,  -268.5844f,-10.1259f,-174.0617f,  
/* M067 */   0.7342f,0.1123f,0.6696f,  0.0345f,0.9788f,-0.2020f,  -0.6781f,0.1714f,0.7147f,  -259.2564f,-14.1128f,-174.1839f,  
/* M068 */   0.7228f,0.1574f,0.6729f,  -0.0081f,0.9756f,-0.2195f,  -0.6910f,0.1532f,0.7064f,  -251.1025f,-16.3119f,-179.0522f,  
/* M069 */   0.7026f,0.1719f,0.6906f,  -0.0261f,0.9760f,-0.2163f,  -0.7111f,0.1339f,0.6902f,  -248.5815f,-13.4381f,-190.2497f,  
/* M070 */   0.6730f,0.1712f,0.7195f,  -0.0319f,0.9787f,-0.2030f,  -0.7389f,0.1137f,0.6641f,  -248.3740f,-6.6894f,-204.6453f,  
/* M071 */   0.6656f,0.1617f,0.7286f,  -0.0353f,0.9820f,-0.1857f,  -0.7455f,0.0979f,0.6593f,  -251.3302f,-1.4141f,-219.6218f,  
/* M072 */   0.6780f,0.1396f,0.7217f,  -0.0311f,0.9864f,-0.1615f,  -0.7344f,0.0870f,0.6731f,  -258.6368f,4.2245f,-237.6227f,  
/* M073 */   0.7004f,0.1075f,0.7056f,  -0.0172f,0.9908f,-0.1340f,  -0.7136f,0.0817f,0.6958f,  -270.0417f,8.2273f,-257.7426f,  
/* M074 */   0.7516f,0.0844f,0.6542f,  -0.0095f,0.9931f,-0.1173f,  -0.6595f,0.0820f,0.7472f,  -283.8060f,9.5162f,-272.9106f,  
/* M075 */   0.8487f,0.0872f,0.5217f,  -0.0270f,0.9922f,-0.1218f,  -0.5282f,0.0893f,0.8444f,  -297.9346f,7.6839f,-277.4386f,  
/* M076 */   0.9409f,0.1002f,0.3236f,  -0.0619f,0.9900f,-0.1268f,  -0.3331f,0.0993f,0.9377f,  -310.0678f,4.7678f,-276.8137f,  
/* M077 */   0.9838f,0.0973f,0.1503f,  -0.0808f,0.9904f,-0.1118f,  -0.1597f,0.0978f,0.9823f,  -321.9098f,3.3438f,-280.9070f,  
/* M078 */   0.9974f,0.0619f,0.0377f,  -0.0589f,0.9954f,-0.0752f,  -0.0422f,0.0728f,0.9965f,  -339.8921f,7.4683f,-293.4019f,  
/* M079 */   0.9988f,0.0151f,-0.0470f,  -0.0167f,0.9993f,-0.0334f,  0.0465f,0.0342f,0.9983f,  -361.1038f,15.5736f,-308.6233f,  
/* M080 */   0.9950f,-0.0134f,-0.0988f,  0.0131f,0.9999f,-0.0038f,  0.0988f,0.0025f,0.9951f,  -377.2664f,20.6481f,-323.0032f,  
/* M081 */   0.9921f,-0.0239f,-0.1231f,  0.0257f,0.9996f,0.0132f,  0.1227f,-0.0163f,0.9923f,  -388.1891f,21.6441f,-335.8275f,  
/* M082 */   0.9915f,-0.0288f,-0.1271f,  0.0319f,0.9992f,0.0224f,  0.1264f,-0.0263f,0.9916f,  -397.1875f,19.4535f,-347.9554f,  
/* M083 */   0.9942f,-0.0174f,-0.1057f,  0.0195f,0.9996f,0.0195f,  0.1053f,-0.0214f,0.9942f,  -400.6801f,13.9460f,-359.2897f,  
/* M084 */   0.9974f,0.0070f,-0.0723f,  -0.0062f,0.9999f,0.0106f,  0.0724f,-0.0101f,0.9973f,  -400.1218f,7.7428f,-370.1276f,  
/* M085 */   0.9985f,0.0320f,-0.0441f,  -0.0318f,0.9995f,0.0061f,  0.0443f,-0.0047f,0.9990f,  -399.6961f,-0.1746f,-381.5322f,  
/* M086 */   0.9982f,0.0583f,-0.0154f,  -0.0583f,0.9983f,0.0046f,  0.0157f,-0.0037f,0.9999f,  -398.9018f,-4.3924f,-393.7186f,  
/* M087 */   0.9966f,0.0821f,0.0102f,  -0.0821f,0.9966f,0.0064f,  -0.0096f,-0.0072f,0.9999f,  -398.8678f,-2.0843f,-406.6356f,  
/* M088 */   0.9946f,0.0991f,0.0291f,  -0.0995f,0.9950f,0.0116f,  -0.0278f,-0.0144f,0.9995f,  -400.8214f,3.0947f,-420.2650f,  
/* M089 */   0.9937f,0.1000f,0.0499f,  -0.1014f,0.9945f,0.0270f,  -0.0469f,-0.0319f,0.9984f,  -406.8094f,8.0594f,-437.0688f,  
/* M090 */   0.9947f,0.0845f,0.0587f,  -0.0876f,0.9947f,0.0530f,  -0.0539f,-0.0578f,0.9969f,  -417.3572f,13.8636f,-456.9625f,  
/* M091 */   0.9972f,0.0665f,0.0327f,  -0.0689f,0.9946f,0.0770f,  -0.0274f,-0.0791f,0.9965f,  -430.6818f,17.4446f,-475.0830f,  
/* M092 */   0.9972f,0.0619f,-0.0408f,  -0.0582f,0.9944f,0.0877f,  0.0461f,-0.0851f,0.9953f,  -444.1006f,17.0834f,-486.3794f,  
/* M093 */   0.9843f,0.0790f,-0.1581f,  -0.0667f,0.9944f,0.0814f,  0.1637f,-0.0696f,0.9841f,  -454.0962f,11.8452f,-488.7323f,  
/* M094 */   0.9517f,0.1090f,-0.2869f,  -0.0936f,0.9933f,0.0672f,  0.2924f,-0.0371f,0.9556f,  -459.2198f,2.9732f,-485.4254f,  
/* M095 */   0.9013f,0.1422f,-0.4093f,  -0.1317f,0.9898f,0.0541f,  0.4128f,0.0051f,0.9108f,  -460.7120f,-4.9554f,-480.5918f,  
/* M096 */   0.8389f,0.1692f,-0.5173f,  -0.1686f,0.9845f,0.0485f,  0.5174f,0.0465f,0.8544f,  -461.6582f,-11.6256f,-477.7873f,  
/* M097 */   0.7795f,0.1839f,-0.5988f,  -0.1915f,0.9801f,0.0517f,  0.5964f,0.0744f,0.7992f,  -465.6873f,-15.7640f,-478.7705f,  
/* M098 */   0.7298f,0.1816f,-0.6591f,  -0.1853f,0.9805f,0.0650f,  0.6581f,0.0747f,0.7492f,  -477.2039f,-16.3042f,-483.6546f,  
/* M099 */   0.6851f,0.1676f,-0.7089f,  -0.1556f,0.9844f,0.0824f,  0.7117f,0.0539f,0.7005f,  -494.5584f,-16.0209f,-489.9254f,  
/* M100 */   0.6467f,0.1523f,-0.7474f,  -0.1222f,0.9879f,0.0956f,  0.7529f,0.0295f,0.6575f,  -512.3522f,-14.3279f,-495.6376f,  
/* M101 */   0.6170f,0.1445f,-0.7736f,  -0.1061f,0.9893f,0.1001f,  0.7798f,0.0203f,0.6258f,  -524.9504f,-13.4160f,-499.8670f,  
/* M102 */   0.5966f,0.1483f,-0.7887f,  -0.1182f,0.9883f,0.0965f,  0.7938f,0.0357f,0.6072f,  -529.3870f,-15.0879f,-502.7012f,  
/* M103 */   0.5844f,0.1499f,-0.7975f,  -0.1352f,0.9870f,0.0864f,  0.8001f,0.0573f,0.5971f,  -531.5026f,-19.5869f,-504.1285f,  
/* M104 */   0.5778f,0.1414f,-0.8038f,  -0.1412f,0.9873f,0.0722f,  0.8038f,0.0718f,0.5905f,  -535.8192f,-25.2453f,-504.2508f,  
/* M105 */   0.5709f,0.1259f,-0.8113f,  -0.1337f,0.9892f,0.0594f,  0.8101f,0.0746f,0.5816f,  -543.4596f,-29.5979f,-504.0119f,  
/* M106 */   0.5573f,0.1059f,-0.8235f,  -0.1097f,0.9925f,0.0533f,  0.8230f,0.0606f,0.5648f,  -555.4206f,-30.0563f,-504.3068f,  
/* M107 */   0.5373f,0.0928f,-0.8382f,  -0.0823f,0.9950f,0.0573f,  0.8393f,0.0382f,0.5423f,  -568.6898f,-27.4943f,-506.1208f,  
/* M108 */   0.5120f,0.0918f,-0.8541f,  -0.0621f,0.9956f,0.0698f,  0.8568f,0.0173f,0.5154f,  -580.3193f,-24.5651f,-509.3442f,  
/* M109 */   0.4792f,0.0936f,-0.8727f,  -0.0398f,0.9956f,0.0849f,  0.8768f,-0.0059f,0.4808f,  -591.7119f,-20.9710f,-512.5533f,  
/* M110 */   0.4395f,0.0973f,-0.8930f,  -0.0171f,0.9948f,0.1000f,  0.8981f,-0.0286f,0.4389f,  -602.1337f,-16.9359f,-515.1756f,  
/* M111 */   0.3933f,0.1023f,-0.9137f,  0.0041f,0.9936f,0.1130f,  0.9194f,-0.0482f,0.3904f,  -611.3035f,-12.7378f,-516.6526f,  
/* M112 */   0.3417f,0.1082f,-0.9336f,  0.0218f,0.9922f,0.1229f,  0.9396f,-0.0623f,0.3366f,  -618.9875f,-8.6897f,-516.6356f,  
/* M113 */   0.2857f,0.1149f,-0.9514f,  0.0334f,0.9910f,0.1297f,  0.9577f,-0.0689f,0.2793f,  -624.3950f,-5.1044f,-515.3168f,  
/* M114 */   0.2271f,0.1225f,-0.9661f,  0.0369f,0.9903f,0.1342f,  0.9732f,-0.0662f,0.2204f,  -626.7986f,-2.2574f,-513.2104f,  
/* M115 */   0.1676f,0.1310f,-0.9771f,  0.0303f,0.9900f,0.1379f,  0.9854f,-0.0527f,0.1620f,  -625.5993f,-0.3505f,-511.0483f,  
/* M116 */   0.0948f,0.1388f,-0.9858f,  0.0081f,0.9901f,0.1402f,  0.9955f,-0.0213f,0.0927f,  -618.3173f,0.2991f,-508.3020f,  
/* M117 */   0.0078f,0.1423f,-0.9898f,  -0.0298f,0.9894f,0.1420f,  0.9995f,0.0284f,0.0119f,  -604.5457f,0.0347f,-505.5301f,  
/* M118 */   -0.0728f,0.1399f,-0.9875f,  -0.0767f,0.9864f,0.1454f,  0.9944f,0.0864f,-0.0611f,  -587.3513f,-0.4930f,-504.4183f,  
/* M119 */   -0.1328f,0.1349f,-0.9819f,  -0.1269f,0.9802f,0.1518f,  0.9830f,0.1447f,-0.1131f,  -569.5510f,-1.0514f,-505.6368f,  
/* M120 */   -0.1626f,0.1331f,-0.9777f,  -0.1755f,0.9712f,0.1614f,  0.9710f,0.1978f,-0.1346f,  -553.5757f,-1.7614f,-509.1583f,  
/* M121 */   -0.1722f,0.1342f,-0.9759f,  -0.2249f,0.9592f,0.1716f,  0.9591f,0.2490f,-0.1349f,  -538.3871f,-2.6492f,-513.5961f,  
/* M122 */   -0.1787f,0.1332f,-0.9748f,  -0.2791f,0.9432f,0.1801f,  0.9435f,0.3042f,-0.1314f,  -521.7479f,-3.3412f,-517.5796f,  
/* M123 */   -0.1846f,0.1305f,-0.9741f,  -0.3370f,0.9227f,0.1875f,  0.9232f,0.3629f,-0.1264f,  -504.0164f,-3.6047f,-521.0826f,  
/* M124 */   -0.1921f,0.1269f,-0.9731f,  -0.3973f,0.8967f,0.1953f,  0.8974f,0.4242f,-0.1218f,  -485.5936f,-3.2703f,-524.3655f,  
/* M125 */   -0.2032f,0.1233f,-0.9713f,  -0.4587f,0.8645f,0.2057f,  0.8651f,0.4873f,-0.1191f,  -466.8853f,-2.1735f,-527.9980f,  
/* M126 */   -0.2202f,0.1212f,-0.9679f,  -0.5195f,0.8253f,0.2215f,  0.8256f,0.5516f,-0.1187f,  -448.2901f,-0.1030f,-532.8329f,  
/* M127 */   -0.2385f,0.1228f,-0.9633f,  -0.5803f,0.7774f,0.2428f,  0.7787f,0.6169f,-0.1141f,  -430.0793f,3.2405f,-539.0201f,  
/* M128 */   -0.2510f,0.1290f,-0.9593f,  -0.6397f,0.7217f,0.2645f,  0.7265f,0.6801f,-0.0986f,  -412.5969f,7.8277f,-545.2300f,  
/* M129 */   -0.2565f,0.1405f,-0.9563f,  -0.6934f,0.6626f,0.2833f,  0.6734f,0.7357f,-0.0726f,  -396.6682f,13.0352f,-550.6000f,  
/* M130 */   -0.2579f,0.1572f,-0.9533f,  -0.7404f,0.6018f,0.2995f,  0.6208f,0.7830f,-0.0388f,  -382.4827f,18.5826f,-555.3752f,  
/* M131 */   -0.2599f,0.1773f,-0.9492f,  -0.7803f,0.5405f,0.3146f,  0.5688f,0.8225f,-0.0022f,  -369.8960f,24.4562f,-560.0511f,  
/* M132 */   -0.2632f,0.2003f,-0.9437f,  -0.8140f,0.4789f,0.3287f,  0.5178f,0.8547f,0.0369f,  -359.0144f,30.6768f,-564.7203f,  
/* M133 */   -0.2677f,0.2264f,-0.9365f,  -0.8432f,0.4153f,0.3415f,  0.4663f,0.8811f,0.0797f,  -349.3987f,37.6608f,-569.4337f,  
/* M134 */   -0.2737f,0.2549f,-0.9274f,  -0.8677f,0.3506f,0.3524f,  0.4150f,0.9012f,0.1252f,  -340.8733f,45.3505f,-574.0723f,  
/* M135 */   -0.2810f,0.2846f,-0.9165f,  -0.8876f,0.2862f,0.3610f,  0.3651f,0.9149f,0.1722f,  -333.4345f,53.6621f,-578.4448f,  
/* M136 */   -0.2895f,0.3147f,-0.9039f,  -0.9031f,0.2232f,0.3670f,  0.3172f,0.9226f,0.2196f,  -327.0464f,62.5694f,-582.3730f,  
/* M137 */   -0.2988f,0.3442f,-0.8901f,  -0.9146f,0.1629f,0.3700f,  0.2723f,0.9247f,0.2661f,  -321.6399f,71.8776f,-585.6949f,  
/* M138 */   -0.3081f,0.3720f,-0.8756f,  -0.9229f,0.1065f,0.3700f,  0.2309f,0.9221f,0.3105f,  -317.1153f,81.2308f,-588.2646f,  
/* M139 */   -0.3178f,0.3972f,-0.8610f,  -0.9285f,0.0539f,0.3675f,  0.1924f,0.9162f,0.3516f,  -313.3081f,90.5391f,-590.1041f,  
/* M140 */   -0.3285f,0.4185f,-0.8467f,  -0.9314f,0.0049f,0.3639f,  0.1565f,0.9082f,0.3882f,  -310.1345f,99.7121f,-591.4594f,  
/* M141 */   -0.3406f,0.4352f,-0.8334f,  -0.9320f,-0.0392f,0.3604f,  0.1241f,0.8995f,0.4189f,  -307.5812f,108.3926f,-592.5589f,  
/* M142 */   -0.3487f,0.4495f,-0.8224f,  -0.9316f,-0.0706f,0.3565f,  0.1022f,0.8905f,0.4434f,  -305.9282f,114.6524f,-593.1266f,  
/* M143 */   -0.3495f,0.4645f,-0.8137f,  -0.9321f,-0.0842f,0.3523f,  0.0951f,0.8816f,0.4624f,  -305.1924f,117.1481f,-593.2047f,  
/* M144 */   -0.3456f,0.4793f,-0.8067f,  -0.9330f,-0.0836f,0.3500f,  0.1003f,0.8736f,0.4761f,  -305.1378f,116.4648f,-593.4144f,  
/* M145 */   -0.3384f,0.4932f,-0.8014f,  -0.9343f,-0.0747f,0.3486f,  0.1121f,0.8667f,0.4861f,  -305.4424f,113.8875f,-593.5106f,  
/* M146 */   -0.3299f,0.5051f,-0.7976f,  -0.9359f,-0.0640f,0.3465f,  0.1239f,0.8607f,0.4938f,  -305.7546f,110.9561f,-593.1707f,  
/* M147 */   -0.3234f,0.5141f,-0.7944f,  -0.9369f,-0.0562f,0.3450f,  0.1327f,0.8559f,0.4998f,  -305.8730f,108.6721f,-592.7980f,  
/* M148 */   -0.3240f,0.5114f,-0.7959f,  -0.9357f,-0.0494f,0.3492f,  0.1392f,0.8579f,0.4945f,  -305.9187f,107.1077f,-593.0005f,  
/* M149 */   -0.3262f,0.5008f,-0.8017f,  -0.9338f,-0.0385f,0.3558f,  0.1473f,0.8647f,0.4802f,  -306.1188f,105.0686f,-593.0572f,  
/* M150 */   -0.3171f,0.5014f,-0.8050f,  -0.9350f,-0.0230f,0.3540f,  0.1590f,0.8649f,0.4761f,  -306.4114f,101.6754f,-591.3774f,  
/* M151 */   -0.2985f,0.5135f,-0.8045f,  -0.9386f,-0.0052f,0.3449f,  0.1730f,0.8581f,0.4835f,  -306.8073f,97.4438f,-588.4232f,  
/* M152 */   -0.2808f,0.5253f,-0.8033f,  -0.9414f,0.0122f,0.3370f,  0.1869f,0.8508f,0.4911f,  -307.3125f,93.4725f,-585.7020f,  
/* M153 */   -0.2640f,0.5368f,-0.8013f,  -0.9434f,0.0294f,0.3305f,  0.2010f,0.8432f,0.4987f,  -307.9400f,89.7597f,-583.2504f,  
/* M154 */   -0.2483f,0.5482f,-0.7987f,  -0.9444f,0.0466f,0.3256f,  0.2157f,0.8351f,0.5061f,  -308.7087f,86.2528f,-581.1037f,  
/* M155 */   -0.2337f,0.5593f,-0.7954f,  -0.9444f,0.0639f,0.3224f,  0.2312f,0.8265f,0.5133f,  -309.6432f,82.8595f,-579.2950f,  
/* M156 */   -0.2202f,0.5702f,-0.7915f,  -0.9435f,0.0817f,0.3213f,  0.2479f,0.8174f,0.5200f,  -310.7765f,79.5175f,-577.8550f,  
/* M157 */   -0.2078f,0.5808f,-0.7871f,  -0.9413f,0.1001f,0.3224f,  0.2660f,0.8079f,0.5259f,  -312.1491f,76.1653f,-576.8100f,  
/* M158 */   -0.1966f,0.5911f,-0.7823f,  -0.9379f,0.1193f,0.3258f,  0.2860f,0.7977f,0.5309f,  -313.7718f,72.7425f,-575.9154f,  
/* M159 */   -0.1865f,0.6010f,-0.7772f,  -0.9329f,0.1396f,0.3319f,  0.3080f,0.7869f,0.5347f,  -315.6742f,69.1900f,-574.9744f,  
/* M160 */   -0.1776f,0.6105f,-0.7719f,  -0.9263f,0.1612f,0.3406f,  0.3324f,0.7755f,0.5368f,  -317.9422f,65.4511f,-574.0729f,  
/* M161 */   -0.1698f,0.6193f,-0.7666f,  -0.9176f,0.1843f,0.3522f,  0.3594f,0.7632f,0.5369f,  -320.6758f,61.4715f,-573.2827f,  
/* M162 */   -0.1713f,0.6272f,-0.7598f,  -0.9025f,0.2094f,0.3763f,  0.3951f,0.7502f,0.5302f,  -324.7293f,57.1653f,-575.1711f,  
/* M163 */   -0.1863f,0.6339f,-0.7506f,  -0.8771f,0.2369f,0.4177f,  0.4426f,0.7362f,0.5119f,  -330.9954f,52.4274f,-580.9786f,  
/* M164 */   -0.2094f,0.6392f,-0.7400f,  -0.8417f,0.2673f,0.4691f,  0.4976f,0.7211f,0.4821f,  -339.6023f,47.1880f,-588.7451f,  
/* M165 */   -0.2357f,0.6428f,-0.7289f,  -0.7975f,0.3008f,0.5231f,  0.5555f,0.7045f,0.4417f,  -350.4181f,41.3948f,-596.5505f,  
/* M166 */   -0.2501f,0.6436f,-0.7233f,  -0.7489f,0.3449f,0.5659f,  0.6136f,0.6832f,0.3958f,  -363.1803f,33.7393f,-600.6611f,  
/* M167 */   -0.2446f,0.6390f,-0.7293f,  -0.7011f,0.4030f,0.5883f,  0.6698f,0.6552f,0.3495f,  -377.0518f,22.8299f,-598.5077f,  
/* M168 */   -0.2239f,0.6263f,-0.7468f,  -0.6566f,0.4693f,0.5904f,  0.7203f,0.6225f,0.3061f,  -390.8572f,10.1854f,-590.3430f,  
/* M169 */   -0.1915f,0.6045f,-0.7732f,  -0.6178f,0.5379f,0.5736f,  0.7627f,0.5875f,0.2704f,  -403.5832f,-1.2323f,-576.9178f,  
/* M170 */   -0.1551f,0.5744f,-0.8038f,  -0.5831f,0.6035f,0.5438f,  0.7974f,0.5530f,0.2413f,  -414.6860f,-10.4071f,-558.1369f,  
/* M171 */   -0.1253f,0.5393f,-0.8327f,  -0.5490f,0.6614f,0.5110f,  0.8264f,0.5212f,0.2133f,  -424.2650f,-17.7845f,-536.1274f,  
/* M172 */   -0.1085f,0.5055f,-0.8560f,  -0.5152f,0.7078f,0.4833f,  0.8502f,0.4935f,0.1837f,  -432.3426f,-23.0435f,-515.4326f,  
/* M173 */   -0.1061f,0.4762f,-0.8729f,  -0.4810f,0.7438f,0.4642f,  0.8703f,0.4691f,0.1501f,  -439.4682f,-26.5954f,-499.0562f,  
/* M174 */   -0.1122f,0.4507f,-0.8856f,  -0.4461f,0.7735f,0.4502f,  0.8879f,0.4456f,0.1143f,  -446.3719f,-29.1078f,-486.2599f,  
/* M175 */   -0.1229f,0.4299f,-0.8945f,  -0.4112f,0.7982f,0.4402f,  0.9032f,0.4219f,0.0786f,  -453.0467f,-30.8373f,-475.3120f,  
/* M176 */   -0.1363f,0.4119f,-0.9010f,  -0.3757f,0.8201f,0.4317f,  0.9167f,0.3973f,0.0430f,  -459.6050f,-32.0332f,-465.3664f,  
/* M177 */   -0.1491f,0.3945f,-0.9067f,  -0.3403f,0.8405f,0.4216f,  0.9284f,0.3714f,0.0089f,  -465.9236f,-32.8313f,-455.4164f,  
/* M178 */   -0.1555f,0.3775f,-0.9129f,  -0.3075f,0.8597f,0.4079f,  0.9387f,0.3442f,-0.0176f,  -471.6014f,-33.2320f,-444.7482f,  
/* M179 */   -0.1497f,0.3602f,-0.9208f,  -0.2798f,0.8778f,0.3888f,  0.9483f,0.3158f,-0.0307f,  -476.2545f,-33.2136f,-432.7751f,  
/* M180 */   -0.1252f,0.3505f,-0.9282f,  -0.2543f,0.8929f,0.3715f,  0.9590f,0.2825f,-0.0227f,  -480.9453f,-32.7465f,-421.4905f,  
/* M181 */   -0.0839f,0.3497f,-0.9331f,  -0.2326f,0.9037f,0.3595f,  0.9690f,0.2472f,0.0055f,  -484.7068f,-31.3185f,-411.5234f,  
/* M182 */   -0.0337f,0.3474f,-0.9371f,  -0.2225f,0.9115f,0.3459f,  0.9744f,0.2201f,0.0466f,  -484.7274f,-28.7680f,-400.5868f,  
/* M183 */   0.0434f,0.3400f,-0.9394f,  -0.2422f,0.9158f,0.3203f,  0.9693f,0.2136f,0.1221f,  -477.3007f,-25.5216f,-386.7026f,  
/* M184 */   0.1482f,0.3224f,-0.9349f,  -0.2912f,0.9177f,0.2703f,  0.9451f,0.2322f,0.2299f,  -462.8504f,-21.9827f,-367.0794f,  
/* M185 */   0.2524f,0.2923f,-0.9224f,  -0.3404f,0.9192f,0.1981f,  0.9057f,0.2640f,0.3315f,  -448.2436f,-18.3617f,-342.0725f,  
/* M186 */   0.3230f,0.2485f,-0.9132f,  -0.3686f,0.9218f,0.1205f,  0.8717f,0.2976f,0.3893f,  -438.2722f,-14.8157f,-315.2734f,  
/* M187 */   0.3648f,0.2010f,-0.9091f,  -0.3776f,0.9245f,0.0528f,  0.8511f,0.3240f,0.4131f,  -432.5090f,-11.3153f,-290.7209f,  
/* M188 */   0.4046f,0.1683f,-0.8989f,  -0.3743f,0.9273f,0.0052f,  0.8344f,0.3344f,0.4381f,  -429.9926f,-8.3979f,-271.9537f,  
/* M189 */   0.4408f,0.1481f,-0.8853f,  -0.3626f,0.9316f,-0.0247f,  0.8211f,0.3319f,0.4643f,  -429.6432f,-6.3152f,-258.3214f,  
/* M190 */   0.4729f,0.1300f,-0.8715f,  -0.3471f,0.9366f,-0.0486f,  0.8099f,0.3255f,0.4880f,  -430.2072f,-4.5676f,-246.3784f,  
/* M191 */   0.5011f,0.1139f,-0.8579f,  -0.3290f,0.9420f,-0.0670f,  0.8004f,0.3158f,0.5095f,  -431.4973f,-3.1605f,-236.1454f,  
/* M192 */   0.5258f,0.1000f,-0.8447f,  -0.3092f,0.9476f,-0.0803f,  0.7924f,0.3034f,0.5292f,  -433.3688f,-2.0914f,-227.6026f,  
/* M193 */   0.5475f,0.0880f,-0.8322f,  -0.2886f,0.9533f,-0.0891f,  0.7855f,0.2889f,0.5473f,  -435.7186f,-1.3536f,-220.6993f,  
/* M194 */   0.5663f,0.0778f,-0.8205f,  -0.2678f,0.9589f,-0.0939f,  0.7795f,0.2729f,0.5639f,  -438.4827f,-0.8464f,-215.3617f,  
/* M195 */   0.5829f,0.0692f,-0.8096f,  -0.2473f,0.9642f,-0.0957f,  0.7740f,0.2560f,0.5792f,  -441.6331f,-0.4537f,-211.4993f,  
/* M196 */   0.5975f,0.0619f,-0.7994f,  -0.2276f,0.9691f,-0.0951f,  0.7689f,0.2387f,0.5932f,  -445.1746f,-0.1439f,-209.0106f,  
/* M197 */   0.6106f,0.0556f,-0.7900f,  -0.2090f,0.9735f,-0.0930f,  0.7638f,0.2218f,0.6061f,  -448.7861f,0.1114f,-207.4193f,  
/* M198 */   0.6225f,0.0500f,-0.7810f,  -0.1916f,0.9773f,-0.0902f,  0.7588f,0.2058f,0.6180f,  -452.0937f,0.3378f,-206.1698f,  
/* M199 */   0.6336f,0.0445f,-0.7724f,  -0.1757f,0.9805f,-0.0877f,  0.7535f,0.1912f,0.6291f,  -455.0602f,0.5581f,-205.0395f,  
/* M200 */   0.6397f,0.0429f,-0.7675f,  -0.1663f,0.9825f,-0.0837f,  0.7505f,0.1811f,0.6356f,  -455.8134f,0.5260f,-204.3811f,  
/* M201 */   0.6352f,0.0462f,-0.7709f,  -0.1644f,0.9834f,-0.0765f,  0.7546f,0.1753f,0.6323f,  -453.7987f,0.1649f,-204.2184f,  
/* M202 */   0.6184f,0.0499f,-0.7843f,  -0.1636f,0.9843f,-0.0664f,  0.7686f,0.1694f,0.6169f,  -450.9698f,-0.2420f,-204.0472f,  
/* M203 */   0.5866f,0.0498f,-0.8084f,  -0.1578f,0.9860f,-0.0538f,  0.7944f,0.1591f,0.5862f,  -449.1608f,-0.4014f,-203.2552f,  
/* M204 */   0.5545f,0.0488f,-0.8307f,  -0.1493f,0.9879f,-0.0416f,  0.8187f,0.1471f,0.5551f,  -448.4914f,-0.4608f,-202.3119f,  
/* M205 */   0.5359f,0.0521f,-0.8427f,  -0.1446f,0.9890f,-0.0308f,  0.8318f,0.1384f,0.5375f,  -447.8223f,-0.7438f,-202.1273f,  
/* M206 */   0.5207f,0.0575f,-0.8518f,  -0.1419f,0.9897f,-0.0199f,  0.8419f,0.1313f,0.5235f,  -447.0631f,-1.1159f,-202.2803f,  
/* M207 */   0.5076f,0.0640f,-0.8592f,  -0.1403f,0.9901f,-0.0092f,  0.8501f,0.1252f,0.5116f,  -446.3163f,-1.5131f,-202.6633f,  
/* M208 */   0.4953f,0.0708f,-0.8659f,  -0.1388f,0.9903f,0.0015f,  0.8576f,0.1194f,0.5003f,  -445.6951f,-1.8709f,-203.1614f,  
/* M209 */   0.4820f,0.0769f,-0.8728f,  -0.1363f,0.9906f,0.0121f,  0.8655f,0.1131f,0.4880f,  -445.3253f,-2.1833f,-203.6533f,  
/* M210 */   0.4665f,0.0818f,-0.8807f,  -0.1316f,0.9910f,0.0223f,  0.8747f,0.1055f,0.4731f,  -445.3449f,-2.4252f,-204.0107f,  
/* M211 */   0.4494f,0.0853f,-0.8892f,  -0.1250f,0.9916f,0.0320f,  0.8845f,0.0968f,0.4563f,  -445.7475f,-2.5609f,-204.2314f,  
/* M212 */   0.4326f,0.0884f,-0.8973f,  -0.1175f,0.9922f,0.0411f,  0.8939f,0.0876f,0.4396f,  -446.3877f,-2.5975f,-204.4018f,  
/* M213 */   0.4162f,0.0911f,-0.9047f,  -0.1094f,0.9928f,0.0496f,  0.9027f,0.0783f,0.4231f,  -447.2023f,-2.5501f,-204.5205f,  
/* M214 */   0.4005f,0.0936f,-0.9115f,  -0.1010f,0.9932f,0.0576f,  0.9107f,0.0690f,0.4072f,  -448.1280f,-2.4635f,-204.5872f,  
/* M215 */   0.3856f,0.0959f,-0.9177f,  -0.0928f,0.9936f,0.0649f,  0.9180f,0.0601f,0.3920f,  -449.1021f,-2.3530f,-204.6027f,  
/* M216 */   0.3717f,0.0982f,-0.9231f,  -0.0849f,0.9938f,0.0716f,  0.9244f,0.0518f,0.3778f,  -450.0621f,-2.2349f,-204.5688f,  
/* M217 */   0.3591f,0.1006f,-0.9278f,  -0.0778f,0.9939f,0.0777f,  0.9300f,0.0443f,0.3648f,  -451.0176f,-2.1263f,-204.5624f,  
/* M218 */   0.3480f,0.1030f,-0.9318f,  -0.0715f,0.9940f,0.0832f,  0.9347f,0.0377f,0.3533f,  -452.0128f,-2.0339f,-204.6517f,  
/* M219 */   0.3433f,0.1043f,-0.9334f,  -0.0673f,0.9940f,0.0863f,  0.9368f,0.0332f,0.3482f,  -452.9774f,-1.9492f,-204.6765f,  
/* M220 */   0.3471f,0.1037f,-0.9321f,  -0.0657f,0.9941f,0.0861f,  0.9355f,0.0314f,0.3519f,  -453.8514f,-1.8730f,-204.5511f,  
/* M221 */   0.3561f,0.1020f,-0.9289f,  -0.0659f,0.9943f,0.0839f,  0.9321f,0.0313f,0.3608f,  -454.6762f,-1.8113f,-204.3639f,  
/* M222 */   0.3667f,0.0999f,-0.9250f,  -0.0667f,0.9945f,0.0809f,  0.9280f,0.0320f,0.3713f,  -455.4974f,-1.7675f,-204.1921f,  
/* M223 */   0.3755f,0.0981f,-0.9216f,  -0.0673f,0.9946f,0.0784f,  0.9244f,0.0326f,0.3801f,  -456.3618f,-1.7372f,-204.1057f,  
/* M224 */   0.3792f,0.0972f,-0.9202f,  -0.0667f,0.9948f,0.0775f,  0.9229f,0.0320f,0.3837f,  -457.3161f,-1.7126f,-204.1690f,  
/* M225 */   0.3768f,0.0973f,-0.9211f,  -0.0647f,0.9948f,0.0786f,  0.9240f,0.0300f,0.3812f,  -458.3715f,-1.6898f,-204.3816f,  
/* M226 */   0.3711f,0.0980f,-0.9234f,  -0.0619f,0.9948f,0.0807f,  0.9265f,0.0272f,0.3752f,  -459.4707f,-1.6683f,-204.6660f,  
/* M227 */   0.3635f,0.0989f,-0.9263f,  -0.0588f,0.9948f,0.0832f,  0.9297f,0.0242f,0.3674f,  -460.5576f,-1.6509f,-204.9703f,  
/* M228 */   0.3558f,0.0998f,-0.9292f,  -0.0559f,0.9948f,0.0855f,  0.9329f,0.0215f,0.3595f,  -461.5739f,-1.6409f,-205.2464f,  
/* M229 */   0.3496f,0.1004f,-0.9315f,  -0.0538f,0.9948f,0.0870f,  0.9353f,0.0197f,0.3532f,  -462.4589f,-1.6422f,-205.4499f,  
/* M230 */   0.3467f,0.1002f,-0.9326f,  -0.0529f,0.9948f,0.0872f,  0.9365f,0.0191f,0.3502f,  -463.1511f,-1.6590f,-205.5380f,  
/* M231 */   0.3478f,0.0992f,-0.9323f,  -0.0534f,0.9949f,0.0859f,  0.9360f,0.0200f,0.3513f,  -463.6042f,-1.6898f,-205.5077f,  
/* M232 */   0.3518f,0.0976f,-0.9310f,  -0.0550f,0.9950f,0.0835f,  0.9345f,0.0219f,0.3554f,  -463.8292f,-1.7327f,-205.3881f,  
/* M233 */   0.3575f,0.0957f,-0.9290f,  -0.0574f,0.9951f,0.0804f,  0.9322f,0.0246f,0.3612f,  -463.8520f,-1.7913f,-205.1833f,  
/* M234 */   0.3635f,0.0939f,-0.9269f,  -0.0604f,0.9952f,0.0771f,  0.9296f,0.0279f,0.3674f,  -463.6985f,-1.8689f,-204.8994f,  
/* M235 */   0.3686f,0.0924f,-0.9250f,  -0.0635f,0.9952f,0.0741f,  0.9274f,0.0315f,0.3727f,  -463.3950f,-1.9688f,-204.5455f,  
/* M236 */   0.3717f,0.0917f,-0.9238f,  -0.0668f,0.9952f,0.0719f,  0.9260f,0.0350f,0.3760f,  -462.9818f,-2.0946f,-204.1886f,  
/* M237 */   0.3715f,0.0921f,-0.9239f,  -0.0701f,0.9950f,0.0710f,  0.9258f,0.0384f,0.3761f,  -462.4808f,-2.2633f,-203.9238f,  
/* M238 */   0.3685f,0.0934f,-0.9249f,  -0.0733f,0.9948f,0.0712f,  0.9267f,0.0416f,0.3734f,  -461.9176f,-2.4656f,-203.7283f,  
/* M239 */   0.3639f,0.0950f,-0.9266f,  -0.0765f,0.9945f,0.0720f,  0.9283f,0.0446f,0.3691f,  -461.3251f,-2.6753f,-203.5402f,  
/* M240 */   0.3579f,0.0964f,-0.9288f,  -0.0787f,0.9942f,0.0728f,  0.9304f,0.0471f,0.3634f,  -460.8462f,-2.8479f,-203.2943f,  
/* M241 */   0.3508f,0.0968f,-0.9314f,  -0.0794f,0.9941f,0.0734f,  0.9331f,0.0482f,0.3565f,  -460.6243f,-2.9405f,-202.9262f,  
/* M242 */   0.3431f,0.0963f,-0.9343f,  -0.0787f,0.9942f,0.0736f,  0.9360f,0.0483f,0.3487f,  -460.6516f,-2.9578f,-202.4464f,  
/* M243 */   0.3353f,0.0955f,-0.9372f,  -0.0774f,0.9943f,0.0736f,  0.9389f,0.0478f,0.3408f,  -460.7849f,-2.9450f,-201.9230f,  
/* M244 */   0.3277f,0.0945f,-0.9400f,  -0.0759f,0.9944f,0.0735f,  0.9417f,0.0472f,0.3331f,  -460.9639f,-2.9197f,-201.3796f,  
/* M245 */   0.3205f,0.0935f,-0.9426f,  -0.0746f,0.9945f,0.0733f,  0.9443f,0.0468f,0.3257f,  -461.1296f,-2.9001f,-200.8409f,  
/* M246 */   0.3141f,0.0927f,-0.9449f,  -0.0739f,0.9946f,0.0730f,  0.9465f,0.0469f,0.3192f,  -461.2237f,-2.9041f,-200.3324f,  
/* M247 */   0.3141f,0.0927f,-0.9449f,  -0.0739f,0.9946f,0.0730f,  0.9465f,0.0469f,0.3192f,  -461.2237f,-2.9041f,-200.3324f,  

_NULL_ }; /* End of body_pData */


/* MESH ANIMATION 4 */

#define object02_NumFrames  243

const float object02_pData[] = {
/* M004 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  -0.0000f,-0.0000f,0.0000f,  
/* M005 */   1.0000f,-0.0000f,-0.0000f,  0.0000f,1.0000f,-0.0001f,  0.0000f,0.0001f,1.0000f,  -0.0008f,-0.0067f,0.0009f,  
/* M006 */   1.0000f,-0.0001f,-0.0000f,  0.0001f,1.0000f,-0.0005f,  0.0000f,0.0005f,1.0000f,  -0.0029f,-0.0253f,0.0034f,  
/* M007 */   1.0000f,-0.0002f,-0.0001f,  0.0002f,1.0000f,-0.0011f,  0.0001f,0.0011f,1.0000f,  -0.0062f,-0.0541f,0.0072f,  
/* M008 */   1.0000f,-0.0004f,-0.0002f,  0.0004f,1.0000f,-0.0019f,  0.0002f,0.0019f,1.0000f,  -0.0105f,-0.0907f,0.0121f,  
/* M009 */   1.0000f,-0.0005f,-0.0002f,  0.0005f,1.0000f,-0.0028f,  0.0003f,0.0028f,1.0000f,  -0.0154f,-0.1334f,0.0178f,  
/* M010 */   1.0000f,-0.0007f,-0.0003f,  0.0007f,1.0000f,-0.0037f,  0.0003f,0.0037f,1.0000f,  -0.0208f,-0.1801f,0.0241f,  
/* M011 */   1.0000f,-0.0009f,-0.0004f,  0.0009f,1.0000f,-0.0047f,  0.0004f,0.0047f,1.0000f,  -0.0265f,-0.2287f,0.0307f,  
/* M012 */   1.0000f,-0.0011f,-0.0005f,  0.0011f,1.0000f,-0.0057f,  0.0005f,0.0057f,1.0000f,  -0.0321f,-0.2774f,0.0374f,  
/* M013 */   1.0000f,-0.0013f,-0.0006f,  0.0013f,1.0000f,-0.0067f,  0.0006f,0.0067f,1.0000f,  -0.0375f,-0.3241f,0.0438f,  
/* M014 */   1.0000f,-0.0014f,-0.0007f,  0.0014f,1.0000f,-0.0076f,  0.0007f,0.0076f,1.0000f,  -0.0425f,-0.3667f,0.0498f,  
/* M015 */   1.0000f,-0.0016f,-0.0007f,  0.0016f,1.0000f,-0.0084f,  0.0008f,0.0084f,1.0000f,  -0.0468f,-0.4034f,0.0549f,  
/* M016 */   1.0000f,-0.0017f,-0.0008f,  0.0017f,1.0000f,-0.0090f,  0.0008f,0.0090f,1.0000f,  -0.0501f,-0.4320f,0.0589f,  
/* M017 */   1.0000f,-0.0018f,-0.0008f,  0.0018f,1.0000f,-0.0093f,  0.0009f,0.0093f,1.0000f,  -0.0523f,-0.4507f,0.0616f,  
/* M018 */   1.0000f,-0.0018f,-0.0008f,  0.0018f,1.0000f,-0.0095f,  0.0009f,0.0095f,1.0000f,  -0.0531f,-0.4573f,0.0625f,  
/* M019 */   1.0000f,-0.0007f,-0.0013f,  0.0007f,0.9999f,-0.0132f,  0.0013f,0.0132f,0.9999f,  -0.0783f,-0.7279f,0.0958f,  
/* M020 */   1.0000f,0.0020f,-0.0026f,  -0.0020f,0.9997f,-0.0230f,  0.0025f,0.0230f,0.9997f,  -0.1416f,-1.4254f,0.1862f,  
/* M021 */   1.0000f,0.0057f,-0.0043f,  -0.0058f,0.9993f,-0.0363f,  0.0041f,0.0363f,0.9993f,  -0.2250f,-2.3778f,0.3211f,  
/* M022 */   0.9999f,0.0096f,-0.0063f,  -0.0099f,0.9987f,-0.0507f,  0.0058f,0.0508f,0.9987f,  -0.3114f,-3.4137f,0.4825f,  
/* M023 */   0.9999f,0.0133f,-0.0081f,  -0.0138f,0.9979f,-0.0640f,  0.0072f,0.0641f,0.9979f,  -0.3869f,-4.3626f,0.6440f,  
/* M024 */   0.9998f,0.0159f,-0.0095f,  -0.0166f,0.9971f,-0.0736f,  0.0083f,0.0738f,0.9972f,  -0.4396f,-5.0554f,0.7702f,  
/* M025 */   0.9998f,0.0169f,-0.0100f,  -0.0177f,0.9968f,-0.0774f,  0.0087f,0.0776f,0.9970f,  -0.4595f,-5.3237f,0.8210f,  
/* M026 */   0.9996f,0.0270f,-0.0109f,  -0.0278f,0.9964f,-0.0802f,  0.0087f,0.0804f,0.9967f,  -0.4293f,-5.9930f,0.8822f,  
/* M027 */   0.9987f,0.0491f,-0.0129f,  -0.0500f,0.9950f,-0.0862f,  0.0086f,0.0868f,0.9962f,  -0.3387f,-7.4637f,1.0234f,  
/* M028 */   0.9974f,0.0711f,-0.0150f,  -0.0722f,0.9931f,-0.0922f,  0.0083f,0.0931f,0.9956f,  -0.2154f,-8.9310f,1.1735f,  
/* M029 */   0.9966f,0.0812f,-0.0160f,  -0.0823f,0.9921f,-0.0950f,  0.0082f,0.0959f,0.9954f,  -0.1485f,-9.5966f,1.2446f,  
/* M030 */   0.9960f,0.0883f,-0.0163f,  -0.0895f,0.9914f,-0.0955f,  0.0078f,0.0965f,0.9953f,  -0.0808f,-9.9908f,1.2655f,  
/* M031 */   0.9947f,0.1017f,-0.0170f,  -0.1029f,0.9900f,-0.0964f,  0.0070f,0.0977f,0.9952f,  0.0526f,-10.7213f,1.3047f,  
/* M032 */   0.9939f,0.1089f,-0.0173f,  -0.1100f,0.9892f,-0.0969f,  0.0066f,0.0983f,0.9951f,  0.1285f,-11.1139f,1.3261f,  
/* M033 */   0.9851f,0.1715f,0.0118f,  -0.1691f,0.9792f,-0.1117f,  -0.0308f,0.1080f,0.9937f,  2.8335f,-14.1107f,-0.0234f,  
/* M034 */   0.9715f,0.2337f,0.0400f,  -0.2270f,0.9654f,-0.1281f,  -0.0685f,0.1154f,0.9910f,  5.8065f,-16.9415f,-1.2468f,  
/* M035 */   0.9690f,0.2453f,0.0294f,  -0.2404f,0.9636f,-0.1174f,  -0.0571f,0.1067f,0.9926f,  5.0954f,-16.5440f,-1.2013f,  
/* M036 */   0.9245f,0.3811f,-0.0050f,  -0.3803f,0.9213f,-0.0809f,  -0.0262f,0.0767f,0.9967f,  4.5521f,-17.0414f,-0.9567f,  
/* M037 */   0.8878f,0.3753f,-0.2665f,  -0.3810f,0.9240f,0.0320f,  0.2582f,0.0732f,0.9633f,  -23.9028f,-13.1843f,-4.2428f,  
/* M038 */   0.7195f,0.3346f,-0.6086f,  -0.3101f,0.9389f,0.1495f,  0.6214f,0.0812f,0.7793f,  -57.4945f,-9.7832f,17.0275f,  
/* M039 */   0.4456f,0.2754f,-0.8518f,  -0.2144f,0.9566f,0.1972f,  0.8692f,0.0948f,0.4853f,  -67.8046f,-3.3040f,39.8771f,  
/* M040 */   0.1665f,0.1719f,-0.9709f,  -0.1556f,0.9769f,0.1463f,  0.9737f,0.1267f,0.1895f,  -65.6387f,0.8915f,45.9932f,  
/* M041 */   -0.0805f,0.0479f,-0.9956f,  -0.1579f,0.9856f,0.0602f,  0.9842f,0.1620f,-0.0718f,  -61.5709f,2.2788f,40.0100f,  
/* M042 */   -0.2324f,0.0055f,-0.9726f,  -0.1733f,0.9838f,0.0470f,  0.9571f,0.1794f,-0.2276f,  -64.4230f,-2.3452f,21.3026f,  
/* M043 */   -0.2645f,0.0814f,-0.9609f,  -0.1402f,0.9826f,0.1218f,  0.9541f,0.1669f,-0.2485f,  -81.3763f,-10.7844f,-6.2920f,  
/* M044 */   -0.2067f,0.2154f,-0.9544f,  -0.0776f,0.9688f,0.2355f,  0.9753f,0.1227f,-0.1836f,  -108.0625f,-17.7329f,-38.8831f,  
/* M045 */   -0.1095f,0.3640f,-0.9249f,  -0.0161f,0.9298f,0.3678f,  0.9939f,0.0552f,-0.0959f,  -134.2751f,-17.4351f,-74.2389f,  
/* M046 */   -0.0346f,0.4921f,-0.8699f,  0.0255f,0.8705f,0.4914f,  0.9991f,-0.0052f,-0.0426f,  -153.0920f,-11.2276f,-106.3935f,  
/* M047 */   -0.0110f,0.6042f,-0.7967f,  0.0637f,0.7956f,0.6025f,  0.9979f,-0.0442f,-0.0472f,  -166.5366f,-2.5581f,-133.5927f,  
/* M048 */   -0.0286f,0.7088f,-0.7049f,  0.1228f,0.7023f,0.7012f,  0.9920f,-0.0666f,-0.1071f,  -179.9435f,9.1943f,-156.7404f,  
/* M049 */   -0.0825f,0.7938f,-0.6025f,  0.2138f,0.6046f,0.7673f,  0.9734f,-0.0655f,-0.2196f,  -195.5209f,23.2348f,-173.3639f,  
/* M050 */   -0.1587f,0.8531f,-0.4971f,  0.3221f,0.5206f,0.7907f,  0.9333f,-0.0347f,-0.3574f,  -210.3395f,37.2349f,-181.8643f,  
/* M051 */   -0.2594f,0.8909f,-0.3727f,  0.4217f,0.4517f,0.7862f,  0.8688f,0.0468f,-0.4929f,  -219.1992f,46.0272f,-187.5023f,  
/* M052 */   -0.3739f,0.9021f,-0.2153f,  0.5111f,0.3942f,0.7638f,  0.7739f,0.1755f,-0.6085f,  -223.7753f,51.4098f,-195.4500f,  
/* M053 */   -0.5109f,0.8590f,-0.0335f,  0.6110f,0.3903f,0.6888f,  0.6047f,0.3314f,-0.7242f,  -228.2794f,49.5014f,-199.2686f,  
/* M054 */   -0.6195f,0.7676f,0.1640f,  0.7021f,0.4485f,0.5530f,  0.3510f,0.4578f,-0.8169f,  -232.2141f,40.4223f,-196.3459f,  
/* M055 */   -0.6844f,0.6454f,0.3392f,  0.7225f,0.5381f,0.4341f,  0.0976f,0.5422f,-0.8346f,  -222.0395f,31.5906f,-199.8790f,  
/* M056 */   -0.7152f,0.5035f,0.4847f,  0.6873f,0.6326f,0.3570f,  -0.1269f,0.5885f,-0.7985f,  -202.1694f,31.0776f,-212.4113f,  
/* M057 */   -0.6872f,0.3936f,0.6105f,  0.6391f,0.7272f,0.2505f,  -0.3454f,0.5623f,-0.7513f,  -190.7921f,30.2525f,-218.8162f,  
/* M058 */   -0.6111f,0.3476f,0.7112f,  0.5654f,0.8204f,0.0848f,  -0.5540f,0.4539f,-0.6979f,  -186.6660f,23.0451f,-215.1410f,  
/* M059 */   -0.5164f,0.3302f,0.7901f,  0.4260f,0.8994f,-0.0974f,  -0.7429f,0.2863f,-0.6051f,  -179.9591f,15.2014f,-209.0685f,  
/* M060 */   -0.4179f,0.3320f,0.8457f,  0.2487f,0.9371f,-0.2450f,  -0.8738f,0.1079f,-0.4741f,  -173.8162f,9.1589f,-204.3818f,  
/* M061 */   -0.3256f,0.3419f,0.8815f,  0.0937f,0.9394f,-0.3297f,  -0.9408f,-0.0248f,-0.3379f,  -171.8756f,3.3379f,-202.2203f,  
/* M062 */   -0.2530f,0.3615f,0.8974f,  -0.0101f,0.9265f,-0.3761f,  -0.9674f,-0.1042f,-0.2308f,  -170.8685f,-4.8888f,-195.5655f,  
/* M063 */   -0.2030f,0.3910f,0.8977f,  -0.0860f,0.9062f,-0.4141f,  -0.9754f,-0.1612f,-0.1503f,  -165.4223f,-10.0378f,-181.8802f,  
/* M064 */   -0.1602f,0.4211f,0.8928f,  -0.1439f,0.8848f,-0.4432f,  -0.9765f,-0.1994f,-0.0811f,  -159.4668f,-7.1171f,-168.6071f,  
/* M065 */   -0.1065f,0.4446f,0.8894f,  -0.1934f,0.8681f,-0.4571f,  -0.9753f,-0.2207f,-0.0064f,  -157.7112f,0.3904f,-163.4162f,  
/* M066 */   -0.0221f,0.4550f,0.8902f,  -0.2417f,0.8616f,-0.4463f,  -0.9701f,-0.2250f,0.0909f,  -163.2283f,3.4436f,-171.0359f,  
/* M067 */   -0.0023f,0.3839f,0.9234f,  -0.2139f,0.9018f,-0.3755f,  -0.9769f,-0.1984f,0.0800f,  -163.2193f,2.2402f,-171.2233f,  
/* M068 */   0.0114f,0.2991f,0.9542f,  -0.1986f,0.9359f,-0.2910f,  -0.9800f,-0.1862f,0.0701f,  -163.3166f,2.5629f,-171.5497f,  
/* M069 */   0.0130f,0.2800f,0.9599f,  -0.2070f,0.9400f,-0.2713f,  -0.9783f,-0.1952f,0.0702f,  -163.4359f,3.6497f,-171.7979f,  
/* M070 */   0.0042f,0.3273f,0.9449f,  -0.2261f,0.9207f,-0.3180f,  -0.9741f,-0.2123f,0.0779f,  -163.4916f,4.3444f,-171.8491f,  
/* M071 */   -0.0151f,0.4152f,0.9096f,  -0.2611f,0.8765f,-0.4044f,  -0.9652f,-0.2436f,0.0952f,  -163.6407f,5.6455f,-172.0524f,  
/* M072 */   -0.0559f,0.5389f,0.8405f,  -0.3289f,0.7849f,-0.5251f,  -0.9427f,-0.3058f,0.1334f,  -164.3080f,9.2272f,-173.1497f,  
/* M073 */   0.1018f,0.5465f,0.8313f,  -0.3832f,0.7927f,-0.4741f,  -0.9180f,-0.2702f,0.2901f,  -176.7508f,10.2797f,-201.9254f,  
/* M074 */   0.3458f,0.5558f,0.7560f,  -0.4397f,0.8077f,-0.3927f,  -0.8289f,-0.1965f,0.5237f,  -203.7081f,5.7609f,-238.8240f,  
/* M075 */   0.5643f,0.5430f,0.6218f,  -0.4760f,0.8295f,-0.2923f,  -0.6745f,-0.1311f,0.7266f,  -238.7831f,-0.2954f,-271.3132f,  
/* M076 */   0.6847f,0.5145f,0.5163f,  -0.4897f,0.8493f,-0.1969f,  -0.5398f,-0.1180f,0.8335f,  -269.7678f,-4.4772f,-296.2686f,  
/* M077 */   0.7265f,0.4716f,0.4998f,  -0.4924f,0.8646f,-0.1000f,  -0.4793f,-0.1734f,0.8604f,  -294.5952f,-4.9583f,-323.2880f,  
/* M078 */   0.7370f,0.4151f,0.5333f,  -0.4935f,0.8697f,0.0050f,  -0.4618f,-0.2669f,0.8459f,  -318.7038f,1.2272f,-355.4137f,  
/* M079 */   0.7227f,0.3648f,0.5871f,  -0.5059f,0.8579f,0.0897f,  -0.4709f,-0.3618f,0.8046f,  -338.9601f,15.9274f,-387.4030f,  
/* M080 */   0.6890f,0.3478f,0.6358f,  -0.5375f,0.8337f,0.1265f,  -0.4861f,-0.4289f,0.7614f,  -351.0554f,30.9354f,-412.8420f,  
/* M081 */   0.6047f,0.3984f,0.6897f,  -0.6091f,0.7892f,0.0782f,  -0.5132f,-0.4674f,0.7199f,  -345.8831f,35.0096f,-427.5493f,  
/* M082 */   0.4774f,0.4778f,0.7374f,  -0.6886f,0.7247f,-0.0237f,  -0.5458f,-0.4965f,0.6750f,  -331.6284f,34.2571f,-429.8081f,  
/* M083 */   0.3696f,0.5393f,0.7567f,  -0.7393f,0.6640f,-0.1122f,  -0.5629f,-0.5179f,0.6441f,  -323.3027f,33.8554f,-425.2060f,  
/* M084 */   0.3377f,0.5649f,0.7529f,  -0.7613f,0.6343f,-0.1345f,  -0.5536f,-0.5278f,0.6442f,  -325.4881f,31.6167f,-427.3712f,  
/* M085 */   0.4449f,0.4119f,0.7952f,  -0.5992f,0.7968f,-0.0775f,  -0.6656f,-0.4420f,0.6014f,  -319.1530f,26.1114f,-424.9344f,  
/* M086 */   0.5191f,0.1641f,0.8388f,  -0.3174f,0.9482f,0.0109f,  -0.7936f,-0.2719f,0.5443f,  -311.6749f,15.3286f,-421.5428f,  
/* M087 */   0.5085f,0.1377f,0.8500f,  -0.2644f,0.9644f,0.0019f,  -0.8195f,-0.2257f,0.5268f,  -309.6541f,11.8075f,-420.2072f,  
/* M088 */   0.4873f,0.2308f,0.8422f,  -0.3194f,0.9447f,-0.0741f,  -0.8128f,-0.2329f,0.5340f,  -309.4468f,10.8090f,-420.1500f,  
/* M089 */   0.4373f,0.3918f,0.8095f,  -0.4077f,0.8887f,-0.2099f,  -0.8016f,-0.2382f,0.5484f,  -308.8468f,8.6402f,-419.8103f,  
/* M090 */   0.3593f,0.5513f,0.7530f,  -0.5295f,0.7848f,-0.3220f,  -0.7685f,-0.2831f,0.5739f,  -309.3443f,10.1623f,-420.1359f,  
/* M091 */   0.4887f,0.5455f,0.6809f,  -0.5487f,0.7989f,-0.2462f,  -0.6783f,-0.2533f,0.6898f,  -327.7371f,10.8381f,-442.9989f,  
/* M092 */   0.7190f,0.4981f,0.4847f,  -0.5229f,0.8471f,-0.0950f,  -0.4579f,-0.1851f,0.8695f,  -366.3264f,6.2745f,-471.0979f,  
/* M093 */   0.8960f,0.4023f,0.1878f,  -0.4194f,0.9058f,0.0605f,  -0.1458f,-0.1330f,0.9803f,  -415.6826f,2.3424f,-488.9898f,  
/* M094 */   0.9536f,0.2872f,-0.0904f,  -0.2700f,0.9486f,0.1650f,  0.1331f,-0.1330f,0.9821f,  -460.7329f,1.7498f,-495.3175f,  
/* M095 */   0.9477f,0.1449f,-0.2844f,  -0.0799f,0.9704f,0.2281f,  0.3090f,-0.1935f,0.9312f,  -502.4041f,6.5625f,-500.2540f,  
/* M096 */   0.9053f,-0.0076f,-0.4248f,  0.1318f,0.9555f,0.2639f,  0.4038f,-0.2949f,0.8660f,  -542.0219f,20.1090f,-504.5788f,  
/* M097 */   0.8533f,-0.0930f,-0.5131f,  0.2762f,0.9152f,0.2935f,  0.4423f,-0.3921f,0.8066f,  -570.3518f,32.4684f,-508.8748f,  
/* M098 */   0.8317f,-0.0937f,-0.5472f,  0.3316f,0.8744f,0.3543f,  0.4453f,-0.4762f,0.7583f,  -587.9702f,39.6423f,-516.4596f,  
/* M099 */   0.8370f,-0.0581f,-0.5442f,  0.3443f,0.8288f,0.4410f,  0.4254f,-0.5565f,0.7137f,  -602.4061f,46.4973f,-527.8678f,  
/* M100 */   0.8484f,-0.0145f,-0.5292f,  0.3379f,0.7843f,0.5203f,  0.4075f,-0.6202f,0.6703f,  -615.9818f,50.8799f,-540.5222f,  
/* M101 */   0.8455f,0.0149f,-0.5337f,  0.3406f,0.7547f,0.5607f,  0.4112f,-0.6559f,0.6331f,  -629.9520f,54.1753f,-551.6494f,  
/* M102 */   0.8096f,0.0266f,-0.5864f,  0.3558f,0.7723f,0.5263f,  0.4668f,-0.6347f,0.6158f,  -642.5853f,52.0533f,-562.8914f,  
/* M103 */   0.7508f,0.0257f,-0.6601f,  0.3638f,0.8180f,0.4456f,  0.5514f,-0.5747f,0.6048f,  -651.0405f,46.8850f,-572.6252f,  
/* M104 */   0.7041f,0.0069f,-0.7101f,  0.3838f,0.8376f,0.3887f,  0.5975f,-0.5462f,0.5871f,  -660.4133f,44.0099f,-574.5345f,  
/* M105 */   0.7152f,-0.0428f,-0.6976f,  0.3577f,0.8800f,0.3126f,  0.6005f,-0.4731f,0.6447f,  -660.8358f,38.7730f,-579.4708f,  
/* M106 */   0.7007f,-0.1076f,-0.7053f,  0.3339f,0.9231f,0.1909f,  0.6305f,-0.3692f,0.6827f,  -662.7720f,31.3397f,-581.4286f,  
/* M107 */   0.7148f,-0.1197f,-0.6890f,  0.3140f,0.9353f,0.1633f,  0.6249f,-0.3331f,0.7061f,  -662.4454f,28.5110f,-583.4203f,  
/* M108 */   0.7153f,-0.1154f,-0.6892f,  0.3094f,0.9366f,0.1643f,  0.6266f,-0.3308f,0.7057f,  -662.5848f,28.0920f,-583.3799f,  
/* M109 */   0.7164f,-0.1045f,-0.6898f,  0.2976f,0.9400f,0.1668f,  0.6310f,-0.3248f,0.7046f,  -662.9344f,27.0078f,-583.2778f,  
/* M110 */   0.7178f,-0.0895f,-0.6904f,  0.2814f,0.9444f,0.1701f,  0.6368f,-0.3164f,0.7031f,  -663.3903f,25.5181f,-583.1426f,  
/* M111 */   0.7190f,-0.0732f,-0.6911f,  0.2637f,0.9488f,0.1739f,  0.6430f,-0.3072f,0.7015f,  -663.8574f,23.8856f,-583.0017f,  
/* M112 */   0.7199f,-0.0581f,-0.6917f,  0.2473f,0.9526f,0.1773f,  0.6486f,-0.2987f,0.7001f,  -664.2589f,22.3793f,-582.8779f,  
/* M113 */   0.7203f,-0.0471f,-0.6920f,  0.2353f,0.9551f,0.1798f,  0.6525f,-0.2924f,0.6991f,  -664.5361f,21.2732f,-582.7908f,  
/* M114 */   0.7205f,-0.0429f,-0.6922f,  0.2306f,0.9561f,0.1808f,  0.6540f,-0.2899f,0.6987f,  -664.6397f,20.8433f,-582.7579f,  
/* M115 */   0.7205f,-0.0450f,-0.6920f,  0.2290f,0.9574f,0.1761f,  0.6546f,-0.2853f,0.7001f,  -664.6765f,20.6330f,-582.8513f,  
/* M116 */   0.7206f,-0.0501f,-0.6916f,  0.2250f,0.9603f,0.1649f,  0.6559f,-0.2744f,0.7032f,  -664.7625f,20.1297f,-583.0698f,  
/* M117 */   0.7207f,-0.0561f,-0.6910f,  0.2203f,0.9636f,0.1515f,  0.6574f,-0.2614f,0.7068f,  -664.8626f,19.5251f,-583.3227f,  
/* M118 */   0.7208f,-0.0612f,-0.6905f,  0.2163f,0.9662f,0.1402f,  0.6586f,-0.2504f,0.7097f,  -664.9441f,19.0156f,-583.5281f,  
/* M119 */   0.7208f,-0.0633f,-0.6902f,  0.2146f,0.9673f,0.1354f,  0.6590f,-0.2457f,0.7108f,  -664.9777f,18.8011f,-583.6124f,  
/* M120 */   0.7208f,-0.0649f,-0.6901f,  0.2151f,0.9674f,0.1336f,  0.6589f,-0.2447f,0.7113f,  -664.9689f,18.8219f,-583.6477f,  
/* M121 */   0.7207f,-0.0680f,-0.6899f,  0.2159f,0.9677f,0.1301f,  0.6587f,-0.2427f,0.7121f,  -664.9525f,18.8603f,-583.7133f,  
/* M122 */   0.7207f,-0.0697f,-0.6897f,  0.2164f,0.9678f,0.1283f,  0.6586f,-0.2417f,0.7126f,  -664.9435f,18.8808f,-583.7486f,  
/* M123 */   0.7206f,-0.0717f,-0.6896f,  0.2148f,0.9688f,0.1237f,  0.6592f,-0.2373f,0.7136f,  -664.9774f,18.6766f,-583.8113f,  
/* M124 */   0.7205f,-0.0769f,-0.6892f,  0.2108f,0.9711f,0.1119f,  0.6607f,-0.2259f,0.7159f,  -665.0630f,18.1483f,-583.9687f,  
/* M125 */   0.7203f,-0.0840f,-0.6885f,  0.2052f,0.9740f,0.0958f,  0.6626f,-0.2103f,0.7188f,  -665.1768f,17.4223f,-584.1735f,  
/* M126 */   0.7202f,-0.0917f,-0.6877f,  0.1991f,0.9769f,0.0782f,  0.6646f,-0.1932f,0.7218f,  -665.2960f,16.6269f,-584.3829f,  
/* M127 */   0.7201f,-0.0988f,-0.6868f,  0.1935f,0.9791f,0.0620f,  0.6664f,-0.1775f,0.7242f,  -665.4011f,15.8931f,-584.5625f,  
/* M128 */   0.7201f,-0.1040f,-0.6861f,  0.1893f,0.9806f,0.0501f,  0.6676f,-0.1660f,0.7258f,  -665.4755f,15.3542f,-584.6862f,  
/* M129 */   0.7201f,-0.1060f,-0.6858f,  0.1877f,0.9812f,0.0455f,  0.6680f,-0.1615f,0.7264f,  -665.5037f,15.1447f,-584.7323f,  
/* M130 */   0.7201f,-0.1044f,-0.6860f,  0.1886f,0.9809f,0.0487f,  0.6678f,-0.1644f,0.7260f,  -665.4879f,15.2666f,-584.7014f,  
/* M131 */   0.7202f,-0.1005f,-0.6865f,  0.1907f,0.9800f,0.0566f,  0.6670f,-0.1717f,0.7250f,  -665.4481f,15.5706f,-584.6222f,  
/* M132 */   0.7203f,-0.0954f,-0.6870f,  0.1935f,0.9788f,0.0670f,  0.6661f,-0.1812f,0.7235f,  -665.3953f,15.9648f,-584.5157f,  
/* M133 */   0.7205f,-0.0903f,-0.6876f,  0.1963f,0.9775f,0.0773f,  0.6651f,-0.1907f,0.7220f,  -665.3414f,16.3576f,-584.4049f,  
/* M134 */   0.7206f,-0.0864f,-0.6879f,  0.1984f,0.9764f,0.0853f,  0.6643f,-0.1979f,0.7208f,  -665.2992f,16.6590f,-584.3170f,  
/* M135 */   0.7207f,-0.0848f,-0.6881f,  0.1993f,0.9759f,0.0884f,  0.6640f,-0.2009f,0.7202f,  -665.2822f,16.7793f,-584.2811f,  
/* M136 */   0.7207f,-0.0839f,-0.6882f,  0.1996f,0.9757f,0.0900f,  0.6639f,-0.2023f,0.7199f,  -665.2759f,16.8317f,-584.2568f,  
/* M137 */   0.7207f,-0.0815f,-0.6885f,  0.2006f,0.9751f,0.0946f,  0.6636f,-0.2062f,0.7191f,  -665.2585f,16.9774f,-584.1888f,  
/* M138 */   0.7206f,-0.0777f,-0.6889f,  0.2020f,0.9741f,0.1014f,  0.6632f,-0.2122f,0.7177f,  -665.2318f,17.1989f,-584.0839f,  
/* M139 */   0.7206f,-0.0729f,-0.6895f,  0.2038f,0.9728f,0.1101f,  0.6627f,-0.2198f,0.7159f,  -665.1974f,17.4785f,-583.9485f,  
/* M140 */   0.7206f,-0.0674f,-0.6900f,  0.2058f,0.9712f,0.1201f,  0.6621f,-0.2286f,0.7138f,  -665.1572f,17.7987f,-583.7898f,  
/* M141 */   0.7206f,-0.0615f,-0.6906f,  0.2081f,0.9693f,0.1308f,  0.6613f,-0.2380f,0.7113f,  -665.1132f,18.1422f,-583.6150f,  
/* M142 */   0.7207f,-0.0554f,-0.6911f,  0.2103f,0.9673f,0.1418f,  0.6606f,-0.2476f,0.7088f,  -665.0673f,18.4918f,-583.4320f,  
/* M143 */   0.7207f,-0.0495f,-0.6915f,  0.2125f,0.9652f,0.1525f,  0.6598f,-0.2569f,0.7061f,  -665.0219f,18.8311f,-583.2498f,  
/* M144 */   0.7208f,-0.0439f,-0.6918f,  0.2146f,0.9631f,0.1624f,  0.6591f,-0.2655f,0.7036f,  -664.9789f,19.1437f,-583.0774f,  
/* M145 */   0.7208f,-0.0391f,-0.6920f,  0.2164f,0.9612f,0.1710f,  0.6585f,-0.2730f,0.7013f,  -664.9412f,19.4138f,-582.9248f,  
/* M146 */   0.7209f,-0.0353f,-0.6922f,  0.2177f,0.9597f,0.1778f,  0.6580f,-0.2789f,0.6995f,  -664.9110f,19.6259f,-582.8030f,  
/* M147 */   0.7209f,-0.0329f,-0.6923f,  0.2187f,0.9586f,0.1822f,  0.6576f,-0.2827f,0.6983f,  -664.8911f,19.7646f,-582.7223f,  
/* M148 */   0.7209f,-0.0320f,-0.6923f,  0.2190f,0.9583f,0.1838f,  0.6575f,-0.2841f,0.6978f,  -664.8840f,19.8142f,-582.6930f,  
/* M149 */   0.7181f,-0.0346f,-0.6951f,  0.2190f,0.9593f,0.1785f,  0.6606f,-0.2804f,0.6964f,  -665.0701f,19.5584f,-582.4529f,  
/* M150 */   0.7133f,-0.0382f,-0.6998f,  0.2203f,0.9601f,0.1721f,  0.6654f,-0.2769f,0.6933f,  -665.3553f,19.3601f,-581.9903f,  
/* M151 */   0.7096f,-0.0394f,-0.7035f,  0.2241f,0.9592f,0.1723f,  0.6680f,-0.2799f,0.6895f,  -665.5045f,19.6629f,-581.5518f,  
/* M152 */   0.7080f,-0.0376f,-0.7052f,  0.2300f,0.9564f,0.1799f,  0.6677f,-0.2896f,0.6858f,  -665.4692f,20.4769f,-581.2254f,  
/* M153 */   0.7079f,-0.0340f,-0.7055f,  0.2368f,0.9525f,0.1917f,  0.6654f,-0.3027f,0.6823f,  -665.3110f,21.5543f,-580.9892f,  
/* M154 */   0.7104f,-0.0279f,-0.7032f,  0.2441f,0.9469f,0.2090f,  0.6601f,-0.3202f,0.6795f,  -664.9647f,22.9448f,-580.9242f,  
/* M155 */   0.7161f,-0.0191f,-0.6978f,  0.2514f,0.9396f,0.2322f,  0.6512f,-0.3417f,0.6776f,  -664.3973f,24.6232f,-581.0741f,  
/* M156 */   0.7252f,-0.0079f,-0.6885f,  0.2575f,0.9305f,0.2605f,  0.6386f,-0.3662f,0.6768f,  -663.6019f,26.5065f,-581.4609f,  
/* M157 */   0.7207f,-0.0045f,-0.6932f,  0.2646f,0.9261f,0.2690f,  0.6407f,-0.3773f,0.6687f,  -663.7021f,27.4135f,-580.6646f,  
/* M158 */   0.7175f,0.0003f,-0.6965f,  0.2722f,0.9203f,0.2808f,  0.6411f,-0.3911f,0.6603f,  -663.6917f,28.5237f,-579.9063f,  
/* M159 */   0.7212f,0.0094f,-0.6927f,  0.2834f,0.9084f,0.3074f,  0.6321f,-0.4180f,0.6525f,  -663.0826f,30.6946f,-579.5070f,  
/* M160 */   0.7124f,0.0119f,-0.7016f,  0.3019f,0.8974f,0.3217f,  0.6335f,-0.4411f,0.6358f,  -663.0621f,32.7283f,-577.8655f,  
/* M161 */   0.7012f,0.0139f,-0.7128f,  0.3238f,0.8846f,0.3357f,  0.6351f,-0.4662f,0.6158f,  -663.0224f,34.9685f,-575.8682f,  
/* M162 */   0.6972f,0.0214f,-0.7165f,  0.3442f,0.8668f,0.3608f,  0.6288f,-0.4982f,0.5970f,  -662.4784f,37.6784f,-574.2686f,  
/* M163 */   0.7068f,0.0370f,-0.7065f,  0.3563f,0.8441f,0.4006f,  0.6112f,-0.5349f,0.5834f,  -661.2907f,40.5874f,-573.6375f,  
/* M164 */   0.7085f,0.0688f,-0.7024f,  0.3777f,0.8037f,0.4597f,  0.5961f,-0.5910f,0.5434f,  -660.1603f,44.8504f,-570.6284f,  
/* M165 */   0.6911f,0.1161f,-0.7134f,  0.4188f,0.7402f,0.5261f,  0.5891f,-0.6623f,0.4629f,  -659.2946f,50.1418f,-563.6520f,  
/* M166 */   0.6726f,0.1626f,-0.7220f,  0.4585f,0.6742f,0.5790f,  0.5809f,-0.7204f,0.3789f,  -658.2824f,54.3108f,-556.3513f,  
/* M167 */   0.6696f,0.1880f,-0.7185f,  0.4769f,0.6328f,0.6100f,  0.5694f,-0.7512f,0.3341f,  -657.3040f,56.5306f,-552.7140f,  
/* M168 */   0.6039f,0.2392f,-0.7603f,  0.5657f,0.5433f,0.6203f,  0.5615f,-0.8047f,0.1927f,  -656.2458f,60.8026f,-540.1986f,  
/* M169 */   0.5108f,0.3643f,-0.7786f,  0.7198f,0.3139f,0.6191f,  0.4700f,-0.8768f,-0.1019f,  -648.3080f,65.8502f,-515.7511f,  
/* M170 */   0.5006f,0.4584f,-0.7344f,  0.7819f,0.1248f,0.6108f,  0.3716f,-0.8800f,-0.2959f,  -640.7556f,65.0766f,-501.0305f,  
/* M171 */   0.6526f,0.3971f,-0.6453f,  0.6967f,0.0201f,0.7170f,  0.2978f,-0.9175f,-0.2636f,  -635.7935f,74.4666f,-504.0896f,  
/* M172 */   0.9003f,0.2441f,-0.3603f,  0.4006f,-0.1413f,0.9053f,  0.1700f,-0.9594f,-0.2250f,  -614.8129f,90.5803f,-522.4639f,  
/* M173 */   0.9808f,0.1549f,-0.1185f,  0.1515f,-0.2221f,0.9632f,  0.1228f,-0.9626f,-0.2413f,  -594.0243f,99.2036f,-526.4217f,  
/* M174 */   0.9592f,0.2673f,-0.0926f,  0.1700f,-0.2830f,0.9439f,  0.2261f,-0.9211f,-0.3169f,  -595.3563f,94.1403f,-512.1185f,  
/* M175 */   0.8642f,0.4830f,-0.1412f,  0.3211f,-0.3131f,0.8938f,  0.3875f,-0.8178f,-0.4256f,  -604.7968f,78.9216f,-491.8346f,  
/* M176 */   0.7042f,0.6867f,-0.1806f,  0.4598f,-0.2472f,0.8529f,  0.5411f,-0.6836f,-0.4898f,  -608.9827f,59.1023f,-472.9109f,  
/* M177 */   0.4736f,0.8555f,-0.2093f,  0.5185f,-0.0788f,0.8514f,  0.7119f,-0.5118f,-0.4809f,  -604.5514f,38.0014f,-456.9609f,  
/* M178 */   0.1798f,0.9433f,-0.2791f,  0.4963f,0.1580f,0.8536f,  0.8493f,-0.2920f,-0.4397f,  -590.9988f,16.8840f,-438.9153f,  
/* M179 */   -0.0247f,0.9102f,-0.4134f,  0.4090f,0.3865f,0.8266f,  0.9122f,-0.1486f,-0.3818f,  -573.9026f,0.5177f,-418.0906f,  
/* M180 */   -0.0935f,0.7942f,-0.6004f,  0.3065f,0.5967f,0.7416f,  0.9473f,-0.1147f,-0.2992f,  -557.6450f,-12.4751f,-391.3342f,  
/* M181 */   -0.0819f,0.6082f,-0.7895f,  0.1965f,0.7865f,0.5855f,  0.9771f,-0.1072f,-0.1839f,  -541.5839f,-19.8093f,-356.7050f,  
/* M182 */   -0.0010f,0.3817f,-0.9243f,  0.1052f,0.9192f,0.3794f,  0.9944f,-0.0969f,-0.0410f,  -529.7057f,-17.5334f,-318.0206f,  
/* M183 */   0.1209f,0.1648f,-0.9789f,  0.0467f,0.9841f,0.1715f,  0.9916f,-0.0665f,0.1113f,  -524.1335f,-7.2459f,-282.3910f,  
/* M184 */   0.2762f,0.0173f,-0.9609f,  0.0086f,0.9998f,0.0205f,  0.9611f,-0.0140f,0.2760f,  -524.3322f,2.9550f,-258.3576f,  
/* M185 */   0.4592f,-0.0176f,-0.8882f,  -0.0248f,0.9992f,-0.0326f,  0.8880f,0.0370f,0.4584f,  -526.0629f,4.5488f,-252.7848f,  
/* M186 */   0.6276f,0.0297f,-0.7779f,  -0.0684f,0.9975f,-0.0171f,  0.7755f,0.0640f,0.6281f,  -523.0807f,-0.3420f,-260.4154f,  
/* M187 */   0.7333f,0.0964f,-0.6731f,  -0.1191f,0.9928f,0.0124f,  0.6694f,0.0710f,0.7395f,  -514.9900f,-4.9611f,-268.6334f,  
/* M188 */   0.7858f,0.1329f,-0.6041f,  -0.1489f,0.9886f,0.0238f,  0.6003f,0.0712f,0.7966f,  -508.3409f,-5.9228f,-268.2155f,  
/* M189 */   0.7897f,0.1098f,-0.6036f,  -0.1245f,0.9921f,0.0176f,  0.6007f,0.0612f,0.7971f,  -508.6051f,-4.1979f,-268.2594f,  
/* M190 */   0.7963f,0.0589f,-0.6020f,  -0.0707f,0.9975f,0.0041f,  0.6007f,0.0393f,0.7985f,  -509.0362f,-0.3849f,-268.3939f,  
/* M191 */   0.8002f,0.0077f,-0.5997f,  -0.0165f,0.9998f,-0.0093f,  0.5995f,0.0174f,0.8002f,  -509.2598f,3.4438f,-268.5803f,  
/* M192 */   0.8010f,-0.0157f,-0.5985f,  0.0081f,0.9998f,-0.0153f,  0.5986f,0.0075f,0.8010f,  -509.2925f,5.1860f,-268.6820f,  
/* M193 */   0.8055f,-0.0304f,-0.5918f,  0.0272f,0.9995f,-0.0144f,  0.5920f,-0.0045f,0.8060f,  -509.1697f,6.6209f,-269.3028f,  
/* M194 */   0.8130f,-0.0580f,-0.5794f,  0.0625f,0.9980f,-0.0122f,  0.5789f,-0.0263f,0.8150f,  -508.8560f,9.2796f,-270.4493f,  
/* M195 */   0.8165f,-0.0730f,-0.5727f,  0.0816f,0.9966f,-0.0108f,  0.5715f,-0.0379f,0.8197f,  -508.6412f,10.7066f,-271.0628f,  
/* M196 */   0.8135f,-0.0885f,-0.5748f,  0.1029f,0.9947f,-0.0075f,  0.5724f,-0.0530f,0.8183f,  -508.5907f,12.7126f,-270.8459f,  
/* M197 */   0.8070f,-0.1172f,-0.5788f,  0.1425f,0.9898f,-0.0017f,  0.5731f,-0.0811f,0.8155f,  -508.3813f,16.4310f,-270.4253f,  
/* M198 */   0.8030f,-0.1324f,-0.5810f,  0.1637f,0.9865f,0.0014f,  0.5730f,-0.0963f,0.8139f,  -508.2064f,18.4279f,-270.1894f,  
/* M199 */   0.8027f,-0.1411f,-0.5795f,  0.1808f,0.9834f,0.0110f,  0.5683f,-0.1137f,0.8149f,  -507.8976f,20.1998f,-270.3866f,  
/* M200 */   0.8017f,-0.1572f,-0.5767f,  0.2124f,0.9768f,0.0290f,  0.5588f,-0.1457f,0.8164f,  -507.2405f,23.4796f,-270.7068f,  
/* M201 */   0.8009f,-0.1659f,-0.5754f,  0.2292f,0.9726f,0.0387f,  0.5532f,-0.1629f,0.8170f,  -506.8422f,25.2385f,-270.8543f,  
/* M202 */   0.8007f,-0.1667f,-0.5754f,  0.2348f,0.9710f,0.0455f,  0.5511f,-0.1715f,0.8166f,  -506.6982f,25.9161f,-270.8450f,  
/* M203 */   0.8003f,-0.1684f,-0.5755f,  0.2470f,0.9671f,0.0604f,  0.5464f,-0.1904f,0.8156f,  -506.3679f,27.4035f,-270.8079f,  
/* M204 */   0.7998f,-0.1702f,-0.5757f,  0.2591f,0.9629f,0.0752f,  0.5415f,-0.2093f,0.8142f,  -506.0186f,28.8859f,-270.7480f,  
/* M205 */   0.7996f,-0.1710f,-0.5757f,  0.2646f,0.9609f,0.0820f,  0.5392f,-0.2178f,0.8135f,  -505.8538f,29.5578f,-270.7133f,  
/* M206 */   0.7999f,-0.1648f,-0.5771f,  0.2652f,0.9597f,0.0934f,  0.5384f,-0.2278f,0.8113f,  -505.8188f,29.9176f,-270.5066f,  
/* M207 */   0.8005f,-0.1533f,-0.5795f,  0.2663f,0.9571f,0.1147f,  0.5370f,-0.2461f,0.8069f,  -505.7536f,30.5792f,-270.1112f,  
/* M208 */   0.8008f,-0.1470f,-0.5806f,  0.2668f,0.9555f,0.1261f,  0.5362f,-0.2559f,0.8043f,  -505.7183f,30.9317f,-269.8924f,  
/* M209 */   0.8008f,-0.1470f,-0.5806f,  0.2668f,0.9555f,0.1260f,  0.5363f,-0.2558f,0.8044f,  -505.7192f,30.9277f,-269.8932f,  
/* M210 */   0.8008f,-0.1471f,-0.5806f,  0.2667f,0.9555f,0.1259f,  0.5363f,-0.2557f,0.8044f,  -505.7219f,30.9158f,-269.8956f,  
/* M211 */   0.8008f,-0.1471f,-0.5806f,  0.2666f,0.9556f,0.1256f,  0.5364f,-0.2554f,0.8044f,  -505.7261f,30.8966f,-269.8996f,  
/* M212 */   0.8008f,-0.1472f,-0.5806f,  0.2664f,0.9557f,0.1252f,  0.5364f,-0.2550f,0.8045f,  -505.7320f,30.8704f,-269.9049f,  
/* M213 */   0.8008f,-0.1472f,-0.5806f,  0.2662f,0.9558f,0.1248f,  0.5365f,-0.2545f,0.8046f,  -505.7392f,30.8376f,-269.9115f,  
/* M214 */   0.8008f,-0.1473f,-0.5805f,  0.2659f,0.9560f,0.1242f,  0.5367f,-0.2539f,0.8047f,  -505.7478f,30.7987f,-269.9193f,  
/* M215 */   0.8008f,-0.1474f,-0.5805f,  0.2656f,0.9561f,0.1236f,  0.5368f,-0.2532f,0.8048f,  -505.7577f,30.7541f,-269.9283f,  
/* M216 */   0.8008f,-0.1475f,-0.5805f,  0.2652f,0.9563f,0.1229f,  0.5370f,-0.2524f,0.8050f,  -505.7687f,30.7042f,-269.9384f,  
/* M217 */   0.8008f,-0.1476f,-0.5804f,  0.2649f,0.9565f,0.1222f,  0.5371f,-0.2516f,0.8051f,  -505.7808f,30.6495f,-269.9493f,  
/* M218 */   0.8008f,-0.1477f,-0.5804f,  0.2644f,0.9567f,0.1214f,  0.5373f,-0.2507f,0.8053f,  -505.7938f,30.5903f,-269.9611f,  
/* M219 */   0.8009f,-0.1479f,-0.5803f,  0.2640f,0.9570f,0.1205f,  0.5375f,-0.2497f,0.8054f,  -505.8077f,30.5270f,-269.9736f,  
/* M220 */   0.8009f,-0.1480f,-0.5803f,  0.2635f,0.9572f,0.1196f,  0.5377f,-0.2487f,0.8056f,  -505.8224f,30.4602f,-269.9868f,  
/* M221 */   0.8009f,-0.1481f,-0.5802f,  0.2630f,0.9575f,0.1186f,  0.5380f,-0.2476f,0.8058f,  -505.8377f,30.3901f,-270.0005f,  
/* M222 */   0.8009f,-0.1483f,-0.5801f,  0.2625f,0.9577f,0.1176f,  0.5382f,-0.2465f,0.8060f,  -505.8535f,30.3172f,-270.0148f,  
/* M223 */   0.8009f,-0.1484f,-0.5801f,  0.2620f,0.9580f,0.1166f,  0.5384f,-0.2453f,0.8062f,  -505.8699f,30.2420f,-270.0293f,  
/* M224 */   0.8009f,-0.1486f,-0.5800f,  0.2614f,0.9583f,0.1155f,  0.5387f,-0.2442f,0.8064f,  -505.8866f,30.1650f,-270.0442f,  
/* M225 */   0.8010f,-0.1487f,-0.5800f,  0.2609f,0.9586f,0.1144f,  0.5389f,-0.2430f,0.8066f,  -505.9035f,30.0863f,-270.0593f,  
/* M226 */   0.8010f,-0.1489f,-0.5799f,  0.2603f,0.9588f,0.1133f,  0.5391f,-0.2417f,0.8068f,  -505.9207f,30.0066f,-270.0744f,  
/* M227 */   0.8010f,-0.1491f,-0.5798f,  0.2598f,0.9591f,0.1122f,  0.5394f,-0.2405f,0.8070f,  -505.9380f,29.9262f,-270.0896f,  
/* M228 */   0.8010f,-0.1492f,-0.5798f,  0.2592f,0.9594f,0.1111f,  0.5396f,-0.2393f,0.8072f,  -505.9553f,29.8456f,-270.1048f,  
/* M229 */   0.8010f,-0.1494f,-0.5797f,  0.2586f,0.9597f,0.1100f,  0.5399f,-0.2381f,0.8074f,  -505.9724f,29.7652f,-270.1198f,  
/* M230 */   0.8010f,-0.1496f,-0.5796f,  0.2581f,0.9600f,0.1089f,  0.5401f,-0.2368f,0.8076f,  -505.9894f,29.6854f,-270.1346f,  
/* M231 */   0.8011f,-0.1497f,-0.5796f,  0.2575f,0.9602f,0.1079f,  0.5404f,-0.2356f,0.8078f,  -506.0061f,29.6066f,-270.1491f,  
/* M232 */   0.8011f,-0.1499f,-0.5795f,  0.2570f,0.9605f,0.1068f,  0.5406f,-0.2345f,0.8079f,  -506.0224f,29.5293f,-270.1632f,  
/* M233 */   0.8011f,-0.1500f,-0.5794f,  0.2564f,0.9608f,0.1058f,  0.5408f,-0.2333f,0.8081f,  -506.0384f,29.4539f,-270.1769f,  
/* M234 */   0.8011f,-0.1502f,-0.5794f,  0.2559f,0.9610f,0.1047f,  0.5410f,-0.2322f,0.8083f,  -506.0537f,29.3808f,-270.1902f,  
/* M235 */   0.8011f,-0.1503f,-0.5793f,  0.2554f,0.9612f,0.1038f,  0.5413f,-0.2311f,0.8085f,  -506.0685f,29.3104f,-270.2029f,  
/* M236 */   0.8011f,-0.1505f,-0.5793f,  0.2549f,0.9615f,0.1029f,  0.5415f,-0.2301f,0.8086f,  -506.0825f,29.2432f,-270.2149f,  
/* M237 */   0.8012f,-0.1506f,-0.5792f,  0.2545f,0.9617f,0.1020f,  0.5417f,-0.2291f,0.8088f,  -506.0958f,29.1795f,-270.2262f,  
/* M238 */   0.8012f,-0.1507f,-0.5792f,  0.2541f,0.9619f,0.1012f,  0.5418f,-0.2282f,0.8089f,  -506.1082f,29.1200f,-270.2368f,  
/* M239 */   0.8012f,-0.1508f,-0.5791f,  0.2537f,0.9621f,0.1004f,  0.5420f,-0.2274f,0.8090f,  -506.1196f,29.0648f,-270.2464f,  
/* M240 */   0.8012f,-0.1509f,-0.5791f,  0.2533f,0.9622f,0.0997f,  0.5421f,-0.2266f,0.8092f,  -506.1301f,29.0145f,-270.2552f,  
/* M241 */   0.8012f,-0.1510f,-0.5790f,  0.2530f,0.9624f,0.0991f,  0.5423f,-0.2259f,0.8093f,  -506.1393f,28.9696f,-270.2631f,  
/* M242 */   0.8012f,-0.1511f,-0.5790f,  0.2527f,0.9625f,0.0986f,  0.5424f,-0.2253f,0.8094f,  -506.1474f,28.9304f,-270.2700f,  
/* M243 */   0.8012f,-0.1511f,-0.5790f,  0.2525f,0.9626f,0.0981f,  0.5425f,-0.2248f,0.8094f,  -506.1542f,28.8974f,-270.2757f,  
/* M244 */   0.8012f,-0.1512f,-0.5789f,  0.2523f,0.9627f,0.0978f,  0.5426f,-0.2244f,0.8095f,  -506.1597f,28.8709f,-270.2802f,  
/* M245 */   0.8012f,-0.1512f,-0.5789f,  0.2522f,0.9628f,0.0975f,  0.5426f,-0.2241f,0.8095f,  -506.1636f,28.8515f,-270.2836f,  
/* M246 */   0.8012f,-0.1513f,-0.5789f,  0.2521f,0.9628f,0.0973f,  0.5427f,-0.2239f,0.8096f,  -506.1661f,28.8396f,-270.2856f,  
/* M247 */   0.8012f,-0.1513f,-0.5789f,  0.2520f,0.9628f,0.0973f,  0.5427f,-0.2238f,0.8096f,  -506.1670f,28.8355f,-270.2863f,  
/* M248 */   0.8012f,-0.1513f,-0.5789f,  0.2520f,0.9628f,0.0973f,  0.5427f,-0.2238f,0.8096f,  -506.1670f,28.8355f,-270.2863f,  

_NULL_ }; /* End of object02_pData */


/* MESH ANIMATION 5 */

#define object01_NumFrames  243

const float object01_pData[] = {
/* M005 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  -0.0000f,-0.0000f,0.0000f,  
/* M006 */   1.0000f,0.0000f,0.0000f,  -0.0000f,1.0000f,0.0001f,  -0.0000f,-0.0001f,1.0000f,  0.0003f,-0.0029f,-0.0011f,  
/* M007 */   1.0000f,0.0002f,0.0000f,  -0.0002f,1.0000f,0.0004f,  -0.0000f,-0.0004f,1.0000f,  0.0013f,-0.0110f,-0.0043f,  
/* M008 */   1.0000f,0.0004f,0.0001f,  -0.0004f,1.0000f,0.0008f,  -0.0001f,-0.0008f,1.0000f,  0.0028f,-0.0236f,-0.0091f,  
/* M009 */   1.0000f,0.0006f,0.0001f,  -0.0006f,1.0000f,0.0013f,  -0.0001f,-0.0013f,1.0000f,  0.0047f,-0.0398f,-0.0154f,  
/* M010 */   1.0000f,0.0009f,0.0001f,  -0.0009f,1.0000f,0.0019f,  -0.0001f,-0.0019f,1.0000f,  0.0070f,-0.0588f,-0.0228f,  
/* M011 */   1.0000f,0.0013f,0.0002f,  -0.0013f,1.0000f,0.0026f,  -0.0002f,-0.0026f,1.0000f,  0.0095f,-0.0798f,-0.0310f,  
/* M012 */   1.0000f,0.0016f,0.0002f,  -0.0016f,1.0000f,0.0033f,  -0.0002f,-0.0033f,1.0000f,  0.0121f,-0.1020f,-0.0397f,  
/* M013 */   1.0000f,0.0020f,0.0003f,  -0.0020f,1.0000f,0.0041f,  -0.0003f,-0.0041f,1.0000f,  0.0148f,-0.1246f,-0.0485f,  
/* M014 */   1.0000f,0.0023f,0.0003f,  -0.0023f,1.0000f,0.0048f,  -0.0003f,-0.0048f,1.0000f,  0.0175f,-0.1468f,-0.0572f,  
/* M015 */   1.0000f,0.0026f,0.0004f,  -0.0026f,1.0000f,0.0055f,  -0.0004f,-0.0055f,1.0000f,  0.0200f,-0.1678f,-0.0655f,  
/* M016 */   1.0000f,0.0029f,0.0004f,  -0.0029f,1.0000f,0.0061f,  -0.0004f,-0.0061f,1.0000f,  0.0223f,-0.1868f,-0.0730f,  
/* M017 */   1.0000f,0.0032f,0.0005f,  -0.0032f,1.0000f,0.0067f,  -0.0004f,-0.0067f,1.0000f,  0.0243f,-0.2029f,-0.0793f,  
/* M018 */   1.0000f,0.0034f,0.0005f,  -0.0034f,1.0000f,0.0071f,  -0.0005f,-0.0071f,1.0000f,  0.0258f,-0.2154f,-0.0843f,  
/* M019 */   1.0000f,0.0035f,0.0005f,  -0.0035f,1.0000f,0.0073f,  -0.0005f,-0.0073f,1.0000f,  0.0268f,-0.2235f,-0.0875f,  
/* M020 */   1.0000f,0.0036f,0.0005f,  -0.0036f,1.0000f,0.0074f,  -0.0005f,-0.0074f,1.0000f,  0.0271f,-0.2264f,-0.0887f,  
/* M021 */   0.9999f,0.0106f,0.0014f,  -0.0106f,0.9999f,0.0129f,  -0.0013f,-0.0130f,0.9999f,  0.0804f,-0.9308f,-0.2150f,  
/* M022 */   0.9997f,0.0262f,0.0035f,  -0.0262f,0.9993f,0.0250f,  -0.0028f,-0.0251f,0.9997f,  0.2156f,-2.4764f,-0.5064f,  
/* M023 */   0.9991f,0.0416f,0.0058f,  -0.0418f,0.9984f,0.0371f,  -0.0042f,-0.0373f,0.9993f,  0.3752f,-4.0162f,-0.8164f,  
/* M024 */   0.9988f,0.0487f,0.0069f,  -0.0489f,0.9979f,0.0426f,  -0.0048f,-0.0429f,0.9991f,  0.4559f,-4.7139f,-0.9634f,  
/* M025 */   0.9966f,0.0819f,0.0094f,  -0.0822f,0.9957f,0.0431f,  -0.0059f,-0.0437f,0.9990f,  0.8718f,-8.7130f,-1.2726f,  
/* M026 */   0.9879f,0.1546f,0.0151f,  -0.1551f,0.9869f,0.0440f,  -0.0081f,-0.0458f,0.9989f,  2.2565f,-17.4472f,-1.9579f,  
/* M027 */   0.9738f,0.2265f,0.0208f,  -0.2272f,0.9728f,0.0444f,  -0.0102f,-0.0479f,0.9988f,  4.2806f,-26.0555f,-2.6470f,  
/* M028 */   0.9657f,0.2588f,0.0234f,  -0.2596f,0.9647f,0.0444f,  -0.0110f,-0.0490f,0.9987f,  5.4092f,-29.9140f,-2.9604f,  
/* M029 */   0.9763f,0.2159f,-0.0135f,  -0.2149f,0.9751f,0.0555f,  0.0251f,-0.0513f,0.9984f,  -14.2223f,-26.4632f,-0.8639f,  
/* M030 */   0.9848f,0.1504f,-0.0869f,  -0.1456f,0.9876f,0.0593f,  0.0947f,-0.0457f,0.9945f,  -44.9247f,-16.9403f,4.6184f,  
/* M031 */   0.9861f,0.0513f,-0.1580f,  -0.0442f,0.9979f,0.0482f,  0.1601f,-0.0406f,0.9863f,  -77.0760f,-4.6958f,8.5286f,  
/* M032 */   0.9713f,-0.1152f,-0.2080f,  0.1191f,0.9929f,0.0063f,  0.2058f,-0.0309f,0.9781f,  -115.4637f,10.1760f,8.0586f,  
/* M033 */   0.9190f,-0.3061f,-0.2484f,  0.2994f,0.9519f,-0.0653f,  0.2565f,-0.0143f,0.9664f,  -156.8264f,35.7451f,5.9151f,  
/* M034 */   0.8549f,-0.4114f,-0.3162f,  0.3831f,0.9114f,-0.1501f,  0.3499f,0.0072f,0.9368f,  -185.5207f,58.3127f,7.7057f,  
/* M035 */   0.8030f,-0.4022f,-0.4399f,  0.3396f,0.9152f,-0.2168f,  0.4898f,0.0247f,0.8715f,  -202.5350f,67.0544f,14.4028f,  
/* M036 */   0.7324f,-0.3337f,-0.5935f,  0.2284f,0.9416f,-0.2475f,  0.6414f,0.0457f,0.7658f,  -213.9460f,67.2247f,25.0243f,  
/* M037 */   0.6264f,-0.2393f,-0.7419f,  0.0869f,0.9672f,-0.2386f,  0.7747f,0.0850f,0.6266f,  -218.0186f,59.0158f,40.8817f,  
/* M038 */   0.4736f,-0.0957f,-0.8755f,  -0.1017f,0.9815f,-0.1623f,  0.8748f,0.1659f,0.4551f,  -206.3363f,36.1504f,55.1771f,  
/* M039 */   0.2504f,0.0814f,-0.9647f,  -0.2792f,0.9602f,0.0085f,  0.9270f,0.2672f,0.2631f,  -180.7584f,5.8412f,56.5467f,  
/* M040 */   0.0038f,0.2007f,-0.9797f,  -0.3420f,0.9208f,0.1873f,  0.9397f,0.3344f,0.0721f,  -157.9337f,-14.0294f,50.3849f,  
/* M041 */   -0.2016f,0.2146f,-0.9557f,  -0.3034f,0.9140f,0.2692f,  0.9313f,0.3443f,-0.1192f,  -135.4861f,-22.3138f,49.9757f,  
/* M042 */   -0.3624f,0.1775f,-0.9150f,  -0.2484f,0.9278f,0.2784f,  0.8983f,0.3282f,-0.2921f,  -107.5386f,-20.6034f,48.0044f,  
/* M043 */   -0.4874f,0.1598f,-0.8584f,  -0.2091f,0.9331f,0.2925f,  0.8477f,0.3221f,-0.4214f,  -92.4675f,-19.8375f,39.5585f,  
/* M044 */   -0.4954f,0.0372f,-0.8679f,  -0.1202f,0.9865f,0.1109f,  0.8603f,0.1592f,-0.4842f,  -92.1270f,-7.0056f,41.6392f,  
/* M045 */   -0.4857f,-0.0343f,-0.8735f,  -0.0809f,0.9967f,0.0059f,  0.8704f,0.0735f,-0.4869f,  -93.4520f,0.7955f,43.0980f,  
/* M046 */   -0.4721f,-0.0611f,-0.8794f,  -0.0917f,0.9956f,-0.0199f,  0.8768f,0.0712f,-0.4756f,  -94.9082f,3.9932f,44.1416f,  
/* M047 */   -0.4662f,-0.0640f,-0.8824f,  -0.1091f,0.9939f,-0.0144f,  0.8779f,0.0896f,-0.4703f,  -95.4642f,4.4918f,44.5306f,  
/* M048 */   -0.4456f,-0.1011f,-0.8895f,  -0.1523f,0.9877f,-0.0360f,  0.8822f,0.1195f,-0.4555f,  -97.9212f,8.4508f,45.0640f,  
/* M049 */   -0.4233f,-0.1374f,-0.8955f,  -0.1948f,0.9791f,-0.0582f,  0.8848f,0.1498f,-0.4412f,  -100.5481f,12.3067f,45.4785f,  
/* M050 */   -0.4482f,-0.1823f,-0.8751f,  -0.2457f,0.9664f,-0.0755f,  0.8595f,0.1811f,-0.4779f,  -96.6430f,17.4858f,44.0841f,  
/* M051 */   -0.6008f,-0.1828f,-0.7782f,  -0.2673f,0.9634f,-0.0200f,  0.7534f,0.1960f,-0.6277f,  -81.8325f,21.8625f,30.7989f,  
/* M052 */   -0.7830f,-0.1947f,-0.5908f,  -0.2929f,0.9533f,0.0740f,  0.5488f,0.2310f,-0.8034f,  -60.2175f,23.9069f,7.8121f,  
/* M053 */   -0.9257f,-0.2083f,-0.3157f,  -0.2752f,0.9435f,0.1845f,  0.2595f,0.2577f,-0.9307f,  -42.0059f,26.7457f,-29.0420f,  
/* M054 */   -0.9664f,-0.2241f,0.1255f,  -0.1830f,0.9435f,0.2762f,  -0.1804f,0.2440f,-0.9529f,  -38.5820f,31.3552f,-89.4038f,  
/* M055 */   -0.7719f,-0.2134f,0.5989f,  -0.0557f,0.9611f,0.2705f,  -0.6333f,0.1754f,-0.7537f,  -68.4735f,31.4993f,-146.4982f,  
/* M056 */   -0.5422f,-0.1880f,0.8190f,  0.0031f,0.9742f,0.2257f,  -0.8403f,0.1249f,-0.5276f,  -100.4509f,26.7505f,-169.8522f,  
/* M057 */   -0.5426f,-0.1780f,0.8209f,  0.0040f,0.9767f,0.2144f,  -0.8400f,0.1196f,-0.5293f,  -100.4068f,25.6744f,-169.9985f,  
/* M058 */   -0.5436f,-0.1559f,0.8247f,  0.0059f,0.9819f,0.1895f,  -0.8393f,0.1079f,-0.5328f,  -100.3132f,23.3011f,-170.2767f,  
/* M059 */   -0.5445f,-0.1338f,0.8280f,  0.0079f,0.9863f,0.1645f,  -0.8387f,0.0961f,-0.5361f,  -100.2246f,20.9215f,-170.4943f,  
/* M060 */   -0.5450f,-0.1237f,0.8293f,  0.0088f,0.9882f,0.1531f,  -0.8384f,0.0907f,-0.5374f,  -100.1859f,19.8380f,-170.5733f,  
/* M061 */   -0.5446f,-0.0961f,0.8331f,  0.0372f,0.9897f,0.1385f,  -0.8378f,0.1064f,-0.5354f,  -100.3425f,16.5173f,-171.0417f,  
/* M062 */   -0.5420f,-0.0450f,0.8392f,  0.0898f,0.9898f,0.1110f,  -0.8356f,0.1355f,-0.5324f,  -100.9196f,10.3517f,-171.7618f,  
/* M063 */   -0.5394f,-0.0174f,0.8419f,  0.1180f,0.9884f,0.0961f,  -0.8337f,0.1512f,-0.5311f,  -101.3840f,7.0395f,-172.0680f,  
/* M064 */   -0.5496f,0.0282f,0.8349f,  0.1530f,0.9859f,0.0675f,  -0.8213f,0.1649f,-0.5462f,  -100.4269f,2.0404f,-171.1644f,  
/* M065 */   -0.5123f,0.0475f,0.8575f,  0.1993f,0.9778f,0.0649f,  -0.8354f,0.2042f,-0.5103f,  -105.1171f,0.5195f,-173.3131f,  
/* M066 */   -0.4452f,0.2637f,0.8557f,  0.5411f,0.8406f,0.0225f,  -0.7134f,0.4731f,-0.5169f,  -114.6978f,-20.8829f,-172.4493f,  
/* M067 */   -0.3866f,0.3333f,0.8599f,  0.6577f,0.7533f,0.0038f,  -0.6465f,0.5670f,-0.5104f,  -121.9159f,-27.2943f,-172.5478f,  
/* M068 */   -0.1618f,0.3322f,0.9292f,  0.6193f,0.7673f,-0.1665f,  -0.7683f,0.5485f,-0.3298f,  -147.8893f,-27.8434f,-192.7298f,  
/* M069 */   0.1946f,0.3154f,0.9288f,  0.4696f,0.8014f,-0.3705f,  -0.8612f,0.5083f,0.0078f,  -190.0392f,-27.1855f,-206.3178f,  
/* M070 */   0.4731f,0.2590f,0.8421f,  0.3140f,0.8435f,-0.4359f,  -0.8231f,0.4706f,0.3177f,  -226.2701f,-25.6607f,-219.1011f,  
/* M071 */   0.6008f,0.0988f,0.7933f,  0.2954f,0.8947f,-0.3352f,  -0.7428f,0.4357f,0.5083f,  -255.2808f,-15.3368f,-253.9463f,  
/* M072 */   0.6558f,-0.1187f,0.7455f,  0.3691f,0.9119f,-0.1795f,  -0.6585f,0.3929f,0.6418f,  -288.9791f,8.7086f,-297.4428f,  
/* M073 */   0.7044f,-0.2587f,0.6610f,  0.4344f,0.8936f,-0.1133f,  -0.5613f,0.3669f,0.7418f,  -323.4241f,30.0189f,-323.3653f,  
/* M074 */   0.8004f,-0.2446f,0.5473f,  0.4137f,0.8861f,-0.2090f,  -0.4338f,0.3936f,0.8105f,  -352.2612f,32.5367f,-324.8020f,  
/* M075 */   0.8900f,-0.1639f,0.4254f,  0.3297f,0.8758f,-0.3525f,  -0.3148f,0.4540f,0.8335f,  -370.9400f,23.6410f,-318.1047f,  
/* M076 */   0.9294f,-0.1262f,0.3469f,  0.2733f,0.8670f,-0.4167f,  -0.2481f,0.4820f,0.8403f,  -382.8762f,19.1038f,-319.5239f,  
/* M077 */   0.9360f,-0.1199f,0.3310f,  0.2369f,0.9100f,-0.3403f,  -0.2604f,0.3970f,0.8801f,  -383.4720f,16.8442f,-317.8500f,  
/* M078 */   0.9487f,-0.0563f,0.3112f,  0.1716f,0.9182f,-0.3570f,  -0.2657f,0.3921f,0.8807f,  -384.4145f,9.2997f,-315.3908f,  
/* M079 */   0.9537f,-0.0214f,0.3001f,  0.1373f,0.9186f,-0.3706f,  -0.2677f,0.3946f,0.8790f,  -384.7069f,5.2782f,-313.9903f,  
/* M080 */   0.9606f,0.0437f,0.2745f,  0.0909f,0.8840f,-0.4586f,  -0.2627f,0.4655f,0.8452f,  -385.0176f,-1.0362f,-310.6494f,  
/* M081 */   0.9607f,0.2003f,0.1920f,  0.0103f,0.6657f,-0.7461f,  -0.2773f,0.7188f,0.6375f,  -384.4835f,-13.8869f,-301.1571f,  
/* M082 */   0.9543f,0.2725f,0.1224f,  -0.0264f,0.4850f,-0.8741f,  -0.2975f,0.8310f,0.4700f,  -383.6700f,-19.1302f,-294.0920f,  
/* M083 */   0.9642f,0.2407f,0.1114f,  -0.0435f,0.5580f,-0.8287f,  -0.2616f,0.7942f,0.5485f,  -399.3493f,-20.0580f,-317.4554f,  
/* M084 */   0.9743f,0.1788f,0.1373f,  -0.0270f,0.6972f,-0.7164f,  -0.2238f,0.6942f,0.6841f,  -421.9426f,-21.8516f,-356.6133f,  
/* M085 */   0.9774f,0.0925f,0.1900f,  0.0294f,0.8309f,-0.5556f,  -0.2093f,0.5486f,0.8094f,  -443.9216f,-17.8070f,-402.6842f,  
/* M086 */   0.9689f,-0.0112f,0.2473f,  0.1080f,0.9181f,-0.3814f,  -0.2228f,0.3963f,0.8907f,  -460.4674f,-5.6070f,-447.0061f,  
/* M087 */   0.9520f,-0.1247f,0.2796f,  0.1950f,0.9510f,-0.2398f,  -0.2360f,0.2828f,0.9297f,  -474.8700f,9.0030f,-481.8596f,  
/* M088 */   0.9093f,-0.3021f,0.2863f,  0.3530f,0.9242f,-0.1459f,  -0.2205f,0.2337f,0.9470f,  -496.3717f,38.6832f,-509.0049f,  
/* M089 */   0.8186f,-0.5043f,0.2750f,  0.5454f,0.8326f,-0.0965f,  -0.1803f,0.2289f,0.9566f,  -517.8674f,82.5190f,-530.2590f,  
/* M090 */   0.7560f,-0.5975f,0.2671f,  0.6399f,0.7605f,-0.1100f,  -0.1374f,0.2541f,0.9574f,  -530.9134f,108.1620f,-542.9285f,  
/* M091 */   0.8063f,-0.5238f,0.2748f,  0.5826f,0.7836f,-0.2158f,  -0.1023f,0.3342f,0.9370f,  -538.0566f,93.1792f,-545.9677f,  
/* M092 */   0.9041f,-0.3508f,0.2441f,  0.4215f,0.8267f,-0.3728f,  -0.0710f,0.4399f,0.8952f,  -540.6390f,58.8608f,-537.7617f,  
/* M093 */   0.9695f,-0.1951f,0.1482f,  0.2428f,0.8459f,-0.4749f,  -0.0328f,0.4964f,0.8675f,  -541.9257f,30.1004f,-522.9603f,  
/* M094 */   0.9950f,-0.0993f,0.0052f,  0.0900f,0.8773f,-0.4714f,  0.0422f,0.4695f,0.8819f,  -544.2241f,12.2515f,-501.6025f,  
/* M095 */   0.9896f,-0.0221f,-0.1418f,  -0.0375f,0.9138f,-0.4043f,  0.1385f,0.4055f,0.9035f,  -539.8859f,0.2975f,-479.7959f,  
/* M096 */   0.9732f,0.0132f,-0.2296f,  -0.0970f,0.9288f,-0.3576f,  0.2086f,0.3702f,0.9052f,  -539.7166f,-7.0123f,-472.0191f,  
/* M097 */   0.9724f,-0.0056f,-0.2334f,  -0.0402f,0.9808f,-0.1908f,  0.2299f,0.1949f,0.9535f,  -539.8624f,-7.3433f,-472.4838f,  
/* M098 */   0.9708f,0.0210f,-0.2390f,  -0.0453f,0.9943f,-0.0969f,  0.2356f,0.1049f,0.9662f,  -539.5575f,-11.1023f,-472.5297f,  
/* M099 */   0.9682f,0.0629f,-0.2420f,  -0.0852f,0.9929f,-0.0825f,  0.2351f,0.1005f,0.9668f,  -538.8952f,-15.3908f,-472.2970f,  
/* M100 */   0.9659f,0.0897f,-0.2427f,  -0.1208f,0.9858f,-0.1164f,  0.2288f,0.1418f,0.9631f,  -538.3845f,-17.5965f,-471.9528f,  
/* M101 */   0.9559f,0.1235f,-0.2666f,  -0.1841f,0.9589f,-0.2158f,  0.2290f,0.2553f,0.9393f,  -537.0530f,-19.7743f,-469.1149f,  
/* M102 */   0.9312f,0.1316f,-0.3400f,  -0.2787f,0.8582f,-0.4310f,  0.2351f,0.4961f,0.8358f,  -534.1073f,-16.9682f,-460.7473f,  
/* M103 */   0.8192f,0.3306f,-0.4686f,  -0.5717f,0.4058f,-0.7131f,  -0.0455f,0.8521f,0.5215f,  -521.1667f,-32.7273f,-446.5322f,  
/* M104 */   0.7798f,0.3406f,-0.5252f,  -0.6112f,0.2332f,-0.7564f,  -0.1352f,0.9108f,0.3900f,  -517.0356f,-31.5145f,-440.7845f,  
/* M105 */   0.7618f,0.3568f,-0.5406f,  -0.6414f,0.2985f,-0.7068f,  -0.0908f,0.8852f,0.4563f,  -525.7535f,-38.3665f,-452.9223f,  
/* M106 */   0.7485f,0.3987f,-0.5299f,  -0.6632f,0.4502f,-0.5980f,  0.0001f,0.7990f,0.6014f,  -542.0734f,-49.6738f,-478.4128f,  
/* M107 */   0.7525f,0.4346f,-0.4949f,  -0.6480f,0.6229f,-0.4384f,  0.1177f,0.6505f,0.7503f,  -566.3156f,-56.0698f,-509.6218f,  
/* M108 */   0.7729f,0.4387f,-0.4584f,  -0.5903f,0.7621f,-0.2659f,  0.2328f,0.4761f,0.8480f,  -595.5975f,-52.2767f,-537.3401f,  
/* M109 */   0.7925f,0.4052f,-0.4559f,  -0.5140f,0.8460f,-0.1417f,  0.3283f,0.3467f,0.8787f,  -624.4069f,-42.2700f,-552.8218f,  
/* M110 */   0.8052f,0.3100f,-0.5056f,  -0.4141f,0.9042f,-0.1051f,  0.4245f,0.2940f,0.8564f,  -656.1531f,-29.4780f,-552.6834f,  
/* M111 */   0.7962f,0.1542f,-0.5850f,  -0.2883f,0.9468f,-0.1427f,  0.5319f,0.2823f,0.7983f,  -691.1563f,-10.6964f,-540.8319f,  
/* M112 */   0.7502f,-0.0106f,-0.6611f,  -0.1850f,0.9565f,-0.2254f,  0.6348f,0.2914f,0.7156f,  -719.8016f,11.2888f,-522.8061f,  
/* M113 */   0.6826f,-0.1297f,-0.7192f,  -0.1401f,0.9427f,-0.3029f,  0.7172f,0.3075f,0.6253f,  -736.9290f,29.3568f,-504.5506f,  
/* M114 */   0.6189f,-0.1513f,-0.7707f,  -0.1648f,0.9344f,-0.3158f,  0.7680f,0.3225f,0.5534f,  -740.8755f,34.3944f,-490.9692f,  
/* M115 */   0.6198f,-0.1322f,-0.7735f,  -0.1874f,0.9323f,-0.3094f,  0.7621f,0.3367f,0.5531f,  -740.8510f,32.3784f,-490.7074f,  
/* M116 */   0.6212f,-0.0943f,-0.7780f,  -0.2344f,0.9249f,-0.2992f,  0.7478f,0.3682f,0.5524f,  -740.7606f,28.4522f,-490.2905f,  
/* M117 */   0.6209f,-0.0743f,-0.7803f,  -0.2585f,0.9204f,-0.2933f,  0.7400f,0.3839f,0.5523f,  -740.6179f,26.3740f,-490.0758f,  
/* M118 */   0.6194f,-0.0797f,-0.7810f,  -0.2427f,0.9266f,-0.2871f,  0.7466f,0.3674f,0.5547f,  -740.5052f,26.7302f,-490.0265f,  
/* M119 */   0.6150f,-0.0935f,-0.7830f,  -0.2032f,0.9406f,-0.2719f,  0.7619f,0.3263f,0.5595f,  -740.1429f,27.6597f,-489.8692f,  
/* M120 */   0.6146f,-0.0949f,-0.7831f,  -0.1970f,0.9428f,-0.2690f,  0.7638f,0.3196f,0.5608f,  -740.1362f,27.7206f,-489.8693f,  
/* M121 */   0.6116f,-0.1387f,-0.7789f,  -0.1792f,0.9347f,-0.3071f,  0.7707f,0.3274f,0.5467f,  -741.7576f,30.6227f,-487.0790f,  
/* M122 */   0.5942f,-0.2443f,-0.7663f,  -0.1359f,0.9086f,-0.3950f,  0.7927f,0.3389f,0.5067f,  -748.7227f,40.8940f,-477.2936f,  
/* M123 */   0.5789f,-0.3668f,-0.7282f,  -0.0788f,0.8638f,-0.4977f,  0.8116f,0.3455f,0.4711f,  -756.0804f,57.9004f,-468.9538f,  
/* M124 */   0.5891f,-0.4632f,-0.6622f,  -0.0167f,0.8123f,-0.5830f,  0.8079f,0.3545f,0.4708f,  -761.1826f,73.3766f,-468.2964f,  
/* M125 */   0.6233f,-0.5335f,-0.5718f,  0.0508f,0.7573f,-0.6511f,  0.7804f,0.3767f,0.4991f,  -765.0345f,83.9545f,-472.6006f,  
/* M126 */   0.6548f,-0.5978f,-0.4623f,  0.1256f,0.6893f,-0.7135f,  0.7453f,0.4091f,0.5265f,  -768.2061f,94.0787f,-477.3566f,  
/* M127 */   0.6781f,-0.6496f,-0.3439f,  0.2012f,0.6141f,-0.7632f,  0.7069f,0.4483f,0.5471f,  -770.1183f,102.8849f,-482.2944f,  
/* M128 */   0.6922f,-0.6844f,-0.2292f,  0.2695f,0.5397f,-0.7976f,  0.6695f,0.4903f,0.5580f,  -770.3603f,109.3803f,-486.8395f,  
/* M129 */   0.7024f,-0.7003f,-0.1273f,  0.3274f,0.4767f,-0.8158f,  0.6320f,0.5313f,0.5641f,  -769.1346f,112.1781f,-491.6546f,  
/* M130 */   0.7121f,-0.7007f,-0.0434f,  0.3761f,0.4330f,-0.8192f,  0.5928f,0.5671f,0.5719f,  -766.7333f,110.9057f,-497.3326f,  
/* M131 */   0.7221f,-0.6916f,0.0158f,  0.4126f,0.4123f,-0.8123f,  0.5553f,0.5931f,0.5831f,  -763.5643f,106.0369f,-503.3177f,  
/* M132 */   0.7338f,-0.6780f,0.0440f,  0.4331f,0.4169f,-0.7991f,  0.5234f,0.6054f,0.5996f,  -760.4255f,98.0748f,-509.6541f,  
/* M133 */   0.7361f,-0.6759f,0.0377f,  0.4402f,0.4357f,-0.7851f,  0.5142f,0.5945f,0.6182f,  -760.8739f,97.5121f,-508.8541f,  
/* M134 */   0.7367f,-0.6758f,0.0235f,  0.4469f,0.4605f,-0.7669f,  0.5075f,0.5755f,0.6413f,  -761.0671f,97.0898f,-507.0543f,  
/* M135 */   0.7345f,-0.6786f,0.0037f,  0.4520f,0.4852f,-0.7485f,  0.5062f,0.5514f,0.6631f,  -760.8664f,96.9805f,-504.5755f,  
/* M136 */   0.7283f,-0.6850f,-0.0199f,  0.4539f,0.5040f,-0.7348f,  0.5134f,0.5262f,0.6780f,  -760.0444f,97.3782f,-501.6197f,  
/* M137 */   0.7187f,-0.6939f,-0.0455f,  0.4529f,0.5167f,-0.7266f,  0.5277f,0.5016f,0.6856f,  -758.6830f,98.1739f,-498.3917f,  
/* M138 */   0.7055f,-0.7051f,-0.0712f,  0.4474f,0.5210f,-0.7269f,  0.5496f,0.4810f,0.6830f,  -756.7826f,99.3831f,-495.1624f,  
/* M139 */   0.6942f,-0.7135f,-0.0951f,  0.4436f,0.5281f,-0.7241f,  0.5669f,0.4605f,0.6831f,  -754.8938f,100.4249f,-492.3053f,  
/* M140 */   0.6881f,-0.7163f,-0.1154f,  0.4457f,0.5428f,-0.7118f,  0.5725f,0.4384f,0.6928f,  -753.4650f,100.9843f,-490.1532f,  
/* M141 */   0.6840f,-0.7180f,-0.1291f,  0.4472f,0.5526f,-0.7033f,  0.5763f,0.4233f,0.6991f,  -752.2494f,101.5115f,-488.7963f,  
/* M142 */   0.6825f,-0.7185f,-0.1342f,  0.4478f,0.5561f,-0.7001f,  0.5777f,0.4177f,0.7013f,  -751.4501f,102.0032f,-488.5111f,  
/* M143 */   0.6921f,-0.7093f,-0.1340f,  0.4452f,0.5656f,-0.6942f,  0.5682f,0.4208f,0.7072f,  -751.9932f,101.3529f,-488.9347f,  
/* M144 */   0.6919f,-0.7094f,-0.1342f,  0.4453f,0.5656f,-0.6942f,  0.5684f,0.4205f,0.7072f,  -751.5213f,101.7438f,-489.1392f,  
/* M145 */   0.6914f,-0.7098f,-0.1347f,  0.4454f,0.5656f,-0.6941f,  0.5689f,0.4199f,0.7072f,  -751.1445f,102.0409f,-489.2046f,  
/* M146 */   0.6907f,-0.7104f,-0.1356f,  0.4455f,0.5656f,-0.6939f,  0.5696f,0.4189f,0.7071f,  -750.9240f,102.2172f,-489.1736f,  
/* M147 */   0.6897f,-0.7111f,-0.1367f,  0.4457f,0.5657f,-0.6938f,  0.5706f,0.4176f,0.7071f,  -750.7853f,102.2930f,-489.0113f,  
/* M148 */   0.6885f,-0.7120f,-0.1379f,  0.4459f,0.5656f,-0.6938f,  0.5719f,0.4162f,0.7068f,  -750.6759f,102.3679f,-488.8234f,  
/* M149 */   0.6876f,-0.7126f,-0.1392f,  0.4464f,0.5661f,-0.6930f,  0.5727f,0.4144f,0.7074f,  -750.5739f,102.3850f,-488.6324f,  
/* M150 */   0.6862f,-0.7137f,-0.1406f,  0.4464f,0.5657f,-0.6934f,  0.5744f,0.4130f,0.7067f,  -750.4166f,102.4977f,-488.4276f,  
/* M151 */   0.6851f,-0.7145f,-0.1419f,  0.4467f,0.5660f,-0.6929f,  0.5754f,0.4113f,0.7069f,  -750.2777f,102.5588f,-488.2383f,  
/* M152 */   0.6840f,-0.7153f,-0.1431f,  0.4470f,0.5660f,-0.6927f,  0.5765f,0.4098f,0.7069f,  -750.1959f,102.5869f,-488.0268f,  
/* M153 */   0.6832f,-0.7159f,-0.1442f,  0.4474f,0.5663f,-0.6922f,  0.5772f,0.4084f,0.7072f,  -750.1640f,102.5739f,-487.8189f,  
/* M154 */   0.6823f,-0.7165f,-0.1450f,  0.4473f,0.5661f,-0.6924f,  0.5782f,0.4076f,0.7068f,  -750.0884f,102.6171f,-487.6364f,  
/* M155 */   0.6817f,-0.7170f,-0.1456f,  0.4473f,0.5659f,-0.6925f,  0.5789f,0.4070f,0.7065f,  -749.9974f,102.6934f,-487.5247f,  
/* M156 */   0.6816f,-0.7170f,-0.1458f,  0.4475f,0.5661f,-0.6923f,  0.5789f,0.4066f,0.7068f,  -749.9141f,102.7613f,-487.4960f,  
/* M157 */   0.6831f,-0.7142f,-0.1527f,  0.4457f,0.5733f,-0.6875f,  0.5786f,0.4016f,0.7099f,  -749.8986f,102.4498f,-486.6812f,  
/* M158 */   0.6864f,-0.7076f,-0.1679f,  0.4416f,0.5889f,-0.6769f,  0.5778f,0.3905f,0.7167f,  -749.9572f,101.6336f,-484.9067f,  
/* M159 */   0.6896f,-0.7007f,-0.1829f,  0.4376f,0.6044f,-0.6657f,  0.5770f,0.3790f,0.7235f,  -750.0193f,100.7683f,-483.1349f,  
/* M160 */   0.6909f,-0.6976f,-0.1897f,  0.4356f,0.6112f,-0.6608f,  0.5769f,0.3740f,0.7262f,  -750.0402f,100.4066f,-482.2854f,  
/* M161 */   0.6887f,-0.6985f,-0.1942f,  0.4371f,0.6137f,-0.6575f,  0.5785f,0.3680f,0.7280f,  -749.7577f,100.4900f,-481.6430f,  
/* M162 */   0.6849f,-0.6999f,-0.2025f,  0.4402f,0.6189f,-0.6506f,  0.5807f,0.3564f,0.7320f,  -749.3145f,100.5370f,-480.5166f,  
/* M163 */   0.6830f,-0.7005f,-0.2070f,  0.4420f,0.6220f,-0.6463f,  0.5815f,0.3499f,0.7345f,  -749.2257f,100.4371f,-479.8099f,  
/* M164 */   0.6788f,-0.6881f,-0.2564f,  0.3819f,0.6290f,-0.6771f,  0.6273f,0.3617f,0.6897f,  -743.3831f,96.9263f,-460.4368f,  
/* M165 */   0.6727f,-0.6495f,-0.3545f,  0.2495f,0.6501f,-0.7177f,  0.6966f,0.3944f,0.5994f,  -727.8903f,85.3915f,-430.9549f,  
/* M166 */   0.6442f,-0.5960f,-0.4794f,  0.0706f,0.6704f,-0.7386f,  0.7616f,0.4419f,0.4739f,  -701.6590f,72.1958f,-399.9914f,  
/* M167 */   0.5849f,-0.5408f,-0.6045f,  -0.1204f,0.6791f,-0.7241f,  0.8021f,0.4963f,0.3321f,  -668.8453f,62.4057f,-374.0586f,  
/* M168 */   0.5057f,-0.4982f,-0.7043f,  -0.2873f,0.6726f,-0.6820f,  0.8135f,0.5472f,0.1970f,  -637.5460f,57.6720f,-354.1113f,  
/* M169 */   0.4275f,-0.4659f,-0.7747f,  -0.4351f,0.6451f,-0.6281f,  0.7924f,0.6056f,0.0731f,  -610.3339f,54.1784f,-336.6673f,  
/* M170 */   0.3563f,-0.4371f,-0.8258f,  -0.5698f,0.5989f,-0.5628f,  0.7405f,0.6711f,-0.0357f,  -585.4633f,50.3992f,-320.7752f,  
/* M171 */   0.2965f,-0.4185f,-0.8584f,  -0.6668f,0.5528f,-0.4998f,  0.6837f,0.7206f,-0.1151f,  -565.7139f,48.8462f,-306.8604f,  
/* M172 */   0.2486f,-0.4182f,-0.8737f,  -0.7137f,0.5308f,-0.4571f,  0.6549f,0.7372f,-0.1665f,  -552.8456f,50.6019f,-292.7371f,  
/* M173 */   0.1938f,-0.4166f,-0.8882f,  -0.6000f,0.6660f,-0.4433f,  0.7762f,0.6188f,-0.1209f,  -545.9133f,47.6055f,-290.5746f,  
/* M174 */   0.0638f,-0.3581f,-0.9315f,  -0.4468f,0.8244f,-0.3475f,  0.8924f,0.4383f,-0.1074f,  -530.6558f,36.9481f,-286.2422f,  
/* M175 */   -0.0616f,-0.2531f,-0.9655f,  -0.3746f,0.9025f,-0.2127f,  0.9252f,0.3485f,-0.1504f,  -516.3044f,22.8121f,-284.1006f,  
/* M176 */   -0.1141f,-0.2002f,-0.9731f,  -0.3305f,0.9314f,-0.1529f,  0.9369f,0.3041f,-0.1724f,  -510.4465f,15.8045f,-284.0601f,  
/* M177 */   -0.1160f,-0.1892f,-0.9751f,  -0.2952f,0.9439f,-0.1480f,  0.9484f,0.2706f,-0.1654f,  -510.3965f,14.0586f,-283.7819f,  
/* M178 */   -0.1246f,-0.1532f,-0.9803f,  -0.2528f,0.9603f,-0.1180f,  0.9595f,0.2331f,-0.1584f,  -509.6392f,9.4613f,-283.3576f,  
/* M179 */   -0.1349f,-0.1006f,-0.9857f,  -0.2073f,0.9757f,-0.0712f,  0.9689f,0.1948f,-0.1525f,  -508.7389f,3.0109f,-283.0774f,  
/* M180 */   -0.1441f,-0.0415f,-0.9887f,  -0.1638f,0.9863f,-0.0175f,  0.9759f,0.1594f,-0.1489f,  -507.9782f,-4.0847f,-283.1820f,  
/* M181 */   -0.1515f,0.0136f,-0.9884f,  -0.1296f,0.9910f,0.0335f,  0.9799f,0.1332f,-0.1484f,  -507.3784f,-10.5571f,-283.6840f,  
/* M182 */   -0.1576f,0.0547f,-0.9860f,  -0.1151f,0.9906f,0.0733f,  0.9808f,0.1251f,-0.1498f,  -506.7917f,-15.2058f,-284.3473f,  
/* M183 */   -0.1628f,0.0748f,-0.9838f,  -0.1416f,0.9850f,0.0983f,  0.9764f,0.1554f,-0.1497f,  -506.0008f,-16.9975f,-284.8284f,  
/* M184 */   -0.2002f,0.0760f,-0.9768f,  -0.0812f,0.9923f,0.0938f,  0.9764f,0.0981f,-0.1925f,  -502.2317f,-17.3717f,-285.7228f,  
/* M185 */   -0.1923f,0.0809f,-0.9780f,  -0.0211f,0.9960f,0.0865f,  0.9811f,0.0373f,-0.1898f,  -503.5459f,-17.5669f,-285.8049f,  
/* M186 */   -0.1673f,0.1319f,-0.9770f,  0.0419f,0.9911f,0.1266f,  0.9850f,-0.0198f,-0.1713f,  -506.8685f,-22.1306f,-286.6961f,  
/* M187 */   -0.1359f,0.1864f,-0.9730f,  0.0945f,0.9801f,0.1746f,  0.9862f,-0.0682f,-0.1508f,  -510.8487f,-27.0205f,-287.9726f,  
/* M188 */   -0.1218f,0.2054f,-0.9711f,  0.1262f,0.9736f,0.1901f,  0.9845f,-0.0994f,-0.1445f,  -512.6883f,-28.6216f,-288.5392f,  
/* M189 */   0.0612f,0.2061f,-0.9766f,  0.0844f,0.9739f,0.2108f,  0.9946f,-0.0954f,0.0422f,  -518.9572f,-27.9969f,-284.1579f,  
/* M190 */   0.3884f,0.2044f,-0.8985f,  -0.0029f,0.9754f,0.2206f,  0.9215f,-0.0831f,0.3795f,  -535.2333f,-28.5861f,-292.1074f,  
/* M191 */   0.6911f,0.2153f,-0.6899f,  -0.1202f,0.9755f,0.1841f,  0.7127f,-0.0443f,0.7001f,  -542.8455f,-31.5173f,-311.3887f,  
/* M192 */   0.8490f,0.2552f,-0.4627f,  -0.2393f,0.9664f,0.0940f,  0.4712f,0.0309f,0.8815f,  -533.3004f,-37.9515f,-324.4328f,  
/* M193 */   0.8761f,0.3429f,-0.3389f,  -0.3874f,0.9191f,-0.0716f,  0.2870f,0.1940f,0.9381f,  -507.9703f,-48.6300f,-315.4023f,  
/* M194 */   0.8366f,0.4462f,-0.3176f,  -0.5324f,0.7987f,-0.2804f,  0.1286f,0.4037f,0.9058f,  -475.3500f,-55.7390f,-288.2874f,  
/* M195 */   0.7871f,0.5048f,-0.3544f,  -0.6163f,0.6652f,-0.4214f,  0.0230f,0.5501f,0.8348f,  -449.9854f,-55.6477f,-257.8517f,  
/* M196 */   0.7415f,0.5139f,-0.4313f,  -0.6709f,0.5776f,-0.4651f,  0.0101f,0.6342f,0.7731f,  -434.2798f,-54.4520f,-227.3177f,  
/* M197 */   0.6842f,0.4891f,-0.5410f,  -0.7270f,0.5158f,-0.4532f,  0.0574f,0.7034f,0.7085f,  -421.9360f,-51.5830f,-195.2157f,  
/* M198 */   0.6339f,0.4534f,-0.6267f,  -0.7655f,0.4838f,-0.4243f,  0.1108f,0.7486f,0.6537f,  -414.0439f,-48.1407f,-170.0934f,  
/* M199 */   0.6251f,0.4374f,-0.6465f,  -0.7712f,0.4742f,-0.4248f,  0.1208f,0.7641f,0.6337f,  -412.4786f,-46.5836f,-158.5188f,  
/* M200 */   0.6343f,0.4379f,-0.6372f,  -0.7610f,0.4986f,-0.4150f,  0.1360f,0.7481f,0.6495f,  -413.4429f,-47.0682f,-159.4861f,  
/* M201 */   0.6511f,0.4213f,-0.6314f,  -0.7488f,0.4926f,-0.4435f,  0.1242f,0.7615f,0.6362f,  -415.6618f,-44.9114f,-160.0718f,  
/* M202 */   0.6685f,0.3978f,-0.6284f,  -0.7380f,0.4590f,-0.4946f,  0.0917f,0.7944f,0.6004f,  -418.2214f,-41.4275f,-160.4202f,  
/* M203 */   0.6822f,0.3797f,-0.6248f,  -0.7286f,0.4246f,-0.5375f,  0.0612f,0.8219f,0.5663f,  -420.3103f,-38.6464f,-160.8954f,  
/* M204 */   0.6890f,0.3734f,-0.6212f,  -0.7225f,0.4209f,-0.5484f,  0.0567f,0.8267f,0.5598f,  -421.2136f,-37.8092f,-161.3013f,  
/* M205 */   0.6905f,0.3732f,-0.6196f,  -0.7205f,0.4308f,-0.5435f,  0.0641f,0.8217f,0.5664f,  -421.3128f,-37.9502f,-161.4473f,  
/* M206 */   0.6912f,0.3712f,-0.6200f,  -0.7201f,0.4251f,-0.5484f,  0.0600f,0.8255f,0.5612f,  -421.4520f,-37.6118f,-161.4219f,  
/* M207 */   0.6915f,0.3678f,-0.6218f,  -0.7208f,0.4084f,-0.5600f,  0.0480f,0.8354f,0.5476f,  -421.6323f,-36.9338f,-161.2907f,  
/* M208 */   0.6905f,0.3634f,-0.6254f,  -0.7229f,0.3756f,-0.5799f,  0.0242f,0.8526f,0.5221f,  -421.8169f,-35.8846f,-161.0179f,  
/* M209 */   0.6894f,0.3587f,-0.6294f,  -0.7244f,0.3379f,-0.6009f,  -0.0028f,0.8702f,0.4928f,  -422.0328f,-34.7571f,-160.7557f,  
/* M210 */   0.6897f,0.3539f,-0.6317f,  -0.7237f,0.3110f,-0.6160f,  -0.0216f,0.8821f,0.4706f,  -422.3260f,-33.7977f,-160.6399f,  
/* M211 */   0.6901f,0.3493f,-0.6338f,  -0.7226f,0.2846f,-0.6300f,  -0.0397f,0.8928f,0.4488f,  -422.6250f,-32.8723f,-160.5535f,  
/* M212 */   0.6906f,0.3451f,-0.6356f,  -0.7211f,0.2606f,-0.6420f,  -0.0559f,0.9017f,0.4288f,  -422.9061f,-32.0445f,-160.4976f,  
/* M213 */   0.6910f,0.3417f,-0.6370f,  -0.7195f,0.2411f,-0.6513f,  -0.0690f,0.9084f,0.4124f,  -423.1422f,-31.3772f,-160.4673f,  
/* M214 */   0.6913f,0.3394f,-0.6379f,  -0.7184f,0.2279f,-0.6573f,  -0.0777f,0.9126f,0.4013f,  -423.3045f,-30.9318f,-160.4545f,  
/* M215 */   0.6914f,0.3385f,-0.6382f,  -0.7179f,0.2231f,-0.6594f,  -0.0809f,0.9141f,0.3973f,  -423.3646f,-30.7696f,-160.4513f,  
/* M216 */   0.6910f,0.3393f,-0.6383f,  -0.7185f,0.2255f,-0.6579f,  -0.0793f,0.9132f,0.3996f,  -423.2841f,-30.8980f,-160.4250f,  
/* M217 */   0.6896f,0.3416f,-0.6385f,  -0.7203f,0.2325f,-0.6536f,  -0.0748f,0.9106f,0.4064f,  -423.0533f,-31.2679f,-160.3517f,  
/* M218 */   0.6875f,0.3453f,-0.6388f,  -0.7230f,0.2436f,-0.6465f,  -0.0677f,0.9063f,0.4172f,  -422.6888f,-31.8576f,-160.2425f,  
/* M219 */   0.6848f,0.3503f,-0.6391f,  -0.7264f,0.2582f,-0.6369f,  -0.0581f,0.9004f,0.4312f,  -422.2083f,-32.6458f,-160.1113f,  
/* M220 */   0.6814f,0.3563f,-0.6393f,  -0.7304f,0.2757f,-0.6249f,  -0.0464f,0.8927f,0.4482f,  -421.6296f,-33.6116f,-159.9729f,  
/* M221 */   0.6777f,0.3633f,-0.6393f,  -0.7346f,0.2958f,-0.6106f,  -0.0328f,0.8835f,0.4673f,  -420.9711f,-34.7334f,-159.8423f,  
/* M222 */   0.6736f,0.3711f,-0.6392f,  -0.7389f,0.3177f,-0.5942f,  -0.0175f,0.8725f,0.4882f,  -420.2510f,-35.9890f,-159.7339f,  
/* M223 */   0.6692f,0.3796f,-0.6388f,  -0.7431f,0.3409f,-0.5759f,  -0.0008f,0.8600f,0.5102f,  -419.4875f,-37.3553f,-159.6600f,  
/* M224 */   0.6651f,0.3888f,-0.6375f,  -0.7465f,0.3684f,-0.5541f,  0.0195f,0.8444f,0.5353f,  -418.7079f,-38.8843f,-159.6717f,  
/* M225 */   0.6637f,0.4009f,-0.6315f,  -0.7454f,0.4241f,-0.5142f,  0.0617f,0.8120f,0.5803f,  -417.9944f,-41.2324f,-160.1452f,  
/* M226 */   0.6606f,0.4125f,-0.6273f,  -0.7452f,0.4615f,-0.4813f,  0.0910f,0.7854f,0.6123f,  -417.2438f,-43.2829f,-160.5160f,  
/* M227 */   0.6574f,0.4240f,-0.6229f,  -0.7442f,0.4951f,-0.4484f,  0.1183f,0.7583f,0.6410f,  -416.5216f,-45.2943f,-160.9467f,  
/* M228 */   0.6541f,0.4349f,-0.6189f,  -0.7430f,0.5230f,-0.4177f,  0.1420f,0.7330f,0.6652f,  -415.8335f,-47.1542f,-161.3788f,  
/* M229 */   0.6506f,0.4446f,-0.6157f,  -0.7422f,0.5442f,-0.3913f,  0.1610f,0.7115f,0.6840f,  -415.1779f,-48.7677f,-161.7469f,  
/* M230 */   0.6460f,0.4519f,-0.6152f,  -0.7444f,0.5516f,-0.3763f,  0.1693f,0.7010f,0.6927f,  -414.5121f,-49.8255f,-161.8226f,  
/* M231 */   0.6413f,0.4577f,-0.6158f,  -0.7474f,0.5542f,-0.3664f,  0.1736f,0.6952f,0.6976f,  -413.8858f,-50.6012f,-161.7834f,  
/* M232 */   0.6372f,0.4628f,-0.6162f,  -0.7499f,0.5567f,-0.3573f,  0.1777f,0.6898f,0.7018f,  -413.3322f,-51.2846f,-161.7572f,  
/* M233 */   0.6338f,0.4672f,-0.6164f,  -0.7518f,0.5595f,-0.3489f,  0.1819f,0.6846f,0.7059f,  -412.8622f,-51.8977f,-161.7606f,  
/* M234 */   0.6312f,0.4710f,-0.6162f,  -0.7529f,0.5630f,-0.3408f,  0.1864f,0.6791f,0.7100f,  -412.4882f,-52.4382f,-161.8018f,  
/* M235 */   0.6293f,0.4740f,-0.6159f,  -0.7534f,0.5664f,-0.3340f,  0.1905f,0.6742f,0.7135f,  -412.2130f,-52.8757f,-161.8586f,  
/* M236 */   0.6283f,0.4759f,-0.6154f,  -0.7535f,0.5692f,-0.3290f,  0.1937f,0.6704f,0.7162f,  -412.0443f,-53.1851f,-161.9194f,  
/* M237 */   0.6281f,0.4768f,-0.6149f,  -0.7531f,0.5713f,-0.3261f,  0.1958f,0.6680f,0.7180f,  -411.9964f,-53.3420f,-161.9815f,  
/* M238 */   0.6286f,0.4768f,-0.6144f,  -0.7524f,0.5729f,-0.3252f,  0.1969f,0.6667f,0.7188f,  -412.0497f,-53.3705f,-162.0390f,  
/* M239 */   0.6297f,0.4761f,-0.6138f,  -0.7513f,0.5742f,-0.3253f,  0.1976f,0.6660f,0.7193f,  -412.1776f,-53.3158f,-162.1020f,  
/* M240 */   0.6312f,0.4749f,-0.6133f,  -0.7501f,0.5751f,-0.3266f,  0.1976f,0.6661f,0.7192f,  -412.3617f,-53.1775f,-162.1574f,  
/* M241 */   0.6329f,0.4733f,-0.6127f,  -0.7488f,0.5754f,-0.3289f,  0.1969f,0.6670f,0.7186f,  -412.5825f,-52.9783f,-162.2032f,  
/* M242 */   0.6347f,0.4714f,-0.6123f,  -0.7475f,0.5753f,-0.3320f,  0.1958f,0.6684f,0.7176f,  -412.8255f,-52.7423f,-162.2444f,  
/* M243 */   0.6367f,0.4695f,-0.6118f,  -0.7462f,0.5753f,-0.3351f,  0.1946f,0.6698f,0.7166f,  -413.0758f,-52.4940f,-162.2851f,  
/* M244 */   0.6385f,0.4676f,-0.6113f,  -0.7449f,0.5752f,-0.3381f,  0.1935f,0.6712f,0.7156f,  -413.3188f,-52.2593f,-162.3304f,  
/* M245 */   0.6402f,0.4660f,-0.6107f,  -0.7436f,0.5754f,-0.3405f,  0.1927f,0.6722f,0.7149f,  -413.5375f,-52.0561f,-162.3773f,  
/* M246 */   0.6416f,0.4646f,-0.6103f,  -0.7427f,0.5754f,-0.3426f,  0.1920f,0.6731f,0.7142f,  -413.7123f,-51.8888f,-162.4118f,  
/* M247 */   0.6424f,0.4637f,-0.6102f,  -0.7421f,0.5751f,-0.3443f,  0.1912f,0.6740f,0.7136f,  -413.8292f,-51.7683f,-162.4311f,  
/* M248 */   0.6427f,0.4633f,-0.6102f,  -0.7421f,0.5744f,-0.3454f,  0.1905f,0.6748f,0.7130f,  -413.8668f,-51.7020f,-162.4204f,  
/* M249 */   0.6427f,0.4633f,-0.6102f,  -0.7421f,0.5744f,-0.3454f,  0.1905f,0.6748f,0.7130f,  -413.8668f,-51.7020f,-162.4204f,  

_NULL_ }; /* End of object01_pData */


/* MESH ANIMATION 6 */

#define floor_NumFrames  243

const float floor_pData[] = {
/* M006 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M007 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M008 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M009 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M010 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M011 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M012 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M013 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M014 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M015 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M016 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M017 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M018 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M019 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M020 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M021 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M022 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M023 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M024 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M025 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M026 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M027 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M028 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M029 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M030 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M031 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M032 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M033 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M034 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M035 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M036 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M037 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M038 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M039 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M040 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M041 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M042 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M043 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M044 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M045 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M046 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M047 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M048 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M049 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M050 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M051 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M052 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M053 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M054 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M055 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M056 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M057 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M058 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M059 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M060 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M061 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M062 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M063 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M064 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M065 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M066 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M067 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M068 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M069 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M070 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M071 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M072 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M073 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M074 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M075 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M076 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M077 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M078 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M079 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M080 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M081 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M082 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M083 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M084 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M085 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M086 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M087 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M088 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M089 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M090 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M091 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M092 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M093 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M094 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M095 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M096 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M097 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M098 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M099 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M100 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M101 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M102 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M103 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M104 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M105 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M106 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M107 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M108 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M109 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M110 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M111 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M112 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M113 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M114 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M115 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M116 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M117 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M118 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M119 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M120 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M121 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M122 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M123 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M124 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M125 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M126 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M127 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M128 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M129 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M130 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M131 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M132 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M133 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M134 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M135 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M136 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M137 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M138 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M139 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M140 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M141 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M142 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M143 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M144 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M145 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M146 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M147 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M148 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M149 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M150 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M151 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M152 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M153 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M154 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M155 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M156 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M157 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M158 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M159 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M160 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M161 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M162 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M163 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M164 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M165 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M166 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M167 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M168 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M169 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M170 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M171 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M172 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M173 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M174 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M175 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M176 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M177 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M178 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M179 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M180 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M181 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M182 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M183 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M184 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M185 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M186 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M187 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M188 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M189 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M190 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M191 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M192 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M193 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M194 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M195 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M196 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M197 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M198 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M199 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M200 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M201 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M202 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M203 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M204 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M205 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M206 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M207 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M208 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M209 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M210 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M211 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M212 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M213 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M214 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M215 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M216 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M217 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M218 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M219 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M220 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M221 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M222 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M223 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M224 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M225 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M226 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M227 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M228 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M229 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M230 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M231 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M232 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M233 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M234 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M235 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M236 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M237 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M238 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M239 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M240 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M241 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M242 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M243 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M244 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M245 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M246 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M247 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M248 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M249 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M250 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  

_NULL_ }; /* End of floor_pData */


/* MESH ANIMATION 7 */

#define wall_NumFrames  243

const float wall_pData[] = {
/* M007 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M008 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M009 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M010 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M011 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M012 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M013 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M014 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M015 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M016 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M017 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M018 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M019 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M020 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M021 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M022 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M023 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M024 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M025 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M026 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M027 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M028 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M029 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M030 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M031 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M032 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M033 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M034 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M035 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M036 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M037 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M038 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M039 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M040 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M041 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M042 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M043 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M044 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M045 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M046 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M047 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M048 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M049 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M050 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M051 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M052 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M053 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M054 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M055 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M056 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M057 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M058 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M059 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M060 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M061 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M062 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M063 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M064 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M065 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M066 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M067 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M068 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M069 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M070 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M071 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M072 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M073 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M074 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M075 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M076 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M077 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M078 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M079 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M080 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M081 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M082 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M083 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M084 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M085 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M086 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M087 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M088 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M089 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M090 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M091 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M092 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M093 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M094 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M095 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M096 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M097 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M098 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M099 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M100 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M101 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M102 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M103 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M104 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M105 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M106 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M107 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M108 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M109 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M110 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M111 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M112 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M113 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M114 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M115 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M116 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M117 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M118 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M119 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M120 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M121 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M122 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M123 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M124 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M125 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M126 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M127 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M128 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M129 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M130 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M131 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M132 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M133 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M134 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M135 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M136 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M137 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M138 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M139 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M140 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M141 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M142 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M143 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M144 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M145 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M146 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M147 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M148 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M149 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M150 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M151 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M152 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M153 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M154 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M155 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M156 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M157 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M158 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M159 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M160 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M161 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M162 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M163 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M164 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M165 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M166 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M167 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M168 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M169 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M170 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M171 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M172 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M173 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M174 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M175 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M176 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M177 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M178 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M179 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M180 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M181 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M182 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M183 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M184 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M185 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M186 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M187 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M188 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M189 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M190 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M191 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M192 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M193 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M194 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M195 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M196 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M197 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M198 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M199 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M200 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M201 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M202 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M203 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M204 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M205 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M206 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M207 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M208 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M209 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M210 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M211 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M212 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M213 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M214 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M215 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M216 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M217 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M218 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M219 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M220 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M221 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M222 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M223 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M224 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M225 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M226 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M227 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M228 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M229 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M230 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M231 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M232 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M233 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M234 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M235 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M236 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M237 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M238 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M239 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M240 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M241 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M242 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M243 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M244 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M245 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M246 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M247 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M248 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M249 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M250 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  
/* M251 */   1.0000f,0.0000f,0.0000f,  0.0000f,1.0000f,0.0000f,  0.0000f,0.0000f,1.0000f,  0.0000f,0.0000f,0.0000f,  

_NULL_ }; /* End of wall_pData */



/**********************************************************
 * MESH ANIMATION 
 **********************************************************/

const Struct_Animation 
   Animation[NUM_MESHES] = {

/* MESH ANIMATION 0 */
	/* NumFrames      */ head_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ head_pData,

/* MESH ANIMATION 1 */
	/* NumFrames      */ hand_left_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ hand_left_pData,

/* MESH ANIMATION 2 */
	/* NumFrames      */ hand_right_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ hand_right_pData,

/* MESH ANIMATION 3 */
	/* NumFrames      */ body_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ body_pData,

/* MESH ANIMATION 4 */
	/* NumFrames      */ object02_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ object02_pData,

/* MESH ANIMATION 5 */
	/* NumFrames      */ object01_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ object01_pData,

/* MESH ANIMATION 6 */
	/* NumFrames      */ floor_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ floor_pData,

/* MESH ANIMATION 7 */
	/* NumFrames      */ wall_NumFrames,
	/* Pivot          */ 0.0000f,0.0000f,0.0000f,
	/* Data           */ wall_pData

	}; /* End of Animation */

/**********************************************************
 * CAMERA ANIMATION DATA 
 **********************************************************/

/* CAMERA ANIMATION 0 */

const float camera01_pPosition[] = {
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   
-1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   -1351.760254f, 722.814270f, 862.245422f,   

_NULL_ }; /* End of camera01_pPosition */

const float camera01_pTarget[] = {
67.589836f, 198.834610f, 41.417912f,   68.692039f, 198.741913f, 41.541550f,   69.805679f, 198.642685f, 41.642555f,   70.828125f, 198.561615f, 41.717838f,   71.656204f, 198.542923f, 41.771534f,   
72.350601f, 198.594696f, 41.853989f,   73.013718f, 198.686890f, 41.990662f,   73.607666f, 198.787704f, 42.149799f,   74.097946f, 198.865280f, 42.296059f,   74.719666f, 198.892776f, 42.367939f,   
75.236519f, 198.829086f, 42.202614f,   75.437630f, 198.631165f, 41.815483f,   75.593811f, 198.265900f, 41.399277f,   75.383377f, 197.705414f, 40.925388f,   74.374329f, 196.965500f, 40.351177f,   
72.575890f, 196.099182f, 39.829632f,   70.046036f, 195.148331f, 39.516518f,   67.456085f, 194.134186f, 39.736610f,   65.305946f, 193.075745f, 40.595520f,   63.431847f, 191.983276f, 41.846912f,   
61.806969f, 190.877640f, 43.353241f,   60.288231f, 189.791428f, 44.988777f,   58.785873f, 188.750427f, 46.574070f,   57.211773f, 187.784821f, 47.917831f,   56.567806f, 186.955276f, 49.069843f,   
56.533821f, 186.307373f, 49.947285f,   55.346569f, 185.854370f, 49.923523f,   53.109467f, 185.658401f, 48.819870f,   49.888702f, 185.773895f, 45.368626f,   44.130169f, 187.228104f, 37.229279f,   
35.061745f, 192.138824f, 25.004805f,   22.854788f, 198.428818f, 11.491251f,   7.707860f, 204.528030f, -1.010743f,   -10.330705f, 211.319122f, -12.287382f,   -30.732180f, 215.904266f, -22.387665f,   
-51.504055f, 218.295090f, -30.465851f,   -70.707466f, 218.500259f, -36.661552f,   -86.316925f, 216.460815f, -42.594631f,   -98.251823f, 212.312256f, -48.833935f,   -107.826233f, 208.844299f, -53.958839f,   
-115.878159f, 205.681152f, -57.785740f,   -122.553688f, 204.579254f, -61.286308f,   -128.348831f, 204.874634f, -64.511429f,   -133.688248f, 205.461029f, -67.560883f,   -138.931274f, 207.532669f, -70.586205f,   
-144.170288f, 212.304596f, -73.700706f,   -148.571594f, 219.757309f, -75.661316f,   -152.150558f, 225.120438f, -76.621117f,   -156.751892f, 228.595154f, -78.233925f,   -165.623016f, 229.667465f, -80.482170f,   
-176.930695f, 227.296555f, -80.834541f,   -185.580276f, 222.958557f, -80.129288f,   -190.862656f, 220.284821f, -79.777176f,   -194.513474f, 217.548416f, -79.005203f,   -196.937714f, 214.830322f, -78.812027f,   
-198.906830f, 212.168091f, -80.123878f,   -201.219254f, 209.590088f, -83.410027f,   -204.421524f, 207.124283f, -88.678314f,   -208.486572f, 204.793884f, -95.337303f,   -213.007034f, 202.629532f, -102.569794f,   
-217.814560f, 200.666824f, -110.097984f,   -222.638077f, 198.941330f, -117.720757f,   -227.142685f, 197.483261f, -125.330650f,   -229.852478f, 196.223160f, -132.361252f,   -230.863266f, 195.191666f, -139.478088f,   
-232.478699f, 194.649414f, -147.947556f,   -235.748398f, 197.782867f, -157.999863f,   -239.825180f, 204.179413f, -168.864182f,   -244.232346f, 208.819824f, -179.994095f,   -249.419922f, 213.388763f, -193.076218f,   
-255.673462f, 215.892929f, -207.866928f,   -262.200714f, 216.071472f, -221.072784f,   -267.822662f, 214.554169f, -231.428040f,   -272.569275f, 212.500473f, -241.317017f,   -278.102966f, 210.903061f, -252.286179f,   
-285.943359f, 212.590500f, -264.531921f,   -294.994080f, 216.707184f, -277.098633f,   -303.322968f, 218.662766f, -289.215302f,   -310.940979f, 218.107895f, -300.418915f,   -318.602417f, 215.104462f, -311.021149f,   
-325.236084f, 210.645340f, -321.387024f,   -330.952301f, 206.617004f, -331.609283f,   -336.688416f, 200.524246f, -341.921112f,   -342.374756f, 197.891464f, -352.427124f,   -348.240509f, 201.325211f, -363.271027f,   
-354.532166f, 207.032013f, -374.593353f,   -361.756317f, 211.235672f, -386.982452f,   -369.780273f, 214.968475f, -401.174683f,   -378.109314f, 216.435547f, -416.280426f,   -386.352386f, 215.475204f, -430.479004f,   
-394.052460f, 212.029358f, -442.471649f,   -401.387451f, 206.318176f, -451.880432f,   -408.876923f, 201.681488f, -459.774689f,   -417.050415f, 197.486145f, -467.716217f,   -426.375824f, 194.628876f, -475.856659f,   
-437.456635f, 194.026093f, -484.254456f,   -449.716064f, 193.267914f, -492.455841f,   -461.758148f, 193.616714f, -499.914307f,   -472.056305f, 193.899124f, -506.322021f,   -479.690094f, 192.923218f, -511.681183f,   
-485.746185f, 189.175262f, -516.117981f,   -491.551605f, 183.605118f, -519.771484f,   -497.914734f, 178.694580f, -522.957520f,   -505.481049f, 176.959686f, -525.973877f,   -513.981323f, 178.190536f, -528.919495f,   
-522.572388f, 180.320084f, -531.847107f,   -530.928528f, 183.068375f, -534.742859f,   -538.640930f, 186.264389f, -537.476990f,   -545.817688f, 189.737381f, -539.770142f,   -552.650940f, 193.319809f, -541.346863f,   
-558.766113f, 196.851013f, -542.258850f,   -563.798157f, 200.178680f, -542.699341f,   -567.427551f, 203.159790f, -542.964417f,   -569.065979f, 205.664551f, -543.207275f,   -568.554321f, 207.559006f, -543.704956f,   
-566.345398f, 208.666565f, -544.792236f,   -563.042664f, 208.963272f, -546.508972f,   -559.250854f, 208.529160f, -548.714722f,   -555.015686f, 207.449066f, -551.029175f,   -550.241821f, 205.811172f, -553.110168f,   
-545.261108f, 203.701797f, -554.874878f,   -540.407410f, 201.158890f, -556.352600f,   -535.986938f, 198.232346f, -557.688354f,   -532.261108f, 195.029678f, -559.122437f,   -529.326965f, 191.665176f, -560.586365f,   
-526.664001f, 188.217926f, -561.572815f,   -523.981506f, 184.739822f, -561.908203f,   -521.410339f, 181.297256f, -561.861511f,   -519.063049f, 177.966431f, -561.742188f,   -517.208862f, 174.843246f, -561.622925f,   
-515.834045f, 172.033035f, -561.534058f,   -514.705322f, 169.622070f, -561.501831f,   -513.786682f, 167.697784f, -561.475037f,   -513.039063f, 166.426300f, -561.408630f,   -512.419800f, 165.820297f, -561.265015f,   
-511.883728f, 165.739075f, -561.013245f,   -511.426086f, 166.045135f, -560.656616f,   -511.061035f, 166.600082f, -560.257874f,   -510.769897f, 167.263794f, -559.884399f,   -510.507355f, 167.883667f, -559.469299f,   
-510.207672f, 168.313980f, -559.001953f,   -509.853638f, 168.424210f, -558.619385f,   -509.446320f, 168.264969f, -558.233154f,   -508.998657f, 168.007111f, -557.729492f,   -508.522369f, 167.699142f, -557.187988f,   
-508.112427f, 167.377838f, -556.886292f,   -507.726898f, 167.071930f, -556.604065f,   -507.162445f, 166.818878f, -555.679138f,   -506.446533f, 166.662750f, -554.189575f,   -505.735016f, 166.648499f, -552.644226f,   
-505.029480f, 166.815216f, -551.044312f,   -504.332520f, 167.151733f, -549.391235f,   -503.648193f, 167.606308f, -547.686401f,   -502.982025f, 168.157059f, -545.931458f,   -502.341095f, 168.782227f, -544.127258f,   
-501.694946f, 169.460022f, -542.008911f,   -501.023499f, 170.168564f, -539.365662f,   -500.353973f, 170.886139f, -536.278931f,   -499.718079f, 171.590927f, -532.827576f,   -499.397247f, 172.260452f, -529.748108f,   
-499.658356f, 172.871658f, -527.452454f,   -500.510071f, 173.401855f, -525.517090f,   -501.901978f, 173.828354f, -523.523071f,   -503.582092f, 174.109497f, -520.644958f,   -505.246857f, 173.282822f, -516.355530f,   
-506.707336f, 171.618164f, -510.736053f,   -507.777069f, 170.920166f, -503.936951f,   -508.086456f, 171.321701f, -494.340057f,   -507.667969f, 171.770767f, -481.981598f,   -506.907501f, 172.294571f, -469.583435f,   
-506.229218f, 172.905914f, -459.544312f,   -505.887299f, 173.607559f, -451.859100f,   -505.700531f, 174.411697f, -444.989777f,   -505.541260f, 175.319733f, -438.652496f,   -505.211334f, 176.333969f, -432.495697f,   
-504.382172f, 177.470825f, -426.073029f,   -502.722626f, 178.748337f, -418.969696f,   -500.249817f, 180.191589f, -411.306763f,   -496.489349f, 182.235764f, -402.875153f,   -490.883667f, 185.070587f, -393.225922f,   
-482.375854f, 188.407669f, -381.452148f,   -471.584839f, 191.892822f, -367.001892f,   -461.360138f, 195.091095f, -351.287750f,   -453.618530f, 197.587585f, -336.915283f,   -447.684723f, 199.502380f, -324.553497f,   
-442.516754f, 201.204758f, -313.534119f,   -437.932312f, 202.680313f, -303.831940f,   -433.713593f, 203.921280f, -294.743042f,   -429.886658f, 204.914703f, -286.356445f,   -426.486969f, 205.647919f, -278.749756f,   
-423.559570f, 206.108154f, -271.990997f,   -421.158722f, 206.374298f, -266.140594f,   -419.346771f, 206.541336f, -261.252960f,   -418.194214f, 206.620941f, -257.377991f,   -417.423676f, 206.624405f, -254.193283f,   
-416.686920f, 206.562973f, -251.298203f,   -415.958099f, 206.447845f, -248.622406f,   -414.558044f, 206.287430f, -246.562820f,   -412.287079f, 206.087936f, -245.346664f,   -409.870178f, 205.857162f, -244.704453f,   
-407.997223f, 205.605911f, -244.311203f,   -406.797363f, 205.364914f, -243.741531f,   -405.906769f, 205.160263f, -242.939911f,   -405.218964f, 204.989365f, -242.138626f,   -404.693756f, 204.856674f, -241.368347f,   
-404.296143f, 204.766968f, -240.657578f,   -403.994873f, 204.667923f, -240.031693f,   -403.761780f, 204.527771f, -239.511719f,   -403.589630f, 204.388214f, -239.071243f,   -403.482483f, 204.294724f, -238.662567f,   
-403.431763f, 204.244492f, -238.272415f,   -403.428925f, 204.205566f, -237.887848f,   -403.465118f, 204.176224f, -237.496185f,   -403.531647f, 204.154617f, -237.085159f,   -403.691254f, 204.138855f, -236.717087f,   
-403.996216f, 204.126282f, -236.454315f,   -404.355713f, 204.113983f, -236.187088f,   -404.714569f, 204.099243f, -235.856613f,   -405.101929f, 204.078491f, -235.522125f,   -405.548065f, 204.048203f, -235.240280f,   
-406.082153f, 204.011154f, -235.067291f,   -406.731628f, 203.971680f, -235.059372f,   -407.493469f, 203.929611f, -235.221848f,   -408.320038f, 203.885635f, -235.491318f,   -409.170807f, 203.840302f, -235.821365f,   
-410.004333f, 203.794144f, -236.166824f,   -410.777802f, 203.747650f, -236.483902f,   -411.447418f, 203.701263f, -236.729675f,   -411.953339f, 203.654053f, -236.894745f,   -412.291473f, 203.605515f, -236.996475f,   
-412.502533f, 203.557037f, -237.031464f,   -412.626770f, 203.509964f, -236.996780f,   -412.703949f, 203.465530f, -236.890335f,   -412.788116f, 203.425125f, -236.765610f,   -412.955627f, 203.390656f, -236.676682f,   
-413.204834f, 203.361008f, -236.614349f,   -413.482788f, 203.332947f, -236.566803f,   -413.772919f, 203.302917f, -236.535706f,   -414.058075f, 203.267929f, -236.522629f,   -414.335022f, 203.228348f, -236.520920f,   
-414.613617f, 203.186996f, -236.518723f,   -414.896423f, 203.144943f, -236.510361f,   -415.186005f, 203.103149f, -236.490417f,   -415.484833f, 203.062485f, -236.453827f,   -415.484833f, 203.062485f, -236.453827f,   

_NULL_ }; /* End of camera01_pTarget */

const float camera01_pFOV[] = {
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   
0.785398f,   0.785398f,   0.785398f,   0.785398f,   0.785398f,   

_NULL_ }; /* End of camera01_pFOV */

#define camera01_NumFrames  244



/**********************************************************
 * CAMERA ANIMATION 
 **********************************************************/

const Struct_CameraAnimation 
   CameraAnimation[NUM_CAMERAS] = {

/* CAMERA ANIMATION 0 */
	/* NumFrames      */ camera01_NumFrames,
	/* Position       */  camera01_pPosition,
	/* Target         */  camera01_pTarget,
	/* FOV            */  camera01_pFOV

	}; /* End of Camera Animation */