#--------------------------------------------------------------------------
# Name         : maketex.mak
# Title        : Makefile to build textures
# Author       : PowerVR
# Created      : 13/01/2005
#
# Copyright    : 2005 by Imagination Technologies.  All rights reserved.
#              : No part of this software, either material or conceptual 
#              : may be copied or distributed, transmitted, transcribed,
#              : stored in a retrieval system or translated into any 
#              : human or computer language in any form by any means,
#              : electronic, mechanical, manual or other-wise, or 
#              : disclosed to third parties without the express written
#              : permission of VideoLogic Limited, Unit 8, HomePark
#              : Industrial Estate, King's Langley, Hertfordshire,
#              : WD4 8LZ, U.K.
#
# Description  : Makefile for demos in the PowerVR SDK
#
# Platform     :
#
# $Revision: 1.4 $
#--------------------------------------------------------------------------

#############################################################################
## Variables
#############################################################################

TEXTURESPATH = ./../Media
TEXTUREFILES = \
	FloorToon.h \
	MouseToon.h \
	Toon.h \
	WallToon.h

#############################################################################
## Instructions
#############################################################################

all:	$(TEXTUREFILES)

$(TEXTUREFILES): $(TEXTURESPATH)/$(@:.h=.bmp)
	$(PVRTEXTURETOOLPATH) -nt -m -h -fOGL565 -i$(TEXTURESPATH)/$(@:.h=.bmp) -o$@
	
############################################################################
# End of file (maketex.mak)
############################################################################