# Usage: bash ./pakconvert.sh c:/q3a


if [ -z "$1" ]; then
	echo "Usage: pakconvert <path to quake 3 installation>"
	exit
fi

if [ ! -d $1/baseq3 ]; then
	echo "Usage: pakconvert <path to quake 3 installation>"
	echo "$1 is not a valid Quake 3 installation directory!"
	exit
fi

if [ ! -e $1/baseq3/pak0.pk3 ]; then
	echo "Usage: pakconvert <path to quake 3 installation>"
	echo "There are no .pk3 files in the baseq3 folder. Corrupt installation!"
	exit
fi

# Create working directory for pak file manipulation
if [ -d ./paktemp ]; then
	echo "(cleaning up paktemp)"
	./rm -rf ./paktemp
fi
	
./mkdir paktemp

# Unzip all of the pk3 files from the destination into this directory, in order, overwriting
echo "1. Extracting .pk3 files..."

if [ -e $1/baseq3/pak0.pk3 ]; then ./unzip -q -o $1/baseq3/pak0.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak1.pk3 ]; then ./unzip -q -o $1/baseq3/pak1.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak2.pk3 ]; then ./unzip -q -o $1/baseq3/pak2.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak3.pk3 ]; then ./unzip -q -o $1/baseq3/pak3.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak4.pk3 ]; then ./unzip -q -o $1/baseq3/pak4.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak5.pk3 ]; then ./unzip -q -o $1/baseq3/pak5.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak6.pk3 ]; then ./unzip -q -o $1/baseq3/pak6.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak7.pk3 ]; then ./unzip -q -o $1/baseq3/pak7.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak8.pk3 ]; then ./unzip -q -o $1/baseq3/pak8.pk3 -d paktemp; fi
if [ -e $1/baseq3/pak9.pk3 ]; then ./unzip -q -o $1/baseq3/pak9.pk3 -d paktemp; fi

# Remove things we aren't going to pak up
echo "2. Removing unnecessary components..."
./rm -rf paktemp/vm
#./rm -rf paktemp/music
./rm -rf paktemp/demos

# Convert all images down to half size
echo "3. Resizing images..."

./cp paktemp/gfx/colors/black.jpg ./black.jpg
./cp paktemp/menu/art/font1_prop.tga ./font1_prop.tga
./cp paktemp/menu/art/font1_prop_glo.tga ./font1_prop_glo.tga
./cp paktemp/menu/art/font2_prop.tga ./font2_prop.tga

./find paktemp -iname \*.jpg -print -exec ./convert {} -scale 50% {} \;
./find paktemp -iname \*.tga -print -exec ./convert {} -scale 50% {} \;

./cp ./black.jpg paktemp/gfx/colors/black.jpg
./cp ./font1_prop.tga paktemp/menu/art/font1_prop.tga 
./cp ./font1_prop_glo.tga paktemp/menu/art/font1_prop_glo.tga 
./cp ./font2_prop.tga paktemp/menu/art/font2_prop.tga 

./rm ./black.jpg
./rm ./font1_prop.tga
./rm ./font1_prop_glo.tga
./rm ./font2_prop.tga

# Encoding audio
echo "4. Encoding audio..."
for x in `./find paktemp/sound | ./grep .wav | ./cut -d . -f 1`; do ./ffmpeg -i $x.wav -acodec mp3 -ar 22050 -ac 1 $x.mp3; done
for x in `./find paktemp/sound | ./grep .wav | ./cut -d . -f 1`; do ./rm $x.wav; done
for x in `./find paktemp/music | ./grep .wav | ./cut -d . -f 1`; do ./ffmpeg -i $x.wav -acodec mp3 -ar 22050 -ac 1 $x.mp3; done
for x in `./find paktemp/music | ./grep .wav | ./cut -d . -f 1`; do ./rm $x.wav; done

# Encode full-screen videos
echo "5. Encoding video...."
for x in `./ls -1 paktemp/video/*.RoQ | ./cut -d . -f 1`; do ./ffmpeg -i $x.RoQ -s 240x120 -b 64 -acodec mp3 -vcodec mpeg4 $x.avi; done
./rm paktemp/video/*.RoQ

# Re-pak files
echo "6. Recompressing .pk3 file..."
cd paktemp
#../7za a -tzip -mx=9 ..\\..\\baseq3\\pak0.pk3
../zip -r -9 ../../baseq3/pak0.pk3 *
cd ..

# Cleanup paktemp
echo "7. Cleaning up..."
./rm -rf ./paktemp

# Done!
echo ".pk3 conversion complete."
