/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class RPGSprite {
    public static final int ACTION_HEADER_SIZE = 4;
    public static final int ACTION_SEQUENCE_DELAY_BIT = 2;
    public static final int ACTION_SEQUENCE_LENGTH_BIT = 1;
    public static final int ACTION_TRANSFORM_BIT = 3;
    public static final int ANTICLOCKWISE_90 = 0;
    public static final int COLLISION_INCLUSION = 2;
    public static final int COLLISION_INTERSECT = 1;
    public static final int DEASIL_90 = 1;
    public static final int DIRECTION_DOWN = 2;
    public static final int DIRECTION_LEFT = 3;
    public static final int DIRECTION_NONE = 0;
    public static final int DIRECTION_RIGHT = 4;
    public static final int DIRECTION_UP = 1;
    public static final int FRAME_BOTTOM_POS_BIT = 5;
    public static final int FRAME_COLLISION_COUNT_BIT = 2;
    public static final int FRAME_HEADER_SIZE = 8;
    public static final int FRAME_LEFT_POS_BIT = 6;
    public static final int FRAME_REFERENCE_POINT_COUNT_BIT = 3;
    public static final int FRAME_RIGHT_POS_BIT = 7;
    public static final int FRAME_TILE_COUNT_BIT = 1;
    public static final int FRAME_TOP_POS_BIT = 4;
    public static final int HORIZONTAL = 2;
    public static final int INVERTED_AXES = 4;
    public static final int SPX_BYTE_SEQUENCE_JAVA = 1;
    public static final int SPX_HEADER = 1397772888;
    public static final int SPX_VERSION = 34;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_ROT90 = 5;
    public static final int VERTICAL = 3;
    protected int X;
    protected int Y;
    int actionCount;
    short[][] actionData;
    int actionIndex;
    protected int[] currentActionList;
    protected int dailogY = 10;
    int delay;
    int frameCount;
    short[][] frameData;
    public Image headImage;
    protected int height;
    protected int moveFrameIndex = 3;
    int originOffsetX;
    int originOffsetY;
    int sequenceIndex;
    protected int state;
    int tileCount;
    short[][] tileData;
    boolean tileMode;
    int[] tileUseCounter;
    protected int type;
    protected boolean visible = false;
    private int waitTime;
    protected int width;

    public abstract void Run();

    protected boolean allowInit() {
        return this.visible;
    }

    public static boolean checkAnchor(int anchor, int illegal_vpos) {
        int n;
        boolean right;
        if (anchor == 0) {
            return true;
        }
        boolean bl = right = anchor > 0 && anchor < 128 && (anchor & illegal_vpos) == 0;
        if (right) {
            n = anchor & 0x72;
            right = n != 0 && (n & n - 1) == 0;
        }
        if (right) {
            n = anchor & 0xD;
            right = n != 0 && (n & n - 1) == 0;
        }
        return right;
    }

    final boolean collidesSelf(RPGSprite rs1, RPGSprite rs2) {
        return rs1.Y <= rs2.Y - rs2.height && rs1.Y - rs1.height <= rs2.Y && rs1.X + rs1.width >= rs2.X && rs1.X <= rs2.X + rs2.width;
    }

    public boolean collidesWith(int x, int y, int width, int height) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(x, y, width, height, 0, 1);
    }

    public boolean collidesWith(Image image, int x, int y) {
        if (!this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(image, x, y, 0, 1);
    }

    public boolean collidesWith(int x, int y, int width, int height, int collides, int type) {
        if (!this.visible) {
            return false;
        }
        int x1 = this.getCollidesX(collides);
        int y1 = this.getCollidesY(collides);
        int w1 = this.getCollidesWidth(collides);
        int h1 = this.getCollidesHeight(collides);
        if (type == 1) {
            return RPGSprite.intersectRect(x1, y1, w1, h1, x, y, width, height);
        }
        if (type == 2) {
            return RPGSprite.inclusionRect(x1, y1, w1, h1, x, y, width, height);
        }
        throw new ArithmeticException();
    }

    public boolean collidesWith(Image image, int x, int y, int collides, int type) {
        return this.collidesWith(x, y, image.getWidth(), image.getHeight(), collides, type);
    }

    public boolean collidesWith(RPGSprite spx, int spxCollides, int thisCollides, int type) {
        int height;
        int width;
        int y;
        int x;
        if (!spx.visible || !this.visible) {
            return false;
        }
        try {
            x = spx.getCollidesX(spxCollides);
            y = spx.getCollidesY(spxCollides);
            width = spx.getCollidesWidth(spxCollides);
            height = spx.getCollidesHeight(spxCollides);
        }
        catch (Exception e) {
            return false;
        }
        return this.collidesWith(x, y, width, height, thisCollides, type);
    }

    public boolean collidesWith(RPGSprite spx) {
        if (!spx.visible || !this.visible) {
            return false;
        }
        if (this.getCollidesCount() == 0 || spx.getCollidesCount() == 0) {
            return false;
        }
        return this.collidesWith(spx, 0, 0, 1);
    }

    public abstract void dispose();

    public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public static void drawRegionMIDP1(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        if (g == null || src == null) {
            throw new NullPointerException();
        }
        if (!RPGSprite.checkAnchor(anchor, 64)) {
            throw new IllegalArgumentException();
        }
        if (transform < 0 || transform > 7) {
            throw new IllegalArgumentException();
        }
        if (width < 0 || height < 0 || x_src < 0 || y_src < 0 || x_src + width > src.getWidth() || y_src + height > src.getHeight()) {
            throw new IllegalArgumentException();
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if ((4 & transform) != 0) {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= width;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= height;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= height / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= width / 2;
                }
            }
            g.clipRect(x_dest, y_dest, height, width);
        } else {
            if (anchor != 0) {
                if ((anchor & 0x20) != 0) {
                    y_dest -= height;
                }
                if ((anchor & 8) != 0) {
                    x_dest -= width;
                }
                if ((anchor & 1) != 0) {
                    x_dest -= width / 2;
                }
                if ((anchor & 2) != 0) {
                    y_dest -= height / 2;
                }
            }
            g.clipRect(x_dest, y_dest, width, height);
        }
        int x_offset = 0;
        int y_offset = 0;
        int srcWidth = src.getWidth();
        int srcHeight = src.getHeight();
        switch (transform) {
            case 0: {
                g.drawImage(src, x_dest - x_src, y_dest - y_src, 4 | 0x10);
                g.setClip(clipX, clipY, clipWidth, clipHeight);
                return;
            }
            case 5: {
                x_offset = srcHeight - (y_src + height);
                y_offset = x_src;
                break;
            }
            case 3: {
                x_offset = srcWidth - (x_src + width);
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 6: {
                x_offset = y_src;
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 2: {
                x_offset = srcWidth - (x_src + width);
                y_offset = y_src;
                break;
            }
            case 7: {
                x_offset = srcHeight - (y_src + height);
                y_offset = srcWidth - (x_src + width);
                break;
            }
            case 1: {
                x_offset = x_src;
                y_offset = srcHeight - (y_src + height);
                break;
            }
            case 4: {
                x_offset = y_src;
                y_offset = x_src;
            }
        }
        x_dest -= x_offset;
        y_dest -= y_offset;
        int clipX1 = g.getClipX();
        int clipY1 = g.getClipY();
        int clipX2 = g.getClipX() + g.getClipWidth();
        int clipY2 = g.getClipY() + g.getClipHeight();
        if ((4 & transform) != 0) {
            int temp = srcWidth;
            srcWidth = srcHeight;
            srcHeight = temp;
        }
        int src_start_x = Math.max(0, clipX1 - x_dest);
        int src_start_y = Math.max(0, clipY1 - y_dest);
        int dest_start_x = Math.max(clipX1, x_dest);
        int dest_start_y = Math.max(clipY1, y_dest);
        int dest_right = x_dest + srcWidth;
        int dest_bottom = y_dest + srcHeight;
        int copy_width = srcWidth - src_start_x;
        int copy_height = srcHeight - src_start_y;
        copy_width -= Math.max(0, dest_right - clipX2);
        copy_height -= Math.max(0, dest_bottom - clipY2);
        int px = 0;
        int py = 0;
        int i = 0;
        while (i < copy_height) {
            int j = 0;
            while (j < copy_width) {
                switch (transform) {
                    case 5: {
                        px = src_start_y + i;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 3: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 6: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = src_start_x + j;
                        break;
                    }
                    case 2: {
                        px = srcWidth - 1 - j - src_start_x;
                        py = src_start_y + i;
                        break;
                    }
                    case 7: {
                        px = srcHeight - 1 - i - src_start_y;
                        py = srcWidth - 1 - j - src_start_x;
                        break;
                    }
                    case 1: {
                        px = src_start_x + j;
                        py = srcHeight - 1 - i - src_start_y;
                        break;
                    }
                    case 4: {
                        px = src_start_y + i;
                        py = src_start_x + j;
                    }
                }
                g.setClip(dest_start_x + j, dest_start_y + i, 1, 1);
                g.drawImage(src, dest_start_x + j - px, dest_start_y + i - py, 4 | 0x10);
                ++j;
            }
            ++i;
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public abstract void drawSprite(Graphics var1, boolean var2);

    public int getCollidesCount() {
        return this.frameData[this.getSequenceFrame()][2];
    }

    public int getCollidesCount(int index) {
        return this.frameData[index][2];
    }

    public int getCollidesHeight(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesHeight(frameIndex, index);
    }

    public int getCollidesHeight(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 3;
        return this.frameData[frame][offset];
    }

    public int getCollidesWidth(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesWidth(frameIndex, index);
    }

    public int getCollidesWidth(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 2;
        return this.frameData[frame][offset];
    }

    public int getCollidesX(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesX(frameIndex, index);
    }

    public int getCollidesX(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4;
        return this.frameData[frame][offset] + this.X;
    }

    public int getCollidesY(int index) {
        int frameIndex = this.getSequenceFrame();
        return this.getCollidesY(frameIndex, index);
    }

    public int getCollidesY(int frame, int index) {
        if (index < 0 || index >= this.frameData[frame][2]) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int offset = 8 + this.frameData[frame][1] * 4 + index * 4 + 1;
        return this.frameData[frame][offset] + this.Y;
    }

    protected int getHeight() {
        return this.height;
    }

    public int getSequenceFrame() {
        if (this.isDelay()) {
            return this.actionData[this.actionIndex][4 + this.sequenceIndex * 2];
        }
        return this.actionData[this.actionIndex][4 + this.sequenceIndex];
    }

    protected int getType() {
        return this.type;
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getX() {
        return this.X;
    }

    protected int getY() {
        return this.Y;
    }

    public static boolean inclusionRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 >= y1 && y2 + height2 <= y1 + height1 && x2 >= x1 && x2 + width2 <= x1 + width1;
    }

    public static boolean intersectRect(int x1, int y1, int width1, int height1, int x2, int y2, int width2, int height2) {
        return y2 + height2 >= y1 && y2 <= y1 + height1 && x2 + width2 >= x1 && x2 <= x1 + width1;
    }

    public boolean isDelay() {
        return this.actionData[this.actionIndex][2] == 1;
    }

    public void loadSpx(String spxName) {
        try {
            int j;
            int offset;
            int length;
            int i;
            InputStream is = spxName.getClass().getResourceAsStream(spxName);
            DataInputStream data = new DataInputStream(is);
            int header = data.readInt();
            if (header != 1397772888) {
                throw new Exception("invalid SpriteX format\n");
            }
            byte version = data.readByte();
            if (version != 34) {
                throw new Exception("version no matching\n");
            }
            byte byteSequence = data.readByte();
            if ((byteSequence & 1) != 1) {
                throw new Exception("byte sequence error\n");
            }
            if ((byteSequence & 2) != 0) {
                this.tileMode = true;
            }
            this.tileCount = data.readInt();
            if (!this.tileMode) {
                this.tileData = new short[this.tileCount][4];
                i = 0;
                while (i < this.tileCount) {
                    this.tileData[i][0] = data.readShort();
                    this.tileData[i][1] = data.readShort();
                    this.tileData[i][2] = data.readShort();
                    this.tileData[i][3] = data.readShort();
                    ++i;
                }
            }
            this.frameCount = data.readInt();
            this.frameData = new short[this.frameCount][];
            i = 0;
            while (i < this.frameCount) {
                int frameTileCount = data.readInt();
                int collisionCount = data.readInt();
                int referencePointCount = data.readInt();
                length = 8 + frameTileCount * 4 + collisionCount * 4 + referencePointCount * 2;
                this.frameData[i] = new short[length];
                this.frameData[i][0] = (short)length;
                this.frameData[i][1] = (short)frameTileCount;
                this.frameData[i][2] = (short)collisionCount;
                this.frameData[i][3] = (short)referencePointCount;
                this.frameData[i][4] = data.readShort();
                this.frameData[i][5] = data.readShort();
                this.frameData[i][6] = data.readShort();
                this.frameData[i][7] = data.readShort();
                offset = 8;
                j = 0;
                while (j < frameTileCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                    ++j;
                }
                j = 0;
                while (j < collisionCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    this.frameData[i][2 + offset] = data.readShort();
                    this.frameData[i][3 + offset] = data.readShort();
                    offset += 4;
                    ++j;
                }
                j = 0;
                while (j < referencePointCount) {
                    this.frameData[i][0 + offset] = data.readShort();
                    this.frameData[i][1 + offset] = data.readShort();
                    offset += 2;
                    ++j;
                }
                ++i;
            }
            this.actionCount = data.readInt();
            this.actionData = new short[this.actionCount][];
            i = 0;
            while (i < this.actionCount) {
                int sequenceLength = data.readInt();
                byte delay = data.readByte();
                length = delay == 1 ? 4 + sequenceLength * 2 : 4 + sequenceLength;
                this.actionData[i] = new short[length];
                this.actionData[i][0] = (short)length;
                this.actionData[i][1] = (short)sequenceLength;
                this.actionData[i][2] = delay;
                this.actionData[i][3] = (short)data.readInt();
                offset = 4;
                if (delay == 1) {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        this.actionData[i][offset + 1] = data.readShort();
                        offset += 2;
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < sequenceLength) {
                        this.actionData[i][offset] = data.readShort();
                        ++offset;
                        ++j;
                    }
                }
                ++i;
            }
            this.visible = true;
            is.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g, Image im) {
        this.paint(g, this.X, this.Y, im);
    }

    public void paint(Graphics g, int x, int y, Image image) {
        if (g == null) {
            throw new NullPointerException();
        }
        if (this.visible) {
            x -= this.originOffsetX;
            y -= this.originOffsetY;
            int clipX = g.getClipX();
            int clipY = g.getClipY();
            int clipWidth = g.getClipWidth();
            int clipHeight = g.getClipHeight();
            int frameIndex = this.getSequenceFrame();
            int tileCount = this.frameData[frameIndex][1];
            int offset = 8;
            int i = 0;
            while (i < tileCount) {
                short ty;
                short tx;
                short transform;
                int dy;
                int dx;
                short tileIndex;
                if (this.tileMode) {
                    tileIndex = this.frameData[frameIndex][0 + offset];
                    dx = this.frameData[frameIndex][1 + offset] + x;
                    dy = this.frameData[frameIndex][2 + offset] + y;
                    transform = this.frameData[frameIndex][3 + offset];
                    tx = 0;
                    ty = 0;
                } else {
                    tileIndex = this.frameData[frameIndex][0 + offset];
                    dx = this.frameData[frameIndex][1 + offset] + x;
                    dy = this.frameData[frameIndex][2 + offset] + y;
                    transform = this.frameData[frameIndex][3 + offset];
                    tx = this.tileData[tileIndex][0];
                    ty = this.tileData[tileIndex][1];
                    short tw = this.tileData[tileIndex][2];
                    short th = this.tileData[tileIndex][3];
                    if (RPGSprite.intersectRect(dx, dy, tw, th, clipX, clipY, clipWidth, clipHeight)) {
                        RPGSprite.drawRegion(g, image, tx, ty, tw, th, transform, dx, dy, 20);
                    }
                }
                offset += 4;
                ++i;
            }
        }
    }

    protected void reset() {
        this.visible = false;
    }

    protected void runFrame(int waitTime) {
        if (this.waitFrame(waitTime)) {
            ++this.moveFrameIndex;
            if (this.moveFrameIndex >= this.currentActionList.length) {
                this.moveFrameIndex = 0;
            }
            this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
        }
    }

    protected void setType(byte t) {
        this.type = t;
    }

    protected void setX(int x) {
        this.X = (short)x;
    }

    protected void setY(int y) {
        this.Y = (short)y;
    }

    protected boolean waitFrame(int t) {
        ++this.waitTime;
        if (this.waitTime >= t) {
            this.waitTime = 0;
            return true;
        }
        return false;
    }
}

