/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RoleSprite
extends RPGSprite {
    public static final int ADDSP = 4;
    public static final int AUTOFIRE = 11;
    public static final int DEAD = 5;
    public static final int DEFANES = 6;
    public static final int FIRE = 3;
    public static final int RIGHT = 2;
    public static final int SP1 = 9;
    public static final int SP2 = 12;
    public static final int SQUEENLEFT = 7;
    public static final int SQUEENRIGHT = 8;
    public static final int STARTMOVE = 10;
    public static final int STILL = 0;
    public static final int STILL_ACTION = 1;
    public int act;
    private boolean actPowUp;
    private Vector allKill;
    private int dailogTime;
    private int danger;
    private int def;
    private boolean defPowUp;
    private int defTime;
    private String[] dialog;
    private int dialogIndex;
    private int emyIndex;
    private GameWorld gw;
    private byte hitFrame;
    public int hp;
    private Image img;
    private boolean isByKill;
    private boolean isShowDialog;
    protected boolean ismove = true;
    private int maxAct;
    public int maxDailogTime;
    private int maxHp;
    private int minAct;
    private int moveCount;
    private int moveSpeed;
    private int powUpTime;
    private int selfIndex;
    private int startX;
    private int stopTime;
    private int targetX;

    public RoleSprite(int t, int x, int y, int index, GameWorld e) {
        this.selfIndex = index;
        this.gw = e;
        this.allKill = new Vector();
        this.visible = true;
        this.moveSpeed = 1;
        this.type = (byte)t;
        this.loadSpx("/Image/role" + t + ".cc");
        this.img = GameInterface.loadImage("role" + t);
        this.changeState(0);
        this.X = x;
        this.Y = y;
        this.width = 25;
        this.height = 25;
        this.setProperty(this.type);
    }

    public void Run() {
        if (this.visible) {
            switch (this.state) {
                case 0: {
                    this.runStop0();
                    break;
                }
                case 1: {
                    this.runStop();
                    break;
                }
                case 2: {
                    this.runRight();
                    break;
                }
                case 3: {
                    this.runAction();
                    break;
                }
                case 4: {
                    this.runByAction();
                    break;
                }
                case 5: {
                    this.runDead();
                    break;
                }
                case 6: {
                    this.runDef();
                    break;
                }
                case 7: {
                    this.runChangeSqueeLeft();
                    break;
                }
                case 8: {
                    this.runChangeSqueeRight();
                    break;
                }
                case 9: {
                    this.runSp1();
                    break;
                }
                case 10: {
                    this.runStartMove();
                    break;
                }
                case 11: {
                    this.searchEmy();
                    break;
                }
                case 12: {
                    this.runSp2();
                }
            }
        }
        if (this.isShowDialog) {
            ++this.dailogTime;
            if (this.dailogTime > this.maxDailogTime) {
                this.dailogTime = 0;
                ++this.dialogIndex;
                if (this.dialogIndex >= this.dialog.length) {
                    this.dialogIndex = 0;
                    this.isShowDialog = false;
                }
            }
        }
        if (this.actPowUp) {
            ++this.powUpTime;
            if (this.powUpTime >= 300) {
                this.powUpTime = 0;
                this.minAct -= 20;
                this.maxAct -= 20;
                this.actPowUp = false;
            }
        }
        if (this.defPowUp) {
            ++this.powUpTime;
            if (this.powUpTime >= 300) {
                this.powUpTime = 0;
                this.def -= 10;
                this.defPowUp = false;
            }
        }
        int i = 0;
        while (i < this.allKill.size()) {
            ((BgLayer)this.allKill.elementAt(i)).Run();
            ++i;
        }
    }

    final void actPowUp() {
        this.minAct += 20;
        this.maxAct += 20;
        this.powUpTime = 0;
        this.actPowUp = true;
    }

    final void addHp(int h) {
        this.hp += h;
        if (this.hp > this.maxHp) {
            this.hp = this.maxHp;
        }
    }

    final void cancelDailog() {
        this.dailogTime = this.maxDailogTime + 1;
    }

    final void changeQuee(int tx) {
        this.targetX = tx;
        if (this.X < this.targetX) {
            this.changeState(8);
        } else {
            this.changeState(7);
        }
    }

    final void changeState(int s) {
        this.stopTime = 0;
        block0 : switch (s) {
            case 0: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{9, 9, 9, 9, 24, 24, 24, 24};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{0, 0, 0, 0, 1, 1, 1, 1};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{3, 3, 3, 3, 4, 4, 4, 4};
                    }
                }
                break;
            }
            case 1: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{9, 9, 9, 10, 10, 10, 11, 11, 11, 11, 11, 12, 12, 12, 13, 13};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{0, 0, 0, 1, 1, 1, 2, 2, 2};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{10, 10, 10, 11, 11, 11, 10, 10, 10, 11, 11, 11, 11};
                    }
                }
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                this.moveCount = 0;
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{14, 14, 14, 15, 15, 15, 16, 16, 16, 15, 15, 15};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{4, 4, 4, 3, 3, 3, 5, 5, 5, 3, 3, 3};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{6, 6, 6, 7, 7, 7, 8, 8, 8, 7, 7, 7};
                    }
                }
                break;
            }
            case 3: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 6, 7, 8, 9};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{15, 16, 15, 16, 15, 16, 17, 17};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{0, 0, 1, 1, 12, 12, 13, 13};
                    }
                }
                break;
            }
            case 4: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{25, 26, 26, 25, 25, 26, 26, 26, 25, 26, 26, 26, 26, 26};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{12, 12, 13, 13};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{10, 11, 11, 10, 10, 11, 11, 11, 10, 11, 11, 11, 11, 11};
                    }
                }
                break;
            }
            case 5: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{18, 18, 19, 20, 20, 21, 22, 23};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{9, 9, 10, 10, 11, 11, 11, 11};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{14, 14, 14, 2, 2, 2, 2};
                    }
                }
                break;
            }
            case 6: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{17};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{14};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{9};
                    }
                }
                break;
            }
            case 7: 
            case 8: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{14, 14, 14, 15, 15, 15, 16, 16, 16, 15, 15, 15};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{4, 4, 4, 3, 3, 3, 5, 5, 5, 3, 3, 3};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{6, 6, 6, 7, 7, 7, 8, 8, 8, 7, 7, 7};
                    }
                }
                break;
            }
            case 9: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{0, 0, 1, 1, 2, 2, 27, 27, 27, 28, 28, 28, 29, 29, 29, 27, 27, 28, 28, 29, 29, 27, 28, 29, 27, 28, 29, 30, 30, 31, 31, 32, 32, 33, 34, 8};
                        break;
                    }
                    case 1: {
                        this.currentActionList = new int[]{15, 15, 16, 16, 15, 15, 16, 16, 15, 16, 15, 16, 17, 17, 18, 18, 19, 19, 20, 20};
                        break;
                    }
                    case 2: {
                        this.currentActionList = new int[]{15, 15, 16, 16, 15, 15, 16, 16, 15, 16, 15, 16, 17, 18, 18, 17, 18, 18, 17, 18, 19, 17, 20};
                    }
                }
                break;
            }
            case 12: {
                switch (this.type) {
                    case 0: {
                        this.currentActionList = new int[]{0, 0, 1, 1, 2, 2, 27, 27, 27, 28, 28, 28, 29, 29, 29, 27, 27, 28, 28, 29, 29, 27, 28, 29, 27, 28, 29, 30, 30, 31, 31, 32, 32, 33, 34, 8, 30, 30, 31, 31, 32, 32, 33, 34, 8, 30, 30, 31, 31, 32, 32, 33, 34, 8};
                        break block0;
                    }
                    case 1: {
                        this.currentActionList = new int[]{21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29};
                        break block0;
                    }
                    case 2: {
                        this.currentActionList = new int[]{21, 21, 22, 22, 21, 21, 22, 22, 21, 22, 21, 22, 23, 23, 24, 24, 25};
                    }
                }
            }
        }
        this.state = s;
        this.moveFrameIndex = 0;
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void computeAct() {
        this.act = GameInterface.getRandomNumber(this.minAct, this.maxAct + (this.gw.currentCombo + 3) / 3);
    }

    final int computeHPScale() {
        try {
            return this.hp * 37 / this.maxHp;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    final void defPowUp() {
        this.def += 10;
        this.powUpTime = 0;
        this.defPowUp = true;
    }

    public void dispose() {
    }

    public void drawSprite(Graphics g, boolean isShowTip) {
        if (this.visible) {
            this.paint(g, this.getLogicX(), this.Y, this.img);
            if (this.isShowDialog) {
                g.drawImage(this.gw.dailogImage, this.getLogicX(), this.Y - 85, 0);
                GameInterface.printText(g, this.dialog[this.dialogIndex], this.getLogicX() + 2, this.Y - 75, 12);
            }
            int i = 0;
            while (i < this.allKill.size()) {
                ((BgLayer)this.allKill.elementAt(i)).Paint(g);
                ++i;
            }
            if (this.actPowUp) {
                if (this.type == 2) {
                    g.drawImage(this.gw.actImage, this.getLogicX() - 7, this.Y - 55, 0);
                } else {
                    g.drawImage(this.gw.actImage, this.getLogicX(), this.Y - 55, 0);
                }
            }
            if (this.defPowUp) {
                if (this.type == 2) {
                    g.drawImage(this.gw.defImage, this.getLogicX() - 7, this.Y - 55, 0);
                } else {
                    g.drawImage(this.gw.defImage, this.getLogicX(), this.Y - 55, 0);
                }
            }
        }
    }

    final int getIndex() {
        return this.selfIndex;
    }

    final int getLogicX() {
        return this.X - this.gw.offsetIndex;
    }

    final boolean getShowDialog() {
        return this.isShowDialog;
    }

    final int getState() {
        return this.state;
    }

    final void killHp(int dan, int km) {
        this.danger = dan - dan * this.def / 10;
        if (dan * this.def % 10 >= 5) {
            ++this.danger;
        }
        if (this.danger <= 0) {
            this.danger = 1;
        }
        if (this.state == 6) {
            this.danger /= 2;
        }
        this.hp -= this.danger;
        this.isByKill = true;
        this.allKill.addElement(new BgLayer(this.gw.hitImage, this.X, this.Y - 35, 2, 4, this.allKill, this.danger, this.gw));
        this.allKill.addElement(new BgLayer(this.gw.numImage5, this.X, this.Y - 45, 3, 10, this.allKill, this.danger, this.gw));
        if (this.hp <= 0) {
            this.changeState(5);
        }
    }

    final void moveBack() {
        this.X -= this.moveSpeed;
        if (this.getLogicX() < 0) {
            this.X += this.moveSpeed;
        }
    }

    final void movePre() {
        if (this.getLogicX() >= GameInterface.SW / 3 + 30 && this.selfIndex == this.gw.maxOffsetIndex) {
            if (this.gw.allowMoveOffsetIndex) {
                ++this.gw.offsetIndex;
                if (this.gw.allowMoveOffsetArray) {
                    int i = 0;
                    while (i < this.gw.em.size()) {
                        if (this.gw.getEmy((int)i).type == 9 || this.gw.getEmy((int)i).type == 18 || this.gw.getEmy((int)i).type == 12 || this.gw.getEmy((int)i).type == 15) {
                            this.ismove = false;
                        }
                        ++i;
                    }
                    if (this.ismove) {
                        ++this.gw.offsetArray;
                    }
                }
            }
            ++this.gw.bgX2;
            if (this.gw.bgX2 > this.gw.mapBgWidth) {
                this.gw.bgX2 = 0;
            }
        }
        boolean b = false;
        int i = 0;
        while (i < this.gw.em.size()) {
            if (this.gw.getEmy((int)i).type != 8 && this.X + this.width >= this.gw.getEmy((int)i).X) {
                b = true;
                break;
            }
            ++i;
        }
        if (!b) {
            this.X += this.moveSpeed;
        }
        int i2 = 0;
        while (i2 < this.gw.allItems.size()) {
            if (this.collidesWith((ItemSprite)this.gw.allItems.elementAt(i2))) {
                ((ItemSprite)this.gw.allItems.elementAt(i2)).getItem(this.type);
                break;
            }
            ++i2;
        }
    }

    final void runAction() {
        ++this.moveFrameIndex;
        switch (this.type) {
            case 0: {
                if (this.sequenceIndex != 8 && this.sequenceIndex != 6 && this.sequenceIndex != 7) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    if (this.gw.getEmy((int)i).type != 8 && this.gw.getEmy((int)i).state != 3 && this.collidesWith(this.gw.getEmy(i), 0, 1, 1)) {
                        this.computeAct();
                        this.gw.getEmy(i).killHp(this.act, 0);
                        this.changeState(0);
                        return;
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                if (this.sequenceIndex <= 16) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    if (this.gw.getEmy((int)i).type != 8 && this.gw.getEmy((int)i).state != 3 && this.collidesWith(this.gw.getEmy(i), 0, 1, 1)) {
                        this.computeAct();
                        this.gw.getEmy(i).killHp(this.act, 2);
                        this.changeState(0);
                        return;
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                if (this.moveFrameIndex != 5) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    if (this.gw.getEmy((int)i).type != 8 && this.gw.getEmy((int)i).state != 3 && this.collidesWith(this.gw.getEmy(i))) {
                        this.computeAct();
                        this.gw.getEmy(i).killHp(this.act, 1);
                        this.changeState(0);
                        return;
                    }
                    ++i;
                }
                break;
            }
        }
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            this.changeState(1);
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runByAction() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            this.changeState(1);
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runChangeSqueeLeft() {
        this.runFrame();
        this.moveBack();
        if (this.X == this.targetX) {
            this.changeState(1);
        }
    }

    final void runChangeSqueeRight() {
        this.runFrame();
        this.movePre();
        if (this.X == this.targetX) {
            this.changeState(1);
        }
    }

    final void runDead() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = this.currentActionList.length - 1;
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runDef() {
        if (this.waitFrame(150)) {
            this.changeState(1);
        }
    }

    final void runFrame() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runRight() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            ++this.moveCount;
            if (this.moveCount > 4) {
                this.moveCount = 0;
                this.changeState(1);
            }
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
        this.movePre();
    }

    final void runSp1() {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                if (this.sequenceIndex <= 16) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    if (this.gw.getEmy((int)i).type != 8 && this.gw.getEmy((int)i).state != 3 && this.collidesWith(this.gw.getEmy(i), 0, 1, 1)) {
                        this.computeAct();
                        this.gw.getEmy(i).killHp(this.act + 30, 3);
                    }
                    ++i;
                }
                break;
            }
            case 2: {
                if (this.sequenceIndex != 17) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    EmySprite emy = this.gw.getEmy(i);
                    if (emy != null && this.gw.getEmy((int)i).type != 8 && emy.state != 3 && this.collidesWith(emy, 0, 1, 1)) {
                        this.computeAct();
                        emy.killHp(this.act, 1);
                    }
                    ++i;
                }
                this.movePre();
                this.movePre();
                this.movePre();
                this.movePre();
                this.movePre();
                this.movePre();
            }
        }
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            if (this.type == 0) {
                this.gw.fireList.addElement(new BgLayer(this.gw.fireImage, this.X + 110, this.Y - 33, 4, 3, this.gw.fireList, 0, this.gw));
            }
            this.changeState(1);
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runSp2() {
        switch (this.type) {
            case 0: {
                if (this.sequenceIndex != 8 && this.sequenceIndex != 33 && this.sequenceIndex != 34) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    if (this.gw.getEmy((int)i).type != 8 && this.gw.getEmy((int)i).state != 3 && this.collidesWith(this.gw.getEmy(i), 0, 1, 1)) {
                        this.computeAct();
                        this.gw.getEmy(i).killHp(this.act, 2);
                    }
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.gw.rs.length) {
                    this.gw.rs[i].addHp(500);
                    ++i;
                }
                break;
            }
            case 2: {
                if (this.moveFrameIndex != 12 && this.moveFrameIndex != 14 && this.moveFrameIndex != 15) break;
                int i = 0;
                while (i < this.gw.em.size()) {
                    EmySprite emy = this.gw.getEmy(i);
                    if (emy != null && this.gw.getEmy((int)i).type != 8 && emy.state != 3 && this.collidesWith(emy, 0, 1, 1)) {
                        this.computeAct();
                        emy.killHp(this.act * 2, 0);
                    }
                    ++i;
                }
                break;
            }
        }
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            this.changeState(1);
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runStartMove() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
        this.movePre();
        if (this.X == this.startX) {
            this.changeState(0);
        }
    }

    final void runStop() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            this.changeState(0);
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void runStop0() {
        ++this.moveFrameIndex;
        if (this.moveFrameIndex >= this.currentActionList.length) {
            this.moveFrameIndex = 0;
            this.stopTime += GameInterface.getRandomNumber(1, 10);
            if (this.stopTime > 15) {
                switch (this.gw.currentQuee) {
                    case 0: {
                        if (this.type == 1) {
                            if (this.gw.rs[0].X - this.X != 70) {
                                this.changeQuee(this.gw.rs[0].X - 70);
                                break;
                            }
                            this.changeState(1);
                            break;
                        }
                        if (this.type != 2) break;
                        if (this.gw.rs[0].X - this.X != 40) {
                            this.changeQuee(this.gw.rs[0].X - 40);
                            break;
                        }
                        this.changeState(1);
                        break;
                    }
                    case 1: {
                        if (this.type == 0) {
                            if (this.gw.rs[1].X - this.X != 70) {
                                this.changeQuee(this.gw.rs[1].X - 70);
                                break;
                            }
                            this.changeState(1);
                            break;
                        }
                        if (this.type != 2) break;
                        if (this.gw.rs[1].X - this.X != 40) {
                            this.changeQuee(this.gw.rs[1].X - 40);
                            break;
                        }
                        this.changeState(1);
                        break;
                    }
                    case 2: {
                        if (this.type == 0) {
                            if (this.gw.rs[2].X - this.X != 40) {
                                this.changeQuee(this.gw.rs[2].X - 40);
                                break;
                            }
                            this.changeState(1);
                            break;
                        }
                        if (this.type != 1) break;
                        if (this.gw.rs[2].X - this.X != 70) {
                            this.changeQuee(this.gw.rs[2].X - 70);
                            break;
                        }
                        this.changeState(1);
                    }
                }
            } else if (this.stopTime > 50) {
                this.stopTime = 0;
                this.changeState(1);
            }
        }
        this.sequenceIndex = this.currentActionList[this.moveFrameIndex];
    }

    final void searchEmy() {
        if (this.gw.em.size() == 0) {
            this.changeState(3);
            return;
        }
        int targetIndex = 0;
        int i = 0;
        while (i < this.gw.em.size()) {
            if (this.gw.getEmy((int)i).type != 8) {
                if (this.gw.getEmy((int)i).X < this.gw.getEmy((int)targetIndex).X) {
                    targetIndex = i;
                }
            } else if (this.gw.getEmy((int)i).X < this.gw.getEmy((int)targetIndex).X) {
                targetIndex = i + 1;
            }
            ++i;
        }
        switch (this.type) {
            case 0: {
                this.changeState(3);
                break;
            }
            case 1: {
                this.changeState(3);
                break;
            }
            case 2: {
                if (this.gw.em.size() == 0) {
                    this.changeState(3);
                    break;
                }
                if (this.gw.getEmy((int)targetIndex).X - this.X > this.width) {
                    this.runFrame();
                    this.movePre();
                    break;
                }
                this.changeState(3);
            }
        }
    }

    final void setAction() {
        this.changeState(3);
    }

    final void setImage(Image im) {
        this.img = im;
    }

    final void setProperty(int t) {
        switch (t) {
            case 0: {
                this.maxHp = this.hp = 200;
                this.minAct = 10;
                this.maxAct = 15;
                this.def = 3;
                this.startX = 40;
                break;
            }
            case 1: {
                this.maxHp = this.hp = 150;
                this.minAct = 1;
                this.maxAct = 2;
                this.act = 0;
                this.def = 2;
                this.startX = 10;
                break;
            }
            case 2: {
                this.maxHp = this.hp = 350;
                this.minAct = 5;
                this.maxAct = 15;
                this.def = 4;
                this.startX = 80;
            }
        }
    }

    final void showDailog(String[] s, int time) {
        this.dialog = s;
        this.dailogTime = 0;
        this.maxDailogTime = time;
        this.isShowDialog = true;
    }
}

