/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Effect {
    public byte state;
    public int x;
    public int y;
    private SpriteLibrary sl;
    private int typeIndex;
    private int actionIndex;
    private short frames;
    private short frameRate;
    private int frameNumber;
    private short currentFrame;

    public Effect(SpriteLibrary spriteLibrary) {
        this.sl = spriteLibrary;
    }

    public void reset(short s, int n, int n2, int n3, byte by) {
        this.state = by;
        this.typeIndex = this.sl.searchTypeIndex(s);
        this.actionIndex = this.sl.searchActionIndex(this.typeIndex, n);
        this.frameRate = this.sl.getFrameRate(this.typeIndex, this.actionIndex);
        this.frameNumber = this.sl.getFrameNumber(this.typeIndex, this.actionIndex);
        this.frames = 0;
        this.currentFrame = 0;
        this.x = n2;
        this.y = n3;
    }

    public void changeAction(int n) {
        this.frames = 0;
        this.currentFrame = 0;
        this.actionIndex = this.sl.searchActionIndex(this.typeIndex, n);
        this.frameRate = this.sl.getFrameRate(this.typeIndex, this.actionIndex);
        this.frameNumber = this.sl.getFrameNumber(this.typeIndex, this.actionIndex);
    }

    public void update() {
        this.frames = (short)(this.frames + 1);
        this.currentFrame = (byte)(this.frames / this.frameRate);
        if (this.currentFrame >= this.frameNumber) {
            this.frames = 0;
            this.currentFrame = 0;
            if (this.state == 1) {
                this.state = 0;
                this.changeAction(1);
            }
        }
    }

    public int[] getRegion(int n, int n2) {
        int[] nArray = new int[]{0, 0, 16, 16};
        nArray[0] = n - 8;
        nArray[1] = n2 - 16;
        return nArray;
    }

    public void paint(Graphics graphics, int n, int n2) {
        this.sl.PaintSprite(graphics, n, n2, this.typeIndex, this.actionIndex, this.currentFrame);
    }
}

