/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FrameWork
extends Canvas
implements Runnable {
    public Main main;
    Display display;
    public static Random rnd;
    public boolean bRunning;
    public boolean bPause;
    public static int iClock;
    public static int iShowTime;
    public static int frameStateNew;
    public static int frameState;
    public int oldFrameState;
    public static Resource pic;
    public static Game game;
    public static Menu menu;
    public static StateMachine stateMachine;
    public static Sound sound;
    public static Record record;
    public int iLoadingSteps;
    public int iLoadingStep;
    public int iLoading;
    private int iKeyManageIndex;
    private int iKeyBufferIndex;
    private int[][] keyBuffer;
    public byte byRuntime;
    public boolean bWarning;
    public boolean bSound;
    public byte bySoundState;
    public byte bySoundLevel;
    public static boolean bGameRunning;
    private static long lThreadTime;
    public long threadTime;
    public Runtime runner;
    public long freeMemory;
    public Logo logo;
    public String[] name = new String[]{"tony_sky", "william", "sieg"};
    public int[] score = new int[]{2000, 1000, 500};

    public FrameWork(Main main, Display display) {
        this.display = display;
        this.main = main;
        frameState = -1;
        frameStateNew = -2;
        this.iKeyBufferIndex = 0;
        this.keyBuffer = new int[5][2];
        pic = new Resource();
        bGameRunning = false;
        this.byRuntime = 0;
        this.setFullScreenMode(true);
        this.bySoundState = 0;
        this.runner = Runtime.getRuntime();
        this.Start();
        record = new Record("game");
        if (!this.loadGame()) {
            this.saveGame();
        }
        this.loadGame();
        this.logo = new Logo();
        menu = new Menu(this);
    }

    public void saveGame() {
        int n = this.name.length;
        byte[][] byArray = new byte[n][8];
        int[] nArray = new int[n];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.name[i].getBytes();
                nArray[i] = byArray[i].length;
                dataOutputStream.writeInt(nArray[i]);
                for (int j = 0; j < nArray[i]; ++j) {
                    dataOutputStream.writeByte(byArray[i][j]);
                }
                dataOutputStream.writeInt(this.score[i]);
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        record.saveRecord(1, byArray2);
        dataOutputStream = null;
        byteArrayOutputStream = null;
    }

    public boolean loadGame() {
        byte[] byArray = record.loadRecord(1);
        if (byArray == null) {
            return false;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            this.name = new String[n];
            int[] nArray = new int[n];
            this.score = new int[n];
            byte[][] byArray2 = new byte[n][8];
            for (int i = 0; i < n; ++i) {
                nArray[i] = dataInputStream.readInt();
                for (int j = 0; j < nArray[i]; ++j) {
                    byArray2[i][j] = dataInputStream.readByte();
                }
                this.name[i] = new String(byArray2[i]);
                this.score[i] = dataInputStream.readInt();
            }
            dataInputStream.close();
            dataInputStream = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void Release() {
        if (!bGameRunning && game != null) {
            game.Close();
            game = null;
        }
    }

    public void Start() {
        this.bRunning = true;
        this.bPause = false;
    }

    public void Stop() {
        this.bRunning = false;
    }

    protected void showNotify() {
        this.bPause = false;
    }

    public void run() {
        while (this.bRunning) {
            if (this.bPause) continue;
            lThreadTime = System.currentTimeMillis();
            this.Close();
            this.KeyManage();
            this.Init();
            this.Running();
            while (System.currentTimeMillis() - lThreadTime < 100L) {
                Thread.yield();
            }
        }
    }

    public void Init() {
        if (frameStateNew == -5) {
            if (game != null) {
                game.Init();
            }
            if (this.logo != null) {
                this.logo = null;
                System.gc();
            }
        }
        if (frameStateNew == frameState) {
            return;
        }
        iClock = 0;
        switch (frameStateNew) {
            case -2: {
                this.InitLegal();
                break;
            }
            case -3: {
                this.InitLoading();
                break;
            }
            case -5: {
                this.InitGame();
                break;
            }
            case -4: {
                menu.Init();
                break;
            }
            case -6: {
                this.InitWarning();
                break;
            }
            case -7: {
                this.InitQuit();
                break;
            }
            default: {
                StateMachine.state[frameStateNew].Init();
            }
        }
        frameState = frameStateNew;
    }

    public void Running() {
        int n = -1;
        iClock = iClock < 2520 ? ++iClock : 0;
        switch (frameState) {
            case -2: {
                n = this.RunningLegal();
                break;
            }
            case -3: {
                n = this.RunningLoading();
                break;
            }
            case -4: {
                n = menu.Running();
                break;
            }
            case -5: {
                n = this.RunningGame();
                break;
            }
            case -6: {
                n = this.RunningWarning();
                break;
            }
            case -7: {
                n = this.RunningQuit();
                break;
            }
            default: {
                n = StateMachine.state[frameState].Running();
            }
        }
        if (n != -1) {
            frameStateNew = n;
        }
        this.byRuntime = 1;
        if (this.logo != null && this.logo.sleepBL) {
            this.logo.sleepBL = false;
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                System.out.println("sleep is null");
            }
        }
        this.repaint();
    }

    protected void paint(Graphics graphics) {
        while (this.byRuntime != 1) {
        }
        graphics.setClip(0, 0, 176, 208);
        switch (frameState) {
            case -2: {
                this.PaintLegal(graphics);
                break;
            }
            case -3: {
                this.PaintLoading(graphics);
                break;
            }
            case -5: {
                this.PaintGame(graphics);
                break;
            }
            case -4: {
                menu.Paint(graphics, FrameWork.game.off_img);
                break;
            }
            case -6: {
                this.PaintWarning(graphics);
                break;
            }
            case -7: {
                this.PaintQuit(graphics);
                break;
            }
            default: {
                StateMachine.state[frameState].Paint(graphics);
            }
        }
        this.byRuntime = 0;
    }

    public void Close() {
        while (this.byRuntime != 0) {
        }
        if (frameStateNew == frameState) {
            return;
        }
        switch (frameState) {
            case -2: {
                this.CloseLegal();
                break;
            }
            case -3: {
                this.CloseLoading();
                break;
            }
            case -5: {
                this.CloseGame();
                break;
            }
            case -4: {
                menu.Close();
                break;
            }
            case -6: {
                this.CloseWarning();
                break;
            }
            case -7: {
                this.CloseQuit();
                break;
            }
            case -1: {
                break;
            }
            default: {
                StateMachine.state[frameState].Close();
            }
        }
    }

    public void keyPressed(int n) {
        if (this.iKeyBufferIndex < 5) {
            this.keyBuffer[this.iKeyBufferIndex][0] = 1;
            this.keyBuffer[this.iKeyBufferIndex++][1] = Environment.getGameKey(n);
        }
    }

    public void keyReleased(int n) {
        if (this.iKeyBufferIndex < 5) {
            this.keyBuffer[this.iKeyBufferIndex][0] = 2;
            this.keyBuffer[this.iKeyBufferIndex++][1] = Environment.getGameKey(n);
        }
    }

    public void KeyManage() {
        this.iKeyManageIndex = 0;
        switch (frameState) {
            case -2: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedLegal(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    this.OnKeyReleasedLegal(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        menu.keyPressed(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    menu.keyReleased(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break;
            }
            case -5: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedGame(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    this.OnKeyReleasedGame(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break;
            }
            case -6: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        this.OnKeyPressedWarning(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    this.OnKeyReleasedWarning(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break;
            }
            case -7: {
                break;
            }
            default: {
                while (this.iKeyManageIndex < this.iKeyBufferIndex) {
                    if (this.keyBuffer[this.iKeyManageIndex][0] == 1) {
                        StateMachine.state[frameState].keyPressed(this.keyBuffer[this.iKeyManageIndex++][1]);
                        continue;
                    }
                    StateMachine.state[frameState].keyReleased(this.keyBuffer[this.iKeyManageIndex++][1]);
                }
                break block0;
            }
        }
        this.iKeyBufferIndex = 0;
    }

    private void InitLegal() {
        short[] sArray = new short[]{50};
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        this.logo.Initialize(sArray, nArray, nArray2, nArray3);
        iShowTime = 0;
    }

    private int RunningLegal() {
        return this.logo.Running();
    }

    private void PaintLegal(Graphics graphics) {
        this.logo.Paint(graphics);
    }

    private void CloseLegal() {
    }

    private void PaintLogo(Graphics graphics) {
        this.logo.Paint(graphics);
    }

    private void OnKeyPressedLegal(int n) {
        this.logo.keyPressed(n);
    }

    private void OnKeyReleasedLegal(int n) {
    }

    private int Running_LOGO() {
        return this.logo.Running();
    }

    private void InitLoading() {
    }

    private int RunningLoading() {
        return 0;
    }

    private void PaintLoading(Graphics graphics) {
    }

    private void CloseLoading() {
    }

    public void LoadingRefresh() {
        ++this.iLoadingStep;
        this.iLoading = this.iLoadingStep * 148 / this.iLoadingSteps;
        this.repaint();
    }

    public void LoadResources() {
    }

    private void InitGame() {
        if (bGameRunning) {
            return;
        }
        rnd = new Random();
        if (game != null) {
            game.Close();
            game = null;
        }
        game = new Game(this);
        game.Init();
        bGameRunning = true;
    }

    private int RunningGame() {
        return game.Running();
    }

    private void PaintGame(Graphics graphics) {
        game.paint(graphics);
    }

    private void CloseGame() {
        if (bGameRunning) {
            return;
        }
        game.Close();
        game = null;
    }

    private void OnKeyPressedGame(int n) {
        game.keyPressed(n);
    }

    private void OnKeyReleasedGame(int n) {
        game.keyReleased(n);
    }

    public void InitWarning() {
        this.bWarning = false;
    }

    public int RunningWarning() {
        return -1;
    }

    public void CloseWarning() {
    }

    public void PaintWarning(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 208);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        Routine.drawStrokString(graphics, "\u7ed3\u675f\u5f53\u524d\u6e38\u620f\uff1f", 88, 61, 0xFFFFFF, 0, 33);
        int n = this.bWarning ? 0xFF0000 : 0xFFFFFF;
        Routine.drawStrokString(graphics, "\u662f", 58, 130, n, 0, 33);
        n = n ^ 0xFF0000 ^ 0xFFFFFF;
        Routine.drawStrokString(graphics, "\u5426", 117, 130, n, 0, 33);
    }

    public void OnKeyPressedWarning(int n) {
        switch (n) {
            case 4: 
            case 6: {
                if (this.bWarning) {
                    this.bWarning = false;
                    break;
                }
                this.bWarning = true;
                break;
            }
            case 10: {
                if (this.bWarning) {
                    game.Close();
                    game = null;
                    sound.SoundReset();
                    bGameRunning = false;
                    if (StateMachine.state[0].getClass().getName().equals("Prepare")) {
                        frameStateNew = 0;
                        break;
                    }
                    frameStateNew = -4;
                    break;
                }
                frameStateNew = this.oldFrameState;
                break;
            }
            case 3: {
                frameStateNew = this.oldFrameState;
            }
        }
    }

    public void OnKeyReleasedWarning(int n) {
    }

    private void InitQuit() {
        iShowTime = 20;
    }

    private int RunningQuit() {
        if (iShowTime > 0 && --iShowTime == 0) {
            this.Release();
            this.Stop();
            this.main.destroyApp(true);
        }
        return -1;
    }

    private void PaintQuit(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 208);
        graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
        graphics.setColor(15920323);
        graphics.drawString("\u611f\u8c22\u60a8\u4f7f\u7528\u4e86", 88, 96, 33);
        graphics.drawString("\u4e50\u6e38\u8f6f\u4ef6\u4ea7\u54c1", 88, 112, 17);
    }

    private void CloseQuit() {
    }

    public void paintUI(Graphics graphics, int n, int n2, int n3, int n4) {
    }
}

