/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SceneLibrary {
    private Scene scene;
    private InputStream res;
    private int dataSize;
    private byte[] data;
    private int index;
    private byte ret_byte;
    private short ret_short;
    private int ret_int;
    private String ret_string;
    private short LayerInfo;
    public int[] iMapWidth;
    public int[] iMapHeight;
    private byte[][] physicalData;
    private int iImgNum;
    private String[] ImageName;
    private short shTileNum;
    public Image[] imgScene;
    public boolean[] roll_x;
    public boolean[] roll_y;
    public byte[][][] layerBuffer;
    private byte[][][] mapIndex;
    private byte mapDataBuffer;
    private int cx;
    private int cy;
    public int iLabelNumber;
    public short[] labelName;
    public int[] labelPosX;
    public int[] labelPosY;
    public int[] labelAttrNum;
    public short[][] labelAttrType;
    public short[][] labelAttrID;
    public byte[][] labelAttrByte;
    public short[][] labelAttrShort;
    public int[][] labelAttrInt;
    public String[][] labelAttrString;

    public SceneLibrary(Scene scene) {
        this.scene = scene;
    }

    public void reset(String string) {
        try {
            this.res = this.getClass().getResourceAsStream(string + ".sce");
            this.dataSize = 0;
            while (this.res.read() != -1) {
                ++this.dataSize;
            }
            this.res.close();
            this.res = this.getClass().getResourceAsStream(string + ".sce");
            this.data = new byte[this.dataSize];
            this.res.read(this.data, 0, this.dataSize);
            this.res.close();
        }
        catch (IOException iOException) {
            System.out.println(string + ".sce not exist!");
            return;
        }
        this.index = 0;
        this.resolveSce();
        this.data = null;
    }

    public void Close() {
        this.iMapWidth = null;
        this.iMapHeight = null;
        this.physicalData = null;
        this.roll_x = null;
        this.roll_y = null;
        this.layerBuffer = null;
        this.mapIndex = null;
        this.labelName = null;
        this.labelPosX = null;
        this.labelPosY = null;
        this.labelAttrNum = null;
        this.labelAttrType = null;
        this.labelAttrID = null;
        this.labelAttrByte = null;
        this.labelAttrShort = null;
        this.labelAttrInt = null;
        this.labelAttrString = null;
    }

    private byte readByte() {
        this.ret_byte = this.data[this.index++];
        return this.ret_byte;
    }

    private short readShort() {
        this.ret_short = (short)((this.data[this.index++] + 256 & 0xFF) + ((this.data[this.index++] + 256 & 0xFF) << 8));
        return this.ret_short;
    }

    private int readInt() {
        this.ret_int = (this.data[this.index++] + 256 & 0xFF) + ((this.data[this.index++] + 256 & 0xFF) << 8) + ((this.data[this.index++] + 256 & 0xFF) << 16) + ((this.data[this.index++] + 256 & 0xFF) << 24);
        return this.ret_int;
    }

    private String readString(int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.readByte();
            if (byArray[n2] != 0) continue;
            this.index += n - 1 - n2;
            break;
        }
        this.ret_string = new String(byArray, 0, n2);
        return this.ret_string;
    }

    private void resolveSce() {
        this.SceneInfo();
        this.ImageList();
        if ((this.LayerInfo & 0xF) != 0) {
            this.MapLayer();
        }
        if ((this.LayerInfo & 0x20) == 32) {
            this.PhysicalLayer();
        }
        if ((this.LayerInfo & 0x10) == 16) {
            this.SpriteLayer();
        }
    }

    private void SceneInfo() {
        this.scene.worldWidth = this.readInt();
        this.scene.worldHeight = this.readInt();
        this.scene.iTileWidth = this.readByte();
        this.scene.iTileHeight = this.readByte();
        if (this.scene.iTileWidth == 16) {
            this.scene.TWA = 4;
        } else if (this.scene.iTileWidth == 32) {
            this.scene.TWA = 5;
        }
        if (this.scene.iTileHeight == 16) {
            this.scene.THA = 4;
        } else if (this.scene.iTileHeight == 32) {
            this.scene.THA = 5;
        }
        this.scene.worldWidth >>= this.scene.TWA;
        this.scene.worldHeight >>= this.scene.THA;
        this.LayerInfo = this.readShort();
        this.scene.iLayerNumber = 0;
        if ((this.LayerInfo & 1) == 1) {
            ++this.scene.iLayerNumber;
        }
        if ((this.LayerInfo & 2) == 2) {
            ++this.scene.iLayerNumber;
        }
        if ((this.LayerInfo & 4) == 4) {
            ++this.scene.iLayerNumber;
        }
        if ((this.LayerInfo & 8) == 8) {
            ++this.scene.iLayerNumber;
        }
    }

    private void ImageList() {
        int n;
        this.iImgNum = this.readInt();
        String string = this.readString(32);
        if (this.ImageName != null && (string.equals(this.ImageName[0]) || string.equals(this.ImageName[1]))) {
            this.index += 34;
            return;
        }
        this.ImageName = null;
        this.ImageName = new String[this.iImgNum];
        this.ImageName[0] = string;
        for (n = 1; n < this.iImgNum; ++n) {
            this.ImageName[n] = this.readString(32);
        }
        this.shTileNum = this.readShort();
        if (this.shTileNum < 0) {
            this.shTileNum = 0;
        }
        if (this.scene.iLayerNumber == 1) {
            int n2 = 256 >> this.scene.TWA;
            this.imgScene = new Image[this.shTileNum];
            int n3 = 0;
            for (int i = 0; i < this.iImgNum; ++i) {
                Image image = FrameWork.pic.getImage(this.ImageName[i]);
                int n4 = image.getWidth() >> this.scene.TWA;
                int n5 = image.getHeight() >> this.scene.THA;
                for (int j = 0; j < n2 * n5; ++j) {
                    if (j % n2 < n4) {
                        this.imgScene[n3] = Image.createImage((int)this.scene.iTileWidth, (int)this.scene.iTileHeight);
                        Graphics graphics = this.imgScene[n3].getGraphics();
                        graphics.drawImage(image, -(j % n2 << this.scene.TWA), -(j / n2 << this.scene.THA), 20);
                    }
                    ++n3;
                }
            }
            Object var3_4 = null;
        } else if (this.scene.iLayerNumber > 1) {
            this.imgScene = new Image[this.iImgNum];
            for (n = 0; n < this.iImgNum; ++n) {
                this.imgScene[n] = FrameWork.pic.getImage(this.ImageName[n]);
            }
        }
    }

    private void MapLayer() {
        this.roll_x = new boolean[this.scene.iLayerNumber];
        this.roll_y = new boolean[this.scene.iLayerNumber];
        this.iMapWidth = new int[this.scene.iLayerNumber];
        this.iMapHeight = new int[this.scene.iLayerNumber];
        this.mapIndex = new byte[this.scene.iLayerNumber][][];
        this.layerBuffer = new byte[this.scene.iLayerNumber][][];
        for (int i = 0; i < this.scene.iLayerNumber; ++i) {
            this.roll_x[i] = false;
            this.roll_y[i] = false;
            this.iMapWidth[i] = this.readInt();
            this.iMapHeight[i] = this.readInt();
            this.mapIndex[i] = new byte[this.iMapWidth[i]][this.iMapHeight[i]];
            this.layerBuffer[i] = new byte[(176 + this.scene.iTileWidth - 1 >> this.scene.TWA) + 1][(208 + this.scene.iTileHeight - 1 >> this.scene.THA) + 1];
            for (int j = 0; j < this.iMapHeight[i]; ++j) {
                for (int k = 0; k < this.iMapWidth[i]; ++k) {
                    this.mapIndex[i][k][j] = (byte)this.readShort();
                }
            }
        }
    }

    private void PhysicalLayer() {
        this.physicalData = new byte[this.scene.worldWidth][this.scene.worldHeight];
        for (int i = 0; i < this.scene.worldHeight; ++i) {
            for (int j = 0; j < this.scene.worldWidth; ++j) {
                this.physicalData[j][i] = this.readByte();
            }
        }
    }

    private void SpriteLayer() {
        this.iLabelNumber = this.readInt();
        if (this.iLabelNumber == 0) {
            return;
        }
        this.labelName = new short[this.iLabelNumber];
        this.labelPosX = new int[this.iLabelNumber];
        this.labelPosY = new int[this.iLabelNumber];
        this.labelAttrNum = new int[this.iLabelNumber];
        this.labelAttrType = new short[this.iLabelNumber][];
        this.labelAttrID = new short[this.iLabelNumber][];
        this.labelAttrByte = new byte[this.iLabelNumber][];
        this.labelAttrShort = new short[this.iLabelNumber][];
        this.labelAttrInt = new int[this.iLabelNumber][];
        this.labelAttrString = new String[this.iLabelNumber][];
        for (int i = 0; i < this.iLabelNumber; ++i) {
            this.labelName[i] = this.readShort();
            this.labelPosX[i] = this.readInt();
            this.labelPosY[i] = this.readInt();
            this.index += 36;
            this.labelAttrNum[i] = this.readInt();
            this.labelAttrType[i] = new short[this.labelAttrNum[i]];
            this.labelAttrID[i] = new short[this.labelAttrNum[i]];
            this.labelAttrByte[i] = new byte[this.labelAttrNum[i]];
            this.labelAttrShort[i] = new short[this.labelAttrNum[i]];
            this.labelAttrInt[i] = new int[this.labelAttrNum[i]];
            this.labelAttrString[i] = new String[this.labelAttrNum[i]];
            block6: for (int j = 0; j < this.labelAttrNum[i]; ++j) {
                this.labelAttrType[i][j] = this.readShort();
                this.labelAttrID[i][j] = this.readShort();
                switch (this.labelAttrType[i][j]) {
                    case 0: {
                        this.labelAttrByte[i][j] = this.readByte();
                        continue block6;
                    }
                    case 1: {
                        this.labelAttrShort[i][j] = this.readShort();
                        continue block6;
                    }
                    case 2: {
                        this.labelAttrInt[i][j] = this.readInt();
                        continue block6;
                    }
                    default: {
                        this.labelAttrString[i][j] = this.readString(this.labelAttrType[i][j] - 3);
                    }
                }
            }
        }
    }

    private byte getMapData(int n, int n2, int n3) {
        if (n2 >= this.iMapWidth[n]) {
            n2 %= this.iMapWidth[n];
        } else if (n2 < 0) {
            n2 = this.iMapWidth[n] + n2 % this.iMapWidth[n];
        }
        if (n3 >= this.iMapHeight[n]) {
            n3 %= this.iMapHeight[n];
        } else if (n3 < 0) {
            n3 = this.iMapHeight[n] + n3 % this.iMapHeight[n];
        }
        return this.mapIndex[n][n2][n3];
    }

    public void closeLabelData() {
        this.labelName = null;
        this.labelPosX = null;
        this.labelPosY = null;
        this.labelAttrNum = null;
        this.labelAttrType = null;
        this.labelAttrID = null;
        this.labelAttrByte = null;
        this.labelAttrShort = null;
        this.labelAttrInt = null;
        this.labelAttrString = null;
    }

    public void setPhysicalData(int n, int n2, int n3) {
        if (this.physicalData == null) {
            return;
        }
        if (n >= this.scene.worldWidth || n2 >= this.scene.worldHeight) {
            return;
        }
        this.physicalData[n][n2] = (byte)n3;
    }

    public void setMapRoll(int n, boolean bl, boolean bl2) {
        this.roll_x[n] = bl;
        this.roll_y[n] = bl2;
    }

    public byte getPhysicalData(int n, int n2) {
        if (this.physicalData == null) {
            return 0;
        }
        if (n >= this.scene.worldWidth || n2 >= this.scene.worldHeight || n < 0 || n2 < 0) {
            return 0;
        }
        return this.physicalData[n][n2];
    }

    public boolean debug_hasAnj(short s) {
        int n = 0;
        while (s != Constant.SPRITE_TYPE_KEY[n]) {
            if (++n != Constant.SPRITE_TYPE_KEY.length) continue;
            System.out.println("Type Key Error:" + s + " doesn't exit!");
            return false;
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(Constant.SPRITE_TYPE_NAME[n] + ".anj");
            if (inputStream == null) {
                System.out.println(Constant.SPRITE_TYPE_NAME[n] + ".anj doesn't exit!");
                return false;
            }
            inputStream.close();
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Type Key Error:" + s + " doesn't exit!");
            return false;
        }
    }

    public void updateLayer(int n, int n2, int n3) {
        int n4;
        int n5;
        for (n5 = 0; n5 < (176 >> this.scene.TWA) + 1; ++n5) {
            for (n4 = 0; n4 < (208 >> this.scene.THA) + 1; ++n4) {
                this.layerBuffer[n][n5][n4] = -1;
            }
        }
        this.cx = 0;
        for (n5 = n2 >> this.scene.TWA; n5 <= n2 + 176 >> this.scene.TWA; ++n5) {
            if (this.roll_x[n] || n5 >= 0 && n5 < this.iMapWidth[n]) {
                this.cy = 0;
                for (n4 = n3 >> this.scene.THA; n4 <= n3 + 208 >> this.scene.THA; ++n4) {
                    if (this.roll_y[n] || n4 >= 0 && n4 < this.iMapHeight[n]) {
                        this.mapDataBuffer = this.getMapData(n, n5, n4);
                        if (this.mapDataBuffer > -1) {
                            if (this.mapDataBuffer > 65535) {
                                System.out.println("Please output your SCE file using linearity ID.");
                                return;
                            }
                            this.layerBuffer[n][this.cx][this.cy] = this.mapDataBuffer;
                        }
                    }
                    ++this.cy;
                }
            }
            ++this.cx;
        }
    }

    public void paintLayer(Graphics graphics, int n, int n2, int n3) {
        graphics.setClip(0, 0, 176, 208);
        this.cx = -(n2 & this.scene.iTileWidth - 1);
        for (int i = 0; i < (176 >> this.scene.TWA) + 1; ++i) {
            if (this.roll_x[n] || i >= 0 && i < this.iMapWidth[n]) {
                this.cy = -(n3 & this.scene.iTileHeight - 1);
                for (int j = 0; j < (208 >> this.scene.THA) + 1; ++j) {
                    if (!this.roll_y[n] && (j < 0 || j >= this.iMapHeight[n])) continue;
                    if (this.layerBuffer[n][i][j] > -1) {
                        if (this.layerBuffer[n][i][j] < this.imgScene.length) {
                            if (this.imgScene[this.layerBuffer[n][i][j]] != null) {
                                graphics.drawImage(this.imgScene[this.layerBuffer[n][i][j]], this.cx, this.cy, 20);
                            }
                        } else {
                            System.out.println("Please output the map data with index id.");
                        }
                    }
                    this.cy += this.scene.iTileHeight;
                }
            }
            this.cx += this.scene.iTileWidth;
        }
        graphics.setClip(0, 0, 176, 208);
    }
}

