/*
 * Decompiled with CFR 0.152.
 */
public class Script {
    private static final int STATE_NONE = -3;
    private static final int STATE_INIT = -2;
    private static final int STATE_READY = -1;
    private static final int STATE_FINISHED = 0;
    private static Game game;
    private static int[][] scriptBuffer;
    private static int temp_index;
    private static short temp_id;
    private static int currentIndex;
    private static int scriptLen;
    private static ScriptItem[] scriptItem;

    public Script(Game game) {
        Script.game = game;
        scriptItem = new ScriptItem[100];
        scriptLen = 0;
        scriptBuffer = new int[2][10];
        Script.resetScriptBuffer();
    }

    public static void resetScriptItem() {
        for (int i = 0; i < 100; ++i) {
            Script.scriptItem[i] = null;
        }
        Script.resetScriptBuffer();
        scriptLen = 0;
    }

    public static void createScriptItem(ScriptItem scriptItem) {
        Script.scriptItem[Script.scriptLen++] = scriptItem;
        if (scriptItem.id == 0) {
            Script.push(0);
        }
    }

    public static void resetScriptBuffer() {
        for (int i = 0; i < 10; ++i) {
            Script.scriptBuffer[0][i] = -3;
            Script.scriptBuffer[1][i] = -3;
        }
    }

    public static void run() {
        for (int i = 0; i < 10; ++i) {
            if (scriptBuffer[1][i] != -2) continue;
            Script.scriptBuffer[1][i] = -1;
        }
        for (currentIndex = 0; currentIndex < 10; ++currentIndex) {
            if (scriptBuffer[1][currentIndex] == -3 || scriptBuffer[1][currentIndex] == -2) continue;
            if (scriptBuffer[1][currentIndex] > 0) {
                int[] nArray = scriptBuffer[1];
                int n = currentIndex;
                nArray[n] = nArray[n] - 1;
            } else if (scriptBuffer[1][currentIndex] == -1 && game.isAffairHappened(Script.scriptItem[Script.scriptBuffer[0][Script.currentIndex]].iAffairCase, 0)) {
                game.affairRun(scriptItem[scriptBuffer[0][currentIndex]], game.chooseAffairTarget(scriptItem[scriptBuffer[0][currentIndex]], -1, -1), -1);
                if (scriptBuffer[1][currentIndex] == -1) {
                    Script.scriptBuffer[1][Script.currentIndex] = 0;
                }
            }
            if (scriptBuffer[1][currentIndex] != 0) continue;
            temp_id = Script.scriptItem[Script.scriptBuffer[0][Script.currentIndex]].next_id;
            Script.pop(currentIndex);
            if (temp_id <= -1) continue;
            Script.push(temp_id);
        }
    }

    public static void setWaitTime(int n) {
        Script.scriptBuffer[1][Script.currentIndex] = n;
    }

    public static void goTo(int n) {
        if (n > -1) {
            Script.push(n);
        }
    }

    private static void pop(int n) {
        Script.scriptBuffer[0][n] = -3;
        Script.scriptBuffer[1][n] = -3;
    }

    private static void push(int n) {
        for (int i = 0; i < scriptLen; ++i) {
            if (Script.scriptItem[i].id != n || Script.scriptItem[i].byAffairID == -1) continue;
            temp_index = 0;
            while (scriptBuffer[1][temp_index] != -3) {
                ++temp_index;
            }
            Script.scriptBuffer[0][Script.temp_index] = i;
            Script.scriptBuffer[1][Script.temp_index] = -2;
        }
    }
}

