/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SpriteLibrary {
    private InputStream res;
    private int dataSize;
    private byte[] data;
    private int index;
    private String sTypeName;
    private int typeNum;
    private short[] typeName;
    private ANJ[] type;
    private int spriteImageNum;
    private String[] spriteImageName;
    private Image[] spriteImage;
    private int typeNumOld;
    private short[] typeNameOld;
    private ANJ[] typeOld;
    private int spriteImageNumOld;
    private String[] spriteImageNameOld;
    private Image[] spriteImageOld;
    private int currentFrame;
    private int currentModule;
    private Runtime runner;
    private long freeMemory;
    private long totalMemory;

    public void reset(int n, short[] sArray) {
        this.saveOldData();
        this.typeNum = n;
        this.typeName = new short[n];
        this.type = new ANJ[n];
        this.spriteImageName = new String[n];
        for (int i = 0; i < n; ++i) {
            this.typeName[i] = sArray[i];
        }
        this.runner = Runtime.getRuntime();
        System.gc();
        this.totalMemory = this.runner.freeMemory();
        this.readAnj();
        System.gc();
        this.totalMemory -= this.runner.freeMemory();
        this.totalMemory = this.runner.freeMemory();
        System.out.println();
        System.out.println("//===========================================//");
        System.out.println("//            RSP Memory State               //");
        System.out.println("//===========================================//");
        this.readResource();
        System.out.println("---------------------------------------------");
        System.gc();
        this.totalMemory -= this.runner.freeMemory();
        System.out.println("All rsp files used " + this.totalMemory + "B (" + (this.totalMemory >> 10) + "KB)");
        this.deleteOldData();
    }

    public void Close() {
        this.type = null;
        this.typeName = null;
        this.spriteImageName = null;
        this.spriteImage = null;
        System.gc();
    }

    private byte readByte() {
        byte by = this.data[this.index++];
        return by;
    }

    private short readShort() {
        short s = (short)((this.data[this.index++] + 256 & 0xFF) + ((this.data[this.index++] + 256 & 0xFF) << 8));
        return s;
    }

    private int readInt() {
        int n = (this.data[this.index++] + 256 & 0xFF) + ((this.data[this.index++] + 256 & 0xFF) << 8) + ((this.data[this.index++] + 256 & 0xFF) << 16) + ((this.data[this.index++] + 256 & 0xFF) << 24);
        return n;
    }

    private String readString(int n) {
        int n2;
        byte[] byArray = new byte[n];
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = this.readByte();
            if (byArray[n2] != 0) continue;
            this.index += n - 1 - n2;
            break;
        }
        String string = new String(byArray, 0, n2);
        return string;
    }

    private String getTypeName(short s) {
        int n = 0;
        while (s != Constant.SPRITE_TYPE_KEY[n]) {
            if (++n != Constant.SPRITE_TYPE_KEY.length) continue;
            System.out.println("Type Key Error:" + s + " doesn't exit in type table.");
            return null;
        }
        return Constant.SPRITE_TYPE_NAME[n];
    }

    private int getImageIndex(String string) {
        int n = 0;
        if (this.spriteImageNum == 0) {
            this.spriteImageName[0] = string;
            ++this.spriteImageNum;
        } else {
            while (!string.equals(this.spriteImageName[n]) && ++n != this.spriteImageNum) {
            }
            if (n == this.spriteImageNum) {
                this.spriteImageName[n] = string;
                ++this.spriteImageNum;
            }
        }
        return n;
    }

    private void saveOldData() {
        if (this.type == null) {
            return;
        }
        this.typeNumOld = this.typeNum;
        this.typeNameOld = this.typeName;
        this.typeOld = this.type;
        this.spriteImageNumOld = this.spriteImageNum;
        this.spriteImageNameOld = this.spriteImageName;
        this.spriteImageOld = this.spriteImage;
        this.typeNum = 0;
        this.typeName = null;
        this.type = null;
        this.spriteImageNum = 0;
        this.spriteImageName = null;
        this.spriteImage = null;
    }

    private void deleteOldData() {
        this.typeNumOld = 0;
        this.typeNameOld = null;
        this.typeOld = null;
        this.spriteImageNumOld = 0;
        this.spriteImageNameOld = null;
        this.spriteImageOld = null;
    }

    private void readAnj() {
        int n;
        block2: for (n = 0; n < this.typeNum; ++n) {
            for (int i = 0; i < this.typeNumOld; ++i) {
                if (this.typeName[n] != this.typeNameOld[i]) continue;
                this.type[n] = this.typeOld[i];
                this.type[n].imgIndex = this.getImageIndex(this.spriteImageNameOld[this.typeOld[i].imgIndex]);
                continue block2;
            }
        }
        this.typeOld = null;
        for (n = 0; n < this.typeNum; ++n) {
            if (this.type[n] != null) continue;
            this.type[n] = new ANJ();
            this.sTypeName = this.getTypeName(this.typeName[n]);
            try {
                this.res = this.getClass().getResourceAsStream(this.sTypeName + ".anj");
                this.dataSize = 0;
                while (this.res.read() != -1) {
                    ++this.dataSize;
                }
                this.res.close();
                this.res = this.getClass().getResourceAsStream(this.sTypeName + ".anj");
                this.data = new byte[this.dataSize];
                this.res.read(this.data, 0, this.dataSize);
                this.res.close();
            }
            catch (IOException iOException) {
                System.out.println(this.sTypeName + ".anj not exist!");
                this.type[n] = null;
            }
            this.index = 0;
            System.gc();
            this.freeMemory = this.runner.freeMemory();
            if (this.type[n] != null) {
                this.type[n].decode();
            }
            System.gc();
            this.freeMemory -= this.runner.freeMemory();
            System.out.println(this.sTypeName + ".anj used " + this.freeMemory + "B (" + (this.freeMemory >> 10) + "KB)");
            this.data = null;
        }
    }

    private void readResource() {
        int n;
        Resource resource = new Resource();
        this.spriteImage = new Image[this.spriteImageNum];
        block0: for (n = 0; n < this.spriteImageNum; ++n) {
            for (int i = 0; i < this.spriteImageNumOld; ++i) {
                if (!this.spriteImageName[n].equals(this.spriteImageNameOld[i])) continue;
                this.spriteImage[n] = this.spriteImageOld[i];
                continue block0;
            }
        }
        this.spriteImageOld = null;
        for (n = 0; n < this.spriteImageNum; ++n) {
            if (this.spriteImage[n] != null) continue;
            System.gc();
            this.freeMemory = this.runner.freeMemory();
            this.spriteImage[n] = resource.getImage(this.spriteImageName[n]);
            System.gc();
            this.freeMemory -= this.runner.freeMemory();
            System.out.println(this.spriteImageName[n] + " used " + this.freeMemory + "B (" + (this.freeMemory >> 10) + "KB)");
        }
        resource = null;
    }

    public static int getActionIndex(String string) {
        int n = 0;
        while (!string.equals(Constant.SPRITE_ACTION_NAME[n])) {
            if (++n != Constant.SPRITE_ACTION_NAME.length) continue;
            System.out.println("Action Name Error:" + string + " doesn't exit in type table.");
            return 0;
        }
        return n;
    }

    public int searchTypeIndex(short s) {
        int n = 0;
        while (s != this.typeName[n]) {
            if (++n != this.typeNum) continue;
            System.out.println("Resource Type " + s + " haven't load.");
            return 0;
        }
        return n;
    }

    public int searchActionIndex(int n, int n2) {
        int n3 = 0;
        while (n2 != this.type[n].ActionIndex[n3]) {
            if (++n3 != this.type[n].ActionNum) continue;
            return 0;
        }
        return n3;
    }

    public short getFrameRate(int n, int n2) {
        return this.type[n].ActionRate[n2];
    }

    public int getFrameNumber(int n, int n2) {
        return this.type[n].FrameUsed[n2];
    }

    public short getRegionX(int n, int n2, int n3, int n4) {
        return this.type[n].RegionX[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public short getRegionY(int n, int n2, int n3, int n4) {
        return this.type[n].RegionY[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public short getRegionW(int n, int n2, int n3, int n4) {
        return this.type[n].RegionW[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public short getRegionH(int n, int n2, int n3, int n4) {
        return this.type[n].RegionH[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public void PaintSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 >= this.type[n3].FrameUsed[n4]) {
            n5 = 0;
        }
        this.currentFrame = this.type[n3].FrameIndex[n4][n5];
        for (int i = 0; i < this.type[n3].ModuleUsed[this.currentFrame]; ++i) {
            this.currentModule = this.type[n3].ModuleIndex[this.currentFrame][i];
            graphics.setClip(n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i], this.type[n3].ModuleW[this.currentModule], this.type[n3].ModuleH[this.currentModule]);
            graphics.drawImage(this.spriteImage[this.type[n3].imgIndex], n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i] - this.type[n3].ModuleX[this.currentModule], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i] - this.type[n3].ModuleY[this.currentModule], 20);
        }
    }

    public void DrawSprite(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5) {
        if (n5 >= this.type[n3].FrameUsed[n4]) {
            n5 = 0;
        }
        this.currentFrame = this.type[n3].FrameIndex[n4][n5];
        for (int i = 0; i < this.type[n3].ModuleUsed[this.currentFrame]; ++i) {
            this.currentModule = this.type[n3].ModuleIndex[this.currentFrame][i];
            graphics.setClip(n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i], this.type[n3].ModuleW[this.currentModule], this.type[n3].ModuleH[this.currentModule]);
            graphics.drawImage(image, n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i] - this.type[n3].ModuleX[this.currentModule], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i] - this.type[n3].ModuleY[this.currentModule], 20);
        }
    }

    private final class ANJ {
        private int imgIndex;
        private int ModuleNum;
        private int[] ModuleX;
        private int[] ModuleY;
        private int[] ModuleW;
        private int[] ModuleH;
        private int FrameNum;
        private short[] CenterX;
        private short[] CenterY;
        private int[] ModuleUsed;
        private short[][] ModuleIndex;
        private short[][] ModuleExcX;
        private short[][] ModuleExcY;
        private byte[] RegionNum;
        private byte[][] RegionID;
        private short[][] RegionX;
        private short[][] RegionY;
        private short[][] RegionW;
        private short[][] RegionH;
        private int ActionNum;
        private int[] ActionIndex;
        private int[] FrameUsed;
        private short[][] FrameIndex;
        private byte[] ActionRate;

        private ANJ() {
        }

        private void decode() {
            int n;
            int n2;
            SpriteLibrary.this.index += 32;
            this.imgIndex = SpriteLibrary.this.getImageIndex(SpriteLibrary.this.readString(32));
            SpriteLibrary.this.index += 4;
            this.ModuleNum = SpriteLibrary.this.readInt();
            this.ModuleX = new int[this.ModuleNum];
            this.ModuleY = new int[this.ModuleNum];
            this.ModuleW = new int[this.ModuleNum];
            this.ModuleH = new int[this.ModuleNum];
            for (n2 = 0; n2 < this.ModuleNum; ++n2) {
                this.ModuleX[n2] = SpriteLibrary.this.readInt();
                this.ModuleY[n2] = SpriteLibrary.this.readInt();
                this.ModuleW[n2] = SpriteLibrary.this.readInt() - this.ModuleX[n2];
                this.ModuleH[n2] = SpriteLibrary.this.readInt() - this.ModuleY[n2];
            }
            this.FrameNum = SpriteLibrary.this.readInt();
            this.CenterX = new short[this.FrameNum];
            this.CenterY = new short[this.FrameNum];
            this.RegionNum = new byte[this.FrameNum];
            this.RegionID = new byte[this.FrameNum][];
            this.RegionX = new short[this.FrameNum][];
            this.RegionY = new short[this.FrameNum][];
            this.RegionW = new short[this.FrameNum][];
            this.RegionH = new short[this.FrameNum][];
            this.ModuleUsed = new int[this.FrameNum];
            this.ModuleIndex = new short[this.FrameNum][];
            this.ModuleExcX = new short[this.FrameNum][];
            this.ModuleExcY = new short[this.FrameNum][];
            for (n2 = 0; n2 < this.FrameNum; ++n2) {
                SpriteLibrary.this.index += 32;
                this.CenterX[n2] = SpriteLibrary.this.readShort();
                this.CenterY[n2] = SpriteLibrary.this.readShort();
                this.RegionNum[n2] = 2;
                this.RegionID[n2] = new byte[this.RegionNum[n2]];
                this.RegionX[n2] = new short[this.RegionNum[n2]];
                this.RegionY[n2] = new short[this.RegionNum[n2]];
                this.RegionW[n2] = new short[this.RegionNum[n2]];
                this.RegionH[n2] = new short[this.RegionNum[n2]];
                for (n = this.RegionNum[n2] - 1; n >= 0; --n) {
                    this.RegionID[n2][n] = (byte)n;
                    this.RegionX[n2][n] = (short)SpriteLibrary.this.readInt();
                    this.RegionY[n2][n] = (short)SpriteLibrary.this.readInt();
                    this.RegionW[n2][n] = (short)(SpriteLibrary.this.readInt() - this.RegionX[n2][n]);
                    this.RegionH[n2][n] = (short)(SpriteLibrary.this.readInt() - this.RegionY[n2][n]);
                }
                this.ModuleUsed[n2] = SpriteLibrary.this.readInt();
                this.ModuleIndex[n2] = new short[this.ModuleUsed[n2]];
                this.ModuleExcX[n2] = new short[this.ModuleUsed[n2]];
                this.ModuleExcY[n2] = new short[this.ModuleUsed[n2]];
                for (n = 0; n < this.ModuleUsed[n2]; ++n) {
                    this.ModuleIndex[n2][n] = SpriteLibrary.this.readShort();
                    this.ModuleExcX[n2][n] = SpriteLibrary.this.readShort();
                    this.ModuleExcY[n2][n] = SpriteLibrary.this.readShort();
                    SpriteLibrary.this.index += 2;
                }
            }
            this.ActionNum = SpriteLibrary.this.readInt();
            this.ActionIndex = new int[this.ActionNum];
            this.FrameUsed = new int[this.ActionNum];
            this.FrameIndex = new short[this.ActionNum][];
            this.ActionRate = new byte[this.ActionNum];
            for (n2 = 0; n2 < this.ActionNum; ++n2) {
                this.ActionIndex[n2] = SpriteLibrary.getActionIndex(SpriteLibrary.this.readString(32));
                this.ActionRate[n2] = (byte)Math.max(1, SpriteLibrary.this.readShort() * 50 / 100);
                this.FrameUsed[n2] = SpriteLibrary.this.readInt();
                this.FrameIndex[n2] = new short[this.FrameUsed[n2]];
                for (n = 0; n < this.FrameUsed[n2]; ++n) {
                    this.FrameIndex[n2][n] = SpriteLibrary.this.readShort();
                }
            }
        }
    }
}

