/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextBox {
    private String text;
    private int textLength;
    private int width;
    private int height;
    private Font font = Font.getFont((int)64, (int)0, (int)0);
    private int maxLineNum;
    private int lineSize;
    private int totalPage;
    private int[] lineNum;
    private int[] linePos;
    private int currentLen;
    private int currentWord;
    private int currentIndex;
    private int currentLine;
    private int totalLine;
    private int lineIndex;
    private int pageIndex;

    public TextBox() {
        this.setBoxSize(176, 208);
    }

    public void Close() {
        this.text = null;
        this.lineNum = null;
        this.linePos = null;
    }

    private void resetBox() {
        this.lineSize = this.width - 4;
        this.maxLineNum = (this.height - 2) / this.font.getHeight();
        if (this.text != null) {
            this.setString(this.text);
        }
    }

    private void newLine(int n) {
        ++this.currentLine;
        this.currentIndex -= this.currentWord;
        this.currentWord = 0;
        this.currentLen = 0;
        this.linePos[++this.lineIndex] = this.currentIndex - (n << 1);
        this.linePos[++this.lineIndex] = this.currentIndex + 1;
        if (this.currentLine == this.maxLineNum) {
            ++this.totalPage;
            this.totalLine += this.currentLine;
            this.lineNum[++this.pageIndex] = this.totalLine;
            this.currentLine = 0;
        }
    }

    public void setString(String string) {
        this.text = string;
        this.textLength = string.length();
        this.lineNum = new int[this.textLength + 1];
        this.linePos = new int[this.textLength << 1];
        this.currentIndex = 0;
        this.currentWord = 0;
        this.currentLen = 0;
        this.currentLine = 0;
        this.totalLine = 0;
        this.pageIndex = 0;
        this.lineIndex = 0;
        this.lineNum[this.pageIndex] = 0;
        this.linePos[this.lineIndex] = 0;
        this.totalPage = 0;
        while (this.currentIndex < this.textLength) {
            String string2 = string.substring(this.currentIndex, this.currentIndex + 1);
            if (string2.compareTo("A") >= 0 && string2.compareTo("z") <= 0) {
                this.currentLen += this.font.stringWidth(string2);
                ++this.currentWord;
                if (this.currentLen == this.lineSize) {
                    if (this.currentIndex == this.textLength - 1 || string.substring(this.currentIndex + 1, this.currentIndex + 2).compareTo("A") >= 0 && string.substring(this.currentIndex + 1, this.currentIndex + 2).compareTo("z") <= 0) {
                        this.currentIndex -= this.currentWord;
                        this.currentWord = 0;
                    }
                    this.newLine(0);
                } else if (this.currentLen > this.lineSize) {
                    this.currentIndex -= this.currentWord;
                    this.currentWord = 0;
                    this.newLine(0);
                }
                ++this.currentIndex;
                continue;
            }
            if (this.currentLen == 0 && string2.equals(" ")) {
                this.currentWord = 0;
                this.linePos[this.lineIndex] = ++this.currentIndex;
                continue;
            }
            if (string2.equals("/")) {
                ++this.currentIndex;
                this.currentWord = 0;
                if (this.currentIndex >= this.textLength) continue;
                string2 = string.substring(this.currentIndex, this.currentIndex + 1);
                if (string2.equals("n")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    this.newLine(1);
                } else if (string2.equals("p")) {
                    if (this.currentIndex == this.textLength - 1) {
                        --this.currentIndex;
                        break;
                    }
                    ++this.currentLine;
                    this.currentIndex -= this.currentWord;
                    this.currentWord = 0;
                    this.currentLen = 0;
                    this.linePos[++this.lineIndex] = this.currentIndex - 2;
                    this.linePos[++this.lineIndex] = this.currentIndex + 1;
                    ++this.totalPage;
                    this.totalLine += this.currentLine;
                    this.lineNum[++this.pageIndex] = this.totalLine;
                    this.currentLine = 0;
                } else {
                    this.currentLen += this.font.stringWidth(string2);
                    if (this.currentLen >= this.lineSize) {
                        if (this.currentLen > this.lineSize) {
                            --this.currentIndex;
                        }
                        this.newLine(0);
                    }
                    --this.currentIndex;
                }
                ++this.currentIndex;
                continue;
            }
            this.currentWord = 0;
            this.currentLen += this.font.stringWidth(string2);
            if (this.currentLen >= this.lineSize) {
                if (this.currentLen > this.lineSize) {
                    --this.currentIndex;
                }
                this.newLine(0);
            }
            ++this.currentIndex;
        }
        if (this.linePos[this.lineIndex] < this.currentIndex - 1) {
            ++this.totalPage;
            this.totalLine += this.currentLine + 1;
            this.linePos[++this.lineIndex] = this.currentIndex - 1;
            this.lineNum[++this.pageIndex] = this.totalLine;
        }
    }

    public void setFont(Font font) {
        this.font = font;
        this.resetBox();
    }

    public void setBoxSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.resetBox();
    }

    public int page() {
        return Math.max(1, this.totalPage);
    }

    public void paintText(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(n3);
        graphics.setFont(this.font);
        for (int i = 0; i < this.lineNum[n4 + 1] - this.lineNum[n4]; ++i) {
            graphics.drawString(this.text.substring(this.linePos[i + this.lineNum[n4] << 1], this.linePos[(i + this.lineNum[n4] << 1) + 1] + 1), n + (this.width >> 1), n2 + (this.height - (this.lineNum[n4 + 1] - this.lineNum[n4]) * (this.font.getHeight() + 2) >> 1) + i * (this.font.getHeight() + 2), 17);
        }
        graphics.setClip(0, 0, 176, 208);
    }
}

