/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class GameMap {
    public static final byte ITEM_X = 0;
    public static final byte ITEM_Y = 1;
    public static final byte ITEM_TYPE = 2;
    public static final byte ITEM_ST = 3;
    public static final byte ITEM_ID = 4;
    public static final byte ITEM_CUR = 5;
    public static final byte ROLE0SHORT = 0;
    public static final byte ZHUFLY = 1;
    public static final byte CLOUDSHOT = 2;
    public static final byte LIFE = 3;
    public static final byte HEART = 4;
    public static final byte HITBOX = 5;
    public static final byte ICE = 6;
    public static final byte DANG = 7;
    public static final byte JIEJIE = 8;
    public static final byte STONE = 9;
    public static final byte GAOYAO = 10;
    public static final byte LAND = 11;
    public static final byte SWITCH = 12;
    public static final byte TIME = 13;
    public static final byte KONG = 14;
    public static final byte OPEN = 2;
    public static final byte CLOSE = 3;
    public static final byte IDLE = 4;
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte UP = 5;
    public static final byte DOWN = 6;
    public static final byte STOP = 7;
    public static final byte STOP2 = 10;
    public static final byte TALK = 8;
    public static final byte MOVE = 9;
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[] tileProperties;
    String[] name;
    static short[][][] imgNpcData;
    static int setOffX;
    static int setOffY;
    int w;
    int h;
    byte[] mapData;
    static GameEngine engine;
    static String[] areaName;
    static int deadTime;
    static int superTime;
    public static final byte BG_\u91ce\u5916 = 0;
    public static final byte BG_\u96ea\u5730 = 1;
    public static final byte BG_\u5730\u4e0b = 2;
    public static final byte BG_\u7687\u5bab = 3;
    public static byte SCEEN_MOVE;
    static boolean isMoveScreen;
    int posX;
    int posY;
    public static final byte B_BOX = 0;
    public static final byte B_FIRE = 1;
    public static final byte B_STONE = 2;
    public static final byte B_TRAP = 3;
    public static final byte B_TRAP2 = 4;
    public static final byte B_X = 1;
    public static final byte B_Y = 2;
    public static final byte B_TYPE = 0;
    public static final byte B_ST = 4;
    public static final byte B_INDEX = 5;
    public static final byte B_CURINDEX = 6;
    public static final byte B_DIR = 3;
    public static final byte B_W = 7;
    public static final byte B_H = 8;
    public static final byte B_ST_1 = 0;
    public static final byte B_ST_2 = 1;
    public static final byte B_ST_3 = 2;
    public static final byte B_ST_4 = 3;
    public static final byte B_DIR_L = 0;
    public static final byte B_DIR_R = 1;
    static short[][] bloadData;
    final int[][] decAttr = new int[][]{{0, 30, 0, 0, 0, 0, 36, 0}, {1, 29, 0, 0, 0, 0, 36, 0}, {2, 16, 0, 0, 0, 0, 37, 0}, {3, 10, 0, 0, 82, 52, 38, 0}, {4, 11, 0, 0, 33, 52, 38, 0}, {5, 12, 0, 0, 0, 0, 39, 0}, {6, 14, 0, 0, 0, 0, 39, 0}, {7, 31, 0, 0, 0, 0, 39, 0}, new int[0], {9, 33, 0, 0, 66, 72, 39, 0}, new int[0], {11, 35, 0, 0, 0, 0, 39, 0}, {12, 36, 0, 0, 0, 0, 39, 0}, {13, 26, 0, 0, 66, 72, 39, 0}, {14, 34, 0, 0, 0, 0, 52, 0}, {15, 24, 0, 0, 226, 156, 40, 0}, {16, 25, 0, 0, 27, 69, 52, 0}};
    final int[][] decAttr2 = new int[][]{{0, 38, 0, 0, 180, 209, 40, 0}, {1, 8, 0, 0, 71, 46, 40, 0}, {2, 9, 0, 0, 45, 66, 40, 0}, {3, 17, 0, 0, 28, 44, 40, 0}, {4, 18, 0, 0, 33, 33, 40, 0}, {5, 32, 0, 0, 83, 68, 39, 0}};
    final int[][] decAttr3 = new int[][]{{0, 39, 0, 0, 96, 180, 40, 0}, {1, 28, 0, 0, 251, 85, 40, 0}, {2, 20, 0, 0, 31, 70, 40, 0}, {3, 19, 0, 0, 40, 57, 40, 0}, {4, 21, 0, 0, 28, 57, 40, 0}};
    final int[][] decAttr4 = new int[][]{{0, 39, 0, 0, 96, 180, 40, 0}, {1, 27, 0, 0, 58, 31, 40, 0}, {2, 23, 0, 0, 15, 41, 40, 0}, {3, 13, 0, 0, 57, 67, 40, 0}, {4, 22, 0, 0, 39, 58, 40, 0}, {5, 20, 0, 0, 31, 70, 40, 0}};
    final byte decAttr_ID;
    final byte decAttr_Img_ID;
    final byte decAttr_AdjustX = (byte)2;
    final byte decAttr_AdjustY = (byte)3;
    final byte decAttr_Img_W = (byte)4;
    final byte decAttr_Img_H = (byte)5;
    final byte decAttr_Layer = (byte)6;
    final byte decAttr_Index = (byte)7;
    final byte D_SHITOU2;
    final byte D_SHITOU1;
    final byte D_DASHU2 = (byte)2;
    final byte D_CAO1 = (byte)3;
    final byte D_CAO2 = (byte)4;
    final byte D_CHELUN = (byte)5;
    final byte D_DASHU1 = (byte)6;
    final byte D_SHUGAN = (byte)7;
    final byte D_BIRD = (byte)8;
    final byte D_SHUZHUANG = (byte)9;
    final byte D_TA1 = (byte)11;
    final byte D_TA2 = (byte)12;
    final byte D_QIZI = (byte)13;
    final byte D_SUISHI = (byte)14;
    final byte D_BING1;
    final byte D_BING2;
    final byte D_DENG1 = (byte)2;
    final byte D_DENG2 = (byte)3;
    final byte D_SHUIJING = (byte)4;
    final byte D_XUESHU = (byte)5;
    final byte D_ZZ;
    final byte D_SD;
    final byte D_DX = (byte)2;
    final byte D_DJ = (byte)3;
    final byte D_HB = (byte)4;
    final byte D_QQ;
    final byte D_LT = (byte)2;
    final byte D_D = (byte)3;
    final byte D_HT = (byte)4;
    final byte D_Dx2 = (byte)5;
    final byte[][] c_HB = new byte[][]{{0, 0, 27, 28}, {27, 0, 28, 29}, {0, 35, 28, 28}, {29, 30, 26, 33}, {10, 64, 12, 14}, {28, 64, 16, 14}};
    final byte[][] c_HT = new byte[][]{{0, 0, 28, 58}, {28, 0, 11, 11}, {28, 11, 11, 12}, {28, 23, 11, 13}};
    final byte[][] f_HB = new byte[][]{{5, 6, 0, 5, 0, 4, 8, -14, 7, 0, 0, 0, -28, 0, 0}, {1, 0, -28, 0, 0, 4, 9, -14, 7, 0, 5, 7, 0, 5, 0}, {2, 0, -28, 0, 0, 4, 9, -14, 7, 0, 5, 7, 0, 5, 0}, {3, 0, -28, 0, 0, 4, 7, -14, 7, 0, 5, 5, 0, 5, 0}};
    byte DEC_STATUS;
    short[][] decCoor;
    byte decCoor_ID = 0;
    byte decCoor_X = 1;
    byte decCoor_Y = (byte)2;
    byte decCoor_Trans = (byte)3;
    byte decCoor_Index = (byte)4;
    int mapID;
    String mapName;
    String fileName;
    int weather;
    String music;
    static short bg;
    static int BGM;
    static Event event;
    static String command;

    public void free() {
        this.mapData = null;
        System.gc();
    }

    public GameMap(GameEngine en, int sw, int sh) {
        this.decAttr_ID = 0;
        this.decAttr_Img_ID = 1;
        this.D_SHITOU2 = 0;
        this.D_SHITOU1 = 1;
        this.D_BING1 = 0;
        this.D_BING2 = 1;
        this.D_ZZ = 0;
        this.D_SD = 1;
        this.D_QQ = 1;
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void init(int GameRank) {
        this.free();
        this.init(Script.mapProperty);
        this.loadMap("/map/" + this.fileName);
        Tools.createImage(this.name, 1);
        bloadData = null;
        this.posX = screenWidth / 2;
        this.posY = screenHeight / 2 + 20;
        this.decCoor = this.readItemData("deccoor" + this.mapID + ".dat");
        this.DEC_STATUS = (byte)GameEngine.nextInt(2);
        switch (this.mapID) {
            case 11: {
                bloadData = new short[][]{{0, 224, 384, 1, 0, 0, 0, 0, 0}, {0, 928, 384, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 12: {
                bloadData = new short[][]{{0, 704, 384, 0, 0, 0, 0, 0, 0}, {0, 1264, 480, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 13: {
                bloadData = new short[][]{{0, 256, 384, 1, 0, 0, 0, 0, 0}, {0, 1504, 416, 0, 0, 0, 0, 0, 0}};
                break;
            }
            case 14: {
                bloadData = new short[][]{{0, 64, 448, 1, 0, 0, 0, 0, 0}, {0, 512, 448, 0, 0, 0, 0, 0, 0}};
                break;
            }
            case 17: {
                bloadData = new short[][]{{0, 128, 480, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 18: {
                bloadData = new short[][]{{1, 688, 384, 0, 0, 0, 0, 0, 0}, {1, 1200, 384, 0, 0, 0, 0, 0, 0}, {1, 1712, 384, 0, 0, 0, 0, 0, 0}};
                break;
            }
            case 20: {
                bloadData = new short[][]{{0, 128, 480, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 23: {
                bloadData = new short[][]{{2, 160, 448, 0, 0, 0, 0, 0, 0}, {3, 1344, 448, 0, 0, 0, 0, 0, 0}, {3, 1440, 448, 0, 0, 0, 0, 0, 0}, {3, 1536, 448, 0, 0, 0, 0, 0, 0}, {4, 1184, 192, 1, 0, 0, 0, 0, 0}, {4, 1664, 336, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 24: {
                bloadData = new short[][]{{3, 320, 960, 0, 0, 0, 0, 0, 0}, {3, 416, 960, 0, 0, 0, 0, 0, 0}, {3, 512, 960, 0, 0, 0, 0, 0, 0}, {3, 256, 672, 0, 0, 0, 0, 0, 0}, {3, 352, 672, 0, 0, 0, 0, 0, 0}, {3, 448, 672, 0, 0, 0, 0, 0, 0}, {4, 768, 352, 1, 0, 0, 0, 0, 0}, {4, 32, 864, 0, 0, 0, 0, 0, 0}};
                break;
            }
            case 25: {
                bloadData = new short[][]{{3, 464, 640, 0, 0, 0, 0, 0, 0}, {3, 560, 640, 0, 0, 0, 0, 0, 0}, {3, 656, 640, 0, 0, 0, 0, 0, 0}, {3, 320, 224, 0, 0, 0, 0, 0, 0}, {3, 416, 224, 0, 0, 0, 0, 0, 0}, {3, 512, 224, 0, 0, 0, 0, 0, 0}, {4, 704, 384, 1, 0, 0, 0, 0, 0}, {4, 32, 192, 0, 0, 0, 0, 0, 0}, {4, 1216, 384, 1, 0, 0, 0, 0, 0}, {4, 1216, 192, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 29: {
                bloadData = new short[][]{{0, 256, 672, 1, 0, 0, 0, 0, 0}, {3, 960, 128, 0, 0, 0, 0, 0, 0}, {3, 1056, 128, 0, 0, 0, 0, 0, 0}, {3, 1152, 128, 0, 0, 0, 0, 0, 0}, {4, 416, 160, 0, 0, 0, 0, 0, 0}, {4, 928, 448, 0, 0, 0, 0, 0, 0}, {4, 1536, 96, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 30: {
                bloadData = new short[][]{{2, 176, 1472, 0, 0, 0, 0, 0, 0}, {3, 320, 1056, 0, 0, 0, 0, 0, 0}, {3, 416, 1056, 0, 0, 0, 0, 0, 0}, {3, 304, 320, 0, 0, 0, 0, 0, 0}, {3, 400, 320, 0, 0, 0, 0, 0, 0}, {4, 704, 480, 1, 0, 0, 0, 0, 0}, {4, 704, 672, 1, 0, 0, 0, 0, 0}, {4, 64, 1024, 0, 0, 0, 0, 0, 0}, {4, 704, 1280, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 31: {
                bloadData = new short[][]{{3, 416, 512, 0, 0, 0, 0, 0, 0}, {3, 272, 1248, 0, 0, 0, 0, 0, 0}, {4, 64, 1120, 0, 0, 0, 0, 0, 0}, {4, 480, 880, 1, 0, 0, 0, 0, 0}};
                break;
            }
            case 32: {
                bloadData = new short[][]{{0, 704, 608, 1, 0, 0, 0, 0, 0}, {1, 160, 608, 0, 0, 0, 0, 0, 0}, {3, 960, 480, 0, 0, 0, 0, 0, 0}, {3, 864, 480, 0, 0, 0, 0, 0, 0}, {3, 896, 192, 0, 0, 0, 0, 0, 0}, {3, 800, 192, 0, 0, 0, 0, 0, 0}, {3, 704, 192, 0, 0, 0, 0, 0, 0}, {4, 800, 576, 1, 0, 0, 0, 0, 0}, {4, 32, 320, 0, 0, 0, 0, 0, 0}, {4, 32, 160, 0, 0, 0, 0, 0, 0}};
                break;
            }
            case 39: {
                bloadData = new short[][]{{0, 620, 352, 0, 0, 0, 0, 0, 0}, {1, 510, 352, 0, 0, 0, 0, 0, 0}};
            }
        }
        if (bloadData != null) {
            int i = 0;
            while (i < bloadData.length) {
                if (bloadData[i][0] == 4 && bloadData[i][3] == 1) {
                    short[] sArray = bloadData[i];
                    sArray[1] = (short)(sArray[1] + 36);
                }
                ++i;
            }
        }
    }

    public void setMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 240, 320);
    }

    public void setTile() {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData.length && i >= 0 && this.mapData[i] != -1) {
                    int dataTemp = GameMap.getLow(this.mapData[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    Tools.addObject(200 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, (byte)GameMap.getTrans(this.mapData[i]), 42);
                }
                ++i;
            }
            ++j;
        }
    }

    private void drawSuper() {
        int col = MyGameCanvas.gameTime % 2 == 0 ? 0 : 0xFFFFFF;
        Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, col, 35);
    }

    private void drawFlash() {
        int col = MyGameCanvas.gameTime % 2 == 0 ? 0xFF0000 : 0xFFFFFF;
        Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, col, 35);
    }

    public void setMap(Graphics g) {
        if (superTime > 0) {
            --superTime;
            this.drawSuper();
        }
        if (deadTime > 0) {
            this.drawFlash();
            if (--deadTime == 0 && Script.isNormal) {
                GameMIDlet.sleepTime = (short)50;
                MyGameCanvas.toPayState(5);
            } else if (deadTime == 0) {
                GameMIDlet.sleepTime = (short)50;
            }
        }
        this.setMapBG();
        if (this.mapData != null) {
            this.setTile();
        }
        this.setMapFG();
    }

    public static void drawFullScreenBG(int y, int y2, byte imgIndex, int bgColor, int bgColor2, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int imgH = Tools.getImage(imgIndex).getHeight();
        int times = screenWidth / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        int startPos2 = y;
        Tools.addObject((byte)1, setOffX, setOffY, screenWidth, mapSize[1] * tileWidth - screenHeight, true, 20, bgColor2, level - 1);
        if (bgColor != -1) {
            Tools.addObject((byte)1, setOffX, startPos2 + imgH + y2, screenWidth, mapSize[1] * tileWidth - imgH - y2, true, 20, bgColor, level - 1);
        }
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * imgW, startPos2 + y2, 0, 0, imgW, imgH, 20, (byte)0, level);
            ++i;
        }
    }

    public static void drawMountains(int speed, int w, int level) {
        int times = screenWidth / w + 2;
        int startPos = setOffX * speed * 10 / 1000;
        int startPos2 = mapSize[1] * tileWidth - screenHeight;
        while (setOffX - startPos >= w) {
            startPos += w;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(56, startPos + i * w + 75, 238 + startPos2, 0, 0, 87, 149, 36, (byte)0, level);
            Tools.addObject(56, startPos + i * w + 311, 225 + startPos2, 0, 0, 87, 149, 36, (byte)0, level);
            Tools.addObject(56, startPos + i * w + 454, 345 + startPos2, 0, 0, 87, 149, 36, (byte)0, level);
            Tools.addObject(56, startPos + i * w + 703, 206 + startPos2, 0, 0, 87, 149, 36, (byte)0, level - 1);
            Tools.addObject(56, startPos + i * w + 187, 259 + startPos2, 87, 5, 63, 144, 36, (byte)0, level - 1);
            Tools.addObject(56, startPos + i * w + 287, 275 + startPos2, 87, 5, 63, 144, 36, (byte)0, level);
            Tools.addObject(56, startPos + i * w + 601, 259 + startPos2, 87, 5, 63, 144, 36, (byte)0, level);
            Tools.addObject(56, startPos + i * w + 792, 289 + startPos2, 87, 5, 63, 144, 36, (byte)0, level + 1);
            Tools.addObject(57, startPos + i * w + 217, 224 + startPos2 - 80, 0, 0, 87, 145, 36, (byte)0, level - 3);
            Tools.addObject(57, startPos + i * w + 392, 261 + startPos2 - 80, 0, 0, 87, 145, 36, (byte)0, level - 3);
            Tools.addObject(57, startPos + i * w + 630, 228 + startPos2 - 80, 0, 0, 87, 145, 36, (byte)0, level - 3);
            Tools.addObject(57, startPos + i * w + 873, 261 + startPos2 - 80, 0, 0, 87, 145, 36, (byte)0, level - 3);
            Tools.addObject(57, startPos + i * w + 152, 293 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            Tools.addObject(57, startPos + i * w + 246, 293 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            Tools.addObject(57, startPos + i * w + 452, 282 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            Tools.addObject(57, startPos + i * w + 554, 310 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            Tools.addObject(57, startPos + i * w + 593, 254 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            Tools.addObject(57, startPos + i * w + 766, 293 + startPos2 - 80, 88, 3, 62, 142, 36, (byte)0, level - 2);
            ++i;
        }
    }

    public static void drawTrees(byte imgIndex, int bgColor, int speed, int w, int level) {
        int times = screenWidth / w + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= w) {
            startPos += w;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * w, mapSize[1] * tileWidth - 96, 36, (byte)0, level);
            ++i;
        }
    }

    public static void drawSD(byte imgIndex, int speed, int w, int h, int level) {
        int times = screenWidth / w + 2;
        int startPos = setOffX * speed * 10 / 1000;
        int startPos2 = setOffY * 70 * 10 / 1000;
        while (setOffX - startPos >= w) {
            startPos += w;
        }
        while (setOffY - startPos2 >= h) {
            startPos2 += h;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * w, startPos2, 20, (byte)0, level);
            Tools.addObject(imgIndex, startPos + i * w, startPos2 + 256, 20, (byte)0, level);
            Tools.addObject(imgIndex, startPos + i * w, startPos2 + 512, 20, (byte)0, level);
            ++i;
        }
    }

    public static void drawSD2(byte imgIndex, int speed, int w, int h, int level) {
        int times = screenWidth / w + 2;
        int startPos = setOffX * speed * 10 / 1000;
        int startPos2 = setOffY * 70 * 10 / 1000;
        while (setOffX - startPos >= w) {
            startPos += w;
        }
        while (setOffY - startPos2 >= h) {
            startPos2 += h;
        }
        int i = 0;
        while (i < times) {
            Tools.addObject(imgIndex, startPos + i * w, startPos2, 20, (byte)0, level);
            Tools.addObject(imgIndex, startPos + i * w, startPos2 + 256, 20, (byte)0, level);
            Tools.addObject(imgIndex, startPos + i * w, startPos2 + 512, 20, (byte)0, level);
            ++i;
        }
    }

    public void setMapFG() {
        switch (bg) {
            case 0: {
                this.drawDecorate();
                break;
            }
            case 1: {
                this.drawDecorate2();
                break;
            }
            case 2: {
                this.drawDecorate3();
                break;
            }
            case 3: {
                this.drawDecorate4();
            }
        }
        if (GameEngine.gameRank == 45) {
            Tools.addObject(24, 0, mapSize[1] * tileWidth - 64, 36, (byte)0, 40);
            Tools.addObject(25, 101, mapSize[1] * tileWidth - 59, 36, (byte)0, 52);
        }
        this.drawBload();
    }

    public void setMapBG() {
        switch (bg) {
            case 0: {
                GameMap.drawFullScreenBG(mapSize[1] * tileWidth - screenHeight, -64, (byte)55, 0xFFFFFF, 0xFFFFFF, 95, -1);
                GameMap.drawMountains(70, 884, 2);
                break;
            }
            case 1: {
                GameMap.drawFullScreenBG(mapSize[1] * tileWidth - screenHeight, -32, (byte)58, 0xFFFFFF, 5348591, 95, -1);
                GameMap.drawTrees((byte)59, 0xFFFFFF, 70, 237, 2);
                break;
            }
            case 2: {
                Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, 327708, -1);
                GameMap.drawSD2((byte)61, 90, 240, 512, 0);
                GameMap.drawSD((byte)60, 80, 240, 512, 1);
                break;
            }
            case 3: {
                int i = 0;
                while (i < mapSize[0] * tileWidth / Tools.getImage(63).getWidth() + 1) {
                    Tools.addObject(63, i * Tools.getImage(63).getWidth(), mapSize[1] * tileWidth - 64 - screenHeight / 2, 36, (byte)0, 0);
                    ++i;
                }
                int i2 = 0;
                while (i2 < mapSize[0] * tileWidth / 240 + 1) {
                    Tools.addObject(62, i2 * 240, mapSize[1] * tileWidth - 64, 36, (byte)0, 0);
                    ++i2;
                }
                Tools.addObject((byte)1, setOffX, setOffY, screenWidth, screenHeight, true, 20, 0, -1);
            }
        }
        GameSprite.initRoadLine(bg);
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.posX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.posY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = GameEngine.sprite[GameEngine.spriteIndex].dir == 3 ? (Math.abs(x - setOffX - (screenWidth - this.posX)) > SCEEN_MOVE ? (x - setOffX - (screenWidth - this.posX) >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - (screenWidth - this.posX)))) : (Math.abs(x - setOffX - this.posX) > SCEEN_MOVE ? (x - setOffX - this.posX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.posX)));
        setOffX = (short)Math.max(setOffX, 0);
        setOffX = (short)Math.min(setOffX, mapSize[0] * tileWidth - screenWidth);
        setOffY = Math.abs(y - setOffY - this.posY) > SCEEN_MOVE ? (y - setOffY - this.posY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.posY));
        setOffY = (short)Math.max(setOffY, 0);
        setOffY = (short)Math.min(setOffY, mapSize[1] * tileHight - screenHeight);
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            GameMap.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        int range = 6;
        short dx = (short)(x - this.posX);
        dx = (short)Math.max(dx, 0);
        dx = (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth);
        short dy = (short)(y - this.posY);
        dy = (short)Math.max(dy, 0);
        dy = (short)Math.min(dy, mapSize[1] * tileHight - screenHeight);
        return Math.abs(setOffX - dx) < range && Math.abs(setOffY - dy) < range;
    }

    public boolean isDownRight(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)1) && GameMap.getTrans(this.inMapData(x, y)) == 0;
    }

    public boolean isDownLeft(int x, int y) {
        if (this.mapData == null || this.inMapData(x, y) == -1) {
            return false;
        }
        return Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)1) && GameMap.getTrans(this.inMapData(x, y)) == 1;
    }

    public boolean canRun(int x, int y) {
        return this.mapData == null || this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)15);
    }

    public boolean canUp(int x, int y) {
        return this.mapData == null || this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)13);
    }

    public boolean canPassShot(int x, int y) {
        return this.mapData == null || this.inMapData(x, y) == -1 || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)0) || Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)15) && Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)14) && Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)13);
    }

    public boolean canPassShot_C(int x, int y) {
        return bloadData == null || this.hitBload_Shot(x, y) == -1;
    }

    public boolean canLand(int x, int y) {
        return this.mapData != null && this.inMapData(x, y) != -1 && !Tools.getProperties(this.tileProperties[GameMap.getLow(this.inMapData(x, y))], (byte)14);
    }

    public boolean canLand_C(int x, int y) {
        return bloadData != null && this.hitBload(x, y) != -1;
    }

    private byte inMapData(int x, int y) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= this.mapData.length || y > mapSize[1] * tileHight || x > mapSize[0] * tileWidth || x < 0) {
            return -1;
        }
        return this.mapData[n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y) {
        return GameMap.getIndex(this.inMapData(x, y));
    }

    public void loadMap(String file) {
        this.mapData = null;
        this.tileProperties = null;
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(file));
        if (in == null) {
            return;
        }
        try {
            GameMap.mapSize[0] = GameMap.bToi(in.readByte());
            GameMap.mapSize[1] = GameMap.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            this.mapData = new byte[size];
            in.read(this.mapData);
            int len = in.readShort();
            this.name = new String[len];
            this.tileProperties = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[i] = new String(names);
                this.tileProperties[i] = in.readShort();
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void setItemST(byte st, int b2, short[][] data) {
        data[b2][4] = 0;
        data[b2][3] = st;
    }

    /*
     * Enabled aggressive block sorting
     */
    public byte hitBload_Shot(int x, int y) {
        if (bloadData == null) {
            return -1;
        }
        int i = 0;
        while (i < bloadData.length) {
            switch (bloadData[i][0]) {
                case 0: {
                    if (x <= bloadData[i][1] - tileHight / 2 || x >= bloadData[i][1] + tileHight + tileHight / 2 || y >= bloadData[i][2] || y <= bloadData[i][2] - tileHight) break;
                    if (bloadData[i][4] == 0) {
                        if (GameEngine.sprite[GameEngine.spriteIndex].dir == 3 && bloadData[i][3] == 0) {
                            GameMap.bloadData[i][4] = 1;
                            return (byte)i;
                        }
                    }
                    if (bloadData[i][4] != 0) return (byte)i;
                    if (GameEngine.sprite[GameEngine.spriteIndex].dir != 1) return (byte)i;
                    if (bloadData[i][3] != 1) return (byte)i;
                    GameMap.bloadData[i][4] = 1;
                    return (byte)i;
                }
            }
            ++i;
        }
        return -1;
    }

    public byte hitBload(int x, int y) {
        if (bloadData == null) {
            return -1;
        }
        int i = 0;
        while (i < bloadData.length) {
            switch (bloadData[i][0]) {
                case 2: {
                    if (bloadData[i][4] == 1 || x <= bloadData[i][1] || x >= bloadData[i][1] + tileHight || y >= bloadData[i][2] || y <= bloadData[i][2] - 70) break;
                    return (byte)i;
                }
                case 0: {
                    if (x <= bloadData[i][1] || x >= bloadData[i][1] + tileHight || y >= bloadData[i][2] || y <= bloadData[i][2] - tileHight) break;
                    return (byte)i;
                }
                case 1: {
                    if (bloadData[i][4] == 2 || x <= bloadData[i][1] || x >= bloadData[i][1] + tileHight || y >= bloadData[i][2] || y <= bloadData[i][2] - tileHight * 4) break;
                    return (byte)i;
                }
            }
            ++i;
        }
        return -1;
    }

    public void drawBload() {
        if (bloadData == null) {
            return;
        }
        int imgIndex = -1;
        short[][] imgdata = null;
        int drawLevel = 45;
        byte[] motion = null;
        byte trans = 0;
        int anchor = 36;
        int i = 0;
        while (i < bloadData.length) {
            block47: {
                block0 : switch (bloadData[i][0]) {
                    case 3: {
                        imgdata = new short[][]{{0, 72, 37, 1}, {0, 0, 37, 28}, {0, 0, 37, 50}, {0, 0, 37, 73}};
                        imgIndex = 138;
                        drawLevel = 45;
                        anchor = 36;
                        switch (bloadData[i][4]) {
                            case 0: {
                                GameMap.bloadData[i][6] = 0;
                                GameMap.bloadData[i][7] = 37;
                                GameMap.bloadData[i][8] = 1;
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] < 30) break;
                                GameMap.bloadData[i][4] = 1;
                                GameMap.bloadData[i][5] = 0;
                                break;
                            }
                            case 1: {
                                motion = new byte[]{1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1};
                                GameMap.bloadData[i][6] = motion[bloadData[i][5]];
                                switch (bloadData[i][6]) {
                                    case 1: {
                                        GameMap.bloadData[i][7] = 37;
                                        GameMap.bloadData[i][8] = 28;
                                        break;
                                    }
                                    case 2: {
                                        GameMap.bloadData[i][7] = 37;
                                        GameMap.bloadData[i][8] = 50;
                                        break;
                                    }
                                    case 3: {
                                        GameMap.bloadData[i][7] = 37;
                                        GameMap.bloadData[i][8] = 73;
                                    }
                                }
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] < motion.length) break;
                                GameMap.bloadData[i][4] = 0;
                                GameMap.bloadData[i][5] = (short)GameEngine.nextInt(0, 20);
                            }
                        }
                        break;
                    }
                    case 4: {
                        imgdata = new short[][]{{56, 0, 17, 37}, {37, 0, 36, 37}, {21, 0, 52, 37}, {0, 0, 73, 37}};
                        imgIndex = 139;
                        drawLevel = 45;
                        if (bloadData[i][3] == 1) {
                            trans = 1;
                            anchor = 40;
                        } else {
                            trans = 0;
                            anchor = 36;
                        }
                        switch (bloadData[i][4]) {
                            case 0: {
                                GameMap.bloadData[i][6] = 0;
                                GameMap.bloadData[i][7] = 17;
                                GameMap.bloadData[i][8] = 37;
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] < 30) break;
                                GameMap.bloadData[i][4] = 1;
                                GameMap.bloadData[i][5] = 0;
                                break;
                            }
                            case 1: {
                                motion = new byte[]{1, 1, 2, 2, 3, 3, 3, 3, 2, 2, 1, 1};
                                GameMap.bloadData[i][6] = motion[bloadData[i][5]];
                                switch (bloadData[i][6]) {
                                    case 1: {
                                        GameMap.bloadData[i][7] = 36;
                                        GameMap.bloadData[i][8] = 37;
                                        break;
                                    }
                                    case 2: {
                                        GameMap.bloadData[i][7] = 52;
                                        GameMap.bloadData[i][8] = 37;
                                        break;
                                    }
                                    case 3: {
                                        GameMap.bloadData[i][7] = 73;
                                        GameMap.bloadData[i][8] = 37;
                                    }
                                }
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] < motion.length) break;
                                GameMap.bloadData[i][4] = 0;
                                GameMap.bloadData[i][5] = (short)GameEngine.nextInt(0, 20);
                            }
                        }
                        break;
                    }
                    case 2: {
                        imgdata = new short[][]{{0, 0, 35, 78}, {35, 5, 52, 73}, {2, 78, 65, 32}, {2, 110, 66, 21}, {1, 131, 68, 9}};
                        imgIndex = 134;
                        drawLevel = 45;
                        switch (bloadData[i][4]) {
                            case 0: {
                                GameMap.bloadData[i][6] = 0;
                                break;
                            }
                            case 1: {
                                motion = new byte[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 4, 4, 4};
                                short[] sArray = bloadData[i];
                                short s = (short)(sArray[5] + 1);
                                sArray[5] = s;
                                GameMap.bloadData[i][6] = s >= motion.length ? 4 : (short)motion[bloadData[i][5]];
                            }
                        }
                        break;
                    }
                    case 1: {
                        imgdata = new short[][]{{0, 0, 32, 122}, {33, 0, 40, 122}, {74, 17, 33, 105}, {0, 122, 56, 84}, {57, 152, 69, 54}, {58, 124, 68, 27}};
                        imgIndex = 52;
                        drawLevel = 45;
                        switch (bloadData[i][4]) {
                            case 0: {
                                byte[] motion2 = null;
                                short[][] imgData = null;
                                imgData = new short[][]{{0, 0, 40, 73}, {41, 0, 39, 76}, {81, 0, 35, 78}, {117, 0, 36, 77}};
                                motion2 = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                                Tools.addObject(53, bloadData[i][1] + 20, bloadData[i][2] - 60 + GameSprite.RoadLine, imgData[motion2[MyGameCanvas.gameTime % 8]], 3, (byte)0, drawLevel + 1);
                                GameMap.bloadData[i][6] = 0;
                                break;
                            }
                            case 1: {
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] >= 10) {
                                    GameMap.bloadData[i][6] = 1;
                                    break;
                                }
                                short[][] imgData = new short[][]{{0, 0, 40, 73}, {41, 0, 39, 76}, {81, 0, 35, 78}, {117, 0, 36, 77}};
                                byte[] motion2 = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                                Tools.addObject(53, bloadData[i][1] + 20, bloadData[i][2] - 60 + GameSprite.RoadLine, imgData[motion2[MyGameCanvas.gameTime % 8]], 3, (byte)0, drawLevel + 1);
                                break;
                            }
                            case 2: {
                                motion = new byte[]{2, 2, 2, 3, 3, 3, 4, 4, 5, 5};
                                short[] sArray = bloadData[i];
                                short s = (short)(sArray[5] + 1);
                                sArray[5] = s;
                                GameMap.bloadData[i][6] = s >= motion.length ? 5 : (short)motion[bloadData[i][5]];
                            }
                        }
                        break;
                    }
                    case 0: {
                        imgdata = new short[][]{{0, 0, 32, 32}, {32, 0, 32, 32}};
                        trans = bloadData[i][3] == 0 ? (byte)0 : 1;
                        imgIndex = 1;
                        drawLevel = 45;
                        switch (bloadData[i][4]) {
                            case 0: {
                                GameMap.bloadData[i][6] = 0;
                                break block0;
                            }
                            case 1: {
                                GameMap.bloadData[i][6] = 1;
                                motion = new byte[]{4, 4, 6, 8, 10, 14, 18};
                                if (bloadData[i][5] == 0) {
                                    GameEngine.AddBlastEffectList(bloadData[i][3] == 0 ? bloadData[i][1] + 32 - 7 : bloadData[i][1] - 7, bloadData[i][2] + 4, 17, bloadData[i][3] == 0 ? 3 : 1, 0);
                                }
                                GameMap.bloadData[i][1] = bloadData[i][3] == 0 ? (short)(bloadData[i][1] - motion[bloadData[i][5]]) : (short)(bloadData[i][1] + motion[bloadData[i][5]]);
                                short[] sArray = bloadData[i];
                                sArray[5] = (short)(sArray[5] + 1);
                                if (sArray[5] >= 7) {
                                    GameMap.bloadData[i][4] = 2;
                                    GameMap.bloadData[i][5] = 0;
                                    break block0;
                                }
                                break block47;
                            }
                            case 2: {
                                GameMap.bloadData[i][6] = 1;
                            }
                        }
                    }
                }
            }
            if (bloadData[i][6] != -1) {
                Tools.addObject(imgIndex, (int)bloadData[i][1], bloadData[i][2] + GameSprite.RoadLine, (short[])imgdata[bloadData[i][6]], anchor, trans, drawLevel);
            }
            ++i;
        }
    }

    public void drawDecorate4() {
        if (this.decCoor == null) {
            return;
        }
        byte[] motion = null;
        Object imgData = null;
        int i = 0;
        while (i < this.decCoor.length) {
            byte imgIndex = (byte)this.decAttr4[this.decCoor[i][this.decCoor_ID]][1];
            short x = this.decCoor[i][this.decCoor_X];
            short y = this.decCoor[i][this.decCoor_Y];
            int w = this.decAttr4[this.decCoor[i][this.decCoor_ID]][4];
            int h = this.decAttr4[this.decCoor[i][this.decCoor_ID]][5];
            byte trans = (byte)this.decCoor[i][this.decCoor_Trans];
            int layer = this.decAttr4[this.decCoor[i][this.decCoor_ID]][6];
            switch (this.decCoor[i][this.decCoor_ID]) {
                case 4: {
                    motion = new byte[]{1, 1, 2, 2, 3, 3};
                    Tools.addObject((int)imgIndex, (int)x, y - 54, this.c_HT[motion[this.decCoor[i][this.decCoor_Index]]], 33, trans, layer);
                    Tools.addObject((int)imgIndex, (int)x, (int)y, this.c_HT[0], 33, trans, layer);
                    short[] sArray = this.decCoor[i];
                    byte by = this.decCoor_Index;
                    sArray[by] = (short)(sArray[by] + 1);
                    if (sArray[by] <= 5) break;
                    this.decCoor[i][this.decCoor_Index] = 0;
                    break;
                }
                default: {
                    Tools.addObject(imgIndex, x, y, 36, trans, layer);
                }
            }
            ++i;
        }
    }

    public void drawDecorate3() {
        if (this.decCoor == null) {
            return;
        }
        byte[] motion = null;
        Object imgData = null;
        int i = 0;
        while (i < this.decCoor.length) {
            byte imgIndex = (byte)this.decAttr3[this.decCoor[i][this.decCoor_ID]][1];
            short x = this.decCoor[i][this.decCoor_X];
            short y = this.decCoor[i][this.decCoor_Y];
            int w = this.decAttr3[this.decCoor[i][this.decCoor_ID]][4];
            int h = this.decAttr3[this.decCoor[i][this.decCoor_ID]][5];
            byte trans = (byte)this.decCoor[i][this.decCoor_Trans];
            int layer = this.decAttr3[this.decCoor[i][this.decCoor_ID]][6];
            switch (this.decCoor[i][this.decCoor_ID]) {
                case 4: {
                    motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                    switch (motion[this.decCoor[i][this.decCoor_Index]]) {
                        case 1: 
                        case 2: {
                            x = (short)(x - 1);
                            break;
                        }
                        case 3: {
                            x = (short)(x + 1);
                        }
                    }
                    Tools.drawFrame(imgIndex, x, y, motion[this.decCoor[i][this.decCoor_Index]], this.c_HB, this.f_HB, 36, false, layer);
                    short[] sArray = this.decCoor[i];
                    byte by = this.decCoor_Index;
                    sArray[by] = (short)(sArray[by] + 1);
                    if (sArray[by] <= 7) break;
                    this.decCoor[i][this.decCoor_Index] = 0;
                    break;
                }
                default: {
                    Tools.addObject(imgIndex, x, y, 36, trans, layer);
                }
            }
            ++i;
        }
    }

    public void drawDecorate2() {
        if (this.decCoor == null) {
            return;
        }
        Object motion = null;
        Object imgData = null;
        int i = 0;
        while (i < this.decCoor.length) {
            byte imgIndex = (byte)this.decAttr2[this.decCoor[i][this.decCoor_ID]][1];
            short x = this.decCoor[i][this.decCoor_X];
            short y = this.decCoor[i][this.decCoor_Y];
            if (this.decCoor[i][this.decCoor_ID] == 11 || this.decCoor[i][this.decCoor_ID] == 12) {
                y = (short)(y - 12);
            }
            int w = this.decAttr2[this.decCoor[i][this.decCoor_ID]][4];
            int h = this.decAttr2[this.decCoor[i][this.decCoor_ID]][5];
            byte trans = (byte)this.decCoor[i][this.decCoor_Trans];
            int layer = this.decAttr2[this.decCoor[i][this.decCoor_ID]][6];
            switch (this.decCoor[i][this.decCoor_ID]) {
                default: 
            }
            Tools.addObject(imgIndex, x, y, 36, trans, layer);
            ++i;
        }
    }

    public void drawDecorate() {
        if (this.decCoor == null) {
            return;
        }
        if (this.DEC_STATUS == 2 && MyGameCanvas.gameTime % 20 == 0) {
            this.DEC_STATUS = 1;
        }
        if (MyGameCanvas.gameTime % 140 == 0) {
            switch (GameEngine.nextInt(2)) {
                case 0: {
                    this.DEC_STATUS = this.DEC_STATUS == 1 ? (byte)0 : 1;
                    int i = 0;
                    while (i < this.decCoor.length) {
                        this.decCoor[i][this.decCoor_Index] = 0;
                        ++i;
                    }
                    break;
                }
                case 1: {
                    this.DEC_STATUS = GameEngine.nextInt(2) == 0 ? (byte)0 : (byte)2;
                    int i = 0;
                    while (i < this.decCoor.length) {
                        this.decCoor[i][this.decCoor_Index] = 0;
                        ++i;
                    }
                    break;
                }
                case 2: {
                    this.DEC_STATUS = this.DEC_STATUS == 1 ? (GameEngine.nextInt(2) == 0 ? (byte)0 : (byte)2) : (byte)1;
                    int i = 0;
                    while (i < this.decCoor.length) {
                        this.decCoor[i][this.decCoor_Index] = 0;
                        ++i;
                    }
                    break;
                }
            }
        }
        byte[] motion = null;
        byte[][] imgData = null;
        int i = 0;
        while (i < this.decCoor.length) {
            byte imgIndex = (byte)this.decAttr[this.decCoor[i][this.decCoor_ID]][1];
            short x = this.decCoor[i][this.decCoor_X];
            int y = this.decCoor[i][this.decCoor_Y];
            if (this.decCoor[i][this.decCoor_ID] == 11 || this.decCoor[i][this.decCoor_ID] == 12) {
                y -= 12;
            }
            int w = this.decAttr[this.decCoor[i][this.decCoor_ID]][4];
            int h = this.decAttr[this.decCoor[i][this.decCoor_ID]][5];
            byte trans = (byte)this.decCoor[i][this.decCoor_Trans];
            int layer = this.decAttr[this.decCoor[i][this.decCoor_ID]][6];
            switch (this.decCoor[i][this.decCoor_ID]) {
                case 13: {
                    switch (this.DEC_STATUS) {
                        case 0: {
                            motion = new byte[]{1};
                            break;
                        }
                        case 1: {
                            motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
                            break;
                        }
                        case 2: {
                            motion = new byte[]{1, 2};
                        }
                    }
                    imgData = new byte[][]{{42, 0, 23, 68}, {65, 0, 24, 68}, {89, 0, 29, 68}};
                    Tools.addObject(imgIndex, x, y, 0, 0, 42, 68, 36, trans, layer);
                    Tools.addObject((int)imgIndex, x + 34, y - 76, imgData[motion[this.decCoor[i][this.decCoor_Index]]], 20, trans, layer);
                    break;
                }
                case 3: 
                case 4: 
                case 9: {
                    switch (this.DEC_STATUS) {
                        case 0: 
                        case 1: {
                            motion = new byte[]{0, 0, 0, 1, 1, 1};
                            break;
                        }
                        case 2: {
                            motion = new byte[]{0, 1};
                        }
                    }
                    Tools.addObject(imgIndex, x, y, 0, h / 2 * motion[this.decCoor[i][this.decCoor_Index]], w, h / 2, 36, this.decCoor[i][this.decCoor_ID] == 4 ? trans : (byte)0, layer);
                    break;
                }
                default: {
                    if (this.decCoor[i][this.decCoor_ID] == 0 || this.decCoor[i][this.decCoor_ID] == 1 || this.decCoor[i][this.decCoor_ID] == 2) {
                        // empty if block
                    }
                    Tools.addObject(imgIndex, x, y, 36, trans, layer);
                    if (this.decCoor[i][this.decCoor_ID] == 11 || this.decCoor[i][this.decCoor_ID] == 12) {
                        switch (this.DEC_STATUS) {
                            case 0: 
                            case 1: {
                                motion = new byte[]{0, 0, 0, 1, 1, 1};
                                break;
                            }
                            case 2: {
                                motion = new byte[]{0, 1};
                            }
                        }
                        Tools.addObject(37, x, y, 0, 12 * motion[this.decCoor[i][this.decCoor_Index]], 33, 12, 20, trans, layer);
                    }
                    if (this.decCoor[i][this.decCoor_ID] != 6) break;
                    switch (this.DEC_STATUS) {
                        case 0: 
                        case 1: {
                            motion = new byte[]{0, 0, 0, 1, 1, 1};
                            break;
                        }
                        case 2: {
                            motion = new byte[]{0, 1};
                        }
                    }
                    Tools.addObject(15, x + (trans == 0 ? 75 : 47), y - 110, 18 * motion[this.decCoor[i][this.decCoor_Index]], 0, 18, 39, 20, trans, layer);
                }
            }
            if (motion != null) {
                short[] sArray = this.decCoor[i];
                byte by = this.decCoor_Index;
                sArray[by] = (short)(sArray[by] + 1);
                if (sArray[by] >= motion.length) {
                    this.decCoor[i][this.decCoor_Index] = 0;
                }
            }
            ++i;
        }
    }

    public short[][] readItemData(String name) {
        DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream("/deccoor/" + name));
        if (is == null) {
            return null;
        }
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    private void init(String[] dat) {
        int i = 0;
        while (i < dat.length) {
            String[] param = Event.splitString(dat[i], " ");
            if (param[0].equals("id")) {
                this.mapID = Event.sToi(param[1]);
            } else if (param[0].equals("name")) {
                this.mapName = param[1];
            } else if (param[0].equals("dat")) {
                this.fileName = param[1];
            } else if (param[0].equals("weather")) {
                this.weather = Event.sToi(param[1]);
            } else if (param[0].equals("music")) {
                this.music = param[1];
            } else if (param[0].equals("BG")) {
                bg = (short)Event.sToi(param[1]);
            } else if (param[0].equals("BGM")) {
                BGM = Event.sToi(param[1]);
                System.out.println(" BGM : " + BGM);
            }
            ++i;
        }
    }

    public static void sender(Event e, String cmd) {
        event = e;
        command = cmd;
    }

    public static void finish() {
        if (event != null) {
            event.setEnd(command);
            event = null;
            command = null;
        }
    }

    static {
        mapSize = new int[2];
        imgNpcData = new short[12][][];
        areaName = new String[]{"", "", "", "", "\u5de8\u9e7f-1", "\u5de8\u9e7f-2", "\u5de8\u9e7f-3", "\u5de8\u9e7f\u5317\u90ca-1", "\u5de8\u9e7f\u5317\u90ca-2", "\u5de8\u9e7f\u5317\u90ca-3", "\u957f\u5e73\u524d\u54e8-1", "\u957f\u5e73\u524d\u54e8-2", "\u957f\u5e73\u524d\u54e8-3", "\u957f\u5e73-1", "\u957f\u5e73-2", "\u98ce\u96ea\u5317\u56fd-1", "\u98ce\u96ea\u5317\u56fd-2", "\u5927\u6881\u5730\u754c-1", "\u5927\u6881\u5730\u754c-2", "\u54b8\u9633\u5173\u53e3-1", "\u54b8\u9633\u5173\u53e3-2", "\u6b66\u5173\u4e4b\u4e1c-1", "\u6b66\u5173\u4e4b\u4e1c-2", "\u695a\u56fd\u53e4\u57ce", "\u957f\u5e73\u6d1e\u7a74-1", "\u957f\u5e73\u6d1e\u7a74-2", "\u53e4\u57ce\u5bc6\u5ba4", "\u5317\u56fd\u5173\u53e3", "\u9a8a\u5c71\u4e4b\u5317-1", "\u9a8a\u5c71\u4e4b\u5317-2", "\u6b66\u5173-1", "\u6b66\u5173-2", "\u6b66\u5173\u4e4b\u5357-1", "\u6b66\u5173\u4e4b\u5357-2", "\u9a8a\u5c71\u4e4b\u5357-1", "\u9a8a\u5c71\u4e4b\u5357-2", "\u9a8a\u5c71", "\u51b0\u5c01\u738b\u5ea7", "\u963f\u623f\u5bab\u53e3-1", "\u963f\u623f\u5bab\u53e3-2", "\u963f\u623f\u5bab\u5185-1", "\u963f\u623f\u5bab\u5185-2", "\u79e6\u5bab", "", "\u4e34\u6dc4\u57ce\u5916-1", "\u4e34\u6dc4\u57ce\u5916-2", "", "", "\u5546\u5e97", "???", "???", "???", "???", "???", "???", "???", "???"};
        SCEEN_MOVE = (byte)12;
    }
}

