/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Actor
extends GameObject {
    static final int HIT_COMMON = 0;
    static final int HIT_FALLDOWN = 1;
    static final int HIT_FLYUP = 2;
    static final int HIT_FLYHIGHTER = 3;
    static final int HIT_FLYAWAY = 4;
    static final int HIT_POUND = 5;
    static final int STAND = 0;
    static final int WALK = 1;
    static final int DEAD = 2;
    static final int BE_FIGHTED = 3;
    static final int LOST_CONTROL = 4;
    static final int LIE_DOWN = 5;
    static final int ATTACK1 = 6;
    static final int ATTACK2 = 7;
    static final int ATTACK3 = 8;
    static final int ATTACK4 = 9;
    static final int RUN = 10;
    static final int RUN_ATTACK = 11;
    static final int JUMP = 12;
    static final int JUMP_ATTACK = 13;
    static final int SPECIAL_ATTACK1 = 14;
    static final int SPECIAL_ATTACK2 = 15;
    static final int SPECIAL_ATTACK3 = 16;
    static final int SPECIAL_ATTACK4 = 17;
    static final int SPECIAL_ATTACK5 = 18;
    static final int PICK = 19;
    static final int BORN = 20;
    static final int BE_FIGHTED_FIRE = 21;
    static final int RIDE_STAND = 22;
    static final int RIDE_WALK = 23;
    static final int RIDE_ATTACK = 24;
    static final int RIDE_BEFIGHT = 25;
    static final int FALL_DOWN = 26;
    static final int TIRED_STAND = 27;
    static final int POWER_UP = 28;
    static final int BLAST_WAVE = 29;
    protected static int screenLeftBoundary;
    protected static int screenRightBoundary;
    protected static int screenUpBoundary;
    protected static int screenDownBoundary;
    static int attackPauseCount;
    static Image[] actorImage;
    static Image[] convertImage;
    static int[] convertImageForWho;
    Effects effect = new Effects();
    short[] cartoonList;
    int moveDir;
    int faceDir;
    int actionState;
    int nextAction;
    int maxBlood;
    int blood;
    int maxDander;
    int dander;
    int attack;
    int defence;
    int score;
    int arc;
    int lieDownCount;
    int unbeatMaxTime;
    int unbeatCount;
    private boolean hittingFlag;
    private boolean hittedFlag;
    private boolean beHittedFlag;
    int[] attackProperty;
    int hitPauseCount;
    int beHittedPauseCount;
    boolean enableToChangeFlag = true;
    int holdCount;
    boolean viewAbleFlag;
    int acceleration;
    static short[][][] IMAGE_DATA;
    static short[][][] FRAME_DATA;
    static short[][][] CARTOON_DATA;
    static int[][][] ATTACK_FRAME;
    static int[] ACTOR_SIZE;
    static int[][][] ATTACK_AREA;
    static int[][][] ATTACK_PROPERTY;
    static int[][] CARTOON_INDEX;
    static int[][] ATTACK_TYPE_INDEX;
    static int[] ACTOR_DATA_INDEX;
    static int[][] LOAD_IMAGE_ID;
    static int[][] ACTOR_RGB_INDEX;
    static int[][] ACTOR_RGB_DATA;
    static final int AI_NORMAL1 = 0;
    static final int AI_NORMAL2 = 1;
    static final int AI_NORMAL3 = 2;
    static final int AI_SPECIAL1 = 3;
    static final int AI_SPECIAL2 = 4;
    static final int AI_SPECIAL3 = 5;
    static int[] AI_TYPE;
    static int[][] AI_FREE_ATTACK_TYPE;
    static int[] REMOTE_ATTACK_BULLET_TYPE;
    static final int BULLET_ROW = 0;
    static final int BULLET_PRO = 1;
    static final int JUMP_AWAY = 2;
    static int[] AI_GIVEN_ATTACK_INDEX;
    static int[][] AI_GIVEN_ATTACK_TYPE;
    static int[][] AI_GIVEN_ATTACK_STEP;
    int givenAIType = -1;
    boolean givenAttackEndFlag = true;
    int givenAttackStepCount;
    int givenAttackContrlCount;
    int savey = 0;
    int jumpCount;

    public static void updateScreenBoundary() {
        screenLeftBoundary = GameScreen.screenX;
        screenRightBoundary = GameScreen.screenX + GameScreen.screenW;
        screenUpBoundary = GameScreen.screenY;
        screenDownBoundary = GameScreen.screenY + GameScreen.screenH;
    }

    public void setCartoonList(short[][] cartoonData, int index) {
        if (index >= 0) {
            this.cartoonList = cartoonData[index];
        }
    }

    public void setDirection(int dir, boolean changeFaceDir) {
        this.moveDir = dir;
        this.faceDir = dir;
        if (!changeFaceDir) {
            this.faceDir = this.faceDir == 1 ? 0 : 1;
        }
    }

    public void setSpeed(int speed_x, int speed_y, int speed_z) {
        this.speedX = this.moveDir == 1 ? Math.abs(speed_x) : -Math.abs(speed_x);
        this.speedY = speed_y;
        this.speedZ = speed_z;
    }

    public void setNextAction(int nAction) {
        this.nextAction = nAction;
    }

    public void setViewAbleFlag(boolean viewAble) {
        this.viewAbleFlag = viewAble;
    }

    public void setScore(int value) {
        this.score = value;
    }

    public int getScore() {
        return this.score;
    }

    public void setMaxBlood(int value) {
        this.maxBlood = value;
    }

    public int getMaxBlood() {
        return this.maxBlood;
    }

    public void setBlood(int value) {
        this.blood = value;
        if (this.blood >= this.maxBlood) {
            this.blood = this.maxBlood;
        }
    }

    public int getBlood() {
        return this.blood;
    }

    public void setMaxDander(int value) {
        this.maxDander = value;
    }

    public int getMaxDander() {
        return this.maxDander;
    }

    public void setDander(int value) {
        this.dander = value;
        if (this.dander >= this.maxDander) {
            this.dander = this.maxDander;
        }
    }

    public int getDander() {
        return this.dander;
    }

    public int getAttack() {
        return this.attack;
    }

    public void setAttack(int att) {
        this.attack = att;
    }

    public int getDefence() {
        return this.defence;
    }

    public void setDefence(int def) {
        this.defence = def;
    }

    public void setHittingFlag(boolean flag) {
        this.hittingFlag = true;
    }

    public void setHittedFlag(boolean flag) {
        this.hittedFlag = flag;
    }

    public void setBeHittedFlag(boolean flag) {
        this.beHittedFlag = flag;
    }

    public void setAccleration(int a) {
        this.acceleration = a;
    }

    public int getAcclerration() {
        return this.acceleration;
    }

    public void updateBlood(int attackValue) {
        this.setBlood(this.getBlood() - attackValue);
        if (this.getBlood() >= this.getMaxBlood()) {
            this.setBlood(this.getMaxBlood());
        } else if (this.getBlood() <= 0) {
            this.setBlood(0);
        }
    }

    protected void changeFace() {
        this.faceDir = this.faceDir == 0 ? 1 : 0;
    }

    protected void updateFrame() {
        ++this.frame;
    }

    protected void drawFrame(Graphics g) {
        if (this.frame >= 0) {
            int frameIndex = this.getFrameIndex();
            short[] frameData = this.getFrameData(frameIndex);
            block4: for (int i = 0; i < frameData.length >> 2; ++i) {
                short[] baseData = this.getImageData(frameData[(i << 2) + 1]);
                int transType = this.getTrans(frameData[(i << 2) + 1]);
                Image img = this.getImage(frameData[i << 2]);
                if (img == null) continue;
                switch (this.faceDir) {
                    case 1: {
                        int px = this.x - GameScreen.screenX + frameData[i * 4 + 2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrame(g, baseData, px, py, transType, img);
                        continue block4;
                    }
                    case 0: {
                        int px = this.x - GameScreen.screenX - frameData[i * 4 + 2] - baseData[2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrameR(g, baseData, px, py, transType, img);
                    }
                }
            }
        }
    }

    protected void drawShadow(Graphics g, int radius) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        if (this.y < 0) {
            if (this.speedY > 0) {
                if (Math.abs(this.y) <= Math.abs(this.savey)) {
                    this.arc += 2;
                }
            } else {
                this.arc -= 2;
            }
            if (this.arc < 10) {
                this.arc = 10;
            } else {
                this.savey = this.y;
            }
            if (this.arc > radius) {
                this.arc = radius;
            }
            g.fillArc(this.x - GameScreen.screenX - this.arc, this.z - 3 - GameScreen.screenY, this.arc * 2, 5, 0, 360);
        } else {
            this.arc = radius;
            g.fillArc(this.x - radius / 2 - GameScreen.screenX, this.z - 3 - GameScreen.screenY, radius, 6, 0, 360);
        }
    }

    public boolean isActionFinish() {
        if (this.frame >= this.cartoonList.length) {
            this.frame = this.cartoonList.length - 1;
            return true;
        }
        return false;
    }

    public int getAttackFrameIndex(int skill) {
        return ATTACK_FRAME[this.type][skill][this.frame];
    }

    public boolean isStanding() {
        return this.speedX == 0;
    }

    public boolean isViewAble() {
        return this.viewAbleFlag;
    }

    public boolean isHitting() {
        return this.hittingFlag;
    }

    public boolean isHitted() {
        return this.hittedFlag;
    }

    public boolean isBeHitted() {
        return this.beHittedFlag;
    }

    public boolean isInScreen() {
        return this.x + (this.width >> 1) >= screenLeftBoundary && this.x - (this.width >> 1) <= screenRightBoundary && this.y + this.z + this.height >= screenUpBoundary && this.y + this.z - this.height <= screenDownBoundary;
    }

    public boolean isAlive() {
        return this.actionState != 2;
    }

    public void setAttackProperty(int[] property) {
        this.attackProperty = property;
    }

    public int[] getAttackArea() {
        int skill = ATTACK_TYPE_INDEX[this.type][this.actionState];
        if (skill < 0) {
            return null;
        }
        if (this.getAttackFrameIndex(skill) < 0) {
            return null;
        }
        int[] property = ATTACK_AREA[this.type][skill];
        if (this.faceDir == 1) {
            return new int[]{this.x + property[0], this.z + this.y + property[1], property[2], property[3], this.z};
        }
        return new int[]{this.x - property[2] - property[0], this.z + this.y + property[1], property[2], property[3], this.z};
    }

    public int[] getDefenceArea() {
        int[] area = new int[]{this.faceDir == 1 ? this.x - (this.width >> 1) : this.x - (this.width >> 1), this.z + this.y - this.height, this.width, this.height, this.z};
        return area;
    }

    public int[] getAttackProperty() {
        int[] property = new int[8];
        int debug = 0;
        int skill = ATTACK_TYPE_INDEX[this.type][this.actionState];
        property[0] = this.x;
        property[1] = this.y;
        property[2] = this.z;
        property[3] = this.faceDir;
        debug = 1;
        int attPropertyIndex = this.getAttackFrameIndex(skill);
        debug = 2;
        property[4] = skill < 0 ? 0 : ATTACK_PROPERTY[this.type][attPropertyIndex][0] + this.attack;
        debug = 3;
        property[5] = ATTACK_PROPERTY[this.type][attPropertyIndex][1];
        property[6] = ATTACK_PROPERTY[this.type][attPropertyIndex][2];
        debug = 4;
        property[7] = ATTACK_PROPERTY[this.type][attPropertyIndex][3];
        return property;
    }

    protected int getJumpVy(int a, int maxHeight) {
        int sumH = 0;
        int tempV = 0;
        this.jumpCount = 0;
        while (sumH < maxHeight) {
            sumH += (tempV += a);
            this.jumpCount += 2;
        }
        return -tempV;
    }

    protected int getJumpCount() {
        return this.jumpCount;
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public short[] getFrameData(int index) {
        int tempType = ACTOR_DATA_INDEX[this.type];
        return FRAME_DATA[tempType][index];
    }

    public short[] getImageData(int index) {
        int tempType = ACTOR_DATA_INDEX[this.type];
        return IMAGE_DATA[tempType][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        for (int i = 0; i < convertImageForWho.length >> 1; ++i) {
            if (convertImageForWho[i << 1] != this.type || convertImageForWho[(i << 1) + 1] != id || convertImageForWho[i << 1] == 0) continue;
            return convertImage[i];
        }
        return actorImage[id];
    }

    public int getTrans(int value) {
        if (value > 0) {
            return 0;
        }
        if (value < 0) {
            return 1;
        }
        return -1;
    }

    protected void clearAIVar() {
        this.givenAIType = -1;
        this.givenAttackEndFlag = true;
        this.givenAttackStepCount = 0;
        this.givenAttackContrlCount = 0;
    }

    public static void loadData() throws Exception {
        int k;
        int j;
        int i;
        DataInputStream di = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/res/data/actor"));
        IMAGE_DATA = new short[di.readInt()][][];
        for (i = 0; i < IMAGE_DATA.length; ++i) {
            Actor.IMAGE_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < IMAGE_DATA[i].length; ++j) {
                Actor.IMAGE_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < IMAGE_DATA[i][j].length; ++k) {
                    Actor.IMAGE_DATA[i][j][k] = di.readShort();
                }
            }
        }
        FRAME_DATA = new short[di.readInt()][][];
        for (i = 0; i < FRAME_DATA.length; ++i) {
            Actor.FRAME_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < FRAME_DATA[i].length; ++j) {
                Actor.FRAME_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < FRAME_DATA[i][j].length; ++k) {
                    Actor.FRAME_DATA[i][j][k] = di.readShort();
                }
            }
        }
        CARTOON_DATA = new short[di.readInt()][][];
        for (i = 0; i < CARTOON_DATA.length; ++i) {
            Actor.CARTOON_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < CARTOON_DATA[i].length; ++j) {
                Actor.CARTOON_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < CARTOON_DATA[i][j].length; ++k) {
                    Actor.CARTOON_DATA[i][j][k] = di.readShort();
                }
            }
        }
        ATTACK_FRAME = new int[di.readInt()][][];
        for (i = 0; i < ATTACK_FRAME.length; ++i) {
            Actor.ATTACK_FRAME[i] = new int[di.readInt()][];
            for (j = 0; j < ATTACK_FRAME[i].length; ++j) {
                Actor.ATTACK_FRAME[i][j] = new int[di.readInt()];
                for (k = 0; k < ATTACK_FRAME[i][j].length; ++k) {
                    Actor.ATTACK_FRAME[i][j][k] = di.readInt();
                }
            }
        }
        ATTACK_AREA = new int[di.readInt()][][];
        for (i = 0; i < ATTACK_AREA.length; ++i) {
            Actor.ATTACK_AREA[i] = new int[di.readInt()][];
            for (j = 0; j < ATTACK_AREA[i].length; ++j) {
                Actor.ATTACK_AREA[i][j] = new int[di.readInt()];
                for (k = 0; k < ATTACK_AREA[i][j].length; ++k) {
                    Actor.ATTACK_AREA[i][j][k] = di.readInt();
                }
            }
        }
        ATTACK_PROPERTY = new int[di.readInt()][][];
        for (i = 0; i < ATTACK_PROPERTY.length; ++i) {
            Actor.ATTACK_PROPERTY[i] = new int[di.readInt()][];
            for (j = 0; j < ATTACK_PROPERTY[i].length; ++j) {
                Actor.ATTACK_PROPERTY[i][j] = new int[di.readInt()];
                for (k = 0; k < ATTACK_PROPERTY[i][j].length; ++k) {
                    Actor.ATTACK_PROPERTY[i][j][k] = di.readInt();
                }
            }
        }
        CARTOON_INDEX = new int[di.readInt()][];
        for (i = 0; i < CARTOON_INDEX.length; ++i) {
            Actor.CARTOON_INDEX[i] = new int[di.readInt()];
            for (j = 0; j < CARTOON_INDEX[i].length; ++j) {
                Actor.CARTOON_INDEX[i][j] = di.readInt();
            }
        }
        ATTACK_TYPE_INDEX = new int[di.readInt()][];
        for (i = 0; i < ATTACK_TYPE_INDEX.length; ++i) {
            Actor.ATTACK_TYPE_INDEX[i] = new int[di.readInt()];
            for (j = 0; j < ATTACK_TYPE_INDEX[i].length; ++j) {
                Actor.ATTACK_TYPE_INDEX[i][j] = di.readInt();
            }
        }
        ACTOR_DATA_INDEX = new int[di.readInt()];
        for (i = 0; i < ACTOR_DATA_INDEX.length; ++i) {
            Actor.ACTOR_DATA_INDEX[i] = di.readInt();
        }
        LOAD_IMAGE_ID = new int[di.readInt()][];
        for (i = 0; i < LOAD_IMAGE_ID.length; ++i) {
            Actor.LOAD_IMAGE_ID[i] = new int[di.readInt()];
            for (j = 0; j < LOAD_IMAGE_ID[i].length; ++j) {
                Actor.LOAD_IMAGE_ID[i][j] = di.readInt();
            }
        }
        ACTOR_RGB_INDEX = new int[di.readInt()][];
        for (i = 0; i < ACTOR_RGB_INDEX.length; ++i) {
            Actor.ACTOR_RGB_INDEX[i] = new int[di.readInt()];
            for (j = 0; j < ACTOR_RGB_INDEX[i].length; ++j) {
                Actor.ACTOR_RGB_INDEX[i][j] = di.readInt();
            }
        }
        ACTOR_RGB_DATA = new int[di.readInt()][];
        for (i = 0; i < ACTOR_RGB_DATA.length; ++i) {
            Actor.ACTOR_RGB_DATA[i] = new int[di.readInt()];
            for (j = 0; j < ACTOR_RGB_DATA[i].length; ++j) {
                Actor.ACTOR_RGB_DATA[i][j] = di.readInt();
            }
        }
        di.close();
    }

    public static void loadRes() throws Exception {
        int i;
        int normalImageNum = 0;
        int convertImageNum = 0;
        for (i = 0; i < LOAD_IMAGE_ID.length; ++i) {
            for (int j = 0; j < LOAD_IMAGE_ID[i].length; ++j) {
                int id = LOAD_IMAGE_ID[i][j];
                if (id > normalImageNum) {
                    normalImageNum = id;
                }
                if (id >= 0 || (id = Math.abs(LOAD_IMAGE_ID[i][j])) <= convertImageNum) continue;
                convertImageNum = id;
            }
        }
        actorImage = new Image[normalImageNum + 1];
        convertImage = new Image[convertImageNum];
        convertImageForWho = new int[convertImage.length << 1];
        for (i = 0; i < LOAD_IMAGE_ID[0].length; ++i) {
            int id = LOAD_IMAGE_ID[0][i];
            Actor.actorImage[id] = Tools.createImage("/actor/A" + id + ".png");
        }
        for (i = 0; i < Enemy.ENEMY_INFO.length / Enemy.PROPERTY_NUM; ++i) {
            int tempType = Enemy.ENEMY_INFO[i * Enemy.PROPERTY_NUM];
            for (int j = 0; j < LOAD_IMAGE_ID[tempType].length; ++j) {
                int id = LOAD_IMAGE_ID[tempType][j];
                if (id >= 0) {
                    if (actorImage[id] != null) continue;
                    Actor.actorImage[id] = Tools.createImage("/actor/A" + id + ".png");
                    continue;
                }
                if (convertImage[id = Math.abs(id) - 1] != null) continue;
                int picID = ACTOR_RGB_INDEX[id][0];
                int rgbDataIndex = ACTOR_RGB_INDEX[id][1];
                Actor.convertImage[id] = GameObject.tools.getConvertImage("/res/actor/A" + picID + ".png", ACTOR_RGB_DATA[rgbDataIndex << 1], ACTOR_RGB_DATA[(rgbDataIndex << 1) + 1]);
                Actor.convertImageForWho[id << 1] = tempType;
                Actor.convertImageForWho[(id << 1) + 1] = picID;
            }
        }
    }

    static {
        ACTOR_SIZE = new int[]{20, 50, 20, 50, 20, 50, 80, 50, 20, 50, 20, 50, 80, 50, 20, 50, 20, 50, 80, 50, 20, 50, 20, 50, 80, 50};
        AI_TYPE = new int[]{-1, 0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 4, 5};
        AI_FREE_ATTACK_TYPE = new int[][]{new int[0], {6, 7}, {6, 7}, {6, 7}, {9}, {9}, {9}, {8}, {8}, {8}, {6, 7, 8, 9}, {6, 7, 8, 9}, {6, 7, 8, 9}};
        REMOTE_ATTACK_BULLET_TYPE = new int[]{0, -1, -1, -1, -1, -1, -1, 1, 2, 3, 1, 2, 3};
        AI_GIVEN_ATTACK_INDEX = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2};
        AI_GIVEN_ATTACK_TYPE = new int[][]{{0, 2}, {0, 2}, {1}};
        AI_GIVEN_ATTACK_STEP = new int[][]{{5, 2}, {5, 2}, {5}};
    }
}

