/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Animal
extends GameObject {
    int faceDir;
    static final int FACE_LEFT = 0;
    static final int FACE_RIGHT = 1;
    int id;
    int type;
    int frame;
    int x;
    int y;
    int z;
    int speedX;
    int speedY;
    int speedZ;
    static final int MOVE = 0;
    static final int STAND = 1;
    static final int STAND1 = 2;
    static final byte BIRD = 0;
    static final byte FROG = 1;
    static final byte RABBIT = 2;
    static final byte CROW = 3;
    static final byte COLORBIRD = 4;
    int acceleration;
    static Effects[] effect = new Effects[5];
    static Image[] animalImage = new Image[5];
    private short[] cartoonList;
    static int[][] ATTACK_AREA = new int[][]{{0, 0, 16, 16}, {0, 0, 30, 30}, {0, 0, 32, 32}, {-40, -20, 120, 60}, {0, 0, 16, 16}};
    static final byte[] frameCount = new byte[]{3, 3, 6, 7, 3};
    static final short[][][] ANIMAL_CARTOON_DATA = new short[][][]{new short[][]{{0, 1, 2}, new short[0], new short[0]}, new short[][]{{0, 1, 1, 1, 2, 2, 2}, {0, 0, 0}, new short[0]}, new short[][]{{2, 3, 4, 5, 2, 3, 4, 5, 2, 3, 4, 5, 2, 3, 4, 5, 2, 3, 4, 5}, {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1}, new short[0]}, new short[][]{{4, 5, 6}, {0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1}}, new short[][]{{0, 1, 2}, new short[0], new short[0]}};
    static final int[][][] ANIMAL_INFO = new int[][][]{new int[][]{{0, 60, -80, 110, -2, 0, 0, 100, 0, 0}}, new int[][]{{3, 80, -50, 115, 4, -8, 0, 100, 1, 1}, {2, 200, 0, 130, -8, 0, 0, 180, 0, 0}, {2, 250, 0, 110, -10, 0, 0, 180, 0, 0}, {2, 260, 0, 180, -12, 0, 0, 180, 0, 0}, {2, 800, 0, 130, -12, 0, 0, 700, 0, 0}, {2, 900, 0, 130, -12, 0, 0, 800, 0, 0}, {2, 1000, 0, 130, -12, 0, 0, 900, 0, 0}, {2, 1300, 0, 130, -12, 0, 0, 1200, 0, 0}, {2, 1400, 0, 130, -12, 0, 0, 1200, 0, 0}}, new int[][]{{0, 200, -80, 120, -8, 0, 0, 200, 0, 0}, {0, 220, -80, 130, -12, 0, 0, 200, 0, 0}}, new int[][]{{1, 220, 0, 130, -4, 0, 0, 100, 0, 0}}, new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[][]{{2, 200, 0, 130, -8, 0, 0, 180, 0, 0}, {2, 250, 0, 110, -10, 0, 0, 180, 0, 0}, {2, 260, 0, 180, -12, 0, 0, 180, 0, 0}, {2, 800, 0, 130, -12, 0, 0, 700, 0, 0}, {2, 900, 0, 130, -12, 0, 0, 800, 0, 0}, {2, 1000, 0, 130, -12, 0, 0, 900, 0, 0}, {2, 1300, 0, 130, -12, 0, 0, 1200, 0, 0}, {2, 1400, 0, 130, -12, 0, 0, 1200, 0, 0}}, new int[][]{{1, 220, 0, 130, -4, 0, 0, 100, 0, 0}, {2, 250, 0, 110, -10, 0, 0, 180, 0, 0}, {2, 260, 0, 180, -12, 0, 0, 180, 0, 0}, {2, 800, 0, 130, -12, 0, 0, 700, 0, 0}, {2, 900, 0, 140, -12, 0, 0, 800, 0, 0}, {2, 1000, 0, 140, -12, 0, 0, 900, 0, 0}, {2, 1300, 0, 140, -12, 0, 0, 1200, 0, 0}, {2, 1400, 0, 120, -12, 0, 0, 1200, 0, 0}}, new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[0][], new int[0][]};

    public Animal() {
        for (int i = 0; i < effect.length; ++i) {
            Animal.effect[i] = new Effects();
        }
        this.state = -1;
    }

    public void init(int i_id, int t_type, int s_state, int tx, int ty, int tz, int speedx, int speedy, int speedz, int dir) {
        this.frame = 0;
        this.id = i_id;
        this.type = t_type;
        this.state = s_state;
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.faceDir = dir;
        this.setSpeed(speedx, speedy, speedz);
        this.setAccleration(2);
        this.setCartoonList(ANIMAL_CARTOON_DATA[this.type][this.state]);
    }

    public void changeAction(int action) {
        this.frame = 0;
        this.state = action;
        this.setCartoonList(ANIMAL_CARTOON_DATA[this.type][this.state]);
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public void setCartoonList(short[] list) {
        this.cartoonList = list;
    }

    public void setSpeed(int speed_x, int speed_y, int speed_z) {
        this.speedX = this.faceDir == 0 ? -Math.abs(speed_x) : Math.abs(speed_x);
        this.speedY = speed_y;
        this.speedZ = speed_z;
    }

    public int getJumpV(int a, int maxHeight) {
        int tempV = 0;
        for (int sumH = 0; sumH < maxHeight; sumH += (tempV += a)) {
        }
        return -tempV;
    }

    protected void move() {
        this.y += this.speedY;
        if (this.state != 1) {
            this.x += this.speedX;
            this.z += this.speedZ;
        }
    }

    protected void updateFrame() {
        ++this.frame;
        if (this.frame >= this.cartoonList.length) {
            this.frame = 0;
        }
    }

    public void draw(Graphics g) {
        if (this.state != -1) {
            if (this.type != 0 && this.type != 4 && this.type != 3) {
                this.drawShadow(g);
            }
            for (int i = 0; i < effect.length; ++i) {
                effect[i].draw(g);
            }
            this.drawFrame(g);
            this.updateFrame();
        }
    }

    private void drawFrame(Graphics g) {
        int iw = this.ImageW(animalImage[this.type]) / frameCount[this.type];
        int ix = this.getFrameIndex() * iw;
        int iy = 0;
        int ih = this.ImageH(animalImage[this.type]);
        int px = this.x - GameScreen.screenX;
        int py = this.z + this.y;
        Image img = animalImage[this.type];
        switch (this.faceDir) {
            case 0: {
                g.setClip(px, py, iw, ih);
                g.drawImage(img, px - ix, py - iy, 20);
                break;
            }
            case 1: {
                g.setClip(px, py, iw, ih);
                g.clipRect(px, py, iw, ih);
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(img, px - Math.abs(-(frameCount[this.type] - 1) * iw + ix), py - iy, 20, 8192);
            }
        }
    }

    protected void drawShadow(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        g.fillArc(this.x - GameScreen.screenX, this.z - GameScreen.screenY + 20, 20, 2, 0, 360);
    }

    protected void drawRect(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(65535);
        if (this.getAttackArea() != null) {
            g.drawRect(this.x + ATTACK_AREA[this.type][0] - GameScreen.screenX, this.z + this.y + ATTACK_AREA[this.type][1], ATTACK_AREA[this.type][2], ATTACK_AREA[this.type][3]);
        }
    }

    protected void drawLine(Graphics g) {
    }

    public void update() {
        switch (this.type) {
            case 0: {
                switch (this.state) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (GameScreen.scene == 0) {
                            if (this.faceDir == 1) {
                                this.x += this.speedX;
                                if (this.x <= GameScreen.screenX + GameScreen.screenW + 50) break;
                                this.speedX = -this.speedX;
                                this.faceDir = 0;
                                break;
                            }
                            this.x += this.speedX;
                            if (this.x >= GameScreen.screenX - 50) break;
                            this.speedX = -this.speedX;
                            this.faceDir = 1;
                            break;
                        }
                        this.move();
                        if (this.x >= GameScreen.screenX - 50) break;
                        this.state = -1;
                    }
                }
                break;
            }
            case 2: {
                if (this.frame >= this.cartoonList.length - 1) {
                    this.changeAction(Tools.getRandom(2));
                }
                switch (this.state) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        if (GameScreen.scene == 0) {
                            if (this.faceDir == 1) {
                                this.x += this.speedX;
                                if (this.x <= GameScreen.screenX + GameScreen.screenW + 50) break;
                                this.z = Tools.getRandom(80) + 110;
                                this.speedX = -this.speedX;
                                this.faceDir = 0;
                                break;
                            }
                            this.x += this.speedX;
                            if (this.x >= GameScreen.screenX - 50) break;
                            this.z = Tools.getRandom(80) + 110;
                            this.speedX = -this.speedX;
                            this.faceDir = 1;
                            break;
                        }
                        this.move();
                        if (this.x >= GameScreen.screenX - 50) break;
                        this.state = -1;
                    }
                }
                break;
            }
            case 1: {
                this.move();
                this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
                if (this.y >= 0) {
                    this.y = 0;
                    this.speedY = 0;
                    this.changeAction(1);
                    this.setSpeed(4, this.getJumpV(this.getAcclerration(), 5), 0);
                    this.changeAction(0);
                }
                if (this.x <= GameScreen.screenX + GameScreen.screenW + 50 && this.x >= GameScreen.screenX - 50) break;
                this.state = -1;
                break;
            }
            case 3: {
                switch (this.state) {
                    case 1: 
                    case 2: {
                        if (this.frame < this.cartoonList.length - 1) break;
                        this.changeAction(Tools.getRandom(2) + 1);
                        break;
                    }
                    case 0: {
                        this.move();
                        if (this.x <= GameScreen.screenX + GameScreen.screenW + 50 && this.x >= GameScreen.screenX - 50) break;
                        this.state = -1;
                    }
                }
                break;
            }
            case 4: {
                this.move();
                if (GameScreen.marchFlag) {
                    if (this.x > GameScreen.screenX + GameScreen.screenW - 30) {
                        this.faceDir = 1;
                        this.setSpeed(0, 0, 0);
                    } else if (this.x < GameScreen.screenX + GameScreen.screenW - 30) {
                        this.setSpeed(9, 0, 0);
                    }
                    if (this.x + 20 <= GameScreen.screenX + GameScreen.screenW) break;
                    this.x = GameScreen.screenX + GameScreen.screenW - 20;
                    this.faceDir = 0;
                    break;
                }
                GameScreen.AnimalInfoCount1 = 0;
                this.setSpeed(1, -8, 0);
                if (this.y > -150) break;
                this.state = -1;
            }
        }
    }

    public void setAccleration(int a) {
        this.acceleration = a;
    }

    public int getAcclerration() {
        return this.acceleration;
    }

    public boolean checkDistance(int tx, int ty, int dis) {
        int temp_x = tx - this.x;
        int temp_y = ty - this.z;
        int temp_r = dis;
        return temp_x * temp_x + temp_y * temp_y < temp_r * temp_r;
    }

    public void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    private int ImageW(Image image) {
        return image.getWidth();
    }

    private int ImageH(Image image) {
        return image.getHeight();
    }

    public static void loadRes() throws Exception {
        for (int i = 0; i < animalImage.length; ++i) {
            Animal.animalImage[i] = Tools.createImage("/animal/A" + i + ".png");
        }
    }

    public int[] getAttackArea() {
        int[] property = ATTACK_AREA[this.type];
        return new int[]{this.x + property[0], this.z + this.y + property[1], property[2], property[3], this.z};
    }
}

