/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bullet
extends GameObject {
    int faceDir;
    int ascription = -1;
    static final byte ACOTRBULLET = 0;
    static final byte ENEMYBULLET1 = 1;
    static final byte ENEMYBULLET2 = 2;
    static final byte ENEMYBULLET3 = 3;
    static final byte ENEMYBULLET4 = 4;
    static final byte RELIVE_ACTOR = 5;
    static final int[][] POS_OFFSET = new int[][]{{60, -200, 0, 100, -200, 0, -60, -200, 0, -100, -200, 0}, {60, -200, 0, 0, -200, -30, -60, -200, 0, 0, -200, 30}, {60, -200, -30, 60, -200, 0, 60, -200, 30}, {-60, -200, -30, -60, -200, 0, -60, -200, 30}};
    static Image[] bulletImage = new Image[7];
    private short[] cartoonList;
    private boolean hittedFlag;
    static final short[][][] BULLET_IMAGE_DATA = new short[][][]{new short[][]{{0, 0, 34, 60}, {0, 60, 34, 65}, {0, 125, 34, 64}, {0, 189, 33, 68}}, new short[][]{{0, 0, 15, 34}, {15, 0, 14, 33}, {30, 5, 9, 23}}, new short[][]{{0, 0, 28, 6}}, new short[][]{{5, 20, 16, 12}, {0, 0, 26, 20}, {26, 1, 31, 29}, {0, 0, 51, 11}, {51, 0, 43, 11}, {94, 0, 37, 11}, {131, 0, 24, 13}, {0, 11, 80, 18}, {80, 13, 75, 16}, {0, 29, 75, 21}, {75, 33, 12, 13}, {87, 29, 68, 17}, {0, 50, 34, 30}, {34, 51, 31, 29}, {65, 51, 20, 29}, {85, 53, 13, 13}, {99, 46, 56, 14}, {99, 60, 30, 8}, {87, 68, 37, 11}, {0, 80, 11, 25}, {11, 81, 16, 24}, {27, 82, 12, 23}, {39, 88, 11, 17}, {39, 81, 52, 5}, {91, 79, 22, 6}, {113, 79, 16, 5}, {50, 87, 30, 18}, {80, 86, 15, 6}, {96, 85, 7, 6}, {104, 85, 10, 8}, {115, 84, 14, 9}, {81, 92, 5, 13}, {90, 92, 13, 13}, {104, 95, 4, 10}, {109, 93, 20, 12}, {129, 63, 26, 42}}, new short[][]{{0, 0, 50, 40}, {50, 1, 48, 38}, {98, 0, 50, 37}, {148, 1, 48, 38}}, new short[][]{{0, 0, 13, 55}, {0, 0, 13, 42}}};
    static final short[][][] BULLET_FRAME_DATA = new short[][][]{new short[][]{{0, 1, -17, -60}, {0, 2, -17, -65}, {0, 3, -17, -64}, {0, 4, -16, -68}}, new short[][]{{1, 1, -7, -34}, {1, 2, -7, -33}, {1, 3, 7, -26}}, new short[][]{{2, 1, -14, -3}}, new short[][]{{4, 1, -8, -20}, {4, 2, -13, -24}, {4, 3, -16, -29}, {5, 36, -26, -42, 5, -36, 0, -42}, {5, 6, -17, -13, 5, 17, -28, -27}, {5, 24, -26, -6, 5, 19, -20, -17, 5, 12, -39, -34}, {5, 26, -7, -8, 5, 5, -22, -19, 5, 10, -40, -40}, {5, 25, -11, -8, 5, 7, -25, -21, 5, 11, -1, -21, 5, 16, 11, -21, 5, 9, -38, -37}, {5, 18, -14, -10, 5, 4, -26, -21, 5, 8, -42, -39}, {5, 13, -22, -32, 5, 22, 12, -36, 5, 21, -38, -40, 5, 34, 6, -43, 5, 31, 25, -35}, {5, 28, -5, -8, 5, 14, -16, -37, 5, 20, -27, -37, 5, 23, -17, -32}, {5, 35, -6, -15, 5, 27, -16, -33, 5, 32, 19, -29, 5, 30, -25, -34}, {5, 15, -6, -34, 5, 29, 20, -31, 5, 33, -19, -33}}, new short[][]{{3, 1, -25, -40}, {3, 2, -24, -39}, {3, 3, -25, -39}, {3, 4, -24, -39}}, new short[][]{{6, 1, -7, -55}, {6, 2, -7, -42}}};
    static final short[][][] BULLET_CARTOON_DATA = new short[][][]{new short[][]{{0, 1, 2, 3}}, new short[][]{{0, 1}}, new short[][]{{0}}, new short[][]{{0, 1, 2}, {3, 4, 5, 6, 7, 8, 9, 10, 11, 12}}, new short[][]{{0, 1, 2, 3}, {0, 1, 2, 3}}, new short[][]{{0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}};
    static int[][] ATTACK_AREA = new int[][]{{-14, -60, 28, 60}, {-15, -26, 26, 26}, {-14, -3, 26, 6}, {-15, -25, 30, 25}, {-7, -55, 14, 55}, {-14, -3, 28, 6}};
    static int[][] ATTACK_PROPERTY = new int[][]{{15, 1, 1, 0}, {30, 1, 1, 0}, {20, 1, 1, 0}, {30, 1, 1, 0}, {25, 1, 1, 0}, {12, 1, 1, 0}};
    static int[][] REMOTE_VOLUME = new int[][]{{30, 0}, {21, -9}, {31, -33}, {50, -25}, {0, 0}, {0, 0}};

    public Bullet() {
        this.state = -1;
    }

    public void init(int i_d, int t_type, int s_state, int tx, int ty, int tz, int speedx, int speedy, int speedz, int fir, int asc) {
        this.frame = 0;
        this.id = i_d;
        this.type = t_type;
        this.state = s_state;
        this.faceDir = fir;
        if (this.faceDir == 0) {
            this.x = tx - REMOTE_VOLUME[t_type][0];
            this.speedX = -Math.abs(speedx);
        } else {
            this.x = tx + REMOTE_VOLUME[t_type][0];
            this.speedX = Math.abs(speedx);
        }
        this.speedY = speedy;
        this.speedZ = speedz;
        this.y = ty + REMOTE_VOLUME[t_type][1];
        this.z = tz;
        this.ascription = asc;
        this.changeAction(0);
    }

    public void changeAction(int action) {
        this.frame = 0;
        this.state = action;
        this.setCartoonList(BULLET_CARTOON_DATA[this.type][this.state]);
    }

    public void setSpeed(int speed_x, int speed_y, int speed_z, int fir) {
        if (fir == 0) {
            this.faceDir = 0;
            this.speedX = -Math.abs(speed_x);
        } else {
            this.faceDir = 1;
            this.speedX = Math.abs(speed_x);
        }
        this.speedY = speed_y;
        this.speedZ = speed_z;
    }

    public void setCartoonList(short[] list) {
        this.cartoonList = list;
    }

    public int getTrans(int value) {
        if (value > 0) {
            return 0;
        }
        if (value < 0) {
            return 1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update() {
        block25: {
            switch (this.type) {
                case 0: {
                    int acceleration = 1;
                    this.speedX += this.speedX > 0 ? acceleration : -acceleration;
                    if (this.x < GameScreen.screenX || this.x > GameScreen.screenX + GameScreen.screenW) {
                        this.setEnd();
                        this.ascription = -1;
                        this.setHittedFlag(false);
                    }
                    this.move();
                    return;
                }
                case 1: {
                    int acceleration4 = 1;
                    this.speedX += this.speedX > 0 ? acceleration4 : -acceleration4;
                    if (this.x < GameScreen.screenX || this.x > GameScreen.screenX + GameScreen.screenW) {
                        this.setEnd();
                        this.ascription = -1;
                        this.setHittedFlag(false);
                    }
                    this.move();
                    return;
                }
                case 2: {
                    if (this.x < GameScreen.screenX || this.x > GameScreen.screenX + GameScreen.screenW || this.isHitted()) {
                        this.setEnd();
                        this.ascription = -1;
                        this.setHittedFlag(false);
                    }
                    this.move();
                    return;
                }
                case 3: {
                    if (this.x < GameScreen.screenX || this.x > GameScreen.screenX + GameScreen.screenW) {
                        this.setEnd();
                        this.ascription = -1;
                        this.setHittedFlag(false);
                    }
                    switch (this.state) {
                        case 0: {
                            if (this.y >= 0) {
                                if (this.isHitted()) {
                                    this.y = 0;
                                    this.setEnd();
                                    this.ascription = -1;
                                    this.setHittedFlag(false);
                                    return;
                                }
                                this.changeAction(1);
                                return;
                            }
                            this.move();
                            return;
                        }
                        case 1: {
                            if (this.frame < this.cartoonList.length - 1) break;
                            this.y = 0;
                            this.setEnd();
                            this.ascription = -1;
                            this.setHittedFlag(false);
                        }
                    }
                    return;
                }
                case 4: {
                    int acceleration1 = 1;
                    this.speedY += acceleration1;
                    this.move();
                    if (this.y < 0) return;
                    this.speedY = -this.speedY >> 2;
                    if (this.speedY != 0) return;
                    GameScreen.initScreenShake(2, 6);
                    this.setEnd();
                    this.setHittedFlag(false);
                    return;
                }
                case 5: {
                    this.move();
                    switch (this.state) {
                        case 0: {
                            int acceleration2 = 2;
                            this.speedY += acceleration2;
                            if (this.y < 0) return;
                            this.y = 0;
                            this.speedY = 0;
                            GameScreen.initScreenShake(2, 4);
                            this.setHittedFlag(false);
                            this.changeAction(1);
                            break block25;
                        }
                        case 1: {
                            if (this.frame < this.cartoonList.length - 1) return;
                            this.y = 0;
                            try {
                                GameScreen.reliveRoler(this.x, 0, this.z);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.setEnd();
                            this.setHittedFlag(false);
                        }
                    }
                }
            }
        }
    }

    protected void move() {
        this.y += this.speedY;
        this.x += this.speedX;
        this.z += this.speedZ;
    }

    public void draw(Graphics g) {
        this.drawShadow(g);
        this.drawFrame(g);
        this.updateFrame();
    }

    protected void updateFrame() {
        ++this.frame;
        if (this.frame >= this.cartoonList.length) {
            this.frame = 0;
        }
    }

    protected void drawFrame(Graphics g) {
        if (this.frame >= 0) {
            int frameIndex = this.getFrameIndex();
            short[] frameData = this.getFrameData(frameIndex);
            block4: for (int i = 0; i < frameData.length >> 2; ++i) {
                short[] baseData = this.getImageData(frameData[(i << 2) + 1]);
                int transType = this.getTrans(frameData[(i << 2) + 1]);
                Image img = this.getImage(frameData[i << 2]);
                if (img == null) continue;
                switch (this.faceDir) {
                    case 1: {
                        int px = this.x - GameScreen.screenX + frameData[i * 4 + 2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrame(g, baseData, px, py, transType, img);
                        continue block4;
                    }
                    case 0: {
                        int px = this.x - GameScreen.screenX - frameData[i * 4 + 2] - baseData[2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrameR(g, baseData, px, py, transType, img);
                    }
                }
            }
        }
    }

    protected void drawShadow(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        g.fillArc(this.x - 10 - GameScreen.screenX, this.z - 3 - GameScreen.screenY, 20, 6, 0, 360);
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public short[] getFrameData(int index) {
        return BULLET_FRAME_DATA[this.type][index];
    }

    public short[] getImageData(int index) {
        return BULLET_IMAGE_DATA[this.type][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        return bulletImage[id];
    }

    public int[] getAttackArea() {
        int[] property = ATTACK_AREA[this.type];
        if (this.isAlive()) {
            return new int[]{this.x + property[0], this.z + this.y + property[1], property[2], property[3], this.z};
        }
        return null;
    }

    public int[] getAttackProperty() {
        int[] property = new int[]{this.x, this.y, this.z, this.faceDir, ATTACK_PROPERTY[this.type][0], ATTACK_PROPERTY[this.type][1], ATTACK_PROPERTY[this.type][2], ATTACK_PROPERTY[this.type][3]};
        return property;
    }

    public void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    public boolean isHitted() {
        return this.hittedFlag;
    }

    public void setHittedFlag(boolean flag) {
        this.hittedFlag = flag;
    }

    public boolean isActionFinish() {
        if (this.frame >= this.cartoonList.length) {
            this.frame = this.cartoonList.length - 1;
            return true;
        }
        return false;
    }

    public static void loadRes() throws Exception {
        for (int i = 0; i < bulletImage.length; ++i) {
            Bullet.bulletImage[i] = Tools.createImage("/bullet/B" + i + ".png");
        }
    }
}

