/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class CipherCommand {
    private final String[] COMMANDS = new String[]{"4357", "636", "377", "53835", "25663", "66639", "288225", "5433"};
    private String inputString = "";
    private boolean matchFlag;
    private int commandIndex = -1;
    private final int MAX_LENGTH;
    private StringBuffer strBuf;
    private static GameScreen gs;

    public CipherCommand(GameScreen canvas) {
        this.MAX_LENGTH = 15;
        gs = canvas;
        this.strBuf = new StringBuffer();
    }

    public void checkCommandString(int inputkey) {
        if (inputkey == 42) {
            this.inputString = "";
            this.resetStrBuf();
            this.matchFlag = false;
        }
        if (this.matchFlag) {
            if (inputkey == 35) {
                char[] tempCharArray = this.inputString.toCharArray();
                int value = 0;
                for (int i = 0; i < tempCharArray.length; ++i) {
                    int num = tempCharArray[i] - 48;
                    value += num * CipherCommand.pow(10, tempCharArray.length - i - 1);
                }
                this.specifyFunction(value);
                this.inputString = "";
                this.resetStrBuf();
                this.matchFlag = false;
            } else {
                this.strBuf.append((char)inputkey);
                if (this.strBuf.length() > 15) {
                    this.resetStrBuf();
                }
                this.inputString = this.strBuf.toString();
            }
        } else {
            this.compareKeyString(inputkey);
        }
    }

    private void compareKeyString(int inputkey) {
        this.strBuf.append((char)inputkey);
        if (this.strBuf.length() > 15) {
            this.resetStrBuf();
        }
        if (inputkey == 35) {
            if (this.strBuf.charAt(0) == '*') {
                this.inputString = this.strBuf.toString().substring(1, this.strBuf.length() - 1);
                for (int i = 0; i < this.COMMANDS.length; ++i) {
                    String tempstr = this.COMMANDS[i];
                    if (!this.inputString.equals(tempstr)) continue;
                    this.matchFlag = true;
                    this.commandIndex = i;
                    this.inputString = "\u8f93\u5165\u6570\u5b57\u6216\u6309#\u952e";
                    this.resetStrBuf();
                    return;
                }
            }
            this.inputString = "";
            this.resetStrBuf();
        }
    }

    private void resetStrBuf() {
        this.strBuf.delete(0, this.strBuf.length());
        this.strBuf.ensureCapacity(0);
    }

    private static int pow(int base, int exponent) {
        int value = base;
        if (exponent == 0) {
            return 1;
        }
        for (int i = 1; i < exponent; ++i) {
            value *= base;
        }
        return value;
    }

    private void specifyFunction(int value) {
        value = value < 0 ? 0 : value;
        switch (this.commandIndex) {
            case 3: {
                GameScreen.task.setNextMainMissionID(value);
                for (int i = 0; i < Task.missionState.length; ++i) {
                    Task.missionState[i] = i < value ? 2 : 0;
                }
                break;
            }
            case 4: {
                GameScreen.role.setMaxBlood(value);
                GameScreen.role.setBlood(value);
                break;
            }
            case 5: {
                GameScreen.role.setScore(value);
                break;
            }
            case 6: {
                GameScreen.role.setAttack(value + 300);
                break;
            }
            case 7: {
                GameScreen.life = value;
            }
        }
    }

    public void paint(Graphics g) {
        switch (this.commandIndex) {
            case 0: {
                g.setColor(0);
                g.fillRect(3, 3, gs.getWidth() - 6, gs.getHeight() - 6);
                g.setColor(0xFFF000);
                g.drawString("\u529f\u80fd\u952e\u5217\u8868", gs.getWidth() >> 1, 20, 17);
                for (int i = 0; i < this.COMMANDS.length; ++i) {
                    g.drawString(this.COMMANDS[i], 6, 30 + i * 20, 20);
                }
                break;
            }
            case 1: {
                g.setColor(0xFFF000);
                g.drawString("totalMemory:" + Runtime.getRuntime().totalMemory(), 5, gs.getHeight() >> 1, 20);
                g.drawString("freeMemory" + Runtime.getRuntime().freeMemory(), 5, (gs.getHeight() >> 1) + 20, 20);
                System.gc();
                break;
            }
        }
        if (this.matchFlag) {
            StringBuffer strbuf = new StringBuffer();
            strbuf.append("[").append(this.COMMANDS[this.commandIndex]).append("] ").append(this.inputString);
            g.setClip(0, 0, gs.getWidth(), gs.getHeight());
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, gs.getWidth(), 20);
            g.setColor(0);
            g.fillRect(1, 1, gs.getWidth() - 2, 18);
            g.setColor(0xFFF000);
            g.drawString(strbuf.toString(), 5, 5, 20);
        }
    }
}

