/*
 * Decompiled with CFR 0.152.
 */
public class Demo {
    static final int DEMO_ROLE = 0;
    static final int DEMO_ENEMY = 1;
    static final int DEMO_CREATE_ENEMY = 2;
    static final int DEMO_DIALOG = 3;
    static final int DEMO_SCREEN_MOVE = 4;
    static final short[] DEMO_ENEMY_INFO = new short[]{2, 2, 1, 1, 250, -221, 135, 30, -1, 250, 2, 2, 1, 1, 300, -221, 170, 60, -1, 250, 2, 2, 1, 1, 250, -221, 200, 30, -1, 250};
    static final String[] DEMO_DIALOG_DATA = new String[]{"0\u2026\u2026\uff1f\uff1f\uff1f\uff01\uff01\uff01", "0\u770b\u60c5\u51b5\u4f3c\u4e4e\u662f\u4e2d\u57cb\u4f0f\u4e86\uff0c\u8fd9\u4e9b\u5bb6\u4f19\u679c\u7136\u662f\u65e0\u6240\u4e0d\u5728\u554a\u3002\f2\u53ef\u6076\u7684\u4eba\u7c7b\uff0c\u8fd9\u56de\u770b\u4f60\u5f80\u54ea\u8dd1\u3002\f0\u53ea\u51ed\u4f60\u4eec\u8fd9\u51e0\u53ea\u5f31\u5c0f\u7684\u5730\u7cbe\u5c31\u60f3\u56f0\u4f4f\u6211\uff1f\f2\u5c45\u7136\u6562\u5c0f\u770b\u6211\u4eec\uff0c\u6740\u4e86\u8fd9\u4e2a\u4eba\u7c7b\uff01", "2\u54fc\uff0c\u6211\u4eec\u8d70\u7740\u77a7\uff01\u64a4\u9000\uff01\uff01\uff01\f0\u2026\u2026", "0\u603b\u7b97\u628a\u4efb\u52a1\u5b8c\u6210\u4e86\uff0c\u8be5\u56de\u8425\u5730\u597d\u597d\u4f11\u606f\u51e0\u5929\u4e86\u3002"};
    static final int[] CREATE_ENEMY_POINT = new int[]{30};
    static final int[] INIT_DIALOG_POINT = new int[]{15, 50, 82, 133};
    static int[] DEMO_COUNT;
    static final int[][] ROLE_ACTION;
    static int[][] DEMO_ENEMY_COUNT;
    static final int[][][] ENEMY_ACTION;
    static final int[][] SCREEN_MOVE_ACTION;
    static final int DEMO_SCENE = 18;
    static int demoStep;
    static int demoRoleStep;
    static int[] demoEnemyStep;
    static int demoStepCount;
    static int roleActionCount;
    static int[] enemyActionCount;
    GameScreen gs;

    public Demo(GameScreen gs) {
        this.gs = gs;
    }

    public static void initDemo() {
        int i;
        GameScreen.scene = 18;
        int sum = 0;
        DEMO_COUNT = new int[ROLE_ACTION.length];
        for (i = 0; i < DEMO_COUNT.length; ++i) {
            Demo.DEMO_COUNT[i] = sum += ROLE_ACTION[i][ROLE_ACTION[i].length - 1];
        }
        DEMO_ENEMY_COUNT = new int[ENEMY_ACTION.length][];
        for (i = 0; i < DEMO_ENEMY_COUNT.length; ++i) {
            int innerSum = 0;
            Demo.DEMO_ENEMY_COUNT[i] = new int[ENEMY_ACTION[i].length];
            for (int j = 0; j < DEMO_ENEMY_COUNT[i].length; ++j) {
                Demo.DEMO_ENEMY_COUNT[i][j] = innerSum += ENEMY_ACTION[i][j][ENEMY_ACTION[i][j].length - 1];
            }
        }
    }

    public static void update() {
        if (!GameScreen.keyDialogFlag) {
            int i;
            Demo.updateRole();
            Demo.updateEnemy();
            for (i = 0; i < CREATE_ENEMY_POINT.length; ++i) {
                if (demoStepCount != CREATE_ENEMY_POINT[i]) continue;
                Demo.updateCreateEnemy(i);
            }
            for (i = 0; i < INIT_DIALOG_POINT.length; ++i) {
                if (demoStepCount != INIT_DIALOG_POINT[i]) continue;
                Demo.updateDialog(i);
            }
            int screenMoveType = 0;
            int tempSpeedX = 0;
            if (GameScreen.role.isAlive() && GameScreen.role.isInScreen()) {
                screenMoveType = 0;
                tempSpeedX = GameScreen.role.speedX;
            }
            for (int i2 = 0; i2 < GameScreen.bullet.length; ++i2) {
                if (!GameScreen.bullet[i2].isAlive()) continue;
                screenMoveType = 1;
                tempSpeedX = GameScreen.bullet[i2].speedX;
                for (int j = 0; j < GameScreen.enemy.length; ++j) {
                    if (!GameScreen.enemy[j].isAlive() || GameScreen.enemy[j].x > GameScreen.screenX + (GameScreen.screenW >> 1)) continue;
                    tempSpeedX = 0;
                }
                break;
            }
            Demo.updateScreenMove(screenMoveType, tempSpeedX);
        }
    }

    public static void changeRoleAction(int[] roleAction) {
        int tAction = roleAction[0];
        int tDir = roleAction[1];
        boolean faceDir = roleAction[2] == 0;
        int tSpeedX = roleAction[3];
        int tSpeedY = roleAction[4];
        int tSpeedZ = roleAction[5];
        int tx = roleAction[6];
        int ty = roleAction[7];
        int tz = roleAction[8];
        int tTime = roleAction[9];
        switch (tAction) {
            case 0: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 1: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 10: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 12: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.enableToChangeFlag = false;
                GameScreen.role.setAccleration(3);
                GameScreen.role.setSpeed(tSpeedX, GameScreen.role.getJumpVy(GameScreen.role.getAcclerration(), 50), 0);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 18: {
                GameScreen.role.enableToChangeFlag = false;
                GameScreen.role.setAccleration(2);
                GameScreen.role.setSpeed(0, GameScreen.role.getJumpVy(GameScreen.role.getAcclerration(), 60), 0);
                break;
            }
            case 28: {
                GameScreen.role.setDirection(tDir, faceDir);
                GameScreen.role.setSpeed(tSpeedX, tSpeedY, tSpeedZ);
            }
        }
    }

    public static void changeEnemyActon(int[] enemyAction, int enemyId) {
        int tAction = enemyAction[0];
        int tDir = enemyAction[1];
        boolean faceDir = enemyAction[2] == 0;
        int tSpeedX = enemyAction[3];
        int tSpeedY = enemyAction[4];
        int tSpeedZ = enemyAction[5];
        int tx = enemyAction[6];
        int ty = enemyAction[7];
        int tz = enemyAction[8];
        int tTime = enemyAction[9];
        switch (tAction) {
            case 0: {
                GameScreen.enemy[enemyId].setDirection(tDir, faceDir);
                GameScreen.enemy[enemyId].setSpeed(0, 0, 0);
                break;
            }
            case 1: {
                GameScreen.enemy[enemyId].setDirection(tDir, faceDir);
                GameScreen.enemy[enemyId].setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 10: {
                GameScreen.enemy[enemyId].setDirection(tDir, faceDir);
                GameScreen.enemy[enemyId].setSpeed(tSpeedX, tSpeedY, tSpeedZ);
                break;
            }
            case 20: {
                GameScreen.enemy[enemyId].setDirection(tDir, faceDir);
                GameScreen.enemy[enemyId].enableToChangeFlag = false;
                GameScreen.enemy[enemyId].setAccleration(2);
                GameScreen.enemy[enemyId].setSpeed(tSpeedX, tSpeedY, tSpeedZ);
            }
        }
    }

    public static void updateRole() {
        if (GameScreen.role.actionState == 0) {
            GameScreen.role.changeAction(ROLE_ACTION[demoStep][0]);
            Demo.changeRoleAction(ROLE_ACTION[demoStep]);
            if (++demoStepCount >= DEMO_COUNT[demoStep] && ++demoStep > DEMO_COUNT.length - 1) {
                demoStep = DEMO_COUNT.length - 1;
                Demo.exitDemo();
            }
        }
        GameScreen.role.update();
    }

    public static void updateEnemy() {
        for (int i = 0; i < GameScreen.enemy.length; ++i) {
            if (!GameScreen.enemy[i].isAlive()) continue;
            if (GameScreen.enemy[i].actionState == 0) {
                GameScreen.enemy[i].changeAction(ENEMY_ACTION[i][demoEnemyStep[i]][0]);
                Demo.changeEnemyActon(ENEMY_ACTION[i][demoEnemyStep[i]], i);
                int n = i;
                enemyActionCount[n] = enemyActionCount[n] + 1;
                if (enemyActionCount[i] >= DEMO_ENEMY_COUNT[i][demoEnemyStep[i]]) {
                    int n2 = i;
                    demoEnemyStep[n2] = demoEnemyStep[n2] + 1;
                    if (demoEnemyStep[i] > DEMO_ENEMY_COUNT[i].length - 1) {
                        Demo.demoEnemyStep[i] = DEMO_ENEMY_COUNT[i].length - 1;
                    }
                }
            }
            GameScreen.enemy[i].update();
        }
    }

    public static void updateDialog(int index) {
        GameScreen.dialogInit(index, DEMO_DIALOG_DATA[index]);
    }

    public static void screenAutoMove() {
    }

    public static void updateScreenMove(int index, int speedX) {
        int speed = speedX;
        int bufSpeed = 4;
        int tx = GameScreen.screenX;
        int ty = GameScreen.screenY;
        GameScreen.screenMoveSpeed = 0;
        GameScreen.moveLeftBorder = 0;
        GameScreen.moveRightBorder = Map.getMapLength();
        switch (index) {
            case 0: {
                if (!GameScreen.role.isStanding()) {
                    if (GameScreen.role.moveDir == 0) {
                        if (GameScreen.role.x - GameScreen.screenX < GameScreen.screenW >> 1) {
                            GameScreen.screenMoveSpeed = speed;
                            tx += speed;
                        }
                    } else if (GameScreen.screenX + GameScreen.screenW - GameScreen.role.x < GameScreen.screenW >> 1) {
                        GameScreen.screenMoveSpeed = speed;
                        tx += speed;
                    }
                } else {
                    if (GameScreen.role.faceDir == 0) {
                        if (GameScreen.role.x - GameScreen.screenX < (GameScreen.screenW >> 3) * 5) {
                            GameScreen.screenMoveSpeed = -bufSpeed;
                            tx -= bufSpeed;
                        }
                    } else if (GameScreen.screenX + GameScreen.screenW - GameScreen.role.x < (GameScreen.screenW >> 3) * 5) {
                        GameScreen.screenMoveSpeed = bufSpeed;
                        tx += bufSpeed;
                    }
                    GameScreen.screenMoveSpeed = 0;
                }
                if (GameScreen.role.isInScreen()) break;
                if (GameScreen.role.x < GameScreen.screenX) {
                    tx -= 20;
                    GameScreen.screenMoveSpeed = -20;
                    break;
                }
                tx += 20;
                GameScreen.screenMoveSpeed = 20;
                break;
            }
            case 1: {
                tx += speedX;
                GameScreen.screenMoveSpeed = speed;
            }
        }
        if (tx <= GameScreen.moveLeftBorder) {
            tx = GameScreen.moveLeftBorder;
            GameScreen.screenMoveSpeed = 0;
        } else if (tx >= GameScreen.moveRightBorder - GameScreen.screenW) {
            tx = GameScreen.moveRightBorder - GameScreen.screenW;
            GameScreen.screenMoveSpeed = 0;
        }
        GameScreen.screenX = tx;
        GameScreen.screenY = ty;
        if (GameScreen.screenX < 0) {
            GameScreen.screenX = 0;
            GameScreen.screenMoveSpeed = 0;
        } else if (GameScreen.screenX + GameScreen.screenW > Map.getMapLength()) {
            GameScreen.screenX = Map.getMapLength() - GameScreen.screenW;
            GameScreen.screenMoveSpeed = 0;
        }
    }

    public static void updateCreateEnemy(int index) {
        for (int i = 0; i < Enemy.ENEMY_INFO.length / Enemy.PROPERTY_NUM; ++i) {
            int enemy_id = GameScreen.getEnableObject(GameScreen.enemy);
            if (enemy_id < 0) continue;
            try {
                GameScreen.createEnemy(enemy_id, i);
                Demo.changeEnemyActon(ENEMY_ACTION[i][demoEnemyStep[i]], i);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void exitDemo() {
        GameScreen.demoFlag = false;
        GameScreen.resetGame();
        GameScreen.initSceneEffect();
        GameScreen.changeGameState(0);
        GameScreen.changeState(4);
        Demo.clearDemo();
    }

    public static void clearDemo() {
        demoStep = 0;
        demoRoleStep = 0;
        demoEnemyStep = new int[4];
        demoStepCount = 0;
        roleActionCount = 0;
        enemyActionCount = new int[4];
    }

    public static void loadDemoEnemyData() {
        Enemy.PROPERTY_NUM = 10;
        Enemy.ENEMY_INFO = DEMO_ENEMY_INFO;
    }

    static {
        ROLE_ACTION = new int[][]{{1, 1, 0, 4, 0, 0, 250, 0, 165, 12}, {0, 1, 0, 0, 0, 0, 0, 0, 165, 20}, {1, 0, 1, 7, 0, 0, 0, 0, 165, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 165, 20}, {10, 1, 0, 6, 0, 0, 0, 0, 165, 1}, {11, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {6, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {7, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {8, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {9, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {6, 0, 0, 0, 0, 0, 0, 0, 165, 1}, {7, 0, 0, 0, 0, 0, 0, 0, 165, 1}, {8, 0, 0, 0, 0, 0, 0, 0, 165, 1}, {17, 0, 0, 0, 0, 0, 0, 0, 165, 1}, {1, 0, 0, 4, 0, 0, 250, 0, 165, 1}, {18, 0, 0, 0, 0, 0, 0, 0, 165, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 165, 20}, {28, 1, 0, 0, 0, 0, 0, 0, 165, 10}, {29, 1, 0, 0, 0, 0, 0, 0, 165, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 165, 40}, {10, 1, 0, 6, 0, 0, 0, 0, 165, 10}};
        ENEMY_ACTION = new int[][][]{new int[][]{{20, 0, 0, 0, 1, 0, 0, 0, 125, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 125, 10}, {1, 0, 0, 2, 0, 0, 0, 0, 125, 2}, {1, 1, 0, 3, 0, 3, 0, 0, 125, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 125, 10}}, new int[][]{{20, 0, 0, 0, 3, 0, 0, 0, 155, 1}, {0, 0, 0, 0, 3, 0, 0, 0, 155, 12}, {1, 0, 0, 2, 0, 0, 0, 0, 125, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 125, 60}, {1, 1, 0, 3, 0, 0, 0, 0, 165, 80}}, new int[][]{{20, 0, 0, 0, 6, 0, 0, 0, 175, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 175, 14}, {1, 0, 0, 2, 0, 0, 0, 0, 125, 2}, {0, 0, 0, 0, 0, 0, 0, 0, 125, 10}, {1, 1, 0, 3, 0, -2, 0, 0, 125, 1}, {0, 1, 0, 0, 0, 0, 0, 0, 125, 10}}};
        SCREEN_MOVE_ACTION = new int[][]{new int[0], new int[0]};
        demoEnemyStep = new int[4];
        enemyActionCount = new int[4];
    }
}

