/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Effects
extends GameObject {
    static final int HIT_EFFECT1 = 0;
    static final int HIT_EFFECT2 = 1;
    static final int HIT_EFFECT3 = 2;
    static final int HIT_EFFECT4 = 3;
    static final int POWER_UP_EFFECT = 4;
    static final int SCORE_EFFECT = 5;
    static final int SHOW_EFFECT1 = 6;
    static final int SHOW_EFFECT2 = 7;
    static short[][][] IMAGE_DATA;
    static short[][][] FRAME_DATA;
    static short[][][] CARTOON_DATA;
    static Image[] effectImage;
    int localType;
    int direction;
    String value;
    int offsetY;
    int arc;
    int deadHead = -2;
    int goodType;
    int[] ScoreImageID = new int[]{6, 5, 7, 5, 8};

    public Effects() {
        this.setEnd();
    }

    public void init(int type, int tx, int ty, int tz, int dir, int offset_y) {
        this.frame = 0;
        this.state = 0;
        this.localType = type;
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.direction = dir;
        this.offsetY = offset_y;
    }

    public void init(int type, int tx, int ty, int tz, int offset_y, String v_value, int good_Type) {
        this.frame = 0;
        this.state = 0;
        this.localType = type;
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.offsetY = offset_y;
        this.value = v_value;
        this.arc = 30;
        this.goodType = good_Type;
    }

    public void update() {
        if (this.state != this.deadHead && this.localType == 5) {
            this.y -= 2;
            if (this.y <= this.offsetY - 20) {
                this.y = 0;
                this.offsetY = 0;
                this.state = this.deadHead;
            }
        }
    }

    public void draw(Graphics g) {
        if (this.localType != 5) {
            this.drawFrame(g);
        } else if (this.localType == 5 && this.state != this.deadHead) {
            Tools.drawNumImage(g, this.value, 7, 8, this.x - GameScreen.screenX - 10, this.z + this.y - GameScreen.screenY - 10, GameScreen.shopImage[9]);
        }
    }

    protected void drawShadow(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        if (this.y < 0) {
            this.arc -= 2;
            g.fillArc(this.x - GameScreen.screenX - this.arc, this.z - 5 - GameScreen.screenY, this.arc * 2, 5, 0, 360);
        } else {
            g.fillArc(this.x - GameScreen.screenX, this.z - 5 - GameScreen.screenY, 20, 5, 0, 360);
            this.arc = 0;
        }
    }

    protected void drawFrame(Graphics g) {
        if (this.state != -1) {
            int frameIndex = this.getFrameIndex();
            short[] frameData = this.getFrameData(frameIndex);
            block4: for (int i = 0; i < frameData.length >> 2; ++i) {
                short[] baseData = this.getImageData(frameData[(i << 2) + 1]);
                int transType = Effects.getTrans(frameData[(i << 2) + 1]);
                Image img = this.getImage(frameData[i << 2]);
                if (img == null) continue;
                switch (this.direction) {
                    case 1: {
                        int px = this.x - GameScreen.screenX + frameData[i * 4 + 2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrame(g, baseData, px, py, transType, img);
                        continue block4;
                    }
                    case 0: {
                        int px = this.x - GameScreen.screenX - frameData[i * 4 + 2] - baseData[2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrameR(g, baseData, px, py, transType, img);
                    }
                }
            }
            this.updateFrame();
        }
    }

    protected void updateFrame() {
        ++this.frame;
        if (this.frame >= CARTOON_DATA[this.localType][this.state].length) {
            this.frame = CARTOON_DATA[this.localType][this.state].length - 1;
            this.setEnd();
        }
    }

    public void move(int tx, int ty, int tz) {
        this.x = tx;
        this.y = ty + this.offsetY;
        this.z = tz;
    }

    private void setDeadHead() {
        this.state = this.deadHead;
    }

    public boolean isAliveD() {
        return this.state != -1;
    }

    private void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    public static int getCartoonLength(int aType, int aState) {
        return CARTOON_DATA[aType][aState].length;
    }

    public int getFrameIndex() {
        return CARTOON_DATA[this.localType][this.state][this.frame];
    }

    public short[] getFrameData(int index) {
        return FRAME_DATA[this.localType][index];
    }

    public short[] getImageData(int index) {
        return IMAGE_DATA[this.localType][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        return effectImage[id];
    }

    public static int getTrans(int value) {
        if (value > 0) {
            return 0;
        }
        if (value < 0) {
            return 1;
        }
        return -1;
    }

    public static void loadRes() throws Exception {
        Effects.loadData();
        for (int i = 0; i < effectImage.length; ++i) {
            Effects.effectImage[i] = Tools.createImage("/effects/" + i + ".png");
        }
    }

    public static void loadData() throws Exception {
        int k;
        int j;
        int i;
        DataInputStream di = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/res/data/effect"));
        IMAGE_DATA = new short[di.readInt()][][];
        for (i = 0; i < IMAGE_DATA.length; ++i) {
            Effects.IMAGE_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < IMAGE_DATA[i].length; ++j) {
                Effects.IMAGE_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < IMAGE_DATA[i][j].length; ++k) {
                    Effects.IMAGE_DATA[i][j][k] = di.readShort();
                }
            }
        }
        FRAME_DATA = new short[di.readInt()][][];
        for (i = 0; i < FRAME_DATA.length; ++i) {
            Effects.FRAME_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < FRAME_DATA[i].length; ++j) {
                Effects.FRAME_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < FRAME_DATA[i][j].length; ++k) {
                    Effects.FRAME_DATA[i][j][k] = di.readShort();
                }
            }
        }
        CARTOON_DATA = new short[di.readInt()][][];
        for (i = 0; i < CARTOON_DATA.length; ++i) {
            Effects.CARTOON_DATA[i] = new short[di.readInt()][];
            for (j = 0; j < CARTOON_DATA[i].length; ++j) {
                Effects.CARTOON_DATA[i][j] = new short[di.readInt()];
                for (k = 0; k < CARTOON_DATA[i][j].length; ++k) {
                    Effects.CARTOON_DATA[i][j][k] = di.readShort();
                }
            }
        }
        di.close();
    }

    static {
        effectImage = new Image[7];
    }
}

