/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Enemy
extends Actor {
    public int[][] goodID = new int[][]{new int[0], {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 2}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};
    static int PROPERTY_NUM;
    static short[] ENEMY_INFO;
    static int[] ENEMY_INFO_SKIP;
    boolean bossFlag;
    int bumpDistance;

    public Enemy() {
        this.actionState = 2;
        this.state = -1;
    }

    public void init(int t_id, int t_type, int action, int tx, int ty, int tz, int dir, int blood, int isBoss) throws Exception {
        this.state = 0;
        this.id = t_id;
        this.type = t_type;
        this.frame = 0;
        this.setDirection(dir, true);
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.width = Actor.ACTOR_SIZE[this.type << 1];
        this.height = Actor.ACTOR_SIZE[(this.type << 1) + 1];
        this.setMaxBlood(blood);
        this.setBlood(blood);
        this.setAttack(0);
        this.setDefence(0);
        this.setViewAbleFlag(true);
        this.bossFlag = isBoss >= 0;
        this.unbeatMaxTime = 5;
        if (this.isBoss()) {
            this.unbeatMaxTime = 10;
        }
        this.holdCount = 0;
        this.enableToChangeFlag = true;
        this.lieDownCount = 10;
        this.changeAction(action);
    }

    public void changeAction(int action) {
        this.frame = 0;
        this.actionState = action;
        this.setCartoonList(Actor.CARTOON_DATA[this.type], Actor.CARTOON_INDEX[this.type][this.actionState]);
        switch (this.actionState) {
            case 2: {
                if (this.isBoss()) {
                    GameScreen.flattenAllEnemy(true);
                }
                if (!GameScreen.demoFlag) {
                    GameScreen.task.endConditionUpdate(2, this.type);
                }
                this.setViewAbleFlag(false);
                this.state = -1;
                if (GameScreen.HONOR_STATE[2] == -1) {
                    --GameScreen.killEnemyNum;
                }
                if (this.isBoss()) {
                    Goods.initGroup(this.x, this.y, this.z);
                    break;
                }
                if (GameScreen.goods == null) break;
                int temp_id = GameScreen.getEnableObject(GameScreen.goods);
                if (temp_id == -1) break;
                if (GameScreen.HONOR_STATE[1] == 1) {
                    int i;
                    int[] saveData = new int[this.goodID[this.type].length];
                    for (i = 0; i < this.goodID[this.type].length; ++i) {
                        saveData[i] = i >= 4 && i <= 8 ? 4 : this.goodID[this.type][i];
                    }
                    for (i = 0; i < saveData.length; ++i) {
                        this.goodID[this.type][i] = saveData[i];
                    }
                }
                int goodsType = this.goodID[this.type][Tools.getRandom(this.goodID[this.type].length - 1)];
                int currentMissionID = GameScreen.task.getCurrentID();
                int conditionType = Task.getConditionType(currentMissionID);
                int conditionCarrierID = Task.getConditionCarrierId(currentMissionID);
                if (conditionType == 1 && conditionCarrierID == this.goodID[this.type][this.goodID[this.type].length - 1]) {
                    goodsType = this.goodID[this.type][this.goodID[this.type].length - 1];
                }
                if (goodsType == -1) break;
                GameScreen.goods[temp_id].init(temp_id, goodsType, 0, this.x, this.y, this.z);
                break;
            }
            case 0: {
                this.holdCount = 0;
                this.enableToChangeFlag = true;
                this.setSpeed(0, 0, 0);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.setHittingFlag(true);
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                this.clearAIVar();
                break;
            }
            case 5: {
                this.setSpeed(0, 0, 0);
                break;
            }
            case 20: {
                this.setAccleration(2);
                this.setSpeed(0, 4, 0);
                this.enableToChangeFlag = false;
            }
        }
    }

    protected void move() {
        this.y += this.speedY;
        this.x += this.speedX;
        if (GameScreen.isMovableZ(this.z + this.speedZ)) {
            this.z += this.speedZ;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void beHittedEvent() {
        tx = this.attackProperty[0];
        ty = this.attackProperty[1];
        tz = this.attackProperty[2];
        tDir = this.attackProperty[3];
        tAttack = this.attackProperty[4];
        tAttackType = this.attackProperty[5];
        tEffectType = this.attackProperty[6];
        tBurnFlag = this.attackProperty[7];
        if (this.x < tx) {
            this.setDirection(0, false);
        } else if (this.x > tx) {
            this.setDirection(1, false);
        }
        effectDir = this.faceDir;
        effectOffset = -30;
        this.beHittedPauseCount = 2;
        if (GameScreen.role.actionState == 17) ** GOTO lbl-1000
        if (GameScreen.role.acceleration == 18) lbl-1000:
        // 2 sources

        {
            this.updateBlood(tAttack + GameScreen.addSkillHarm);
        } else {
            this.updateBlood(tAttack);
        }
        tempType = tBurnFlag == 0 ? 4 : 21;
        switch (tAttackType) {
            case 0: {
                if (this.blood <= 0) {
                    this.changeAction(tempType);
                    this.setAccleration(1);
                    this.setSpeed(2, this.getJumpVy(this.getAcclerration(), 5), 0);
                    this.enableToChangeFlag = false;
                } else {
                    this.changeAction(3);
                    this.holdCount = 10;
                    this.enableToChangeFlag = false;
                }
                if (this.y >= 0) break;
                this.changeAction(tempType);
                this.setAccleration(2);
                this.setSpeed(10, this.getJumpVy(this.getAcclerration(), 5), 0);
                this.enableToChangeFlag = false;
                break;
            }
            case 1: {
                this.changeAction(tempType);
                this.setAccleration(2);
                this.setSpeed(3, this.getJumpVy(this.getAcclerration(), 10), 0);
                this.enableToChangeFlag = false;
                break;
            }
            case 2: {
                this.changeAction(tempType);
                this.setAccleration(2);
                this.setSpeed(1, this.getJumpVy(this.getAcclerration(), 40), 0);
                this.enableToChangeFlag = false;
                break;
            }
            case 3: {
                this.changeAction(tempType);
                effectDir = 0;
                if (Tools.getRandom(100) < 50) {
                    effectDir = 1;
                }
                effectOffset = -25;
                if (this.y < 0) {
                    this.setAccleration(1);
                    this.setSpeed(1, this.getJumpVy(this.getAcclerration(), 20), 0);
                } else {
                    this.setAccleration(2);
                    this.setSpeed(10, this.getJumpVy(this.getAcclerration(), 5), 0);
                }
                this.enableToChangeFlag = false;
                break;
            }
            case 4: {
                tempRandom = Tools.getRandom(100);
                if (tempRandom < 50) {
                    if (this.isInScreen()) {
                        tEffectType = 2;
                        effectOffset = -20;
                        this.changeAction(tempType);
                        this.setSpeed(50, 0, 0);
                        this.enableToChangeFlag = false;
                        break;
                    }
                    this.attackProperty[5] = 1;
                    break;
                }
                this.changeAction(tempType);
                this.setAccleration(2);
                this.setSpeed(3, this.getJumpVy(this.getAcclerration(), 10), 0);
                this.attackProperty[5] = 1;
                this.enableToChangeFlag = false;
                break;
            }
            case 5: {
                this.changeAction(tempType);
                this.setSpeed(15, 30, 0);
                this.enableToChangeFlag = false;
            }
        }
        this.effect.init(tEffectType, this.x, this.y, this.z, effectDir, effectOffset);
    }

    public boolean isBeHittedPaused() {
        if (this.beHittedPauseCount <= 0) {
            this.beHittedPauseCount = 0;
            return false;
        }
        int tempDis = 0;
        switch (this.faceDir) {
            case 0: {
                if (this.beHittedPauseCount % 2 == 0) {
                    tempDis = 1;
                    break;
                }
                tempDis = -1;
                break;
            }
            case 1: {
                tempDis = this.beHittedPauseCount % 2 == 0 ? -1 : 1;
            }
        }
        this.x += tempDis;
        --this.beHittedPauseCount;
        --this.frame;
        return true;
    }

    public void update() {
        if (!this.isBeHittedPaused()) {
            if (this.isBeHitted()) {
                this.beHittedEvent();
                this.setBeHittedFlag(false);
            }
            if (this.unbeatCount > 0) {
                --this.unbeatCount;
                if (this.unbeatCount <= 0) {
                    this.unbeatCount = 0;
                }
            }
            this.actionUpdate();
        }
        this.effect.move(this.x, this.y, this.z);
    }

    public void draw(Graphics g) {
        if (this.isInScreen() && this.isViewAble()) {
            if (this.isDragon()) {
                this.drawShadow(g, 60);
            } else {
                this.drawShadow(g, 20);
            }
            this.drawFrame(g);
        }
        this.effect.draw(g);
        this.updateFrame();
        if (this.beHittedPauseCount <= 0 && this.isActionFinish() && this.enableToChangeFlag) {
            this.changeAction(0);
        }
    }

    public void actionUpdate() {
        switch (this.actionState) {
            case 0: {
                if (GameScreen.demoFlag) break;
                this.thinking(Actor.AI_TYPE[this.type]);
                break;
            }
            case 1: {
                this.updateWalk();
                break;
            }
            case 3: {
                this.updateBeFight();
                break;
            }
            case 4: {
                this.updateLostControl();
                break;
            }
            case 5: {
                this.updateLieDown();
                break;
            }
            case 21: {
                this.updateLostControl();
                break;
            }
            case 6: {
                this.updateAttack1();
                break;
            }
            case 7: {
                this.updateAttack2();
                break;
            }
            case 8: {
                this.updateAttack3();
                break;
            }
            case 9: {
                this.updateAttack4();
                break;
            }
            case 10: {
                this.updateRun();
                break;
            }
            case 11: {
                this.updateRunAttack();
                break;
            }
            case 12: {
                this.updateJump();
                break;
            }
            case 20: {
                this.updateBorn();
                break;
            }
            case 14: {
                this.updateSpecialAttack1();
            }
        }
    }

    private void moveInScren(int targetX, int targetZ) {
        this.changeAction(1);
        if (this.x < targetX) {
            this.setDirection(1, true);
        } else {
            this.setDirection(0, true);
        }
        if (Math.abs(this.z - targetZ) < 10) {
            this.setSpeed(0, 0, 3);
            if (this.z + this.speedZ > GameScreen.moveDownBorder) {
                this.setSpeed(0, 0, -3);
            }
        } else {
            this.setSpeed(3, 0, 0);
        }
    }

    private boolean isInThinkingArea(int iw) {
        return this.x + (this.width >> 1) >= Actor.screenLeftBoundary - iw && this.x - (this.width >> 1) <= Actor.screenRightBoundary + iw && this.y + this.z + this.height >= Actor.screenUpBoundary - iw && this.y + this.z - this.height <= Actor.screenDownBoundary + iw;
    }

    private void thinking(int aiType) {
        int targetX = GameScreen.role.x;
        int targetZ = GameScreen.role.z;
        int attactDistanceX = 60;
        int attactDistanceZ = 15;
        int thinkingArea = -20;
        switch (aiType) {
            case 0: {
                if (!this.isInThinkingArea(thinkingArea)) {
                    this.moveInScren(targetX, targetZ);
                    break;
                }
                int randomNum = Tools.getRandom(100);
                if (randomNum >= 50) {
                    this.changeAction(1);
                    int randomNum2 = Tools.getRandom(100);
                    if (randomNum2 >= 20) {
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                    } else if (randomNum2 >= 10) {
                        if (this.x < targetX) {
                            this.setDirection(0, true);
                        } else {
                            this.setDirection(1, true);
                        }
                    } else if (this.x < targetX) {
                        this.setDirection(0, false);
                    } else {
                        this.setDirection(1, false);
                    }
                    int randomNum3 = Tools.getRandom(100);
                    if (randomNum3 >= 50) {
                        if (this.z < targetZ) {
                            this.setSpeed(0, 0, 2);
                            break;
                        }
                        this.setSpeed(0, 0, -2);
                        break;
                    }
                    this.setSpeed(3, 0, 0);
                    break;
                }
                if (randomNum < 40 || Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                if (this.x < targetX) {
                    this.setDirection(1, true);
                } else {
                    this.setDirection(0, true);
                }
                this.changeAction(Actor.AI_FREE_ATTACK_TYPE[this.type][Tools.getRandom(Actor.AI_FREE_ATTACK_TYPE[this.type].length)]);
                break;
            }
            case 1: {
                if (!this.isInThinkingArea(thinkingArea)) {
                    this.moveInScren(targetX, targetZ);
                    break;
                }
                int randomNum = Tools.getRandom(100);
                if (randomNum >= 50) {
                    this.changeAction(1);
                    int randomNum2 = Tools.getRandom(100);
                    if (randomNum2 >= 80) {
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                    } else if (randomNum2 >= 40) {
                        if (this.x < targetX) {
                            this.setDirection(0, true);
                        } else {
                            this.setDirection(1, true);
                        }
                    } else if (this.x < targetX) {
                        this.setDirection(0, false);
                    } else {
                        this.setDirection(1, false);
                    }
                    int randomNum3 = Tools.getRandom(100);
                    if (randomNum3 >= 60) {
                        if (this.z < targetZ) {
                            this.setSpeed(0, 0, 3);
                            break;
                        }
                        this.setSpeed(0, 0, -3);
                        break;
                    }
                    this.setSpeed(4, 0, 0);
                    break;
                }
                if (randomNum < 30 || Math.abs(this.z - targetZ) > attactDistanceZ || Math.abs(this.x - targetX) < attactDistanceX) break;
                if (this.x < targetX) {
                    this.setDirection(1, true);
                } else {
                    this.setDirection(0, true);
                }
                this.setSpeed(7, 0, 0);
                this.bumpDistance = Math.abs(this.x - targetX) + 40;
                this.enableToChangeFlag = false;
                this.changeAction(Actor.AI_FREE_ATTACK_TYPE[this.type][Tools.getRandom(Actor.AI_FREE_ATTACK_TYPE[this.type].length)]);
                break;
            }
            case 2: {
                if (!this.isInThinkingArea(thinkingArea)) {
                    this.moveInScren(targetX, targetZ);
                    break;
                }
                int randomNum = Tools.getRandom(100);
                if (randomNum >= 70) {
                    this.changeAction(1);
                    int randomNum2 = Tools.getRandom(100);
                    if (randomNum2 >= 70) {
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                    } else if (randomNum2 >= 50) {
                        if (this.x < targetX) {
                            this.setDirection(0, true);
                        } else {
                            this.setDirection(1, true);
                        }
                    } else if (this.x < targetX) {
                        this.setDirection(0, false);
                    } else {
                        this.setDirection(1, false);
                    }
                    int randomNum3 = Tools.getRandom(100);
                    if (randomNum3 >= 70) {
                        if (this.z < targetZ) {
                            this.setSpeed(0, 0, 3);
                            break;
                        }
                        this.setSpeed(0, 0, -3);
                        break;
                    }
                    this.setSpeed(4, 0, 0);
                    break;
                }
                if (randomNum < 50 || Math.abs(this.z - targetZ) > attactDistanceZ || Math.abs(this.x - targetX) < attactDistanceX) break;
                if (this.x < targetX) {
                    this.setDirection(1, true);
                } else {
                    this.setDirection(0, true);
                }
                this.changeAction(Actor.AI_FREE_ATTACK_TYPE[this.type][Tools.getRandom(Actor.AI_FREE_ATTACK_TYPE[this.type].length)]);
                break;
            }
            case 3: {
                if (!this.givenAttackEndFlag) {
                    this.updateGivenAI(this.givenAIType);
                    break;
                }
                if (this.isInThinkingArea(thinkingArea)) {
                    int randomNum = Tools.getRandom(100);
                    if (randomNum >= 50) {
                        this.changeAction(1);
                        int randomNum2 = Tools.getRandom(100);
                        if (randomNum2 >= 20) {
                            if (this.x < targetX) {
                                this.setDirection(1, true);
                            } else {
                                this.setDirection(0, true);
                            }
                        } else if (randomNum2 >= 10) {
                            if (this.x < targetX) {
                                this.setDirection(0, true);
                            } else {
                                this.setDirection(1, true);
                            }
                        } else if (this.x < targetX) {
                            this.setDirection(0, false);
                        } else {
                            this.setDirection(1, false);
                        }
                        int randomNum3 = Tools.getRandom(100);
                        if (randomNum3 >= 20) {
                            if (this.z < targetZ) {
                                this.setSpeed(0, 0, 3);
                                break;
                            }
                            this.setSpeed(0, 0, -3);
                            break;
                        }
                        this.setSpeed(4, 0, 0);
                        break;
                    }
                    if (randomNum >= 47) {
                        int givenTypeIndex = Actor.AI_GIVEN_ATTACK_INDEX[this.type];
                        int tempIndex = Tools.getRandom(Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex].length);
                        this.givenAIType = Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex][tempIndex];
                        this.givenAttackStepCount = Actor.AI_GIVEN_ATTACK_STEP[givenTypeIndex][tempIndex];
                        this.givenAttackContrlCount = 0;
                        this.givenAttackEndFlag = false;
                        break;
                    }
                    if (randomNum >= 25) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(6);
                        break;
                    }
                    if (randomNum >= 15) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(7);
                        break;
                    }
                    if (randomNum >= 10) {
                        if (Math.abs(this.x - targetX) < attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.setSpeed(7, 0, 0);
                        this.bumpDistance = Math.abs(this.x - targetX) + 40;
                        this.enableToChangeFlag = false;
                        this.changeAction(9);
                        break;
                    }
                    if (Math.abs(this.x - targetX) < attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                    if (this.x < targetX) {
                        this.setDirection(1, true);
                    } else {
                        this.setDirection(0, true);
                    }
                    this.changeAction(8);
                    break;
                }
                this.moveInScren(targetX, targetZ);
                break;
            }
            case 4: {
                if (!this.givenAttackEndFlag) {
                    this.updateGivenAI(this.givenAIType);
                    break;
                }
                if (this.isInThinkingArea(thinkingArea)) {
                    int randomNum = Tools.getRandom(100);
                    if (randomNum >= 50) {
                        this.changeAction(1);
                        int randomNum2 = Tools.getRandom(100);
                        if (randomNum2 >= 20) {
                            if (this.x < targetX) {
                                this.setDirection(1, true);
                            } else {
                                this.setDirection(0, true);
                            }
                        } else if (randomNum2 >= 10) {
                            if (this.x < targetX) {
                                this.setDirection(0, true);
                            } else {
                                this.setDirection(1, true);
                            }
                        } else if (this.x < targetX) {
                            this.setDirection(0, false);
                        } else {
                            this.setDirection(1, false);
                        }
                        int randomNum3 = Tools.getRandom(100);
                        if (randomNum3 >= 20) {
                            if (this.z < targetZ) {
                                this.setSpeed(0, 0, 3);
                                break;
                            }
                            this.setSpeed(0, 0, -3);
                            break;
                        }
                        this.setSpeed(4, 0, 0);
                        break;
                    }
                    if (randomNum >= 47) {
                        int givenTypeIndex = Actor.AI_GIVEN_ATTACK_INDEX[this.type];
                        int tempIndex = Tools.getRandom(Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex].length);
                        this.givenAIType = Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex][tempIndex];
                        this.givenAttackStepCount = Actor.AI_GIVEN_ATTACK_STEP[givenTypeIndex][tempIndex];
                        this.givenAttackContrlCount = 0;
                        this.givenAttackEndFlag = false;
                        break;
                    }
                    if (randomNum >= 25) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(6);
                        break;
                    }
                    if (randomNum >= 15) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(7);
                        break;
                    }
                    if (randomNum >= 10) {
                        if (Math.abs(this.x - targetX) < attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.setSpeed(7, 0, 0);
                        this.bumpDistance = Math.abs(this.x - targetX) + 40;
                        this.enableToChangeFlag = false;
                        this.changeAction(9);
                        break;
                    }
                    if (Math.abs(this.x - targetX) < attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                    if (this.x < targetX) {
                        this.setDirection(1, true);
                    } else {
                        this.setDirection(0, true);
                    }
                    this.changeAction(8);
                    break;
                }
                this.moveInScren(targetX, targetZ);
                break;
            }
            case 5: {
                if (!this.givenAttackEndFlag) {
                    this.updateGivenAI(this.givenAIType);
                    break;
                }
                if (this.isInThinkingArea(thinkingArea)) {
                    int randomNum = Tools.getRandom(100);
                    if (randomNum >= 50) {
                        this.changeAction(1);
                        int randomNum2 = Tools.getRandom(100);
                        if (randomNum2 >= 20) {
                            if (this.x < targetX) {
                                this.setDirection(1, true);
                            } else {
                                this.setDirection(0, true);
                            }
                        } else if (randomNum2 >= 10) {
                            if (this.x < targetX) {
                                this.setDirection(0, true);
                            } else {
                                this.setDirection(1, true);
                            }
                        } else if (this.x < targetX) {
                            this.setDirection(0, false);
                        } else {
                            this.setDirection(1, false);
                        }
                        int randomNum3 = Tools.getRandom(100);
                        if (randomNum3 >= 20) {
                            if (this.z < targetZ) {
                                this.setSpeed(0, 0, 3);
                                break;
                            }
                            this.setSpeed(0, 0, -3);
                            break;
                        }
                        this.setSpeed(4, 0, 0);
                        break;
                    }
                    if (randomNum >= 47) {
                        int givenTypeIndex = Actor.AI_GIVEN_ATTACK_INDEX[this.type];
                        int tempIndex = Tools.getRandom(Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex].length);
                        this.givenAIType = Actor.AI_GIVEN_ATTACK_TYPE[givenTypeIndex][tempIndex];
                        this.givenAttackStepCount = Actor.AI_GIVEN_ATTACK_STEP[givenTypeIndex][tempIndex];
                        this.givenAttackContrlCount = 0;
                        this.givenAttackEndFlag = false;
                        break;
                    }
                    if (randomNum >= 25) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(6);
                        break;
                    }
                    if (randomNum >= 15) {
                        if (Math.abs(this.x - targetX) > attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.changeAction(7);
                        break;
                    }
                    if (randomNum >= 10) {
                        if (Math.abs(this.x - targetX) < attactDistanceX || Math.abs(this.z - targetZ) > attactDistanceZ) break;
                        if (this.x < targetX) {
                            this.setDirection(1, true);
                        } else {
                            this.setDirection(0, true);
                        }
                        this.setSpeed(7, 0, 0);
                        this.bumpDistance = Math.abs(this.x - targetX) + 40;
                        this.enableToChangeFlag = false;
                        this.changeAction(9);
                        break;
                    }
                    if (Math.abs(this.x - targetX) > attactDistanceX) break;
                    if (this.x < targetX) {
                        this.setDirection(1, true);
                    } else {
                        this.setDirection(0, true);
                    }
                    this.changeAction(14);
                    break;
                }
                this.moveInScren(targetX, targetZ);
            }
        }
    }

    private void updateGivenAI(int givenAIType) {
        int targetX = GameScreen.role.x;
        int targetZ = GameScreen.role.z;
        int attactDistanceX = 40;
        int attactDistanceZ = 10;
        int tempSpeedX = 0;
        int tempSpeedY = 0;
        int tempSpeedZ = 0;
        switch (givenAIType) {
            case 0: {
                if (this.givenAttackContrlCount == 0) {
                    this.changeAction(12);
                    if (this.x < targetX) {
                        this.setDirection(1, true);
                    } else {
                        this.setDirection(0, true);
                    }
                    this.setAccleration(3);
                    tempSpeedY = this.getJumpVy(this.getAcclerration(), 50);
                    tempSpeedX = 0;
                    tempSpeedZ = 8;
                    this.enableToChangeFlag = false;
                    this.setSpeed(tempSpeedX, tempSpeedY, tempSpeedZ);
                } else if (this.givenAttackContrlCount % 2 == 0) {
                    --this.givenAttackStepCount;
                    if (this.givenAttackStepCount <= 0) {
                        this.givenAttackStepCount = 0;
                        this.givenAttackEndFlag = true;
                        return;
                    }
                    this.changeAction(12);
                    this.setAccleration(6);
                    tempSpeedY = this.getJumpVy(this.getAcclerration(), 20);
                    tempSpeedX = 0;
                    tempSpeedZ = -3;
                    this.enableToChangeFlag = false;
                    this.setSpeed(tempSpeedX, tempSpeedY, tempSpeedZ);
                } else {
                    this.changeAction(8);
                }
                ++this.givenAttackContrlCount;
                break;
            }
            case 1: {
                --this.givenAttackStepCount;
                if (this.givenAttackStepCount <= 0) {
                    this.givenAttackStepCount = 0;
                    this.givenAttackEndFlag = true;
                }
                this.changeAction(8);
                if (this.givenAttackContrlCount == 0) {
                    if (this.x < targetX) {
                        this.setDirection(1, true);
                    } else {
                        this.setDirection(0, true);
                    }
                }
                ++this.givenAttackContrlCount;
                break;
            }
            case 2: {
                this.changeAction(12);
                if (this.x < targetX) {
                    this.setDirection(1, true);
                } else {
                    this.setDirection(0, true);
                }
                this.setAccleration(3);
                tempSpeedY = this.getJumpVy(this.getAcclerration(), 50);
                tempSpeedX = this.faceDir == 1 ? (Actor.screenRightBoundary - this.x) / this.getJumpCount() : (this.x - Actor.screenLeftBoundary) / this.getJumpCount();
                tempSpeedZ = this.z < targetZ ? 2 : -2;
                this.enableToChangeFlag = false;
                this.setSpeed(tempSpeedX, tempSpeedY, tempSpeedZ);
                --this.givenAttackStepCount;
                if (this.givenAttackStepCount > 0) break;
                this.givenAttackStepCount = 0;
                this.givenAttackEndFlag = true;
            }
        }
    }

    private void updateWalk() {
        this.move();
    }

    private void updateBeFight() {
        if (this.isDragon()) {
            this.holdCount /= 5;
            this.setSpeed(7, 0, 0);
            this.move();
        }
        --this.holdCount;
        if (this.holdCount <= 0) {
            this.holdCount = 0;
            this.enableToChangeFlag = true;
        }
    }

    private void updateLostControl() {
        int tx = this.attackProperty[0];
        int ty = this.attackProperty[1];
        int tz = this.attackProperty[2];
        int tDir = this.attackProperty[3];
        int tAttack = this.attackProperty[4];
        int tAttackType = this.attackProperty[5];
        int tEffectType = this.attackProperty[6];
        int tBurnFlag = this.attackProperty[7];
        if (this.isDragon()) {
            if (this.y < 0) {
                this.speedY += 2;
            }
            this.setSpeed(7, 0, 0);
            this.move();
        } else {
            this.move();
            if (this.y < 0) {
                this.speedY += this.getAcclerration();
            }
            this.setSpeed(this.speedX, this.speedY, this.speedZ);
        }
        if (this.isBoss() && this.getBlood() <= 0) {
            if (this.x > GameScreen.screenX + GameScreen.screenW) {
                this.setDirection(0, false);
                this.setSpeed(7, this.speedY, this.speedZ);
                this.x = GameScreen.screenX + GameScreen.screenW;
            } else if (this.x < GameScreen.screenX) {
                this.setDirection(1, false);
                this.setSpeed(7, this.speedY, this.speedZ);
                this.x = GameScreen.screenX;
            }
        }
        switch (this.attackProperty[5]) {
            case 0: {
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 1: {
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 2: {
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 3: {
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 4: {
                int tempRandom = 0;
                if (this.x > Actor.screenRightBoundary) {
                    this.setAccleration(1);
                    this.setDirection(0, false);
                    this.setSpeed(-2, this.getJumpVy(this.getAcclerration(), 5), tempRandom);
                    this.x = Actor.screenRightBoundary;
                    this.attackProperty[5] = 1;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.setAccleration(1);
                    this.setDirection(1, false);
                    this.setSpeed(2, this.getJumpVy(this.getAcclerration(), 5), tempRandom);
                    this.x = Actor.screenLeftBoundary;
                    this.attackProperty[5] = 1;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 5: {
                if (this.y < 0) break;
                this.y = 0;
                GameScreen.initScreenShake(2, 6);
                this.changeAction(5);
            }
        }
    }

    private void updateLieDown() {
        ++this.y;
        if (this.y >= 0) {
            if (this.blood <= 0) {
                --this.lieDownCount;
                this.setViewAbleFlag(true);
                if (this.lieDownCount % 2 == 0) {
                    this.setViewAbleFlag(false);
                }
                if (this.lieDownCount <= 0) {
                    this.lieDownCount = 0;
                    this.changeAction(2);
                }
            } else {
                this.unbeatCount = this.unbeatMaxTime;
                this.enableToChangeFlag = true;
            }
            this.y = 0;
        }
    }

    private void updateAttack1() {
    }

    private void updateAttack2() {
    }

    private void updateAttack3() {
        if (this.frame >= this.cartoonList.length - 1) {
            int tempid = 0;
            switch (Actor.REMOTE_ATTACK_BULLET_TYPE[this.type]) {
                case 1: {
                    tempid = GameScreen.getEnableObject(GameScreen.bullet);
                    if (tempid < 0) break;
                    GameScreen.bullet[tempid].init(tempid, 1, 0, this.x, this.y, this.z, 5, 0, 0, this.faceDir, 1);
                    break;
                }
                case 2: {
                    tempid = GameScreen.getEnableObject(GameScreen.bullet);
                    if (tempid < 0) break;
                    GameScreen.bullet[tempid].init(tempid, 2, 0, this.x, this.y, this.z, 13, 0, 0, this.faceDir, 1);
                    break;
                }
                case 3: {
                    tempid = GameScreen.getEnableObject(GameScreen.bullet);
                    if (tempid < 0) break;
                    GameScreen.bullet[tempid].init(tempid, 3, 0, this.x, this.y, this.z, 4, 2, 0, this.faceDir, 1);
                }
            }
        }
    }

    private void updateAttack4() {
        if (this.frame >= this.cartoonList.length - 1) {
            this.move();
            this.bumpDistance -= Math.abs(this.speedX);
            if (this.bumpDistance <= 0) {
                this.bumpDistance = 0;
                this.enableToChangeFlag = true;
            }
        }
    }

    private void updateSpecialAttack1() {
        if (this.frame >= this.cartoonList.length - 1) {
            int tempRandom = Tools.getRandom(Bullet.POS_OFFSET.length);
            for (int i = 0; i < Bullet.POS_OFFSET[tempRandom].length / 3; ++i) {
                int offsetX = Bullet.POS_OFFSET[tempRandom][i * 3];
                int offsetY = Bullet.POS_OFFSET[tempRandom][i * 3 + 1];
                int offsetZ = Bullet.POS_OFFSET[tempRandom][i * 3 + 2];
                int tempid = GameScreen.getEnableObject(GameScreen.bullet);
                if (tempid < 0) continue;
                GameScreen.bullet[tempid].init(tempid, 4, 0, this.x + offsetX, this.y + offsetY, this.z + offsetZ, 0, 2, 0, this.faceDir, 1);
            }
        }
    }

    private void updateRun() {
    }

    private void updateRunAttack() {
    }

    private void updateJump() {
        this.move();
        this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
        if (this.y >= 0) {
            this.y = 0;
            this.speedY = 0;
            this.changeAction(0);
            this.enableToChangeFlag = true;
        }
    }

    private void updateBorn() {
        this.move();
        this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
        if (this.y >= 0) {
            this.y = 0;
            this.speedY = 0;
            this.changeAction(26);
            this.enableToChangeFlag = true;
        }
    }

    private void clear() {
    }

    public boolean isDragon() {
        return this.type == 3 || this.type == 6 || this.type == 9 || this.type == 12;
    }

    public boolean isBoss() {
        return this.bossFlag;
    }

    public boolean enableBeHitted() {
        return this.unbeatCount == 0 && this.actionState != 5 && (!this.isBoss() || this.actionState != 9);
    }

    public static void loadData(int scene) throws Exception {
        Enemy.loadEnemyInfoSkip();
        Enemy.loadEnemyInfo(scene);
    }

    private static void loadEnemyInfo(int scene) throws Exception {
        DataInputStream di = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/res/data/enemyInfo"));
        di.skip(ENEMY_INFO_SKIP[scene]);
        ENEMY_INFO = new short[di.readInt()];
        for (int i = 0; i < ENEMY_INFO.length; ++i) {
            Enemy.ENEMY_INFO[i] = di.readShort();
        }
        di.close();
    }

    private static void loadEnemyInfoSkip() throws Exception {
        DataInputStream di = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/res/data/enemyInfoSkip"));
        PROPERTY_NUM = di.readInt();
        ENEMY_INFO_SKIP = new int[di.readInt()];
        for (int i = 0; i < ENEMY_INFO_SKIP.length; ++i) {
            Enemy.ENEMY_INFO_SKIP[i] = di.readInt();
        }
        di.close();
    }
}

