/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Goods
extends GameObject {
    int faceDir;
    static final int FACE_LEFT = 0;
    int value;
    int deadHead = -2;
    int liveCount;
    static final byte GRAPE = 0;
    static final byte APPLE = 1;
    static final byte CRYSTAL = 2;
    static final byte MUSHROOM = 3;
    static final byte GOLD = 4;
    static final byte APPLEB = 5;
    int acceleration;
    static Image[] goodsImage = new Image[6];
    Effects effect = new Effects();
    int jumpCount;
    private short[] cartoonList;
    static final int[][] CARTOON_INDEX = new int[][]{{0, 0, 1, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1}};
    static final short[][][] GOODS_IMAGE_DATA = new short[][][]{new short[][]{{0, 0, 16, 16}}, new short[][]{{0, 0, 15, 13}}, new short[][]{{0, 0, 14, 14}}, new short[][]{{0, 0, 16, 16}}, new short[][]{{0, 0, 16, 42}, {16, 20, 26, 22}}, new short[][]{{0, 0, 25, 24}}};
    static final short[][][] GOODS_FRAME_DATA = new short[][][]{new short[][]{{0, 1, -9, -17}}, new short[][]{{1, 1, -9, -15}}, new short[][]{{2, 1, -9, -15}}, new short[][]{{3, 1, -9, -17}}, new short[][]{{4, 1, -8, -42}, {4, 2, -13, -22}}, new short[][]{{5, 1, -13, -24}}};
    static final short[][][] GOODS_CARTOON_DATA = new short[][][]{new short[][]{{0}}, new short[][]{{0}}, new short[][]{{0}}, new short[][]{{0}}, new short[][]{{0}, {1}}, new short[][]{{0}}};
    static int[][] ATTACK_AREA = new int[][]{{-9, -17, 18, 17}, {-9, -15, 18, 15}, {-9, -15, 18, 15}, {-9, -17, 18, 17}, {-7, -16, 14, 16}, {-13, -24, 20, 24}};
    static final int[] GOODS_VALUE = new int[]{45, 30, 1, 1, 100, 60};

    public Goods() {
        this.state = -1;
    }

    public void init(int i_id, int t_type, int s_state, int tx, int ty, int tz) {
        this.id = i_id;
        this.type = t_type;
        this.state = 0;
        this.x = tx;
        if (this.x > GameScreen.screenX + GameScreen.screenW) {
            this.x = GameScreen.screenX + GameScreen.screenW;
        } else if (this.x < GameScreen.screenX) {
            this.x = GameScreen.screenX;
        }
        this.y = ty;
        this.z = tz;
        this.value = GOODS_VALUE[this.type];
        this.liveCount = 200;
        this.setAccleration(4);
        this.setSpeed(Tools.getSignRandom(3), this.getJumpVy(this.getAcclerration(), 50 + Tools.getSignRandom(11)), Tools.getSignRandom(2));
        this.setCartoonList(GOODS_CARTOON_DATA[this.type], this.state);
    }

    public static void initGroup(int x, int y, int z) {
        int[] goodArray = new int[]{0, 1, 4, 0, 1, 4, 0, 1, 4, 0, 1, 4, 0, 1, 0, 4};
        if (GameScreen.goods != null) {
            for (int i = 0; i < 8; ++i) {
                int temp_id = GameScreen.getEnableObject(GameScreen.goods);
                if (temp_id == -1) continue;
                GameScreen.goods[temp_id].init(temp_id, goodArray[Tools.getRandom(goodArray.length)], 0, x, y, z);
            }
        }
    }

    public void changeAction(int action) {
        this.frame = 0;
        this.state = action;
        this.setCartoonList(GOODS_CARTOON_DATA[this.type], this.state);
        if (this.state == this.deadHead) {
            GameScreen.task.endConditionUpdate(1, this.type);
            if (this.value > 0) {
                this.effect.init(5, this.x, this.y, this.z, this.y, "" + this.value, this.type);
            }
        }
    }

    public void setSpeed(int speed_x, int speed_y, int speed_z) {
        this.speedX = speed_x;
        this.speedY = speed_y;
        this.speedZ = speed_z;
    }

    public void setCartoonList(short[][] cartoonData, int index) {
        if (index >= 0) {
            this.cartoonList = cartoonData[index];
        }
    }

    public void setAccleration(int a) {
        this.acceleration = a;
    }

    public int getAcclerration() {
        return this.acceleration;
    }

    protected int getJumpVy(int a, int maxHeight) {
        int sumH = 0;
        int tempV = 0;
        this.jumpCount = 0;
        while (sumH < maxHeight) {
            sumH += (tempV += a);
            this.jumpCount += 2;
        }
        return -tempV;
    }

    protected void move() {
        this.y += this.speedY;
        if (GameScreen.isMovableX(this.x, this.speedX)) {
            this.x += this.speedX;
        }
        if (GameScreen.isMovableZ(this.z + this.speedZ)) {
            this.z += this.speedZ;
        }
    }

    public int getTrans(int value) {
        if (value > 0) {
            return 0;
        }
        if (value < 0) {
            return 1;
        }
        return -1;
    }

    public void draw(Graphics g) {
        if (this.state != this.deadHead) {
            if (this.y >= 0) {
                this.drawShadow(g);
                this.drawFrame(g);
            } else {
                this.drawShadow(g);
                this.drawFrame(g);
            }
            this.updateFrame();
        }
        if (this.state != -1 && this.effect.state != -1) {
            this.effect.draw(g);
        }
    }

    public void update() {
        if (this.state != this.deadHead) {
            this.move();
            this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
            if (this.y >= 0) {
                this.y = 0;
                this.speedX = 0;
                this.speedZ = 0;
                if (this.type == 4) {
                    this.changeAction(1);
                }
            }
        }
        if (this.state != -1) {
            if (this.effect.state != -1) {
                this.effect.update();
            }
            if (this.effect.state == this.deadHead) {
                this.effect.state = -1;
                this.state = -1;
            }
        }
        --this.liveCount;
        if (this.liveCount <= 0) {
            this.liveCount = 0;
            this.state = -1;
        }
    }

    protected void updateFrame() {
        ++this.frame;
        if (this.frame >= this.cartoonList.length) {
            this.frame = 0;
        }
    }

    protected void drawFrame(Graphics g) {
        if (this.frame >= 0) {
            int frameIndex = this.getFrameIndex();
            short[] frameData = this.getFrameData(frameIndex);
            block4: for (int i = 0; i < frameData.length >> 2; ++i) {
                short[] baseData = this.getImageData(frameData[(i << 2) + 1]);
                int transType = this.getTrans(frameData[(i << 2) + 1]);
                Image img = this.getImage(frameData[i << 2]);
                if (img == null) continue;
                switch (this.faceDir) {
                    case 1: {
                        int px = this.x - GameScreen.screenX + frameData[i * 4 + 2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrame(g, baseData, px, py, transType, img);
                        continue block4;
                    }
                    case 0: {
                        int px = this.x - GameScreen.screenX - frameData[i * 4 + 2] - baseData[2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrameR(g, baseData, px, py, transType, img);
                    }
                }
            }
        }
    }

    protected void drawShadow(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        g.fillArc(this.x - 10 - GameScreen.screenX, this.z - 6 - GameScreen.screenY, 20, 6, 0, 360);
    }

    protected void drawRect(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(65535);
        if (this.getAttackArea() != null) {
            g.drawRect(this.x + ATTACK_AREA[this.type][0] - GameScreen.screenX, this.z + this.y + ATTACK_AREA[this.type][1], ATTACK_AREA[this.type][2], ATTACK_AREA[this.type][3]);
        }
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public short[] getFrameData(int index) {
        return GOODS_FRAME_DATA[this.type][index];
    }

    public short[] getImageData(int index) {
        return GOODS_IMAGE_DATA[this.type][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        return goodsImage[id];
    }

    public int[] getAttackArea() {
        int[] property = ATTACK_AREA[this.type];
        return new int[]{this.x + property[0], this.z + this.y + property[1], property[2], property[3], this.z};
    }

    public void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    public static void loadRes() throws Exception {
        for (int i = 0; i < goodsImage.length; ++i) {
            Goods.goodsImage[i] = Tools.createImage("/goods/" + i + ".png");
        }
    }
}

