/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Map {
    private static final int CLOSE_LAYER = 0;
    private static final int GROUND_LAYER = 1;
    private static final int MID_LAYER = 2;
    private static final int FAR_LAYER = 3;
    private static final int BACK_LAYER = 4;
    static short[] RES_INDEX = new short[]{0, 1, 1, 2, 2, 3, 3, 4, 5, 5, 1, 1, 3, 3, 2, 2, 4, 4, 5, 5, 5};
    static short[] MID_LAYER_RES_NUM = new short[]{1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};
    static short[] MID_LAYER_TILE_NUM = new short[]{1, 6, 1, 6, 6, 6, 1, 1, 6, 1, 6, 6, 6, 6, 6, 1, 6, 1, 6, 6, 1};
    private static short[] MAP_GROUND_WIDTH = new short[]{210, 110, 210, 110, 210, 110, 210, 110, 210, 110, 210, 100, 210, 100, 177, 110, 210, 110, 210, 110, 210, 110, 210, 110, 210, 100, 210, 100, 210, 110, 210, 110, 177, 110, 177, 110, 210, 110, 210, 110, 210, 110};
    private static Image[] pieceImages;
    private static Image[] farLayerImg;
    private static Image[] backLayerImg;
    private static Image groundImg;
    private static Image tentImg;
    private static Image closeImg;
    private static Image[] cloudImage;
    private static Image[] fireImage;
    private static int[] fireImageIndex;
    private static int[] fireImagePos;
    private GameScreen gs;
    private Tools tools;
    private static int[] midLayerImageIndex;
    private static int[] midLayerImagePos;
    static int farLayerX;
    static int[] cloudX;
    private static int mapLength;
    private static int scene;
    private static int mapFrameCount;

    public Map(GameScreen gs) {
        this.gs = gs;
        this.tools = GameScreen.tools;
    }

    public static int getMapLength() {
        return mapLength;
    }

    public static void loadMapRes(int sceneId) throws Exception {
        scene = sceneId;
        Map.clearMap();
        switch (scene) {
            case 0: {
                Map.loadMap0();
                break;
            }
            case 1: 
            case 2: {
                Map.loadMap1();
                break;
            }
            case 3: 
            case 4: {
                Map.loadMap2();
                break;
            }
            case 5: 
            case 6: {
                Map.loadMap3();
                break;
            }
            case 7: {
                Map.loadMap4();
                break;
            }
            case 8: 
            case 9: {
                Map.loadMap5();
                break;
            }
            case 10: 
            case 11: {
                Map.loadMap1();
                break;
            }
            case 12: 
            case 13: {
                Map.loadMap3();
                break;
            }
            case 14: 
            case 15: {
                Map.loadMap2();
                break;
            }
            case 16: 
            case 17: {
                Map.loadMap4();
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                Map.loadMap5();
            }
        }
        Map.getRandomMap();
        Map.getRandomFirePos();
    }

    private static void loadBaseData() throws Exception {
        int i;
        DataInputStream di = new DataInputStream(Runtime.getRuntime().getClass().getResourceAsStream("/res/data/mapbase"));
        RES_INDEX = new short[di.readInt()];
        for (i = 0; i < RES_INDEX.length; ++i) {
            Map.RES_INDEX[i] = di.readShort();
        }
        MID_LAYER_RES_NUM = new short[di.readInt()];
        for (i = 0; i < MID_LAYER_RES_NUM.length; ++i) {
            Map.MID_LAYER_RES_NUM[i] = di.readShort();
        }
        MID_LAYER_TILE_NUM = new short[di.readInt()];
        for (i = 0; i < MID_LAYER_TILE_NUM.length; ++i) {
            Map.MID_LAYER_TILE_NUM[i] = di.readShort();
        }
        MAP_GROUND_WIDTH = new short[di.readInt()];
        for (i = 0; i < MAP_GROUND_WIDTH.length; ++i) {
            Map.MAP_GROUND_WIDTH[i] = di.readShort();
        }
        di.close();
    }

    private static void getRandomMap() throws Exception {
        if (pieceImages.length > 0) {
            midLayerImageIndex = new int[MID_LAYER_TILE_NUM[scene]];
            midLayerImagePos = new int[MID_LAYER_TILE_NUM[scene]];
            for (int i = 0; i < midLayerImageIndex.length; ++i) {
                Map.midLayerImageIndex[i] = Tools.getRandom(pieceImages.length);
                Map.midLayerImagePos[i] = mapLength;
                mapLength += pieceImages[midLayerImageIndex[i]].getWidth();
            }
        }
    }

    private static void getRandomFirePos() throws Exception {
        if (fireImage != null) {
            int maxImageW = 0;
            for (int i = 0; i < fireImage.length; ++i) {
                if (i + 1 >= fireImage.length) continue;
                maxImageW = Math.max(fireImage[i].getWidth(), fireImage[i + 1].getWidth());
            }
            int num = Math.max(5, Tools.getRandom(Map.getMapLength() / maxImageW));
            fireImagePos = new int[num];
            fireImageIndex = new int[num];
            int distance = 0;
            for (int index = 0; index < num; ++index) {
                Map.fireImageIndex[index] = Tools.getRandom(fireImage.length);
                Map.fireImagePos[index] = Tools.getRandom(100) < 50 ? distance : -distance;
                distance += fireImage[fireImageIndex[index]].getWidth() * (1 + Tools.getRandom(3));
            }
        }
    }

    private static void loadMap0() throws Exception {
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (int i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
        farLayerImg = new Image[1];
        Map.farLayerImg[0] = Tools.createImage("/map/" + RES_INDEX[scene] + "/far0.png");
        tentImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/tent.png");
    }

    private static void loadMap1() throws Exception {
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (int i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
        backLayerImg = new Image[2];
        Map.backLayerImg[0] = Tools.createImage("/map/" + RES_INDEX[scene] + "/back0.png");
        Map.backLayerImg[1] = Tools.createImage("/map/" + RES_INDEX[scene] + "/back1.png");
    }

    private static void loadMap2() throws Exception {
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (int i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
    }

    private static void loadMap3() throws Exception {
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (int i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
        closeImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/close.png");
    }

    private static void loadMap4() throws Exception {
        int i;
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
        farLayerImg = new Image[1];
        Map.farLayerImg[0] = Tools.createImage("/map/" + RES_INDEX[scene] + "/far0.png");
        cloudImage = new Image[3];
        cloudX = new int[cloudImage.length];
        for (i = 0; i < cloudImage.length; ++i) {
            Map.cloudImage[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/cloud" + i + ".png");
        }
    }

    private static void loadMap5() throws Exception {
        int i;
        pieceImages = new Image[MID_LAYER_RES_NUM[scene]];
        for (i = 0; i < pieceImages.length; ++i) {
            Map.pieceImages[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/" + i + ".png");
        }
        groundImg = Tools.createImage("/map/" + RES_INDEX[scene] + "/ground.png");
        farLayerImg = new Image[1];
        Map.farLayerImg[0] = Tools.createImage("/map/" + RES_INDEX[scene] + "/far0.png");
        fireImage = new Image[2];
        for (i = 0; i < fireImage.length; ++i) {
            Map.fireImage[i] = Tools.createImage("/map/" + RES_INDEX[scene] + "/fire" + i + ".png");
        }
    }

    public static void clearMap() {
        mapLength = 0;
        midLayerImageIndex = null;
        midLayerImagePos = null;
        farLayerX = 0;
        pieceImages = null;
        farLayerImg = null;
        backLayerImg = null;
        groundImg = null;
        tentImg = null;
        closeImg = null;
        cloudImage = null;
        fireImage = null;
        fireImageIndex = null;
        fireImagePos = null;
        System.gc();
    }

    private static int getMapFrameCount() {
        return mapFrameCount;
    }

    private static void updateMapFrame() {
        if (++mapFrameCount > 1000) {
            mapFrameCount = 0;
        }
    }

    public static void update() {
        Map.updateMapFrame();
        Map.updateBackLayer();
        Map.updateFarLayer();
        Map.updateMidLayer();
        Map.updateGround();
        Map.updateCloseLayer();
    }

    public static void updateCloseLayer() {
    }

    public static void updateGround() {
    }

    public static void updateMidLayer() {
    }

    public static void updateFarLayer() {
    }

    public static void updateBackLayer() {
    }

    public static void draw(Graphics g) {
        int debug = 0;
        try {
            Map.drawBackLayer(g);
            debug = 1;
            Map.drawFarLayer(g);
            debug = 2;
            Map.drawMidLayer(g);
            debug = 3;
            Map.drawGround(g);
            debug = 4;
            debug = 5;
        }
        catch (RuntimeException e) {
            System.out.println("debug:" + debug);
            e.printStackTrace();
        }
    }

    public static void drawCloseLayer(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        if (closeImg != null) {
            int imgW = closeImg.getWidth();
            int num = GameScreen.screenW / imgW + 1;
            if (num * imgW - GameScreen.screenW < imgW) {
                ++num;
            }
            int offsetx = GameScreen.screenX % imgW;
            for (int i = num - 1; i >= 0; --i) {
                g.drawImage(closeImg, i * imgW - offsetx, 0, 20);
            }
        }
        if (fireImage != null) {
            for (int i = 0; i < fireImageIndex.length; ++i) {
                int ty;
                if (fireImagePos[i] >= 0) continue;
                int frameNum = 3;
                int imgIndex = fireImageIndex[i];
                int tw = fireImage[imgIndex].getWidth();
                int th = fireImage[imgIndex].getHeight() / frameNum;
                int tx = Math.abs(fireImagePos[i]);
                if (!Map.isInScreen(tx, ty = GameScreen.screenH - th + 5, tw, th)) continue;
                g.setClip(tx - GameScreen.screenX, ty - GameScreen.screenY, tw, th);
                g.drawImage(fireImage[imgIndex], tx - GameScreen.screenX, ty - Map.getMapFrameCount() % frameNum * th - GameScreen.screenY, 20);
                g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
            }
        }
    }

    public static void drawGround(Graphics g) {
        int i;
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        int imgW = groundImg.getWidth();
        int imgH = groundImg.getHeight();
        int num = GameScreen.screenW / imgW + 1;
        if (num * imgW - GameScreen.screenW < imgW) {
            ++num;
        }
        int offsetx = GameScreen.screenX % imgW;
        for (i = num - 1; i >= 0; --i) {
            g.drawImage(groundImg, i * imgW - offsetx, GameScreen.screenH - GameScreen.screenY, 36);
        }
        if (tentImg != null) {
            int ty;
            int tw = tentImg.getWidth();
            int th = tentImg.getHeight();
            int tx = Map.getMapLength() - tw;
            if (Map.isInScreen(tx, ty = GameScreen.screenH - imgH - th, tw, th)) {
                g.setClip(tx - GameScreen.screenX, ty - GameScreen.screenY, tw, th);
                g.drawImage(tentImg, tx - GameScreen.screenX, ty - GameScreen.screenY, 20);
                g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
            }
        }
        if (fireImage != null) {
            for (i = 0; i < fireImageIndex.length; ++i) {
                if (fireImagePos[i] < 0) continue;
                int frameNum = 3;
                int imgIndex = fireImageIndex[i];
                int tw = fireImage[imgIndex].getWidth();
                int tx = fireImagePos[i];
                int th = fireImage[imgIndex].getHeight() / frameNum;
                int ty = GameScreen.screenH - imgH - th - 5;
                if (!Map.isInScreen(tx, ty, tw, th)) continue;
                g.setClip(tx - GameScreen.screenX, ty - GameScreen.screenY, tw, th);
                g.drawImage(fireImage[imgIndex], tx - GameScreen.screenX, ty - Map.getMapFrameCount() % frameNum * th - GameScreen.screenY, 20);
                g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
            }
        }
    }

    public static void drawMidLayer(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        if (pieceImages != null) {
            for (int i = 0; i < midLayerImageIndex.length; ++i) {
                int h;
                int x = midLayerImagePos[i];
                int y = 0;
                int w = pieceImages[midLayerImageIndex[i]].getWidth();
                if (!Map.isInScreen(x, y, w, h = pieceImages[midLayerImageIndex[i]].getHeight())) continue;
                g.drawImage(pieceImages[midLayerImageIndex[i]], x - GameScreen.screenX, y - GameScreen.screenY, 20);
            }
        }
    }

    public static void drawFarLayer(Graphics g) {
        int farLayerMoveSpeed = 0;
        if (farLayerImg != null) {
            g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
            int imgW = farLayerImg[0].getWidth();
            int num = GameScreen.screenW / imgW + 1;
            if (num * imgW - GameScreen.screenW < imgW) {
                ++num;
            }
            if (GameScreen.screenMoveSpeed > 0) {
                farLayerMoveSpeed = 2;
            } else if (GameScreen.screenMoveSpeed < 0) {
                farLayerMoveSpeed = -2;
            }
            if ((farLayerX += farLayerMoveSpeed) <= 0) {
                farLayerX = 0;
            }
            int offsetx = farLayerX % imgW;
            for (int i = num - 1; i >= 0; --i) {
                g.drawImage(farLayerImg[0], i * imgW - offsetx, 0, 20);
            }
        }
        if (cloudImage != null) {
            for (int i = 0; i < cloudImage.length; ++i) {
                int imgW = cloudImage[i].getWidth();
                int speed = i + 1;
                int px = 0;
                int n = i;
                cloudX[n] = cloudX[n] + (speed + farLayerMoveSpeed);
                if (cloudX[i] > GameScreen.screenW + imgW) {
                    Map.cloudX[i] = 0;
                }
                px = GameScreen.screenX + GameScreen.screenW + imgW - cloudX[i];
                g.drawImage(cloudImage[i], px - imgW - GameScreen.screenX, 20 + i * 20, 20);
            }
        }
    }

    public static void drawBackLayer(Graphics g) {
        if (backLayerImg != null) {
            int index = Map.getMapFrameCount() % backLayerImg.length;
            g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
            g.drawImage(backLayerImg[index], GameScreen.screenW >> 1, 0, 17);
        }
    }

    public static Image getImage(int index) {
        return pieceImages[Math.abs(index)];
    }

    public static int getGroundTop() {
        return MAP_GROUND_WIDTH[scene * 2];
    }

    public static int getGroundWidth() {
        return MAP_GROUND_WIDTH[scene * 2 + 1];
    }

    public static boolean isInScreen(int x, int y, int w, int h) {
        return x + w >= GameScreen.screenX && y + h >= GameScreen.screenY && x <= GameScreen.screenX + GameScreen.screenW && y <= GameScreen.screenY + GameScreen.screenH;
    }
}

