/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class NPC
extends Actor {
    static int[][] NPC_INFO = new int[][]{{1, 100, 0, 200, 0, 250, 0, 200}, {2, 150, 0, 230}, {3, 150, 0, 230}};
    static Image[] npcImage = new Image[4];
    static int[] SCENE = new int[]{0, -1, -1, -1, -1, -1, -1, -1, -1, 1, -1, -1, -1, -1, -1, 2, -1, -1, -1, -1, -1, -1};
    static final byte TASKNPC = 0;
    static final byte SHOPNPC = 1;
    static final byte GAMENPC = 2;
    static final byte GAMENPC1 = 3;
    static final String[][] TIPS = new String[][]{{"\u5371\u9669\u65e0\u5904\u4e0d\u5728", "\u591a\u4e48\u7f8e\u4e3d\u7684\u6751\u5e84", "\u5fc5\u987b\u6293\u7d27\u65f6\u95f4", "\u654c\u4eba\u5f88\u5f3a\u5927"}, {"\u9700\u8981\u7145\u9020\u88c5\u5907\u5417", "\u8981\u770b\u770b\u5417\uff1f"}, {"\u6709\u4eba\u6765\u4e86\uff1f"}, {"\u8fd8\u6ca1\u8d76\u6765\u4e48\uff1f"}};
    int tipIndex;
    boolean collideflag;
    private short[] cartoonList;
    static final short[][][] NPC_CARTOON_DATA = new short[][][]{new short[][]{{0}}, new short[][]{{0}}, new short[][]{{0}}, new short[][]{{0}}};
    static final short[][][] NPC_FRAME_DATA = new short[][][]{new short[][]{{0, 1, -15, -40}}, new short[][]{{1, 1, -17, -47}}, new short[][]{{2, 1, -17, -33}}, new short[][]{{3, 1, -17, -47}}};
    static final short[][][] NPC_IMAGE_DATA = new short[][][]{new short[][]{{0, 0, 24, 42}}, new short[][]{{0, 0, 79, 49}}, new short[][]{{0, 0, 29, 33}}, new short[][]{{0, 0, 39, 47}}};

    public NPC() {
        this.state = -1;
    }

    public void init(int i_id, int t_type, int s_state, int tx, int ty, int tz) {
        this.id = i_id;
        this.type = t_type;
        this.state = s_state;
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.setCartoonList(NPC_CARTOON_DATA[this.type][0]);
        this.tipIndex = 0;
    }

    public void setTipIndex(int index) {
        this.tipIndex = index;
    }

    public void setcollideflag(boolean flag) {
        this.collideflag = flag;
    }

    public boolean getCollideflag() {
        return this.collideflag;
    }

    public void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    public void setCartoonList(short[] list) {
        this.cartoonList = list;
    }

    public void update() {
        switch (this.type) {
            case 0: {
                if (this.getCollideflag() && !GameScreen.keyDialogFlag) {
                    GameScreen.collideTaskFlag = true;
                    break;
                }
                GameScreen.collideTaskFlag = false;
                break;
            }
            case 1: {
                if (this.getCollideflag() && !GameScreen.keyShopFlag) {
                    GameScreen.collideShopFlag = true;
                    break;
                }
                GameScreen.collideShopFlag = false;
                break;
            }
            case 2: 
            case 3: {
                if (!this.getCollideflag() || GameScreen.keyDialogFlag) break;
                if (Task.missionState[GameScreen.task.getNextMainMissionID()] == 1) {
                    GameScreen.task.initFinishDialog();
                    GameScreen.keyDialogFlag = true;
                }
                GameScreen.task.endConditionUpdate(0, this.type);
            }
        }
    }

    public void draw(Graphics g) {
        if (this.state != -1) {
            this.drawFrame(g);
            if (!(this.type != 0 && this.type != 1 || !this.getCollideflag() || GameScreen.keyDialogFlag || GameScreen.keyShopFlag)) {
                this.drawNpcTips(g);
            }
        }
    }

    private void drawNpcTips(Graphics g) {
        g.setFont(GameScreen.font);
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        int tx = this.x - GameScreen.screenX;
        int ty = this.y + this.z - 40 - GameScreen.dialogImages[3].getHeight() - GameScreen.screenY;
        g.drawImage(GameScreen.dialogImages[3], tx, ty, 17);
        int wordX = tx + 6;
        int wordY = ty + 15;
        g.setColor(13943916);
        g.drawString(TIPS[this.type][this.tipIndex] + "    ", wordX, wordY, 17);
        tx = wordX + (GameScreen.font.stringWidth(TIPS[this.type][this.tipIndex]) >> 1);
        ty = 0;
        ty = GameScreen.getGameLoopCount() % 4 > 1 ? wordY - 1 : wordY + 1;
        g.drawImage(GameScreen.dialogImages[2], tx - 3, ty + 3, 20);
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public short[] getFrameData(int index) {
        return NPC_FRAME_DATA[this.type][index];
    }

    public short[] getImageData(int index) {
        return NPC_IMAGE_DATA[this.type][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        return npcImage[id];
    }

    public boolean checkDistance(int tx, int ty, int dis) {
        int temp_x = tx - this.x;
        int temp_y = ty - this.z;
        int temp_r = dis;
        return temp_x * temp_x + temp_y * temp_y < temp_r * temp_r;
    }

    public static void loadRes() throws Exception {
        for (int i = 0; i < npcImage.length; ++i) {
            NPC.npcImage[i] = Tools.createImage("/npc/N" + i + ".png");
        }
    }
}

