/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Role
extends Actor {
    static final int SKILL_COST = 50;
    static final int RUN_COUNT_LIMIT = 5;
    static final int POWER_UP_COUNT_LIMIT = 10;
    static final int MAX_POWER = 30;
    int runCount;
    int powerUpCount;
    int powerCount;
    static final int MAX_REWARD_COUNT = 50;
    static final int MAX_CONTINUE_COUNT = 30;
    boolean comboFlag;
    int combo;
    int continueCount;
    int maxCombo;
    static final int MAX_FIRE_ATTACK_COUNT = 350;
    private boolean fireAttackFlag;
    private int fireAttackCount;
    boolean nextAttackFlag;
    int nextAttack;
    int nextAttackCount;
    boolean localHitFlag;
    int attackPauseCount;
    boolean autoMoveInFlag;
    boolean autoMoveOutFlag;
    int autoMoveOutStep;

    public void changeAction(int action) {
        this.frame = 0;
        this.actionState = action;
        this.setCartoonList(Actor.CARTOON_DATA[this.type], Actor.CARTOON_INDEX[this.type][this.actionState]);
        this.hitPauseCount = 0;
        this.beHittedPauseCount = 0;
        this.localHitFlag = false;
        switch (this.actionState) {
            case 2: {
                this.setViewAbleFlag(false);
                GameScreen.initReliveEffect();
                break;
            }
            case 0: {
                if (this.blood < this.maxBlood >> 2) {
                    this.setCartoonList(Actor.CARTOON_DATA[this.type], Actor.CARTOON_INDEX[this.type][27]);
                }
                this.holdCount = 0;
                this.enableToChangeFlag = true;
                this.setSpeed(0, 0, 0);
                this.setAccleration(0);
                break;
            }
            case 3: 
            case 4: 
            case 21: {
                this.runCount = 0;
                this.powerUpCount = 0;
                this.powerCount = 0;
                this.nextAttack = 0;
                this.nextAttackCount = 0;
                this.nextAttackFlag = false;
                this.setNextAction(0);
                break;
            }
            case 17: {
                if (this.isFireAttack()) break;
                this.updateSkillCost();
                break;
            }
            case 18: {
                if (this.isFireAttack()) break;
                this.updateSkillCost();
                break;
            }
            case 26: {
                this.nextAttack = 0;
                this.setNextAction(0);
                break;
            }
            case 28: {
                if (this.effect.isAlive()) break;
                this.effect.init(4, this.x, this.y, this.z, this.faceDir, 0);
                break;
            }
        }
    }

    public void init(int t_id, int t_type, int action, int tx, int ty, int tz, int dir) throws Exception {
        this.id = t_id;
        this.type = t_type;
        this.frame = 0;
        this.setDirection(dir, true);
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.width = Actor.ACTOR_SIZE[this.type << 1];
        this.height = Actor.ACTOR_SIZE[(this.type << 1) + 1];
        this.setMaxBlood(this.getMaxBlood());
        this.setBlood(this.getBlood());
        this.setMaxDander(this.getMaxDander());
        this.setDander(this.getDander());
        this.setAttack(this.getAttack());
        this.setDefence(this.getDefence());
        this.setScore(this.getScore());
        this.setViewAbleFlag(true);
        this.lieDownCount = 10;
        this.unbeatMaxTime = 5;
        this.holdCount = 0;
        this.enableToChangeFlag = true;
        this.autoMoveInFlag = false;
        this.autoMoveOutFlag = false;
        this.autoMoveOutStep = 0;
        this.setNextAction(0);
        this.changeAction(action);
    }

    public void initRoleProperty() {
        this.setMaxBlood(100 + GameScreen.addBlood);
        this.setBlood(this.getMaxBlood());
        this.setMaxDander(200);
        this.setDander(0);
        this.setAttack(0);
        this.setDefence(0);
        GameScreen.readNewGame();
        if (this.score < 9999) {
            this.setScore(0);
        } else {
            this.setScore(9999);
        }
        this.maxCombo = 0;
    }

    protected void move() {
        this.y += this.speedY;
        if (GameScreen.isMovableX(this.x, this.speedX)) {
            this.x += this.speedX;
        }
        if (GameScreen.isMovableZ(this.z + this.speedZ)) {
            this.z += this.speedZ;
        }
    }

    public void beHittedEvent() {
        int tx = this.attackProperty[0];
        int ty = this.attackProperty[1];
        int tz = this.attackProperty[2];
        int tDir = this.attackProperty[3];
        int tAttack = this.attackProperty[4];
        int tAttackType = this.attackProperty[5];
        int tEffectType = this.attackProperty[6];
        int tBurnFlag = this.attackProperty[7];
        if (this.x < tx) {
            this.setDirection(0, false);
        } else if (this.x > tx) {
            this.setDirection(1, false);
        }
        this.effect.init(tEffectType, this.x, this.y, this.z, this.faceDir, -30);
        this.beHittedPauseCount = 2;
        this.updateBlood(tAttack);
        GameScreen.reduceBlood(tAttack);
        int tempType = tBurnFlag == 0 ? 4 : 21;
        switch (tAttackType) {
            case 0: {
                if (this.blood <= 0) {
                    this.changeAction(tempType);
                    this.setAccleration(1);
                    this.setSpeed(2, this.getJumpVy(this.getAcclerration(), 5), 0);
                    this.enableToChangeFlag = false;
                } else {
                    this.changeAction(3);
                    this.holdCount = 5;
                    this.enableToChangeFlag = false;
                }
                if (this.y >= 0) break;
                this.changeAction(tempType);
                this.setAccleration(2);
                this.setSpeed(10, this.getJumpVy(this.getAcclerration(), 5), 0);
                this.enableToChangeFlag = false;
                break;
            }
            case 1: {
                this.changeAction(tempType);
                this.setAccleration(1);
                this.setSpeed(3, this.getJumpVy(this.getAcclerration(), 5), 0);
                this.enableToChangeFlag = false;
            }
        }
    }

    public void initAutoMoveIn() {
        this.autoMoveInFlag = true;
    }

    public void autoMoveIn() {
        this.setDirection(1, true);
        this.setSpeed(4, 0, 0);
        this.setNextAction(1);
        if (this.x > GameScreen.moveLeftBorder + 30) {
            this.autoMoveInFlag = false;
        }
    }

    public void initAutoMoveOut() {
        if (this.y >= 0) {
            this.autoMoveOutFlag = true;
        }
    }

    public void autoMoveOut() {
        int tempAction = 1;
        int tempDir = 1;
        int tempSpeedX = 0;
        int tempSpeedZ = 0;
        int xMiddle = GameScreen.moveRightBorder - (GameScreen.screenW >> 1);
        int zMiddle = Map.getGroundTop() + (Map.getGroundWidth() >> 1);
        if (this.autoMoveOutStep == 0) {
            if (Math.abs(this.z - zMiddle) > 10) {
                tempDir = this.x - xMiddle > 0 ? 0 : 1;
                tempSpeedX = 2;
                tempAction = 1;
                tempSpeedZ = this.z - zMiddle > 0 ? -2 : 2;
            } else {
                ++this.autoMoveOutStep;
            }
        } else if (this.autoMoveOutStep == 1) {
            tempDir = 1;
            tempSpeedX = 6;
            tempSpeedZ = 0;
            tempAction = 10;
        }
        this.setDirection(tempDir, true);
        this.setSpeed(tempSpeedX, 0, tempSpeedZ);
        this.setNextAction(tempAction);
    }

    public void input() {
        switch (this.actionState) {
            case 0: {
                this.inputStand();
                break;
            }
            case 1: {
                this.inputWalk();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 6: {
                if (!GameScreen.isPressedSingleKey(16) || this.nextAttackCount <= 0) break;
                this.nextAttackCount = 0;
                if (!this.fireAttackFlag) {
                    this.setNextAction(7);
                    break;
                }
                this.setNextAction(14);
                break;
            }
            case 7: 
            case 14: {
                if (!GameScreen.isPressedSingleKey(16) || this.nextAttackCount <= 0) break;
                this.nextAttackCount = 0;
                if (!this.fireAttackFlag) {
                    this.setNextAction(8);
                    break;
                }
                this.setNextAction(15);
                break;
            }
            case 8: 
            case 15: {
                if (GameScreen.isPressedSingleKey(16)) {
                    if (this.nextAttackCount <= 0) break;
                    this.nextAttackCount = 0;
                    if (!this.fireAttackFlag) {
                        this.setNextAction(9);
                        break;
                    }
                    this.setNextAction(16);
                    break;
                }
                if (GameScreen.isPressedSingleKey(256)) {
                    if (this.blood - 25 <= 0 && this.getDander() - 50 <= 0) break;
                    this.nextAttack = 0;
                    this.nextAttackCount = 0;
                    this.nextAttackFlag = false;
                    this.setNextAction(0);
                    this.changeAction(17);
                    break;
                }
                if (!GameScreen.isPressedSingleKey(512) || this.blood - 25 <= 0 && this.getDander() - 50 <= 0) break;
                this.nextAttack = 0;
                this.nextAttackCount = 0;
                this.nextAttackFlag = false;
                this.setNextAction(26);
                this.changeAction(18);
                this.enableToChangeFlag = false;
                this.setAccleration(2);
                this.setSpeed(0, this.getJumpVy(this.getAcclerration(), 60), 0);
                break;
            }
            case 10: {
                this.inputRun();
                break;
            }
            case 12: {
                if (!GameScreen.isPressedSingleKey(16)) break;
                this.changeAction(13);
                break;
            }
            case 28: {
                if (GameScreen.isPressedMultiKey(16)) {
                    this.setNextAction(28);
                    break;
                }
                this.setNextAction(0);
                if (this.powerCount >= 30) {
                    this.powerCount = 0;
                    this.changeAction(29);
                    break;
                }
                this.powerCount = 0;
                this.changeAction(0);
            }
        }
    }

    private void inputStand() {
        if (GameScreen.isPressedMultiKey(1)) {
            this.setSpeed(0, 0, -4);
            this.changeAction(1);
        } else if (GameScreen.isPressedMultiKey(2)) {
            this.setSpeed(0, 0, 4);
            this.changeAction(1);
        } else if (GameScreen.isPressedMultiKey(4)) {
            if (this.runCount > 0) {
                this.setSpeed(6, 0, 0);
                this.changeAction(10);
            } else {
                this.setSpeed(-4, 0, 0);
                this.changeAction(1);
            }
            this.setDirection(0, true);
        } else if (GameScreen.isPressedMultiKey(8)) {
            if (this.runCount > 0) {
                this.setSpeed(6, 0, 0);
                this.changeAction(10);
            } else {
                this.setSpeed(4, 0, 0);
                this.changeAction(1);
            }
            this.setDirection(1, true);
        }
        if (GameScreen.isPressedMultiKey(16)) {
            ++this.powerUpCount;
            if (this.powerUpCount >= 10) {
                this.powerUpCount = 0;
                this.changeAction(28);
            }
        } else {
            this.powerUpCount = 0;
        }
        if (GameScreen.isPressedSingleKey(16)) {
            switch (this.nextAttack) {
                case 0: {
                    this.changeAction(6);
                    break;
                }
                case 1: {
                    if (this.nextAttackCount <= 0) break;
                    this.nextAttackCount = 0;
                    if (!this.fireAttackFlag) {
                        this.changeAction(7);
                        break;
                    }
                    this.changeAction(14);
                    break;
                }
                case 2: {
                    if (this.nextAttackCount <= 0) break;
                    this.nextAttackCount = 0;
                    if (!this.fireAttackFlag) {
                        this.changeAction(8);
                        break;
                    }
                    this.changeAction(15);
                    break;
                }
                case 3: {
                    if (this.nextAttackCount <= 0) break;
                    this.nextAttackCount = 0;
                    if (!this.fireAttackFlag) {
                        this.changeAction(9);
                        break;
                    }
                    this.changeAction(16);
                }
            }
        } else if (GameScreen.isPressedSingleKey(256)) {
            if (this.blood - 25 > 0 || this.getDander() - 50 > 0) {
                this.nextAttack = 0;
                this.nextAttackCount = 0;
                this.nextAttackFlag = false;
                this.setNextAction(0);
                this.changeAction(17);
            }
        } else if (GameScreen.isPressedSingleKey(512)) {
            if (this.blood - 25 > 0 || this.getDander() - 50 > 0) {
                this.nextAttack = 0;
                this.nextAttackCount = 0;
                this.nextAttackFlag = false;
                this.setNextAction(26);
                this.changeAction(18);
                this.enableToChangeFlag = false;
                this.setAccleration(2);
                this.setSpeed(0, this.getJumpVy(this.getAcclerration(), 60), 0);
            }
        } else if (GameScreen.isPressedSingleKey(64)) {
            this.changeAction(12);
            this.setDirection(0, true);
            this.enableToChangeFlag = false;
            this.setAccleration(3);
            this.setSpeed(-5, this.getJumpVy(this.getAcclerration(), 50), 0);
        } else if (GameScreen.isPressedSingleKey(128)) {
            this.changeAction(12);
            this.setDirection(1, true);
            this.enableToChangeFlag = false;
            this.setAccleration(3);
            this.setSpeed(5, this.getJumpVy(this.getAcclerration(), 50), 0);
        } else if (GameScreen.isPressedSingleKey(4)) {
            this.runCount = this.faceDir == 1 ? 0 : 5;
        } else if (GameScreen.isPressedSingleKey(8)) {
            this.runCount = this.faceDir == 0 ? 0 : 5;
        }
    }

    private void inputWalk() {
        if (GameScreen.isPressedMultiKey(1)) {
            this.setSpeed(0, 0, -4);
        } else if (GameScreen.isPressedMultiKey(2)) {
            this.setSpeed(0, 0, 4);
        } else if (GameScreen.isPressedMultiKey(4)) {
            this.setSpeed(-4, 0, 0);
            this.setDirection(0, true);
        } else if (GameScreen.isPressedMultiKey(8)) {
            this.setSpeed(4, 0, 0);
            this.setDirection(1, true);
        } else {
            this.changeAction(0);
        }
        if (GameScreen.isPressedSingleKey(16)) {
            this.changeAction(6);
        }
    }

    private void inputRun() {
        if (GameScreen.isPressedMultiKey(1)) {
            this.setSpeed(this.speedX, 0, -3);
            this.setNextAction(10);
        } else if (GameScreen.isPressedMultiKey(2)) {
            this.setSpeed(this.speedX, 0, 3);
            this.setNextAction(10);
        } else if (GameScreen.isPressedSingleKey(16)) {
            this.setSpeed(5, 0, 0);
            this.changeAction(11);
            this.setNextAction(0);
        } else if (GameScreen.isPressedSingleKey(64)) {
            this.changeAction(12);
            this.setNextAction(0);
            this.setDirection(0, true);
            this.enableToChangeFlag = false;
            this.setAccleration(4);
            this.setSpeed(-7, this.getJumpVy(this.getAcclerration(), 40), 0);
        } else if (GameScreen.isPressedSingleKey(128)) {
            this.changeAction(12);
            this.setNextAction(0);
            this.setDirection(1, true);
            this.enableToChangeFlag = false;
            this.setAccleration(4);
            this.setSpeed(7, this.getJumpVy(this.getAcclerration(), 40), 0);
        } else if (GameScreen.isPressedSingleKey(512)) {
            if (this.blood - 25 > 0 || this.getDander() - 50 > 0) {
                this.nextAttack = 0;
                this.nextAttackCount = 0;
                this.nextAttackFlag = false;
                this.setNextAction(26);
                this.changeAction(18);
                this.enableToChangeFlag = false;
                this.setAccleration(2);
                this.setSpeed(4, this.getJumpVy(this.getAcclerration(), 60), 0);
            }
        } else if (GameScreen.isPressedAnykey()) {
            this.setNextAction(0);
            this.changeAction(0);
        } else {
            this.setSpeed(this.speedX, 0, 0);
            this.setNextAction(10);
        }
    }

    public boolean isActionPaused() {
        if (this.hitPauseCount <= 0) {
            this.hitPauseCount = 0;
            return false;
        }
        --this.hitPauseCount;
        --this.frame;
        return true;
    }

    public void update() {
        if (!this.isActionPaused()) {
            if (this.isBeHitted()) {
                this.beHittedEvent();
                this.setBeHittedFlag(false);
            }
            if (this.isHitted()) {
                if (this.actionState == 17) {
                    GameScreen.intiScreenFlash(2);
                }
                if (this.actionState == 18) {
                    GameScreen.intiScreenFlash(1);
                }
                if (this.combo == 0) {
                    ++this.combo;
                    this.continueCount = 30;
                } else if (this.continueCount > 0) {
                    this.comboFlag = true;
                    ++this.combo;
                    this.continueCount = 30;
                }
                this.saveMaxComboNum();
                this.dander += NoteBuy.danderDx;
                if (this.dander >= this.getMaxDander()) {
                    this.dander = this.getMaxDander();
                }
                this.localHitFlag = true;
                this.setHittedFlag(false);
                this.hitPauseCount = 2;
            }
            if (this.nextAttackCount > 0) {
                --this.nextAttackCount;
                if (this.nextAttackCount <= 0) {
                    this.nextAttackCount = 0;
                    this.nextAttack = 0;
                    this.nextAttackFlag = false;
                }
            }
            if (this.runCount > 0) {
                --this.runCount;
                if (this.runCount <= 0) {
                    this.runCount = 0;
                }
            }
            if (this.continueCount > 0) {
                --this.continueCount;
                if (this.continueCount <= 0) {
                    this.comboFlag = false;
                    this.combo = 0;
                    this.continueCount = 0;
                }
            }
            if (this.unbeatCount > 0) {
                --this.unbeatCount;
                if (this.unbeatCount <= 0) {
                    this.unbeatCount = 0;
                }
            }
            this.updateFireAttackCount();
            this.actionUpdate();
        }
        this.effect.move(this.x, this.y, this.z);
    }

    public void draw(Graphics g) {
        if (this.isViewAble()) {
            this.drawShadow(g, 20);
            this.drawFrame(g);
        }
        this.effect.draw(g);
        this.updateFrame();
        switch (this.actionState) {
            case 28: {
                this.drawPower(g);
            }
        }
        if (this.isActionFinish() && this.enableToChangeFlag) {
            if (this.nextAction != 0) {
                this.changeAction(this.nextAction);
                this.setNextAction(0);
            } else {
                this.changeAction(0);
            }
        }
    }

    private void drawPower(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0xFFFF00);
        if (this.powerCount >= 30 && GameScreen.getGameLoopCount() % 3 == 0) {
            g.setColor(0xFF0000);
        }
        g.fillRect(this.x - GameScreen.screenX - 15, this.z + this.y - GameScreen.screenY - this.height - 10, this.powerCount, 1);
    }

    public void actionUpdate() {
        switch (this.actionState) {
            case 0: {
                this.updateStand();
                break;
            }
            case 1: {
                this.updateWalk();
                break;
            }
            case 2: {
                this.updateDead();
                break;
            }
            case 3: {
                this.updateBeFight();
                break;
            }
            case 4: {
                this.updateLostControl();
                break;
            }
            case 21: {
                this.updateLostControl();
                break;
            }
            case 5: {
                this.updateLieDown();
                break;
            }
            case 6: {
                this.updateAttack1();
                break;
            }
            case 7: {
                this.updateAttack2();
                break;
            }
            case 8: {
                this.updateAttack3();
                break;
            }
            case 9: {
                this.updateAttack4();
                break;
            }
            case 10: {
                this.updateRun();
                break;
            }
            case 11: {
                this.updateRunAttack();
                break;
            }
            case 12: {
                this.updateJump();
                break;
            }
            case 13: {
                this.updateJumpAttack();
                break;
            }
            case 14: {
                this.updateSpecialAttack1();
                break;
            }
            case 15: {
                this.updateSpecialAttack2();
                break;
            }
            case 16: {
                this.updateSpecialAttack3();
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                this.updateSpecialAttack5();
                break;
            }
            case 19: {
                this.updatePick();
                break;
            }
            case 26: {
                this.updateFalldown();
                break;
            }
            case 28: {
                this.updatePowerUp();
                break;
            }
            case 29: {
                this.updateBlastWave();
                break;
            }
            case 20: {
                this.updateBorn();
            }
        }
    }

    private void updateStand() {
    }

    private void updateWalk() {
        this.move();
    }

    private void updateDead() {
    }

    private void updateBeFight() {
        --this.holdCount;
        if (this.holdCount <= 0) {
            this.holdCount = 0;
            this.enableToChangeFlag = true;
        }
        int tempDis = 0;
        switch (this.faceDir) {
            case 0: {
                if (this.beHittedPauseCount % 2 == 0) {
                    tempDis = 1;
                    break;
                }
                tempDis = -1;
                break;
            }
            case 1: {
                tempDis = this.beHittedPauseCount % 2 == 0 ? -1 : 1;
            }
        }
        this.x += tempDis;
        --this.beHittedPauseCount;
    }

    private void updateBorn() {
    }

    private void updateLostControl() {
        this.move();
        if (this.y < 0) {
            this.speedY += this.getAcclerration();
        }
        this.setSpeed(this.speedX, this.speedY, this.speedZ);
        switch (this.attackProperty[5]) {
            case 0: {
                if (this.x > Actor.screenRightBoundary) {
                    this.x = Actor.screenRightBoundary;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.x = Actor.screenLeftBoundary;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 1: {
                if (this.x > Actor.screenRightBoundary) {
                    this.x = Actor.screenRightBoundary;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.x = Actor.screenLeftBoundary;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 2: {
                if (this.x > Actor.screenRightBoundary) {
                    this.x = Actor.screenRightBoundary;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.x = Actor.screenLeftBoundary;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 3: {
                if (this.x > Actor.screenRightBoundary) {
                    this.x = Actor.screenRightBoundary;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.x = Actor.screenLeftBoundary;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
                break;
            }
            case 4: {
                if (this.x > Actor.screenRightBoundary) {
                    this.setAccleration(1);
                    this.setDirection(0, false);
                    this.setSpeed(-6, this.getJumpVy(this.getAcclerration(), 5), this.speedZ);
                    this.x = Actor.screenRightBoundary;
                } else if (this.x < Actor.screenLeftBoundary) {
                    this.setAccleration(1);
                    this.setDirection(1, false);
                    this.setSpeed(6, this.getJumpVy(this.getAcclerration(), 5), this.speedZ);
                    this.x = Actor.screenLeftBoundary;
                }
                if (this.y < 0) break;
                this.y = 0;
                this.changeAction(5);
            }
        }
    }

    private void updateLieDown() {
        ++this.y;
        if (this.y >= 0) {
            if (this.blood <= 0) {
                --this.lieDownCount;
                this.setViewAbleFlag(true);
                if (this.lieDownCount % 2 == 0) {
                    this.setViewAbleFlag(false);
                }
                if (this.lieDownCount <= 0) {
                    this.lieDownCount = 0;
                    this.changeAction(2);
                }
            } else {
                this.unbeatCount = this.unbeatMaxTime;
                this.enableToChangeFlag = true;
            }
            this.y = 0;
        }
    }

    private void updateAttack1() {
        if (this.localHitFlag) {
            this.nextAttackFlag = true;
            this.nextAttack = 1;
            this.nextAttackCount = 10;
            this.localHitFlag = false;
        }
    }

    private void updateAttack2() {
        if (this.nextAttackFlag) {
            this.nextAttack = 2;
            this.nextAttackCount = 10;
        }
    }

    private void updateAttack3() {
        if (this.nextAttackFlag) {
            this.nextAttack = 3;
            this.nextAttackCount = 10;
        }
    }

    private void updateAttack4() {
        this.nextAttack = 0;
        this.nextAttackCount = 0;
        this.nextAttackFlag = false;
    }

    private void updateRun() {
        this.move();
    }

    private void updateRunAttack() {
        this.move();
    }

    private void updateJump() {
        this.move();
        this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
        if (this.y >= 0) {
            this.y = 0;
            this.speedY = 0;
            this.changeAction(26);
            this.enableToChangeFlag = true;
        }
    }

    private void updateJumpAttack() {
        this.move();
        this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
        if (this.y >= 0) {
            this.y = 0;
            this.speedY = 0;
            this.changeAction(26);
            this.enableToChangeFlag = true;
        }
    }

    private void updateSpecialAttack1() {
        if (this.nextAttackFlag) {
            this.nextAttack = 2;
            this.nextAttackCount = 10;
        }
    }

    private void updateSpecialAttack2() {
        if (this.nextAttackFlag) {
            this.nextAttack = 3;
            this.nextAttackCount = 10;
        }
    }

    private void updateSpecialAttack3() {
        this.nextAttack = 0;
        this.nextAttackCount = 0;
        this.nextAttackFlag = false;
    }

    private void updateSpecialAttack4() {
    }

    private void updateSpecialAttack5() {
        if (GameScreen.isMovableX(this.x, this.speedX)) {
            this.x += this.speedX;
        }
        if (this.frame >= 8) {
            this.y += this.speedY;
            this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
            if (this.y >= 0) {
                this.y = 0;
                this.speedY = 0;
                this.changeAction(26);
                this.enableToChangeFlag = true;
            }
        }
    }

    private void updateFalldown() {
        this.move();
        this.setSpeed(this.speedX, this.speedY + this.getAcclerration(), this.speedZ);
    }

    private void updatePick() {
    }

    private void updatePowerUp() {
        this.powerCount += 4;
        if (this.powerCount >= 30) {
            this.powerCount = 30;
        }
    }

    private void updateBlastWave() {
        int tempid;
        if (this.frame == this.cartoonList.length - 3 && (tempid = GameScreen.getEnableObject(GameScreen.bullet)) >= 0) {
            GameScreen.bullet[tempid].init(tempid, 0, 0, this.x, this.y, this.z, 1, 0, 0, this.faceDir, 0);
        }
    }

    private void updateSkillCost() {
        if (GameScreen.HONOR_STATE[4] == -1) {
            --GameScreen.useSkillNum;
        }
        int currentDander = this.getDander() - 50 + GameScreen.danderValue;
        this.setDander(currentDander);
        if (currentDander <= 0) {
            this.setBlood(this.getBlood() - (Math.abs(currentDander) >> 1) + GameScreen.reduceDanderValue);
            this.setDander(0);
        }
    }

    public void clearCombo() {
        this.comboFlag = false;
        this.combo = 0;
        this.continueCount = 0;
    }

    public void clearMaxComboNum() {
        this.maxCombo = 0;
    }

    public int getCombo() {
        return this.combo;
    }

    public void saveMaxComboNum() {
        if (this.combo > this.maxCombo) {
            GameScreen.recordMaxValue = this.maxCombo = this.combo;
        }
    }

    public int getMaxComboNum() {
        return this.maxCombo;
    }

    public void setFireAttackFlag(boolean flag) {
        this.fireAttackFlag = flag;
        this.fireAttackCount = 350;
    }

    public boolean isFireAttack() {
        return this.fireAttackFlag;
    }

    public int getFireAttackCount() {
        return this.fireAttackCount;
    }

    private void updateFireAttackCount() {
        if (this.fireAttackCount > 0) {
            --this.fireAttackCount;
            if (this.fireAttackCount <= 0) {
                this.fireAttackCount = 0;
                this.nextAttackCount = 10;
                this.fireAttackFlag = false;
            }
        }
    }

    public boolean enableBeHitted() {
        return this.unbeatCount == 0 && this.actionState != 20 && this.actionState != 2 && this.actionState != 4 && this.actionState != 21 && this.actionState != 5 && this.actionState != 17 && this.actionState != 18;
    }
}

