/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Tools {
    public static final int GROUND_Y = 100;
    public static final String[] MENU_ITEM = new String[]{"\u65b0\u7684\u6e38\u620f", "\u7ee7\u7eed\u6e38\u620f", "\u97f3\u4e50\u8bbe\u7f6e", "\u5e2e\u52a9\u4fe1\u606f", "\u5173\u4e8e\u4fe1\u606f", "\u9000\u51fa\u6e38\u620f"};
    public static final String[] GMENU_ITEM = new String[]{"\u5728\u7ebf\u5546\u5e97", "\u52cb\u7ae0\u6536\u96c6", "\u7ee7\u7eed\u6e38\u620f", "\u67e5\u770b\u4efb\u52a1", "\u64cd\u4f5c\u8bf4\u660e", "\u97f3\u4e50\u5f00\u5173", "\u7ed3\u675f\u6e38\u620f"};
    public static final String GAME_HELP = "\u884c\u8d70\uff1a\u65b9\u5411\u952e\n\u653b\u51fb\uff1a\u4e2d\u95f4\u952e\n\u8df3\u8dc3\uff1a1/3\u952e\n\u8dd1\u52a8\uff1a\u8fde\u63092\u6b21\u65b9\n\u5411\u5de6\u952e\u6216\u65b9\u5411\u53f3\u952e\n\u5200\u6ce2\uff1a\u6309\u4f4f5\u952e\u84c4\u529b\n\u706b\u67f1\uff1a7\u952e\n\u7a7a\u65a9\uff1a9\u952e\n\u83dc\u5355\uff1a\u5de6\u8f6f\u952e\n\u53d6\u6d88\uff1a\u53f3\u8f6f\u952e";
    public static final String GAME_ABOUT = "\u5185\u5bb9\u63d0\u4f9b:\u957f\u6625\u4e09\u8d62\n\u6e38\u620f\u540d\u79f0:\n\u9b54\u517d\u738b\u8bb0-\u672b\u65e5\u4f20\u8bf4\n\u5ba2\u670d\u8054\u7cfb\u4eba:\u767d\u51b0\n\u5ba2\u670d\u7535\u8bdd\uff1a\n0431-87656083\n\u90ae\u7bb1\uff1a\nhrsany@yahoo.com.cn";
    static final int[] SIN_TABLE = new int[]{0, 71, 142, 214, 285, 357, 428, 499, 570, 641, 711, 781, 851, 921, 990, 1060, 1128, 1197, 1265, 1333, 1400, 1468, 1534, 1600, 1665, 1730, 1795, 1859, 1922, 1985, 2048, 2109, 2170, 2230, 2290, 2349, 2407, 2464, 2521, 2577, 2632, 2686, 2740, 2793, 2845, 2896, 2946, 2995, 3043, 3091, 3137, 3183, 3227, 3271, 3313, 3355, 3395, 3434, 3473, 3510, 3547, 3582, 3616, 3649, 3681, 3712, 3741, 3770, 3797, 3823, 3849, 3872, 3895, 3917, 3937, 3956, 3974, 3991, 4006, 4020, 4033, 4045, 4056, 4065, 4073, 4080, 4086, 4090, 4093, 4095, 4096};
    static Random random = new Random();

    public static int getRandom(int n) {
        return (random.nextInt() & Integer.MAX_VALUE) % n;
    }

    public static int getSignRandom(int n) {
        return random.nextInt() % n;
    }

    public static int angleToRadian(int angle) {
        int PI = 12868;
        int radian = angle * PI / 180;
        return radian;
    }

    public static int getSinValue(int radian) {
        int microAngle = 0;
        while (radian < 0) {
            radian += 25736;
        }
        if (radian > 25736) {
            radian %= 25736;
        }
        int angle = radian * 10 / 714;
        if (radian != 0 && radian != 6434 && radian != 12868 && radian != 19302 && radian != 25736) {
            microAngle = radian * 100 / 714 - angle * 10;
        }
        if (angle <= 90) {
            return Tools.lookupSinTable(angle, microAngle);
        }
        if (angle <= 180) {
            return Tools.lookupSinTable(180 - angle, microAngle);
        }
        if (angle <= 270) {
            return -Tools.lookupSinTable(angle - 180, microAngle);
        }
        return -Tools.lookupSinTable(360 - angle, microAngle);
    }

    private static int lookupSinTable(int angle, int microAngle) {
        if (microAngle > 0 && microAngle < 10 && angle < 90) {
            return SIN_TABLE[angle] + (SIN_TABLE[angle + 1] - SIN_TABLE[angle]) / 10 * microAngle;
        }
        return SIN_TABLE[angle];
    }

    public static int getCosValue(int radian) {
        return Tools.getSinValue(radian + 6435);
    }

    Image getConvertImage(String s, int[] oc, int[] nc) {
        try {
            InputStream is = this.getClass().getResourceAsStream(s);
            byte[] pixel = GameScreen.createImage(s);
            this.imgConvert(pixel, oc, nc);
            Image img = Image.createImage((byte[])pixel, (int)0, (int)pixel.length);
            return img;
        }
        catch (Exception e) {
            System.out.println("getColoredImage error " + e);
            return null;
        }
    }

    void imgConvert(byte[] data, int[] oc, int[] nc) {
        try {
            int start = 0;
            int crc = -1;
            for (int idx = 0; idx < data.length; ++idx) {
                if (data[idx] != 80 || data[idx + 1] != 76 || data[idx + 2] != 84 || data[idx + 3] != 69) continue;
                start = idx;
                break;
            }
            int length = (data[start - 4] & 0xFF) << 24 | (data[start - 3] & 0xFF) << 16 | (data[start - 2] & 0xFF) << 8 | data[start - 1] & 0xFF;
            for (int aa = 0; aa < oc.length; ++aa) {
                for (int bb = 0; bb < length / 3; ++bb) {
                    int tt = start + 4 + bb * 3;
                    int r = data[tt] & 0xFF;
                    int g = data[tt + 1] & 0xFF;
                    int b = data[tt + 2] & 0xFF;
                    if (r != (oc[aa] >> 16 & 0xFF) || g != (oc[aa] >> 8 & 0xFF) || b != (oc[aa] & 0xFF)) continue;
                    data[tt] = (byte)(nc[aa] >> 16 & 0xFF);
                    data[tt + 1] = (byte)(nc[aa] >> 8 & 0xFF);
                    data[tt + 2] = (byte)(nc[aa] & 0xFF);
                }
            }
            for (int i = start; i < start + length + 4; ++i) {
                crc = this.pixelConvert(data[i], crc);
            }
            data[start + 4 + length] = (byte)((crc ^= 0xFFFFFFFF) >> 24);
            data[start + 4 + length + 1] = (byte)(crc >> 16);
            data[start + 4 + length + 2] = (byte)(crc >> 8);
            data[start + 4 + length + 3] = (byte)crc;
        }
        catch (Exception e) {
            System.out.println("imgConvert error " + e);
        }
    }

    int pixelConvert(byte pixel, int color) {
        int tmp = pixel & 0xFF;
        color ^= tmp;
        for (int idx = 0; idx < 8; ++idx) {
            if ((color & 1) != 0) {
                color = color >>> 1 ^ 0xEDB88320;
                continue;
            }
            color >>>= 1;
        }
        return color;
    }

    static void drawFrame(Graphics g, short[] data, int px, int py, int trans, Image image) {
        Tools.drawClip(g, data[0], data[1], data[2], data[3], px, py, trans, image);
    }

    static void drawFrameR(Graphics g, short[] data, int px, int py, int trans, Image image) {
        byte[] trans_id = new byte[]{1, 0, 3, 2};
        Tools.drawClip(g, data[0], data[1], data[2], data[3], px, py, trans_id[trans], image);
    }

    static void drawClip(Graphics g, int ix, int iy, int w, int h, int px, int py, int trans, Image image) {
        g.setClip(px, py, w, h);
        switch (trans) {
            case 0: {
                g.drawImage(image, px - ix, py - iy, 20);
                break;
            }
            case 1: {
                g.clipRect(px, py, w, h);
                DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
                dg.drawImage(image, px - (image.getWidth() - ix - w), py - iy, 20, 8192);
                break;
            }
            case 2: {
                DirectGraphics dg1 = DirectUtils.getDirectGraphics((Graphics)g);
                g.clipRect(0, 0, 176, 208);
                dg1.drawImage(image, px - ix, py - (image.getHeight() - iy - h), 20, 16384);
            }
        }
    }

    static final int colorGradualChange(int color1, int color2, int count, int num) {
        if (count == 0) {
            return color1;
        }
        if (count == num) {
            return color2;
        }
        int r = color1 & 0xFF0000;
        int g = color1 & 0xFF00;
        int b = color1 & 0xFF;
        int newR = (((color2 & 0xFF0000) - r) * count / num & 0xFF0000) + r;
        int newG = (((color2 & 0xFF00) - g) * count / num & 0xFF00) + g;
        int newB = ((color2 & 0xFF) - b) * count / num + b;
        return newR | newG | newB;
    }

    static final void drawNumImage(Graphics g, String NUM, int iw, int ih, int x, int y, Image image) {
        int i;
        int LEN = NUM.length();
        byte[] number = new byte[LEN];
        for (i = 0; i < LEN; ++i) {
            number[i] = (byte)Integer.parseInt(NUM.substring(i, i + 1));
        }
        for (i = 0; i <= LEN - 1; ++i) {
            Tools.drawClip(g, number[i] * iw + 0, 0, iw, ih, x + i * iw, y, 0, image);
        }
    }

    static final void drawScore(Graphics g, Image scoreImage, int px, int py, int wid, int hei, int num, int anchor) {
        String temp = "" + num;
        int x = px;
        if (anchor == 1) {
            x = px + wid * temp.length() / 2 - 1 - wid;
        } else if (anchor == 2) {
            x = px + wid * (temp.length() - 1);
        } else if (anchor == 3) {
            x = px;
        }
        do {
            g.setClip(x, py, wid, hei);
            g.drawImage(scoreImage, x - num % 10 * wid, py, 20);
            x -= wid;
        } while ((num /= 10) != 0);
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
    }

    static void DrawString(String pStr, int x, int y, int nColor, int bColor, Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(bColor);
        g.drawString(pStr, x + 1, y, 20);
        g.drawString(pStr, x, y + 1, 20);
        g.drawString(pStr, x - 1, y, 20);
        g.drawString(pStr, x, y - 1, 20);
        if (nColor != 0) {
            g.setColor(nColor);
        } else {
            g.setColor(16310537);
        }
        g.drawString(pStr, x, y, 20);
    }

    static int getImageW(Image im) {
        return im.getWidth();
    }

    static int getImageH(Image im) {
        return im.getHeight();
    }

    static int getFontW(String str) {
        return Font.getFont((int)64, (int)0, (int)8).stringWidth(str);
    }

    public static Image createImage(String name) {
        Image image = null;
        try {
            byte[] data = GameScreen.createImage("/res" + name);
            return Image.createImage((byte[])data, (int)0, (int)data.length);
        }
        catch (Exception e) {
            image = null;
            System.out.println("createImage error = " + e + name);
            e.printStackTrace();
            return image;
        }
    }
}

