/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Trap
extends GameObject {
    int faceDir;
    static final int FACE_LEFT = 0;
    int speedX;
    int speedY;
    int speedZ;
    static final short LANCE = 0;
    static final short ROCK = 1;
    static final short DINGBAN = 2;
    static final short BOX = 3;
    static Image[] trapImage = new Image[4];
    private short[] cartoonList;
    static final short[][][] TRAP_IMAGE_DATA = new short[][][]{new short[][]{{0, 0, 11, 3}, {0, 3, 11, 4}, {2, 7, 7, 29}, {2, 7, 7, 43}, {2, 7, 7, 58}}, new short[][]{{0, 0, 50, 40}, {50, 1, 48, 38}, {98, 0, 50, 37}, {148, 1, 48, 38}}, new short[][]{{0, 0, 47, 92}, {0, 0, 47, 44}}, new short[][]{{0, 0, 32, 26}, {32, 0, 32, 26}, {64, 0, 32, 26}}};
    static final short[][][] TRAP_FRAME_DATA = new short[][][]{new short[][]{{0, 1, -5, -7, 0, 2, -5, -4, 0, 5, -3, -62}, {0, 1, -5, -7, 0, 2, -5, -4, 0, 4, -3, -47}, {0, 1, -5, -7, 0, 2, -5, -4, 0, 3, -3, -33}, {0, 1, -5, -7, 0, 2, -5, -4}}, new short[][]{{1, 1, -25, -40}, {1, 2, -24, -39}, {1, 3, -25, -39}, {1, 4, -24, -39}}, new short[][]{{2, 1, -24, -92, 2, 2, -24, -136, 2, 2, -24, -180, 2, 2, -24, -224}}, new short[][]{{3, 1, -16, -26}, {3, 2, -16, -26}, {3, 3, -16, -26}}};
    static final short[][][] TRAP_CARTOON_DATA = new short[][][]{new short[][]{{0, 0, 1, 1, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 1, 1}}, new short[][]{{0, 1, 2, 3}}, new short[][]{{0}}, new short[][]{{0}, {1}, {2}}};
    static int[][] ATTACK_AREA = new int[][]{{-5, -50, 15, 50}, {-27, -3, 50, 10}, {-13, -20, 25, 10}, {-13, -20, 20, 20}};
    static int[][] ATTACK_PROPERTY = new int[][]{{12, 1, 1, 0}, {12, 1, 1, 0}, {12, 1, 1, 0}, {0, 0, 0, 0}};
    static int[] CollisionFrame = new int[]{3, -1, -1, -1};
    static final short[][] TRAP_POS = new short[][]{new short[0], {100, 0, 120, 3, 0, 1055, 0, 124, 0, 0, 1080, 0, 150, 3, 0, 1120, -200, 150, 1, 0}, {150, 0, 200, 3, 0}, {400, -70, 160, 2, 0, 800, 0, 160, 3, 0}, {500, 0, 140, 0, 1, 500, 0, 170, 3, 0, 700, -200, 150, 1, 1}, {500, 0, 134, 0, 2, 600, 0, 150, 3, 0}, {150, 0, 140, 3, 0}, {150, 0, 140, 3, 0}, {400, 0, 200, 3, 0, 600, -70, 130, 2, 1}, new short[0], new short[0], {700, 0, 134, 0, 3, 900, 0, 200, 3, 0, 1200, 0, 130, 3, 0}, {300, -70, 140, 2, 2, 500, -200, 150, 1, 2, 600, 0, 150, 3, 0}, {1250, 0, 160, 3, 0, 1300, 0, 134, 0, 2}, {1250, 0, 130, 3, 0}, new short[0], {1250, 0, 130, 3, 0}, {100, 0, 100, 3, 0, 150, 0, 100, 3, 0}, {400, 0, 134, 0, 4, 750, 0, 150, 3, 0, 8005, -70, 130, 2, 2}, {800, 0, 130, 3, 0, 1000, -200, 150, 1, 3, 1300, 0, 130, 3, 0}, {150, 0, 130, 3, 0}};
    static final int[][][] TRAP_INFO = new int[][][]{new int[][]{{0, 0, 0, -6, 0, 22, -12, 0, 49, -19, 0, 77}, {0, 0, 0, 41, 0, 27, 0, 0, 52}, {0, 0, 0, 9, 0, 17, 16, 0, 36, 25, 0, 59}, {0, 0, 0, 63, 0, 21, 119, 0, 0, 7, 0, 58, 122, 0, 56}, {0, 0, 0, 10, 0, 20, 20, 0, 40, 35, 0, 62, 85, 0, 0, 95, 0, 20, 105, 0, 40, 120, 0, 62}}, new int[][]{{0, 0, 0, 0, 0, 30}, {0, 0, 0, 0, 0, 40, 100, 0, 20}, {0, 0, 0, 100, 0, -10, 100, 0, 20}, {0, 0, 0, 80, 0, 0}}, new int[][]{{0, 0, 0, 100, 0, -10, 100, 0, 20}, {0, 0, 0, 0, 0, 30, 0, 0, 60, 100, 0, 10, 100, 0, 40}, {0, 0, 0, 0, 0, 50, 150, 0, 0, 150, 0, 50}, {0, 0, 0, 0, 0, 50}}, new int[][]{{0, 0, 0}}};

    public Trap() {
        this.state = -1;
    }

    public void init(int i_id, int t_type, int s_state, int tx, int ty, int tz, int speedy) {
        this.id = i_id;
        this.type = t_type;
        this.state = s_state;
        this.x = tx;
        this.y = ty;
        this.z = tz;
        this.frame = 0;
        this.speedY = speedy;
        this.changeAction(0);
    }

    public void changeAction(int action) {
        this.frame = 0;
        this.state = action;
        if (this.state != -1) {
            this.setCartoonList(TRAP_CARTOON_DATA[this.type][this.state]);
        }
        switch (this.type) {
            case 3: {
                if (this.state != -1) break;
                if (GameScreen.goods == null) break;
                int[] goodID = new int[]{0, 1, 0, 4};
                int temp_id = GameScreen.getEnableObject(GameScreen.goods);
                if (temp_id == -1) break;
                GameScreen.goods[temp_id].init(temp_id, goodID[Tools.getRandom(goodID.length)], 0, this.x, this.y, this.z);
            }
        }
    }

    public void setSpeed(int speed_x, int speed_y, int speed_z) {
        this.speedX = speed_x;
        this.speedY = speed_y;
        this.speedZ = speed_z;
    }

    protected void move() {
        this.y += this.speedY;
        this.x += this.speedX;
        this.z += this.speedZ;
    }

    public void setCartoonList(short[] list) {
        this.cartoonList = list;
    }

    public int getTrans(int value) {
        if (value > 0) {
            return 0;
        }
        if (value < 0) {
            return 1;
        }
        return -1;
    }

    public void update() {
        switch (this.type) {
            case 1: {
                ++this.speedY;
                this.move();
                if (this.y < 0) break;
                GameScreen.initScreenShake(2, 6);
                this.speedY = -this.speedY >> 2;
                if (this.speedY != 0) break;
                this.setEnd();
                break;
            }
            case 2: {
                if (this.y >= 0) {
                    this.speedY = -this.speedY;
                } else if (this.y < -70) {
                    this.speedY = -this.speedY;
                }
                this.move();
            }
        }
    }

    public void draw(Graphics g) {
        if (this.state != -1) {
            if (this.type != 0) {
                this.drawShadow(g);
            }
            this.drawFrame(g);
            this.updateFrame();
        }
    }

    protected void updateFrame() {
        ++this.frame;
        if (this.frame >= this.cartoonList.length) {
            this.frame = 0;
        }
    }

    protected void drawFrame(Graphics g) {
        if (this.frame >= 0) {
            int frameIndex = this.getFrameIndex();
            short[] frameData = this.getFrameData(frameIndex);
            block4: for (int i = 0; i < frameData.length >> 2; ++i) {
                short[] baseData = this.getImageData(frameData[(i << 2) + 1]);
                int transType = this.getTrans(frameData[(i << 2) + 1]);
                Image img = this.getImage(frameData[i << 2]);
                if (img == null) continue;
                switch (this.faceDir) {
                    case 1: {
                        int px = this.x - GameScreen.screenX + frameData[i * 4 + 2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrame(g, baseData, px, py, transType, img);
                        continue block4;
                    }
                    case 0: {
                        int px = this.x - GameScreen.screenX - frameData[i * 4 + 2] - baseData[2];
                        int py = this.z + this.y - GameScreen.screenY + frameData[i * 4 + 3];
                        Tools.drawFrameR(g, baseData, px, py, transType, img);
                    }
                }
            }
        }
    }

    protected void drawShadow(Graphics g) {
        g.setClip(0, 0, GameScreen.screenW, GameScreen.screenH);
        g.setColor(0);
        g.fillArc(this.x - 10 - GameScreen.screenX, this.z - 3 - GameScreen.screenY, 20, 6, 0, 360);
        g.setColor(65535);
    }

    public int getFrameIndex() {
        return this.cartoonList[this.frame];
    }

    public short[] getFrameData(int index) {
        return TRAP_FRAME_DATA[this.type][index];
    }

    public short[] getImageData(int index) {
        return TRAP_IMAGE_DATA[this.type][Math.abs(index) - 1];
    }

    public Image getImage(int id) {
        return trapImage[id];
    }

    public int[] getAttackArea() {
        int[] property = ATTACK_AREA[this.type];
        return new int[]{this.x + property[0], this.z + this.y + property[1], property[2], property[3], this.z};
    }

    public int[] getAttackProperty() {
        int[] property = new int[]{this.x, this.y, this.z, this.faceDir, ATTACK_PROPERTY[this.type][0], ATTACK_PROPERTY[this.type][1], ATTACK_PROPERTY[this.type][2], ATTACK_PROPERTY[this.type][3]};
        return property;
    }

    public void setEnd() {
        this.state = -1;
    }

    public boolean isAlive() {
        return this.state != -1;
    }

    public static void loadRes() throws Exception {
        for (int i = 0; i < trapImage.length; ++i) {
            Trap.trapImage[i] = Tools.createImage("/trap/T" + i + ".png");
        }
    }
}

