/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Vector;

public final class AI {
    public static final short AS_IF = 255;
    public static final short AS_ELSE = 254;
    public static final short AS_ENDIF = 253;
    public static final short AS_BREAK = 252;
    public static final short AS_RANDOM = 251;
    public static final short AS_STOP = 160;
    public static final short AS_WALK = 161;
    public static final short AS_CLOSETO = 162;
    public static final short AS_FARAWAY = 163;
    public static final short AS_ATTACK = 164;
    public static final short AS_SKILL = 165;
    public static final short AS_ESCAPE = 166;
    public static final short AS_WATCH = 167;
    public static final short AS_SETVIEW = 168;
    public static final short AS_SETSTATE = 169;
    public static final short AS_SETAI = 170;
    public static final short AS_WARN = 171;
    public static final short AS_FOLLOW = 172;
    public static final short AS_REBORN = 173;
    public static final short AS_ADDHP = 174;
    public static final short AS_SKILLLONG = 175;
    short[][] AIScript;
    short[] prop;
    static String[] exp;
    static int[] bInt;
    static short[][] array;
    public static final byte TAR_NULL = 0;
    public static final byte TAR_NEAREST = 1;
    public static final byte TAR_FURTHEST = 2;
    public static final byte TAR_WEAKEST = 3;
    public static final byte TAR_STRONGEST = 4;
    public static final byte TAR_MAINROLE = 5;
    public static final byte TAR_SELF = 6;
    public static final byte TAR_DEADHK = 7;
    public static final byte TAR_ADDHP = 8;
    public static final byte con_enemyInView = 0;
    public static final byte con_friendInView = 1;
    public static final byte con_hurtFriend = 2;
    public static final byte con_enemyInReach = 3;
    public static final byte con_friendInArea = 4;
    public static final byte con_enemyInArea = 5;
    public static final byte con_hpLessThan = 6;
    public static final byte con_state = 7;
    public static final byte con_timeMoreThan = 8;
    static Vector objs;
    static final byte CAMP_ALL = 0;
    static final byte CAMP_FRIEND = 1;
    static final byte CAMP_ENEMY = 2;

    static int getInt(short param) {
        return Variable.getInt(param, exp, bInt);
    }

    static boolean getBool(short param) {
        return Variable.getBool(param, exp);
    }

    static String getString(short param) {
        return Variable.getString(param, exp);
    }

    static short[] getArray(short param) {
        return Variable.getArray(param, array);
    }

    static AI[] loadScript(String path) {
        DataInputStream dis = Tools.openFile(path);
        try {
            int i2;
            if (dis == null) {
                dis.close();
                return null;
            }
            int len = dis.readShort();
            AI[] ai = new AI[len];
            for (i2 = 0; i2 < len; ++i2) {
                ai[i2] = new AI();
                int tLen = dis.readShort();
                ai[i2].prop = new short[tLen];
                for (int j2 = 0; j2 < tLen; ++j2) {
                    ai[i2].prop[j2] = dis.readShort();
                }
                int orderLen = dis.readShort();
                ai[i2].AIScript = new short[orderLen][];
                for (int j3 = 0; j3 < orderLen; ++j3) {
                    int pLen = dis.readShort();
                    ai[i2].AIScript[j3] = new short[pLen];
                    ai[i2].AIScript[j3][0] = dis.readShort();
                    for (int k2 = 1; k2 < pLen; ++k2) {
                        ai[i2].AIScript[j3][k2] = dis.readShort();
                    }
                }
            }
            len = dis.readShort();
            exp = new String[len];
            for (i2 = 0; i2 < len; ++i2) {
                short bLen = dis.readShort();
                byte[] buff = new byte[bLen];
                dis.read(buff);
                AI.exp[i2] = new String(buff, "UTF-8");
            }
            len = dis.readShort();
            bInt = new int[len];
            for (i2 = 0; i2 < len; ++i2) {
                AI.bInt[i2] = dis.readInt();
            }
            len = dis.readShort();
            array = new short[len][];
            for (i2 = 0; i2 < len; ++i2) {
                int aLen = dis.readShort();
                AI.array[i2] = new short[aLen];
                for (int j4 = 0; j4 < aLen; ++j4) {
                    AI.array[i2][j4] = dis.readShort();
                }
            }
            for (i2 = 0; i2 < ai.length; ++i2) {
                ai[i2].init();
            }
            dis.close();
            return ai;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    void init() {
    }

    void run(Sprite s2) {
        objs.removeAllElements();
        block7: for (int i2 = 0; i2 < this.AIScript.length; ++i2) {
            short order = this.AIScript[i2][0];
            switch (order) {
                case 255: {
                    if (this.checkCondition(s2, this.AIScript[i2])) continue block7;
                    int endLine = this.getEndIndex(this.AIScript, i2, this.AIScript.length - 1, (short)255, (short)253, 253, 0);
                    int elseLine = this.getEndIndex(this.AIScript, i2, endLine, (short)255, (short)253, 254, -1);
                    if (elseLine != -1) {
                        i2 = elseLine;
                        continue block7;
                    }
                    i2 = endLine;
                    continue block7;
                }
                case 254: {
                    int endLine;
                    i2 = endLine = this.getEndIndex(this.AIScript, i2, this.AIScript.length - 1, (short)255, (short)253, 253, 1);
                    continue block7;
                }
                case 253: {
                    continue block7;
                }
                case 252: {
                    return;
                }
                case 251: {
                    short[] tmp = AI.getArray(this.AIScript[i2][1]);
                    int index = this.getIndex(tmp);
                    i2 += index;
                    continue block7;
                }
                default: {
                    this.parseOrder(s2, order, this.AIScript[i2]);
                    return;
                }
            }
        }
    }

    private int getEndIndex(short[][] script, int startLine, int endLine, short left, short right, int key, int level) {
        for (int i2 = startLine; i2 <= endLine; ++i2) {
            short command = script[i2][0];
            if (command == left) {
                ++level;
            } else if (command == right) {
                --level;
            }
            if (level != 0 || command != key) continue;
            return i2;
        }
        return -1;
    }

    private int getIndex(short[] array) {
        int rnd = Tools.nextInt(0, 99);
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (rnd < array[i2]) {
                return i2;
            }
            rnd -= array[i2];
        }
        return array.length;
    }

    private boolean checkCondition(Sprite s2, short[] script) {
        int condition = AI.getInt(script[1]);
        short[] array = AI.getArray(script[2]);
        switch (condition) {
            case 0: {
                return AI.isExist(s2, s2.alarmW, s2.alarmH, 2, false);
            }
            case 3: {
                return AI.isExist(s2, s2.attW, s2.attH, 2, false);
            }
            case 1: {
                return AI.isExist(s2, s2.alarmW, s2.alarmH, 1, false);
            }
            case 2: {
                return AI.isExist(s2, s2.alarmW, s2.alarmH, 1, true);
            }
            case 5: {
                return AI.isExist(s2, array[0], array[1], 2, false);
            }
            case 4: {
                return AI.isExist(s2, array[0], array[1], 1, false);
            }
            case 7: {
                return s2.curStates == array[0];
            }
            case 6: {
                return s2.hp < s2.hp_max * array[0] / 100;
            }
        }
        return false;
    }

    private void parseOrder(Sprite s2, int order, short[] script) {
        switch (order) {
            case 161: {
                int time2 = AI.getInt(script[1]);
                s2.setOrder(order, null, time2, 0);
                break;
            }
            case 160: {
                int time2 = AI.getInt(script[1]);
                s2.setOrder(order, null, 0, time2);
                break;
            }
            case 165: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time1 = AI.getInt(script[2]);
                int time2 = AI.getInt(script[3]);
                s2.setOrder(order, obj, time2, time1);
                break;
            }
            case 164: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time2 = AI.getInt(script[2]);
                s2.setOrder(order, obj, 0, time2);
                break;
            }
            case 162: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time1 = AI.getInt(script[2]);
                int time2 = AI.getInt(script[3]);
                s2.setOrder(order, obj, time1, time2);
                break;
            }
            case 163: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time1 = AI.getInt(script[2]);
                int time2 = AI.getInt(script[3]);
                s2.setOrder(order, obj, time1, time2);
                break;
            }
            case 172: {
                break;
            }
            case 168: {
                s2.alarmW = s2.alarmH = (short)AI.getInt(script[1]);
                break;
            }
            case 170: {
                s2.aiMode = (byte)AI.getInt(script[1]);
                break;
            }
            case 173: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time2 = AI.getInt(script[2]);
                s2.setOrder(order, obj, 0, time2);
                break;
            }
            case 174: {
                Sprite obj = AI.getSprite(s2, AI.getInt(script[1]));
                int time2 = AI.getInt(script[2]);
                s2.setOrder(order, obj, 0, time2);
                break;
            }
            case 175: {
                int time1 = AI.getInt(script[1]);
                int time2 = AI.getInt(script[2]);
                s2.setOrder(order, null, time1, time2);
                break;
            }
        }
    }

    static boolean isExist(Sprite s2, int w2, int h2, int camp, boolean checkHurt) {
        int i2;
        boolean exist = false;
        for (i2 = 0; i2 < Engine.sprite.length; ++i2) {
            if (Engine.sprite[i2].equals(s2) || Engine.sprite[i2].hp <= 0 || !Engine.sprite[i2].visible || !AI.checkArea(s2, w2, h2, Engine.sprite[i2]) || !AI.checkCamp(s2, Engine.sprite[i2], camp) || checkHurt && !AI.checkHurt(Engine.sprite[i2])) continue;
            exist = true;
            break;
        }
        if (!exist) {
            return false;
        }
        objs.removeAllElements();
        for (i2 = 0; i2 < Engine.sprite.length; ++i2) {
            if (Engine.sprite[i2].equals(s2) || Engine.sprite[i2].hp <= 0 || !Engine.sprite[i2].visible || !AI.checkArea(s2, w2, h2, Engine.sprite[i2]) || !AI.checkCamp(s2, Engine.sprite[i2], camp) || checkHurt && !AI.checkHurt(Engine.sprite[i2])) continue;
            objs.addElement(Engine.sprite[i2]);
        }
        return true;
    }

    static Sprite getSprite(Sprite s2, int limit) {
        switch (limit) {
            case 0: {
                return null;
            }
            case 5: {
                return Engine.sprite[Engine.spriteIndex];
            }
            case 6: {
                return s2;
            }
            case 7: {
                for (int i2 = 1; i2 < Engine.sprite.length; ++i2) {
                    if (Engine.sprite[i2].modle != 3 || Engine.sprite[i2].hp > 0 || Engine.sprite[i2].isBoss) continue;
                    return Engine.sprite[i2];
                }
                return null;
            }
            case 8: {
                for (int i3 = 1; i3 < Engine.sprite.length; ++i3) {
                    if (Engine.sprite[i3].equals(s2) || Engine.sprite[i3].isBoss || Engine.sprite[i3].isBox() || Engine.sprite[i3].hp >= Engine.sprite[i3].hp_max / 2 || Engine.sprite[i3].hp <= 0) continue;
                    return Engine.sprite[i3];
                }
                return null;
            }
        }
        Sprite temp = null;
        int len = objs.size();
        for (int i4 = 0; i4 < len; ++i4) {
            temp = i4 == 0 ? (Sprite)objs.elementAt(0) : AI.getSpecial(s2, temp, (Sprite)objs.elementAt(i4), limit);
        }
        return temp;
    }

    static boolean checkArea(Sprite s1, int w2, int h2, Sprite s2) {
        boolean horizontal = Tools.hit(s1.x - w2, s1.y + h2 / 2, w2 + w2, h2, s2.x - s2.w / 2, s2.y + s2.h / 2, s2.w, s2.h);
        return horizontal;
    }

    static boolean checkAreaXY(Sprite s1, int w2, int h2, int x2, int y2) {
        boolean horizontal = Tools.hit(s1.x - w2, s1.y + h2 / 2, w2 + w2, h2, x2 - 8, y2 + 8, 16, 16);
        return horizontal;
    }

    static boolean checkCamp(Sprite s1, Sprite s2, int camp) {
        if (s2.camp == 0) {
            return false;
        }
        switch (camp) {
            case 0: {
                return true;
            }
            case 1: {
                return s1.camp == s2.camp;
            }
            case 2: {
                return s1.camp != s2.camp;
            }
        }
        return false;
    }

    static boolean checkHurt(Sprite s2) {
        return s2.hp < s2.hp_max;
    }

    static Sprite getSpecial(Sprite s2, Sprite s1, Sprite s22, int targetType) {
        switch (targetType) {
            case 3: {
                return s1.hp * 100 / s1.hp_max >= s22.hp * 100 / s22.hp_max ? s1 : s22;
            }
            case 4: {
                return s1.hp * 100 / s1.hp_max <= s22.hp * 100 / s22.hp_max ? s1 : s22;
            }
            case 1: {
                return Math.abs(s1.x - s2.x) + Math.abs(s1.y - s2.y) <= Math.abs(s22.x - s2.x) + Math.abs(s22.y - s2.y) ? s1 : s22;
            }
            case 2: {
                return Math.abs(s1.x - s2.x) + Math.abs(s1.y - s2.y) >= Math.abs(s22.x - s2.x) + Math.abs(s22.y - s2.y) ? s1 : s22;
            }
        }
        return null;
    }

    static {
        objs = new Vector();
    }
}

