/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Tools {
    static final short GRUOP_MAX = 1000;
    static int mapGroup;
    private static Image[][] imgGroup;
    private static Image[][] imgSprite;
    static final short SPRITE_IMAGE_MAX = 10;
    public static final String[] dirNames;
    public static final byte D_BATTLE = 0;
    public static final byte D_BG = 1;
    public static final byte D_DECK = 2;
    public static final byte D_EFFECT = 3;
    public static final byte D_FIGHTER = 4;
    public static final byte D_HEAD = 5;
    public static final byte D_LOAD = 6;
    public static final byte D_MORE = 7;
    public static final byte D_OPEN = 8;
    public static final byte D_OTHER = 9;
    public static final byte D_SPRITE = 10;
    public static final byte D_UI = 11;
    public static final byte D_SHOT = 12;
    public static final byte D_FACE = 13;
    public static final byte D_CHOOSE = 14;
    public static final byte D_RANK = 15;
    public static final byte D_PUBLIC = 16;
    public static final byte D_DEAD = 17;
    private static final int MAX_MAP = 5;
    private static int[] anthors;
    public static final byte LEFT_TOP = 0;
    public static final byte LEFT_VCENTER = 1;
    public static final byte LEFT_BOTTOM = 2;
    public static final byte HCENTER_TOP = 3;
    public static final byte HCENTER_VCENTER = 4;
    public static final byte HCENTER_BOTTOM = 5;
    public static final byte RIGHT_TOP = 6;
    public static final byte RIGHT_VCENTER = 7;
    public static final byte RIGHT_BOTTOM = 8;
    public static final byte TRANS_NONE = 0;
    public static final byte TRANS_HORIZONTAL = 1;
    public static final byte TRANS_VERTICAL = 2;
    public static final byte TRANS_CENTER = 3;
    public static final byte TRANS_ROTATE = 4;
    public static final byte TRANS_ROTATE_H = 5;
    public static final byte TRANS_ROTATE_C = 6;
    public static final byte TRANS_ROTATE_V = 7;
    static int clipNum;
    static int frameNum;
    static int numNum;
    static byte[] wave;
    public static final byte TYPE_ROUND_RECT = 0;
    public static final byte TYPE_RECT = 1;
    public static final byte TYPE_ARC = 2;
    public static final byte TYPE_LINE = 3;
    public static final byte TYPE_STRING = 4;
    public static final byte TYPE_IMG = 5;
    public static final byte TYPE_NUM = 6;
    public static final byte TYPE_PANE = 7;
    public static final byte TYPE_FRAME = 8;
    public static final byte TYPE_COL_STRING = 9;
    public static final byte TYPE_CHARS = 10;
    public static final byte TYPE_SPFRAME = 11;
    public static final byte TYPE_MASK = 12;
    public static final byte TYPE_TRIANGLE = 13;
    public static final byte TYPE_CLIP = 99;
    private static final int MAX = 400;
    private static int curIndex;
    static short max_obj;
    static short[] drawObj;
    private static short[] clipX;
    private static short[] clipY;
    private static short[] clipW;
    private static short[] clipH;
    private static short[] x;
    private static short[] y;
    static short[] drawLevel;
    private static int[] imgIndex;
    private static byte[] anchor;
    private static byte[] trans;
    private static String[] str;
    private static byte[] type;
    private static Vector arrayV;
    public static final byte ISFILL = 99;
    public static final byte TILE_PASS = 15;
    public static final byte TILE_TOP = 14;
    public static final byte TILE_DECK = 13;
    public static final byte TILE_LB_PASS_LR = 12;
    public static final byte TILE_LB_PASS_T = 11;
    public static final byte TILE_LB_PASS_B = 10;
    public static final byte TILE_RT_PASS_LR = 9;
    public static final byte TILE_RT_PASS_T = 8;
    public static final byte TILE_RT_PASS_B = 7;
    public static final byte TILE_RB_PASS_LR = 6;
    public static final byte TILE_RB_PASS_T = 5;
    public static final byte TILE_RB_PASS_B = 4;
    public static final byte TILE_NULL = 3;
    public static final byte TILE_LD_REBOUND = 2;
    public static final byte TILE_HIT = 1;
    public static final byte TILE_EMPTY = 0;
    public static final byte MOTION_ID = 0;
    public static final byte MOTION_TRANS = 1;
    public static final byte MOTION_DELAY = 2;
    public static final byte MOTION_OFF_LEFT = 3;
    public static final byte MOTION_OFF_RIGHT = 4;
    public static final byte MOTION_OFF_TOP = 5;
    public static final byte MOTION_OFF_BOTTOM = 6;
    static Random rnd;
    static int maxNum;

    public static DataInputStream openFile(String filePath) {
        InputStream is = "".getClass().getResourceAsStream(filePath);
        if (is == null) {
            return null;
        }
        return new DataInputStream(is);
    }

    public static int getColor(char c2) {
        switch (c2) {
            case 'A': {
                return 0xFFFFFF;
            }
            case 'B': {
                return 0xFF0000;
            }
            case 'C': {
                return 16740120;
            }
            case 'G': {
                return 65280;
            }
            case 'W': {
                return 15132922;
            }
            case 'Y': {
                return 16179357;
            }
        }
        return 7208956;
    }

    private static Image getImage(int index) {
        int group = index / 1000;
        int i2 = index % 1000;
        if (group == 10) {
            int p1 = i2 / 10;
            int p2 = i2 % 10;
            return imgSprite[p1][p2];
        }
        return Tools.getImage(group, i2);
    }

    public static Image getImage(int group, int index) {
        if (imgGroup[group] == null || imgGroup[group][index] == null) {
            return null;
        }
        return imgGroup[group][index];
    }

    private static void drawFrame(Graphics g2, int imgIndex, byte[][] frameData, byte[][] imgData, int x2, int y2, int index, int trans) {
        byte[] data = frameData[index];
        int h2 = Tools.bToi(data[2]) << 8 | Tools.bToi(data[3]);
        clipNum = 0;
        for (int i2 = 4; i2 < data.length; i2 += 5) {
            int[] cilp = Tools.changeClipData(imgData[data[i2]]);
            int clipX = cilp[0];
            int clipY = cilp[1];
            int clipW = cilp[2];
            int clipH = cilp[3];
            int offX = Tools.bToi(data[i2 + (trans % 2 == 1 ? 3 : 1)]);
            int offY = trans / 2 == 0 ? Tools.bToi(data[i2 + 2]) : h2 - Tools.bToi(data[i2 + 2]) - clipH;
            ++clipNum;
            Tools.drawClipImage(g2, imgIndex, x2 + offX, y2 + offY, clipX, clipY, clipW, clipH, (byte)0, trans ^ data[i2 + 4]);
        }
        maxNum += clipNum;
        frameNum += clipNum;
    }

    private static void drawSpFrame(Graphics g2, int x2, int y2, int index, boolean isMirror, int imgIndex, byte[][][] imgData, byte[][][] subFrameData, byte[][] frameData) {
        byte[] data = frameData[index];
        for (int i2 = 4; i2 < data.length; i2 += 6) {
            int offX = Tools.bToi(data[i2 + (isMirror ? 4 : 2)]);
            int offY = Tools.bToi(data[i2 + 3]);
            byte id = data[i2];
            int trans = isMirror ? data[i2 + 5] ^ 1 : data[i2 + 5];
            int imgID = 10000 + imgIndex * 10 + id;
            Tools.drawFrame(g2, imgID, subFrameData[id], imgData[id], x2 + offX, y2 + offY, data[i2 + 1], trans);
        }
    }

    static void loadSpriteImg(String[] sprite) {
        DataInputStream is = Tools.openFile("/images/spritePng.pak");
        try {
            PackageHead ph = Data.openPack(is);
            if (imgSprite == null) {
                int len = Data.getPackLen(ph.fileNames);
                imgSprite = new Image[len][];
            }
            int[] oIndex = Data.strOrder(ph.fileNames, sprite);
            int skip = 0;
            for (int i2 = 0; i2 < oIndex.length; ++i2) {
                int index = oIndex[i2];
                int pos = Integer.parseInt(ph.fileNames[index]);
                int offset = index == 0 ? 0 : ph.fileOffsets[index - 1];
                is.skip(offset - skip);
                PackageHead ph1 = Data.openPack(is);
                int len1 = ph1.number;
                Tools.imgSprite[pos] = new Image[len1];
                for (int j2 = 0; j2 < len1; ++j2) {
                    int offset1 = j2 == 0 ? 0 : ph1.fileOffsets[j2 - 1];
                    int len = ph1.fileOffsets[j2] - offset1;
                    byte[] imgData = new byte[len];
                    is.read(imgData);
                    Image img = Image.createImage((byte[])imgData, (int)0, (int)len);
                    int imgIndex = Integer.parseInt(ph1.fileNames[j2]);
                    Tools.imgSprite[pos][imgIndex] = img;
                }
                ph1 = null;
                skip = ph.fileOffsets[index];
                System.out.println("oIndex[" + i2 + "]:: " + oIndex[i2]);
            }
            is.close();
            ph = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void loadImages(int dir) {
        DataInputStream dis = Tools.openFile("/images/" + dirNames[dir] + ".pak");
        try {
            PackageHead ph = Data.openPack(dis);
            if (imgGroup[dir] == null) {
                int max = Data.getPackLen(ph.fileNames);
                Tools.imgGroup[dir] = new Image[max];
            }
            for (int i2 = 0; i2 < ph.fileNames.length; ++i2) {
                int offset = i2 == 0 ? 0 : ph.fileOffsets[i2 - 1];
                int len = ph.fileOffsets[i2] - offset;
                byte[] imgData = new byte[len];
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)len);
                int imgIndex = Integer.parseInt(ph.fileNames[i2]);
                Tools.imgGroup[dir][imgIndex] = img;
            }
            dis.close();
            ph = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean loadImages(int dir, String[] names) {
        DataInputStream dis = Tools.openFile("/images/" + dirNames[dir] + ".pak");
        if (dis == null) {
            return false;
        }
        try {
            int[] oIndex;
            PackageHead ph = Data.openPack(dis);
            if (imgGroup[dir] == null) {
                int max = Data.getPackLen(ph.fileNames);
                Tools.imgGroup[dir] = new Image[max];
            }
            if ((oIndex = Data.strOrder(ph.fileNames, names)).length == 0) {
                return false;
            }
            int skip = 0;
            for (int i2 = 0; i2 < oIndex.length; ++i2) {
                int index = oIndex[i2];
                int offset = index == 0 ? 0 : ph.fileOffsets[index - 1];
                int len = ph.fileOffsets[index] - offset;
                byte[] imgData = new byte[len];
                dis.skip(offset - skip);
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                int imgIndex = Integer.parseInt(ph.fileNames[index]);
                Tools.imgGroup[dir][imgIndex] = img;
                System.out.println("dir  " + dir + "imgIndex  " + imgIndex);
                skip = ph.fileOffsets[index];
            }
            dis.close();
            ph = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    public static Image createImage(String path) {
        try {
            return Image.createImage((String)path);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static void removeImage(int group, int index) {
        if (group >= imgGroup.length || index >= imgGroup[group].length) {
            System.out.println("removeImage error!");
            return;
        }
        Tools.imgGroup[group][index] = null;
    }

    public static void removeSpriteGroup(int group) {
        Tools.imgGroup[group] = null;
        if (imgSprite != null) {
            for (int i2 = 0; i2 < imgSprite.length; ++i2) {
                Tools.imgSprite[i2] = null;
            }
        }
    }

    public static void removeImageGroup(int group) {
        Tools.imgGroup[group] = null;
    }

    public static void removeAllImage() {
        for (int i2 = 0; i2 < imgGroup.length; ++i2) {
            Tools.imgGroup[i2] = null;
        }
    }

    public static void removeSpriteImage() {
        if (imgSprite == null) {
            return;
        }
        for (int i2 = 0; i2 < imgSprite.length; ++i2) {
            Tools.imgSprite[i2] = null;
        }
    }

    public static void addClip(int x2, int y2, int w2, int h2, int drawLevel) {
        Tools.setDrawData((byte)99, x2, y2, 0, 0, w2, h2, drawLevel, 0, (byte)0, 0, null);
    }

    public static void addString(String str1, int x2, int y2, byte anchor, int color, int drawLevel) {
        Tools.setDrawData((byte)4, x2, y2, 0, 0, 0, 0, drawLevel, color, anchor, 0, str1);
    }

    public static void addChars(char[][] chars, int x2, int y2, int offX, int offY, int max, byte anchor, int drawLevel) {
        int cIndex = Tools.addObject(chars);
        Tools.setDrawData((byte)10, x2, y2, 0, chars[0].length, offX, offY, drawLevel, cIndex, anchor, max, null);
    }

    public static void addChars(char[][] chars, int x2, int y2, int offX, int offY, int start, int end, int max, byte anchor, int drawLevel) {
        int cIndex = Tools.addObject(chars);
        Tools.setDrawData((byte)10, x2, y2, start, end, offX, offY, drawLevel, cIndex, anchor, max, null);
    }

    public static void addMask(int x2, int y2, int maskWidth, int maskHeight, int alpha, int drawLevel) {
        Tools.setDrawData((byte)12, x2, y2, 0, 0, maskWidth, maskHeight, drawLevel, alpha, (byte)0, 0, null);
    }

    public static void addARC(int x2, int y2, int w2, int h2, int rw, int rh, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x2, y2, w2, h2, anchor)) {
            Tools.setDrawData((byte)2, x2, y2, rw, rh, w2, h2, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addRoundRect(int x2, int y2, int w2, int h2, int rw, int rh, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x2, y2, w2, h2, anchor)) {
            Tools.setDrawData((byte)0, x2, y2, rw, rh, w2, h2, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addNum(int num, int path, int imgIndex, int x2, int y2, int length, int space, byte anchor, int drawLevel) {
        int index = path * 1000 + imgIndex;
        Tools.setDrawData((byte)6, x2, y2, index, 0, space, length, drawLevel, num, anchor, 0, null);
    }

    public static void addPane(int path, int imgIndex, int x2, int y2, int w2, int h2, boolean isFill, int drawLevel) {
        int index = path * 1000 + imgIndex;
        Tools.setDrawData((byte)7, x2, y2, 0, 0, w2, h2, drawLevel, index, (byte)0, Tools.getIsFill(isFill), null);
    }

    public static void addFrame(int path, int imgIndex, byte[][] frameData, byte[][] imgData, int x2, int y2, int frameindex, int trans, byte anchor, int drawLevel) {
        int index = path * 1000 + imgIndex;
        int frame = Tools.addObject(frameData);
        int clip = Tools.addObject(imgData);
        Tools.setDrawData((byte)8, x2, y2, frame, clip, frameindex, 0, drawLevel, index, anchor, trans, null);
    }

    public static void addSpFrame(int imgIndex, byte[][][] imgData, byte[][][] frameData, byte[][] exFrameData, int x2, int y2, int frameIndex, byte isMirror, byte anchor, int drawLevel) {
        int clip = Tools.addObject(imgData);
        int frame = Tools.addObject(frameData);
        int exframe = Tools.addObject(exFrameData);
        Tools.setDrawData((byte)11, x2, y2, clip, frame, exframe, frameIndex, drawLevel, imgIndex, anchor, isMirror, null);
    }

    private static byte getIsFill(boolean isFill) {
        return isFill ? (byte)99 : -1;
    }

    public static void addLine(int x2, int y2, int w2, int h2, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x2, y2, w2, h2, anchor)) {
            Tools.setDrawData((byte)3, x2, y2, 0, 0, w2, h2, drawLevel, color, anchor, 0, null);
        }
    }

    public static void addRect(int x2, int y2, int w2, int h2, boolean isFill, byte anchor, int color, int drawLevel) {
        if (Tools.isDraw(x2, y2, w2, h2, anchor)) {
            Tools.setDrawData((byte)1, x2, y2, 0, 0, w2, h2, drawLevel, color, anchor, Tools.getIsFill(isFill), null);
        }
    }

    public static void addTriangle(int x2, int y2, int x1, int y1, int x22, int y22, int color, int drawLevel) {
        Tools.setDrawData((byte)13, x2, y2, x1, y1, x22, y22, drawLevel, color, (byte)0, Tools.getIsFill(true), null);
    }

    public static void addColorString(String str, int x2, int y2, byte anchor, int rgbRound, int rgb, int drawLevel) {
        short rgbRound1 = (short)(rgbRound >> 16 & 0xFFFF);
        short rgbRound2 = (short)(rgbRound & 0xFFFF);
        Tools.setDrawData((byte)9, x2, y2, rgbRound1, rgbRound2, 0, 0, drawLevel, rgb, anchor, 0, str);
    }

    public static void addImage(int path, int imgIndex, int x2, int y2, byte anchor, byte trans, int drawLevel) {
        int ch;
        int index = path * 1000 + imgIndex;
        int cw = Tools.getImage(index).getWidth();
        if (Tools.isDraw(x2, y2, cw, ch = Tools.getImage(index).getHeight(), anchor)) {
            Tools.setDrawData((byte)5, x2, y2, 0, 0, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x2, int y2, int clipX, int clipY, int clipW, int clipH, byte anchor, byte trans, int drawLevel) {
        int index = path * 1000 + imgIndex;
        int cw = clipW;
        int ch = clipH;
        if (Tools.isDraw(x2, y2, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x2, y2, clipX, clipY, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x2, int y2, byte[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 1000 + imgIndex;
        int[] clip = Tools.changeClipData(clipRect);
        int cx = clip[0];
        int cy = clip[1];
        int cw = clip[2];
        int ch = clip[3];
        if (Tools.isDraw(x2, y2, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x2, y2, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x2, int y2, short[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 1000 + imgIndex;
        short cx = clipRect[0];
        short cy = clipRect[1];
        short cw = clipRect[2];
        short ch = clipRect[3];
        if (Tools.isDraw(x2, y2, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x2, y2, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addImage(int path, int imgIndex, int x2, int y2, int[] clipRect, byte anchor, byte trans, int drawLevel) {
        int index = path * 1000 + imgIndex;
        int cx = clipRect[0];
        int cy = clipRect[1];
        int cw = clipRect[2];
        int ch = clipRect[3];
        if (Tools.isDraw(x2, y2, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x2, y2, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void addGridImage(int path, int imgIndex, int x2, int y2, int allCol, int allRow, int col, int row, byte anchor, byte trans, int drawLevel) {
        int index = path * 1000 + imgIndex;
        int tempW = Tools.getImage(index).getWidth();
        int tempH = Tools.getImage(index).getHeight();
        int cw = tempW / allCol;
        int ch = tempH / allRow;
        int cx = cw * col;
        int cy = ch * row;
        if (Tools.isDraw(x2, y2, cw, ch, anchor)) {
            Tools.setDrawData((byte)5, x2, y2, cx, cy, cw, ch, drawLevel, index, anchor, trans, null);
        }
    }

    public static void drawWaveNum(int num, int imgDir, int imgid, int x2, int y2, int cilpW, int cilpH, int space, int waveInterval, int drawlever, int index) {
        int number = num;
        int seat = Tools.getDigitCounter(number) - 1;
        int totalSeat = Tools.getDigitCounter(number) - 1;
        int step = 0;
        while (seat >= 0) {
            byte addy = wave[Math.min(Math.max(index - (totalSeat - seat) * waveInterval, 0), wave.length - 1)];
            Tools.addImage(imgDir, imgid, x2 + step, y2 + addy, number / Tools.square(10, seat) * cilpW, 0, cilpW, cilpH, (byte)2, (byte)0, drawlever);
            number %= Tools.square(10, seat);
            --seat;
            step += cilpW + space;
        }
        ++index;
    }

    public static void drawClipImage(Graphics g2, int index, int x2, int y2, int clipX, int clipY, int clipW, int clipH, byte anchor, int trans) {
        Image img = Tools.getImage(index);
        if (img == null) {
            return;
        }
        int mode = 0;
        switch (trans) {
            case 1: {
                mode = 2;
                break;
            }
            case 2: {
                mode = 1;
                break;
            }
            case 3: {
                mode = 3;
                break;
            }
            case 4: {
                mode = 5;
                break;
            }
            case 5: {
                mode = 4;
                break;
            }
            case 6: {
                mode = 6;
                break;
            }
            case 7: {
                mode = 7;
            }
        }
        if (clipW <= 0 || clipH <= 0 || clipX < 0 || clipY < 0) {
            return;
        }
        if (clipX + clipW > img.getWidth()) {
            clipW = img.getWidth() - clipX;
        }
        if (clipY + clipH > img.getHeight()) {
            clipH = img.getHeight() - clipY;
        }
        g2.drawRegion(img, clipX, clipY, clipW, clipH, mode, x2, y2, anthors[anchor]);
    }

    public static void drawColorString(Graphics g2, String string, int x2, int y2, byte anchor, int color) {
        switch (anchor) {
            case 1: {
                y2 += GCanvas.strHeight / 2;
                anchor = (byte)2;
                break;
            }
            case 4: {
                y2 -= GCanvas.strHeight / 2;
                x2 -= GCanvas.strWidth * string.length() / 2;
                anchor = 0;
                break;
            }
            case 7: {
                y2 += GCanvas.strHeight / 2;
                anchor = (byte)8;
            }
        }
        g2.setColor(color);
        g2.drawString(string, x2, y2, anthors[anchor]);
    }

    public static final boolean isDraw(int dx, int dy, int dw, int dh, byte anchor) {
        switch (anchor) {
            case 0: {
                if (dx - Map.setOffX > -dw && dx - Map.setOffX < 240 || dy - Map.setOffY <= -dh || dy - Map.setOffY >= 320) break;
                return false;
            }
            case 2: {
                if (dx - Map.setOffX > -dw && dx - Map.setOffX < 240 || dy - Map.setOffY <= 0 || dy - Map.setOffY >= 320 + dh) break;
                return false;
            }
            case 6: {
                if (dx - Map.setOffX > 0 && dx - Map.setOffX < 240 + dw || dy - Map.setOffY <= -dh || dy - Map.setOffY >= 320) break;
                return false;
            }
            case 8: {
                if (dx - Map.setOffX > 0 && dx - Map.setOffX < 240 + dw || dy - Map.setOffY <= 0 || dy - Map.setOffY >= 320 + dh) break;
                return false;
            }
            case 1: {
                if (dx - Map.setOffX > -dw && dx - Map.setOffX < 240 || dy - Map.setOffY <= -dh / 2 || dy - Map.setOffY >= 320 + dh / 2) break;
                return false;
            }
            case 7: {
                if (dx - Map.setOffX > 0 && dx - Map.setOffX < 240 + dw || dy - Map.setOffY <= -dh / 2 || dy - Map.setOffY >= 320 + dh / 2) break;
                return false;
            }
            case 3: {
                if (dx - Map.setOffX > -dw / 2 && dx - Map.setOffX < 240 + dw / 2 || dy - Map.setOffY <= -dh || dy - Map.setOffY >= 320) break;
                return false;
            }
            case 5: {
                if (dx - Map.setOffX > -dw / 2 && dx - Map.setOffX < 240 + dw / 2 || dy - Map.setOffY <= 0 || dy - Map.setOffY >= 320 + dh) break;
                return false;
            }
            case 4: {
                if (dx - Map.setOffX > -dw / 2 && dx - Map.setOffX < 240 + dw / 2 || dy - Map.setOffY <= -dh / 2 || dy - Map.setOffY >= 320 + dh / 2) break;
                return false;
            }
        }
        return true;
    }

    private static void setIndex() {
        short s2 = max_obj;
        max_obj = (short)(s2 + 1);
        Tools.drawObj[s2] = (short)curIndex;
        if (++curIndex == 400) {
            curIndex = 0;
        }
    }

    private static int addObject(Object obj) {
        arrayV.addElement(obj);
        return arrayV.size() - 1;
    }

    private static void setDrawData(byte type, int x2, int y2, int cx, int cy, int cw, int ch, int drawLevel, int imgIndex, byte anchor, int trans, String str) {
        Tools.type[Tools.curIndex] = type;
        Tools.clipX[Tools.curIndex] = (short)cx;
        Tools.clipY[Tools.curIndex] = (short)cy;
        Tools.clipW[Tools.curIndex] = (short)cw;
        Tools.clipH[Tools.curIndex] = (short)ch;
        Tools.x[Tools.curIndex] = (short)x2;
        Tools.y[Tools.curIndex] = (short)y2;
        Tools.drawLevel[Tools.curIndex] = (short)drawLevel;
        Tools.imgIndex[Tools.curIndex] = imgIndex;
        Tools.anchor[Tools.curIndex] = anchor;
        Tools.trans[Tools.curIndex] = (byte)trans;
        Tools.str[Tools.curIndex] = str;
        Tools.setIndex();
    }

    public static void drawMe(Graphics g2, int index) {
        int endx = x[index] - Map.setOffX;
        int endy = y[index] - Map.setOffY;
        switch (type[index]) {
            case 2: {
                int y2 = endy;
                short rw = clipX[index];
                short rh = clipY[index];
                short w2 = clipW[index];
                short h2 = clipH[index];
                if (anchor[index] != 0) {
                    y2 = endy - h2;
                }
                g2.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    g2.fillArc(endx, y2, (int)w2, (int)h2, (int)rw, (int)rh);
                    break;
                }
                g2.drawArc(endx, y2, (int)w2, (int)h2, (int)rw, (int)rh);
                break;
            }
            case 5: {
                Tools.drawClipImage(g2, imgIndex[index], endx, endy, clipX[index], clipY[index], clipW[index], clipH[index], anchor[index], trans[index]);
                break;
            }
            case 13: {
                int y2 = endy;
                short rw = clipX[index];
                short rh = clipY[index];
                short w2 = clipW[index];
                short h2 = clipH[index];
                g2.setColor(imgIndex[index]);
                g2.fillTriangle(endx, y2, (int)rw, (int)rh, (int)w2, (int)h2);
                break;
            }
            case 1: {
                int y2 = endy;
                short w2 = clipW[index];
                short h2 = clipH[index];
                if (anchor[index] == 2) {
                    y2 = endy - h2;
                }
                g2.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    g2.fillRect(endx, y2, (int)w2, (int)h2);
                    break;
                }
                g2.drawRect(endx, y2, (int)w2, (int)h2);
                break;
            }
            case 0: {
                int y2 = endy;
                short rw = clipX[index];
                short rh = clipY[index];
                short w2 = clipW[index];
                short h2 = clipH[index];
                if (anchor[index] == 2) {
                    y2 = endy - h2;
                }
                g2.setColor(imgIndex[index]);
                if (trans[index] == 99) {
                    g2.fillRoundRect(endx, y2, (int)w2, (int)h2, (int)rw, (int)rh);
                    break;
                }
                g2.drawRoundRect(endx, y2, (int)w2, (int)h2, (int)rw, (int)rh);
                break;
            }
            case 4: {
                Tools.drawColorString(g2, str[index], endx, endy, anchor[index], imgIndex[index]);
                Tools.str[index] = null;
                break;
            }
            case 6: {
                int number = imgIndex[index];
                short img = clipX[index];
                short spacing = clipW[index];
                short count = clipH[index];
                Tools.drawNum(g2, number, img, endx, endy, spacing, count, anchor[index]);
                break;
            }
            case 7: {
                Tools.drawPane(g2, imgIndex[index], endx, endy, clipW[index], clipH[index], trans[index] == 99);
                break;
            }
            case 8: {
                byte[][] frameDat = (byte[][])arrayV.elementAt(clipX[index]);
                byte[][] clipDat = (byte[][])arrayV.elementAt(clipY[index]);
                short frameindex = clipW[index];
                byte tran = trans[index];
                short[] size = Tools.getFrameSize(frameDat[frameindex]);
                short offX = 0;
                int offY = 0;
                switch (anchor[index]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        offY = size[1] / 2;
                        break;
                    }
                    case 2: {
                        offY = size[1];
                        break;
                    }
                    case 6: {
                        offX = size[0];
                        break;
                    }
                    case 7: {
                        offX = size[0];
                        offY = size[1] / 2;
                        break;
                    }
                    case 8: {
                        offX = size[0];
                        offY = size[1];
                    }
                }
                Tools.drawFrame(g2, imgIndex[index], frameDat, clipDat, endx - offX, endy - offY, frameindex, tran);
                break;
            }
            case 9: {
                int sx = endx;
                int sy = endy + (anchor[index] == 4 ? GCanvas.strHeight / 2 : 0);
                int rgb = clipX[index] << 16 | clipY[index];
                Tools.drawColorString(g2, str[index], sx, sy + 1, anchor[index], rgb);
                Tools.drawColorString(g2, str[index], sx, sy, anchor[index], imgIndex[index]);
                Tools.str[index] = null;
                break;
            }
            case 10: {
                char[][] chars = (char[][])arrayV.elementAt(imgIndex[index]);
                int charAnchor = anthors[anchor[index]];
                short offX = clipW[index];
                short offY = clipH[index];
                int start = clipX[index];
                short end = clipY[index];
                byte max = trans[index];
                int len = chars[0].length;
                int charW = Math.min(len, max) * offX - (offX - GCanvas.strWidth);
                int sx = endx;
                if (Tools.checkAnthor(charAnchor, 1)) {
                    sx -= charW / 2;
                }
                for (int i2 = start; i2 < end; ++i2) {
                    g2.setColor(Tools.getColor(chars[1][i2]));
                    g2.drawChar(chars[0][i2], sx + (i2 - start) % max * offX, endy + (i2 - start) / max * offY, 0x10 | 4);
                }
                break;
            }
            case 11: {
                byte[][][] clipDats = (byte[][][])arrayV.elementAt(clipX[index]);
                byte[][][] frameDats = (byte[][][])arrayV.elementAt(clipY[index]);
                byte[][] exframeDat = (byte[][])arrayV.elementAt(clipW[index]);
                short frameindex = clipH[index];
                boolean isMirror = trans[index] == 1;
                short[] size = Tools.getFrameSize(exframeDat[frameindex]);
                short offX = 0;
                int offY = 0;
                switch (anchor[index]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        offY = size[1] / 2;
                        break;
                    }
                    case 2: {
                        offY = size[1];
                        break;
                    }
                    case 6: {
                        offX = size[0];
                        break;
                    }
                    case 7: {
                        offX = size[0];
                        offY = size[1] / 2;
                        break;
                    }
                    case 8: {
                        offX = size[0];
                        offY = size[1];
                    }
                }
                Tools.drawSpFrame(g2, endx - offX, endy - offY, frameindex, isMirror, imgIndex[index], clipDats, frameDats, exframeDat);
                break;
            }
            case 12: {
                int[] rgbdata = new int[clipW[index]];
                for (int i3 = 0; i3 < rgbdata.length; ++i3) {
                    rgbdata[i3] = imgIndex[index];
                }
                g2.drawRGB(rgbdata, 0, 0, endx, endy, (int)clipW[index], (int)clipH[index], true);
                break;
            }
            case 99: {
                g2.setClip(endx, endy, (int)clipW[index], (int)clipH[index]);
            }
        }
    }

    private static boolean checkAnthor(int anchor, int dir) {
        switch (dir) {
            case 4: {
                return (anchor >> 2 & 1) == 1;
            }
            case 1: {
                return (anchor & 1) == 1;
            }
            case 8: {
                return (anchor >> 3 & 1) == 1;
            }
            case 16: {
                return (anchor >> 4 & 1) == 1;
            }
            case 2: {
                return (anchor >> 1 & 1) == 1;
            }
            case 32: {
                return (anchor >> 5 & 1) == 1;
            }
        }
        return false;
    }

    private static short[] getFrameSize(byte[] dat) {
        short[] size = new short[]{(short)(Tools.bToi(dat[0]) << 8 | Tools.bToi(dat[1])), (short)(Tools.bToi(dat[2]) << 8 | Tools.bToi(dat[3]))};
        return size;
    }

    public static int conversionRatio(int vaule, int ratio) {
        return vaule * ratio / 100;
    }

    public static int simpleFormula(int base, int up, int level) {
        return up * level + base;
    }

    public static byte limit(int value) {
        return (byte)Math.max(0, Math.min(value, 100));
    }

    public static int getDigitCounter(int num) {
        int digitCounter = 0;
        while (num > 0) {
            num /= 10;
            ++digitCounter;
        }
        return digitCounter;
    }

    private static void drawNum(Graphics g2, int number, int imgIndex, int x2, int y2, int spacing, int count, byte anthor) {
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        maxNum += digitCounter;
        numNum += digitCounter;
        int numWidth = Tools.getImage(imgIndex).getWidth() / count;
        int numHeight = Tools.getImage(imgIndex).getHeight();
        switch (anthor) {
            case 0: 
            case 1: 
            case 2: {
                int i2 = digitCounter - 1;
                while (i2 >= 0) {
                    Tools.drawClipImage(g2, imgIndex, x2, y2, digits[i2] * numWidth, 0, numWidth, numHeight, anthor, 0);
                    --i2;
                    x2 += spacing + numWidth;
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                int i3 = 0;
                while (i3 <= digitCounter - 1) {
                    Tools.drawClipImage(g2, imgIndex, x2, y2, digits[i3] * numWidth, 0, numWidth, numHeight, anthor, 0);
                    ++i3;
                    x2 -= spacing + numWidth;
                }
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                x2 -= (numWidth + spacing) * (digitCounter - 1) / 2;
                int i4 = digitCounter - 1;
                while (i4 >= 0) {
                    Tools.drawClipImage(g2, imgIndex, x2, y2, digits[i4] * numWidth, 0, numWidth, numHeight, anthor, 0);
                    --i4;
                    x2 += spacing + numWidth;
                }
                break;
            }
        }
    }

    public static int getImageColor(Image img, int x2, int y2) {
        int[] p2 = new int[1];
        img.getRGB(p2, 0, 1, x2, y2, 1, 1);
        return p2[0];
    }

    private static void drawPane(Graphics g2, int imgIndex, int x2, int y2, int w2, int h2, boolean isFill) {
        int i2;
        Image img = Tools.getImage(imgIndex);
        if (isFill) {
            int col = Tools.getImageColor(img, 0, 0);
            g2.setColor(col);
            g2.fillRect(x2 + 3, y2 + 3, w2 - 6, h2 - 6);
        }
        int tileH = img.getHeight();
        int lenw = (w2 - tileH - 1) / tileH;
        int lenh = (h2 - tileH - 1) / tileH;
        for (i2 = 0; i2 < lenw; ++i2) {
            Tools.drawClipImage(g2, imgIndex, x2 + tileH + i2 * tileH, y2, tileH, 0, tileH, tileH, (byte)0, 0);
            Tools.drawClipImage(g2, imgIndex, x2 + tileH + i2 * tileH, y2 + h2 - tileH, tileH, 0, tileH, tileH, (byte)0, 2);
        }
        for (i2 = 0; i2 < lenh; ++i2) {
            Tools.drawClipImage(g2, imgIndex, x2, y2 + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)0, 0);
            Tools.drawClipImage(g2, imgIndex, x2 + w2 - tileH, y2 + tileH + i2 * tileH, tileH * 2, 0, tileH, tileH, (byte)0, 1);
        }
        Tools.drawClipImage(g2, imgIndex, x2, y2, 0, 0, tileH, tileH, (byte)0, 3);
        Tools.drawClipImage(g2, imgIndex, x2 + w2 - tileH, y2, 0, 0, tileH, tileH, (byte)0, 2);
        Tools.drawClipImage(g2, imgIndex, x2, y2 + h2 - tileH, 0, 0, tileH, tileH, (byte)0, 1);
        Tools.drawClipImage(g2, imgIndex, x2 + w2 - tileH, y2 + h2 - tileH, 0, 0, tileH, tileH, (byte)0, 0);
    }

    public static boolean getProperties(short val, byte bit) {
        return (val >> bit & 1) == 1;
    }

    static void createImage(String[][] mName) {
        Vector<String> v2 = new Vector<String>();
        for (int i2 = 0; i2 < mName.length; ++i2) {
            int len = mName[i2].length;
            Tools.imgGroup[Tools.mapGroup + i2] = new Image[len];
            for (int j2 = 0; j2 < len; ++j2) {
                String name = mName[i2][j2];
                if (v2.contains(name)) continue;
                v2.addElement(name);
            }
        }
        Object[] names = new String[v2.size()];
        v2.copyInto(names);
        v2 = null;
        DataInputStream dis = Tools.openFile("/images/tile.pak");
        try {
            PackageHead ph = Data.openPack(dis);
            int[] oIndex = Data.strOrder(ph.fileNames, (String[])names);
            int skip = 0;
            for (int i3 = 0; i3 < oIndex.length; ++i3) {
                int index = oIndex[i3];
                int offset = index == 0 ? 0 : ph.fileOffsets[index - 1];
                int len = ph.fileOffsets[index] - offset;
                byte[] imgData = new byte[len];
                dis.skip(offset - skip);
                dis.read(imgData);
                Image img = Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
                Tools.setMapImage(mName, ph.fileNames[oIndex[i3]], img);
                skip = ph.fileOffsets[index];
            }
            dis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void setMapImage(String[][] mName, String curName, Image img) {
        block0: for (int i2 = 0; i2 < mName.length; ++i2) {
            for (int j2 = 0; j2 < mName[i2].length; ++j2) {
                if (!curName.equals(mName[i2][j2])) continue;
                Tools.imgGroup[Tools.mapGroup + i2][j2] = img;
                continue block0;
            }
        }
    }

    public static int bToi(byte byte0) {
        int i2 = byte0;
        if (byte0 < 0) {
            i2 += 256;
        }
        return i2;
    }

    public static boolean percent(int per) {
        int rnd = Tools.nextInt(0, 99);
        return rnd < per;
    }

    public static final long sqrt(long v2) {
        if (v2 > 0L) {
            long c2;
            v2 *= 10000L;
            long r2 = 10000L;
            while ((r2 = (v2 / r2 + r2) / 2L) < (c2 = r2)) {
            }
            return c2;
        }
        return 0L;
    }

    static int square(int base, int exponent) {
        int pro = 1;
        for (int i2 = 0; i2 < exponent; ++i2) {
            pro *= base;
        }
        return pro;
    }

    public static boolean hit(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return x1 < x2 + w2 && x2 < x1 + w1 && (y1 -= h1) < (y2 -= h2) + h2 && y2 < y1 + h1;
    }

    public static boolean hit(int x1, int y1, int x2, int y2, int w2, int h2) {
        return x1 >= x2 && x1 < x2 + w2 && y1 >= (y2 -= h2) && y1 < y2 + h2;
    }

    static int getMotionValue(byte[] motion, int index) {
        switch (index) {
            case 0: {
                return Tools.bToi(motion[0]);
            }
            case 1: {
                return motion[1] & 3;
            }
            case 2: {
                int v1 = motion[1] >> 2 & 0x3F;
                int v2 = v1 & 0x1F;
                return (v1 >> 5 & 1) == 0 ? v2 : -v2;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                long d1 = Tools.bToi(motion[2]);
                long d2 = Tools.bToi(motion[3]);
                long d3 = Tools.bToi(motion[4]);
                long d4 = Tools.bToi(motion[5]);
                long d5 = Tools.bToi(motion[6]);
                long temp = d1 << 32 | d2 << 24 | d3 << 16 | d4 << 8 | d5;
                int tmp = (int)(temp >> 30 - (index - 3) * 10 & 0x3FFL);
                return (tmp & 0x200) == 0 ? tmp & 0x1FF : -(tmp & 0x1FF);
            }
        }
        System.out.println("getMotionValue error!");
        return Integer.MAX_VALUE;
    }

    public static int nextInt(int n2) {
        return Math.abs(rnd.nextInt()) % (n2 + 1);
    }

    public static int nextInt(int n2, int m2) {
        if (n2 == m2) {
            return n2;
        }
        if (n2 > m2) {
            int temp = n2;
            n2 = m2;
            m2 = temp;
        }
        int gap = Math.abs(n2 - m2);
        return Math.abs(rnd.nextInt()) % (gap + 1) + n2;
    }

    static void drawAll(Graphics g2) {
        maxNum = max_obj;
        Tools.sort();
        for (int i2 = 0; i2 < max_obj; ++i2) {
            Tools.drawMe(g2, drawObj[i2]);
        }
        max_obj = 0;
        maxNum = 0;
        frameNum = 0;
        numNum = 0;
        arrayV.removeAllElements();
    }

    private static void sort() {
        for (int i2 = 1; i2 < max_obj; ++i2) {
            if (drawLevel[drawObj[i2]] >= drawLevel[drawObj[i2 - 1]]) continue;
            short temp = drawObj[i2];
            int j2 = i2 - 1;
            do {
                Tools.drawObj[j2 + 1] = drawObj[j2];
            } while (--j2 >= 0 && drawLevel[temp] < drawLevel[drawObj[j2]]);
            Tools.drawObj[j2 + 1] = temp;
        }
    }

    static int[] changeClipData(byte[] clip) {
        int[] newCilp;
        block3: {
            block2: {
                newCilp = new int[4];
                if (clip.length != 4) break block2;
                for (int i2 = 0; i2 < newCilp.length; ++i2) {
                    newCilp[i2] = Tools.bToi(clip[i2]);
                }
                break block3;
            }
            if (clip.length != 8) break block3;
            for (int i3 = 0; i3 < newCilp.length; ++i3) {
                newCilp[i3] = (Tools.bToi(clip[i3 * 2]) << 8) + Tools.bToi(clip[i3 * 2 + 1]);
            }
        }
        return newCilp;
    }

    static {
        dirNames = new String[]{"battle", "bg", "deck", "effect", "fighter", "head", "load", "more", "open", "other", "sprite", "ui", "shot", "face", "choose", "rank", "public", "dead"};
        mapGroup = dirNames.length;
        imgGroup = new Image[mapGroup + 5][];
        anthors = new int[]{20, 5, 36, 17, 3, 33, 24, 10, 40};
        wave = new byte[]{0, -6, -10, -11, -12, -11, -10, -6, 0};
        curIndex = 0;
        max_obj = 0;
        drawObj = new short[400];
        clipX = new short[400];
        clipY = new short[400];
        clipW = new short[400];
        clipH = new short[400];
        x = new short[400];
        y = new short[400];
        drawLevel = new short[400];
        imgIndex = new int[400];
        anchor = new byte[400];
        trans = new byte[400];
        str = new String[400];
        type = new byte[400];
        arrayV = new Vector();
        rnd = new Random();
    }
}

