/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public final class Data {
    static final byte PERFRAME = 12;
    static short[][][] effectGroupScript;
    static byte[][] uiClipDat21;
    static byte[][][] roleEquipType;
    static byte[][][][] spriteClipData;
    static byte[][][][] spriteFrameData;
    static byte[][][] spriteExFrameData;
    static byte[][][][] spriteMotionData;
    static int[][] fighterVauleData;
    static final byte FV_FM = 0;
    static final byte FV_SKILL = 1;
    static final byte FV_CRIT = 2;
    static final byte FV_PIMM = 3;
    static final byte FV_MIMM = 4;
    static final byte FV_AI = 5;
    static byte[][][] effectClipData;
    static byte[][][] effectFrameData;
    static byte[][][][] effectMotionData;
    static byte value1Max;
    static byte value2Max;
    static final byte DATA_CLIP = 0;
    static final byte DATA_FRAME = 1;
    static final byte DATA_MOTION = 2;
    static final byte DATA_OFFSET = 3;
    static final byte DATA_SCRIPT = 4;
    static final byte DATA_FRAME_EX = 5;
    public static final byte FE_AREA = 0;
    public static final byte FE_DEFAREA = 1;
    public static final byte FE_ATTACK = 2;
    public static final byte FE_COMBO = 3;
    public static final byte FE_MOVE = 4;
    public static final byte FE_SHAKE = 6;
    public static final byte FE_ADDEFF = 7;
    public static final byte FE_ADDSHOT = 8;
    public static final byte FE_HITEFFECT = 9;
    public static final byte FE_BLACKBG = 10;
    public static final byte FE_SUPERSKILL = 11;
    public static final byte FE_SLEEPTIME = 12;
    public static final byte FE_SUPERARMOR = 13;
    public static final byte FE_SWORDMOVE = 14;
    public static final byte FE_MUSIC = 15;
    static short[][][][][] frameScript;
    static short[][][] defaultArea;
    private static short[][] tempArea;

    private static void freeData(Object[] obj) {
        if (obj == null) {
            return;
        }
        int i2 = 0;
        while (i2 < obj.length) {
            obj[i2] = null;
            ++i2;
        }
    }

    static void freeSpriteData() {
        Data.freeData((Object[])spriteClipData);
        Data.freeData((Object[])spriteFrameData);
        Data.freeData((Object[])spriteMotionData);
    }

    static void freeFighterData() {
    }

    static void freeEffectData() {
        Data.freeData((Object[])effectClipData);
        Data.freeData((Object[])effectFrameData);
        Data.freeData((Object[])effectMotionData);
    }

    static void loadSpriteData(String[] sprite) {
        DataInputStream is = Tools.openFile("/data/spriteDat.pak");
        try {
            PackageHead ph = Data.openPack(is);
            if (spriteClipData == null) {
                int len = Data.getPackLen(ph.fileNames);
                spriteClipData = new byte[len][][][];
                spriteFrameData = new byte[len][][][];
                spriteExFrameData = new byte[len][][];
                spriteMotionData = new byte[len][][][];
                frameScript = new short[len][][][][];
                defaultArea = new short[len][][];
            }
            int[] oIndex = Data.strOrder(ph.fileNames, sprite);
            int skip = 0;
            int i2 = 0;
            while (i2 < oIndex.length) {
                int index = oIndex[i2];
                int pos = Integer.parseInt(ph.fileNames[index]);
                int offset = index == 0 ? 0 : ph.fileOffsets[index - 1];
                is.skip(offset - skip);
                Object[] obj = Data.getDataGroup(is);
                Data.spriteClipData[pos] = (byte[][][])obj[0];
                Data.spriteFrameData[pos] = (byte[][][])obj[1];
                Data.spriteMotionData[pos] = (byte[][][])obj[2];
                Data.spriteExFrameData[pos] = (byte[][])obj[5];
                Data.frameScript[pos] = (short[][][][])obj[4];
                Data.defaultArea[pos] = tempArea;
                tempArea = null;
                skip = ph.fileOffsets[index];
                ++i2;
            }
            is.close();
            ph = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static Object[] getDataGroup(DataInputStream is) {
        try {
            Object[] obj = new Object[6];
            PackageHead ph = Data.openPack(is);
            int clipNum = (ph.number - 3) / 2;
            byte[][][] clipTemp = new byte[clipNum][][];
            byte[][][] frameTemp = new byte[clipNum][][];
            int i2 = 0;
            while (i2 < ph.number) {
                int len = ph.fileNames[i2].length();
                char type = ph.fileNames[i2].substring(len - 1, len).charAt(0);
                int index = 0;
                switch (type) {
                    case 'c': 
                    case 'f': {
                        index = Integer.parseInt(ph.fileNames[i2].substring(0, len - 1));
                    }
                }
                switch (type) {
                    case 'c': {
                        clipTemp[index] = Data.readClipData(is);
                        break;
                    }
                    case 'f': {
                        frameTemp[index] = Data.readFrameData(is);
                        break;
                    }
                    case 'm': {
                        obj[2] = Data.readMotionData(is);
                        break;
                    }
                    case 's': {
                        obj[4] = Data.readFrameScript(is);
                        break;
                    }
                    case 'x': {
                        obj[5] = Data.readExFrameData(is);
                    }
                }
                ++i2;
            }
            obj[0] = clipTemp;
            obj[1] = frameTemp;
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("getDataGroup error");
            return null;
        }
    }

    static void loadEffData() {
        DataInputStream is = Tools.openFile("/data/effect.pak");
        try {
            PackageHead ph = Data.openPack(is);
            if (effectClipData == null) {
                int len = Data.getPackLen(ph.fileNames);
                effectClipData = new byte[len][][];
                effectFrameData = new byte[len][][];
                System.out.println("len:" + len);
                effectMotionData = new byte[len][][][];
            }
            int i2 = 0;
            while (i2 < ph.fileNames.length) {
                Object[] obj = Data.getSpecialData(is);
                int index = Integer.parseInt(ph.fileNames[i2]);
                Data.effectClipData[index] = (byte[][])obj[0];
                Data.effectFrameData[index] = (byte[][])obj[1];
                Data.effectMotionData[index] = (byte[][][])obj[2];
                ++i2;
            }
            is.close();
            ph = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static void loadDB() {
        DataInputStream is = Tools.openFile("/data/db.pak");
        try {
            PackageHead ph = Data.openPack(is);
            int i2 = 0;
            while (i2 < ph.fileNames.length) {
                if (ph.fileNames[i2].equals("equip")) {
                    Data.initEquipment(is);
                } else if (ph.fileNames[i2].equals("consumable")) {
                    Data.initConsumable(is);
                } else if (ph.fileNames[i2].equals("gem")) {
                    Data.initGem(is);
                } else if (ph.fileNames[i2].equals("box")) {
                    Data.initBox(is);
                } else if (ph.fileNames[i2].equals("raw")) {
                    Data.initRaw(is);
                } else if (ph.fileNames[i2].equals("fighter")) {
                    Data.initFighterData(is);
                } else if (ph.fileNames[i2].equals("ps")) {
                    Data.initPassiveSkills(is);
                } else if (ph.fileNames[i2].equals("miniMap")) {
                    Data.initMiniMap(is);
                } else if (ph.fileNames[i2].equals("rankMiniMap")) {
                    Data.initRankMiniMap(is);
                } else if (ph.fileNames[i2].equals("ps")) {
                    Data.initPassiveSkills(is);
                } else if (ph.fileNames[i2].equals("initiativeSkills")) {
                    Data.initInitiativeSkills(is);
                } else if (ph.fileNames[i2].equals("achievement")) {
                    Data.initAchievement(is);
                } else if (ph.fileNames[i2].equals("roleEquipType")) {
                    Engine.initRoleEquipType(is);
                } else {
                    int offset = i2 == 0 ? 0 : ph.fileOffsets[i2 - 1];
                    is.skip(ph.fileOffsets[i2] - offset);
                }
                ++i2;
            }
            is.close();
            ph = null;
        }
        catch (Exception ex) {}
    }

    static void initInitiativeSkills(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.tempiIs = new InitiativeSkills[len];
            int i2 = 0;
            while (i2 < Engine.tempiIs.length) {
                Engine.tempiIs[i2] = new InitiativeSkills();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.tempiIs[i2].name = new String(strBuff, "UTF-8");
                Engine.tempiIs[i2].level = 0;
                Engine.tempiIs[i2].level_max = dis.readByte();
                Engine.tempiIs[i2].baseVaule = dis.readShort();
                Engine.tempiIs[i2].upVaule = dis.readByte();
                Engine.tempiIs[i2].atkBaseVaule = dis.readByte();
                Engine.tempiIs[i2].atkUpVaule = dis.readByte();
                Engine.tempiIs[i2].reduceBaseValue = dis.readShort();
                Engine.tempiIs[i2].reduceUpValue = dis.readByte();
                Engine.tempiIs[i2].cdTime = dis.readShort();
                Engine.tempiIs[i2].icon = dis.readByte();
                System.out.println("Engine.tempiIs[" + i2 + "].name:  " + Engine.tempiIs[i2].name);
                System.out.println("Engine.tempiIs[" + i2 + "].level_max:  " + Engine.tempiIs[i2].level_max);
                System.out.println("Engine.tempiIs[" + i2 + "].baseVaule:  " + Engine.tempiIs[i2].baseVaule);
                System.out.println("Engine.tempiIs[" + i2 + "].upVaule:  " + Engine.tempiIs[i2].upVaule);
                System.out.println("Engine.tempiIs[" + i2 + "].atkBaseVaule:  " + Engine.tempiIs[i2].atkBaseVaule);
                System.out.println("Engine.tempiIs[" + i2 + "].atkUpVaule:  " + Engine.tempiIs[i2].atkUpVaule);
                System.out.println("Engine.tempiIs[" + i2 + "].reduceBaseVaule:  " + Engine.tempiIs[i2].reduceBaseValue);
                System.out.println("Engine.tempiIs[" + i2 + "].cdTime:  " + Engine.tempiIs[i2].cdTime);
                System.out.println("Engine.tempiIs[" + i2 + "].reduceUpVaule:  " + Engine.tempiIs[i2].reduceUpValue);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("IS data error!");
        }
    }

    static void initAchievement(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.ach = new Achievement[len];
            int i2 = 0;
            while (i2 < Engine.ach.length) {
                Engine.ach[i2] = new Achievement();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.ach[i2].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.ach[i2].describe = new String(strBuff, "UTF-8");
                Engine.ach[i2].addMoney = dis.readInt();
                Engine.ach[i2].addIntegral = dis.readShort();
                Engine.ach[i2].addDef = dis.readShort();
                Engine.ach[i2].addAtk = dis.readShort();
                Engine.ach[i2].addMp = dis.readShort();
                Engine.ach[i2].addHp = dis.readShort();
                Engine.ach[i2].isGet = false;
                System.out.println("Engine.ach[" + i2 + "].name:  " + Engine.ach[i2].name);
                System.out.println("Engine.ach[" + i2 + "].describe:  " + Engine.ach[i2].describe);
                System.out.println("Engine.ach[" + i2 + "].addMoney:  " + Engine.ach[i2].addMoney);
                System.out.println("Engine.ach[" + i2 + "].addIntegral:  " + Engine.ach[i2].addIntegral);
                System.out.println("Engine.ach[" + i2 + "].addDef:  " + Engine.ach[i2].addDef);
                System.out.println("Engine.ach[" + i2 + "].addAtk:  " + Engine.ach[i2].addAtk);
                System.out.println("Engine.ach[" + i2 + "].addMp:  " + Engine.ach[i2].addMp);
                System.out.println("Engine.ach[" + i2 + "].addHp:  " + Engine.ach[i2].addHp);
                System.out.println("Engine.ach[" + i2 + "].isGet:  " + Engine.ach[i2].isGet);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Gem data error!");
        }
    }

    static void initFighterData(DataInputStream dis) {
        try {
            int len = dis.readShort();
            Object strBuff = null;
            int vauleMax = 7;
            fighterVauleData = new int[len][vauleMax];
            int i2 = 0;
            while (i2 < len) {
                Data.fighterVauleData[i2][0] = dis.readInt();
                Data.fighterVauleData[i2][1] = dis.readShort();
                Data.fighterVauleData[i2][2] = dis.readShort();
                Data.fighterVauleData[i2][3] = dis.readShort();
                Data.fighterVauleData[i2][4] = dis.readShort();
                Data.fighterVauleData[i2][5] = dis.readByte();
                Data.fighterVauleData[i2][6] = dis.readByte();
                System.out.println("sprite[" + i2 + "]. \u751f\u547d:" + fighterVauleData[i2][0]);
                System.out.println("sprite[" + i2 + "].\u84dd:" + fighterVauleData[i2][1]);
                System.out.println("sprite[" + i2 + "].\u653b\u51fb:" + fighterVauleData[i2][2]);
                System.out.println("sprite[" + i2 + "].\u9632\u5fa1:" + fighterVauleData[i2][3]);
                System.out.println("sprite[" + i2 + "].\u7ecf\u9a8c:" + fighterVauleData[i2][4]);
                System.out.println("sprite[" + i2 + "].\u901f\u5ea6:" + fighterVauleData[i2][5]);
                System.out.println("sprite[" + i2 + "].BOSS:" + fighterVauleData[i2][6]);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("fighter data error!");
        }
    }

    static void initEquipment(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.equip = new Equipment[len];
            int i2 = 0;
            while (i2 < Engine.equip.length) {
                Engine.equip[i2] = new Equipment();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.equip[i2].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.equip[i2].info = new String(strBuff, "UTF-8");
                Engine.equip[i2].type = dis.readByte();
                Engine.equip[i2].profession = dis.readByte();
                Engine.equip[i2].level = dis.readByte();
                Engine.equip[i2].attack = dis.readShort();
                Engine.equip[i2].defense = dis.readShort();
                Engine.equip[i2].hp = dis.readShort();
                Engine.equip[i2].mp = dis.readShort();
                Engine.equip[i2].luck = dis.readByte();
                Engine.equip[i2].critical = dis.readByte();
                Engine.equip[i2].propertyExMin = dis.readByte();
                Engine.equip[i2].propertyExMax = dis.readByte();
                Engine.equip[i2].gemType = dis.readByte();
                Engine.equip[i2].gemNumMax = dis.readByte();
                Engine.equip[i2].price = dis.readShort();
                Engine.equip[i2].icon = dis.readByte();
                System.out.println("Engine.equip[" + i2 + "].name:" + Engine.equip[i2].name);
                System.out.println("Engine.equip[" + i2 + "].info:" + Engine.equip[i2].info);
                System.out.println("Engine.equip[" + i2 + "].type:" + Engine.equip[i2].type);
                System.out.println("Engine.equip[" + i2 + "].profession:" + Engine.equip[i2].profession);
                System.out.println("Engine.equip[" + i2 + "].level:" + Engine.equip[i2].level);
                System.out.println("Engine.equip[" + i2 + "].attack:" + Engine.equip[i2].attack);
                System.out.println("Engine.equip[" + i2 + "].defense:" + Engine.equip[i2].defense);
                System.out.println("Engine.equip[" + i2 + "].hp:" + Engine.equip[i2].hp);
                System.out.println("Engine.equip[" + i2 + "].mp:" + Engine.equip[i2].mp);
                System.out.println("Engine.equip[" + i2 + "].luck:" + Engine.equip[i2].luck);
                System.out.println("Engine.equip[" + i2 + "].critical:" + Engine.equip[i2].critical);
                System.out.println("Engine.equip[" + i2 + "].propertyExMin:" + Engine.equip[i2].propertyExMin);
                System.out.println("Engine.equip[" + i2 + "].propertyExMax:" + Engine.equip[i2].propertyExMax);
                System.out.println("Engine.equip[" + i2 + "].gemType:" + Engine.equip[i2].gemType);
                System.out.println("Engine.equip[" + i2 + "].gemNumMax:" + Engine.equip[i2].gemNumMax);
                System.out.println("Engine.equip[" + i2 + "].price:" + Engine.equip[i2].price);
                System.out.println("Engine.equip[" + i2 + "].icon:" + Engine.equip[i2].icon);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("equipment data error!");
        }
    }

    static void initConsumable(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.consum = new Consumable[len];
            int i2 = 0;
            while (i2 < Engine.consum.length) {
                Engine.consum[i2] = new Consumable();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.consum[i2].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.consum[i2].info = new String(strBuff, "UTF-8");
                Engine.consum[i2].type = dis.readByte();
                Engine.consum[i2].addHp = dis.readShort();
                Engine.consum[i2].addMp = dis.readShort();
                Engine.consum[i2].addHpMax = dis.readByte();
                Engine.consum[i2].addMpMax = dis.readByte();
                Engine.consum[i2].addAttack = dis.readByte();
                Engine.consum[i2].addDefense = dis.readByte();
                Engine.consum[i2].addCritical = dis.readByte();
                Engine.consum[i2].price = dis.readShort();
                Engine.consum[i2].icon = dis.readByte();
                System.out.println("Engine.consum[" + i2 + "].name:  " + Engine.consum[i2].name);
                System.out.println("Engine.consum[" + i2 + "].info:  " + Engine.consum[i2].info);
                System.out.println("Engine.consum[" + i2 + "].type:  " + Engine.consum[i2].type);
                System.out.println("Engine.consum[" + i2 + "].addHp:  " + Engine.consum[i2].addHp);
                System.out.println("Engine.consum[" + i2 + "].addMp:  " + Engine.consum[i2].addMp);
                System.out.println("Engine.consum[" + i2 + "].addHpMax:  " + Engine.consum[i2].addHpMax);
                System.out.println("Engine.consum[" + i2 + "].addMpMax:  " + Engine.consum[i2].addMpMax);
                System.out.println("Engine.consum[" + i2 + "].addAttack:  " + Engine.consum[i2].addAttack);
                System.out.println("Engine.consum[" + i2 + "].addDefense:  " + Engine.consum[i2].addDefense);
                System.out.println("Engine.consum[" + i2 + "].addCritical:  " + Engine.consum[i2].addCritical);
                System.out.println("Engine.consum[" + i2 + "].price:  " + Engine.consum[i2].price);
                System.out.println("Engine.consum[" + i2 + "].icon:  " + Engine.consum[i2].icon);
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Consumable data error!");
        }
    }

    static void initGem(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.gem = new Gem[len];
            int i2 = 0;
            while (i2 < Engine.gem.length) {
                Engine.gem[i2] = new Gem();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.gem[i2].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.gem[i2].info = new String(strBuff, "UTF-8");
                Engine.gem[i2].type = dis.readByte();
                Engine.gem[i2].attackPer = dis.readByte();
                Engine.gem[i2].defense = dis.readByte();
                Engine.gem[i2].critical = dis.readByte();
                Engine.gem[i2].luck = dis.readByte();
                Engine.gem[i2].level = dis.readByte();
                Engine.gem[i2].price = dis.readShort();
                Engine.gem[i2].icon = dis.readByte();
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Gem data error!");
        }
    }

    static void initMiniMap(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.miniMap = new MiniMap[len];
            int i2 = 0;
            while (i2 < Engine.miniMap.length) {
                Engine.miniMap[i2] = new MiniMap();
                Engine.miniMap[i2].scriptId = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.miniMap[i2].name = new String(strBuff, "UTF-8");
                Engine.miniMap[i2].type = dis.readByte();
                Engine.miniMap[i2].pass_up = dis.readByte() != 0;
                Engine.miniMap[i2].pass_right = dis.readByte() != 0;
                Engine.miniMap[i2].pass_down = dis.readByte() != 0;
                Engine.miniMap[i2].pass_left = dis.readByte() != 0;
                System.out.println("Engine.miniMap[" + i2 + "].scriptId:  " + Engine.miniMap[i2].scriptId);
                System.out.println("Engine.miniMap[" + i2 + "].name:  " + Engine.miniMap[i2].name);
                System.out.println("Engine.miniMap[" + i2 + "].type:  " + Engine.miniMap[i2].type);
                System.out.println("Engine.miniMap[" + i2 + "].pass_up:  " + Engine.miniMap[i2].pass_up);
                System.out.println("Engine.miniMap[" + i2 + "].pass_right:  " + Engine.miniMap[i2].pass_right);
                System.out.println("Engine.miniMap[" + i2 + "].pass_down:  " + Engine.miniMap[i2].pass_down);
                System.out.println("Engine.miniMap[" + i2 + "].pass_left:  " + Engine.miniMap[i2].pass_left);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Minimap data error!");
        }
    }

    static void initPassiveSkills(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.ps = new PassiveSkills[len];
            int i2 = 0;
            while (i2 < Engine.ps.length) {
                Engine.ps[i2] = new PassiveSkills();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.ps[i2].name = new String(strBuff, "UTF-8");
                Engine.ps[i2].type = dis.readByte();
                Engine.ps[i2].baseVaule = dis.readByte();
                Engine.ps[i2].upVaule = dis.readByte();
                Engine.ps[i2].level_max = dis.readByte();
                Engine.ps[i2].icon = dis.readByte();
                Engine.ps[i2].level = 0;
                System.out.println("Engine.ps[" + i2 + "].name:  " + Engine.ps[i2].name);
                System.out.println("Engine.ps[" + i2 + "].type:  " + Engine.ps[i2].type);
                System.out.println("Engine.ps[" + i2 + "].baseVaule:  " + Engine.ps[i2].baseVaule);
                System.out.println("Engine.ps[" + i2 + "].upVaule:  " + Engine.ps[i2].upVaule);
                System.out.println("Engine.ps[" + i2 + "].level_max:  " + Engine.ps[i2].level_max);
                System.out.println("Engine.ps[" + i2 + "].icon:  " + Engine.ps[i2].icon);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("PS data error!");
        }
    }

    static void initRankMiniMap(DataInputStream dis) {
        try {
            int len = dis.readShort();
            byte[] strBuff = null;
            Engine.rmm = new RankMiniMap[len];
            int p2 = 0;
            while (p2 < Engine.difficulty.length) {
                Engine.difficulty[p2] = new short[len];
                Engine.difficultyScore[p2] = new short[len];
                ++p2;
            }
            int i2 = 0;
            while (i2 < len) {
                int j2;
                String[] params;
                Engine.rmm[i2] = new RankMiniMap();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.rmm[i2].name = new String(strBuff, "UTF-8");
                Engine.rmm[i2].mapData = new byte[value1Max][value2Max];
                int k2 = 0;
                while (k2 < value1Max) {
                    strBuff = new byte[dis.readShort()];
                    dis.read(strBuff);
                    String equip = new String(strBuff, "UTF-8");
                    if (equip.equals("null")) {
                        Engine.rmm[i2].mapData[k2] = null;
                    } else {
                        params = Variable.splitString(equip, ",");
                        j2 = 0;
                        while (j2 < params.length) {
                            Engine.rmm[i2].mapData[k2][j2] = (byte)Integer.parseInt(params[j2]);
                            System.out.println("Engine.rmm[" + i2 + "].mapData[k][j]:" + Engine.rmm[i2].mapData[k2][j2]);
                            ++j2;
                        }
                    }
                    ++k2;
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.rmm[i2].dis = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.rmm[i2].target = new String(strBuff, "UTF-8");
                Engine.rmm[i2].rankId = dis.readShort();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String con = new String(strBuff, "UTF-8");
                if (con.equals("null")) {
                    Engine.rmm[i2].conDrop = null;
                } else {
                    params = Variable.splitString(con, ",");
                    Engine.rmm[i2].conDrop = new byte[params.length];
                    j2 = 0;
                    while (j2 < params.length) {
                        Engine.rmm[i2].conDrop[j2] = (byte)Integer.parseInt(params[j2]);
                        System.out.println("Engine.rmm[" + i2 + "].conDrop[" + j2 + "]:" + Engine.rmm[i2].conDrop[j2]);
                        ++j2;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String equip = new String(strBuff, "UTF-8");
                if (equip.equals("null")) {
                    Engine.rmm[i2].equipDrop = null;
                } else {
                    params = Variable.splitString(equip, ",");
                    Engine.rmm[i2].equipDrop = new byte[params.length];
                    int j3 = 0;
                    while (j3 < params.length) {
                        Engine.rmm[i2].equipDrop[j3] = (byte)Integer.parseInt(params[j3]);
                        System.out.println("Engine.rmm[" + i2 + "].equipDrop[" + j3 + "]:" + Engine.rmm[i2].equipDrop[j3]);
                        ++j3;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String gold = new String(strBuff, "UTF-8");
                if (gold.equals("null")) {
                    Engine.rmm[i2].goldDrop = null;
                } else {
                    params = Variable.splitString(gold, ",");
                    Engine.rmm[i2].goldDrop = new byte[params.length];
                    int j4 = 0;
                    while (j4 < params.length) {
                        Engine.rmm[i2].goldDrop[j4] = (byte)Integer.parseInt(params[j4]);
                        System.out.println("Engine.rmm[" + i2 + "].goldDrop[" + j4 + "]:" + Engine.rmm[i2].goldDrop[j4]);
                        ++j4;
                    }
                }
                System.out.println("Engine.rmm[" + i2 + "].name:" + Engine.rmm[i2].name);
                System.out.println("Engine.rmm[" + i2 + "].dis:" + Engine.rmm[i2].dis);
                System.out.println("Engine.rmm[" + i2 + "].target:" + Engine.rmm[i2].target);
                System.out.println("Engine.rmm[" + i2 + "].rankId:" + Engine.rmm[i2].rankId);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("rankMiniMap data error!");
        }
    }

    static void initBox(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.box = new Box[len];
            int i2 = 0;
            while (i2 < Engine.box.length) {
                String[] params;
                Engine.box[i2] = new Box();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.box[i2].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.box[i2].info = new String(strBuff, "UTF-8");
                Engine.box[i2].level = dis.readByte();
                Engine.box[i2].gemNumMax = dis.readByte();
                Engine.box[i2].gemNum = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String equip = new String(strBuff, "UTF-8");
                if (equip.equals("null")) {
                    Engine.box[i2].getEquipment = null;
                } else {
                    params = Variable.splitString(equip, ",");
                    Engine.box[i2].getEquipment = new short[params.length];
                    int j2 = 0;
                    while (j2 < params.length) {
                        Engine.box[i2].getEquipment[j2] = (short)Integer.parseInt(params[j2]);
                        ++j2;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String con = new String(strBuff, "UTF-8");
                if (con.equals("null")) {
                    Engine.box[i2].getConsumable = null;
                } else {
                    params = Variable.splitString(con, ",");
                    Engine.box[i2].getConsumable = new short[params.length];
                    int j3 = 0;
                    while (j3 < params.length) {
                        Engine.box[i2].getConsumable[j3] = (short)Integer.parseInt(params[j3]);
                        ++j3;
                    }
                }
                Engine.box[i2].price = dis.readShort();
                Engine.box[i2].icon = dis.readByte();
                System.out.println("Engine.box[" + i2 + "].name:  " + Engine.box[i2].name);
                System.out.println("Engine.box[" + i2 + "].info:  " + Engine.box[i2].info);
                System.out.println("Engine.box[" + i2 + "].level:  " + Engine.box[i2].level);
                System.out.println("Engine.box[" + i2 + "].gemNumMax:  " + Engine.box[i2].gemNumMax);
                System.out.println("Engine.box[" + i2 + "].gemNum:  " + Engine.box[i2].gemNum);
                System.out.println("Engine.box[" + i2 + "].getEquipment:  " + equip);
                System.out.println("Engine.box[" + i2 + "].getConsumable:  " + con);
                System.out.println("Engine.box[" + i2 + "].price:  " + Engine.box[i2].price);
                System.out.println("Engine.box[" + i2 + "].icon:  " + Engine.box[i2].icon);
                System.out.println("-------------------------< next >----------------------------------");
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Box data error!");
        }
    }

    static void initRaw(DataInputStream dis) {
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            Engine.raw = new Raw[len];
            int i2 = 0;
            while (i2 < Engine.raw.length) {
                Engine.raw[i2] = new Raw();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                Engine.raw[i2].name = new String(strBuff, "UTF-8");
                Engine.raw[i2].exchangeNum = dis.readByte();
                Engine.raw[i2].price = dis.readByte();
                Engine.raw[i2].icon = dis.readByte();
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Raw data error!");
        }
    }

    public static PackageHead openPack(DataInputStream is) throws Exception {
        char mark = (char)is.readShort();
        if (mark != 'A') {
            System.out.println("file format error");
            return null;
        }
        PackageHead ph = new PackageHead();
        int len = is.readShort();
        ph.number = len;
        ph.fileNames = new String[len];
        ph.fileOffsets = new int[len];
        int i2 = 0;
        while (i2 < len) {
            int nameLen = is.read();
            byte[] contentBuff = new byte[nameLen];
            is.read(contentBuff);
            ph.fileNames[i2] = new String(contentBuff, "UTF-8");
            ++i2;
        }
        int i3 = 0;
        while (i3 < len) {
            ph.fileOffsets[i3] = is.readInt();
            ++i3;
        }
        return ph;
    }

    static int getPackLen(String[] names) {
        int max = 0;
        int i2 = 0;
        while (i2 < names.length) {
            int v2 = Integer.parseInt(names[i2]);
            if (v2 > max) {
                max = v2;
            }
            ++i2;
        }
        return max + 1;
    }

    static int[] strOrder(String[] modle, String[] str) {
        Vector<String> v2 = new Vector<String>();
        int i2 = 0;
        while (i2 < str.length) {
            int j2 = 0;
            while (j2 < modle.length) {
                if (Integer.parseInt(modle[j2]) == Integer.parseInt(str[i2])) {
                    v2.addElement("" + j2);
                }
                ++j2;
            }
            ++i2;
        }
        int[] index = new int[v2.size()];
        int i3 = 0;
        while (i3 < index.length) {
            index[i3] = Integer.parseInt(v2.elementAt(i3).toString());
            ++i3;
        }
        v2 = null;
        int i4 = 0;
        while (i4 < index.length) {
            int j3 = i4 + 1;
            while (j3 < index.length) {
                if (index[i4] > index[j3]) {
                    index[i4] = index[i4] ^ index[j3];
                    index[j3] = index[i4] ^ index[j3];
                    index[i4] = index[i4] ^ index[j3];
                }
                ++j3;
            }
            ++i4;
        }
        return index;
    }

    public static int searchFile(DataInputStream is, String name) {
        try {
            PackageHead ph = Data.openPack(is);
            int index = -1;
            int i2 = 0;
            while (i2 < ph.fileNames.length) {
                if (ph.fileNames[i2].equals(name)) {
                    index = i2;
                    break;
                }
                ++i2;
            }
            if (index == -1) {
                return -1;
            }
            int offset = index == 0 ? 0 : ph.fileOffsets[index - 1];
            int len = ph.fileOffsets[index] - offset;
            is.skip(offset);
            return len;
        }
        catch (Exception ex1) {
            return -1;
        }
    }

    public static Object[] getSpecialData(DataInputStream is) throws Exception {
        int len = is.readByte();
        Object[] obj = new Object[5];
        int i2 = 0;
        while (i2 < len) {
            char flag = is.readChar();
            switch (flag) {
                case 'c': {
                    obj[0] = Data.readClipData(is);
                    break;
                }
                case 'f': {
                    obj[1] = Data.readFrameData(is);
                    break;
                }
                case 'm': {
                    obj[2] = Data.readMotionData(is);
                    break;
                }
                case 'o': {
                    obj[3] = Data.readClipData(is);
                    break;
                }
                case 's': {
                    obj[4] = Data.readFrameScript(is);
                }
            }
            ++i2;
        }
        return obj;
    }

    static byte[][] readClipData(DataInputStream is) {
        byte[][] clip = null;
        int clipLen = 0;
        int perlen = 0;
        try {
            byte mark = is.readByte();
            perlen = mark == 0 ? 4 : 8;
            clipLen = is.readShort();
            clip = new byte[clipLen][perlen];
            int i2 = 0;
            while (i2 < clipLen) {
                int j2 = 0;
                while (j2 < perlen) {
                    clip[i2][j2] = is.readByte();
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("read ClipData error!");
            e2.printStackTrace();
        }
        return clip;
    }

    static byte[][] readFrameData(DataInputStream is) {
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i2 = 0;
            while (i2 < len) {
                int gLen = (is.readByte() - 4) * 5 + 4;
                frame[i2] = new byte[gLen];
                int j2 = 0;
                while (j2 < gLen) {
                    frame[i2][j2] = is.readByte();
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("read frameData error!");
            e2.printStackTrace();
        }
        return frame;
    }

    static byte[][][] readMotionData(DataInputStream is) {
        byte[][][] motion = null;
        int motionLen = 0;
        try {
            motionLen = is.readByte();
            motion = new byte[30][][];
            int i2 = 0;
            while (i2 < motionLen) {
                byte st = is.readByte();
                int zs = is.readByte();
                motion[st] = new byte[zs][7];
                int j2 = 0;
                while (j2 < zs) {
                    int m2 = 0;
                    while (m2 < 7) {
                        motion[st][j2][m2] = is.readByte();
                        ++m2;
                    }
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("read motionData error!");
            e2.printStackTrace();
        }
        return motion;
    }

    static short[][] readArray(String fileName, String name) {
        DataInputStream is = Tools.openFile(fileName);
        if (is == null) {
            return null;
        }
        int fileLen = Data.searchFile(is, name);
        if (fileLen == -1) {
            return null;
        }
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i2 = 0;
            while (i2 < len) {
                int gLen = is.readByte();
                dat[i2] = new short[gLen];
                int j2 = 0;
                while (j2 < gLen) {
                    dat[i2][j2] = is.readShort();
                    ++j2;
                }
                ++i2;
            }
            is.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return dat;
    }

    static short[][] readArray(String filePath) {
        DataInputStream dis = Tools.openFile(filePath);
        try {
            if (dis == null) {
                dis.close();
                return null;
            }
            int p0 = dis.readByte();
            int p1 = dis.readByte();
            short[][] temp = new short[p0][p1];
            int i2 = 0;
            while (i2 < p0) {
                int j2 = 0;
                while (j2 < p1) {
                    temp[i2][j2] = dis.readShort();
                    ++j2;
                }
                ++i2;
            }
            dis.close();
            return temp;
        }
        catch (IOException ex) {
            return null;
        }
    }

    static byte[][] readExFrameData(DataInputStream is) {
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i2 = 0;
            while (i2 < len) {
                int gLen = (is.readByte() - 4) * 6 + 4;
                frame[i2] = new byte[gLen];
                int j2 = 0;
                while (j2 < gLen) {
                    frame[i2][j2] = is.readByte();
                    ++j2;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return frame;
    }

    static short[][][][] readFrameScript(DataInputStream dis) {
        try {
            char flag = dis.readChar();
            if (flag != 'A') {
                System.out.println("\u9519\u8bef\u7684\u6570\u636e\u683c\u5f0f");
                return null;
            }
            short baseX = dis.readShort();
            short baseY = dis.readShort();
            short baseW = dis.readShort();
            short baseH = dis.readShort();
            tempArea = new short[4][4];
            int i2 = 0;
            while (i2 < tempArea.length) {
                int j2 = 0;
                while (j2 < tempArea[i2].length) {
                    Data.tempArea[i2][j2] = dis.readShort();
                    ++j2;
                }
                short[] sArray = tempArea[i2];
                sArray[0] = (short)(sArray[0] - baseX);
                short[] sArray2 = tempArea[i2];
                sArray2[1] = (short)(sArray2[1] - (baseY - tempArea[i2][3]));
                ++i2;
            }
            int motionLen = dis.readByte();
            short[][][][] fs = new short[30][][][];
            int i3 = 0;
            while (i3 < motionLen) {
                byte st = dis.readByte();
                int zs = dis.readByte();
                fs[st] = new short[zs][][];
                int j3 = 0;
                while (j3 < zs) {
                    int scriptLen = dis.readShort();
                    if (scriptLen != 0) {
                        fs[st][j3] = new short[scriptLen][];
                        int k2 = 0;
                        while (k2 < scriptLen) {
                            int paramLen = dis.readShort();
                            fs[st][j3][k2] = new short[paramLen];
                            int m2 = 0;
                            while (m2 < paramLen) {
                                int temp = dis.readShort();
                                fs[st][j3][k2][m2] = (short)(m2 == 0 ? temp : Variable.getInt((short)temp));
                                ++m2;
                            }
                            switch (fs[st][j3][k2][0]) {
                                case 0: 
                                case 1: 
                                case 2: {
                                    short[] sArray = fs[st][j3][k2];
                                    sArray[1] = (short)(sArray[1] - baseX);
                                    short[] sArray3 = fs[st][j3][k2];
                                    sArray3[2] = (short)(sArray3[2] - (baseY - fs[st][j3][k2][4]));
                                }
                            }
                            ++k2;
                        }
                    }
                    ++j3;
                }
                ++i3;
            }
            dis.readShort();
            dis.readShort();
            dis.readShort();
            return fs;
        }
        catch (Exception ex) {
            System.out.println("\u52a8\u4f5c\u811a\u672c\u8f7d\u5165\u9519\u8bef!");
            return null;
        }
    }

    public static int[] readIntArray(InputStream is, int len) {
        int[] intArray = new int[len];
        byte[] buff = new byte[len << 2];
        try {
            is.read(buff);
        }
        catch (Exception e2) {
            System.out.println("readIntArray err");
        }
        int i2 = 0;
        while (i2 < len) {
            intArray[i2] = buff[i2 * 4] << 24 | buff[i2 * 4 + 1] << 16 | buff[i2 * 4 + 2] << 8 | buff[i2 * 4 + 3];
            ++i2;
        }
        return intArray;
    }

    static {
        uiClipDat21 = new byte[][]{{0, 0, 60, 6}, {1, 6, 59, 4}, {1, 10, 59, 4}, {1, 14, 59, 4}, {1, 18, 59, 4}};
        value1Max = (byte)6;
        value2Max = (byte)5;
    }
}

